/**** readdir - subroutines to access directories
*
*	Programmer: Darron J Shaffer
*
*	Company:    SigmaSoft & Systems
*		    17000 Dallas Parkway, #207
*		    Dallas, Texas 75248
*
*	Date:	    July 3, 1987
*
*	Notes:	    Written under contract with William Adney for use
*		    in Heath Company MS-DOS course.
*
*		    This program is intended to compile under Microsoft C
*		    version 4.0.
*
*/

#define LINT_ARGS

#include    <dos.h>
#include    "dir.h"

static union REGS       registers;	    /* register image for dos calls */
static struct SREGS     segments;	    /* seg reg image for dos calls */
static char	        far *old_dta;	    /* old dta address for restore */

/**** open_dir - find first matching directory entry ****
*
*	0 is return on success, otherwise the error code generated
*	by DOS is returned.
*/

int	open_dir(filespec,buffer)
char	    *filespec;      /* filespec to search for */
FILE_INFO   *buffer;        /* where to return info on found files */
{
    /* save the old dta address & set the new one */

    segread(&segments);
    registers.h.ah = GETDTA;
    intdosx(&registers,&registers,&segments);	/* get the old dta address */
    FP_SEG(old_dta) = segments.es;
    FP_OFF(old_dta) = registers.x.bx;

    segread(&segments);                         /* get proper DS */
    registers.x.dx = (unsigned) buffer;         /* point at buffer */
    registers.h.ah = SETDTA;
    intdosx(&registers,&registers,&segments);	/* set the working dta */

    registers.h.ah = FINDFIRST;
    registers.x.dx = (short) filespec;
    registers.x.cx = 0x3f;		    /* look at all files */
    intdosx(&registers,&registers,&segments);	/* go search directory */
    return (int)( ( registers.x.cflag) ? registers.x.ax : 0 );
}

/**** find_next - get the next file in an ambiguous file reference
*
*	A call to this function must be preceded by a open_dir call.
*	0 is return on success, otherwise the error code generated
*	by DOS is returned.
*/

int  find_next()
{
    registers.h.ah = FINDNEXT;
    intdosx(&registers,&registers,&segments);
    return (int) ( (registers.x.cflag) ? registers.x.ax : 0 );
}

/**** close_dir - restore the previous dta
*/

void close_dir()
{
    /* restore the old dta */
    segread(&segments);
    registers.x.dx = FP_OFF(old_dta);
    segments.ds    = FP_SEG(old_dta);
    registers.h.ah = SETDTA;
    intdosx(&registers,&registers,&segments);	/* set the working dta */
}

