	Title	program to list a file in hex
	page	,132
include	macros.asm
;
;	Hexlist
;
;	Author: R. A. Metz		Date: 12/16/83
;
;	MODIFIED BY P. SWAYNE, HUG  19-JAN-85
;		PAUSES EVERY 16 LINES
;		ENDS AT FILE END, NOT ROUND-OFF
;		ADDRESS STARTS AT 100H FOR COM FILE
;
;	This program will list the file specified by the first
;	(and only) parameter in hex and ASCII, 16 bytes per line.
;	The DOS list control features are active:
;		control S to stop and start listing
;		control C to abort listing
;
;	Calling sequence:
;
;		A:HEXLIST filename
;
;	Where 'filename' is the name of the file to be hexlisted.
;	'filename' must be in the current directory of the current
;	disk or specified disk as MS-DOS 1.x type file I/O is
;	performed.
;
;
	prog_header	hexlist
	jmp	begin
;
address	dw	0
bcount	dw	0,0
recsz	dw	512
LASTLIN	DW	0
LINCNT	DB	16
;
cr	equ	0dh
lf	equ	0ah
;
opn_err	db	cr,lf
	db	'File open error!$'
;
read_err	db	cr,lf
		db	'HEXLIST - File I/O error!$'
;
HITKEY	DB	'Type any key...$'
;
bgnlin	label   byte
adrbuf	db	0,0,0,0
	db	':  $'
sepmsg	db	'   *$'
;
crlf	db	cr,lf,'$'
;
begin:
	MOV	DX,OFFSET DONE
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C EXIT
	CMP	WORD PTR FCB1+9,'OC'	; COM FILE?
	JNZ	NOTCOM			; NO
	CMP	BYTE PTR FCB1+11,'M'
	JNZ	NOTCOM
	MOV	ADDRESS,100H		; ELSE, START AT 100H
NOTCOM:	set_dta	rec_buf
	open	fcb1
	cmp	al,0
	je	listinit
	display	opn_err
	sys_term 0
listinit:
	mov	fcb1+32,0
	mov	si,offset fcb1
	mov	ax,10h[si]
	mov	bcount,ax		; save file size
	mov	ax,12h[si]
	mov	bcount+2,ax
	mov	word ptr fcb1+0eh,512	; res size=512
;
readlp:
	cmp	bcount+2,0
	jne	usemax
	cmp	bcount,512
	jae	usemax
	mov	ax,bcount
	jmp	readrec
usemax:
	mov	ax,512
readrec:
	mov	recsz,ax
	read_seq	fcb1
	cmp	al,0
	je	read_ok
	cmp	al,3			; partial rec ok
	je	read_ok
	display read_err
	sys_term 0
read_ok:
	mov	cx,recsz
	shr	cx,1
	shr	cx,1
	shr	cx,1
	shr	cx,1
	mov	ax,recsz
	and	ax,15
	MOV	LASTLIN,16		; ASSUME FULL LAST LINE
	je	noxtra
	inc	cx   			; # 16-byte display lines in au
	MOV	LASTLIN,AX		; SAVE LAST LINE SIZE
noxtra:
	mov	si,offset rec_buf	; au buffer address
linlp:
	push	cx
	mov	ax,address
	mov	di,offset adrbuf
	call	cvthex
	display	bgnlin
	CMP	CX,1			; LAST LINE?
	mov	cx,16			; ASSUME NOT, 16 bytes/line
	JNZ	NOTLST
	MOV	CX,LASTLIN		; ELSE, GET LAST LINE SIZE
NOTLST:	PUSH	CX			; SAVE COUNT
chrlp:
	lodsb
	mov	ah,al
	call	cvtbyt
	mov	bx,ax
	mov	ah,2
	mov	dl,bl
	int	21h
	mov	ah,2
	mov	dl,bh
	int	21h
	mov	ah,2
	mov	dl,' '
	cmp	cx,9			; sep = '-' on 8th byte
	jne	sep
	mov	dl,'-'
sep:
	int	21h
	loop	chrlp
	POP	CX			; GET BYTE COUNT FOR LINE
	SUB	SI,CX			; BACK UP TO LINE START
	display	sepmsg
asclp:
	lodsb
	cmp	al,' '
	jae	hichk
	mov	al,'.'
hichk:
	cmp	al,7fh
	jb	prtit
	mov	al,'.'
prtit:
	display_chr	al
	loop	asclp
	display_chr	'*'
	display	crlf
;
	add	address,16
	DEC	LINCNT			; COUNT THIS LINE
	JNZ	NOT16			; NOT 16 LINES
	DISPLAY	HITKEY
	DIR_CONSOLE_IN			; WAIT FOR KEY
	CMP	AL,3			; CONTROL-C?
	JNZ	NOTCC			; NO
	JMP	DONE			; ELSE, QUIT
NOTCC:	DISPLAY	CRLF
	MOV	LINCNT,16		; RESET LINE COUNTER
NOT16:	pop	cx
	LOOP	LINLPJ
	JMP	ENDLN
LINLPJ:	JMP	LINLP
ENDLN:
	mov	ax,recsz
	clc
	sbb	bcount,ax
	sbb	bcount+2,0
	cmp	bcount+2,0
	jne	lpj
	cmp	bcount,0
	je	done
lpj:
	jmp	readlp
done:
	display	crlf
	sys_term 0
;
;
;	cvthex  -  convert binary to hex ascii
;
;	on entry  ax=value to convert
;		  di=buf addr (4-byte buffer)
;
cvthex	proc	near
	push	ax
	call	cvtbyt
	stosw
	pop	ax
	mov	ah,al
	call	cvtbyt
	stosw
	ret
cvthex	endp
;
cvtbyt	proc	near
	mov	al,ah
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	and	ax,0f0fh
	or	ax,3030h
	cmp	ah,39h
	jle	ckal
	add	ah,7
ckal:
	cmp	al,39h
	jle	cvtbret
	add	al,7
cvtbret:
	ret
cvtbyt	endp
;
rec_buf	label	byte
;
hexlist	ends
	end	start

                                                           