;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
	PAGE	,132
	TITLE	BDEV - BIOS devices

	.LFCOND
	.TFCOND		; Use the /X switch to cause FALSE conds not to list

;
;  BIOS device driver interface for MS-DOS 2.0
;

	INCLUDE	PARMS.ASM
	INCLUDE	DEFDOSI.ASM

    IF LISTI
	IF1
	%OUT	*Full listing being generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF

	.XLIST
    ENDIF

	INCLUDE	DEFDSK.ASM
	INCLUDE	DEFDEV.ASM
	INCLUDE	MACLIB.ASM

	.LIST
	PAGE

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	PUBLIC	BIOS_DEVS
	PUBLIC	EXIT_SUCC
	PUBLIC	EXIT_BUS
	PUBLIC	EXIT_ERR
	PUBLIC	PTRSAV

	EXTRN	RECURLV:WORD
	EXTRN	SAVESS:WORD
	EXTRN	SAVESP:WORD
	EXTRN	BIOS_STACK:BYTE

	EXTRN	CON_INIT:NEAR
	EXTRN	CON_IN:NEAR
	EXTRN	CON_ICHK:NEAR
	EXTRN	CON_ISTAT:NEAR
	EXTRN	CON_IFL:NEAR
	EXTRN	CON_OUT:NEAR
	EXTRN	CON_OSTAT:NEAR
	EXTRN	CON_OFL:NEAR

	EXTRN	AUX_IN:NEAR
	EXTRN	AUX_ICHK:NEAR
	EXTRN	AUX_ISTAT:NEAR
	EXTRN	AUX_IFL:NEAR
	EXTRN	AUX_OUT:NEAR
	EXTRN	AUX_OSTAT:NEAR
	EXTRN	AUX_OFL:NEAR

	EXTRN	PRN_IN:NEAR
	EXTRN	PRN_ICHK:NEAR
	EXTRN	PRN_ISTAT:NEAR
	EXTRN	PRN_IFL:NEAR
	EXTRN	PRN_OUT:NEAR
	EXTRN	PRN_OSTAT:NEAR
	EXTRN	PRN_OFL:NEAR

	EXTRN	TIM_IN:NEAR
	EXTRN	TIM_OUT:NEAR

	EXTRN	DSK0_INIT:NEAR
	EXTRN	DSK0_MCHK:NEAR
	EXTRN	DSK0_BPB:NEAR
	EXTRN	DSK0_IN:NEAR
	EXTRN	DSK0_OUT:NEAR
	EXTRN	DSK0_OUTV:NEAR

	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

BIOS_DEVS LABEL	BYTE
DVH_CON	LABEL	NEAR
	ERRNZ	DVH_CON,DVH_OFF
	DW	OFFSET DVH_AUX
	ERRNZ	DVH_CON,DVH_SEG
	DW	SEG BIOS_SEG
	ERRNZ	DVH_CON,DVH_ATTR
	DW	DVHA_CHR OR DVHA_STI OR DVHA_STO OR DVHA_SPC
	ERRNZ	DVH_CON,DVH_STRAT
	DW	OFFSET STRATEGY
	ERRNZ	DVH_CON,DVH_INTR
	DW	OFFSET INTR_CON
	ERRNZ	DVH_CON,DVH_NAME
	DB	"CON     "
	ERRNZ	DVH_CON,<SIZE DVH_STRUC>
     		
DVH_AUX	LABEL	NEAR
	ERRNZ	DVH_AUX,DVH_OFF
	DW	OFFSET DVH_PRN
	ERRNZ	DVH_AUX,DVH_SEG
	DW	SEG BIOS_SEG
	ERRNZ	DVH_AUX,DVH_ATTR
	DW	DVHA_CHR
	ERRNZ	DVH_AUX,DVH_STRAT
	DW	OFFSET STRATEGY
	ERRNZ	DVH_AUX,DVH_INTR
	DW	OFFSET INTR_AUX
	ERRNZ	DVH_AUX,DVH_NAME
	DB	"AUX     "
	ERRNZ	DVH_AUX,<SIZE DVH_STRUC>

DVH_PRN	LABEL	NEAR
	ERRNZ	DVH_PRN,DVH_OFF
	DW	OFFSET DVH_TIM
	ERRNZ	DVH_PRN,DVH_SEG
	DW	SEG BIOS_SEG
	ERRNZ	DVH_PRN,DVH_ATTR
	DW	DVHA_CHR
	ERRNZ	DVH_PRN,DVH_STRAT
	DW	OFFSET STRATEGY
	ERRNZ	DVH_PRN,DVH_INTR
	DW	OFFSET INTR_PRN
	ERRNZ	DVH_PRN,DVH_NAME
	DB	"PRN     "
	ERRNZ	DVH_PRN,<SIZE DVH_STRUC>

DVH_TIM	LABEL	NEAR
	ERRNZ	DVH_TIM,DVH_OFF
	DW	OFFSET DVH_DSK0
	ERRNZ	DVH_TIM,DVH_SEG
	DW	SEG BIOS_SEG
	ERRNZ	DVH_TIM,DVH_ATTR
	DW	DVHA_CHR OR DVHA_CLK
	ERRNZ	DVH_TIM,DVH_STRAT
	DW	OFFSET STRATEGY
	ERRNZ	DVH_TIM,DVH_INTR
	DW	OFFSET INTR_TIM
	ERRNZ	DVH_TIM,DVH_NAME
	DB	"CLOCK$  "
	ERRNZ	DVH_TIM,<SIZE DVH_STRUC>

DVH_DSK0 LABEL	NEAR
	ERRNZ	DVH_DSK0,DVH_OFF
	DW	-1
	ERRNZ	DVH_DSK0,DVH_SEG
	DW	SEG BIOS_SEG
	ERRNZ	DVH_DSK0,DVH_ATTR
	DW	0				;DVHA_IBM later
	ERRNZ	DVH_DSK0,DVH_STRAT
	DW	OFFSET STRATEGY
	ERRNZ	DVH_DSK0,DVH_INTR
	DW	OFFSET INTR_DSK0
	ERRNZ	DVH_DSK0,DVH_NAME
	DB	MAXDSKW,"Z-2?7  "
	ERRNZ	DVH_DSK0,<SIZE DVH_STRUC>

CONTBL	LABEL	NEAR
	ERRNZ	CONTBL,SRHC_INIT
	DW	CON_INIT	; Initialization
	ERRNZ	CONTBL,SRHC_MCHK*2
	DW	EXIT_SUCC	; Media check 
	ERRNZ	CONTBL,SRHC_BPB*2
	DW	EXIT_SUCC	; Build BPB 
	ERRNZ	CONTBL,SRHC_ICTL*2
	DW	EXIT_SUCC	; IOCTL input
	ERRNZ	CONTBL,SRHC_IN*2
	DW	CON_IN		; Input
	ERRNZ	CONTBL,SRHC_ICHK*2
	DW	CON_ICHK	; Non-destructive input no wait 
	ERRNZ	CONTBL,SRHC_ISTAT*2
	DW	CON_ISTAT	; Input status 
	ERRNZ	CONTBL,SRHC_IFL*2
	DW	CON_IFL		; Input flush 
	ERRNZ	CONTBL,SRHC_OUT*2
	DW	CON_OUT		; Output
	ERRNZ	CONTBL,SRHC_OUTV*2
	DW	CON_OUT		; Output (write) with verify
	ERRNZ	CONTBL,SRHC_OSTAT*2
	DW	CON_OSTAT	; Output status 
	ERRNZ	CONTBL,SRHC_OFL*2
	DW	CON_OFL		; Output flush 
	ERRNZ	CONTBL,SRHC_OCTL*2
	DW	EXIT_SUCC	; IOCTL output
	ERRNZ	CONTBL,(SRHC_MAX+1)*2

AUXTBL	LABEL	NEAR
	ERRNZ	AUXTBL,SRHC_INIT
	DW	EXIT_SUCC	; Initialization
	ERRNZ	AUXTBL,SRHC_MCHK*2
	DW	EXIT_SUCC	; Media check 
	ERRNZ	AUXTBL,SRHC_BPB*2
	DW	EXIT_SUCC	; Build BPB 
	ERRNZ	AUXTBL,SRHC_ICTL*2
	DW	EXIT_SUCC	; IOCTL input
	ERRNZ	AUXTBL,SRHC_IN*2
	DW	AUX_IN		; Input
	ERRNZ	AUXTBL,SRHC_ICHK*2
	DW	AUX_ICHK	; Non-destructive input no wait 
	ERRNZ	AUXTBL,SRHC_ISTAT*2
	DW	AUX_ISTAT	; Input status 
	ERRNZ	AUXTBL,SRHC_IFL*2
	DW	AUX_IFL		; Input flush 
	ERRNZ	AUXTBL,SRHC_OUT*2
	DW	AUX_OUT		; Output
	ERRNZ	AUXTBL,SRHC_OUTV*2
	DW	AUX_OUT		; Output (write) with verify
	ERRNZ	AUXTBL,SRHC_OSTAT*2
	DW	AUX_OSTAT 	; Output status 
	ERRNZ	AUXTBL,SRHC_OFL*2
	DW	AUX_OFL		; Output flush 
	ERRNZ	AUXTBL,SRHC_OCTL*2
	DW	EXIT_SUCC	; IOCTL output
	ERRNZ	AUXTBL,(SRHC_MAX+1)*2

PRNTBL	LABEL	NEAR
	ERRNZ	PRNTBL,SRHC_INIT
	DW	EXIT_SUCC	; Initialization
	ERRNZ	PRNTBL,SRHC_MCHK*2
	DW	EXIT_SUCC	; Media check 
	ERRNZ	PRNTBL,SRHC_BPB*2
	DW	EXIT_SUCC	; Build BPB 
	ERRNZ	PRNTBL,SRHC_ICTL*2
	DW	EXIT_SUCC	; IOCTL input
	ERRNZ	PRNTBL,SRHC_IN*2
	DW	PRN_IN		; Input
	ERRNZ	PRNTBL,SRHC_ICHK*2
	DW	PRN_ICHK	; Non-destructive input no wait 
	ERRNZ	PRNTBL,SRHC_ISTAT*2
	DW	PRN_ISTAT	; Input status 
	ERRNZ	PRNTBL,SRHC_IFL*2
	DW	PRN_IFL		; Input flush 
	ERRNZ	PRNTBL,SRHC_OUT*2
	DW	PRN_OUT		; Output
	ERRNZ	PRNTBL,SRHC_OUTV*2
	DW	PRN_OUT		; Output (write) with verify
	ERRNZ	PRNTBL,SRHC_OSTAT*2
	DW	PRN_OSTAT	; Output status 
	ERRNZ	PRNTBL,SRHC_OFL*2
	DW	PRN_OFL		; Output flush 
	ERRNZ	PRNTBL,SRHC_OCTL*2
	DW	EXIT_SUCC	; IOCTL output
	ERRNZ	PRNTBL,(SRHC_MAX+1)*2

TIMTBL	LABEL	NEAR
	ERRNZ	TIMTBL,SRHC_INIT
	DW	EXIT_SUCC	; Initialization
	ERRNZ	TIMTBL,SRHC_MCHK*2
	DW	EXIT_SUCC	; Media check 
	ERRNZ	TIMTBL,SRHC_BPB*2
	DW	EXIT_SUCC	; Build BPB 
	ERRNZ	TIMTBL,SRHC_ICTL*2
	DW	EXIT_SUCC	; IOCTL input
	ERRNZ	TIMTBL,SRHC_IN*2
	DW	TIM_IN		; Input
	ERRNZ	TIMTBL,SRHC_ICHK*2
	DW	EXIT_BUS	; Non-destructive input no wait 
	ERRNZ	TIMTBL,SRHC_ISTAT*2
	DW	EXIT_SUCC	; Input status 
	ERRNZ	TIMTBL,SRHC_IFL*2
	DW	EXIT_SUCC	; Input flush 
	ERRNZ	TIMTBL,SRHC_OUT*2
	DW	TIM_OUT		; Output
	ERRNZ	TIMTBL,SRHC_OUTV*2
	DW	TIM_OUT		; Output (write) with verify
	ERRNZ	TIMTBL,SRHC_OSTAT*2
	DW	EXIT_SUCC	; Output status 
	ERRNZ	TIMTBL,SRHC_OFL*2
	DW	EXIT_SUCC	; Output flush 
	ERRNZ	TIMTBL,SRHC_OCTL*2
	DW	EXIT_SUCC	; IOCTL output
	ERRNZ	TIMTBL,(SRHC_MAX+1)*2

DSK0TBL	LABEL	NEAR
	ERRNZ	DSK0TBL,SRHC_INIT
	DW	DSK0_INIT 	; Initialization
	ERRNZ	DSK0TBL,SRHC_MCHK*2
	DW	DSK0_MCHK 	; Media check 
	ERRNZ	DSK0TBL,SRHC_BPB*2
	DW	DSK0_BPB 	; Build BPB 
	ERRNZ	DSK0TBL,SRHC_ICTL*2
	DW	EXIT_SUCC	; IOCTL input
	ERRNZ	DSK0TBL,SRHC_IN*2
	DW	DSK0_IN		; Input
	ERRNZ	DSK0TBL,SRHC_ICHK*2
	DW	EXIT_BUS 	; Non-destructive input no wait 
	ERRNZ	DSK0TBL,SRHC_ISTAT*2
	DW	EXIT_SUCC	; Input status 
	ERRNZ	DSK0TBL,SRHC_IFL*2
	DW	EXIT_SUCC	; Input flush 
	ERRNZ	DSK0TBL,SRHC_OUT*2
	DW	DSK0_OUT 	; Output
	ERRNZ	DSK0TBL,SRHC_OUTV*2
	DW	DSK0_OUTV 	; Output (write) with verify
	ERRNZ	DSK0TBL,SRHC_OSTAT*2
	DW	EXIT_SUCC	; Output status 
	ERRNZ	DSK0TBL,SRHC_OFL*2
	DW	EXIT_SUCC	; Output flush 
	ERRNZ	DSK0TBL,SRHC_OCTL*2
	DW	EXIT_SUCC	; IOCTL output
	ERRNZ	DSK0TBL,(SRHC_MAX+1)*2

STRATP	PROC	FAR

; Save the packet pointer

PTRSAV		DD ?		; Request packet pointer

STRATEGY:
	MOV	WORD PTR CS:PTRSAV,BX
	MOV	WORD PTR CS:PTRSAV+2,ES
	RET
STRATP	ENDP


; The "Interrupt" routines

; Get addr of dispatch table and join common code

INTRP	PROC	FAR

INTR_AUX:	
	PUSH	SI
	MOV	SI,OFFSET AUXTBL
	JMP	SHORT ENTRY


INTR_PRN:
	PUSH	SI
	MOV	SI,OFFSET PRNTBL
	JMP	SHORT ENTRY


INTR_TIM:
	PUSH	SI
	MOV	SI,OFFSET TIMTBL
	JMP	SHORT ENTRY


INTR_DSK0:
	PUSH	SI
	MOV	SI,OFFSET DSK0TBL
	JMP	SHORT ENTRY


INTR_CON:
	PUSH	SI
	MOV	SI,OFFSET CONTBL
;	JMP	SHORT ENTRY

; Common entry code

ENTRY:
	CLI			; Disable interrutps for a bit
	INC	CS:RECURLV	; Bump recursion level, first time through ?
	JNZ	ENTRY1		;   No, skip
	MOV	CS:SAVESP,SP	; Set up new stack
	MOV	CS:SAVESS,SS
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET BIOS_STACK
ENTRY1:
	STI			; Turn interrupts back on
	PUSH	AX		; Save regs
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	DS
	PUSH	ES
	CLD

; Check if command valid, and then dispatch to it

	LDS	BX,CS:PTRSAV	; Get packet addr
	MOV	CL,SRH_CMD[BX]	; Get command
	CMP	CL,SRHC_MAX	; Is command valid ?
	JA	CMDERR		;   No, show error
	XOR	CH,CH		; Clear upper half
	SHL	CX,1		; Make into word offset
	ADD	SI,CX		; Compute table entry
	JMP	WORD PTR CS:[SI] ; Dispatch to command


; Busy exit

EXIT_BUS:
	MOV	AH,SRHS_BUI OR SRHS_DON ; Mark busy and done
	JMP	SHORT EXIT1	; Join common code


; Command error exit

CMDERR:
	MOV	AL,SRHS_EUKC	; Get UNKNOWN CODE
;	JMP	SHORT EXIT_ERR	; Join common code


; Error exit

EXIT_ERR:
	MOV	AH,SRHS_ERR OR SRHS_DON ; Mark error and done
	JMP	SHORT EXIT1	; Join code


; Success exit	

EXIT_SUCC:
	MOV	AH,SRHS_DON	; Mark as done
;	JMP	SHORT EXIT1	; Join common code


; Common exit code

EXIT1:
	LDS	BX,CS:PTRSAV	; Get packet addr
	MOV	SRH_STAT[BX],AX ; Store status

	POP	ES		; Restore regs
	POP	DS
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX

	CLI			; Disable interrupts for a bit
	DEC	CS:RECURLV	; Dec recursion level, at bottom ?
	JNS	EXIT2		;   No, skip
	MOV	SS,CS:SAVESS	; Recover stack
	MOV	SP,CS:SAVESP
EXIT2:
	POP	SI
	STI			; Enable interrupts
	RET
INTRP	ENDP

BIOS_SEG	ENDS

	END

