;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Define the interrupt page offsets
;

IPAGE_SEG SEGMENT AT 0

	ORG	0
  INT_ZERO	LABEL DWORD

;  Hardware defined interrupts

	ORG	4*0
  INT_DIV	LABEL DWORD		; Divide error
	ORG	4*1
  INT_STEP	LABEL DWORD		; Single step
	ORG	4*2
  INT_NMI	LABEL DWORD		; Non-maskable interrupt
	ORG	4*3
  INT_BRK	LABEL DWORD		; Breakpoint
	ORG	4*4
  INT_OVFL	LABEL DWORD		; Overflow error
 
;	Print Screen Emulation

   INT_PRSCA	EQU 5			; Interrupt 5 for print screen

	ORG	4*INT_PRSCA
   INT_PRSC	LABEL DWORD		; Print screen

;  MS-DOS defined interrupts

	ORG	4*DOSI_TERM
  INT_TERM	LABEL DWORD		; Terminate program function
	ORG	4*DOSI_FUNC
  INT_FUNC	LABEL DWORD		; Perform function
	ORG	4*DOSI_TADDR
  INT_TADDR	LABEL DWORD		; Resume addr on program termination
	ORG	4*DOSI_CADDR
  INT_CADDR	LABEL DWORD		; ^C handler
	ORG	4*DOSI_FERADDR
  INT_FERADDR	LABEL DWORD		; Fatal error handler
	ORG	4*DOSI_ADREAD
  INT_ADREAD	LABEL DWORD		; Absolute disk read
	ORG	4*DOSI_ADWRITE
  INT_ADWRITE	LABEL DWORD		; Absolute disk write
	ORG	4*DOSI_TERMR
  INT_TERMR	LABEL DWORD		; Terminate but stay resident


; Master 8259A interrupt controller defined interrupts

	ORG	4*ZM8259AI
  INT_ZM8259A	LABEL DWORD		; Base of Master 8259A interrupts

	ORG	4*(ZM8259AI+ZINTEI)
  INT_EI	LABEL DWORD		; Parity or S-100 pin 98
	ORG	4*(ZM8259AI+ZINTPS)
  INT_PS	LABEL DWORD		; Processor swap
	ORG	4*(ZM8259AI+ZINTTIM)
  INT_TIM	LABEL DWORD		; Timer
	ORG	4*(ZM8259AI+ZINTSLV)
  INT_SLV	LABEL DWORD		; Slave 8259A
	ORG	4*(ZM8259AI+ZINTSA)
  INT_SA	LABEL DWORD		; Serial port A
	ORG	4*(ZM8259AI+ZINTSB)
  INT_SB	LABEL DWORD		; Serial port B
	ORG	4*(ZM8259AI+ZINTKD)
  INT_KD	LABEL DWORD		; Keyboard/Display/Light pen
	ORG	4*(ZM8259AI+ZINTPP)
  INT_PP	LABEL DWORD		; Parallel port


; Slave 8259A interrupt controller defined interrupts

	ORG	4*ZS8259AI
  INT_ZS8259A	LABEL DWORD		; Base of Slave 8259A interrupts

	ORG	4*(ZS8259AI+0)
  INT_SLV0	LABEL DWORD		; Slave line 0
	ORG	4*(ZS8259AI+1)
  INT_SLV1	LABEL DWORD		; Slave line 1
	ORG	4*(ZS8259AI+2)
  INT_SLV2	LABEL DWORD		; Slave line 2
	ORG	4*(ZS8259AI+3)
  INT_SLV3	LABEL DWORD		; Slave line 3
	ORG	4*(ZS8259AI+4)
  INT_SLV4	LABEL DWORD		; Slave line 4
	ORG	4*(ZS8259AI+5)
  INT_SLV5	LABEL DWORD		; Slave line 5
	ORG	4*(ZS8259AI+6)
  INT_SLV6	LABEL DWORD		; Slave line 6
	ORG	4*(ZS8259AI+7)
  INT_SLV7	LABEL DWORD		; Slave line 7

; BIOS generated software interrupts

;	NOTE: These routines should be accessed by placing the interrupt
;	routines address in ES:BX and the interrupt number (the one ending
;	in A, for example INT_UKBA or INT_UTMA) in the AH register. Then
;	place the proper function in the AL register and call BIOS_INTFUNC.
;	The functions are defined as:

BIF_SETINT	EQU	0			; Set interrupt
BIF_CLRINT	EQU	1			; Clear interrupt
BIF_MAXINT	EQU	2			; Limit value

	ORG	4*(BIOSAI+0)
INT_UKB		LABEL	DWORD			; User keyboard interrupt
INT_UKBA	EQU	BIOSAI+0

	ORG	4*(BIOSAI+1)
INT_UTM		LABEL	DWORD			; User timer interrupt
INT_UTMA	EQU	BIOSAI+1

	ORG	4*(BIOSAI+2)
INT_USAI	LABEL	DWORD			; Users serial A interrupts
INT_USAIA	EQU	BIOSAI+2

	ORG	4*(BIOSAI+3)
INT_USBI	LABEL	DWORD			; User serial B interrupt
INT_USBIA	EQU	BIOSAI+3

	ORG	4*(BIOSAI+4)
INT_ULP		LABEL	DWORD			; User light pen interrupt
INT_ULPA	EQU	BIOSAI+4

	ORG	4*(BIOSAI+5)
INT_UCRT	LABEL	DWORD			; User keyboard output
INT_UCRTA	EQU	BIOSAI+5

	ORG	4*(BIOSAI+6)
INT_USAO	LABEL	DWORD			; Serial A output
INT_USAOA	EQU	BIOSAI+6

	ORG	4*(BIOSAI+7)
INT_USBO	LABEL	DWORD			; Serial B output
INT_USBOA	EQU	BIOSAI+7

	ORG	4*(BIOSAI+8)
INT_EVN		LABEL	DWORD			; Event interrupt
INT_EVNA	EQU	BIOSAI+8

	ORG	4*(BIOSAI+9)
INT_NET		LABEL	DWORD			; RESERVED
INT_NETA	EQU	BIOSAI+9

	ORG	4*(BIOSAI+10)
INT_VSYN	LABEL	DWORD
INT_VSYNA	EQU	BIOSAI+10		; Vertical Sync

	ORG	4*(BIOSAI+11)
INT_ULPS	LABEL	DWORD
INT_ULPSA	EQU	BIOSAI+11		; Light pen support

INT_UMAX	EQU	BIOSAI+12		; Limit for interupts

IPAGE_SEG ENDS

