
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

	EXTRN	CHRFOD_SER:NEAR, CHRFOD_PAR:NEAR
	EXTRN	CHRFOS_SER:NEAR, CHRFOS_PAR:NEAR
	EXTRN	CHRFID_SER:NEAR, CHRFID_PAR:NEAR
	EXTRN	CHRFIS_SER:NEAR, CHRFIS_PAR:NEAR
	EXTRN	CHRCTI_SER:NEAR, CHRCTI_PAR:NEAR
	EXTRN	CHRCTS_SER:NEAR, CHRCTS_PAR:NEAR

	EXTRN	PMSG:NEAR
	EXTRN	SER_EXIST:BYTE

;	These are the output buffers for the PRN, AUX, and CON devices.
;	the first byte != 0 if a character is waiting, the second byte
;	is the character.

PRNBUF	DW	0		; PRN character buffer
AUXBUF	DW	0		; AUX character buffer
CONBUF	DW	0		; CON character buffer

;
; Character I/O routines
;

; Special keys recognized by the BIOS
;
; These are the key codes generated by the keyboard processor. The key codes
; can be modified to be any key code the user wants. Note however that the
; key code chosen will NOT be placed in the type-ahead buffer, and so will
; never get passed to the system (or ZBASIC or others). Some other key
; choices and their codes are:
;
;	Shift break	-	0EAH
;	Shift I LINE	-	0E4H
;	HELP		-	095H
;	Shift HELP	-	0D5H
;
; For an entire list of key codes, see the Z100 technical manual in the
; keyboard section.
;

SPECIAL_KEY		EQU 0AAH	; "BREAK" key - clear type ahead
PRINT_SCREEN_KEY	EQU 0E2H	; Shift F12, print screen key

;	Combinations of light pens/terminals have a latency when reporting
;	a light pen hit. Some of this is built into the hardware, and the
;	following value is an estimate, which is deducted from the value
;	obtained from the hardware, which compensates for this. Users with
;	non-standard terminals and light pens (no "standard" light pen is
;	yet spec'd) will have to adjust even further in software.
;
;	This is only in full character positions, so the closest we
;	can get is to within 1 character. The pixel adjustment is
;	left to the user, since it is felt that this is much less
;	critical than the full character adjustment

LPERROR	EQU	5		; 5 character positions off

;
; Data used by Character I/O routines
;


VIDEO_ROM	DB ?		; Value of video control bits seen by ROM
VIDEO_PGM	DB ?		; Value of video control bits seen by program

; Input queue for the Console

CQ_ZCON	LABEL	BYTE			; Input queue descriptor for console
	ERRNZ	CQ_ZCON,CQ_SADDR
	DW	OFFSET Q_ZCON 		; Addr of start of queue
	ERRNZ	CQ_ZCON,CQ_EADDR
	DW	(OFFSET Q_ZCON)+ZCON_IQS-1	; Addr of end of queue
	ERRNZ	CQ_ZCON,CQ_QSIZE
	DW	ZCON_IQS		; Size of queue
	ERRNZ	CQ_ZCON,CQ_ELMTS
	DW	0			; Current number of elements in queue
	ERRNZ	CQ_ZCON,CQ_STATUS
	DB	0			; Current error status
	ERRNZ	CQ_ZCON,CQ_FRONT
	DW	OFFSET Q_ZCON		; Addr of front element in queue
	ERRNZ	CQ_ZCON,CQ_REAR
	DW	(OFFSET Q_ZCON)+ZCON_IQS-1	; Addr of rear elem in queue
	ERRNZ	CQ_ZCON,CQ_SEGM
	DW	BIOS2_SEG		; Segment of queue
	ERRNZ	CQ_ZCON,CQ_SIZE



; Input queue for ZSERA 2661 USART


CQ_ZSERA LABEL	BYTE			; queue descriptor for ZSERA port
	ERRNZ	CQ_ZSERA,CQ_SADDR
	DW	OFFSET Q_ZSERA		; Addr of start of queue
	ERRNZ	CQ_ZSERA,CQ_EADDR
	DW	(OFFSET Q_ZSERA)+ZSERA_IQS-1 ; Addr of end of queue
	ERRNZ	CQ_ZSERA,CQ_QSIZE
	DW	ZSERA_IQS		; Size of queue
	ERRNZ	CQ_ZSERA,CQ_ELMTS
	DW	0			; Current number of elements in queue
	ERRNZ	CQ_ZSERA,CQ_STATUS
	DB	0			; Current error status
	ERRNZ	CQ_ZSERA,CQ_FRONT
	DW	OFFSET Q_ZSERA		; Addr of front element in queue
	ERRNZ	CQ_ZSERA,CQ_REAR
	DW	(OFFSET Q_ZSERA)+ZSERA_IQS-1 ; Addr of rear elem in queue
	ERRNZ	CQ_ZSERA,CQ_SEGM
	DW	0			; Segment of que
	ERRNZ	CQ_ZSERA,CQ_SIZE

; Input queue for ZSERB 2661 USART

CQ_ZSERB LABEL	BYTE			; queue descriptor for ZSERB port
	ERRNZ	CQ_ZSERB,CQ_SADDR
	DW	OFFSET Q_ZSERB		; Addr of start of queue
	ERRNZ	CQ_ZSERB,CQ_EADDR
	DW	(OFFSET Q_ZSERB)+ZSERB_IQS-1 ; Addr of end of queue
	ERRNZ	CQ_ZSERB,CQ_QSIZE
	DW	ZSERB_IQS		; Size of queue
	ERRNZ	CQ_ZSERB,CQ_ELMTS
	DW	0			; Current number of elements in queue
	ERRNZ	CQ_ZSERB,CQ_STATUS
	DB	0			; Current error status
	ERRNZ	CQ_ZSERB,CQ_FRONT
	DW	OFFSET Q_ZSERB		; Addr of front element in queue
	ERRNZ	CQ_ZSERB,CQ_REAR
	DW	(OFFSET Q_ZSERB)+ZSERB_IQS-1 ; Addr of rear elem in queue
	ERRNZ	CQ_ZSERB,CQ_SEGM
	DW	0			; Segment of que
	ERRNZ	CQ_ZSERB,CQ_SIZE

; Fake control table for CON: device

CID_CON LABEL	BYTE
CHRD_CON LABEL	BYTE
	DB	CID_SIZE DUP (0)


; Control table for the PRN: device

CID_PRN	LABEL	BYTE			; device control table for PRN:
	ERRNZ	CID_PRN,CID_CHRD
CHRD_PRN LABEL BYTE			;  Configuration table for PRN:
	ERRNZ	CHRD_PRN,CHRD_CLASS
	DB	CHRDCL_SER		; Serial printer
	ERRNZ	CHRD_PRN,CHRD_ATTR
	DB	0			; No special attributes
	ERRNZ	CHRD_PRN,CHRD_PORT
	DW	ZSERA			; First 2661
	ERRNZ	CHRD_PRN,CHRD_BAUD
	DB	BD480			; 4800 baud
	ERRNZ	CHRD_PRN,CHRD_HSHK
	DB	CHRDH_DCDH		; DCD Positive
	ERRNZ	CHRD_PRN,CHRD_BCTL
	DB	CHRDB_SB1+CHRDB_CL8	; 1 stop bit, no parity, 8 data bits
	ERRNZ	CHRD_PRN,CHRD_ECNT
	DB	0			; No ETX/ACK count
	ERRNZ	CHRD_PRN,CHRD_NCNT
	DB	0			; Don't send null's
	ERRNZ	CHRD_PRN,CHRD_NCHR
	DB	0			; Character to pad
	ERRNZ	CHRD_PRN,CHRD_RES
	DB	6 DUP (0)		; Reserved
	ERRNZ	CHRD_PRN,CHRD_SIZE
	DB	CID_SIZE-CHRD_SIZE DUP (0)
	ERRNZ	CID_PRN,CID_SIZE


; Control table for the AUX: device

CID_AUX	LABEL	BYTE			; device control table for AUX:
	ERRNZ	CID_AUX,CID_CHRD
CHRD_AUX LABEL BYTE			;  Configuration table for AUX:
	ERRNZ	CHRD_AUX,CHRD_CLASS
	DB	CHRDCL_SER		; Serial printer
	ERRNZ	CHRD_AUX,CHRD_ATTR
	DB	0			; No special attributes
	ERRNZ	CHRD_AUX,CHRD_PORT
	DW	ZSERB			; Second 2661
	ERRNZ	CHRD_AUX,CHRD_BAUD
	DB	BD960			; 9600 baud
	ERRNZ	CHRD_AUX,CHRD_HSHK
	DB	CHRDH_NO		; No handshake
	ERRNZ	CHRD_AUX,CHRD_BCTL
	DB	CHRDB_SB1+CHRDB_CL8	; 1 stop bit, no parity, 8 data bits
	ERRNZ	CHRD_AUX,CHRD_ECNT
	DB	0			; No ETX/ACK count
	ERRNZ	CHRD_AUX,CHRD_NCNT
	DB	0			; Don't send null's
	ERRNZ	CHRD_AUX,CHRD_NCHR
	DB	0			; No pad character
	ERRNZ	CHRD_AUX,CHRD_RES
	DB	6 DUP (0)		; Reserved
	ERRNZ	CHRD_AUX,CHRD_SIZE
	DB	CID_SIZE-CHRD_SIZE DUP (0)
	ERRNZ	CID_AUX,CID_SIZE



TCID	DB CID_SIZE DUP(?) ; Temporary CID

ISR_SACC DB 0			; <>0 if DC1 seen, and no DC3 yet follows
ISR_SBCC DB 0			; <>0 if DC1 seen, and no DC3 yet follows


	PAGE
;
;  Q_STATUS - Queue status
;
;  Nondestructive read of a queue
;
;      Call with:
;          BX -> CQ(queue descriptor)
;
;      Returns:
;          DH = Queue size
;          DL = Number of elements in queue
;          Z set - AL = 0, no chars in queue
;          Z clear - AL = first char in queue
;
;  Assumes: No interrupt can occur which also touches queue
;

Q_STATUS PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_ELMTS[BX] ; Get number of elems in queue
	MOV	DX,SI		; Get element count
	MOV	DH,BYTE PTR CS:CQ_QSIZE[BX] ; Get size of queue
	XOR	AL,AL		; Assume no element in queue
	OR	SI,SI		; Was there any ?
	JZ	Q_SR		;   No, return
	MOV	SI,WORD PTR CS:CQ_FRONT[BX] ; Get addr of front element
	PUSH	ES
	PUSH	SI
	MOV	SI,WORD PTR CS:CQ_SEGM[BX]  ; Get segment
	MOV	ES,SI
	POP	SI

;	NOTE: Setting of direction on this instruction is not important!

	LODS	BYTE PTR ES:0	; Get element
	POP	ES
Q_SR:
	POP	SI		; Restore regs
	RET			;   and return
Q_STATUS ENDP

	PAGE
;
;  Q_FLUSH - Flush queue
;
;      Call with:
;          BX -> CQ(queue descriptor)
;
;  Assumes: No interrupt can occur which also touches queue
;

Q_FLUSH PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_SADDR[BX] ; Get start addr
	MOV	WORD PTR CS:CQ_FRONT[BX],SI ; Set front elem ptr
	MOV	SI,WORD PTR CS:CQ_EADDR[BX] ; Get end addr
	MOV	WORD PTR CS:CQ_REAR[BX],SI ; Set rear elem ptr
	MOV	WORD PTR CS:CQ_ELMTS[BX],0 ; Set number of elems to 0
	MOV	BYTE PTR CS:CQ_STATUS[BX],0 ; Clear errors
	POP	SI		; Recover regs
	RET			;   and return
Q_FLUSH ENDP


	PAGE
;
;  Q_GET - Get an element from a queue
;
;      Call with:
;          BX -> CQ(queue descriptor)
;
;      Returns:
;          Z set - queue empty
;          Z clear - AL = char removed from front of queue
;
;  Assumes: No interrupt can occcur which also touches queue
;

Q_GET	PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_ELMTS[BX] ; Get number of elems in queue
	OR	SI,SI		; Is queue empty ?
	JZ	Q_G2		;   Yes, skip
	DEC	SI		; Decr number of elemts
	MOV	WORD PTR CS:CQ_ELMTS[BX],SI ; Store updated count
	MOV	SI,WORD PTR CS:CQ_FRONT[BX] ; Get addr of front element
	PUSH	ES
	PUSH	SI
	MOV	SI,WORD PTR CS:CQ_SEGM[BX]  ; Get segment
	MOV	ES,SI
	POP	SI
	PUSHF			; Save state of direction flags
	CLD			; Insure the direction flag is up
	LODS	BYTE PTR ES:0	; Get element
	POPF			; Restore flags
	POP	ES
	CMP	SI,WORD PTR CS:CQ_EADDR[BX] ; Should ptr be wrapped ?
	JNA	Q_G1		;   No, skip
	MOV	SI,WORD PTR CS:CQ_SADDR[BX] ; Wrap ptr
Q_G1:
	MOV	WORD PTR CS:CQ_FRONT[BX],SI ; Store updated ptr
	OR	SI,-1		; Force the zero flag off
Q_G2:
	POP	SI		; Restore regs
	RET			;   and return
Q_GET	ENDP

	PAGE
;
;  Q_PUT - Put an element in a queue
;      Call with:
;          AL = character to put in queue
;          BX -> CQ(queue descriptor)
;
;      Returns:
;          CY clear - no error
;          CY set - no room in queue to put element
;
;  Assumes: No interrupt can occur which also touches queue
;

Q_PUT	PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_ELMTS[BX] ; Get number currently in queue
	CMP	SI,WORD PTR CS:CQ_QSIZE[BX] ; Is there room for another ?
	JB	Q_P1		;   Yes, skip
	STC			;   No, show error
	POP	SI		; Recover regs
	RET			;   and return
Q_P1: 
	INC	SI		; Bump element count
	MOV	WORD PTR CS:CQ_ELMTS[BX],SI ; Store updated count
	MOV	SI,WORD PTR CS:CQ_REAR[BX] ; Get rear ptr
	INC	SI		; Bump it
	CMP	SI,WORD PTR CS:CQ_EADDR[BX] ; Should it be wrapped
	JNA	Q_P2		;   No, skip
	MOV	SI,WORD PTR CS:CQ_SADDR[BX] ; Wrap ptr
Q_P2:
	PUSH	ES
	PUSH	SI
	MOV	SI,WORD PTR CS:CQ_SEGM[BX]  ; Get segment
	MOV	ES,SI
	POP	SI
	MOV	BYTE PTR ES:[SI],AL	; Get element
	POP	ES
	MOV	WORD PTR CS:CQ_REAR[BX],SI ; Store updated ptr
	CLC			; Clear CY to show success
	POP	SI		; Recover regs
	RET			;   and return
Q_PUT	ENDP

	PAGE
;
;  BIOS_AUXFUNC - Perform a AUX: related function
;
;      Call with:
;          AH = function to perform
;
;            AH = CHR_WRITE - Write character function
;            AH = CHR_READ - Read character function
;            AH = CHR_STATUS - Status function(may need ES:BX)
;            AH = CHR_CONTROL - Control function(may need ES:BX)
;            AH = CHR_LOOK - Nondestructive read function
;
;      Returns:
;          CY = 0 - function executed normally
;          CY = 1 - function returns error code in AX
;
;      Uses: BX, DX, DI, and SI
;

BIOS_AUXFUNC:
	MOV	SI,OFFSET CID_AUX ; Get internal printer control table addr
	JMP	NEAR PTR CHRFUNC ; Join common code


;
;  BIOS_PRNFUNC - Perform a PRN related function
;
;      Call with:
;          AH = function to perform
;
;            AH = CHR_WRITE - Write character function
;            AH = CHR_READ - Read character function
;            AH = CHR_STATUS - Status function(may need ES:BX)
;            AH = CHR_CONTROL - Control function(may need ES:BX)
;            AH = CHR_LOOK - Nondestructive read function
;
;      Returns:
;          CY = 0 - function executed normally
;          CY = 1 - function returns error code in AX
;
;      Uses: BX, DX, DI, and SI
;

BIOS_PRNFUNC:
	MOV	SI,OFFSET CID_PRN ; Get internal aux control table addr
	JMP	NEAR PTR CHRFUNC ; Join common code


	PAGE
;
;  CHRFUNC - Perform a character device related function
;
;      Call with:
;          SI -> internal control table (CID)
;          AH = function to perform
;
;            AH = CHR_WRITE - Write character function
;            AH = CHR_READ - Read character function
;            AH = CHR_STATUS - Status function(may need ES:BX)
;            AH = CHR_CONTROL - Control function(may need ES:BX)
;            AH = CHR_LOOK - Nondestructive read function
;
;      Returns:
;          CY = 0 - function executed normally
;          CY = 1 - function returns error code in AX
;
;      Uses: BX, DX, DI, and SI
;

CHRFUNC PROC FAR
	CMP	AH,CHR_FMAX	; Is function code valid ?
	JNA	CF1		;     Yes, skip
	MOV	AX,CHRE_ILGFH	;     No, get ILLEGAL FUNCTION error code
	STC			; Show error by setting CY
	RET			;   and return

CF1:
	PUSH	DS		; Save DS
	PUSH	CS		; Setup new DS
	POP	DS
	MOV	DI,AX		; Save AX
	MOV	AL,AH		; Put function in lower part
	XOR	AH,AH		; Clear upper part
	SHL	AX,1		; Make into word offset
	XCHG	AX,DI		; Restore AX and make offset available
	CALL	WORD PTR CHRFC[DI] ; Case to function
	POP	DS		; Recover DS
	RET			;   and return

CHRFUNC	ENDP

CHRFC:
	DW	OFFSET CHRFWR	; Write function
	DW	OFFSET CHRFRD	; Read function
	DW	OFFSET CHRFST	; Status function
	DW	OFFSET CHRFCT	; Control function
	DW	OFFSET CHRFLK	; Look function


	PAGE
;
; CHRFWR - Character device write function
;
;     Call with:
;         SI -> CID
;         AL = character to write
; 
;     Returns:
;         CY clear - char written
;         CY set - AX has error code
;
;     Uses: BX, DX, DI

CHRFWR	PROC	NEAR

; Normal output processing

	MOV	BX,AX			; Save char to write
	CALL	CHRFOS			; Get output status, any errors ?
	JNC	CHRFWR1			;   No, skip

;	See if CID = PRN and CHRBUF = 0

	MOV	DI,OFFSET PRNBUF
	CMP	SI,OFFSET CID_PRN	; PRN device?
	JZ	CHRFWR0Z2		; Yes
	MOV	DI,OFFSET AUXBUF
	CMP	SI,OFFSET CID_AUX	; AUX device?
	JZ	CHRFWR0Z2		; Yes
;	MOV	DI,OFFSET CONBUF	; Nope, must be CON
CHRFWR0Z2:
	CMP	CS:BYTE PTR [DI],0
	MOV	AX,CHRE_WRB
	STC
	JNZ	CHRFWR0Z1		; Yep, can't buffer it

;	Only 1 waiting, lets save it

	MOV	CS:BYTE PTR [DI+1],BL	; Set in the character
	MOV	CS:BYTE PTR [DI],-1	; Flag it as present
	CLC
CHRFWR0Z1:
	RET				; Yes, return error (CY already set)

CHRFWR1:
	MOV	AL,BL			; Recover char to write
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_SPO ; parity stripped ?
	JZ	CHRFWR2			;   No, skip
	AND	AL,07FH			; Strip the parity bit
CHRFWR2:
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_MLO ; lower case mapped
	JZ	CHRFWR3			;   No, skip
	CALL	UPCASE			; Convert char to upper case
CHRFWR3:
	MOV	DI,CID_CLASS[SI]	; Get device class
	CALL	WORD PTR CHRFODC[DI]	; Output character
	
	CMP	AL,CID_CHRD+CHRD_NCHR[SI] ; Should nulls be sent ?
	JNE	CHRFWR4			;   No, skip
	MOV	AL,CID_CHRD+CHRD_NCNT[SI] ;   get number of nulls to send
	MOV	CID_NCTR[SI],AL		; Store as down counter
CHRFWR4:
	MOV	AX,BX			; Recover AX
	CMP	BYTE PTR CID_CHRD+CHRD_HSHK[SI],CHRDH_EAH ; Using ETX/ACK ?
	JNE	CHRFWR6			;   No, skip
	MOV	BL,BYTE PTR CID_ECTR[SI] ; Get char count
	INC	BL			; Bump it
	CMP	AL,CC_ESC		; Is char an ESC ?
	JNE	CHRFWR5			;   No, skip
	MOV	BH,BYTE PTR CID_CHRD+CHRD_ECNT[SI] ; Get max count
	SUB	BH,3			; Allow for 3 char ESC sequences
	CMP	BL,BH			; Will it fit ?
	JNA	CHRFWR5			;   Yes, skip
	MOV	BL,BH			; No, use decrement count so it will
CHRFWR5:
	MOV	BYTE PTR CID_ECTR[SI],BL ; Store new count
CHRFWR6:  
	CLC				; Show success
	RET
CHRFWR	ENDP


	PAGE
;
; CHRFOS - Get character device output status
;
;     Call with:
;         SI -> CID
;         BL = possible char(only ESC's are significant when ETX/ACK'ing)
;
;     Returns:
;         CY clear - output device ready
;         CY set - AX has error code
;
;     Uses: AX, DI
;

CHRFOS	PROC	NEAR
	MOV	DI,CID_CLASS[SI] ; Get device class
	CMP	DI,CIDCL_SER	; Is it a serial device?
	JNZ	CHRFOS3E	; No, skip
	MOV	AX,CID_CHRD+CHRD_PORT[SI]	; Get port number
	CMP	AX,ZSERA	; Serial A port?
	JNZ	CHRFOS2E	; No, skip
	TEST	BYTE PTR SER_EXIST,0FFH	; Does it exist?
	JNZ	CHRFOS3E	; Yes, skip

CHRFOS_NOEXIST:
	CLC			; Show ready
	RET

CHRFOS2E:
	CMP	AX,ZSERB
	JNZ	CHRFOS3E	; Not A or B, let it go through
	TEST	BYTE PTR SER_EXIST[1],0FFH	; Does port B exist?
	JZ	CHRFOS_NOEXIST		; No, return error	

CHRFOS3E:
	MOV	DI,OFFSET PRNBUF
	CMP	SI,OFFSET CID_PRN	; PRN device?
	JZ	CHRFOS1X		; Yep
	MOV	DI,OFFSET AUXBUF
	CMP	SI,OFFSET CID_AUX	; AUX?
	JZ	CHRFOS1X		; Yep
;	MOV	DI,OFFSET CONBUF	; Nope, must be CON
CHRFOS1X:
	CMP	CS:BYTE PTR [DI],0
	JNZ	CHRFOS2X		; If char waiting, busy

	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFOSC[DI] ; Get status from device(returned in AL)
	AND	AL,CID_ORM[SI]	; Issolate ready/busy bits in status
	XOR	AL,CID_OPM[SI]	; Adjust for polarity
	CMP	AL,CID_ORM[SI]	; Is device busy(not ready) ?
	JE	CHRFOS1		;   No, skip
CHRFOS2X:
	MOV	AX,CHRE_WRB	;   Yes, get DEVICE BUSY error code
	STC			; Show failure
	RET			;   and return

CHRFOS1:
	CMP	BYTE PTR CID_CHRD+CHRD_HSHK[SI],CHRDH_EAH ; <ETX>/<ACK>
	JNE	CHRFOS5		;   No, skip

; Using <ETX>/<ACK> handshaking

	TEST	BYTE PTR CID_ST[SI],CHRS_WA ; Are we waiting for <ACK> ?
	JNZ	CHRFOS2		;   Yes, go to it
	
	MOV	AL,CID_ECTR[SI]	; Get character counter
	CMP	AL,CID_CHRD+CHRD_ECNT[SI] ; Is it equal to limit ?
	JNB	CHRFOS2A	;   Yes, skip
	JMP	CHRFOS12	;   No, skip to check for nulls
CHRFOS2A:
	MOV	BYTE PTR CID_ECTR[SI],0	; Reinitialize counter
	MOV	AL,CC_ETX	; Get <ETX> char
	CALL	WORD PTR CHRFODC[DI] ; Output character
	OR	BYTE PTR CID_ST[SI],CHRS_WA ; Show waiting for <ACK>
	MOV	AX,CHRE_WRB	; Get DEVICE BUSY error code
	STC			; Show failure
	RET			;   and return

; Waiting on <ACK>

CHRFOS2:
	CALL	CHRFIS		; Get input status, is char available ?
	JNC	CHRFOS3		;   Yes, skip
	RET			;   No, return error(CY already set)

CHRFOS3:
	CALL	WORD PTR CHRFIDC[DI] ; Read character
	AND	AL,07FH		; Strip parity
	CMP	AL,CC_ACK	; Is character an <ACK>
	JE	CHRFOS4		;   Yes, skip
	MOV	AX,CHRE_ILR	;   No, get ILLEGAL RESPONCE error message 
	STC			; Show failure
	RET			;   and return

CHRFOS4:
	AND	BYTE PTR CID_ST[SI],NOT CHRS_WA ; Clear wait flag
	JMP	CHRFOS12	; Go check on nulls


; Test for <DC1>/<DC3> handshaking

CHRFOS5:
	CMP	BYTE PTR CID_CHRD+CHRD_HSHK[SI],CHRDH_DCH ; <DC1>/<DC3>
	JE	CHRFOS6		;   Yes, skip
	JMP	CHRFOS12	;   No, go check on nulls

; Using <DC1>/<DC3> handshaking, See if DC1 seen, and no DC3 has followed

CHRFOS6:
	MOV	AL,BYTE PTR ISR_SACC	; Assume serial A
	CMP	WORD PTR [SI+CID_CHRD+CHRD_PORT],ZSERA
	JZ	CHRFOS7		; If that was it
	MOV	AL,BYTE PTR ISR_SBCC
	CMP	WORD PTR [SI+CID_CHRD+CHRD_PORT],ZSERB
	JZ	CHRFOS7
	JMP	SHORT CHRFOS8
CHRFOS7:
	OR	AL,AL
	JZ	CHRFOS12	; If = 0, no DC1 seen lately
CHRFOS8:
	MOV	AX,CHRE_WRB	; Get DEVICE BUSY error code
	STC			; Show failure
	RET			;   and return

; Check if a NULL should be written

CHRFOS12:
	CMP	BYTE PTR CID_NCTR[SI],0	; Any nulls need to be written ?
	JNE	CHRFOS13	;   Yes, skip
	CLC			;   No, show success	
	RET			; and return

CHRFOS13:
	DEC	BYTE PTR CID_NCTR[SI] ; Decr number of NULLS remaining
	MOV	AL,CC_NUL	; Get NULL char
	CALL	WORD PTR CHRFODC[DI] ; Output char
	MOV	AX,CHRE_WRB	; Show device busy
	STC			; Show failure
	RET			;  and return
CHRFOS	ENDP

	PAGE
;
; CHRFRD - Character device read function
;
;     Call with:
;         SI -> CID
; 
;     Returns:
;         CY clear - AL has char that was read
;         CY set - AX has error code
;
;     Uses: BX, DX, DI

CHRFRD	PROC NEAR
	MOV	BX,AX		; Save AX
	CALL	CHRFIS		; Get input status, any errors ?
	JNC	CHRFRD1		;   No, skip
	RET			;   Yes, return failure(CY already set)

CHRFRD1:
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFIDC[DI] ; Read a character
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_SPI ; parity stripped ?
	JZ	CHRFRD2		;   No, skip
	AND	AL,07FH		; Strip the parity bit
CHRFRD2:
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_MLI ; lower case mapped
	JZ	CHRFRD3		;   No, skip
	CALL	UPCASE		; Convert char to upper case
CHRFRD3:
	MOV	AH,BH		; Restore AH
	CLC			; Show success
	RET			;  and return
CHRFRD	ENDP

	PAGE
;
; CHRFIS - Get character device input status
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         CY clear - input device has char
;         CY set - AX has error code
;
;     Uses: AX, DI        
;

CHRFIS	PROC NEAR
	MOV	DI,CID_CLASS[SI] ; Get device class
	CMP	DI,CIDCL_SER	; Is it a serial device?
	JNZ	CHRFIS3		; No, skip
	MOV	AX,CID_CHRD+CHRD_PORT[SI]	; Get port number
	CMP	AX,ZSERA	; Serial A port?
	JNZ	CHRFIS2		; No, skip
	TEST	BYTE PTR SER_EXIST,0FFH	; Does it exist?
	JNZ	CHRFIS3		; Yes, skip

CHRFIS_NOEXIST:
	MOV	AX,CHRE_NRD	; Set error code for non-existant device
	STC			; Flag error
	RET

CHRFIS2:
	CMP	AX,ZSERB
	JNZ	CHRFIS3		; Not A or B, let it go through
	TEST	BYTE PTR SER_EXIST[1],0FFH	; Does port B exist?
	JZ	CHRFIS_NOEXIST		; No, return error	

CHRFIS3:
	CALL	WORD PTR CHRFISC[DI] ; Get status
	AND	AL,CID_IRM[SI]	; Issolate ready/busy bits
	XOR	AL,CID_IPM[SI]	; Adjust for polarity
	CMP	AL,CID_IRM[SI]	; Is character ready ?
	JNE	CHRFIS1		;   No, skip
	CLC			;   Yes, show success
	RET			; and return

CHRFIS1:
	MOV	AX,CHRE_RDNR	; Get READER NOT READY error code
	STC			; Show failure
	RET			;  and return
CHRFIS	ENDP



	PAGE
;
; CHRFLK - Nondestructive read (check if input queue is empty and
;          if not, then return a copy of the first element)
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         CY clear - AL = copy of first char in queue
;         CY set - AX has error code
;
;     Uses: AX, DI, BX
;

CHRFLK	PROC NEAR
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFGIQD[DI] ; Get queue descriptor addr
	JNC	CHRFLK1		;   Yes, skip
	MOV	AX,CHRE_NIQ	; Return "No input queue" error 
	RET

CHRFLK1:
	CALL	Q_STATUS	; Any chars in input queue ?
	JNZ	CHRFLK2		;   Yes, skip
	MOV	AX,CHRE_IQE	; Return "Input queue emptry" error
	STC			; Set CY to show error
CHRFLK2:
	RET			;   and return

CHRFLK	ENDP


	PAGE
;
; CHRFGIQD - Get input queue descriptor
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         CY clear - BX -> CQ (character queue descriptor)  
;         CY set - device has no input queue
;

CHRFGIQD PROC NEAR
	DW	OFFSET BAD	  ; Internal video/keyboard
	DW	OFFSET CHRFGI_SER ; 2661-2 ports
	DW	OFFSET CHRFGI_PAR ; PIA port


; 2661 serial ports

CHRFGI_SER:
	MOV	BX,CID_CHRD+CHRD_PORT[SI] ; Get base port
	CMP	BX,ZSERA	; Is it the serial A port ?
	JNE	CHRFGI_SER1	;   No, skip
	MOV	BX,OFFSET CQ_ZSERA ; Get addr of input queue desc
	CLC			; show success
	RET

CHRFGI_SER1:
	CMP	BX,ZSERB	; Is it the serial B port ?
	JNE	CHRFGI_SER2	;   No, skip
	MOV	BX,OFFSET CQ_ZSERB ; Get addr of input queue desc
	CLC			; show success
	RET

CHRFGI_SER2:
	STC			; Show failure
	RET


; PIA parallel port

CHRFGI_PAR:
	STC			; Show failure
	RET

CHRFGIQD ENDP

BAD:
	STC
	RET

	PAGE
;
; Raw Output data routines
;
;     Call with:
;         AL = char to write
;         SI -> CID
;
;     Uses: DX, AH
;

CHRFODC PROC NEAR
	DW	OFFSET BAD	;OFFSET CHRFOD_CRT ; Internal video/keyboard
	DW	OFFSET CHRFOD_SER ; 2661-2 ports		
	DW	OFFSET CHRFOD_PAR ; PIA port
CHRFODC ENDP

	PAGE
;
; Raw Output status routines
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         AL = device status
;
;     Uses: DX, AH 
;

CHRFOSC	PROC NEAR
	DW	OFFSET BAD	  ; Internal video/keyboard
	DW	OFFSET CHRFOS_SER ; 2661-2 ports		
	DW	OFFSET CHRFOS_PAR ; PIA port
CHRFOSC ENDP

CHRFIDC PROC NEAR
	DW	OFFSET BAD ; Internal video/keyboard
	DW	OFFSET CHRFID_SER ; 2661-2 ports		
	DW	OFFSET CHRFID_PAR ; PIA port
CHRFIDC ENDP


CHRFISC PROC NEAR
	DW	OFFSET BAD ; Internal video/keyboard
	DW	OFFSET CHRFIS_SER ; 2661-2 ports		
	DW	OFFSET CHRFIS_PAR ; PIA port


;	CHRFIS_SER returns here

CHRFIS_QS:
	CLI				; Disable interrupts
	MOV	AL,CQ_STATUS[BX]	; Get status
	OR	BYTE PTR CID_ST[SI],AL	; Propagate to CID
	CALL	Q_STATUS		; Is there a character in the queue?
	JZ	CHRFIS_QS1		; No, skip
	MOV	AL,0FFH			; Show not empty
CHRFIS_QS1:
	STI				; Turn interrupts back on
	POP	BX			; Restore regs
	RET

CHRFISC ENDP

	PAGE
;
; CHRFST - Get character device status function
;
;     Call with:
;         SI -> CID
;         AL = Subfunction
;
;           AL = CHR_SFGS - Get status 
;           AL = CHR_SFGC - Return configuration info to addr ES:BX
;
;     Returns:
;         CY clear -
;             CHR_SFGS - AH = synthesized status
;                        AL = raw status
;                        BH = input queue size
;                        BL = number of elements in queue
;             CHR_SFGC - Printer configuration is copied to addr ES:BX
;         CY set - AX has error code
;
;     Uses:  DX, DI
;

CHRFST	PROC NEAR
	CMP	AL,CHR_SFGS	; Is function, get status ?
	JNE	CHRFST1		;   No, skip

	MOV	DI,CID_CLASS[SI] ; Get device class
	XOR	BH,BH		; Clear status byte
	CALL	CHRFIS		; Get input status, errors ?
	JC	CHRFST0A	;   Yes, skip
	OR	BH,CHRS_RXR	;   No, show receiver has data
CHRFST0A:
	CALL	CHRFOS		; Get output status, errors ?	
	JC	CHRFST0B	;   Yes, skip
	OR	BH,CHRS_TXR	;   No, show transmitter ready
CHRFST0B:
	OR	BH,CID_ST[SI]	; Add other status bits
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFSTC[DI] ; Get raw status
	MOV	AL,AH		; Get raw status
	MOV	AH,BH		; Move synthesized status to proper reg
;???	put in other errors like parity and framing etc
	MOV	BX,DX		; Get queue stats
	CMP	BYTE PTR CID_NCTR[SI],0 ; Sending nulls ?
	JE	CHRFST0C	;   No, skip
	OR	AH,CHRS_SN	;   Yes, show it
CHRFST0C:
	CLC			; Show success
	RET			;  and return


CHRFSTC:
	DW	OFFSET BAD ; Same as input status
	DW	OFFSET CHRFIS_SER ; Same as input status
	DW	OFFSET CHRFOS_PAR ; Same as output status 



; Check if status is Get configuration info

CHRFST1:
	CMP	AL,CHR_SFGC	; Is subfunction get configuration info ?
	JE	CHRFST2		;    Yes, skip
	MOV	AX,CHRE_ILGFL	;    No, get error code
	STC			; Show error
	RET			;   and return

; Move device configuration info to caller

CHRFST2:
	LEA	SI,CID_CHRD[SI]	; Get source ptr
	MOV	DI,BX		; Get dest ptr
	PUSH	CX		; Save CX
	MOV	CX,CHRD_SIZE	; Get length of CHRD
	CLD			; Set direction	
	REP MOVSB		; Copy the CHRD
	POP	CX		; Recover CX
	CLC			; Show success
	RET			;   and return
CHRFST	ENDP


	PAGE
;
; CHRFCT - Character device control function
;
;     Call with:
;         SI -> CID
;         AL = Subfunction
;
;           AL = CHR_CFSU - Set up new configuration using parms at ES:BX
;           AL = CHR_CFCI - Clear input
;           AL = CHR_CFCO - Clear output
;
;     Returns:
;         CY clear - success
;         CY set - AX has error code
;
;     Uses: DI, DX

CHRFCT	PROC NEAR
	CMP	AL,CHR_CFSU	; Is function, set up new parms ?
	JE	CHRFCT0		;   Yes, skip
	JMP	CHRFCT1		;   No, to next check

CHRFCT0:

; Set up new configuration

	PUSH	CX		; Save CX
	PUSH	BX		; Save BX


; Clear temp CID to zero

	PUSH	SI		; Save some regs
	PUSH	ES
	PUSH	DS		; Set up ES
	POP	ES
	MOV	SI,OFFSET TCID	; Get source
	MOV	DI,OFFSET TCID+1 ; Get dest
	MOV	BYTE PTR TCID,0 ; Store zero in first byte
	MOV	CX,CID_SIZE-1	; Get count for smear
	CLD			; Set direction
	REP MOVSB		; Smear zero over CID

; Copy caller's CHRD into temp CID
;  (SI and ES on stack)

	MOV	SI,BX		; Get source offset
	POP	DS		; Get source segment
	MOV	DI,OFFSET TCID+CID_CHRD ; Get dest (segment already setup)
	MOV	CX,CHRD_SIZE	; Get size
	REP MOVSB		; Move caller's CHRD into temp CID

; Restore regs

	PUSH	DS		; Exchange DS and ES
	PUSH	ES
	POP	DS
	POP	ES
	POP	SI		; Recover SI

; Finish init of CID

	MOV	CL,TCID+CID_CHRD+CHRD_CLASS ; Get new device class
	CMP	CL,CHRDCL_MAX	; Is class valid ?
	JNA	CHRFCT0A	;   Yes, skip
	JMP	CHRCTS_BEX	;   No, skip to failure exit
CHRFCT0A:
	XOR	CH,CH		; Clear high part
	SHL	CX,1		; Convert to word ptr
	MOV	WORD PTR TCID+CID_CLASS,CX ; Store in temp CID
	MOV	DI,CX		; Make avail as index
	JMP	WORD PTR CHRFCTSC[DI] ; Case to class

CHRFCTSC:
	DW	OFFSET BAD
	DW	OFFSET CHRCTS_SER
	DW	OFFSET CHRCTS_PAR

CHRFCT 	ENDP


; Common success exit for set up

CHRCTS_GEX:

; Copy temp CID to CID at SI
	
	PUSH	SI		; Save SI for later
	MOV	DI,SI		; Set up DI, SI for move
	MOV	SI,OFFSET TCID
	PUSH	ES		; Save ES
	PUSH	DS		; Set up ES
	POP	ES
	MOV	CX,CID_SIZE	; Get size of CID
	CLD
	REP MOVSB		; Copy CID
	POP	ES		; Recover ES

	POP	SI		; Recover SI
	MOV	DI,CID_CLASS[SI] ; Get class
	CALL	WORD PTR CHRFCTIC[DI] ; Clear input queue

	POP	BX		; Recover BX
	POP	CX		; Recover CX
	CLC			; Show success
	RET			; And return


; Common failure exit for set up

CHRCTS_BEX:
	POP	BX		; Recover BX
	POP	CX		; Recover CX
	MOV	AX,CHRE_BSUP	; Get BAD SETUP error code
	STC			; Show failure
	RET			;  and return




; Check if subfunction is clear input

CHRFCT1:
	CMP	AL,CHR_CFCI	; Is function clear input ?
	JNE	CHRFCT2		;   No, skip

	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFCTIC[DI] ; Case to device
	RET			; And return

CHRFCTIC:
	DW	OFFSET BAD
 	DW	OFFSET CHRCTI_SER
	DW	OFFSET CHRCTI_PAR


CHRCTI_QF:
	CLI
	CALL	Q_FLUSH
	STI
	CLC
	POP	BX
	RET


; Check if subfunction is clear output

CHRFCT2:
	CMP	AL,CHR_CFCO	; Is subfunction clear output ?
	JE	CHRFCT3		;    Yes, go to it
	MOV	AX,CHRE_ILGFL	;    No, get error code
	STC			; Show failure
	RET			;  and return

CHRFCT3:
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFCTOC[DI] ; Case to device
	RET			; and return

CHRFCTOC:
	DW	OFFSET BAD
	DW	OFFSET CHRCTO_SER
	DW	OFFSET CHRCTO_PAR


; 2661-2 clear output
; PIA clear output

CHRCTO_SER:
CHRCTO_PAR:
	;
	; (Nothing to do)
	;
	CLC			; Show success
	RET			;   and return

 
;
; UPCASE - Convert character to uppper case
;
;     Call with:
;         AL - character to convert
;
;     Returns:
;         AL - converted char
;

UPCASE	PROC NEAR
	CMP	AL,'a'		; Is character less than an 'a' ?
	JB	UPCASE1		;   Yes, skip to end
	CMP	AL,'z'		; Is character greater than a 'z' ?
	JA	UPCASE1		;   Yes, skip to end
	AND	AL,05FH		;   No, convert to upper case
UPCASE1:
	RET
UPCASE	ENDP

;
;	NOTE: Users should exit from their routine by simply using
;	a JMPF to the next routine wanting interrupts (found at
;	0:int_uk). In this way, more than one routine can trap keyboard
;	keys. The use flag (in AH) is used to inform the bios that
;	the key code is special (if AH != 0) and should NOT be placed
;	in the queue, or is not special (if AH = 0) and should be
;	treated as a normal character.
;

ISR_UKB:
	CALL	KYB_IDT			; Go through INTFUNC tables
	IRET				; Return to BIOS
ISR_UCRT:
	CALL	CRT_IDT			; Go through INTFUNC tables
	IRET

;
;	ISR_USAI - Serial A interrupt routine
;	ISR_USAO - Serial A output routine
;
;	ENTRY, EXIT, USAGE, and NOTES from above apply
;

ISR_USAI:
	CALL	SAI_IDT
	IRET

ISR_USAO:
	CALL	SAO_IDT
	IRET

;
;	ISR_USBI - Serial B interrupt routine
;	ISR_USBO - Serial B output routine
;	ENTRY, EXIT, USAGE, and NOTES from above apply
;

ISR_USBI:
	CALL	SBI_IDT
	IRET

ISR_USBO:
	CALL	SBO_IDT
	IRET

;
;	ISR_ULP - Light Pen interrupt routine
;
;	ENTRY:
;		BX	=	Character address of hit
;				Address is (line * 80) + column
;
;		AL	=	Address within the character cell
;
;				76543210
;				****		-	Scan line hit
;				    *		-	Not used
;				     ***	-	pixel on scan line
;
;	EXIT:	NONE
;
;	USES:	NONE
;
;	See notes on interrupt handling above
;

ISR_ULP:
	CALL	LP_IDT
	IRET

;
;	ISR_PRSC - Print Screen Subroutine
;
;	Entry:	None
;
;	Exit:	None
;
;	Uses:	None
;

ISR_PRSC:
	IRET

;
;	ISR_UVSYN - Vertical Sync User Subroutine
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	None
;

ISR_UVSYN:
	CALL	VSY_IDT
	IRET

;
;	ISR_VSYN - Vertical Sync routine

VSYNC_PTR	DD	0		; ROM's ISR address

ISR_VSYN:
	INT	INT_UVSYNA		; Give user a chance at interrupt
	JMP	CS:DWORD PTR VSYNC_PTR	; Go to ROM routine


