	PAGE	,132
;	BIOS for the Z-100 side of the Z-150 computer
;
;
;	Supports 8x512 and 9x512 floppy disk formats
;
;	Supports 4 floppys and 4 fixed disk partitions
;
;	Author:	RJM
;	Z-100 mode: DAS
;	Date:	4/6/84
;	File:	BIOS.ASM
;

;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
	IF1
%OUT PASS 1 STARTED
	ELSE
%OUT PASS 2 STARTED
	ENDIF

	TITLE	MS-DOS 2.00 BIOS for the Z-150/Z-100 mode Computer
	SUBTTL	Common definitions

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFMTR.ASM
	INCLUDE PARMS.ASM
.LIST

	SUBTTL	BIOS jump table
	PAGE

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME CS:BIOS, DS:BIOS, SS:BIOS

	EXTRN	BIOS_INIT:NEAR
	EXTRN	BIOS_INTFUNC:NEAR
	EXTRN	BIOS_CONFUNC:NEAR
	EXTRN	BIOS_PRNFUNC:NEAR
	EXTRN	BIOS_AUXFUNC:NEAR
	EXTRN	BIOS_DSKFUNC:NEAR
	EXTRN	DSK_TPTR:BYTE
	EXTRN	CHRD_CON:BYTE
	EXTRN	CHRD_PRN:BYTE
	EXTRN	CHRD_AUX:BYTE
	EXTRN	BIOS_DATE:WORD
	EXTRN	CQ_ZSERA:BYTE
	EXTRN	CQ_ZSERB:BYTE
	EXTRN	CQ_ZCON:BYTE
	EXTRN	CON:NEAR
	

	PUBLIC	BIOS_START, BPB_9X2,    COM_BUF,     CONFIG_DATA, CONFIG_PTR
	PUBLIC	DATE,       DISK_MSG,   DOP_TYPE,    DOP_VERIFY,  DRIVE,   DSK_TIMOUT
	PUBLIC	FIRST_SEC,  FIXED_BPBS, FLOPPY_BPBS, IO_TABLES,   KB_BREAK
	PUBLIC	L_ERR,      NEW_DISK,   NUM_FLOPPY,  OLD_SP1,     OLD_SP2, ONE_DRIVE
	PUBLIC	PACKET,     PMSG,       PRINTER_MAX, RETRY_COUNT, SEC_CNT
	PUBLIC	SERIAL_MAX, SP_SAVE,    SS_SAVE,     STACK_TOP,   TIM_FLG
	PUBLIC	TIM_PTR,    TIM_TOD,    T_ERR,       NXT_CHAR,    FIXED_FLAGS
	PUBLIC	RECURLV,    SCT1,       TICVAL,      ISR_EVN,     EVN_FLG, BIOS_EXTRA
	PUBLIC	FNT_INFO,   FNT_RAM,    FNT_ROM,     FNT_SIZE,    FNT_MSIZE
	PUBLIC	DUMMY_IRET, INIT_BPB,	ASP_LPHFV,   ASP_LPHCAV,  ASP_LPHPAV
	PUBLIC	SER_EXIST

	ORG	0

BIOS_START LABEL NEAR

CONFIG_PTR	LABEL	WORD		; Pointer to configuration stuff after init.
	JMP	NEAR PTR BIOS_INIT	; Initialization code


;*	PBE_xxxx - Phony Bios Entry
;
;	These entry points are phony entries used simply to maintain
;	compatability with Z-DOS 1.25 programs, and to give extended
;	capabilities to Z-DOS programs like FORMAT and DSKCOPY
;

	EXTRN	PBE_STATUS:NEAR,PBE_CONIN:NEAR,PBE_CONOUT:NEAR
	EXTRN	PBE_PRINT:NEAR,PBE_AUXIN:NEAR,PBE_AUXOUT:NEAR
	EXTRN	PBE_READ:NEAR,PBE_WRITE:NEAR,PBE_DSKCHG:NEAR
	EXTRN	PBE_SETDATE:NEAR,PBE_SETTIME:NEAR,PBE_GETDATE:NEAR
	EXTRN	PBE_FLUSH:NEAR,PBE_MAPDEV:NEAR

	JMP	PBE_STATUS		; Console status
	JMP	PBE_CONIN		; Console input
	JMP	PBE_CONOUT		; Console output
	JMP	PBE_PRINT		; Printer output
	JMP	PBE_AUXIN		; AUX device input
	JMP	PBE_AUXOUT		; AUX device output
	JMP	PBE_READ		; Disk Read Routine
	JMP	PBE_WRITE		; Disk Write Routine
	JMP	PBE_DSKCHG		; Disk change
	JMP	PBE_SETDATE		; Date Set
	JMP	PBE_SETTIME		; Set time
	JMP	PBE_GETDATE		; Get date
	JMP	PBE_FLUSH		; Console flush
	JMP	PBE_MAPDEV		; Map device

	ORG	045H			; Reserved for other unused entries

	JMP	BIOS_INTFUNC		; Int installation
	JMP	BIOS_DSKFUNC		; Disk functions
	JMP	BIOS_PRNFUNC		; PRN functions
	JMP	BIOS_AUXFUNC		; AUX functions
	JMP	BIOS_CONFUNC		; CON functions

	ORG	60H

	DB	BIOS_CREL		; Release of the BIOS
	DW	OFFSET CONFG_INFO	; Address of Z-100 configuration info
	DB	BIOS2_CVER		; Version of BIOS


	SUBTTL	BIOS data definitions
	PAGE

;****************************************************************
;								*
;	Configuration data, used by the CONFIGUR,  program  and	*
;	other user setable variables used to configure the	*
;	hardware.						*
;								*
;****************************************************************
CONFIG_DATA	LABEL	BYTE
BIOS_VER DB	BIOS2_CVER		; Version of the BIOS

	DW	OFFSET IO_TABLES	; Address of ROM I/O tables

	DW	OFFSET FIXED_BPBS	; Offset of Partition BPB's
	DW	OFFSET FIXED_FLAGS	; Offset of partition flags

	DW	OFFSET BIOS_EXTRA	; Addr of internal BIOS info

;***********************************
;				   *
;	END OF CONFIGURATION TABLE *
;				   *
;***********************************


;************************************************************************
;									*
;	This is the configurable data pointed to by the configuration	*
;	table.								*
;									*
;************************************************************************


;	Fixed disk BPB's (Bios parameter blocks).
;	These are the fixed disk BPB's used
;	by the disk I/O code. They are initially set to the
;	maximum format that can be supported.

FIXED_BPBS	LABEL	BYTE
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0, 12, 17, 0, 0, 080H>
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0, 12, 17, 0, 0, 080H>
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0, 12, 17, 0, 0, 080H>
INIT_BPB	LABEL	BYTE
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0, 12, 17, 0, 0, 080H>

	ERRNZ	<(OFFSET $ - OFFSET FIXED_BPBS)/(TYPE BPB_STRUC)>,MAX_FIXED

;	Flags for assigned partitions
;	bit 0=0 - not assigned, bit 0=1 partition assigned
;	bit 1=0 - not formatted, bit 1=1 partition formatted
;	bit 2=0 - disk has not changed, bit 2=1 disk has changed
;	bits 3-7 reserved (undefined)
FIXED_FLAGS DB	MAX_FIXED DUP(0)


;*********************************************************
;	Default parallel and serial configuration tables *
;	used by the ROM					 *
;*********************************************************
IO_TABLES LABEL BYTE
PCT1	DB	0		; No remap, no case mapping or parity stripping
	DB	0		; Pad character
	DB	0		; No pad count
	DB	20		; Time out value

PCT2	DB	0
	DB	0
	DB	0
	DB	20

PCT3	DB	0
	DB	0
	DB	0
	DB	20

PRINTER_MAX = ($-PCT1)/PCT_SIZE


SCT1	DB	SCT_DEFAULT+SCT_DTR+SCT_RTS+SCT_DTR_POLAR+SCT_RTS_POLAR
				; Default handshake, compatibility mode
				; DTR and RTS, Hardware
	DB	0		; No attributes
	DB	0		; Pad character
	DB	0		; No pad count
	DB	0		; Flag for DC1/DC3 and ETX/ACK
	DB	0		; Count for ETX/ACK
	DB	101B SHL 5 + 00B SHL 3 + 0B SHL 2 + 11B	; 2400 baud,
				; No parity, 1 stop bit and 8 bit words
	DB	1		; Time out value

SCT2	DB	SCT_DEFAULT+SCT_DTR+SCT_RTS+SCT_DTR_POLAR+SCT_RTS_POLAR
				; Default handshake, compatibility mode
				; DTR and RTS, Hardware
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	101B SHL 5 + 00B SHL 3 + 0B SHL 2 + 11B
	DB	1

SERIAL_MAX = ($-SCT1)/SCT_SIZE

;**********************************************************
;							  *
;	End of configurable information pointed to by the *
;	configuration table.				  *
;							  *
;**********************************************************

;	Floppy disk BPB's. These are the floppy disk BPB's used
;	by the disk I/O code. They must be in order of the last
;	two bits of the associated media byte.

FLOPPY_BPBS	LABEL	BYTE
BPB_9X1	BPB_STRUC <512, 1, 1, 2,  64,   9*40, 0FCH, 2, 9, 1, 0, 0>
BPB_9X2	BPB_STRUC <512, 2, 1, 2, 112, 9*40*2, 0FDH, 2, 9, 2, 0, 0>
BPB_8X1	BPB_STRUC <512, 1, 1, 2,  64,   8*40, 0FEH, 1, 8, 1, 0, 0>
BPB_8X2	BPB_STRUC <512, 2, 1, 2, 112, 8*40*2, 0FFH, 1, 8, 2, 0, 0>

	ERRNZ	<(OFFSET $ - OFFSET FLOPPY_BPBS)/(TYPE BPB_STRUC)>,MAX_FLOPPY

	IF	D_2SEC

;
;	Floppy disk timeout tables.  These are used to store the current
;	timer values to determine when the drive was last accessed.

DSK_TIMOUT	LABEL	WORD
	DW	0
	DW	0
	DW	0
	DW	0

	ENDIF


;****************************
; Z-100 configuration table *
;****************************

CONFG_INFO:
	DW	OFFSET DSK_TPTR	; Address of disk table vector
	DW	OFFSET CHRD_PRN	; Address of PRN configuration table
	DW	OFFSET CHRD_AUX	; Address of AUX configuration table
	DW	OFFSET CHRD_CON	; Address of CON configuration table
	DW	OFFSET FNT_INFO ; Address of FONT information 
	DW	OFFSET BIOS_DATE ; Address of date and time fields
	DW	OFFSET CON	; Address of DOS disk table
	DW	OFFSET BIOS_MCL	; Address of memory control info
	DW	OFFSET BIOS_ASP	; Aspect ratio information
	DW	OFFSET CQ_ZCON	; Console queue pointer
	DW	OFFSET CQ_ZSERA	; Serial A queue pointer
	DW	OFFSET CQ_ZSERB	; Serial B queue pointer
	DW	OFFSET EVN_FLG	; Event flag
	DW	OFFSET TICVAL	; 16 bit tic counter
	DW	0		; Drive assignment table (not implemented)
	DW	-1

;	BIOS aspect and light pen info

BIOS_ASP	LABEL NEAR
		DB	ASP_X	; X aspect value
		DB	ASP_Y	; Y aspect value
ASP_LPEFV	DW	5	; Light pen error factor
ASP_LPHFV	DB	0	; Light pen hit flag
ASP_LPHCAV	DW	0	; Character of hit
ASP_LPHPAV	DB	0	; Pixel of hit
ASP_LPHCNT	DB	0	; =0 if pen is up
PRSC_IN_PROGRESS DB	0	; != 0 if prsc in progress
EVN_FLG		DW	0	; Event flag
TICVAL		DW	0	; 16 bit tic counter
GWBASIC		DB	0	; != if GWBASIC in ram

;***********************************
;* End of Z-100 configuration info *
;***********************************

BIOS_EXTRA:
	DB	14 DUP(0)	; Space for DPT, psc flag and last drive flag


FNT_INFO	LABEL	BYTE
FNT_RAM	DD	?		; Address of FONT in RAM
FNT_ROM	DD	?		; Address of FONT in ROM
FNT_SIZE DW	?		; Bytes in FONT in RAM
FNT_MSIZE DW	?		; Maximum bytes in FONT in RAM

BIOS_MCL	DB	0	; This is here in case someone tries to write to it

;**************************************
; Variables used by the disk I/O code *
;**************************************
RETRY_COUNT DB	?		; Location to keep retry count
ONE_DRIVE   DB	0		; One drive flag (1 = 1 drive system)
DRIVE	    DB	?		; Drive number for ROM
	IF	D_2SEC
TIM_PTR	    DW	?		; Pointer to timeout table of last access
	ENDIF
	IF	DT_STAMP
TIM_FLG	    DB	0FFH		; Flag for date/time stamp initialization
TIM_TOD     DD	?		; Current timer for date/time stamp
FIRST_SEC   DW	?		; First sector in I/O request
	ENDIF

NUM_FLOPPY DB	?		; Number of floppy drives in the system
DOP_TYPE   DB	?		; Disk operation type (ROM error code)
DOP_VERIFY DB	?		; Verify flag (1 = verify, 0 = no verify)
	ERRNZ	DOP_TYPE,<(DOP_VERIFY-1)>
SEC_CNT    DW	?		; Sector count
OLD_SP1	   DW	?		; Old stack pointer for error exit
OLD_SP2	   DW	?		; Old stack pointer for error exit
RECURLV	   DW	-1		; Recursion level

;	Error codes returned by the ROM

T_ERR	DB	80H, 40H, 20H, 10H, 09H, 08H, 04H, 03H, 02H, 01H
L_ERR	=	OFFSET $ - OFFSET T_ERR

;	Error codes to return to MS-DOS (1 to 1 map to the table above)

	DB	02H, 06H, 0CH, 04H, 0CH, 04H, 08H, 00H, 0CH, 0CH


;	Message for the imaginary drive on a one drive system
DISK_MSG LABEL	BYTE
	DB	'Place disk '
NEW_DISK DB	0
	DB	' in drive A:.', CC_CR, CC_LF
	DB	'Press any key when ready.', CC_CR, CC_LF+80H


NXT_CHAR DB	0		; Look ahead for special keys (0 = Nothing pending)

SER_EXIST	LABEL	BYTE	; Existance flags for serial ports
		DB	8 DUP(0)	; 8 possible ports

COM_BUF	DB	SERIAL_MAX DUP(0)	; Look ahead for serial ports
DATE	DW	?		; BIOS Date storage

;	Packet pointer for the DOS packet

PACKET	DD	?
SS_SAVE	DW	?		; Storage for saving the DOS stack
SP_SAVE	DW	?

;	BIOS local stack

	DW	128 DUP(?)
STACK_TOP LABEL WORD

	SUBTTL	Print to console routine
	PAGE


;**	This routine will print a message to the console
;
;	ENTRY:	DX = offset of message in code segment (end
;		     of message has high bit turned on)
;
;	EXIT:	None
;
;	USES:	DX, AL
;
PMSG	PROC	NEAR
	CLD
	XCHG	SI,DX		; Get address of message in index reg.
PMSG1:
	LODS	CS:NXT_CHAR	; Get CS overide on LODSB
	PUSH	AX
	AND	AL,7FH		; Strip high bit
	CALL	MTR_SCRT
	POP	AX
	TEST	AL,80H		; End?
	JZ	PMSG1
	XCHG	DX,SI
	RET

PMSG	ENDP


	SUBTTL	BIOS keyboard break function
	PAGE

;	On break interrupt put CTRL-C in look ahead buffer
;
KB_BREAK:
	MOV	BYTE PTR CS:NXT_CHAR,3

DUMMY_IRET:
	IRET



;*	ISR_EVN - Event interrupt
;
;	ISR_EVN is a service routine for the INT_EVNA interrupt
;
;	It returns AX as the event flag, then resets it to zero
;

ISR_EVN:
	MOV	AX,CS:WORD PTR EVN_FLG		; Event flag
	MOV	CS:WORD PTR EVN_FLG,0		; Reset it
	IRET


BIOS	ENDS
	END
