;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

;
; DEFCHR - Definitions for the character devices (CON, AUX, and PRN)
;


;  Define functions of BIOS_CONFUNC, BIOS_PRNFUNC, and BIOS_AUXFUNC

CHR_WRITE	= 0		; Write function
CHR_READ	= CHR_WRITE+1	; Read function
CHR_STATUS	= CHR_READ+1	; Status function
  CHR_SFGS	  = 0		  ; Get status subfunction
    CHRS_WA	    = 00000001B   ; <ETX> sent, waiting for <ACK>
    CHRS_WD	    = 00000010B   ; <DC3> seen, waiting for <DC1>
    CHRS_SN         = 00000100B   ; Sending nulls
    CHRS_TXR        = 10000000B   ; Transmitter ready to send data
    CHRS_RXR	    = 01000000B   ; Receiver has data	
    CHRS_RXOF	    = 00100000B   ; Receiver queue overflow
    CHRS_RXE	    = 00010000B   ; Other type of reciver error
    CHRS_TXE	    = 00001000B   ; Transmitter error
  CHR_SFGC	  = CHR_SFGS+1  ; Get configuration info subfunction
CHR_CONTROL	= CHR_STATUS+1 ; Control function
  CHR_CFSU	  = 0		  ; Setup new configuration parms subfunction
  CHR_CFCI	  = CHR_CFSU+1  ; Clear input subfunction
  CHR_CFCO	  = CHR_CFCI+1  ; Clear output subfunction
CHR_LOOK	= CHR_CONTROL+1; Nondestructive read function
CHR_FMAX	= CHR_LOOK	; Maximum function number


; Configuration information packet

CHRD_CLASS	= 0		; Device class
  CHRDCL_CRT	  = 0		  ; Internal keyboard/display
  CHRDCL_SER	  = CHRDCL_CRT+1; 2661 serial port
  CHRDCL_PAR	  = CHRDCL_SER+1; PIA parallel port
  CHRDCL_MAX	  = CHRDCL_PAR  ; Maximum class value
CHRD_ATTR	= CHRD_CLASS+1 ; Attributes
  CHRDA_SPI	  = 00000001B	  ; Strip parity on input
  CHRDA_SPO	  = 00000010B	  ; Strip parity on output
  CHRDA_MLI	  = 00000100B	  ; Map lower to upper case on input
  CHRDA_MLO	  = 00001000B   ; Map lower to upper case on output

; The remaining fields are used only with the 2661 serial ports
;  (except CHRD_NCHR and CHRD_NCNT which can be used by para printer)

CHRD_PORT	= CHRD_ATTR+1	; Port number
CHRD_BAUD	= CHRD_PORT+2	; Baud rate
  BD455		  = 0		  ; 45.5
  BD050		  = 1		  ; 50
  BD075		  = 2		  ; 75
  BD110		  = 3		  ; 110
  BD134		  = 4		  ; 134.5
  BD150		  = 5		  ; 150
  BD300		  = 6		  ; 300
  BD600		  = 7		  ; 600
  BD120		  = 8		  ; 1200
  BD180		  = 9		  ; 1800
  BD200		  = 10	  ; 2000
  BD240		  = 11	  ; 2400
  BD480		  = 12	  ; 4800
  BD960		  = 13	  ; 9600
  BD192		  = 14	  ; 19200
  BD384		  = 15	  ; 38400
  BDMAX		  = BD384	  ; Maximum valid baud rate
CHRD_HSHK	= CHRD_BAUD+1	; Handshaking protocol
  CHRDH_NO	  = 0		  ; None
  CHRDH_EAH	  = CHRDH_NO+1  ; <ETX>/<ACK>
  CHRDH_DCH	  = CHRDH_EAH+1 ; <DC3>/<DC1> (CTRL-S/CTRL-Q)
  CHRDH_DCDH	  = CHRDH_DCH+1 ; DCD(data carrier detect) high
  CHRDH_DCDL	  = CHRDH_DCDH+1; DCD low
  CHRDH_DSRH	  = CHRDH_DCDL+1; DSR(data set ready) high
  CHRDH_DSRL      = CHRDH_DSRH+1; DSR low
  CHRDH_MAX	  = CHRDH_DSRL  ; Maximum valid value
CHRD_BCTL	= CHRD_HSHK+1	; Stop bits/parity/char length
				;   (2661 Mode register 1)
  CHRDB_SB	  = 11000000B	  ; Stop bits
    CHRDB_SB1	    = 040H	    ; 1 stop bit
    CHRDB_SB15	    = 080H        ; 1.5 stop bits
    CHRDB_SB2	    = 0C0H	    ; 2 stop bits
  CHRDB_PT	  = 00100000B	  ; Parity type(0=odd, 1=even)
  CHRDB_PC	  = 00010000B	  ; Parity contr(0=disabled, 1=enabled)
  CHRDB_CL	  = 00001100B   ; Character length
    CHRDB_CL5	    = 00H	    ; 5 bits
    CHRDB_CL6	    = 04H	    ; 6 bits
    CHRDB_CL7	    = 08H	    ; 7 bits
    CHRDB_CL8	    = 0CH	    ; 8 bits
CHRD_ECNT	= CHRD_BCTL+1	; If <ETX>/<ACK> used, chars to
				;   send before <ETX> sent
CHRD_NCNT	= CHRD_ECNT+1 ; Number of NULLs to send after
				;   CHRD_NCHR seen
CHRD_NCHR	= CHRD_NCNT+1 ; Character after which to send NULLs
CHRD_RES	= CHRD_NCHR+1 ; Reserved for future use
CHRD_SIZE	= CHRD_RES+6	; Size of a CHRD


; Error codes that are returned

CHRE_ILGFH	= 0		; Illegal function code in AH
CHRE_ILGFL	= CHRE_ILGFH+1; Illegal function code in AL
CHRE_NWR	= CHRE_ILGFL+1; No writes allowed to device
CHRE_NRD	= CHRE_NWR+1	; No reads allowed to device
CHRE_BSUP	= CHRE_NRD+1	; Bad set up parameters
CHRE_WRB	= CHRE_BSUP+1	; Device busy on write
CHRE_RDNR	= CHRE_WRB+1	; Device not ready on read
CHRE_HTO	= CHRE_RDNR+1	; Software handshake time out
CHRE_ILR	= CHRE_HTO+1	; Illegal responce from device
CHRE_IQE	= CHRE_ILR+1	; Input queue empty
CHRE_NIQ	= CHRE_IQE+1	; Device has no input queue


; Internal character device control table(It includes an embedded CHRD)

CID_CHRD	= 0		; A CHRD	
CID_CLASS	= CID_CHRD+CHRD_SIZE	; Class of character device
					;   (must be mult of 2)
  CIDCL_CRT	  = CHRDCL_CRT*2 ; Internal video/keyboard
  CIDCL_SER	  = CHRDCL_SER*2 ; 2661 serial port
  CIDCL_PAR	  = CHRDCL_PAR*2 ; PIA parallel port
CID_TYPE	= CID_CLASS+2	; Special types
  CIDTY_NORM	  = 0		   ; Normal type
  CIDTY_CSP	  = CIDTY_NORM+1 ; Special CRT
CID_IPORT	= CID_TYPE+2	; Input port
CID_OPORT	= CID_IPORT+2	; Output port
CID_SPORT	= CID_OPORT+2	; Status port
CID_CPORT	= CID_SPORT+2	; Control port
CID_ST		= CID_CPORT+2	; Status(see CHRD_SFGS for values)
CID_IRM		= CID_ST+1	; Input ready mask
CID_IPM		= CID_IRM+1	; Input polarity mask
CID_ORM		= CID_IPM+1	; Output ready mask
CID_OPM		= CID_ORM+1	; Output polarity mask
CID_ECTR	= CID_OPM+1	; Char counter for sending <ETX>
CID_NCTR	= CID_ECTR+1	; Null down counter
CID_SIZE	= CID_NCTR+1	; Size of the a CID 


;
; Define queue for character devices
;

CQ_SADDR	= 0		; Addr of start of queue
CQ_EADDR	= CQ_SADDR+2	; Addr of end of queue
CQ_QSIZE	= CQ_EADDR+2	; Size of queue
CQ_ELMTS	= CQ_QSIZE+2	; Number of elements currently in queue
CQ_STATUS	= CQ_ELMTS+2	; Status (as defined under CHR_STATUS)
CQ_FRONT	= CQ_STATUS+1	; Addr of first element in queue
CQ_REAR		= CQ_FRONT+2	; Addr of last element in queue
CQ_SEGM		= CQ_REAR+2	; Segment of que
CQ_SIZE		= CQ_SEGM+2	; Size of a CQ

;	queue sizes

ZSERA_IQS	=	255	; Serial A input que
ZSERA_OQS	=	255	; Serial A output que
ZSERB_IQS	=	255	; Serial B input que
ZSERB_OQS	=	255	; Serial B output que
ZCON_IQS	=	90	; Input que size
ZCON_IQS1	=	ZCON_IQS-10	; Actual que size
