;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

; The Device headers 

DVH_STRUC STRUC
  DVH_OFF	DW ?		; Offset of link to next DVH in list
  DVH_SEG	DW ?		; Segment
  DVH_ATTR	DW ?		; Attributes(see below)
  DVH_STRAT	DW ?		; Offset of strategy routine
  DVH_INTR	DW ?		; Offset of intrupt routine
  DVH_NAME	DB 8 DUP(?)	; Device name (unit number in first byte for disks)
DVH_STRUC ENDS	


; The values for DVH_ATTR

DVHA_CHR	= 8000H 	; 1=character device; 0=block device
DVHA_STI	= 0001H 	; 1=standard input device; 0=not
DVHA_STO	= 0002H 	; 1=standard output device; 0=not
DVHA_NUL	= 0004H 	; 1=NUL device; 0=not
DVHA_CLK	= 0008H 	; 1=Clock device; 0=not
DVHA_SPC	= 0010H	; 1=Special "Fast output" bit
DVHA_CTL	= 4000H 	; 1=control mode; 0=not control mode
DVHA_IBM	= 2000H	; 1=non-IBM format bit



; The Static Request header

SRH_STRUC STRUC	
  SRH_LEN	DB ?		; Length of command request structure
  SRH_UNIT	DB ?		; Sub unit number
  SRH_CMD	DB ?		; Command code(see below)
  SRH_STAT	DW ?		; Status code(see below))
  SRH_RES	DB 8 DUP(?)	; Reserved for two sets of links
SRH_STRUC ENDS


; Device driver commands (SRH_CMD)

SRHC_INIT	= 0		; Initialization
SRHC_MCHK	= 1		; Media check (block devices only)
SRHC_BPB	= 2		; Build BPB (block devices only)
SRHC_ICTL	= 3		; IOCTL input
SRHC_IN		= 4		; Input
SRHC_ICHK	= 5		; Non-destructive input no wait (char devices only)
SRHC_ISTAT	= 6		; Input status (char devices only)
SRHC_IFL	= 7		; Input flush (char devices only)
SRHC_OUT	= 8		; Output
SRHC_OUTV	= 9		; Output (write) with verify
SRHC_OSTAT	= 10		; Output status (char devices only)
SRHC_OFL	= 11		; Output flush (char devices only)
SRHC_OCTL	= 12		; IOCTL output
SRHC_MAX	= 12		; Max command value

; Status codes (in upper half of SRH_STAT)

SRHS_ERR	= 80H		; 1=error; 0=no error
SRHS_RES1	= 7CH		; reserved
SRHS_BUI	= 02H		; 1=busy; 0=not busy 
SRHS_DON	= 01H		; 1=done; 0=not done

; Error codes (in lower half of SRH_STAT)

SRHS_EWPR	= 0		; Write protect violation
SRHS_EUKU	= 1		; Unknown unit
SRHS_EDNR	= 2		; Drive not ready
SRHS_EUKC	= 3		; Unknown command
SRHS_ECRC	= 4		; CRC error
SRHS_ELEN	= 5		; Bad request structure length
SRHS_ESEEK	= 6		; Seek error
SRHS_EUKM	= 7		; Unknown media
SRHS_ESNF	= 8		; Sector not found
SRHS_ENPP	= 9		; Printer out of paper
SRHS_EWRF	= 10		; Write fault
SRHS_ERDF	= 11		; Read fault
SRHS_EGNF	= 12		; General failure
SRHS_EMAX	= 12		; Max error code


; Read/Write Request packet

CRW_STRUC STRUC
  CRW_SRH	DB SIZE SRH_STRUC DUP(?) ; A static request header
  CRW_MBYTE	DB ?		; Media descriptor
  CRW_TADDR	DD ?		; Transfer addr
  CRW_CNT	DW ?		; Byte/sector count
  CRW_START	DW ?		; Starting sector number
CRW_STRUC ENDS	


; Non-destructive read(no wait) packet

CIC_STRUC STRUC
  CIC_SRH	DB SIZE SRH_STRUC DUP(?) ; A static request header
  CIC_CHAR	DB ?		; Character from device
CIC_STRUC ENDS


; Media check packet

CMC_STRUC STRUC
  CMC_SRH	DB SIZE SRH_STRUC DUP(?) ; A static request header
  CMC_MBYTE	DB ?		; Media descriptor
  CMC_STAT	DB ?		; Media status (see below)
CMC_STRUC ENDS

CMCS_CHG	= -1		; Media has been changed
CMCS_DKN	=  0		; Don't know if media changed
CMCS_NOC	= +1		; Media not changed


; Build BPB packet

CBPB_STRUC STRUC
  CBPB_SRH	DB SIZE SRH_STRUC DUP(?) ; A static request header
  CBPB_MBYTE	DB ?		; Media descriptor
  CBPB_TADDR	DD ?		; Transfer addr
  CBPB_BADDR	DD ?		; BPB addr
CBPB_STRUC ENDS


; Init packet

CIN_STRUC STRUC
  CIN_SRH	DB SIZE SRH_STRUC DUP(?) ; A static request header
  CIN_UNITS	DB ?		; Number of units
  CIN_KADDR	DD ?		; Break addr
  CIN_BADDR	DD ?		; BPB array addr
  CIN_PADDR	DD ?		; Init parameters
CIN_STRUC ENDS


; A BPB (BIOS parameter block)

BPB_STRUC STRUC
  BPB_SECSZ	DW ?		; Sector size
  BPB_SPAU	DB ?		; Sectors per allocation unit
  BPB_RES	DW ?		; Reserved sectors
  BPB_NFATS	DB ?		; Number of FAT's (file alloc tables)
  BPB_DIRENTS	DW ?		; Number of director entries
  BPB_SECS	DW ?		; Number of sectors
  BPB_MBYTE	DB ?		; Media byte
  BPB_FATSECS	DW ?		; Number of sectors occupied by a FAT
BPB_STRUC ENDS

