;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Definitions for Enhanced programmable communication interface chip 2661-2
;

;	PORT DISPLACEMENTS

EPDATA	=	0		;DATA
EPSTAT	=	1		;STATUS
EPSYN	=	1		;SYN1/SYN2/DLE
EPMODE	=	2		;MODE
EPCMD	=	3		;COMMAND

;	STATUS REGISTER

EPTXR	=	00000001B	;TRANSMITTER READY
EPRXR	=	00000010B	;RECEIVER READY
EPTXE	=	00000100B	;TRANSMITTER EMPTY
EPDSC	=	00000100B	;DATA SET CHANGE
EPPE	=	00001000B	;PARITY ERROR
EPOE	=	00010000B	;OVERRUN ERROR
EPFE	=	00100000B	;FRAME ERROR
EPSD	=	00100000B	;SYNC DETECTED
EPDCD	=	01000000B	;DATA CARRIER DETECT
EPDSR	=	10000000B	;DATA SET READY

;	MODE REGISTER 1

EPMBRF	=	00000011B	;MODE AND BAUDRATE FACTOR
EPS1X	=	000H		;  SYNCHRONOUS 1X RATE
EPA1X	=	001H		;  ASYNCHRONOUS 1X RATE
EPA16X	=	002H		;  ASYNCHRONOUS 16X RATE
EPA64X	=	003H		;  ASYNCHRONOUS 64X RATE

EPCL	=	00001100B	;CHARACTER LENGTH
EPCL5	=	000H		;  LENGTH 5
EPCL6	=	004H		;  LENGTH 6
EPCL7	=	008H		;  LENGTH 7
EPCL8	=	00CH		;  LENGTH 8

EPPC	=	00010000B	;PARITY CONTROL (0=DISABLED , 1=ENABLED)
EPPT	=	00100000B	;PARITY TYPE (0=ODD , 1=EVEN)

EPASBL	=	11000000B	;ASYNCHRONOUS STOP BIT LENGTH
EPSB1	=	040H		;  LENGTH 1
EPSB15	=	080H		;  LENGTH 1.5
EPSB2	=	0C0H		;  LENGTH 2

EPSTC	=	01000000B	;SYNCHRONOUS TRANSPARENCY CONTROL
				; (0=NORMAL , 1=TRANSPARENT)
EPNSC	=	10000000B	;NUMBER OF SYNC CHARACTERS
				; (0=DOUBLE , 1=SINGLE)

;	MODE REGISTER 2

EPBRS	=	00001111B	;BAUD RATE SELECTION
EPMR2U	=	11110000B	;SEE TEXT
  EPMR2A  =	  70H		  ;VALUE FOR ASYNC OPERATION

;	COMMAND REGISTER

EPTXEN	=	00000001B	;TRANSMITTER ENABLE
EPDTR	=	00000010B	;DATA TERMINAL READY
EPRXEN	=	00000100B	;RECEIVER ENABLE
EPSBRK	=	00001000B	;SEND BREAK (ASYNC)
EPSDLE	=	00001000B	;SEND DLE (SYNC)
EPRESE	=	00010000B	;RESET STATUS ERRORS
EPRTS	=	00100000B	;R=EST TO SEND

EPOM	=	11000000B	;OPERATING MODE
EPNORM	=	000H		;  NORMAL
EPOM1	=	040H		;  MODE 1
EPOMLL	=	080H		;  LOCAL LOOP BACK
EPOMRL	=	0C0H		;  REMOTE LOOP BACK

;	BAUDRATE SELECTION VALUES

EPB455	=	0		;45.5
EPB050	=	1		;50
EPB075	=	2		;75
EPB110	=	3		;110
EPB134	=	4		;134.5
EPB150	=	5		;150
EPB300	=	6		;300
EPB600	=	7		;600
EPB120	=	8		;1200
EPB180	=	9		;1800
EPB200	=	10		;2000
EPB240	=	11		;2400
EPB480	=	12		;4800
EPB960	=	13		;9600
EPB192	=	14		;19200
EPB384	=	15		;38400
EPBMAX	=	EPB384		;MAX BAUD RATE 
