;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

;
; Define the parameters for the Z-217 controller
;
; 11/22/82 - bcb
;

Z217SPT		= 9		; Sectors/track
Z217BPS		= 1024		; Bytes/sector

; Define the port offsets

WICOM		= 0		; Command port offset
WISTA		= 0		; Status port offset
WIRES		= 1		; Reset port offset
WIACK		= 1		; Interrupt ackowledge port offset

; Define status register bits

WISINT		= 80H		; Interrupt
WISBUSY		= 40H		; Busy
WISTMAIP	= 20H		; TMA in progress
WISBUM		= 10H		; Burst mode
WISERR		= 08H		; Error
WISIME		= 04H		; Immediate mode error
WISPAUS		= 02H		; Paused
WISDONE		= 01H		; Done

; Define the commands

WICBOOT		= 00H		; Boot
WICSETUP	= 08H		; Setup
WICEXE		= 10H		; Execute
WICPAU		= 18H		; Pause
WICCONT		= 20H		; Continue

; Define the Flag byte

WIFIEN		= 80H		; Interrupts enabled
WIFUBUM		= 40H		; Use burst mode
WIFIPC		= 20H		; Ignore PAUSE and CONT
WIFDR		= 04H		; Disable retries
WIFDECC		= 02H		; Disable ecc errors
WIFCHAIN	= 01H		; Chain next command

; Define the control block commands

WICBRCL		= 00H		; Recal drive
WICBSTS		= 01H		; Read drive status

WICBRDL		= 11H		; Read logical
WICBWRL		= 10H		; Write logical
WICBSKL		= 13H		; Seek logical

WICBFMD		= 20H		; Format drive
WICBFMT		= 21H		; Format track
WICBSDP		= 22H		; Set drive parameters

WICBWRA		= 30H		; Write absolute
WICBRDA		= 31H		; Read absolute
WICBSKA		= 33H		; Seek absolute

; Define a type 0/1 control block

WI1COM		= 0		; Command
WI1DSHS		= WI1COM+1	; Drive select in bits 7-5, sector number 4-0
WI1SECH		= WI1DSHS+1	; Sector number(high)
WI1SECL		= WI1SECH+1	; Sector number(low)
WI1CNT		= WI1SECL+1	; Sector count (0=256)
WI1TMAH		= WI1CNT+1	; Data TMA addr(high)
WI1TMAM		= WI1TMAH+1	; Data TMA addr(middle)
WI1TMAL		= WI1TMAM+1	; Data TMA addr(low)
WI1NCAH		= WI1TMAL+1	; Next command addr(high)
WI1NCAM		= WI1NCAH+1	; Next command addr(middle)
WI1NCAL		= WI1NCAM+1	; Next command addr(low)
WI1FLAGS	= WI1NCAL+1	; Flags
WI1ERR		= WI1FLAGS+1	; Error code
WI1HSE		= WI1ERR+1	; Head in bits 7-5, sector in 4-0 of error
WI1SCHE		= WI1HSE+1	; Sector number(high) of error
WI1SCLE		= WI1SCHE+1	; Sector number(low) of error
WI1_SIZE	= WI1SCLE+1	; Size of control block

; Define a type 2 control block

WI2COM		= 0		; Command
WI2DSHS		= WI2COM+1	; Drive/max head number
WI2MCH		= WI2DSHS+1	; Max cylinder hi
WI2MCL		= WI2MCH+1	; Max cylinder lo
WI2RWCH		= WI2MCL+1	; Reduced write current hi
WI2RWCL		= WI2RWCH+1	; Reduced write current lo
WI2PCH		= WI2RWCL+1	; Precomp hi
WI2PCL		= WI2PCH+1	; Precomp lo
WI2SRC		= WI2PCL+1	; Step rate code
WI2ECS		= WI2SRC+1	; ECC correction span to use
WI2CIF		= WI2ECS+1	; Cell size and interleave factor
WI2FFC		= WI2CIF+1	; fill character for formatting

; Define a type 3 control block

WI3COM		= 0		; Command
WI3DSHS		= WI3COM+1	; Drive select bits 7-5, head select in 2-0
WI3CYH		= WI3DSHS+1	; Cylinder number(high)
WI3CYL		= WI3CYH+1	; Cylinder number(low)
WI3SEC		= WI3CYL+1	; Sector number
WI3TMAH		= WI3SEC+1	; Data TMA addr(high)
WI3TMAM		= WI3TMAH+1	; Data TMA addr(middle)
WI3TMAL		= WI3TMAM+1	; Data TMA addr(low)
WI3NCAH		= WI3TMAL+1	; Next command addr(high)
WI3NCAM		= WI3NCAH+1	; Next command addr(middle)
WI3NCAL		= WI3NCAM+1	; Next command addr(low)
WI3FLAGS	= WI3NCAL+1	; Flags
WI3ERR		= WI3FLAGS+1	; Error code
WI3HSE		= WI3ERR+1	; Head in bits 7-5, sector in 4-0 of error
WI3CYHE		= WI3HSE+1	; Cylinder number(high) of error
WI3CYLE		= WI3CYHE+1	; Cylinder number(low) of error
WI3_SIZE	= WI3CYLE+1	; Size of control block

; Define the error codes

WIENO		= 00H		; No error
WIEDNR		= 01H		; Drive not ready
WIENSC		= 02H		; No seek complete
WIENTZ		= 03H		; No track 0
WIENI		= 04H		; No index
WIENDS		= 05H		; No drive selected

WIEHNF		= 10H		; Header A.M. not found
WIESKE		= 11H		; Seek error
WIESNF		= 12H		; Sector not found
WIEHECC		= 13H		; ECC error in header
WIEDAM		= 14H		; Data A.M. not found
WIENECC		= 15H		; Non-Correctable ECC error in data field
WIECECC		= 16H		; Correctable ECC error in data field
WIEWF		= 17H		; Write fault

WIEIOC		= 20H		; Illegal op code
WIEIDA		= 21H		; Illegal disk addr
WIEFP		= 22H		; Format protected
WIEWP		= 23H		; Write protected

WIEMISC		= 30H		; Miscellaneous error

WIEDIAG		= 40H		; Error during diagnostic

