;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFCHR.ASM
.LIST

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS,DS:BIOS,SS:BIOS

	PUBLIC	LPT_FLUSH, LPT_INPUT, LPT_LOOK, LPT_OUTPUT
	PUBLIC	LPT_IN_STAT, LPT_OUT_STAT

	EXTRN	SUCESS:NEAR
	EXTRN	ERRORC:NEAR
	EXTRN	BUSY:NEAR
	EXTRN	ERROR:NEAR
	EXTRN	BIOS_PRNFUNC:FAR

	TITLE	Parallel routines
	PAGE

;**	LPT_INPUT - Printer Input
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;
;	EXIT:	None
;
LPT_INPUT PROC NEAR

	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LES	DI,ES:CRW_TADDR[BX]	; Get transfer address
	CLD
CMI1:
	PUSH	CX
	PUSH	DI
	CALL	LPT_IN
	POP	DI
	POP	CX
	JC	CMI3
CMI2:
	STOSB
	LOOP	CMI1
	JMP	SUCESS
CMI3:
	JMP	ERRORC

LPT_INPUT ENDP

;**	LPT_OUTPUT - Printer output
;
;	ENTRY:	AL - Character to be output
;
;	EXIT:	None
;
;	USES:	AL

LPT_OUTPUT PROC NEAR

	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LDS	SI,ES:CRW_TADDR[BX]	; Get transfer address
	CLD
	PUSH	BX
CMO1:
	LODSB
	MOV	AH,CHR_WRITE		; Char in AL is sent
CMO2:
	PUSH	AX
	PUSH	CX
	PUSH	SI
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_PRNFUNC
	POP	SI
	POP	CX
	POP	AX
	JC	CMO2			; If error, try again
	LOOP	CMO1
	POP	BX
	JMP	SUCESS

LPT_OUTPUT ENDP

;	Stepping stone jumps for short jumps
BUSY1:	JMP	BUSY
ERROR1: JMP	ERROR
ERROR1C:JMP	ERRORC


;	LPT_LOOK - This routine returns a character from the LPT device
;
;	ENTRY:	ES:BX - Packet
;		DS - BIOS segment
;
;	EXIT:	BUSY set - no char available
;		BUSY Clear - Char returned in packet
;
LPT_LOOK PROC NEAR

	MOV	AH,CHR_LOOK		; Look at next char in queue
	PUSH	BX
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_PRNFUNC
	POP	BX
	JNC	CIL1
	CMP	AX,CHRE_IQE		; Is queue empty?
	JZ	BUSY1			; Yes, jump
	MOV	AL,SRHS_ERDF		; Flag error
	JMP	ERROR1

CIL1:
	MOV	ES:CIC_CHAR[BX],AL	; Return character to DOS
	JMP	SUCESS

LPT_LOOK ENDP


;	LPT_OUT_STAT - This routine will return the output status
;		of the PRN device
;
;	ENTRY:	ES:BX - Packet
;
;	EXIT:	BUSY set - Output request will wait for device
;		BUSY celar - Output request will execute immediately
;
LPT_OUT_STAT PROC NEAR

	CALL	LPT_STAT		; Get port status
	TEST	AH,80H			; Is transmitter ready?
	JZ	BUSY1			; No, busy
	JMP	SUCESS

LPT_OUT_STAT ENDP

;	LPT_IN_STAT - Get imput status for PRN device
LPT_IN_STAT PROC NEAR

	CALL	LPT_STAT		; Get device status
	TEST	AH,40H			; Is data available?
	JZ	BUSY1			; No
	JMP	SUCESS
LPT_IN_STAT ENDP

;	LPT_FLUSH - Flush the PRN look ahead
LPT_FLUSH PROC	NEAR

	MOV	AH,CHR_CONTROL
	MOV	AL,CHR_CFCI		; Clear input buffer
	PUSH	BX
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_PRNFUNC
	POP	BX
	JMP	SUCESS

LPT_FLUSH ENDP


;	LPT_STAT - Common status routine fom PRN routines
LPT_STAT PROC	NEAR

	MOV	AH,CHR_STATUS		; Return device status
	MOV	AL,CHR_SFGS		; Status sub-function
	PUSH	BX
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_PRNFUNC
	POP	BX
	RET

LPT_STAT ENDP

;	LPT_IN - Common input routine for PRN routines
LPT_IN	PROC	NEAR

	MOV	AH,CHR_READ		; Read a character
	PUSH	BX
	PUSH	CS			; Fake a far call
	CALL	NEAR PTR BIOS_PRNFUNC
	POP	BX
	JNC	CMIN1			; Jump if no errors
	CMP	AX,CHRE_RDNR		; 'Not ready' error?
	JZ	LPT_IN			; If so, try again
	MOV	AL,SRHS_ERDF		; else flag read error
	STC				; Notify caller
	RET
CMIN1:
	CLC				; Sucessful read
	RET

LPT_IN	ENDP

BIOS	ENDS
	END
