;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFCHR.ASM
.LIST

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS,DS:BIOS,SS:BIOS

	PUBLIC	BUSY1, COM_FLUSH, COM_INPUT, COM_LOOK, COM_OUTPUT
	PUBLIC	COM_IN_STAT, COM_OUT_STAT, ERROR1, ERROR1C

	EXTRN	SUCESS:NEAR
	EXTRN	ERRORC:NEAR
	EXTRN	BUSY:NEAR
	EXTRN	ERROR:NEAR
	EXTRN	BIOS_AUXFUNC:FAR

	TITLE	Serial routines
	PAGE

;**	COM_INPUT - Auxilliary Input
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;
;	EXIT:	None
;
COM_INPUT PROC NEAR

	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LES	DI,ES:CRW_TADDR[BX]	; Get transfer address
	CLD
CMI1:
	PUSH	CX
	PUSH	DI
	CALL	COM_IN
	POP	DI
	POP	CX
	JC	CMI3
CMI2:
	STOSB
	LOOP	CMI1
	JMP	SUCESS
CMI3:
	JMP	ERRORC

COM_INPUT ENDP

;**	COM_OUTPUT - Auxilliary output
;
;	ENTRY:	AL - Character to be output
;
;	EXIT:	None
;
;	USES:	AL

COM_OUTPUT PROC NEAR

	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LDS	SI,ES:CRW_TADDR[BX]	; Get transfer address
	CLD
	PUSH	BX
CMO1:
	LODSB
	MOV	AH,CHR_WRITE		; Char in AL is sent
CMO2:
	PUSH	AX
	PUSH	CX
	PUSH	SI
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_AUXFUNC
	POP	SI
	POP	CX
	POP	AX
	JC	CMO2			; If error, try again
	LOOP	CMO1
	POP	BX
	JMP	SUCESS

COM_OUTPUT ENDP

;	Stepping stone jumps for short jumps
BUSY1:	JMP	BUSY
ERROR1: JMP	ERROR
ERROR1C:JMP	ERRORC


;	COM_LOOK - This routine returns a character from the COM device
;
;	ENTRY:	ES:BX - Packet
;		DS - BIOS segment
;
;	EXIT:	BUSY set - no char available
;		BUSY Clear - Char returned in packet
;
COM_LOOK PROC NEAR

	MOV	AH,CHR_LOOK		; Look at next char in queue
	PUSH	BX
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_AUXFUNC
	POP	BX
	JNC	CIL1			; Jump if no errors
	CMP	AX,CHRE_IQE		; Is queue empty?
	JZ	BUSY1			; Yes, jump
	MOV	AL,SRHS_ERDF		; Flag error
	JMP	ERROR1

CIL1:
	MOV	ES:CIC_CHAR[BX],AL	; Return character to DOS
	JMP	SUCESS

COM_LOOK ENDP


;	COM_OUT_STAT - This routine will return the output status
;		of a serial device
;
;	ENTRY:	ES:BX - Packet
;
;	EXIT:	BUSY set - Output request will wait for device
;		BUSY clear - Output request will execute immediately
;
COM_OUT_STAT PROC NEAR

	CALL	COM_STAT		; Get port status
	TEST	AH,80H			; Is transmitter ready?
	JZ	BUSY1			; No, receiver busy
	JMP	SUCESS

COM_OUT_STAT ENDP

;	COM_IN_STAT - Get imput status for COM device
COM_IN_STAT PROC NEAR

	CALL	COM_STAT		; Get device status
	TEST	AH,40H			; Is data available?
	JZ	BUSY1			; No
	JMP	SUCESS
COM_IN_STAT ENDP

;	COM_FLUSH - Flush the COM look ahead
COM_FLUSH PROC	NEAR

	MOV	AH,CHR_CONTROL
	MOV	AL,CHR_CFCI		; Clear input buffer
	PUSH	BX
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_AUXFUNC
	POP	BX
	JMP	SUCESS

COM_FLUSH ENDP


;	COM_STAT - Common status routine fom COM routines
COM_STAT PROC	NEAR

	MOV	AH,CHR_STATUS		; Return device status
	MOV	AL,CHR_SFGS		; Status sub-function
	PUSH	BX
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_AUXFUNC
	POP	BX
	RET

COM_STAT ENDP

;	COM_IN - Common input routine for COM routines
COM_IN	PROC	NEAR

	MOV	AH,CHR_READ		; Read a character
	PUSH	BX
	PUSH	CS			; Fake a far call
	CALL	NEAR PTR BIOS_AUXFUNC
	POP	BX
	JNC	CMIN1			; Jump if no errors
	CMP	AX,CHRE_RDNR		; 'Not ready' error?
	JZ	COM_IN			; If so, try again
	MOV	AL,SRHS_ERDF		; else flag read error
	STC				; Notify caller
	RET
CMIN1:
	CLC				; Sucessful read
	RET

COM_IN	ENDP

BIOS	ENDS
	END
