	PAGE	,132
;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;


.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEF8253.ASM
	INCLUDE DEFCONFG.ASM
	INCLUDE DEFCHR.ASM
	INCLUDE DEF8259A.ASM
	INCLUDE DEFIPAGE.ASM
	INCLUDE DEFMTR.ASM
.LIST


BIOS	SEGMENT	BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS, DS:BIOS

	EXTRN	BIOS_PRNFUNC:FAR
	EXTRN	BIOS_AUXFUNC:FAR
	EXTRN	DSK_TIMOUT:WORD
	EXTRN	PRNBUF:BYTE
	EXTRN	AUXBUF:BYTE
	EXTRN	TIM_TOD:DWORD
	EXTRN	TICVAL:WORD
	EXTRN	EVN_FLG:WORD
	EXTRN	ASP_LPHFV:BYTE
	EXTRN	ASP_LPHCAV:WORD
	EXTRN	ASP_LPHPAV:BYTE
	EXTRN	CQ_ZCON:BYTE
	EXTRN	TIM_IDT:NEAR

	PUBLIC	ISR_TIM, BIOS_DATE, ROM_TIMER_VECTOR
	PUBLIC	ISR_UTM, TIMESTAMP_FLG
	PUBLIC	BIOS_HRS, BIOS_MIN, BIOS_SEC, BIOS_HSEC

BIOS_DATE	DW	0
BIOS_HRS	DB	0
BIOS_MIN	DB	0
BIOS_SEC	DB	0
BIOS_HSEC	DB	0

ROM_TIMER_VECTOR	DD	0		; ROM's timer int vector

TIMESTAMP_FLG	DB	0

ROMINT_COUNT	DB	0

LP_COUNT	DB	10			; Light pen poll timer

ISR_TIM:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	DS
	PUSH	CS
	POP	DS

	INC	TICVAL			; Update public tick counter

	INC	BIOS_HSEC		; Bump hundredths count
	CMP	BIOS_HSEC,100		; Overflow?
	JB	ISR_TIM1		; No, skip
	MOV	BIOS_HSEC,0		; Reset hundredths
	INC	BIOS_SEC		; Bump seconds count
	CMP	BIOS_SEC,60		; Overflow?
	JB	ISR_TIM1		; No, skip
	MOV	BIOS_SEC,0		; Reset seconds
	INC	BIOS_MIN		; Bump minutes counter
	CMP	BIOS_MIN,60		; Overflow?
	JB	ISR_TIM1		; No, skip
	MOV	BIOS_MIN,0		; Reset minutes
	INC	BIOS_HRS		; Bump hours counter
	CMP	BIOS_HRS,24		; Overflow?
	JB	ISR_TIM1		; No, skip
	MOV	BIOS_HRS,0		; Reset 
	INC	BIOS_DATE		; Bump day counter

ISR_TIM1:
	MOV	CX,4			; Set loop counter for 4 floppies
	MOV	DI,0			; Start with unit 0
ISR_TIM2:
	CMP	WORD PTR DSK_TIMOUT[DI],0	; Has it timed out yet?
	JZ	ISR_TIM3		; Yep, skip
	DEC	WORD PTR DSK_TIMOUT[DI]	; Decrement count
ISR_TIM3:
	ADD	DI,2			; Point to next entry
	LOOP	ISR_TIM2		; Do for all 4 floppies

;	Check date/time stamp flag

	CMP	WORD PTR TIM_TOD,0	; Time to set flag?
	JA	ISR_TIM3A		; No, skip
	MOV	TIMESTAMP_FLG,0FFH	; Set flag
	JMP	SHORT ISR_TIM3B		; Skip
ISR_TIM3A:
	DEC	WORD PTR TIM_TOD	; Count this tick
ISR_TIM3B:


;	Interrupt on user timer interrupt

	MOV	AX,1			; Assume only one tic since last int
	INT	INT_UTMA		; User timer interrupt

;	See if light pen was hit
;
;	CMP	CS:LP_COUNT,0		; Time to poll light pen?
;	JNZ	ISR_TIM3C		; Skip if not time yet
;	MOV	CS:LP_COUNT,10		; Reset count
;	MOV	AH,VIO_RPP		; Read light pen position
;	INT	VIDEO_IO_INTR		; Do it
;	OR	AH,AH			; Was the light pen hit?
;	JZ	ISR_TIM3D		; No, skip
;
;	Get light pen info into Z-100 format
;
;	MOV	AL,9			; Scan lines per cell
;	MUL	DH			; Get scan line of top of cell in AX
;	MOV	CL,CH
;	XOR	CH,CH			; Get hit scan line in CX
;	SUB	CX,AX			; CX = Scan line within cell
;	MOV	AL,8			; Pixels per line in cell
;	MUL	DL			; AX = position of first pixel in cell
;	SUB	BX,AX			; BX = Pixel within cell
;	PUSH	BX			; Save this info
;	MOV	AL,80			; Characters per line
;	MUL	DH
;	XOR	DH,DH
;	ADD	AX,DX			; AX = Character of hit (0-1999)
;	MOV	BX,AX			; Move it to BX
;	MOV	CS:ASP_LPHCAV,BX		; Store it
;	POP	AX			; Restore pixel number within cell
;	MOV	CH,CL			; CH = Scan line within cell
;	MOV	CL,4			; Set up count
;	SHL	CH,CL			; Shift bits into position
;	OR	AL,CH			; Move them into AL
;	MOV	CS:ASP_LPHPAV,AL		; Store the info
;	MOV	CS:ASP_LPHFV,0FFH	; Flag the hit
;	OR	CS:EVN_FLG,08H		; Set light pen bit in event flag
;	INT	INT_ULPA		; Int on user interrupt
;
;
ISR_TIM3C:
;	DEC	CS:LP_COUNT		; Decrement counter
ISR_TIM3D:

	CALL	Q_CON_UPDATE		; Update console queue descriptor
	POP	DS
	POP	DI			; Restore registers
	POP	DX
	POP	CX
	POP	BX

	CMP	CS:ROMINT_COUNT,0	; Time to call ROM interrupt?
	JZ	ISR_TIM4		; Yes, go to it
	DEC	CS:ROMINT_COUNT		; Decrement the count
	MOV	AL,OCW2OP+OCW2EOI
	OUT	ZM8259A+OCW2,AL		; Tell 8259A that int has been serviced
	POP	AX			; Finally restore AX
	IRET				; And return

ISR_TIM4:
	POP	AX			; Restore AX
	MOV	CS:ROMINT_COUNT,5	; Reset counter
	JMP	CS:ROM_TIMER_VECTOR	; Let ROM handle rest of interrupt


;
;	ISR_UTM - Default user timer interrupt routine
;

ISR_UTM:
	PUSH	AX
	PUSH	BX
	PUSH	DX
	PUSH	SI
	PUSH	DI

;	Check to see if devices have data buffered

	CMP	CS:BYTE PTR PRNBUF,0	; Does PRN have a character?
	JZ	ISR_UTM2		; No, skip

	MOV	AL,CS:BYTE PTR PRNBUF+1	; Get character
	MOV	CS:BYTE PTR PRNBUF,0	; Flag buffer empty
	MOV	AH,CHR_WRITE

	PUSH	CS			; Fake a far call
	CALL	NEAR PTR BIOS_PRNFUNC	; Output the char

ISR_UTM2:
	CMP	CS:BYTE PTR AUXBUF,0	; Does AUX have a character?
	JZ	ISR_UTM3		; No

	MOV	AL,CS:BYTE PTR AUXBUF+1	; Get the character
	MOV	CS:BYTE PTR AUXBUF,0	; Flag buffer as empty
	MOV	AH,CHR_WRITE

	PUSH	CS
	CALL	NEAR PTR BIOS_AUXFUNC

ISR_UTM3:
	POP	DI
	POP	SI
	POP	DX
	POP	BX
	POP	AX
	CALL	TIM_IDT			; Go through INTFUNC tables
	IRET


Q_CON_UPDATE	PROC	NEAR
	PUSH	DS
	MOV	AX,ROM_SEG		; Point to ROM data seg
	MOV	DS,AX
	
	ASSUME	DS:NOTHING

	MOV	DS,DS:ROM_DATA_SEG	; Point to IBM data seg

	ASSUME	DS:ROM_DATA

	MOV	DI,OFFSET CQ_ZCON	; Get address of queue descriptor
	MOV	AX,BUFFER_HEAD		; Get address of head
	MOV	CS:CQ_FRONT[DI],AX	; Store it
	MOV	BX,BUFFER_TAIL		; Get address of tail
	PUSH	BX			; Save it
	DEC	BX			; Adjust to z100 queue format
	CMP	BX,CS:CQ_SADDR[DI]	; Are we off the end?
	JAE	QUPD0			; Skip if we are still in queue
	ADD	BX,CQ_QSIZE[DI]		; Point to the end of the queue
QUPD0:
	MOV	CS:CQ_REAR[DI],BX	; Store it
	POP	BX			; Restore actual tail pointer
	SUB	BX,AX			; BX = TAIL - HEAD
	JNC	QUPD1			; Jump if not negative
	ADD	BX,CS:CQ_QSIZE[DI]	; Add in size of queue
QUPD1:
	MOV	CS:CQ_ELMTS[DI],BX	; Store number of elements
	POP	DS
	RET

Q_CON_UPDATE	ENDP


BIOS	ENDS
	END


                                                                                                                 
