    1   /*******************************************************************/
    2   /*                                                                 */
    3   /*       Assignment 4                  by: Wojciech BOK            */
    4   /*                                                                 */
    5   /*                                   date: March 23, 1988          */
    6   /*                                                                 */
    7   /*       Filename: XREF filename.C switches redirection            */
    8   /*                                                                 */
    9   /*       Purpose:   parse a file for legal function names, ignore  */
   10   /*                  reserved words, and maintain a list of line    */
   11   /*                  numbers where the function names occur         */
   12   /*                                                                 */
   13   /*       Note:  All global variables begin with a capital letter   */
   14   /*                                                                 */
   15   /*******************************************************************/
   16   
   17   #include <stdio.h>                  /* definition of stderr */
   18   #include <math.h>                   /* holds atoi */
   19   
   20   #define     FALSE           0       /* not true */
   21   #define     TRUE            1       /* true */
   22   #define     NUL             0
   23   #define     NAME_LENGTH     36      /* maximum length of a function name */
   24   #define     NAME_BUFFER     NAME_LENGTH + 4 /* size of name buffer - 4 extra chars for special display */
   25   #define     MAX_LINES       10      /* maximum number of lines per line link */
   26   #define     BUF_SIZE        60      /* length of input buffer */
   27   #define     EOL             '\n'    /* new line char */
   28   #define     MOL             '\0'    /* middle of logical line char */
   29   
   30   struct      S_library_functions
   31                   {
   32                   char     Name [ NAME_BUFFER ];           /* names of library functions */
   33                   struct   S_library_functions *Following; /* address of next link */
   34                   };
   35   struct      S_library_functions Lib_head,               /* dummy starting point */
   36                                   *Library,               /* current library function */
   37                                   *Blank_lib;             /* blank space */
   38   
   39   struct      S_line_numbers
   40                   {
   41                   int      Number [ MAX_LINES ];          /* line number lsit */
   42                   int      Space_left;                    /* number of spaces left in this link */
   43                   struct   S_line_numbers *Following;     /* address of next link */
   44                   };
   45   struct      S_line_numbers  *Blank_line;                /* next available space */
   46                   
   47   struct      S_function_name
   48                   {
   49                   char     Name [ NAME_BUFFER ];          /* function name */
   50                   int      Too_many_lines;                /* line number overflow -- not enough memory */
   51                   struct   S_line_numbers *First_line;    /* first link in line number list */
   52                   struct   S_line_numbers *Curr_line;     /* current working number list */
   53                   struct   S_function_name *Following;    /* address of next function */
   54                   };
   55   struct      S_function_name Head,                       /* dummy starting point */
   56                               *Function,                  /* current name in use */
   57                               *Blank_name;                /* next available space */
   58   
   59   
   60   int         Line_count = 0;         /* current source line number */
   61   int         Overflow = 0;           /* too many function names count and flag */
   62   int         Eof = FALSE;            /* flag for end of file */
   63   
   64   char        Line_buf[BUF_SIZE];     /* current line */
   65   char        *Line_ptr;              /* input line pointer */
   66   int         Input_file;             /* input file handle */
   67   int         Output_file = FALSE;    /* handle of file for numbered listing */
   68   
   69   int         XR_var = FALSE;         /* cross ref variables */
   70   int         XR_func = FALSE;        /*           function names */
   71   int         XR_lib = FALSE;         /*           library functions */
   72   int         XR_resv = FALSE;        /*           reserved words */
   73   
   74   #define     ONLY_LIB      !XR_var && !XR_func && !XR_resv && XR_lib  /* only the library switch was used */
   75   #define     NO_XR_FLAGS   !XR_var && !XR_func && !XR_resv && !XR_lib /* no cross reference switches were used */
   76               
   77   int         R_margin = 80;          /* width of listing */
   78   
   79   /*******************************************************************/
   80   /*                             IDENTIFICATION                      */
   81   /*    Function name:  MAIN ( argc , argv )                         */
   82   /*    Purpose      :  inputs the file name to be parsed and        */
   83   /*                      controls the flow of the program           */
   84   /*    Method       :  command line arguments                       */
   85   /*                                                                 */
   86   /*******************************************************************/
   87   /*                             COMMUNICATION                       */
   88   /*    Formal Paramters:                                            */
   89   /*        NAME               TYPE                    USED FOR      */
   90   /*     argc                  int                number of arguments*/
   91   /*     argv                  char               arguments          */
   92   /*                                                                 */
   93   /*    Global Variables Needed:                                     */
   94   /*        NAME               TYPE                    USED FOR      */
   95   /*      TRUE                 int                                   */
   96   /*      MAX_NAMES            int                limiter            */
   97   /*      NAME_BUFFER          int                size of words      */
   98   /*      MAX_LINES            int                limiter            */
   99   /*      NO_XR_FLAGS          macro              test               */
  100   /*      ONLY_LIB             macro              test               */
  101   /*                                                                 */
  102   /*      *Line_ptr            int                pointer            */
  103   /*      Eof                  int                flag               */
  104   /*      Line_count           int                counter            */
  105   /*      R_margin             int                width of output    */
  106   /*                                                                 */
  107   /*      Output_file          int                file handle        */
  108   /*      Input_file           int                file handle        */
  109   /*      stderr               int                standard error     */
  110   /*                                                handle           */
  111   /*                                                                 */
  112   /*      XR_resv              int                reserved words     */
  113   /*      XR_lib               int                library functions  */
  114   /*      XR_func              int                function names     */
  115   /*      XR_var               int                variables          */
  116   /*                                                                 */
  117   /*      S_function_name      struct             variable type      */
  118   /*                                                                 */
  119   /*      Head                 struct             starting point for */
  120   /*                                                linked list      */
  121   /*        .Following         int                pointer            */
  122   /*        .First_line        int                pointer            */
  123   /*        .Curr_line         int                pointer            */
  124   /*        .Too_many_lines    int                flag               */
  125   /*        .Name              char               function name      */
  126   /*                                                                 */
  127   /*      Function             struct             linked list        */
  128   /*                                                                 */
  129   /*      Blank_name           struct             next available     */
  130   /*                                                name location    */
  131   /*        ->Following        int                pointer            */
  132   /*        ->Too_many_lines   int                flag               */
  133   /*                                                                 */
  134   /*      Lib_head             struct             library list start */
  135   /*        .Following         int                pointer            */
  136   /*        .Name              char               function name      */
  137   /*                                                                 */
  138   /*      Library              struct             library list       */
  139   /*                                                                 */
  140   /*    Return Value:                                                */
  141   /*                     none                                        */
  142   /*******************************************************************/
  143   
  144   main( argc, argv)
  145       char *argv[];
  146       {
  147       int number;                 /* number of functions found */
  148       char output_name[15];       /* name of output file if any */
  149       int  output_flag = FALSE;   /* flag for line numbered O/P */
  150   
  151       fputs("\n                   C Cross Reference Utility - version 1.10", stderr);
  152       fputs("\n                                 by: Soft Touch\n\n", stderr);
  153   
  154       if ( argc == 1 )            /* no filename entered */
  155           fatal_msg( 1, " ");
  156   
  157       if ( *argv[1] == '/' )      /* switch entered first - treat as /? */
  158           fatal_msg( 9, " ");
  159   
  160       if ( argc > 2 )
  161           {
  162           number = 2;
  163   
  164           while ( number < argc )
  165               {
  166               if ( *argv[number] == '/' )
  167                   {
  168                   argv[number]++;
  169                   switch ( toupper( *argv[number] ))
  170                       {
  171                       case 'R':
  172                           XR_resv = TRUE;
  173                           break;
  174                       case 'L':
  175                           XR_lib = TRUE;
  176                           break;
  177                       case 'F':
  178                           XR_func = TRUE;
  179                           break;
  180                       case 'V':
  181                           XR_var = TRUE;
  182                           break;
  183                       case 'W':
  184                           {
  185                           argv[number]++;
  186                           if (*argv[number] != ':')
  187                               R_margin = 132;
  188                           else
  189                               if ( ( R_margin = atoi( ++argv[number] ) ) < 50 )
  190                                   R_margin = 80;
  191                           break;
  192                           }
  193                       case 'N':
  194                           {
  195                           argv[number]++;
  196                           output_flag = TRUE;
  197                           if (*argv[number] != ':')
  198                               {
  199                               strcpy ( output_name, argv[1]);
  200                               Line_ptr = output_name;
  201                               while ( *Line_ptr && *Line_ptr != '.' )
  202                                   Line_ptr++;
  203   
  204                               *Line_ptr = '.';
  205                               *(Line_ptr + 1) = 'L';
  206                               *(Line_ptr + 2) = '\0';
  207                               }
  208                           else
  209                               {
  210                               argv[number]++;
  211                               strcpy( output_name, argv[number] );
  212                               }
  213                           break;
  214                           }
  215                       case '?':
  216                           fatal_msg( 9, " " );    /* print help screen and die */
  217                       default:
  218                           break;
  219                       }
  220                   }
  221               else
  222                   argv[number]++;
  223   
  224               if ( *argv[number] == '\0' )
  225                   ++number;
  226               }
  227           }
  228   
  229       if ( NO_XR_FLAGS )  /* default */
  230           {
  231           XR_func = TRUE;
  232           XR_var = TRUE;
  233           }
  234   
  235       Head.Following  = NUL;
  236       Head.First_line = NUL;
  237       Head.Curr_line  = NUL;
  238       Head.Too_many_lines = FALSE;
  239       for ( number = 0; number < NAME_BUFFER; number++)
  240           Head.Name [ number ] = ' ';
  241   
  242       Function = Head.Following;
  243       
  244       if ( Blank_name = malloc ( sizeof ( struct S_function_name )))
  245           {
  246           Blank_name->Following = NUL;
  247           Blank_name->Too_many_lines = FALSE;
  248           }
  249   
  250       new_blank_line();
  251   
  252       Lib_head.Following = NUL;
  253       for ( number = 0; number < NAME_BUFFER; number++)
  254           Lib_head.Name [ number ] = ' ';
  255   
  256       Library = Lib_head.Following;
  257   
  258       number = FALSE;                /* 'number' is used as a flag temporarily */
  259   
  260       if ( ( Input_file = fopen ( "C_LIB.XRF", "r" )))
  261           {
  262           fputs("Reading library file C_LIB.XRF\r", stderr );
  263           number = get_library();
  264           fclose ( Input_file );
  265           Line_count = 0;
  266           Eof = FALSE;
  267           fputs("                              \r", stderr );
  268           }
  269   
  270       if ( !number )
  271           if ( ONLY_LIB )
  272               fatal_msg( 4, " " );
  273           else
  274               {
  275               fputs("\n     C_LIB.XRF not found or no functions found in C_LIB.XRF", stderr);
  276               fputs("\n     Cannot tell library functions and user functions apart\n\n", stderr);
  277               XR_lib = FALSE;
  278               }
  279   
  280       if ( output_flag )
  281           if ( ( Output_file = creat ( output_name )) == -1 )
  282               fatal_msg( 3, output_name );
  283           else
  284               fprintf( stderr, "Creating numbered list named %s\n", strupr ( output_name ) );
  285   
  286       if (( Input_file = fopen ( argv[1], "r" )) == FALSE )
  287           fatal_msg( 2, argv[1]);
  288   
  289       fprintf( stderr, "Using %d column width\nParsing file %s for:\n", R_margin, strupr( argv[1] ) );
  290   
  291       if ( XR_resv )
  292           fputs(" Reserved Words;", stderr);
  293   
  294       if ( XR_lib )
  295           fputs(" Library Functions;", stderr);
  296   
  297       if ( XR_func )
  298           fputs(" Function Names;", stderr);
  299   
  300       if ( XR_var )
  301           fputs(" Variables;", stderr);
  302   
  303       fputs("\b.\n", stderr);
  304   
  305       number = parse_file();
  306   
  307       fclose ( Input_file );
  308   
  309       if ( Output_file )
  310           fclose ( Output_file );
  311   
  312       print_list( number, argv[1] );
  313   
  314       fputs("\nFinished\n", stderr);
  315   
  316       }
  317   
  318   /*******************************************************************/
  319   /*                             IDENTIFICATION                      */
  320   /*    Function name: FATAL_MSG ( number , name )                   */
  321   /*    Purpose      : A fatal error has occurred. Print message     */
  322   /*                   and abort                                     */
  323   /*    Method       : print to stderr ( cannot be redirected )      */
  324   /*                   exit with error level 'number'                */
  325   /*******************************************************************/
  326   /*                             COMMUNICATION                       */
  327   /*    Formal Paramters:                                            */
  328   /*        NAME               TYPE                    USED FOR      */
  329   /*      number                int                  message number  */
  330   /*      name                  char                 special message */
  331   /*                                                                 */
  332   /*    Global Variables Needed:                                     */
  333   /*        NAME               TYPE                    USED FOR      */
  334   /*      stderr               int                standard error     */
  335   /*                                                handle           */
  336   /*    Return Value:                                                */
  337   /*                    exit value                                   */
  338   /*******************************************************************/
  339   
  340   fatal_msg( number, name )
  341       int number;
  342       char *name;
  343       {
  344       
  345       switch ( number )
  346           {
  347           case 1:
  348               fputs("You must enter a filename", stderr);
  349               break;
  350           case 2:
  351               if ( *name != '/' )         /* check if switch is only thing entered */ 
  352                   fprintf( stderr, "Cannot open source file %s", strupr ( name ) );
  353               break;
  354           case 3:
  355               fprintf( stderr, "Cannot open %s for numbered output", strupr ( name ) );
  356               break;
  357           case 4:
  358               fputs("C_LIB.XRF not found and only /L switch used", stderr);
  359               break;
  360           case 9:                  /* place holder -- currently no message */
  361               break;
  362           default:
  363               break;
  364           }
  365   
  366       fputs(  "\nUsage is:  CXREF source [/s ...] [ > list_file]", stderr);
  367   
  368       fputs("\n\n  source      the name of the 'C' file to be cross referenced ie: TEST.C", stderr);
  369       fputs(  "\n  list-file   an optional re-direction of the list to a file or printer PRN", stderr);
  370   
  371       fputs("\n\n   /R  reserved words       /F  functions  ( if /R, /L, /F, and /L are not  )", stderr);
  372       fputs(  "\n   /L  library functions    /V  variables  ( chosen then /F and /V are used )", stderr);
  373       fputs(  "\n      (needs C_LIB.XRF)", stderr);
  374   
  375       fputs("\n\n   /W[:#]    width of list  default # is 132 - must be more than 50 columns/page", stderr);
  376       fputs(  "\n   /N[:name] numbered source file - default is source with .L extension", stderr);
  377       fputs("\n\n   /?        this screen - terminates program\n\n", stderr);
  378       
  379       exit ( number );
  380       }
  381   
  382   /*******************************************************************/
  383   /*                             IDENTIFICATION                      */
  384   /*    Function name: GET_LIBRARY                                   */
  385   /*    Purpose      : read the 'C' library functions from disk      */
  386   /*                                                                 */
  387   /*    Method       : locate functions and add to linked list       */
  388   /*                                                                 */
  389   /*******************************************************************/
  390   /*                             COMMUNICATION                       */
  391   /*    Formal Paramters:                                            */
  392   /*        NAME               TYPE                    USED FOR      */
  393   /*               none                                              */
  394   /*                                                                 */
  395   /*    Global Variables Needed:                                     */
  396   /*        NAME               TYPE                    USED FOR      */
  397   /*      NAME_BUFFER           int          size of function names  */
  398   /*      FALSE                 int                                  */
  399   /*      TRUE                  int                                  */
  400   /*      Eof                   int          flag                    */
  401   /*                                                                 */
  402   /*    Return Value:                                                */
  403   /*                  TRUE if function(s) found else FALSE           */
  404   /*******************************************************************/
  405   
  406   get_library()
  407       {
  408       char word[NAME_BUFFER];
  409       int flag = FALSE;
  410       
  411       read_line(0);
  412       
  413       if (!Eof)
  414           parse_word ( word );
  415       
  416       while (!Eof)
  417           {
  418           if ( is_reserved ( word ) )
  419                ;
  420           else if ( is_function() )
  421               {
  422               add_to_library( word );
  423               flag = TRUE;
  424               }
  425   
  426           parse_word( word );
  427           }
  428   
  429       return ( flag );
  430       }
  431   
  432   /*******************************************************************/
  433   /*                             IDENTIFICATION                      */
  434   /*    Function name: ADD_TO_LIBRARY ( word )                       */
  435   /*    Purpose      : add a new function to the library list        */
  436   /*                                                                 */
  437   /*    Method       : linked list                                   */
  438   /*                                                                 */
  439   /*******************************************************************/
  440   /*                             COMMUNICATION                       */
  441   /*    Formal Paramters:                                            */
  442   /*        NAME               TYPE                    USED FOR      */
  443   /*       word                char            word to be added      */
  444   /*                                                                 */
  445   /*    Global Variables Needed:                                     */
  446   /*        NAME               TYPE                    USED FOR      */
  447   /*      TRUE                  int                                  */
  448   /*                                                                 */
  449   /*      S_library_functions   struc          variable type         */
  450   /*                                                                 */
  451   /*      Library               struct         library list          */
  452   /*        ->Following         int            pointer               */
  453   /*        ->Name              char           function name         */
  454   /*                                                                 */
  455   /*      Lib_head              struct         start of list         */
  456   /*                                                                 */
  457   /*      Blank_lib             struct         next memory location  */
  458   /*        ->Following         int            pointer               */
  459   /*                                                                 */
  460   /*    Return Value:                                                */
  461   /*                       none                                      */
  462   /*******************************************************************/
  463   
  464   add_to_library( word )
  465       char *word;
  466       {
  467       int test = TRUE;
  468       
  469       Library = &Lib_head;
  470       
  471       while ( Library->Following )
  472           {
  473           if ( ( test = strcmp ( Library->Following->Name, word)) >= 0 )
  474               break;
  475           
  476           Library = Library->Following;
  477           }
  478       
  479       if ( test )
  480           {
  481           if ( Blank_lib = malloc ( sizeof ( struct S_library_functions )))
  482               {
  483               Blank_lib->Following = Library->Following;
  484               Library->Following = Blank_lib;
  485               strcpy( Library->Following->Name, word );
  486               }
  487           }
  488       }
  489   
  490   /*******************************************************************/
  491   /*                             IDENTIFICATION                      */
  492   /*    Function name:  PARSE_FILE                                   */
  493   /*    Purpose      :  main control for locating function names in  */
  494   /*                    input file                                   */
  495   /*    Method       :  gets a function name, checks if is a reserved*/
  496   /*                    word, locates it in current words, and adds  */
  497   /*                    it to the list                               */
  498   /*                                                                 */
  499   /*******************************************************************/
  500   /*                             COMMUNICATION                       */
  501   /*    Formal Paramters:                                            */
  502   /*        NAME               TYPE                    USED FOR      */
  503   /*              none                                               */
  504   /*                                                                 */
  505   /*    Global Variables Needed:                                     */
  506   /*        NAME               TYPE                    USED FOR      */
  507   /*        Eof                int                  end of file flag */
  508   /*        NAME_BUFFER        int                  length of        */
  509   /*                                                  function name  */
  510   /*        MAX_NAMES          int                  maximum number of*/
  511   /*                                                functions allowed*/
  512   /*        Overflow           int                  too many names   */
  513   /*        stderr             int                  standard error   */
  514   /*                                                  handle         */
  515   /*        XR_resv            int                output reserved    */
  516   /*                                                words            */
  517   /*        XR_func            int                output function    */
  518   /*                                                names            */
  519   /*        XR_var             int                output variables   */
  520   /*        XR_lib             int                library functions  */
  521   /*                                                                 */
  522   /*        Line_count         int                current line in    */
  523   /*                                                input file       */
  524   /*        TRUE               int                                   */
  525   /*        FALSE              int                                   */
  526   /*                                                                 */
  527   /*    Return Value:                                                */
  528   /*                  number of functions located                    */
  529   /*******************************************************************/
  530   
  531   parse_file()
  532       {
  533       char word[ NAME_BUFFER ];         /* holds found word */
  534       int  current_word = 0;            /* position of found word in list */
  535       int  number_words = 0;            /* number of words found */
  536       int  add_flag;                    /* add name to list or not */
  537   
  538       fputs("  Lines    Words\n", stderr);
  539       fprintf( stderr, "\r %6d     %3d\r", Line_count , number_words );
  540   
  541       read_line(1);
  542   
  543       if ( !Eof )
  544           parse_word( word );
  545   
  546       while ( !Eof )
  547           {
  548           add_flag = FALSE;
  549   
  550           if ( is_reserved ( word ) )    /* logic checks if word is to be added */
  551               {
  552               if ( XR_resv )
  553                   {
  554                   add_flag = strlen ( word );
  555                   *(word + add_flag) = ' ';
  556                   *(word + add_flag + 1) = '<';
  557                   *(word + add_flag + 2) = 'R';
  558                   *(word + add_flag + 3) = '>';
  559                   *(word + add_flag + 4) = '\0';
  560                   add_flag = TRUE;
  561                   }
  562               }
  563           else if ( is_function () )
  564               {
  565               if ( is_library ( word ) )
  566                   {
  567                   if ( XR_lib )
  568                       {
  569                       add_flag = strlen( word );
  570                       *(word + add_flag) = '(';
  571                       *(word + add_flag + 1) = ' ';
  572                       *(word + add_flag + 2) = 'L';
  573                       *(word + add_flag + 3) = '\0';
  574                       add_flag = TRUE;
  575                       }
  576                   }
  577               else if ( XR_func )
  578                   {
  579                   add_flag = strlen ( word );
  580                   *(word + add_flag) = '(';
  581                   *(word + add_flag + 1) = '\0';
  582                   add_flag = TRUE;
  583                   }
  584               }
  585           else if ( XR_var )
  586               add_flag = TRUE;
  587           
  588           if ( add_flag )
  589               number_words = add_to_list ( word );
  590   
  591           fprintf( stderr, " %6d      %3d\r", Line_count , number_words );
  592   
  593           parse_word( word );
  594           }
  595   
  596       return (number_words -1);
  597       }
  598   
  599   /*******************************************************************/
  600   /*                             IDENTIFICATION                      */
  601   /*    Function name: PARSE_WORD ( word_ptr )                       */
  602   /*    Purpose      : locates the next legal function name          */
  603   /*                                                                 */
  604   /*    Method       : successively checks the line buffer until     */
  605   /*                    a) a legal function name char is found       */
  606   /*                    b) an ignore char is found                   */
  607   /*                                                                 */
  608   /*                   copies the legal name into the word_ptr and   */
  609   /*                     returns                                     */
  610   /*                                                                 */
  611   /*                   if the end of a line is reached, gets the next*/
  612   /*                     line via a function call                    */
  613   /*                                                                 */
  614   /*******************************************************************/
  615   /*                             COMMUNICATION                       */
  616   /*    Formal Paramters:                                            */
  617   /*        NAME               TYPE                    USED FOR      */
  618   /*     word_ptr              int                   function name   */
  619   /*                                                                 */
  620   /*    Global Variables Needed:                                     */
  621   /*        NAME               TYPE                    USED FOR      */
  622   /*      *Line_ptr            int                parsing input line */
  623   /*      Eof                  int                end of file flag   */
  624   /*      EOL                  char               end of line        */
  625   /*      MOL                  char               end of line buffer */
  626   /*      NAME_BUFFER          int                limiter            */
  627   /*      TRUE                 int                                   */
  628   /*      FALSE                int                                   */
  629   /*                                                                 */
  630   /*    Return Value:                                                */
  631   /*                  none                                           */
  632   /*******************************************************************/
  633   
  634   parse_word ( word_ptr )
  635       char *word_ptr;
  636       {
  637       int parse = TRUE;       /* remain in loop until false */
  638       int word = 0;           /* word found flag & length */
  639   
  640       while ( parse )
  641           {
  642           if ( isalnum( *Line_ptr ) || *Line_ptr == '_' )
  643               {
  644               if ( ( !word && isdigit( *Line_ptr ) ) || word >= NAME_LENGTH )  /* skip if first char is a number, or name is too long */
  645                   ++Line_ptr;
  646               else
  647                   {
  648                   *word_ptr++ = *Line_ptr++;
  649                   word++;
  650                   }
  651               }
  652           else if ( *Line_ptr == MOL )       /* end of buffer */
  653               read_line(0);           /* rest of line - no increment of line counter */
  654           else if ( word )
  655               parse = FALSE;          /* end of function name */
  656           else if ( *Line_ptr == EOL )       /* end of physical line */
  657               read_line(1);           /* next line - increment line counter */
  658           else if ( ignore_char() )
  659               parse_ignore();         /* single / double quotes or comments */
  660           else
  661               Line_ptr++;             /* next char */
  662   
  663           if ( Eof )
  664               parse = FALSE;
  665   
  666           }
  667       *word_ptr = '\0';
  668       }
  669   /*******************************************************************/
  670   /*                             IDENTIFICATION                      */
  671   /*    Function name: PARSE_IGNORE                                  */
  672   /*    Purpose      : to skip any chars that are in single, double  */
  673   /*                   quotes or in a comment                        */
  674   /*                                                                 */
  675   /*    Method       : look for a corresponding ignore char          */
  676   /*                                                                 */
  677   /*******************************************************************/
  678   /*                             COMMUNICATION                       */
  679   /*    Formal Paramters:                                            */
  680   /*        NAME               TYPE                    USED FOR      */
  681   /*              none                                               */
  682   /*                                                                 */
  683   /*    Global Variables Needed:                                     */
  684   /*        NAME               TYPE                    USED FOR      */
  685   /*     *Line_ptr             int                line parsing       */
  686   /*     FALSE                 int                                   */
  687   /*     Eof                   int                end of file flag   */
  688   /*     EOL                   char               end of line        */
  689   /*     MOL                   char               end of line buffer */
  690   /*                                                                 */
  691   /*    Return Value:                                                */
  692   /*                  none                                           */
  693   /*******************************************************************/
  694   
  695   parse_ignore()
  696       {
  697       char ignore;                /* current ignore char */
  698       char back_slash = 0;        /* backslash counter */
  699   
  700       if ( *Line_ptr == '\'' || *Line_ptr == '"' )
  701           ignore = *Line_ptr;
  702       else
  703           {
  704           ignore = '*';
  705           Line_ptr++;
  706           }
  707   
  708       Line_ptr++;
  709   
  710       while ( ignore )
  711           {
  712           while ( *Line_ptr != ignore && !Eof )
  713               {
  714               switch ( *Line_ptr )
  715                   {
  716                   case MOL:
  717                       read_line(0);
  718                       break;
  719                   case EOL:
  720                       read_line(1);
  721                       break;
  722                   case '\\':
  723                       back_slash++;
  724                       Line_ptr++;
  725                       break;
  726                   default:
  727                       back_slash = 0;
  728                       Line_ptr++;
  729                       break;
  730                   }
  731               }
  732           
  733           switch ( ignore )
  734               {
  735               case '\'':
  736                   {
  737                   Line_ptr++;
  738                   
  739                   if ( *Line_ptr == MOL )
  740                       read_line(0);
  741                       
  742                   if ( *Line_ptr == '\'' )
  743                       Line_ptr++;
  744                   
  745                   ignore = FALSE;
  746                   break;
  747                   }    
  748               case '"':
  749                   {
  750                   if ( !(back_slash % 2))         /* even number of backslashes immediately before " */
  751                       ignore = FALSE;
  752                   else
  753                       Line_ptr++;
  754                   
  755                   break;
  756                   }
  757               case '*':
  758                   {
  759                   Line_ptr++;
  760                   
  761                   if ( *Line_ptr == MOL )
  762                       read_line(0);
  763                   
  764                   if ( *Line_ptr == '/' )
  765                       ignore = FALSE;
  766                   
  767                   break;
  768                   }
  769               default:
  770                   break;
  771               }
  772   
  773           if ( Eof )
  774               ignore = FALSE;
  775   
  776           }
  777   
  778       Line_ptr++;             /* first char past ignore delimeter */
  779       }
  780   
  781   /*******************************************************************/
  782   /*                             IDENTIFICATION                      */
  783   /*    Function name: IGNORE_CHAR                                   */
  784   /*    Purpose      : to determine if current char is a comment,    */
  785   /*                     single, or double quote                     */
  786   /*    Method       : test                                          */
  787   /*                                                                 */
  788   /*******************************************************************/
  789   /*                             COMMUNICATION                       */
  790   /*    Formal Paramters:                                            */
  791   /*        NAME               TYPE                    USED FOR      */
  792   /*              none                                               */
  793   /*                                                                 */
  794   /*    Global Variables Needed:                                     */
  795   /*        NAME               TYPE                    USED FOR      */
  796   /*      TRUE                 int                                   */
  797   /*      FALSE                int                                   */
  798   /*      *Line_ptr            char             line pointer         */
  799   /*      MOL                  char               end of line buffer */
  800   /*                                                                 */
  801   /*    Return Value:                                                */
  802   /*             TRUE if ignore / FALSE if not                       */
  803   /*******************************************************************/
  804   
  805   ignore_char()
  806       {
  807       int flag = FALSE;
  808       
  809       switch ( *Line_ptr )
  810           {
  811           case '\'':              /* single or double quotes */
  812           case '"':
  813               flag = TRUE;
  814               break;
  815           case '/':
  816               if ( *(Line_ptr + 1) == '*' )   /* comment */
  817                   flag = TRUE;
  818               else if ( *(Line_ptr + 1) == MOL )         /* end of logical line */
  819                   {
  820                   read_line(0);
  821                   if ( *Line_ptr == '*' )     /* comment */
  822                       flag = TRUE;
  823                   }
  824               break;
  825           default:
  826               break;
  827           }
  828       
  829       return flag;
  830       }
  831   
  832   /*******************************************************************/
  833   /*                             IDENTIFICATION                      */
  834   /*    Function name:  READ_LINE ( increment )                      */
  835   /*    Purpose      :  read a line from the input file and increment*/
  836   /*                        the line counter                         */
  837   /*                                                                 */
  838   /*    Method       :  get chars from file up to buffer size        */
  839   /*                                                                 */
  840   /*******************************************************************/
  841   /*                             COMMUNICATION                       */
  842   /*    Formal Paramters:                                            */
  843   /*        NAME               TYPE                    USED FOR      */
  844   /*      increment            int           if the previous read did*/
  845   /*                                         not get the entire line,*/
  846   /*          does not increment the line counter, if the entire line*/
  847   /*          was read, does increment the line counter              */
  848   /*                                                                 */
  849   /*    Global Variables Needed:                                     */
  850   /*        NAME               TYPE                    USED FOR      */
  851   /*     Line_ptr              int             buffer pointer        */
  852   /*     Input_file            int             file handle           */
  853   /*     Line_buf              char            line buffer           */
  854   /*     Eof                   int             end of file flag      */
  855   /*     BUF_SIZE              int             length of line buffer */
  856   /*     Line_count            int             physycal line counter */
  857   /*     TRUE                  int                                   */
  858   /*     FALSE                 int                                   */
  859   /*                                                                 */
  860   /*    Return Value:                                                */
  861   /*                  none                                           */
  862   /*******************************************************************/
  863   
  864   read_line ( increment )
  865       int increment;
  866       {
  867   
  868       Line_count += increment;
  869   
  870       if ( fgets( Line_buf, BUF_SIZE, Input_file ) )
  871           Eof = FALSE;
  872       else
  873           Eof = TRUE;
  874   
  875       Line_ptr = Line_buf;
  876   
  877       if ( Output_file )
  878           {
  879           if ( increment )
  880               fprintf ( Output_file, "%5d   %s", Line_count, Line_buf);
  881           else
  882               fprintf ( Output_file, "%s", Line_buf);
  883           }
  884   
  885       }
  886   
  887   /*******************************************************************/
  888   /*                             IDENTIFICATION                      */
  889   /*    Function name: IS_RESERVED ( function )                      */
  890   /*    Purpose      : find if function is a reserved word           */
  891   /*                                                                 */
  892   /*    Method       : sequentially check reserved word list         */
  893   /*                                                                 */
  894   /*    Note         : the reserved word list is taken from page 180 */
  895   /*          ' The C Programming Language ' by  Brian W. Kernighan  */
  896   /*                                             Dennis M. Ritchie   */
  897   /*                                                                 */
  898   /*******************************************************************/
  899   /*                             COMMUNICATION                       */
  900   /*    Formal Paramters:                                            */
  901   /*        NAME               TYPE                    USED FOR      */
  902   /*     function              char                name of function  */
  903   /*                                                                 */
  904   /*    Global Variables Needed:                                     */
  905   /*        NAME               TYPE                    USED FOR      */
  906   /*      TRUE                 int                                   */
  907   /*      FALSE                int                                   */
  908   /*                                                                 */
  909   /*    Return Value:                                                */
  910   /*                TRUE if found / FALSE if not found               */
  911   /*******************************************************************/
  912   
  913   is_reserved( function )
  914       char *function;
  915       {
  916       int max = 28;           /* number of reserved words */
  917   
  918       static char reserved_list[28][8] = "int",     "char",    "float",
  919         "double",  "struct",  "union",   "long",    "short",   "unsigned",
  920         "auto",    "extern",  "register","typedef", "static",  "goto",
  921         "return",  "sizeof",  "break",   "continue","if",      "else",
  922         "for",     "do",      "while",   "switch",  "case",    "default",
  923         "entry";
  924   
  925       char flag = FALSE;      /* return value */
  926       int search;             /* counter */
  927   
  928       for ( search = 0; search < max; search++)
  929           if ( !strcmp( reserved_list [ search ] , function) )
  930               {
  931               flag = TRUE;
  932               break;
  933               }
  934   
  935       return flag;
  936       }
  937   
  938   /*******************************************************************/
  939   /*                             IDENTIFICATION                      */
  940   /*    Function name: IS_LIBRARY ( word )                           */
  941   /*    Purpose      : find if word is a library function            */
  942   /*                                                                 */
  943   /*    Method       : sequentially search library linked list       */
  944   /*                                                                 */
  945   /*******************************************************************/
  946   /*                             COMMUNICATION                       */
  947   /*    Formal Paramters:                                            */
  948   /*        NAME               TYPE                    USED FOR      */
  949   /*       word                char           word to be tested      */
  950   /*                                                                 */
  951   /*    Global Variables Needed:                                     */
  952   /*        NAME               TYPE                    USED FOR      */
  953   /*      FALSE                 int                                  */
  954   /*      TRUE                  int                                  */
  955   /*      Library               struct        library linked list    */
  956   /*        ->Following         int           pointer                */
  957   /*        ->Name              char          library function name  */
  958   /*      Lib_head              struct        start of library list  */
  959   /*                                                                 */
  960   /*    Return Value:                                                */
  961   /*                  TRUE if word is library functionelse FALSE     */
  962   /*******************************************************************/
  963   
  964   is_library( word )
  965       char *word;
  966       {
  967       int flag = FALSE;
  968   
  969       Library = &Lib_head;
  970   
  971       while ( Library->Following )
  972           {
  973           if ( !strcmp ( Library->Following->Name, word) )
  974               {
  975               flag = TRUE;
  976               break;
  977               }
  978   
  979           Library = Library->Following;
  980           }
  981   
  982       return ( flag );
  983       }
  984   
  985   /*******************************************************************/
  986   /*                             IDENTIFICATION                      */
  987   /*    Function name: IS_FUNCTION                                   */
  988   /*    Purpose      : to check if function is a function            */
  989   /*                                                                 */
  990   /*    Method       : next non white space char must be a '('       */
  991   /*                                                                 */
  992   /*******************************************************************/
  993   /*                             COMMUNICATION                       */
  994   /*    Formal Paramters:                                            */
  995   /*        NAME               TYPE                    USED FOR      */
  996   /*                  none                                           */
  997   /*    Global Variables Needed:                                     */
  998   /*        NAME               TYPE                    USED FOR      */
  999   /*     *Line_ptr              int                   line pointer   */
 1000   /*     EOL                    char                  end of logical */
 1001   /*                                                     line        */
 1002   /*     Eof                    int                   end of file    */
 1003   /*     MOL                    char              end of line buffer */
 1004   /*     TRUE                   int                                  */
 1005   /*     FALSE                  int                                  */
 1006   /*                                                                 */
 1007   /*    Return Value:                                                */
 1008   /*             TRUE if function name / FALSE if not                */
 1009   /*******************************************************************/
 1010   
 1011   is_function()
 1012       {
 1013       int flag = TRUE;
 1014   
 1015       while ( flag )
 1016           {
 1017           switch ( *Line_ptr )
 1018               {
 1019               case ' ':
 1020               case '\t':
 1021                   Line_ptr++;
 1022                   break;
 1023               case EOL:
 1024                   read_line(1);
 1025                   break;
 1026               case MOL:
 1027                   read_line(0);
 1028                   break;
 1029               default:
 1030                   flag = FALSE;
 1031                   break;
 1032               }
 1033   
 1034           if ( Eof )
 1035               flag = FALSE;
 1036           }
 1037   
 1038       if ( *Line_ptr == '(' )
 1039           flag = TRUE;
 1040       else
 1041           flag = FALSE;
 1042   
 1043       return flag;
 1044       }
 1045   
 1046   /*******************************************************************/
 1047   /*                             IDENTIFICATION                      */
 1048   /*    Function name: ADD_TO_LIST ( function )                      */
 1049   /*    Purpose      : add a function to list, with current line no. */
 1050   /*                                                                 */
 1051   /*    Method       : copy function name, find last number and add  */
 1052   /*                   if needed add new link to list                */
 1053   /*                                                                 */
 1054   /*******************************************************************/
 1055   /*                             COMMUNICATION                       */
 1056   /*    Formal Paramters:                                            */
 1057   /*        NAME               TYPE                    USED FOR      */
 1058   /*     function              char              name of function    */
 1059   /*                                                                 */
 1060   /*    Global Variables Needed:                                     */
 1061   /*        NAME               TYPE                    USED FOR      */
 1062   /*      TRUE                  int                                  */
 1063   /*      FALSE                 int                                  */
 1064   /*      NUL                   int                                  */
 1065   /*      MAX_LINES             int             number of lines/link */
 1066   /*                                                                 */
 1067   /*      S_function_name       struct          variable type        */
 1068   /*                                                                 */
 1069   /*      Function              struct          function name list   */
 1070   /*        ->Following         int             pointer              */
 1071   /*        ->Name              char            function name        */
 1072   /*        ->Too_many_lines    int             flag                 */
 1073   /*        ->First_line        int             pointer              */
 1074   /*        ->Curr_line         int             pointer              */
 1075   /*          ->Space_left      int             flag and counter     */
 1076   /*          ->Number[]        int             line number          */
 1077   /*                                                                 */
 1078   /*      Head                  struct          start of list        */
 1079   /*                                                                 */
 1080   /*      Blank_name            struct          next blank spot      */
 1081   /*        ->Following         int             pointer              */
 1082   /*        ->Too_many_lines    int             flag                 */
 1083   /*                                                                 */
 1084   /*      Blank_line            struct          next blank line      */
 1085   /*      Overflow              int             flag and counter     */
 1086   /*      Line_count            int             current line number  */
 1087   /*                                                                 */
 1088   /*    Return Value:                                                */
 1089   /*                     number                                      */
 1090   /*******************************************************************/
 1091   
 1092   add_to_list( name )
 1093       char *name;
 1094       {
 1095       static int number = 0;      /* counter for number of names found */
 1096       int test = TRUE;               /* flag for found name in list compare */
 1097       
 1098       Function = &Head;
 1099   
 1100       while ( Function->Following )
 1101           {
 1102           if ( ( test = strcmp( Function->Following->Name, name )) >= 0 )
 1103               break;
 1104   
 1105           Function = Function->Following;
 1106           }
 1107   
 1108       if ( test )
 1109           {
 1110           if ( Blank_name && Blank_line )
 1111               {
 1112               number++;
 1113   
 1114               Blank_name->Following = Function->Following;
 1115               Function->Following = Blank_name;
 1116               strcpy( Function->Following->Name, name );
 1117               Function->Following->First_line = Function->Following->Curr_line = Blank_line;
 1118               Function->Following->Curr_line->Number [ MAX_LINES - Function->Following->Curr_line->Space_left ] = Line_count;
 1119               Function->Following->Curr_line->Space_left--;
 1120   
 1121               if ( Blank_name = malloc ( sizeof ( struct S_function_name )))
 1122                   {
 1123                   Blank_name->Following = NUL;
 1124                   Blank_name->Too_many_lines = FALSE;
 1125                   }
 1126   
 1127               new_blank_line();
 1128               }
 1129           else
 1130               Overflow++;
 1131           }
 1132       else
 1133           {
 1134           if ( Function->Following->Curr_line->Space_left )
 1135               {
 1136               Function->Following->Curr_line->Number [ MAX_LINES - Function->Following->Curr_line->Space_left ] = Line_count;
 1137               Function->Following->Curr_line->Space_left--;
 1138               }
 1139           else
 1140               {
 1141               if ( Blank_line )
 1142                   {
 1143                   Function->Following->Curr_line = Function->Following->Curr_line->Following = Blank_line;
 1144                   Function->Following->Curr_line->Number [ MAX_LINES - Function->Following->Curr_line->Space_left ] = Line_count;
 1145                   Function->Following->Curr_line->Space_left--;
 1146                   new_blank_line();
 1147                   }
 1148               else
 1149                   Function->Following->Too_many_lines = TRUE;
 1150               }
 1151           }
 1152       return number;
 1153       }
 1154   
 1155   /*******************************************************************/
 1156   /*                             IDENTIFICATION                      */
 1157   /*    Function name: NEW_BLANK_LINE                                */
 1158   /*    Purpose      : get a new blank line structure                */
 1159   /*                                                                 */
 1160   /*    Method       : obtain a block of memory from the system      */
 1161   /*                                                                 */
 1162   /*******************************************************************/
 1163   /*                             COMMUNICATION                       */
 1164   /*    Formal Paramters:                                            */
 1165   /*        NAME               TYPE                    USED FOR      */
 1166   /*                 none                                            */
 1167   /*                                                                 */
 1168   /*    Global Variables Needed:                                     */
 1169   /*        NAME               TYPE                    USED FOR      */
 1170   /*     S_line_numbers        struct          variable type         */
 1171   /*                                                                 */
 1172   /*     Blank_line            struct          address of block      */
 1173   /*      .Space_left            int           flag                  */
 1174   /*      .Following             int           pointer               */
 1175   /*      .Number[]              int           holds line numbers    */
 1176   /*                                                                 */
 1177   /*    Return Value:                                                */
 1178   /*                     none                                        */
 1179   /*******************************************************************/
 1180   
 1181   new_blank_line()
 1182       {
 1183       int count;          /* general purpose counter */
 1184   
 1185       if ( Blank_line = malloc ( sizeof ( struct S_line_numbers ) ) )
 1186           {
 1187           Blank_line->Space_left = MAX_LINES ;
 1188           Blank_line->Following = NUL;
 1189   
 1190           for ( count = 0; count < MAX_LINES; count++)
 1191               Blank_line->Number [ count ] = 0;
 1192           }
 1193       }
 1194   
 1195   /*******************************************************************/
 1196   /*                             IDENTIFICATION                      */
 1197   /*    Function name: PRINT_LIST ( number , name )                  */
 1198   /*    Purpose      : prints list of function names and line numbers*/
 1199   /*                   to the screen. can be redirected              */
 1200   /*                                                                 */
 1201   /*    Method       : O/P to screen                                 */
 1202   /*                                                                 */
 1203   /*******************************************************************/
 1204   /*                             COMMUNICATION                       */
 1205   /*    Formal Paramters:                                            */
 1206   /*        NAME               TYPE                    USED FOR      */
 1207   /*       name               char            name of input file     */
 1208   /*                                                                 */
 1209   /*    Global Variables Needed:                                     */
 1210   /*        NAME               TYPE                    USED FOR      */
 1211   /*    TRUE                  int                                    */
 1212   /*    FALSE                 int                                    */
 1213   /*    MAX_LINES             int                max lines per link  */
 1214   /*                                                                 */
 1215   /*    Function              struct             function name list  */
 1216   /*      ->Following         int                pointer             */
 1217   /*      ->Name              char               function name       */
 1218   /*      ->Too_many_lines    int                flag                */
 1219   /*      ->First_line        int                pointer             */
 1220   /*        ->Number[]        int                line number list    */
 1221   /*        ->Following       int                pointer             */
 1222   /*                                                                 */
 1223   /*    Head                  struct             start of functions  */
 1224   /*                                                                 */
 1225   /*    Overflow              int                  too many names    */
 1226   /*    R_margin              int                  width of screen   */
 1227   /*    XR_resv               int                output reserved     */
 1228   /*                                                words            */
 1229   /*    XR_func               int                output function     */
 1230   /*                                                names            */
 1231   /*    XR_var                int                output variables    */
 1232   /*    XR_lib                int                library functions   */
 1233   /*    stderr                int                standard error      */
 1234   /*                                                handle           */
 1235   /*    Return Value:                                                */
 1236   /*                   none                                          */
 1237   /*******************************************************************/
 1238   
 1239   print_list( number, name )
 1240       int number;
 1241       char *name;
 1242       {
 1243       int line_flag;              /* flag */
 1244       int col;                    /* counter */
 1245       int count;                  /* counter */
 1246       int margin;                 /* current margin */
 1247       int max_length = 0;         /* longest name */
 1248   
 1249       fputs("\nPrinting\n" , stderr );
 1250   
 1251       Function = &Head;
 1252   
 1253       while ( Function->Following )
 1254           {
 1255           count = strlen ( Function->Following->Name );
 1256           max_length = ( count > max_length ) ? count : max_length;
 1257           Function = Function->Following;
 1258           }
 1259   
 1260       max_length += 2;
 1261   
 1262       puts("\n\nC Cross Reference Utility - version 1.10\n  by Wojtek Bok\n\n");
 1263       puts("Cross Reference for:\n");
 1264   
 1265       if ( XR_resv )
 1266           puts("            Reserved Words\n");
 1267   
 1268       if ( XR_lib )
 1269           puts("            Library Functions\n");
 1270   
 1271       if ( XR_func )
 1272           puts("            Function Names\n");
 1273   
 1274       if ( XR_var )
 1275           puts("            User Variables\n");
 1276   
 1277       printf("\nFilename  :%15s\nReferences:%15d\n\n", strupr(name) , number + 1 );
 1278   
 1279       puts("    Name");
 1280       for ( col = max_length; col > 0; col--)
 1281           puts(" ");
 1282       puts("Line Number\n\n");
 1283   
 1284       Function = &Head;
 1285   
 1286       while ( Function->Following )
 1287           {
 1288           fprintf( stderr, "  %6d \r", number-- );
 1289   
 1290           puts( Function->Following->Name );
 1291           count = max_length - strlen( Function->Following->Name ) - 1; 
 1292           puts (" ");
 1293           while ( count-- )
 1294               puts(".");
 1295   
 1296           margin = max_length;
 1297           col = 0;
 1298           line_flag = TRUE;
 1299   
 1300           while ( line_flag )
 1301               {
 1302               if ( margin + 6 >= R_margin )
 1303                   {
 1304                   puts("\n");
 1305                   for ( count = max_length; count > 0; count--)
 1306                       puts(" ");
 1307                   margin = max_length;
 1308                   }
 1309               printf("%6d", Function->Following->First_line->Number [ col++ ] );
 1310               margin += 6;
 1311   
 1312               if ( col >= MAX_LINES )
 1313                   {
 1314                   Function->Following->First_line = Function->Following->First_line->Following;
 1315                   col = 0;
 1316                   }
 1317   
 1318               if ( !Function->Following->First_line || Function->Following->First_line->Number [ col ] == 0 )
 1319                   line_flag = FALSE;
 1320   
 1321               }
 1322   
 1323           if ( Function->Following->Too_many_lines )
 1324               {
 1325               if ( margin + 6 >= R_margin )
 1326                   {
 1327                   puts("\n");
 1328                   for ( count = max_length; count > 0; count--)
 1329                       puts(" ");
 1330                   }
 1331               puts("<OVER>");         /* too many line numbers */
 1332               }
 1333   
 1334           puts("\n");
 1335   
 1336           Function = Function->Following;
 1337   
 1338           }
 1339   
 1340       if ( Overflow )
 1341           {
 1342           puts("\n\n ************ Ran out of memory during run ***********\n");
 1343           printf(   "************ %6d functions not found   ***********\n", Overflow );
 1344           }
 1345   
 1346       co(12);
 1347       }
 1348   
 1349   /* end of CXREF */
 1350   