;;;	hayes - CIOS for MITE utility / Hayes Micromodem 100 verison
;
;	L.E. Hughes
;
;	Mycroft Labs, Inc.
;	P.O. Box 6045
;	Tallahassee, FL 32301
;
;	(904) 385-2708

base	equ	080H		;base of Hayes modem board
 
cr	equ	0DH		;carriage return
lf	equ	0AH		;line feed
eos	equ	'$'		;end of string
 
	org	180H

;;	jump vector
;
 
	jmp	initm
	jmp	modin
	jmp	modout
	jmp	chkrr
	jmp	chktr
	jmp	chkcd
	jmp	chkpe
	jmp	chkfe
	jmp	chkoe
	jmp	chkri
	jmp	setbr
	jmp	setpar
	jmp	set8db
	jmp	set2sb
	jmp	setorg
	jmp	setoh
	jmp	settxe
	jmp	setbrk
	jmp	dial
	jmp	tenths
	jmp	w1ms

;;;	initm - initialize modem
;;

initm:	mvi	a,00000101B
	sta	cr1
	mvi	a,00000111B
	sta	cr2
	ret
 
;;;	modin - input character from modem
;
;	exit:	A	character from modem
 
modin:	in	base+0		;read data port
	ret

;;;	modout - output character to modem
;
;	entry:	A	character for modem

modout:	out	base+0		;write data port
	ret
 
;;;	chkrr - check for receiver ready
;
;	exit:	c-flag	set if character available

chkrr:	in	base+1		;check status port 1
	ani	01H		;mask off data avail. bit
	rz			;exit if no data available
	stc			;exit with carry set
	ret
 
;;;	chktr - check for tranmitter ready
;
;	exit:	c-flag	set if transmitter ready

chktr:	in	base+1		;check status port 1
	ani	02H		;mask off trans. ready bit
	rz			;exit if not ready
	stc			;exit with carry set
	ret

;;	chkcd - check for carrier detect
;
;	exit:	c-flag	set if carrier present

chkcd:	in	base+1		;check status port 2
	ani	40H		;mask off CTS bit
	rz			;exit if no carrier
	stc			;exit with carry set
	ret

;;;	chkpe - check for parity error
;
;	exit:	c-flag set if parity error
 
chkpe:	in	base+1		;check status port 0
	ani	04H		;mask off parity error bit
	rz			;exit if no parity error
	stc			;return with carry set
	ret
 
;;;	chkfe - check for frame error
;
;	exit:	c-flag set if frame error
 
chkfe:	in	base+1		;check status port 0
	ani	08H		;mask off frame error bit
	rz			;exit if no frame error
	stc			;return with carry set
	ret
 
;;;	chkoe - check for overrun error
;
;	exit:	c-flag set if overrun error
 
chkoe:	in	base+1		;check status port 0
	ani	10H		;mask off overrun error bit
	rz			;exit if no overrun error
	stc			;return with carry set
	ret
 
;;;	chkri - check for ring indicate
;
;	exit:	c-flag	set if incoming call
 
chkri:	in	base+1
	cma			;active low
	ani	80H
	rz
	stc
	ret
 
;;;	setbr - set baud rate
;
;	entry:	HL	baud rate
;
;	exit:	c-flag	set if error
 
setbr:	lxi	d,110		;jump if not 110
	call	cmpde
	jnz	setbr1
	mvi	b,01H		;select 110 baud
	call	cr2off
	ora	a
	ret
setbr1:	lxi	d,300		;jump if not 300
	call	cmpde
	jnz	setbr2
	mvi	b,01H		;select 300 baud
	call	cr2on
	ora	a
	ret
setbr2:	stc
	ret
 
;;;	setpar - set parity
;
;	entry:	A	parity select code:
;				0 = NONE
;				1 = ODD
;				2 = EVEN

setpar:	ora	a		;jump if A .ne. 0
	jnz	setp1
	mvi	b,10H		;PARITY INHIBIT on
	jmp	cr1on
setp1:	dcr	a		;jump if A .ne. 1
	jnz	setp2
	mvi	b,10H		;PARITY INHIBIT off
	call	cr1off
	mvi	b,01H		;EVEN PARITY ENABLE off
	jmp	cr1off
setp2:	mvi	b,10H		;PARITY INHIBIT off
	call	cr1off
	mvi	b,01H		;EVEN PARITY ENABLE on
	jmp	cr1on

;;;	set8db - set number of data bits
;
;	entry:	A	data bits select code:
;				0 = 7 data bits
;				1 = 8 data bits

set8db:	mvi	b,04H		;LS2 on 
	call	cr1on
	ora	a		;jump if A .ne. 0
	jnz	set8d1
	mvi	b,02H		;LS1 off
	jmp	cr1off
set8d1:	mvi	b,02H		;LS1 on
	jmp	cr1on
 
;;;	set2sb - set number of stop bits
;
;	entry:	A	stop bits select code:
;				0 = 1 stop bit
;				1 = 2 stop bits
 
set2sb:	ora	a		;jump if A .ne. 0
	jnz	set2s1
	mvi	b,08H		;TWO STOP BITS off
	jmp	cr1off
set2s1:	mvi	b,08H		;TWO STOP BITS on
	jmp	cr1on
 
;;;	setorg - set modem mode (answer or originate)
;
;	entry:	A	mode select code:
;				0 = answer
;				1 = originate

setorg:	ora	a		;jump if A .ne. 0
	jnz	setor1
	mvi	b,04H		;MS off
	jmp	cr2off
setor1:	mvi	b,04H		;MS on
	jmp	cr2on
 
;;;	setoh - set phone "off hook"
;
;	entry:	A	hook select code:
;				0 = on hook (hung up)
;				1 = off hook
 
setoh:	ora	a		;jump if A .ne. 0
	jnz	setoh1
	mvi	b,80H		;SWITCH HOOK off
	jmp	cr2off
setoh1:	mvi	b,80H		;SWITCH HOOK on
	jmp	cr2on

;;;	settxe - set transmitter enable
;
;	entry:	A	transmitter enable code:
;				0 = disabled
;				1 = enabled
 
settxe:	ora	a		;jump if A .ne. 0 (enabled)
	jnz	settx1
	mvi	b,02H		;DTR off
	jmp	cr2off
settx1:	mvi	b,02H		;DTR on
	jmp	cr2on 
 
;;;	setbrk - set communications line break
;
;	entry:	A	break enable code:
;				0 = normal
;				1 = break
 
setbrk:	ora	a		;jump if A .ne. 0 (break)
	jnz	setbk1
	mvi	b,08H
	jmp	cr2off
setbk1:	mvi	b,08H
	jmp	cr2on

;;;	cr1on - turn on bit(s) on modem control register one
;
;	entry:	B	ones in bit position(s) to turn on

cr1on:	push	psw
	lda	cr1
	ora	b
	sta	cr1
	out	base+1
	pop	psw
	ret
 
;;;	cr1off - turn off bit(s) on modem control register one
;
;	entry:	B	ones in bit position(s) to turn off

cr1off:	push	psw
	mov	a,b
	cma
	mov	b,a
	lda	cr1
	ana	b
	sta	cr1
	out	base+1
	pop	psw
	ret
 
;;;	cr2on - turn on bit(s) on modem control register two
;
;	entry:	B	ones in bit position(s) to turn on

cr2on:	push	psw
	lda	cr2
	ora	b
	sta	cr2
	out	base+2
	pop	psw
	ret
 
;;;	cr2off - turn off bit(s) on modem control register two
;
;	entry:	B	ones in bit position(s) to turn off

cr2off:	push	psw
	mov	a,b
	cma
	mov	b,a
	lda	cr2
	ana	b
	sta	cr2
	out	base+2
	pop	psw
	ret

;;;	cmpde - compare de to hl
;
;	exit:	c-flag	set if de < hl
;		z-flag	set if de = hl

cmpde:	mov	a,h
	cmp	d
	rnz
	mov	a,l
	cmp	e
	ret
 
;;;	dial - dial phone number
;
;	entry:	HL	points to phone number, term by 0 byte

dial:	mov	a,m		;fetch next digit of number
	ora	a		;exit if zero
	rz
	inx	h		;increment pointer
	cpi	'*'		;jump if not asterisk
	jnz	dial2
	mvi	b,10		;wait 1 second
	call	tenths
	jmp	dial4		;continue
dial2:	sui	'0'		;convert ASCII to binary
	jc	dial4		;ignore if < '0'
	cpi	10		;ignore if > '9'
	jnc	dial4
	ora	a		;jump if not zero 
	jnz	dial3
	mvi	a,10		;use 10 clicks for zero
dial3:	mov	b,a		;b = number of clicks
dial3a:	push	b
	mvi	b,80H		;go on-hook
	call	cr2off
	call	wait50		;wait 50 msec
	mvi	b,80H		;go back off hook
	call	cr2on
	call	wait50		;wait 50 msec
	pop	b
	dcr	b		;decrement click count
	jnz	dial3a		;loop until zero
	mvi	b,7		;interdigit wait (.7 sec)
	call	tenths
dial4:	jmp 	dial

;;	tenths - wait B tenths of a second
;
;	entry:	B	number of tenths of a second to wait

tenths:	call	tenth
	dcr	b
	jnz	tenths
	ret
 
;;	tenth - wait 1 tenth of a second
;
 
tenth:	push	b
	mvi	b,100
tenth1:	call	w1ms
	dcr	b
	jnz	tenth1
	pop	b
	ret

;;	wait50 - wait 50 msec
;
 
wait50:	push	b
	mvi	b,50
wait51:	call	w1ms
	dcr	b
	jnz	wait51
	pop	b
	ret
 
;;	w1ms - wait one millisecond
;
 
w1ms:	push	psw
	push	h
	lxi	h,160
w1ms1:	dcx	h
	mov	a,h
	ora	l
	jnz	w1ms1
	pop	h
	pop	psw
	ret
 
rate:	ds	2		;temp storage for baud rate
tocnt:	ds	2		;time-out count
timer:	ds	2		;timer for RACM

cr1:	ds	1		;current control register 1
cr2:	ds	1		;current control register 2

	end	hayes
