;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
	PUBLIC	PRNBUF,CONBUF,AUXBUF

;	These are the output buffers for the PRN, AUX, and CON devices.
;	the first byte != 0 if a character is waiting, the second byte
;	is the character.

PRNBUF	DW	0		; PRN character buffer
AUXBUF	DW	0		; AUX character buffer
CONBUF	DW	0		; CON character buffer

;
; Character I/O routines
;

; Special keys recognized by the BIOS
;
; These are the key codes generated by the keyboard processor. The key codes
; can be modified to be any key code the user wants. Note however that the
; key code chosen will NOT be placed in the type-ahead buffer, and so will
; never get passed to the system (or ZBASIC or others). Some other key
; choices and their codes are:
;
;	Shift break	-	0EAH
;	Shift I LINE	-	0E4H
;	HELP		-	095H
;	Shift HELP	-	0D5H
;
; For an entire list of key codes, see the Z100 technical manual in the
; keyboard section.
;

SPECIAL_KEY		EQU 0AAH	; "BREAK" key - clear type ahead
PRINT_SCREEN_KEY	EQU 0E2H	; Shift F12, print screen key

;	Combinations of light pens/terminals have a latency when reporting
;	a light pen hit. Some of this is built into the hardware, and the
;	following value is an estimate, which is deducted from the value
;	obtained from the hardware, which compensates for this. Users with
;	non-standard terminals and light pens (no "standard" light pen is
;	yet spec'd) will have to adjust even further in software.
;
;	This is only in full character positions, so the closest we
;	can get is to within 1 character. The pixel adjustment is
;	left to the user, since it is felt that this is much less
;	critical than the full character adjustment

LPERROR	EQU	5		; 5 character positions off

;
; Data used by Character I/O routines
;


VSYNC_CNT	DW 0		; Number of unserviced vsyncs seen
VSYNC_MAX	EQU 5		; Max number before force of service
VIDEO_ROM	DB ?		; Value of video control bits seen by ROM
VIDEO_PGM	DB ?		; Value of video control bits seen by program

; Input queue for the Console

CQ_ZCON	LABEL	BYTE			; Input queue descriptor for console
	ERRNZ	CQ_ZCON,CQ_SADDR
	DW	OFFSET Q_ZCON 		; Addr of start of queue
	ERRNZ	CQ_ZCON,CQ_EADDR
	DW	(OFFSET Q_ZCON)+ZCON_IQS-1	; Addr of end of queue
	ERRNZ	CQ_ZCON,CQ_QSIZE
	DW	ZCON_IQS		; Size of queue
	ERRNZ	CQ_ZCON,CQ_ELMTS
	DW	0			; Current number of elements in queue
	ERRNZ	CQ_ZCON,CQ_STATUS
	DB	0			; Current error status
	ERRNZ	CQ_ZCON,CQ_FRONT
	DW	OFFSET Q_ZCON		; Addr of front element in queue
	ERRNZ	CQ_ZCON,CQ_REAR
	DW	(OFFSET Q_ZCON)+ZCON_IQS-1	; Addr of rear elem in queue
	ERRNZ	CQ_ZCON,CQ_SEGM
	DW	0			; Segment of que
	ERRNZ	CQ_ZCON,CQ_SIZE


; Input queue for ZSERA 2661 USART


CQ_ZSERA LABEL	BYTE			; queue descriptor for ZSERA port
	ERRNZ	CQ_ZSERA,CQ_SADDR
	DW	OFFSET Q_ZSERA		; Addr of start of queue
	ERRNZ	CQ_ZSERA,CQ_EADDR
	DW	(OFFSET Q_ZSERA)+ZSERA_IQS-1 ; Addr of end of queue
	ERRNZ	CQ_ZSERA,CQ_QSIZE
	DW	ZSERA_IQS		; Size of queue
	ERRNZ	CQ_ZSERA,CQ_ELMTS
	DW	0			; Current number of elements in queue
	ERRNZ	CQ_ZSERA,CQ_STATUS
	DB	0			; Current error status
	ERRNZ	CQ_ZSERA,CQ_FRONT
	DW	OFFSET Q_ZSERA		; Addr of front element in queue
	ERRNZ	CQ_ZSERA,CQ_REAR
	DW	(OFFSET Q_ZSERA)+ZSERA_IQS-1 ; Addr of rear elem in queue
	ERRNZ	CQ_ZSERA,CQ_SEGM
	DW	0			; Segment of que
	ERRNZ	CQ_ZSERA,CQ_SIZE

; Input queue for ZSERB 2661 USART

CQ_ZSERB LABEL	BYTE			; queue descriptor for ZSERB port
	ERRNZ	CQ_ZSERB,CQ_SADDR
	DW	OFFSET Q_ZSERB		; Addr of start of queue
	ERRNZ	CQ_ZSERB,CQ_EADDR
	DW	(OFFSET Q_ZSERB)+ZSERB_IQS-1 ; Addr of end of queue
	ERRNZ	CQ_ZSERB,CQ_QSIZE
	DW	ZSERB_IQS		; Size of queue
	ERRNZ	CQ_ZSERB,CQ_ELMTS
	DW	0			; Current number of elements in queue
	ERRNZ	CQ_ZSERB,CQ_STATUS
	DB	0			; Current error status
	ERRNZ	CQ_ZSERB,CQ_FRONT
	DW	OFFSET Q_ZSERB		; Addr of front element in queue
	ERRNZ	CQ_ZSERB,CQ_REAR
	DW	(OFFSET Q_ZSERB)+ZSERB_IQS-1 ; Addr of rear elem in queue
	ERRNZ	CQ_ZSERB,CQ_SEGM
	DW	0			; Segment of que
	ERRNZ	CQ_ZSERB,CQ_SIZE


; Control table for the PRN: device

CID_PRN	LABEL	BYTE			; device control table for PRN:
	ERRNZ	CID_PRN,CID_CHRD
CHRD_PRN LABEL BYTE			;  Configuration table for PRN:
	ERRNZ	CHRD_PRN,CHRD_CLASS
	DB	CHRDCL_SER		; Serial printer
	ERRNZ	CHRD_PRN,CHRD_ATTR
	DB	0			; No special attributes
	ERRNZ	CHRD_PRN,CHRD_PORT
	DW	ZSERA			; First 2661
	ERRNZ	CHRD_PRN,CHRD_BAUD
	DB	BD480			; 4800 baud
	ERRNZ	CHRD_PRN,CHRD_HSHK
	DB	CHRDH_DCDH		; DCD Positive
	ERRNZ	CHRD_PRN,CHRD_BCTL
	DB	CHRDB_SB1+CHRDB_CL8	; 1 stop bit, no parity, 8 data bits
	ERRNZ	CHRD_PRN,CHRD_ECNT
	DB	0			; No ETX/ACK count
	ERRNZ	CHRD_PRN,CHRD_NCNT
	DB	0			; Don't send null's
	ERRNZ	CHRD_PRN,CHRD_NCHR
	DB	0			; Character to pad
	ERRNZ	CHRD_PRN,CHRD_RES
	DB	6 DUP (0)		; Reserved
	ERRNZ	CHRD_PRN,CHRD_SIZE
	DB	CID_SIZE-CHRD_SIZE DUP (0)
	ERRNZ	CID_PRN,CID_SIZE


; Control table for the AUX: device

CID_AUX	LABEL	BYTE			; device control table for AUX:
	ERRNZ	CID_AUX,CID_CHRD
CHRD_AUX LABEL BYTE			;  Configuration table for AUX:
	ERRNZ	CHRD_AUX,CHRD_CLASS
	DB	CHRDCL_SER		; Serial printer
	ERRNZ	CHRD_AUX,CHRD_ATTR
	DB	0			; No special attributes
	ERRNZ	CHRD_AUX,CHRD_PORT
	DW	ZSERB			; Second 2661
	ERRNZ	CHRD_AUX,CHRD_BAUD
	DB	BD960			; 9600 baud
	ERRNZ	CHRD_AUX,CHRD_HSHK
	DB	CHRDH_NO		; No handshake
	ERRNZ	CHRD_AUX,CHRD_BCTL
	DB	CHRDB_SB1+CHRDB_CL8	; 1 stop bit, no parity, 8 data bits
	ERRNZ	CHRD_AUX,CHRD_ECNT
	DB	0			; No ETX/ACK count
	ERRNZ	CHRD_AUX,CHRD_NCNT
	DB	0			; Don't send null's
	ERRNZ	CHRD_AUX,CHRD_NCHR
	DB	0			; No pad character
	ERRNZ	CHRD_AUX,CHRD_RES
	DB	6 DUP (0)		; Reserved
	ERRNZ	CHRD_AUX,CHRD_SIZE
	DB	CID_SIZE-CHRD_SIZE DUP (0)
	ERRNZ	CID_AUX,CID_SIZE


; Control table for the CON: device

CID_CON	LABEL	BYTE			; device control table for CON:
	ERRNZ	CID_CON,CID_CHRD
CHRD_CON LABEL BYTE			;  Configuration table for CON:
	ERRNZ	CHRD_CON,CHRD_CLASS
	DB	CHRDCL_CRT		; System CRT
	ERRNZ	CHRD_CON,CHRD_ATTR
	DB	0			; No special attributes
	ERRNZ	CHRD_CON,CHRD_PORT
	DW	ZSERA			; First 2661
	ERRNZ	CHRD_CON,CHRD_BAUD
	DB	BD480			; 4800 baud
	ERRNZ	CHRD_CON,CHRD_HSHK
	DB	CHRDH_DCDH		; DCD Positive
	ERRNZ	CHRD_CON,CHRD_BCTL
	DB	CHRDB_SB1+CHRDB_CL8	; 1 stop bit, no parity, 8 data bits
	ERRNZ	CHRD_CON,CHRD_ECNT
	DB	0			; No ETX/ACK count
	ERRNZ	CHRD_CON,CHRD_NCNT
	DB	0			; Don't send null's
	ERRNZ	CHRD_CON,CHRD_NCHR
	DB	0			; No pad character
	ERRNZ	CHRD_CON,CHRD_RES
	DB	6 DUP (0)		; Reserved
	ERRNZ	CHRD_CON,CHRD_SIZE
	ERRNZ	CID_CON,CID_CLASS
	DW	CIDCL_CRT		; Is a CRT
	ERRNZ	CID_CON,CID_TYPE
	DB	CID_SIZE-CID_TYPE DUP (0)
	ERRNZ	CID_CON,CID_SIZE


TCID	DB CID_SIZE DUP(?) ; Temporary CID
	
	PAGE
;
;  ISR_KD - Interrupt service routine for Keyboard, Video vertical retrace,
;           and light pen.
;

ISR_KD:
	INC	WORD PTR CS:RECURLV ; Bump recursion level, first time through ?
	JNZ	ISR_KD1		;   No, then skip set up of stack
	MOV	CS:SAVESP,SP	; Set up a new stack
	MOV	CS:SAVESS,SS
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET BIOS_STACK
ISR_KD1:
	PUSH	AX		; Save regs
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
;??	STI			; Let higher priorty interrupts in

;
; Check for interrupts until none are present
;

ISR_KDL:

; Check for interrupt from PIA

	IN	AL,ZPIA+PIACTLA	; Get status
	TEST	AL,PIAIRQ1 OR PIAIRQ2 ; either vsync or light pen interrupt?
	JZ	ISR_KD2		;   No, skip to keyboard check
	MOV	AH,AL		; Save status

; Check for light pen as source of interrupt

	TEST	AH,PIAIRQ1	; Did light pen cause interrupt ?
	JZ	ISR_KD1A	;   No, skip

;	Check light pen switch

	IN	AL,ZPIA+PIADATA	; Read PA
	TEST	AL,040H		; Check light pen bit
	JNZ	ISR_KDL1	; Yep, was light pen
	MOV	AL,AH		; Restore it in AL
	JMP	SHORT ISR_KD1A	; Nope, bail out

;	Was light pen

ISR_KDL1:
	CALL	ISR_KDLP

; Check for vertical retrace as source of interrupt

ISR_KD1A:
	TEST	AH,PIAIRQ2	; Did vertical retrace cause interrupt ?
	JZ	ISR_KD1B	;   No, skip
	INT	INT_VSYNA	; Vertical sync interrupt
	INC	WORD PTR CS:VSYNC_CNT ; Bump count of vsyncs seen
	IN	AL,ZPIA+PIADATA	; Read PIA(clears interrupt request)
	CMP	WORD PTR CS:VSYNC_CNT,VSYNC_MAX ; Have too many vsyncs gone by ?
	JA	ISR_KD1AZ	;   Yes, force service
	TEST	AL,00010000B	; Is vertical sync still active ?
	JZ	ISR_KD1B	;    No, skip
ISR_KD1AZ:
	CALL	FAR PTR MTR_TTY_INTR ; Yes, let ROM monitor handle it
	MOV	WORD PTR CS:VSYNC_CNT,0 ; Show vsync serviced

; Clear vertical retrace/light pen interrupt

ISR_KD1B:
	IN	AL,ZPIA+PIADATA	; Read PIA (Clears interrupt request, if not already cleared)
	AND	AL,01011111B	; Clear vsync/light pen flip flops
	OUT	ZPIA+PIADATA,AL	; Clear vsysc flip flop
	IN	AL,ZDIPSW	; Dummy I/O to drive clock on PIA
	IN	AL,ZPIA+PIADATA	; Read PIA
	OR	AL,10100000B	; Enable vsync/light pen to cause interrupts
	OUT	ZPIA+PIADATA,AL	; Let vsync cause interrupts


; Check for keyboard interrupt

ISR_KD2:
	IN	AL,ZKEYBRDS	; Get status of keyboard
	TEST	AL,ZKEYOBF	; Is output buffer empty ?
	JZ	ISR_KDR		;   Yes, nothing more to do
	IN	AL,ZKEYBRDD	;   No, read char(clears interrupt request)

	XOR	AH,AH		; Set AH = 0
	PUSH	AX
	OR	CS:WORD PTR EVN_FLG,EVN_KYB
	POP	AX
	INT	INT_UKBA	; Do the interrupt
	OR	AH,AH		; Still zero? (No one wanted it)
	JNZ	ISR_KDLJ	; Nope, some one else got it

;	Nobody wanted the key, put it in the que

	CMP	AL,SPECIAL_KEY	; Was special key hit ?
	JE	ISR_KDSK	;   Yes, go process it

;	Check for print screen key
    
    	CMP	AL,PRINT_SCREEN_KEY	; Was it this one?
    	JNZ	ISR_KD2A	; Nope
    
	TEST	CS:BYTE PTR PRSC_IN_PROGRESS,0FFH  ; One currently running?
	JNZ	ISR_KDLJ	; Yes, ignore this key

;	Had a PRINT_SCREEN_KEY

	MOV	CS:BYTE PTR PRSC_IN_PROGRESS,0FFH	; Flag busy
	INT	INT_PRSCA
	CLI			; Interrupts back off
	MOV	CS:BYTE PTR PRSC_IN_PROGRESS,0	; Turn it back off
	JMP	SHORT ISR_KDLJ	; And exit
	
;	Check if  queue is full

ISR_KD2A:
	MOV	BX,WORD PTR CS:CQ_ZCON+CQ_ELMTS	; BX = number in queue
	ADD	BX,10			; Insure expansion room
	CMP	BX,WORD PTR CS:CQ_ZCON+CQ_QSIZE	; Is it full yet?
	JNC	ISR_KDFL
	CALL	FAR PTR MTR_DKBD ; Translate and store char(AL has char)
	JMP	ISR_KDL		; See if more interrupts

ISR_KDFL:
	MOV	AL,ZKEYBEP	; Get beep command
	OUT	ZKEYBRDC,AL	; Beep keyboard
ISR_KDLJ:
	JMP	ISR_KDL		; See if more interrupts

ISR_KDSK:
	MOV	BX,OFFSET CQ_ZCON ; Get addr of queue descriptor
	CALL	Q_FLUSH		; Flush the typeahead queue
	JMP	ISR_KDL		; See if more interrupts

ISR_KDR:
	CLI			; Turn off interrupts for a bit
	MOV	AL,OCW2OP+OCW2EOI
	OUT	ZM8259A+OCW2,AL	; Tell 8259A that interrupt serviced
	POP	ES		; Recover regs
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	DEC	WORD PTR CS:RECURLV ; Dec recursion level, at bottom ?
	JNS	ISR_KDR1	;   No, skip
	MOV	SS,CS:SAVESS	;   Yes, recover stack
	MOV	SP,CS:SAVESP
ISR_KDR1:
	IRET			;   and return

;
;  ISR_KDLP - Service light pen hit
;

ISR_KDLP:
	OR	CS:WORD PTR EVN_FLG,EVN_LPN
	AND	AL,NOT 040H	; Clear it for next time
	OUT	ZPIA+PIADATA,AL	; Set it so
	MOV	AL,AH		; Clear status

	PUSH	AX		; Save the status
	PUSH	BX		; Location for LP address
	MOV	AL,CRTLPH	; Read hi address value
	OUT	ZCRTC+CRTREG,AL	; Set it
	IN	AL,ZCRTC+CRTDAT	; Read the value
	MOV	BH,AL
	MOV	AL,CRTLPL	; Read low address value
	OUT	ZCRTC+CRTREG,AL
	IN	AL,ZCRTC+CRTDAT	; Read it
	MOV	BL,AL

;	BX = relative address of hit, now get real address

	MOV	AL,CRTSAH	; Read hi address value
	OUT	ZCRTC+CRTREG,AL	; Set it
	IN	AL,ZCRTC+CRTDAT	; Read the value
	MOV	AH,AL
	MOV	AL,CRTSAL	; Read low address value
	OUT	ZCRTC+CRTREG,AL
	IN	AL,ZCRTC+CRTDAT	; Read it, AX = start address
	SUB	BX,AX		; BX = relative hit address
	SUB	BX,CS:WORD PTR ASP_LPEFV ; Subtract light pen error value
	IN	AL,ZLPEN	; Read light pen hit register
	MOV	CS:BYTE PTR ASP_LPHFV,1	; Show a hit
	MOV	CS:WORD PTR ASP_LPHCAV,BX	; Show address
	MOV	CS:BYTE PTR ASP_LPHPAV,AL	; and pixel address
	INT	INT_ULPA	; User interrupt routine
	CLI
	POP	BX
	POP	AX		; Restore interrupts and AX
	RET
	PAGE
;
;  KQ_PUT - Put character in keyboard typeahead queue
;          (Note: This is only called by ROM monitor)
;
;      Call with:
;          AL = char
;
;  Assumes: No keyboard interrupt can occur during execution
;

KQ_PUT	PROC FAR
	PUSH	BX		; Save regs
	MOV	BX,OFFSET CQ_ZCON ; Get addr of console input queue
	CALL	NEAR PTR Q_PUT	; Store char in queue, any errors ?
	JNC	KQ_RT		;   No, skip
	MOV	AL,ZKEYBEP	; Get keyboard beep command
	OUT	ZKEYBRDC,AL	; Beep keyboard
KQ_RT:
	POP	BX		; Restore reg
	RET			;  and return
KQ_PUT	ENDP

	PAGE
;
;  ISR_SA - Interrupt service routine for the ZSERA port, a 2661 USART.
;           If the transmitter is empty, it is simply turned off.
;           If the receiver has data, it is read and stored in
;           the input queue.
;

ISR_SA:
	PUSH	AX		; Save regs
	PUSH	BX
;??	STI			; Let higher interrupts in

	MOV	BX,OFFSET CQ_ZSERA ; Get addr of queue descriptor
	IN	AL,ZSERA+EPSTAT ; Get status
	MOV	AH,AL		; Save it
	TEST	AH,EPRXR	; Does receiver have data ?
	JZ	ISR_SA1		;   No, skip
	OR	CS:WORD PTR EVN_FLG,EVN_SRA
	IN	AL,ZSERA+EPDATA ; Read char
	PUSH	AX		; Save AH status
	XOR	AH,AH		; Show not yet used
	INT	INT_USAIA	; Interrupt routine
	CLI
	OR	AH,AH		; Was it used
	POP	AX
	JNZ	ISR_SA1

;	See if DC1 or DC3 (in case using DC1/DC3 handshake)

	PUSH	BX
	MOV	BL,1
	CMP	AL,CC_DC3	; Is it DC3 (^S)
	JNZ	ISR_SAN1	;  Nope
	JMP	SHORT ISR_SAICC	; Is control character.
ISR_SAN1:
	DEC	BL
	CMP	AL,CC_DC1	; Is it DC1 (^Q)
	JNZ	ISR_SAN2	;  Nope.
ISR_SAICC:
	MOV	CS:BYTE PTR ISR_SACC,BL	; Save BL as the control flag
ISR_SAN2:
	POP	BX
	CALL	Q_PUT		; Put char in queue, did it fit ?
	JNC	ISR_SA1		;   Yes, skip
	OR	BYTE PTR CS:CQ_STATUS[BX],CHRS_RXOF ; Show error
ISR_SA1:
	TEST	AH,EPTXR	; Is transmitter empty ?
	JZ	ISR_SA2		;   No, nothing to do
	IN	AL,ZSERA+EPCMD	; Read command
	AND	AL,NOT EPTXEN	; Turn off transmitter
	OUT	ZSERA+EPCMD,AL	; Execute command
ISR_SA2: 
	MOV	AL,OCW2OP+OCW2EOI ; Tell interrupt controller
	OUT	ZM8259A+OCW2,AL   ;   that interrupt serviced
	POP	BX		; Restore regs
	POP	AX
	IRET			;   and return 


	PAGE
;
;  ISR_SB - Interrupt service routine for the ZSERB port, a 2661 USART.
;           If the transmitter is empty, it is simply turned off.
;           If the receiver has data, it is read and stored in
;           the input queue.
;

ISR_SB:
	PUSH	AX		; Save regs
	PUSH	BX
;??	STI			; Let higher interrupts in

	MOV	BX,OFFSET CQ_ZSERB ; Get addr of queue descriptor
	IN	AL,ZSERB+EPSTAT ; Get status
	MOV	AH,AL		; Save it
	TEST	AH,EPRXR	; Does receiver have data ?
	JZ	ISR_SB1		;   No, skip
	OR	CS:WORD PTR EVN_FLG,EVN_SRB
	IN	AL,ZSERB+EPDATA ; Read char
	PUSH	AX
	XOR	AH,AH		; Show not yet used
	INT	INT_USBIA	; Interrupt on it
	CLI
	OR	AH,AH		; Used?
	POP	AX
	JNZ	ISR_SB1		; Yes, ignore
	PUSH	BX
	MOV	BL,1
	CMP	AL,CC_DC3	; Is it DC3 (^S)
	JNZ	ISR_SBN1
	JMP	SHORT ISR_SBICC	; Yes, save flag value
ISR_SBN1:
	DEC	BL
	CMP	AL,CC_DC1	; Is it a DC1 (^Q)
	JNZ	ISR_SBN2
ISR_SBICC:
	MOV	CS:BYTE PTR ISR_SBCC,BL
ISR_SBN2:
	POP	BX
	CALL	Q_PUT		; Put char in queue, did it fit ?
	JNC	ISR_SB1		;   Yes, skip
	OR	BYTE PTR CS:CQ_STATUS[BX],CHRS_RXOF ; Show error
ISR_SB1:
	TEST	AH,EPTXR	; Is transmitter empty ?
	JZ	ISR_SB2		;   No, nothing to do
	IN	AL,ZSERB+EPCMD	; Read command
	AND	AL,NOT EPTXEN	; Turn off transmitter
	OUT	ZSERB+EPCMD,AL	; Execute command
ISR_SB2:
	MOV	AL,OCW2OP+OCW2EOI ; Tell interrupt controller
	OUT	ZM8259A+OCW2,AL   ;   that interrupt serviced
	POP	BX		; Restore regs
	POP	AX
	IRET			;   and return 

ISR_SACC	DB	0	; <>0 if DC1 seen, and no DC3 yet follows
ISR_SBCC	DB	0	; <>0 if DC1 seen, and no DC3 yet follows

	PAGE
;
;  Q_STATUS - Queue status
;
;  Nondestructive read of a queue
;
;      Call with:
;          BX -> CQ(queue descriptor)
;
;      Returns:
;          DH = Queue size
;          DL = Number of elements in queue
;          Z set - AL = 0, no chars in queue
;          Z clear - AL = first char in queue
;
;  Assumes: No interrupt can occur which also touches queue
;

Q_STATUS PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_ELMTS[BX] ; Get number of elems in queue
	MOV	DX,SI		; Get element count
	MOV	DH,BYTE PTR CS:CQ_QSIZE[BX] ; Get size of queue
	XOR	AL,AL		; Assume no element in queue
	OR	SI,SI		; Was there any ?
	JZ	Q_SR		;   No, return
	MOV	SI,WORD PTR CS:CQ_FRONT[BX] ; Get addr of front element
	PUSH	ES
	PUSH	SI
	MOV	SI,WORD PTR CS:CQ_SEGM[BX]  ; Get segment
	MOV	ES,SI
	POP	SI

;	NOTE: Setting of direction on this instruction is not important!

	LODS	BYTE PTR ES:0	; Get element
	POP	ES
Q_SR:
	POP	SI		; Restore regs
	RET			;   and return
Q_STATUS ENDP

	PAGE
;
;  Q_FLUSH - Flush queue
;
;      Call with:
;          BX -> CQ(queue descriptor)
;
;  Assumes: No interrupt can occur which also touches queue
;

Q_FLUSH PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_SADDR[BX] ; Get start addr
	MOV	WORD PTR CS:CQ_FRONT[BX],SI ; Set front elem ptr
	MOV	SI,WORD PTR CS:CQ_EADDR[BX] ; Get end addr
	MOV	WORD PTR CS:CQ_REAR[BX],SI ; Set rear elem ptr
	MOV	WORD PTR CS:CQ_ELMTS[BX],0 ; Set number of elems to 0
	MOV	BYTE PTR CS:CQ_STATUS[BX],0 ; Clear errors
	POP	SI		; Recover regs
	RET			;   and return
Q_FLUSH ENDP


	PAGE
;
;  Q_GET - Get an element from a queue
;
;      Call with:
;          BX -> CQ(queue descriptor)
;
;      Returns:
;          Z set - queue empty
;          Z clear - AL = char removed from front of queue
;
;  Assumes: No interrupt can occcur which also touches queue
;

Q_GET	PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_ELMTS[BX] ; Get number of elems in queue
	OR	SI,SI		; Is queue empty ?
	JZ	Q_G2		;   Yes, skip
	DEC	SI		; Decr number of elemts
	MOV	WORD PTR CS:CQ_ELMTS[BX],SI ; Store updated count
	MOV	SI,WORD PTR CS:CQ_FRONT[BX] ; Get addr of front element
	PUSH	ES
	PUSH	SI
	MOV	SI,WORD PTR CS:CQ_SEGM[BX]  ; Get segment
	MOV	ES,SI
	POP	SI
	PUSHF			; Save state of direction flags
	CLD			; Insure the direction flag is up
	LODS	BYTE PTR ES:0	; Get element
	POPF			; Restore flags
	POP	ES
	CMP	SI,WORD PTR CS:CQ_EADDR[BX] ; Should ptr be wrapped ?
	JNA	Q_G1		;   No, skip
	MOV	SI,WORD PTR CS:CQ_SADDR[BX] ; Wrap ptr
Q_G1:
	MOV	WORD PTR CS:CQ_FRONT[BX],SI ; Store updated ptr
	OR	SI,-1		; Force the zero flag off
Q_G2:
	POP	SI		; Restore regs
	RET			;   and return
Q_GET	ENDP

	PAGE
;
;  Q_PUT - Put an element in a queue
;      Call with:
;          AL = character to put in queue
;          BX -> CQ(queue descriptor)
;
;      Returns:
;          CY clear - no error
;          CY set - no room in queue to put element
;
;  Assumes: No interrupt can occur which also touches queue
;

Q_PUT	PROC NEAR
	PUSH	SI		; Save regs
	MOV	SI,WORD PTR CS:CQ_ELMTS[BX] ; Get number currently in queue
	CMP	SI,WORD PTR CS:CQ_QSIZE[BX] ; Is there room for another ?
	JB	Q_P1		;   Yes, skip
	STC			;   No, show error
	POP	SI		; Recover regs
	RET			;   and return
Q_P1: 
	INC	SI		; Bump element count
	MOV	WORD PTR CS:CQ_ELMTS[BX],SI ; Store updated count
	MOV	SI,WORD PTR CS:CQ_REAR[BX] ; Get rear ptr
	INC	SI		; Bump it
	CMP	SI,WORD PTR CS:CQ_EADDR[BX] ; Should it be wrapped
	JNA	Q_P2		;   No, skip
	MOV	SI,WORD PTR CS:CQ_SADDR[BX] ; Wrap ptr
Q_P2:
	PUSH	ES
	PUSH	SI
	MOV	SI,WORD PTR CS:CQ_SEGM[BX]  ; Get segment
	MOV	ES,SI
	POP	SI
	MOV	BYTE PTR ES:[SI],AL	; Get element
	POP	ES
	MOV	WORD PTR CS:CQ_REAR[BX],SI ; Store updated ptr
	CLC			; Clear CY to show success
	POP	SI		; Recover regs
	RET			;   and return
Q_PUT	ENDP

	PAGE
;
;  BIOS_AUXFUNC - Perform a AUX: related function
;
;      Call with:
;          AH = function to perform
;
;            AH = CHR_WRITE - Write character function
;            AH = CHR_READ - Read character function
;            AH = CHR_STATUS - Status function(may need ES:BX)
;            AH = CHR_CONTROL - Control function(may need ES:BX)
;            AH = CHR_LOOK - Nondestructive read function
;
;      Returns:
;          CY = 0 - function executed normally
;          CY = 1 - function returns error code in AX
;
;      Uses: BX, DX, DI, and SI
;

BIOS_AUXFUNC:
	MOV	SI,OFFSET CID_AUX ; Get internal printer control table addr
	JMP	NEAR PTR CHRFUNC ; Join common code


;
;  BIOS_PRNFUNC - Perform a PRN related function
;
;      Call with:
;          AH = function to perform
;
;            AH = CHR_WRITE - Write character function
;            AH = CHR_READ - Read character function
;            AH = CHR_STATUS - Status function(may need ES:BX)
;            AH = CHR_CONTROL - Control function(may need ES:BX)
;            AH = CHR_LOOK - Nondestructive read function
;
;      Returns:
;          CY = 0 - function executed normally
;          CY = 1 - function returns error code in AX
;
;      Uses: BX, DX, DI, and SI
;

BIOS_PRNFUNC:
	MOV	SI,OFFSET CID_PRN ; Get internal aux control table addr
	JMP	NEAR PTR CHRFUNC ; Join common code


;
;  BIOS_CONFUNC - Perform a CON: related function
;
;      Call with:
;          AH = function to perform
;
;            AH = CHR_WRITE - Write character function
;            AH = CHR_READ - Read character function
;            AH = CHR_STATUS - Status function(may need ES:BX)
;            AH = CHR_CONTROL - Control function(may need ES:BX)
;            AH = CHR_LOOK - Nondestructive read function
;
;      Returns:
;          CY = 0 - function executed normally
;          CY = 1 - function returns error code in AX
;
;      Uses: BX, DX, DI, and SI
;

BIOS_CONFUNC:
	MOV	SI,OFFSET CID_CON ; Get internal console control table addr
;	JMP	NEAR PTR CHRFUNC ; Join common code

	PAGE
;
;  CHRFUNC - Perform a character device related function
;
;      Call with:
;          SI -> internal control table (CID)
;          AH = function to perform
;
;            AH = CHR_WRITE - Write character function
;            AH = CHR_READ - Read character function
;            AH = CHR_STATUS - Status function(may need ES:BX)
;            AH = CHR_CONTROL - Control function(may need ES:BX)
;            AH = CHR_LOOK - Nondestructive read function
;
;      Returns:
;          CY = 0 - function executed normally
;          CY = 1 - function returns error code in AX
;
;      Uses: BX, DX, DI, and SI
;

CHRFUNC PROC FAR
	CMP	AH,CHR_FMAX	; Is function code valid ?
	JNA	CF1		;     Yes, skip
	MOV	AX,CHRE_ILGFH	;     No, get ILLEGAL FUNCTION error code
	STC			; Show error by setting CY
	RET			;   and return

CF1:
	PUSH	DS		; Save DS
	PUSH	CS		; Setup new DS
	POP	DS
	MOV	DI,AX		; Save AX
	MOV	AL,AH		; Put function in lower part
	XOR	AH,AH		; Clear upper part
	SHL	AX,1		; Make into word offset
	XCHG	AX,DI		; Restore AX and make offset available
	CALL	WORD PTR CHRFC[DI] ; Case to function
	POP	DS		; Recover DS
	RET			;   and return

CHRFUNC	ENDP

CHRFC:
	DW	OFFSET CHRFWR	; Write function
	DW	OFFSET CHRFRD	; Read function
	DW	OFFSET CHRFST	; Status function
	DW	OFFSET CHRFCT	; Control function
	DW	OFFSET CHRFLK	; Look function


	PAGE
;
; CHRFWR - Character device write function
;
;     Call with:
;         SI -> CID
;         AL = character to write
; 
;     Returns:
;         CY clear - char written
;         CY set - AX has error code
;
;     Uses: BX, DX, DI

CHRFWR	PROC	NEAR
	CMP	WORD PTR CID_TYPE[SI],CIDTY_CSP ; Is it special console ?
	JNE	CHRFWR0Z		;   No, skip

;	Output directly to monitor rom

	PUSH	AX
	PUSH	CX
	PUSH	BP
	PUSH	DS
	PUSH	ES
	XOR	AH,AH			; Flag character not used
	INT	INT_UCRTA		; See if user wants it
	OR	AH,AH
	JNZ	CHRFWR0A		; If he did
	CALL	MTR_SCRT		; If he did not, I will
CHRFWR0A:
	POP	ES
	POP	DS
	POP	BP
	POP	CX
	POP	AX

	CLC
	RET

; Normal output processing

CHRFWR0Z:
	MOV	BX,AX			; Save char to write
	CALL	CHRFOS			; Get output status, any errors ?
	JNC	CHRFWR1			;   No, skip

;	See if CHRE_WRB and CID = PRN and CHRBUF = 0

	CMP	AX,CHRE_WRB
	JNZ	CHRFWR0Z1		; Not "Device not ready"

	MOV	DI,OFFSET PRNBUF
	CMP	SI,OFFSET CID_PRN	; PRN device?
	JZ	CHRFWR0Z2		; Yes
	MOV	DI,OFFSET AUXBUF
	CMP	SI,OFFSET CID_AUX	; AUX device?
	JZ	CHRFWR0Z2		; Yes
	MOV	DI,OFFSET CONBUF	; Nope, must be CON
CHRFWR0Z2:
	CMP	CS:BYTE PTR [DI],0
	STC
	JNZ	CHRFWR0Z1		; Yep, can't buffer it

;	Only 1 waiting, lets save it

	MOV	CS:BYTE PTR [DI+1],BL	; Set in the character
	MOV	CS:BYTE PTR [DI],-1	; Flag it as present
	CLC
CHRFWR0Z1:
	RET				; Yes, return error (CY already set)

CHRFWR1:
	MOV	AL,BL			; Recover char to write
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_SPO ; parity stripped ?
	JZ	CHRFWR2			;   No, skip
	AND	AL,07FH			; Strip the parity bit
CHRFWR2:
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_MLO ; lower case mapped
	JZ	CHRFWR3			;   No, skip
	CALL	UPCASE			; Convert char to upper case
CHRFWR3:
	MOV	DI,CID_CLASS[SI]	; Get device class
	CALL	WORD PTR CHRFODC[DI]	; Output character
	
	CMP	AL,CID_CHRD+CHRD_NCHR[SI] ; Should nulls be sent ?
	JNE	CHRFWR4			;   No, skip
	MOV	AL,CID_CHRD+CHRD_NCNT[SI] ;   get number of nulls to send
	MOV	CID_NCTR[SI],AL		; Store as down counter
CHRFWR4:
	MOV	AX,BX			; Recover AX
	CMP	BYTE PTR CID_CHRD+CHRD_HSHK[SI],CHRDH_EAH ; Using ETX/ACK ?
	JNE	CHRFWR6			;   No, skip
	MOV	BL,BYTE PTR CID_ECTR[SI] ; Get char count
	INC	BL			; Bump it
	CMP	AL,CC_ESC		; Is char an ESC ?
	JNE	CHRFWR5			;   No, skip
	MOV	BH,BYTE PTR CID_CHRD+CHRD_ECNT[SI] ; Get max count
	SUB	BH,3			; Allow for 3 char ESC sequences
	CMP	BL,BH			; Will it fit ?
	JNA	CHRFWR5			;   Yes, skip
	MOV	BL,BH			; No, use decrement count so it will
CHRFWR5:
	MOV	BYTE PTR CID_ECTR[SI],BL ; Store new count
CHRFWR6:  
	CLC				; Show success
	RET
CHRFWR	ENDP


	PAGE
;
; CHRFOS - Get character device output status
;
;     Call with:
;         SI -> CID
;         BL = possible char(only ESC's are significant when ETX/ACK'ing)
;
;     Returns:
;         CY clear - output device ready
;         CY set - AX has error code
;
;     Uses: AX, DI
;

CHRFOS	PROC	NEAR
	MOV	DI,OFFSET PRNBUF
	CMP	SI,OFFSET CID_PRN	; PRN device?
	JZ	CHRFOS1X		; Yep
	MOV	DI,OFFSET AUXBUF
	CMP	SI,OFFSET CID_AUX	; AUX?
	JZ	CHRFOS1X		; Yep
	MOV	DI,OFFSET CONBUF	; Nope, must be CON
CHRFOS1X:
	CMP	CS:BYTE PTR [DI],0
	JNZ	CHRFOS2X		; If char waiting, busy

	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFOSC[DI] ; Get status from device(returned in AL)
	AND	AL,CID_ORM[SI]	; Issolate ready/busy bits in status
	XOR	AL,CID_OPM[SI]	; Adjust for polarity
	CMP	AL,CID_ORM[SI]	; Is device busy(not ready) ?
	JE	CHRFOS1		;   No, skip
CHRFOS2X:
	MOV	AX,CHRE_WRB	;   Yes, get DEVICE BUSY error code
	STC			; Show failure
	RET			;   and return

CHRFOS1:
	CMP	BYTE PTR CID_CHRD+CHRD_HSHK[SI],CHRDH_EAH ; <ETX>/<ACK>
	JNE	CHRFOS5		;   No, skip

; Using <ETX>/<ACK> handshaking

	TEST	BYTE PTR CID_ST[SI],CHRS_WA ; Are we waiting for <ACK> ?
	JNZ	CHRFOS2		;   Yes, go to it
	
	MOV	AL,CID_ECTR[SI]	; Get character counter
	CMP	AL,CID_CHRD+CHRD_ECNT[SI] ; Is it equal to limit ?
	JNB	CHRFOS2A	;   Yes, skip
	JMP	CHRFOS12	;   No, skip to check for nulls
CHRFOS2A:
	MOV	BYTE PTR CID_ECTR[SI],0	; Reinitialize counter
	MOV	AL,CC_ETX	; Get <ETX> char
	CALL	WORD PTR CHRFODC[DI] ; Output character
	OR	BYTE PTR CID_ST[SI],CHRS_WA ; Show waiting for <ACK>
	MOV	AX,CHRE_WRB	; Get DEVICE BUSY error code
	STC			; Show failure
	RET			;   and return

; Waiting on <ACK>

CHRFOS2:
	CALL	CHRFIS		; Get input status, is char available ?
	JNC	CHRFOS3		;   Yes, skip
	RET			;   No, return error(CY already set)

CHRFOS3:
	CALL	WORD PTR CHRFIDC[DI] ; Read character
	AND	AL,07FH		; Strip parity
	CMP	AL,CC_ACK	; Is character an <ACK>
	JE	CHRFOS4		;   Yes, skip
	MOV	AX,CHRE_ILR	;   No, get ILLEGAL RESPONCE error message 
	STC			; Show failure
	RET			;   and return

CHRFOS4:
	AND	BYTE PTR CID_ST[SI],NOT CHRS_WA ; Clear wait flag
	JMP	CHRFOS12	; Go check on nulls


; Test for <DC1>/<DC3> handshaking

CHRFOS5:
	CMP	BYTE PTR CID_CHRD+CHRD_HSHK[SI],CHRDH_DCH ; <DC1>/<DC3>
	JE	CHRFOS6		;   Yes, skip
	JMP	CHRFOS12	;   No, go check on nulls

; Using <DC1>/<DC3> handshaking, See if DC1 seen, and no DC3 has followed

CHRFOS6:
	MOV	AL,BYTE PTR ISR_SACC	; Assume serial A
	CMP	WORD PTR [SI+CID_CHRD+CHRD_PORT],ZSERA
	JZ	CHRFOS7		; If that was it
	MOV	AL,BYTE PTR ISR_SBCC
	CMP	WORD PTR [SI+CID_CHRD+CHRD_PORT],ZSERB
	JZ	CHRFOS7
	JMP	SHORT CHRFOS8
CHRFOS7:
	OR	AL,AL
	JZ	CHRFOS12	; If = 0, no DC1 seen lately
CHRFOS8:
	MOV	AX,CHRE_WRB	; Get DEVICE BUSY error code
	STC			; Show failure
	RET			;   and return

; Check if a NULL should be written

CHRFOS12:
	CMP	BYTE PTR CID_NCTR[SI],0	; Any nulls need to be written ?
	JNE	CHRFOS13	;   Yes, skip
	CLC			;   No, show success	
	RET			; and return

CHRFOS13:
	DEC	BYTE PTR CID_NCTR[SI] ; Decr number of NULLS remaining
	MOV	AL,CC_NUL	; Get NULL char
	CALL	WORD PTR CHRFODC[DI] ; Output char
	MOV	AX,CHRE_WRB	; Show device busy
	STC			; Show failure
	RET			;  and return
CHRFOS	ENDP

	PAGE
;
; CHRFRD - Character device read function
;
;     Call with:
;         SI -> CID
; 
;     Returns:
;         CY clear - AL has char that was read
;         CY set - AX has error code
;
;     Uses: BX, DX, DI

CHRFRD	PROC NEAR
	MOV	BX,AX		; Save AX
	CALL	CHRFIS		; Get input status, any errors ?
	JNC	CHRFRD1		;   No, skip
	RET			;   Yes, return failure(CY already set)

CHRFRD1:
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFIDC[DI] ; Read a character
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_SPI ; parity stripped ?
	JZ	CHRFRD2		;   No, skip
	AND	AL,07FH		; Strip the parity bit
CHRFRD2:
	TEST	BYTE PTR CID_CHRD+CHRD_ATTR[SI],CHRDA_MLI ; lower case mapped
	JZ	CHRFRD3		;   No, skip
	CALL	UPCASE		; Convert char to upper case
CHRFRD3:
	MOV	AH,BH		; Restore AH
	CLC			; Show success
	RET			;  and return
CHRFRD	ENDP

	PAGE
;
; CHRFIS - Get character device input status
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         CY clear - input device has char
;         CY set - AX has error code
;
;     Uses: AX, DI        
;

CHRFIS	PROC NEAR
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFISC[DI] ; Get status
	AND	AL,CID_IRM[SI]	; Issolate ready/busy bits
	XOR	AL,CID_IPM[SI]	; Adjust for polarity
	CMP	AL,CID_IRM[SI]	; Is character ready ?
	JNE	CHRFIS1		;   No, skip
	CLC			;   Yes, show success
	RET			; and return

CHRFIS1:
	MOV	AX,CHRE_RDNR	; Get READER NOT READY error code
	STC			; Show failure
	RET			;  and return
CHRFIS	ENDP



	PAGE
;
; CHRFLK - Nondestructive read (check if input queue is empty and
;          if not, then return a copy of the first element)
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         CY clear - AL = copy of first char in queue
;         CY set - AX has error code
;
;     Uses: AX, DI, BX
;

CHRFLK	PROC NEAR
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFGIQD[DI] ; Get queue descriptor addr
	JNC	CHRFLK1		;   Yes, skip
	MOV	AX,CHRE_NIQ	; Return "No input queue" error 
	RET

CHRFLK1:
	CALL	Q_STATUS	; Any chars in input queue ?
	JNZ	CHRFLK2		;   Yes, skip
	MOV	AX,CHRE_IQE	; Return "Input queue emptry" error
	STC			; Set CY to show error
CHRFLK2:
	RET			;   and return

CHRFLK	ENDP


	PAGE
;
; CHRFGIQD - Get input queue descriptor
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         CY clear - BX -> CQ (character queue descriptor)  
;         CY set - device has no input queue
;

CHRFGIQD PROC NEAR
	DW	OFFSET CHRFGI_CRT ; Internal video/keyboard
	DW	OFFSET CHRFGI_SER ; 2661-2 ports
	DW	OFFSET CHRFGI_PAR ; PIA port


; Internal video/keyboard

CHRFGI_CRT:
	MOV	BX,OFFSET CQ_ZCON ; Get addr of input queu descriptor
	CLC			; Show success
	RET			; and return


; 2661 serial ports

CHRFGI_SER:
	MOV	BX,CID_CHRD+CHRD_PORT[SI] ; Get base port
	CMP	BX,ZSERA	; Is it the serial A port ?
	JNE	CHRFGI_SER1	;   No, skip
	MOV	BX,OFFSET CQ_ZSERA ; Get addr of input queue desc
	CLC			; show success
	RET

CHRFGI_SER1:
	CMP	BX,ZSERB	; Is it the serial B port ?
	JNE	CHRFGI_SER2	;   No, skip
	MOV	BX,OFFSET CQ_ZSERB ; Get addr of input queue desc
	CLC			; show success
	RET

CHRFGI_SER2:
	STC			; Show failure
	RET


; PIA parallel port

CHRFGI_PAR:
	STC			; Show failure
	RET

CHRFGIQD ENDP


	PAGE
;
; Raw Output data routines
;
;     Call with:
;         AL = char to write
;         SI -> CID
;
;     Uses: DX, AH
;

CHRFODC PROC NEAR
	DW	OFFSET CHRFOD_CRT ; Internal video/keyboard
	DW	OFFSET CHRFOD_SER ; 2661-2 ports		
	DW	OFFSET CHRFOD_PAR ; PIA port


; Internal video/keyboard output data

CHRFOD_CRT:
	CLI			; Disable interrupts for a bit
	INC	WORD PTR RECURLV ; Bump recursion level, first time through ?
	JNZ	CHRFOD_CRT1	;   No, skip
	MOV	SAVESP,SP	; Set up new stack
	MOV	SAVESS,SS
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET BIOS_STACK
CHRFOD_CRT1:
	STI			; Enable interrupts
	PUSH	AX		; Save regs
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	MOV	AH,AL		; Save char to display
	IN	AL,ZVIDEO+PIADATA ; Read video control port for program
	MOV	VIDEO_PGM,AL	; Save it
	MOV	AL,VIDEO_ROM	; Get ROM's value
	OUT	ZVIDEO+PIADATA,AL ; Restore ROM's video status
	MOV	AL,AH		; Restore char
	XOR	AH,AH		; AH = flag, AL = character
	INT	INT_UCRTA	; Exectue CRT interrupt
	OR	AH,AH		; Check flag
	JNZ	CHRFOD_CRT1B	; If to ignore it
	CALL	MTR_SCRT	; Have ROM monitor display char
CHRFOD_CRT1B:
	IN	AL,ZVIDEO+PIADATA ; Read video control port for ROM
	MOV	VIDEO_ROM,AL	; Save it
	MOV	AL,VIDEO_PGM	; Get program's value
	OUT	ZVIDEO+PIADATA,AL ; Restore program's video status
	POP	ES		; Restore regs
	POP	DS
	POP	BP
 	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	CLI			; Disable interrupts
	DEC	WORD PTR RECURLV ; Dec recursion level, at bottom
	JNS	CHRFOD_CRT2	;   No, skip
	MOV	SS,SAVESS	;   Yes, recover stack
	MOV	SP,SAVESP
CHRFOD_CRT2:
	STI			; Enable interrupts
	RET			;  and return


; 2661-2 output data

CHRFOD_SER:
	CLI
	PUSH	AX
	XOR	AH,AH		; Show AH = 0
	CMP	WORD PTR CID_CHRD+CHRD_PORT[SI],ZSERA	; Get base port
	JNZ	CHRFOD_SERINT1
	INT	INT_USAOA	; Interrupt on it
	JMP	SHORT CHRFOD_SERINT2
CHRFOD_SERINT1:
	INT	INT_USBOA	; Serial B interrupt
CHRFOD_SERINT2:
	CLI
	OR	AH,AH		; Test return value
	POP	AX
	JNZ	CHRFOD_SER1	; If to ignore the character
	MOV	DX,CID_OPORT[SI] ; Get output data port addr
	OUT	DX,AL		; Write the byte
	MOV	AH,AL		; Save char
	MOV	DX,CID_CPORT[SI] ; Get command port
	IN	AL,DX		; Get current command
	OR	AL,EPTXEN	; Enable transmitter
	OUT	DX,AL
	MOV	AL,AH		; Recover char
CHRFOD_SER1:
	STI
	RET			;  and return

; PIA output data

CHRFOD_PAR:
	PUSH	AX		; Save character for a bit
	MOV	AH,AL		; Get second copy of char
	MOV	DX,CID_SPORT[SI] ; Get status port
	OUT	DX,AL		; Output part of data byte
	MOV	DX,CID_OPORT[SI] ; Get output data port
	CLI			; Disable interrupts for a bit
	MOV	AL,10101100B	; Get assumed current value
	AND	AH,00000011B	; Issolate new part
	OR	AL,AH		; Insert new value
	OUT	DX,AL		; Output new value
	AND	AL,11111011B	; Clear strobe bit
	OUT	DX,AL		; Strobe printer
	OR	AL,00000100B	; Set strobe line back high
	OUT	DX,AL		; Set back to normal
	STI			; Enable interrupts
	POP	AX		; Recover AX
	RET
CHRFODC ENDP

	PAGE
;
; Raw Output status routines
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         AL = device status
;
;     Uses: DX, AH 
;

CHRFOSC	PROC NEAR
	DW	OFFSET CHRFOS_CRT ; Internal video/keyboard
	DW	OFFSET CHRFOS_SER ; 2661-2 ports		
	DW	OFFSET CHRFOS_PAR ; PIA port


; Internal video/keyboard output status

CHRFOS_CRT:
	XOR	AL,AL		; Is always ready
	RET


; 2661-2 output status

CHRFOS_SER:
	CLI			; Disable interrupts
	MOV	DX,CID_CPORT[SI] ; Get command port
	IN	AL,DX		; Get current command
	MOV	AH,AL		; Save copy
	OR	AL,EPTXEN	; Enable transmitter
	OUT	DX,AL		; Turn on transmitter
	MOV	DX,CID_SPORT[SI] ; Get status port
	IN	AL,DX		; Get status
	XCHG	AL,AH		; Save status/get command
	MOV	DX,CID_CPORT[SI] ; Get command port
	OUT	DX,AL		; Restore to previous state
	MOV	AL,AH		; Restore status
	STI			; Turn on interrupts
	RET			;   and return


; PIA output status

CHRFOS_PAR:
	MOV	DX,CID_SPORT[SI] ; Get status port
	IN	AL,DX		; Get status
	AND	AL,00000011B	; Clear high part
	RET
CHRFOSC ENDP

	PAGE
;
; Raw Input data routines
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         AL = data byte read
;
;     Uses: DX
;

CHRFIDC PROC NEAR
	DW	OFFSET CHRFID_CRT ; Internal video/keyboard
	DW	OFFSET CHRFID_SER ; 2661-2 ports		
	DW	OFFSET CHRFID_PAR ; PIA port


; Internal video/keyboard input data

CHRFID_CRT:
	PUSH	BX		; Save regs
	MOV	BX,OFFSET CQ_ZCON ; Get addr of queue descriptor
CHRFID_QL:
	CLI			; Disable interrupts for a bit
	CALL	Q_GET		; Get char from type ahead queue
	STI			; Turn interrupts back on
	NOP			; Let an interrupt in
	JZ	CHRFID_QL	; If typeahead queue empty

;	AL = character from input que

	CMP	AL,CC_DC1	; DC1 character?
	JNZ	CHRFID_QL1

;	Character is DC1/DC3 - See if we should ignore this guy

CHRFID_QL2:
	CMP	BYTE PTR [SI+CID_CHRD+CHRD_HSHK],CHRDH_DCH	; DC1/DC3?
	JZ	CHRFID_QL	; Yep, skip this guy and get another
	JMP	SHORT CHRFID_QL3
CHRFID_QL1:
	CMP	AL,CC_DC3	; DC3?
	JZ	CHRFID_QL2	;  Yes, see if need to ignore
CHRFID_QL3:
	POP	BX		; Restore regs
	RET			;   and return


; 2661-2 input data

CHRFID_SER:
	MOV	DX,CID_CHRD+CHRD_PORT[SI] ; Get base port
	CMP	DX,ZSERA	; Is it the serial A port ?
	JNE	CHRFID_SER1	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERA ; Get addr of queue descriptor
	JMP	CHRFID_QL	; Join common code
CHRFID_SER1:
	CMP	DX,ZSERB	; Is it the serial B port ?
	JNE	CHRFID_SER2	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERB ; Get addr of queue descriptor
	JMP	CHRFID_QL	; Join common code
CHRFID_SER2:
	MOV	DX,CID_IPORT[SI] ; Get input data port
	IN	AL,DX		; Read data
	RET


; PIA input data

CHRFID_PAR:
	XOR	AL,AL		; You can't read from the parallel printer
	RET
CHRFIDC	ENDP

	PAGE
;
; Raw Input status routines
;
;     Call with:
;         SI -> CID
;
;     Returns:
;         AL = status
;         AH = raw status
;         DH = input queue size
;         DL = number of elements in queue
;

CHRFISC PROC NEAR
	DW	OFFSET CHRFIS_CRT ; Internal video/keyboard
	DW	OFFSET CHRFIS_SER ; 2661-2 ports		
	DW	OFFSET CHRFIS_PAR ; PIA port


; Internal video/keyboard input status

CHRFIS_CRT:
	PUSH	BX		; Save regs
	MOV	BX,OFFSET CQ_ZCON ; Get addr of queue descriptor
	XOR	AH,AH		; Clear raw status
CHRFIS_QS:
	CLI			; Disable interrupts
	MOV	AL,CQ_STATUS[BX] ; Get status
	OR	BYTE PTR CID_ST[SI],AL ; Propagate to CID
	CALL	Q_STATUS	; Is there a character in the queue ?
	JZ	CHRFIS_QS1	;   No, skip
	MOV	AL,0FFH		;   Yes, show not empty
CHRFIS_QS1:
	STI			; Turn interrupts back on
	POP	BX		; Restore regs
	RET			;   and return


; 2661-2 input status

CHRFIS_SER:
	MOV	DX,CID_SPORT[SI] ; Get status port
	IN	AL,DX		; Get status
	MOV	AH,AL		; Move to proper reg	
	MOV	DX,CID_CHRD+CHRD_PORT[SI] ; Get base port
	CMP	DX,ZSERA	; Is it the serial A port ?
	JNE	CHRFIS_SER1	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERA ; Get addr of queue descriptor
	JMP	CHRFIS_QS	; Join common code
CHRFIS_SER1:
	CMP	DX,ZSERB	; Is it the serial B port ?
	JNE	CHRFIS_SER2	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERB ; Get addr of queue descriptor
	JMP	CHRFIS_QS	; Join common code
CHRFIS_SER2:
	XOR	DX,DX		; Clear queue stats
	RET


; PIA input status

CHRFIS_PAR:
	XOR	AX,AX		; Meaningless
	XOR	DX,DX		; Clear queue stats
	RET
CHRFISC ENDP

	PAGE
;
; CHRFST - Get character device status function
;
;     Call with:
;         SI -> CID
;         AL = Subfunction
;
;           AL = CHR_SFGS - Get status 
;           AL = CHR_SFGC - Return configuration info to addr ES:BX
;
;     Returns:
;         CY clear -
;             CHR_SFGS - AH = synthesized status
;                        AL = raw status
;                        BH = input queue size
;                        BL = number of elements in queue
;             CHR_SFGC - Printer configuration is copied to addr ES:BX
;         CY set - AX has error code
;
;     Uses:  DX, DI
;

CHRFST	PROC NEAR
	CMP	AL,CHR_SFGS	; Is function, get status ?
	JNE	CHRFST1		;   No, skip

	MOV	DI,CID_CLASS[SI] ; Get device class
	XOR	BH,BH		; Clear status byte
	CALL	CHRFIS		; Get input status, errors ?
	JC	CHRFST0A	;   Yes, skip
	OR	BH,CHRS_RXR	;   No, show receiver has data
CHRFST0A:
	CALL	CHRFOS		; Get output status, errors ?	
	JC	CHRFST0B	;   Yes, skip
	OR	BH,CHRS_TXR	;   No, show transmitter ready
CHRFST0B:
	OR	BH,CID_ST[SI]	; Add other status bits
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFSTC[DI] ; Get raw status
	MOV	AL,AH		; Get raw status
	MOV	AH,BH		; Move synthesized status to proper reg
;???	put in other errors like parity and framing etc
	MOV	BX,DX		; Get queue stats
	CMP	BYTE PTR CID_NCTR[SI],0 ; Sending nulls ?
	JE	CHRFST0C	;   No, skip
	OR	AH,CHRS_SN	;   Yes, show it
CHRFST0C:
	CLC			; Show success
	RET			;  and return


CHRFSTC:
	DW	OFFSET CHRFIS_CRT ; Same as input status
	DW	OFFSET CHRFIS_SER ; Same as input status
	DW	OFFSET CHRFOS_PAR ; Same as output status 



; Check if status is Get configuration info

CHRFST1:
	CMP	AL,CHR_SFGC	; Is subfunction get configuration info ?
	JE	CHRFST2		;    Yes, skip
	MOV	AX,CHRE_ILGFL	;    No, get error code
	STC			; Show error
	RET			;   and return

; Move device configuration info to caller

CHRFST2:
	LEA	SI,CID_CHRD[SI]	; Get source ptr
	MOV	DI,BX		; Get dest ptr
	PUSH	CX		; Save CX
	MOV	CX,CHRD_SIZE	; Get length of CHRD
	CLD			; Set direction	
	REP MOVSB		; Copy the CHRD
	POP	CX		; Recover CX
	CLC			; Show success
	RET			;   and return
CHRFST	ENDP

	PAGE
;
; CHRFCT - Character device control function
;
;     Call with:
;         SI -> CID
;         AL = Subfunction
;
;           AL = CHR_CFSU - Set up new configuration using parms at ES:BX
;           AL = CHR_CFCI - Clear input
;           AL = CHR_CFCO - Clear output
;
;     Returns:
;         CY clear - success
;         CY set - AX has error code
;
;     Uses: DI, DX

CHRFCT	PROC NEAR
	CMP	AL,CHR_CFSU	; Is function, set up new parms ?
	JE	CHRFCT0		;   Yes, skip
	JMP	CHRFCT1		;   No, to next check

CHRFCT0:

; Set up new configuration

	PUSH	CX		; Save CX

; Clear temp CID to zero

	PUSH	SI		; Save some regs
	PUSH	ES
	PUSH	DS		; Set up ES
	POP	ES
	MOV	SI,OFFSET TCID	; Get source
	MOV	DI,OFFSET TCID+1 ; Get dest
	MOV	BYTE PTR TCID,0 ; Store zero in first byte
	MOV	CX,CID_SIZE-1	; Get count for smear
	CLD			; Set direction
	REP MOVSB		; Smear zero over CID

; Copy caller's CHRD into temp CID
;  (SI and ES on stack)

	MOV	SI,BX		; Get source offset
	POP	DS		; Get source segment
	MOV	DI,OFFSET TCID+CID_CHRD ; Get dest (segment already setup)
	MOV	CX,CHRD_SIZE	; Get size
	REP MOVSB		; Move caller's CHRD into temp CID

; Restore regs

	PUSH	DS		; Exchange DS and ES
	PUSH	ES
	POP	DS
	POP	ES
	POP	SI		; Recover SI

; Finish init of CID

	MOV	CL,TCID+CID_CHRD+CHRD_CLASS ; Get new device class
	CMP	CL,CHRDCL_MAX	; Is class valid ?
	JNA	CHRFCT0A	;   Yes, skip
	JMP	CHRCTS_BEX	;   No, skip to failure exit
CHRFCT0A:
	XOR	CH,CH		; Clear high part
	SHL	CX,1		; Convert to word ptr
	MOV	WORD PTR TCID+CID_CLASS,CX ; Store in temp CID
	MOV	DI,CX		; Make avail as index
	JMP	WORD PTR CHRFCTSC[DI] ; Case to class

CHRFCTSC:
	DW	OFFSET CHRCTS_CRT
	DW	OFFSET CHRCTS_SER
	DW	OFFSET CHRCTS_PAR


; Internal Video/keyboard

CHRCTS_CRT:
	MOV	BYTE PTR TCID+CID_CHRD+CHRD_HSHK,CHRDH_NO ; No handshaking
	MOV	BYTE PTR TCID+CID_CHRD+CHRD_NCNT,0 ; Don't send nulls
	TEST	BYTE PTR TCID+CID_CHRD+CHRD_ATTR,0FFH ; Any attributes ?
	JNZ	CHRCTS_CRT1	;   Yes, skip
	MOV	WORD PTR TCID+CID_TYPE,CIDTY_CSP ; No, show special type
CHRCTS_CRT1:
	MOV	BYTE PTR TCID+CID_IRM,0FFH ; Store input ready mask
	JMP	CHRCTS_GEX	; Join common exit


; 2661-2 serial

CHRCTS_SER:

; Check if baud rate OK

	CMP	BYTE PTR TCID+CID_CHRD+CHRD_BAUD,BDMAX ; Is baud rate valid ?
	JNA	CHRCTS_SER1	;   Yes, skip
	JMP	CHRCTS_BEX	;   No, join failure exit
CHRCTS_SER1:

; Compute ports

	MOV	CX,WORD PTR TCID+CID_CHRD+CHRD_PORT ; Get base port
	OR	CX,CX		; Was port specified ?
	JNZ	CHRCTS_SER1B	;   Yes, skip
	MOV	CX,ZSERA	;   No, assume a port
	CMP	SI,OFFSET CID_AUX ; Are we setting up AUX: ?
	JNE	CHRCTS_SER1A	;   No, skip
	MOV	CX,ZSERB	;   Yes, get default port for it
CHRCTS_SER1A:
	MOV	WORD PTR TCID+CID_CHRD+CHRD_PORT,CX ; Save base port
CHRCTS_SER1B:
	ADD	CX,EPDATA	; Compute input/output ports
	MOV	WORD PTR TCID+CID_IPORT,CX ; Store input data port
	MOV	WORD PTR TCID+CID_OPORT,CX ; Store output data port
	ADD	CX,EPSTAT-EPDATA ; Compute status port
	MOV	WORD PTR TCID+CID_SPORT,CX ; Store status port
	ADD	CX,EPCMD-EPSTAT ; Compute command port
	MOV	WORD PTR TCID+CID_CPORT,CX ; Store command port	

; Check if handshaking is ok and setup ready and polarity masks

	MOV	CL,TCID+CID_CHRD+CHRD_HSHK ; Get handshaking type
	CMP	CL,CHRDH_MAX	; Is type valid ?
	JNA	CHRCTS_SER2	;   Yes, skip
	JMP	CHRCTS_BEX	;   No, join failure exit
CHRCTS_SER2:
	XOR	CH,CH		; Clear upper half
	MOV	DI,CX		; Make avail as index
	SHL	DI,1		; Mult by 4 (the size of a table entry)
	SHL	DI,1
	MOV	CL,BYTE PTR CHRCTS_SITAB+0[DI] ; Get first entry
	MOV	TCID+CID_IRM,CL	; Store input ready mask
	MOV	CL,BYTE PTR CHRCTS_SITAB+1[DI] ; Get second entry
	MOV	TCID+CID_IPM,CL	; Store input polarity mask
	MOV	CL,BYTE PTR CHRCTS_SITAB+2[DI] ; Get third entry
	MOV	TCID+CID_ORM,CL	; Store output ready mask
	MOV	CL,BYTE PTR CHRCTS_SITAB+3[DI] ; Get fourth entry
	MOV	TCID+CID_OPM,CL	; Store output polarity ready mask

; Program the 2661

	MOV	DX,WORD PTR TCID+CID_CPORT ; Get command port
	MOV	CL,AL		; Save AL
	CLI			; Disable interrutps
	XOR	AL,AL		; Turn unit off
	OUT	DX,AL 
	IN	AL,DX		; Reset mode register ptr
	MOV	AL,BYTE PTR TCID+CID_CHRD+CHRD_BCTL ; Get mode reg 1
	AND	AL,CHRDB_SB+CHRDB_PT+CHRDB_PC+CHRDB_CL ; Issolate settable bits
	OR	AL,EPA16X	; Add mode factor
	MOV	DX,EPMODE	; Get mode port offset	
	ADD	DX,WORD PTR TCID+CID_CHRD+CHRD_PORT ; Compute mode port
	OUT	DX,AL		; Set mode reg 1
	MOV	AL,EPMR2A	; Get mode/clk selector mode reg 2
	OR	AL,BYTE PTR TCID+CID_CHRD+CHRD_BAUD ; Add baud rate
	OUT	DX,AL		; Set mode reg 2
	MOV	AL,EPNORM+EPRTS+EPRESE+EPRXEN+EPDTR ; Get command to turn on 2661
	MOV	DX,WORD PTR TCID+CID_CPORT ; Get command port
	OUT	DX,AL		; Turn on 2661
	MOV	DX,WORD PTR TCID+CID_IPORT ; Get input port
	IN	AL,DX		; Clear device
	IN	AL,DX
	MOV	AL,CL		; Restore AL
	STI			; Restore interrupts
	JMP	CHRCTS_GEX	; Join common exit

CHRCTS_SITAB:

; No handshaking: input ready, input polarity, output ready, output polarity
	DB	EPRXR
	DB	0
	DB	EPTXR
	DB	0

; <ACK>/<ETX>:input ready, input polarity, output ready, output polarity
	DB	EPRXR
	DB	0
	DB	EPTXR
	DB	0

; <DC3>/<DC1>: input ready, input polarity, output ready, output polarity
	DB	EPRXR
	DB	0
	DB	EPTXR
	DB	0

; DCD high: input ready, input polarity, output ready, output polarity
	DB	EPDCD+EPRXR
	DB	0
	DB	EPDCD+EPTXR
	DB	0

; DCD low: input ready, input polarity, output ready, output polarity
	DB	EPDCD+EPRXR
	DB	0
	DB	EPDCD+EPTXR
	DB	EPDCD

; DSR high: input ready, input polarity, output ready, output polarity
	DB	EPDSR+EPRXR
	DB	0
	DB	EPDSR+EPTXR
	DB	0

; DSR low: input ready, input polarity, output ready, output polarity
	DB	EPDSR+EPRXR
	DB	0
	DB	EPDSR+EPTXR
	DB	EPDSR

; PIA Parallel 

CHRCTS_PAR:
	MOV	CX,ZPIA		; Get Base port
	MOV	WORD PTR TCID+CID_CHRD+CHRD_PORT,CX ; Store it
	ADD	CX,PIADATB	; Compute status port
	MOV	WORD PTR TCID+CID_SPORT,CX ; Store status port
	ADD	CX,PIADATA-PIADATB ; Compute output data port
	MOV	WORD PTR TCID+CID_OPORT,CX ; Store output data port
	MOV	BYTE PTR TCID+CID_CHRD+CHRD_HSHK,CHRDH_NO ; No handshaking
	MOV	BYTE PTR TCID+CID_ORM,00000001B ; Store output ready mask
	MOV	BYTE PTR TCID+CID_OPM,00000001B ; Store output polarity mask
	JMP	CHRCTS_GEX	; Join common exit


; Common success exit for set up

CHRCTS_GEX:

; Copy temp CID to CID at SI
	
	PUSH	SI		; Save SI for later
	MOV	DI,SI		; Set up DI, SI for move
	MOV	SI,OFFSET TCID
	PUSH	ES		; Save ES
	PUSH	DS		; Set up ES
	POP	ES
	MOV	CX,CID_SIZE	; Get size of CID
	CLD
	REP MOVSB		; Copy CID
	POP	ES		; Recover ES

	POP	SI		; Recover SI
	MOV	DI,CID_CLASS[SI] ; Get class
	CALL	WORD PTR CHRFCTIC[DI] ; Clear input queue

	POP	CX		; Recover CX
	CLC			; Show success
	RET			; And return


; Common failure exit for set up

CHRCTS_BEX:
	POP	CX		; Recover CX
	MOV	AX,CHRE_BSUP	; Get BAD SETUP error code
	STC			; Show failure
	RET			;  and return



; Check if subfunction is clear input

CHRFCT1:
	CMP	AL,CHR_CFCI	; Is function clear input ?
	JNE	CHRFCT2		;   No, skip

	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFCTIC[DI] ; Case to device
	RET			; And return

CHRFCTIC:
	DW	OFFSET CHRCTI_CRT
 	DW	OFFSET CHRCTI_SER
	DW	OFFSET CHRCTI_PAR


; Internal video/keyboard clear input

CHRCTI_CRT:
	PUSH	BX		; Save regs
	MOV	BX,OFFSET CQ_ZCON ; Get addr of queue descriptor
CHRCTI_QF:
	CLI			; Disable interrupts
	CALL	Q_FLUSH		; Clear the typeahead queue
	STI			; Turn interrupts back on
	CLC			; Show success
	POP	BX		; Restore regs
	RET			;  and return


; 2661-1 clear input

CHRCTI_SER:
	CLI			; Disable interrupts
	MOV	DX,WORD PTR CID_CPORT[SI] ; Get command port
	IN	AL,DX		; Get current command
	AND	AL,NOT EPRXEN	; Turn off receiver
	OR	AL,EPRESE	;   and clear errors
	OUT	DX,AL		; Do it
	OR	AL,EPRXEN	; Or in command to turn it on
	OUT	DX,AL		; Turn on receiver
	MOV	DX,WORD PTR CID_IPORT[SI] ; Get input port
	IN	AL,DX		; Clear receiver
	IN	AL,DX
	MOV	DX,CID_CHRD+CHRD_PORT[SI] ; Get base port
	CMP	DX,ZSERA	; Is it the serial A port ?
	JNE	CHRCTI_SER1	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERA ; Get addr of queue descriptor
	JMP	CHRCTI_QF	; Join common code
CHRCTI_SER1:
	CMP	DX,ZSERB	; Is it the serial B port ?
	JNE	CHRCTI_SER2	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERB ; Get addr of queue descriptor
	JMP	CHRCTI_QF	; Join common code
CHRCTI_SER2:
	CLC			; Show success
	STI			; Turn on interrupts
	RET			;  and return


; PIA clear input

CHRCTI_PAR:
	;
	; (Nothing to do)
	;
	CLC			; Show success
	RET			;  and return


; Check if subfunction is clear output

CHRFCT2:
	CMP	AL,CHR_CFCO	; Is subfunction clear output ?
	JE	CHRFCT3		;    Yes, go to it
	MOV	AX,CHRE_ILGFL	;    No, get error code
	STC			; Show failure
	RET			;  and return

CHRFCT3:
	MOV	DI,CID_CLASS[SI] ; Get device class
	CALL	WORD PTR CHRFCTOC[DI] ; Case to device
	RET			; and return

CHRFCTOC:
	DW	OFFSET CHRCTO_CRT
	DW	OFFSET CHRCTO_SER
	DW	OFFSET CHRCTO_PAR


; Internal video/keyboard clear output

CHRCTO_CRT:
	;
	; (Nothing to do)
	;
	CLC			; Show success
	RET			;  and return


; 2661-2 clear output
	
CHRCTO_SER:
	MOV	AL,EPNORM+EPRTS+EPRESE+EPDTR+EPRXEN ; Turn off transmitter
	MOV	DX,WORD PTR CID_CPORT[SI] ; Get command port
	OUT	DX,AL		; Turn off transmitter
	CLC			; Show success
	RET			;   and return


; PIA clear output

CHRCTO_PAR:
	;
	; (Nothing to do)
	;
	CLC			; Show success
	RET			;   and return
CHRFCT	ENDP


 
;
; UPCASE - Convert character to uppper case
;
;     Call with:
;         AL - character to convert
;
;     Returns:
;         AL - converted char
;

UPCASE	PROC NEAR
	CMP	AL,'a'		; Is character less than an 'a' ?
	JB	UPCASE1		;   Yes, skip to end
	CMP	AL,'z'		; Is character greater than a 'z' ?
	JA	UPCASE1		;   Yes, skip to end
	AND	AL,05FH		;   No, convert to upper case
UPCASE1:
	RET
UPCASE	ENDP
	PAGE

;
;	default interrupt handler routines
;

;
;****	NOTE: The interrupt routines are on a physical device level, i.e.
;	there is no way to interrupt on PRN or AUX or CON output, but only
;	on the physical i/o to Serial A, Serial B, CRT/KYB, or Light pen
;

;
;  ISR_UKB - User keyboard interrupt
;  ISR_UCRT - User CRT output interrupt
;
;	ENTRY:
;		AL = Keycode
;		AH = 0 if no one has yet handled this key
;
;	EXIT:
;		AL = Keycode
;		If (AH = 0 on entry)
;			AH = 0 if we don't want it
;			AH != 0 if we processed it (BIOS will ignore)
;		else
;		AH != 0
;
;	USES:	AH
;
;	NOTE: Users should exit from their routine by simply using
;	a JMPF to the next routine wanting interrupts (found at
;	0:int_uk). In this way, more than one routine can trap keyboard
;	keys. The use flag (in AH) is used to inform the bios that
;	the key code is special (if AH != 0) and should NOT be placed
;	in the queue, or is not special (if AH = 0) and should be
;	treated as a normal character.
;

ISR_UKB:
;	IRET				; Return to BIOS
ISR_UCRT:
;	IRET

;
;	ISR_USAI - Serial A interrupt routine
;	ISR_USAO - Serial A output routine
;
;	ENTRY, EXIT, USAGE, and NOTES from above apply
;

ISR_USAI:
;	IRET
ISR_USAO:
;	IRET

;
;	ISR_USBI - Serial B interrupt routine
;	ISR_USBO - Serial B output routine
;	ENTRY, EXIT, USAGE, and NOTES from above apply
;

ISR_USBI:
;	IRET
ISR_USBO:
;	IRET

;
;	ISR_ULP - Light Pen interrupt routine
;
;	ENTRY:
;		BX	=	Character address of hit
;				Address is (line * 80) + column
;
;		AL	=	Address within the character cell
;
;				76543210
;				****		-	Scan line hit
;				    *		-	Not used
;				     ***	-	pixel on scan line
;
;	EXIT:	NONE
;
;	USES:	NONE
;
;	See notes on interrupt handling above
;

ISR_ULP:
;	IRET

;
;	ISR_PRSC - Print Screen Subroutine
;
;	Entry:	None
;
;	Exit:	None
;
;	Uses:	None
;

ISR_PRSC:
;	IRET

;
;	ISR_VSYN - Vertical Sync Subroutine
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	None
;

ISR_VSYN:
	IRET

