;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
	PAGE	,132
	TITLE	BCLOCK - BIOS clock

TOD_LIM	EQU	2	; # of minutes between clock updates
MAX_DSKVAL =	60*100	; # of ticks for max disk timeout

	.LFCOND
	.TFCOND		; Use /X to cause FALSE conds not to be listed

;
;  BIOS clock routines
;

	INCLUDE	PARMS.ASM

    IF LISTI
	IF1
	%OUT	*Full listing beging generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF
	.XLIST
    ENDIF

	INCLUDE	DEFCONFG.ASM
	INCLUDE	DEF8259A.ASM	
	INCLUDE	DEF8253.ASM
	INCLUDE	DEFDOSI.ASM
	INCLUDE	DEFIPAGE.ASM
	INCLUDE	DEFCHR.ASM
	INCLUDE	DEFDSK.ASM

	.LIST
	PAGE

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	PUBLIC	ALARM_ST
	PUBLIC	ALARM_CK
	PUBLIC	ALARM_SP
	PUBLIC	ALARM_WAIT
	PUBLIC	ISR_TIM

	EXTRN	RECURLV:WORD
	EXTRN	SAVESS:WORD
	EXTRN	SAVESP:WORD
	EXTRN	BIOS_STACK:BYTE
	EXTRN	BIOS_START:NEAR
	EXTRN	BIOS_DATE:WORD
	EXTRN	BIOS_HRS:BYTE
	EXTRN	BIOS_MIN:BYTE
	EXTRN	BIOS_SEC:BYTE
	EXTRN	BIOS_HSEC:WORD
	EXTRN	PRNBUF:BYTE
	EXTRN	AUXBUF:BYTE
	EXTRN	CONBUF:BYTE
	EXTRN	BIOS_PRNFUNC:FAR
	EXTRN	BIOS_AUXFUNC:FAR
	EXTRN	BIOS_CONFUNC:FAR
	EXTRN	DSKT_FG:BYTE
	EXTRN	DSKT_PORT:WORD
	EXTRN	DSKT_DNCTR:WORD
	EXTRN	DSKT_DSEL:BYTE
	EXTRN	DSK_TPTR:BYTE

	EXTRN	TIM_FLG:BYTE
	EXTRN	TICVAL:WORD

	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG


; 
; Date and time fields
;

ALARM_FLAG	DB 0		; Alarm clock timer flag
TICCNT		DW 0		; Tic counter
PTICCNT		DW 0		; Previous tic counter value
CW100		DW 100		; Word constant 100
CB60		DB 60		; Byte constant 60

	PAGE
;
; ALARM_ST - Start alarm clock
;
;     Call with:
;         CX = tics before alarm goes off(a tic = 4 msec)
;
;     Returns:
;         Timer 2 starts running and ALARM_FLAG = FALSE
;

ALARM_ST PROC NEAR
	CLI			; Disable interrupts
	MOV	BYTE PTR CS:ALARM_FLAG,FALSE ; Show alarm hasn't gone off yet
	PUSH	AX		; Save AX
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,PITSC2+PITRLW+PITMITC ; Clear timer
	OUT	ZTIMER+PITCW,AL
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,NOT ZTIMERS2 ; Clear interrupt flag
	OUT	ZTIMERS,AL
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,CL		; Set clock period
	OUT	ZTIMER+PITC2,AL
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,CH
	OUT	ZTIMER+PITC2,AL
	POP	AX
	STI			; Restore interrupts
	RET			;  and return
ALARM_ST ENDP


;
; ALARM_CK - Check alarm and stop timer if alarm has gone off
;
;     Returns:
;         "CY" clear - alarm hasn't gone off yet
;         "CY" set - alarm has gone off(and timer cleared)
;   

ALARM_CK PROC NEAR
	CLI			; Disable interrupts
	TEST	BYTE PTR CS:ALARM_FLAG,TRUE ; Has alarm gone off ?
	JZ	ALARM_CKR	;   No, skip to end(CY is clear)
	STC			; Set CY to show alarm has gone off
ALARM_CKST:
	PUSH	AX		; Save AX
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,PITSC2+PITRLW+PITMITC ; Get command to stop timmer 2
	OUT	ZTIMER+PITCW,AL	; Stop timmer
	POP	AX		; Recover AX
ALARM_CKR:
	STI			; Turn interrupts on
	RET			;  and return
ALARM_CK ENDP

	PAGE
;
; ALARM_SP - Stop  Alarm clock
;

ALARM_SP PROC NEAR
	CLI			; Disable interrupts
	JMP	ALARM_CKST	; Join common code
ALARM_SP ENDP

	

;
; ALARM_WAIT - Start alarm clock and wait for it to go off
;
;     Call with:
;         CX = tics before alarm goes off(a tic = 4 msec)
;
;     Returns:
;         Routine delays until the specified time has elapsed
;

ALARM_WAIT PROC NEAR
	CALL	ALARM_ST	; Start clock
ALARM_WL:
	CALL	ALARM_CK	; Has time elasped ?
	JNC	ALARM_WL	;   No, look again
	RET			;   Yes, return
ALARM_WAIT ENDP

	PAGE
;
; ISR_TIM - Interrupt service routine for timer
;
;    Invoked when a timer interrupt occurs
;
;    Updates time and date variables
;        BIOS_DATE - days since Jan 1, 1980
;        BIOS_HR - hours since midnight
;        BIOS_MN - minutes
;        BIOS_SEC - seconds
;        BIOS_HSEC - hundredths of seconds
;
;    Updates disk drive variables(and deselects drive)
;        DSKT_FG - flag that drive is selected
;        DSKT_DNCTR - down counter on select time
;        DSKT_PORT - port to use to deselect drive
;        DSKT_DSEL - command to deselect drive
;
;    Checks if time to set "update disk time/day values"
;
;	Checks CHRBUF, and if a character needs outputing, it
;	is output to the PRN device.
;

ISR_TIM:
	PUSH	AX		; Save regs and set up DS
	PUSH	DX
	PUSH	DS

	MOV	AX,CS
	MOV	DS,AX

	MOV	WORD PTR TICFLG,0

; Check cause of interrupt

TIMINT1:
	IN	AL,ZDIPSW	; Time waster
	IN	AL,ZTIMERS	; Get cause of timer interrupt
	TEST	AL,ZTIMERS0	; Is it timer 0 ?
	JNZ	TIM0INT		;   Yes, go to it
	TEST	AL,ZTIMERS2	; Is it timer 2 ?
	JZ	TIMINTX		;   No, go handle it

; Handle timer 2 interrupts

TIM2INT:
	OR	BYTE PTR ALARM_FLAG,TRUE ; Set flag
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,NOT ZTIMERS2	; Clear intr
	OUT	ZTIMERS,AL
	JMP	SHORT TIMINT1	; Go check for other interrupts


; Timer interrupt exit

TIMINTX:
	MOV	AL,OCW2OP+OCW2EOI
	OUT	ZM8259A+OCW2,AL	; Tell 8259A that interrupt serviced

;	Generate user interrupt if needed

	MOV	AX,TICFLG
	OR	AX,AX
	JZ	TIMINTX1	; If not user timer interrupt
	PUSHF
	INT	INT_UTMA	; Generate interrupt
	POPF
TIMINTX1:
	POP	DS		; Restore regs
	POP	DX
	POP	AX
	IRET			;   and return


; Handle timer 0 interrupts

TIM0INT:
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,PITSC1+PITRLCL
	OUT	ZTIMER+PITCW,AL	; Latch counter 1 value
	IN	AL,ZDIPSW	; Time waster
	IN	AL,ZTIMER+PITC1	; Get counter 1's LSB
	MOV	AH,AL		; Save it
	IN	AL,ZDIPSW	; Time waster
	IN	AL,ZTIMER+PITC1	; Get counter 1's MSB
	XCHG	AH,AL		; Swap bytes into proper regs
	NEG	AX		; Take 2's complement
	MOV	TICCNT,AX	; Save it as tic count
				;  (each tic is one 100Th of a sec)
	SUB	AX,PTICCNT	; Compute elapsed tics

	TEST	BYTE PTR DSKT_FG,0FFH ; Should disk deselect be looked at ?
	JZ	TOD0		;   No, skip over
	SUB	WORD PTR DSKT_DNCTR,AX ; Decr down counter, time out ?
	JG	TOD0		;   No, skip
	MOV	DX,DSKT_PORT	;   Yes, get port number
	PUSH	AX		; Save AX
	MOV	AL,BYTE PTR DSKT_DSEL ; Get deselect command
	OUT	DX,AL		; Deselect the drive
	MOV	BYTE PTR DSKT_FG,00H ; Show disk deselected
	POP	AX		; Recover AX

TOD0:
	MOV	WORD PTR TICFLG,AX
	ADD	WORD PTR TICVAL,AX

;	Check on tim_flg update

	TEST	BYTE PTR TIM_FLG,0FFH
	JNZ	TOD0RT		; Flag set, reset timer and ignore
	ADD	WORD PTR TOD_FLG,AX
	CMP	WORD PTR TOD_FLG,100*60*TOD_LIM	; Time to set it?
	JC	TOD0NT		; Nope, ignore
	OR	BYTE PTR TIM_FLG,0FFH	; Yes, set flag
TOD0RT:
	MOV	WORD PTR TOD_FLG,0
TOD0NT:
	ADD	AX,BIOS_HSEC	; Compute new hundredths
	CMP	AX,200		; Did a lot of time go by(more than 2 sec)?
	JB	TOD1		;   No, go handle the easy case

	XOR	DX,DX		; Clear for divide
	DIV	CW100		; Word divide by 100
	MOV	BIOS_HSEC,DX	; Store remainder, which is hundredths of sec
	XOR	DH,DH		; Clear high part
	MOV	DL,BIOS_SEC	; Get seconds in DX
	ADD	AX,DX		; Compute new seconds
	DIV	CB60		; Byte divide by 60
	MOV	BIOS_SEC,AH	; Store remainder, which is seconds
	ADD	BIOS_MIN,AL	; Compute new minutes
	JMP	SHORT TOD2	;  join back with other code

TOD1:	MOV	BIOS_HSEC,AX	; Assume LT 100, Store hundredths
	SUB	AX,100		; Was assumption correct ?
	JB	TOD3		;    Yes, value was ok - so not much to do
	MOV	BIOS_HSEC,AX	;    No, store correct value
	INC	BIOS_SEC	; Bump seconds up
	MOV	AL,BIOS_SEC	; Get seconds
	SUB	AL,60		; Did seconds go up to 60
	JB	TOD3		;   No, not much to do now
	MOV	BIOS_SEC,AL	;   Yes, store new value
	INC	BIOS_MIN	; Bump minutes up
TOD2:	MOV	AL,BIOS_MIN	; Get minutes
	SUB	AL,60		; Did minutes go up to or over 60
	JB	TOD3		;   No, not much to do
	MOV	BIOS_MIN,AL	;   Yes, store correct value
	INC	BIOS_HRS	; Bump hours up
	CMP	BIOS_HRS,24	; Did hours go up to 24
	JB	TOD3		;   No, don't need to do any more
	MOV	BIOS_HRS,0	;   Yes, fix it
	INC	BIOS_DATE	; Bump days up

TOD3:	MOV	AX,TICCNT	; Get tic counter
	MOV	PTICCNT,AX	; Save it
	IN	AL,ZDIPSW	; Time waster
	MOV	AL,0FFH-ZTIMERS0	; Clear intr
	OUT	ZTIMERS,AL
	JMP	TIMINT1		; Check for more intrs

TOD_FLG	DW	0		; Counts from zero to TOD_LIM
TICFLG	DW	0		; <>0 if timer tic

;
;	ISR_UTM - Default user timer interrupt routine
;

	PUBLIC	ISR_UTM

ISR_UTM:
	PUSH	AX
	PUSH	BX
	PUSH	DX
	PUSH	SI
	PUSH	DI

;	First on the list. Update all disk I/O timer values

	PUSH	CX
	MOV	DI,OFFSET DSK_TPTR
	MOV	CX,MAXDSK8		; Do all floppies
UPCNT:
	MOV	BX,CS:WORD PTR [DI]
	CMP	CS:WORD PTR [BX.DSK_TIMOUT],MAX_DSKVAL
	JNC	UPCNT1
	INC	CS:WORD PTR [BX.DSK_TIMOUT]	; Count some
UPCNT1:
	ADD	DI,2			; Go to next one
	LOOP	UPCNT			; do it
	POP	CX

;	Check to see if a device has data to output. First PRN

	CMP	CS:BYTE PTR PRNBUF,0
	JZ	ISR_UTM2		; If not, nothing to do

	MOV	AL,CS:BYTE PTR PRNBUF+1
	MOV	CS:BYTE PTR PRNBUF,0
	MOV	AH,CHR_WRITE

	PUSH	CS
	CALL	NEAR PTR BIOS_PRNFUNC	; Print it

;	Now check AUX

ISR_UTM2:
	CMP	CS:BYTE PTR AUXBUF,0
	JZ	ISR_UTM3		; AUX has nothing for us
	MOV	AL,CS:BYTE PTR AUXBUF+1
	MOV	CS:BYTE PTR AUXBUF,0	; Assume AUX output ok
	MOV	AH,CHR_WRITE
	PUSH	CS
	CALL	NEAR PTR BIOS_AUXFUNC

;	Now check the CON device

ISR_UTM3:
	CMP	CS:BYTE PTR CONBUF,0
	JZ	ISR_UTM1		; Nothing for CON

	MOV	AL,CS:BYTE PTR CONBUF+1
	MOV	CS:BYTE PTR CONBUF,0	; Assume character output ok
	MOV	AH,CHR_WRITE
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_CONFUNC

ISR_UTM1:
	POP	DI
	POP	SI
	POP	DX
	POP	BX
	POP	AX
	IRET

BIOS_SEG ENDS

	END


