;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;


PAGE	,132
	TITLE	FONTLD - Load alternate character font

	INCLUDE	DEFMS.ASM
	INCLUDE	DEFMTR.ASM

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	ORG	0
	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

	PUBLIC	FONTLD
	EXTRN	ROM_VER:BYTE,MTR_DS_VAL:WORD,FNT_TAB:BYTE,BDRIVE:BYTE

;**	FONTLD - Load the file ALTCHAR.SYS on the default drive
;
;	FONTLD is called at init time to load the ALTCHAR.SYS file
;	from the boot (default) drive into memory
;
;

FONTLD	PROC	NEAR
	MOV	AL,BYTE PTR BDRIVE
	ADD	AL,'A'				; AL = drive letter
	MOV	BYTE PTR FNT_FCB,AL
	MOV	DX,OFFSET FNT_FCB
	MOV	AX,DOSF_OPENH*256+DOSFO_RED
	INT	21H				; Open the font file
	JNC	FONTLD1				; If opened ok
	RET
FONTLD1:
	MOV	BX,AX				; BX = font file handle
RD_KY1:
	MOV	DX,OFFSET FNT_BUF
	MOV	CX,2
	MOV	AH,DOSF_READH			; Read 2 bytes (keyboard map)
	INT	21H
	JC	FONT_EOF
	CMP	AX,2
	JNZ	FONT_EOF
RD_KY2:
	MOV	CX,WORD PTR FNT_BUF		; CX = keyboard code
	INC	CX
	JZ	RD_CHR				; If end of keyboard stuff
	MOV	AL,BYTE PTR FNT_BUF
	XOR	AH,AH
	MOV	SI,AX				; SI = index to old one
	CMP	BYTE PTR ROM_VER,2
	JNC	RD_KY3
	DEC	SI
	DEC	SI
RD_KY3:
	PUSH	DS
	MOV	AX,WORD PTR MTR_DS_VAL
	MOV	DS,AX				; DS points to it
	MOV	AL,CS:BYTE PTR FNT_BUF+1	; AL = new code
	MOV	DS:BYTE PTR [SI+MTR_KYB],AL	; Map it in
	POP	DS
	JMP	RD_KY1

;	Now do the character font stuff

RD_CHR:
	MOV	DX,OFFSET FNT_BUF
	MOV	CX,1				; Read the index byte
	MOV	AH,DOSF_READH
	INT	21H
	JC	FONT_EOF			; If error on read
	CMP	AX,1				; or not enough read
	JNZ	FONT_EOF

	MOV	AL,BYTE PTR FNT_BUF		; AL = character index
	CMP	AL,0FFH
	JZ	FNT_CHR				; If all done

	XOR	AH,AH
	MOV	DX,AX
	MOV	CL,3				; * 8 + 1
	SHL	DX,CL
	ADD	DX,AX				; Location for it
	CMP	DX,MTR_FNT_SIZE
	JNC	FONT_EOF			; If too big, file error
	ADD	DX,OFFSET FNT_TAB
	MOV	AH,DOSF_READH
	MOV	CX,9
	INT	21H				; Read it into place
	JC	FONT_EOF
	CMP	AX,9
	JNZ	FONT_EOF			; If did not work
	JMP	RD_CHR

;	Handle EOF on the font file

FONT_EOF:
	MOV	AH,DOSF_CLOSEH
	INT	21H				; Close the file
	RET

;	Now map the font value

FNT_CHR:
	MOV	DX,OFFSET FNT_BUF
	MOV	CX,2
	MOV	AH,DOSF_READH			; Read some
	INT	21H
	JC	FONT_EOF
	CMP	AX,2
	JNZ	FONT_EOF			; Did not get them all
RD_CH2:
	MOV	CX,WORD PTR FNT_BUF
	INC	CX
	JZ	FONT_EOF

	MOV	AL,BYTE PTR FNT_BUF
	XOR	AH,AH
	MOV	SI,AX
	CMP	BYTE PTR ROM_VER,2
	JNC	RD_CH3
	DEC	SI
	DEC	SI
RD_CH3:
	PUSH	DS
	MOV	AX,WORD PTR MTR_DS_VAL
	MOV	DS,AX
	MOV	AL,CS:BYTE PTR FNT_BUF+1
	MOV	DS:BYTE PTR [SI+MTR_CHR],AL
	POP	DS
	JMP	SHORT FNT_CHR

FNT_FCB	DB	'X:\ALTCHAR.SYS',0

FNT_BUF	DB	0,0

FONTLD	ENDP
BIOS_SEG	ENDS

	END
