;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
;  DSK - This routine provides the necessary code to perform all disk I/O.
;
;        The particular function to perform is passed in the AL register.
;
;  Call with:
;
;    The register pair ES:BX points to a parameter block(for all functions
;    except GBIOSVEC and  MAPDSK) with the following fields:
;
;      DSKPR_DRIVE (byte):
;         Logical drive number (0-MAXDSK allowed)
;      DSKPR_SECTOR (word):
;         Logical sector number
;            (0-drive_max allowed)
;         (On read/write track function, side flag:
;            0 - side zero, 1 - side one)
;      DSKPR_COUNT (word):
;	transfer count
;            (1-?? (total bytes must fit within the same segment))
;      DSKPR_BUFF (double word):
;         Address of buffer. The first word is the offset, the second word is
;         the segment.
;
;  Register AL has the function to perform
;   (AL) = DSK_RESET - Reset disk(home head)
;   (AL) = DSK_STATUS - Get disk status(on success AH=aux status,AL=status)
;   (AL) = DSK_STEPIN - Step in head
;   (AL) = DSK_READ - Read the specified sectors to the buffer addr
;   (AL) = DSK_WRITE - Write the specified sectors from the buffer addr
;   (AL) = DSK_VERIFY - Verify the specified sectors. (Not implemented yet)
;   (AL) = DSK_FORMAT - Format a track.
;           The write track command is used to write the data at DSK_BUFF.
;   (AL) = DSK_READTRK - Perform the read track command.
;   (AL) = DSK_GBIOSVEC - Get addr of disk vector used by the BIOS in ES:BX.
;   (AL) = DSK_MAPDSK - Maps logical in AH to physical in AL
;   (AL) = DSK_SETFDC - Set force disk has been changed flag(DSK_FDC)
;   (AL) = DSK_PREAD - Same as DSK_READ but do not apply BSEC value
;   (AL) = DSK_ASSIGN - Set up BSEC and FATS values in partition
;   (AL) = DSK_PWRITE - Same as DSK_WRITE but no BSEC applied
;
;  Returns:
;   AX = Status of operation
;         (See DEFDSK.ASM)
;   CY = 0 - Operation was a success
;   CY = 1 - Operation failed (see AX)
;   For DSK_READ and DSK_WRITE:
;     DSKPR_COUNT = number of sectors not read/written
;     DSKPR_BUFF = Addr at end of read/write
;   For DSK_GBIOSVEC:
;     ES:BX -> vector of disk table addresses
;
;
;  All register are used.
;  Segment registers are perserved.
;  (DS must be set up before call)
;
;  Last modified: 9/28/82 - bcb
;

BDSK207	PROC NEAR
	CMP	BYTE PTR DSK_FUN,DSK_SETFDC ; Is Set Force Disk change ?
	JNE	D0E1		;   No, skip
	OR	BYTE PTR DSK_FLAG[SI],DSK_FDC ; Set flag
	XOR	AX,AX		; Clear CY to show success
	RET			;   and return


; Check if proper disk is in drive

D0E1:
	TEST	BYTE PTR DSK_IMGFLG[SI],DSKIF_DV ; Is correct disk in drive ?
	JNZ	D0E2		;   Yes, skip
	CLI			;   No, disable interrupts
	XOR	AL,AL		; Get deselect command
	CALL	DSK_OCON	; Deselect all drives
	MOV	BYTE PTR DSK_DBIT,FDFDLF ; Force delay
	MOV	BYTE PTR DSKT_FG,00H ; Disable timer from deselecting drive
	STI			; Turn interrupts back on
	CALL	GRD		; Prompt user to switch diskettes
	JMP	DSKSL		; Join common code


; Check if current and previous disks are the same and timer hasn't run out

D0E2:
	CMP	SI,DSK_LDRIVE	; Is current disk same as last disk ?
	JNE	DSKSL		;   No, join select code
	CLI			; Disable interrupts 
	TEST	BYTE PTR DSKT_FG,0FFH ; Has timeout occured ?
	JNZ	D0E4		;   No, skip
	STI			; Turn interrupts back on

; Wait for head to unload

	MOV	CX,FDHULDM	; Get head unload multiplier
D0E3:
	CALL	DSK_LWAIT	; Wait for head to completely unload
	LOOP	D0E3
	JMP	DSKSL		; Join common select code


D0E4:
	MOV	BYTE PTR DSKT_FG,00H ; Disable timer from deselecting drive
	MOV	BYTE PTR DSK_DBIT,00H ; Set no delay needed
	STI			; Enable interrupts
	JMP	D1C		; Join common code to start operation


; Select drive and load head

DSKSL:
	CLI			; Disable interrupts
	MOV	BYTE PTR DSK_DBIT,FDFDLF ; Set delay bit
	XOR	AH,AH		;  Get a zero
	XCHG	AH,BYTE PTR DSKT_FG ; Disable timer from deselecting drive
	MOV	DSK_LDRIVE,SI	; Save drive number
	STI			; Turn interrupts back on
	XOR	AL,AL		; Get deselect command
	CALL	DSK_OCON	; Deselect previous drive
	MOV	AL,BYTE PTR DSK_SEL[SI] ; Get select command
	TEST	AL,CONDS8	; Is drive an 8 incher ?
	JNZ	DSKSL2		;   Yes, go to it

; 5.25 inch Startup

	CALL	DSK_OCON	; Select current drive
	OR	AH,AH		; Has disk timed out ?
	JNZ	DSKSL5		;   No, skip motor start up
	CALL	DSK_IAS		; Get Aux status
	TEST	AL,ASMO		; Is motor running ?
	JNZ	DSKSL5		;   Yes, skip motor start up

; Wait for motor to come up to speed

	MOV	CX,FD5MOM	; Get 5.25 motor multiplier
DSKSL1:
	CALL	DSK_LWAIT	; Wait for motor to come up to speed
	LOOP	DSKSL1
	JMP	DSKSL5		; Join common code


DSKSL2:

; 8 inch Startup


; Ensure side zero is selected if single sided disk and
; previous operation was on side one

	CMP	BYTE PTR SIDFLG,0 ; Was side zero used last ?
	JE	DSKSL3		;   Yes, nothing to do
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FDS ; Is disk double sided ?
	JNZ	DSKSL3		;   Yes, nothing to do

; Disk is single sided and side one was used last.
; Force select of side 0.

	MOV	AL,FDCRDA	; Get read address command
	CALL	DSK_OCMD	; Issue command
	CALL	DSK_WAIT	; Wait a little bit for command to start
	MOV	AL,FDCFI+FDFINI	; Get force interrupt command
	CALL	DSK_OCMD	; Force interrupt to stop command
	CALL	DSK_WAIT	; Wait for things to settle

; Clear DRQ bit(if present)

	CALL	DSK_IDAT	; Read data returned to clear
	CALL	DSK_ISTA	; Read status


DSKSL3:
	MOV	AL,BYTE PTR DSK_SEL[SI] ; Get select command
	CALL	DSK_OCON	; Select current drive

; Wait for motor to come up to speed

	MOV	CX,FD8NRD	; Get 8 inch counter
DSKSL4:
	CALL	DSK_ISTA	; Get status
	TEST	AL,FDSNRD	; Is disk not ready
	LOOPNZ	DSKSL4		; Keep looping if not ready and counter not 0

DSKSL5:

; Load head

	TEST	BYTE PTR DSK_FLAG[SI],DSK_FSL ; Should we skip head load ?
	JNZ	D1C		;   Yes, skip

	CALL	DSK_ITRK	; Get current track
	CALL	DSK_ODAT	; Set desired track
	MOV	AL,FDCSEK+FDFHLB ; Get seek command to load head
	CALL	DSK_EXCMD	; Load head

; Wait for head to load

	MOV	CX,FDHLDM	; Get head load multiplier
DSKSL6:
	CALL	DSK_LWAIT	; Wait for head to load
	LOOP	DSKSL6


; Go to function
;   (DI has function index)

D1C:
	JMP	WORD PTR D3[DI]	; Case to function

D3	DW      OFFSET DSKFRS	; Restore function
  	DW	OFFSET DSKFST	; Status function
	DW	OFFSET DSKFRD	; Read function
	DW	OFFSET DSKFWR	; Write function
	DW	OFFSET DSKFVF	; Verify function
	DW	OFFSET DSKFFT	; Format function
	DW	OFFSET DSKFSI	; Step in function
	DW	OFFSET DSKFRT	; Read track function
	DW	OFFSET DSKBDO	; GBIOSVEC
	DW	OFFSET DSKBDO	; MAPDSK
	DW	OFFSET DSKBDO	; SETFDC
	DW	OFFSET DSKFRD	; PREAD
	DW	OFFSET DSKBDO	; ASSIGN
	DW	OFFSET DSKFWR	; PWRITE
	PAGE
;
; GRD - Get required disk
;
;     GRD insures that the disk being accessed is in
;     the needed drive. If not, it will prompt the
;     user for the disk.
;
;     Call with:
;         SI -> to disk table
;         ES:BX	-> disk packet
;
;     USES: AX, CX
;

GRD	PROC NEAR

	PUSH	SI				; Save Regs
	PUSH	DI
	PUSH	BX

	MOV	BYTE PTR DSK_DBIT,FDFDLF	; Turn on delay flag

	PUSH	SI				; Save drive pointer
	TEST	BYTE PTR DSK_IMGFLG[SI],DSKIF_ID ; Is drive imaginary ?
	JZ	GRD2				;    No,a real drive

; User accessing a phantom drive, link to real drive

	MOV	AL,BYTE PTR DSK_IMGFLG[SI]	; Get real drive number
	AND	AL,DSKIF_DN			; Isolate drive bits
	XOR	AH,AH				; Clear upper part
	SHL	AX,1				; Make into word index
	MOV	SI,AX				; Make avail
	MOV	SI,DSK_TPTR[SI]			; Get pointer to real drive

; See if real drive already in use by other phantom diskette

	TEST	BYTE PTR DSK_IMGFLG[SI],DSKIF_DV ; Is real drive valid ?
	JNZ	GRD3				;   Yes, Not in use by others

; Drive is in use by other phantom disk, update values

GRD2:	
	MOV	AL,BYTE PTR DSK_IMGFLG[SI]	; Get real drive number
	AND	AL,DSKIF_DN			; Issolate those bits
	XOR	AH,AH				; Clear high part
	SHL	AX,1				; Make into word index
	MOV	DI,AX				; Make avail
	MOV	DI,DSK_TPTR[DI]			; ptr to destination pointer

; Back data from DI to SI tables

	AND	BYTE PTR DSK_IMGFLG[DI],0FFH-DSKIF_DV
	AND	BYTE PTR DSK_IMGFLG[SI],0FFH-DSKIF_DN
	MOV	AL,BYTE PTR DSK_LTRK[DI]
	MOV	BYTE PTR DSK_LTRK[SI],AL

; Real drive now all set

GRD3:	POP	DI				; DI desired drive
	TEST	BYTE PTR DSK_IMGFLG[DI],DSKIF_ID ; Was it a real drive ?
	JZ	GRD4				;   Yes, skip

; Update logical drives tables

	MOV	AL,BYTE PTR DSK_LTRK[SI]
	MOV	BYTE PTR DSK_LTRK[DI],AL
	MOV	AL,BYTE PTR DSK_SEL[SI]
	AND	AL,CONDS			; Isolate unit number
	MOV	AH,AL				; Save it
	MOV	AL,BYTE PTR DSK_SEL[DI]
	AND	AL,NOT CONDS	
	OR	AL,AH				; AL = new drive select
	MOV	BYTE PTR DSK_SEL[DI],AL
	AND	BYTE PTR DSK_IMGFLG[SI],NOT DSKIF_DV
	OR	BYTE PTR DSK_IMGFLG[DI],DSKIF_DV
	MOV	AL,BYTE PTR DSK_NAME[DI]
	SUB	AL,'A'				; Make binary
	AND	AL,DSKIF_DN
	MOV	AH,BYTE PTR DSK_IMGFLG[SI]
	AND	AH,NOT DSKIF_DN
	OR	AL,AH
	MOV	BYTE PTR DSK_IMGFLG[SI],AL	; Show where it is at

; Get disk from user

GRD4:
	MOV	AL,BYTE PTR DSK_NAME[DI]
	MOV	BYTE PTR GRDA,AL
	TEST	BYTE PTR DSK_IMGFLG[DI],DSKIF_ID
	JNZ	GRD5
	OR	BYTE PTR DSK_IMGFLG[DI],DSKIF_DV
	JMP	SHORT GRD6

GRD5:	MOV	AL,BYTE PTR DSK_IMGFLG[DI]
	AND	AL,DSKIF_DN			; Get his real drive
	ADD	AL,'A'

GRD6:	MOV	BYTE PTR GRDB,AL
	MOV	BX,OFFSET GRDMSG
	MOV	CH,OFFSET GRDMSGL
	CALL	PMESG				; Request disk from user

;	Flush keyboard buffer

	MOV	AH,OFFSET CHR_CONTROL
	MOV	AL,OFFSET CHR_CFCI
	PUSH	CS
	CALL	NEAR PTR BIOS_CONFUNC		; Flush type-ahead

;	Get a key from user

GRD7:
	MOV	AH,CHR_READ
	PUSH	CS
	CALL	NEAR PTR BIOS_CONFUNC		; Get a character
	JC	GRD7
	CMP	AL,0DH				; RETURN?
	JNZ	GRD7

	POP	BX
	POP	DI
	POP	SI

	RET

;	Message for user prompt

GRDMSG	DB	CC_BEL,'Place disk '
GRDA	DB	'x in drive '
GRDB	DB	'x:.',CC_CR,CC_LF,'Press RETURN when ready.',CC_CR,CC_LF
GRDMSGL	EQU	54

GRD	ENDP
	PAGE
;
;  Restore(home) disk function
;
;    Clear errors and move head to track zero.
;      (ES:BX has parameter block addr,SI has offset of disk parameter table)
;
;
;  DSKBDO - Entry point for all invalid functions
;

DSKFRS:
	CALL	DSK_RST		; Restore the disk
	JC	D5
	XOR	AH,AH		; Clear AH
	TEST	AL,FDSTK0	; Did we find track 0 ? 
	JNZ	D5		;   Yes, all is well
DSKBDO:
	STC			;   No, set CY to show error
D5:	JMP	DSK_DSEL	; Deselect drive and return


;
;  Status function
;
;    Clear errors and get current status
;      (ES:BX has parameter block addr,SI has offset of disk parameter table)
;
;	4/23/82 - Returns AUXSTAT in AH if no errors
;
	
DSKFST:
	MOV	AL,FDCFI+FDFINI	; Get command to force Type I Status
	CALL	DSK_OCMD	; Force Type I status
	CALL	DSK_WAIT	; Wait around for things to settle
	CALL	DSK_ISTA	; Get status
	MOV	CL,AL		; Save status
	CALL	DSK_IAS		; Read aux status
	MOV	AH,AL		; AH gets AUXSTAT
	MOV	AL,CL		; AL get Status

; See if there is a disk in the drive (it's already running)

	TEST	AL,FDSIND	; Do we see an index hole?
	JZ	DSKFST3		;   No, Must be a disk in the drive

; We see a hole, wait for it to leave, but time wait

	PUSH	AX		; Save status
	MOV	CX,DSK_LDELAY[SI]; Get long delay tic count
	CALL	ALARM_ST	; Start alarm clock
DSKFST0: 
	CALL	DSK_ISTA	; Get status in AL
	TEST	AL,FDSIND	; Still at hole ?
	JZ	DSKFST1		;   No, all done
	CALL	ALARM_CK	; Was alarm gone off ?
	JNC	DSKFST0		;   No, keep looking

; Timed out, Must not be a disk in the drive

	POP	AX		; Get status
	OR	AL,FDSNRD	; Show disk not ready
	JMP	SHORT DSKFST3	; Skip to common exit

; No index hole, disk must be there

DSKFST1:
	CALL	ALARM_SP	; Stop clock
	POP	AX		; Restore status

; Common exit

DSKFST3:
	TEST	AL,FDSNRD	; Was drive ready ?
	JZ	DSKFST4		;   Yes, skip
	XOR	AH,AH		;   No, set error
	OR	AX,DSKST_NDERR
	STC
DSKFST4:
	JMP	DSK_DSEL

	PAGE
;
;  Verify disk function
;

DSKFVF:
	MOV	BYTE PTR DSK_FUN,DSK_READ
	MOV	BYTE PTR VERFLG,1	; Flag a verify operation
	JMP	NEAR PTR DSKFRDV

;
;  Read track function
;      (ES:BX has parameter block addr, SI has offset of disk parameter table) 

DSKFRT:
	XOR	DL,DL		; Assume side 0
	TEST	ES: WORD PTR DSKPR_SECTOR[BX],0FFFFH ; Was assumption correct ?
	JZ	DSKFRT1		;   Yes, skip
	MOV	DL,FDFSS1	;   No, get side one flag
DSKFRT1:
	MOV	BYTE PTR SIDFLG,DL ; Set side flag
	MOV	AL,DSK_SEL[SI]	; Get disk select command
	OR	AL,CONWE	; Add in wait states
	CALL	DSK_OCON
	MOV	CX,DSK_BPRT[SI]	; Get bytes per track(when reading) 
	PUSH	ES		; Save ES
	LES	DI,ES:DWORD PTR DSKPR_BUFF[BX] ; Get buffer addr in ES:DI
	CLD			; Set direction
	PUSHF			; Save interrupt status
	CLI			; Disable interrupts
	MOV	AL,DSK_RDT[SI]	; Get read track command
	OR	AL,BYTE PTR SIDFLG ; Or in side 
	MOV	DX,DSK_PORT[SI]	; Get base port
	ADD	DX,FDDAT	; Compute data port
	PUSH	DX		; Save it
	MOV	DX,DSK_PORT[SI] ; Get base port
	ADD	DX,FDCMD	; Compute command port
	OUT	DX,AL		; Start read
	POP	DX		; Get data port

DSKFRT2:
	IN	AL,DX		; Get next data byte
	STOS	BYTE PTR ES:[DI] ; Save the byte
	LOOP	DSKFRT2		; Get more

	MOV	AL,DSK_SEL[SI]	; Get select command
	CALL	DSK_OCON	; Turn offf wait state I/O
	CALL	DSK_WCMPLT	; Wait for read to complete
	POPF			; Recover interrupt status
	POP	ES		; Restore ES
	CALL	DSK_WAIT	; Wait some more
	MOV	BYTE PTR DSK_LOPT[SI],DSK_ORT ; Show last operation
	TEST	AL,FDSNRD	; Was not ready seen ?
	JZ	DSKFRT3		;   No, skip
	MOV	BYTE PTR DSK_LOPT[SI],DSK_OUK ; Show error
	STC
DSKFRT3:
	MOV	AH,0
	JMP	DSK_DSEL
	PAGE
;
;  Read disk and Write disk functions
;
;      (ES:BX has parameter block addr, SI has offset of disk parameter table)
;

DSKFWR:				; Write function entry point
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FWP+DSK_FDP ; Is file protected ?
	JZ	DSKFRD		;   No, skip
	MOV	AX,FDSWPV	;   Yes, make it look like hardware protect
	STC			; Turn on CY to show error
	JMP	DSK_DSEL	; Deselect the drive and return

DSKFRD:				; Read function entry point
	MOV	BYTE PTR VERFLG,0	; Show no verify operation
DSKFRDV:
	MOV	AX,ES:DSKPR_SECTOR[BX] ; Get logical sector to read
	MOV	CUR_SECTOR,AX	; Save locally
	MOV	BYTE PTR DSK_WRIC,0 ; Show write has not occured

;
;  Convert the logical sector in CUR_SECTOR to track, sector, and side
;     (SI -> Disk parm table; ES:BX has parameter block addr)
;

	MOV	AX,CUR_SECTOR	; Get logical sector
	MOV	CL,BYTE PTR DSK_SPT[SI]
	XOR	CH,CH
	JCXZ	SEEKERR		; Is SPT is zero, divide error!
	DIV	CL		; Use byte divide

	INC	AH		; Convert sector from zero- to one- based
	XOR	DL,DL		; Assume side zero
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FDS ; Is disk two sided ?
	JZ	D8		;   No, skip over two sided code
	SHR	AL,1		; Even tracks on side zero, odd on other side
	JNC	D8		; Skip if even track number
	MOV	DL,FDFSS1	; Load up side one command/flag

; Test if we need to seek

D8:	
	MOV	BYTE PTR SIDFLG,DL ; Save side flag
	CMP	AL,BYTE PTR DSK_MAXT[SI]
	JA	SEEKERR		; If track > max track, too bad
	MOV	BYTE PTR CURTRK,AL	; Save track
	MOV	BYTE PTR CURSEC,AH	; And sector
	JMP	SHORT DSKTSSOK		; Skip new stuff

DSKFSUL:

;	Compute new track/sector/side information

	INC	BYTE PTR CURSEC
	MOV	AL,BYTE PTR DSK_SPT[SI]	; AL = sectors/track
	CMP	AL,BYTE PTR CURSEC
	JNC	DSKTSSOK		; If ok

	MOV	BYTE PTR CURSEC,1	; Flag new sector
	INC	BYTE PTR CURTRK		; Assume single sided
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FDS	; Double sided?
	JZ	DSKTSSOK		; Nope, next track
	MOV	AL,0
	XCHG	AL,BYTE PTR SIDFLG	; Set side zero
	CMP	AL,FDFSS1		; Was side one?
	JZ	DSKTSSOK		; Yes, done
	DEC	BYTE PTR CURTRK
	MOV	BYTE PTR SIDFLG,FDFSS1	; Nope, set it so
DSKTSSOK:
    IF DSK_RTY
	MOV	BYTE PTR RETRY_FLAG,0 ; Set retry type flag
	MOV	BYTE PTR RETRY_INDX,0 ; Set retry index in cycle
	MOV	AL,BYTE PTR DSK_NRETRY[SI] ; Get max number of retry cycles
	INC	AL		; Make one-based from zero-based
	MOV	BYTE PTR RETRY_CREM,AL ; Store as down counter
    ENDIF
DSKCRTY:

	TEST	BYTE PTR DSK_LOPT[SI],DSK_OUK ; Is disk at an unknown track ?
	JNZ	D6		;   Yes, home it
	MOV	AL,DSK_LTRK[SI] ; Disk at known track, get track
	CALL	DSK_OTRK	; Tell controller current track number
	JMP	SHORT D7	; Skip

SEEKERR:
	MOV	AX,FDSSEK	; Set SEEK error
	STC
	JMP	DSK_DSEL	; and bail out

D6:	CALL	DSK_RST		; Home disk

D7:
	MOV	AL,BYTE PTR CURTRK
	MOV	AH,BYTE PTR CURSEC

;	Compute AL = track number, AH = sector, and SIDFLG = side flag

	MOV	CH,DSK_LTRK[SI]	; Get last track
	CMP	CH,AL		; Is last track = new track ?
	JZ	D10		;   Yes, then don't need to seek to it

; Seek to proper sector
;   (CH = last track, AL = new track)

	MOV	BYTE PTR DSK_DBIT,FDFDLF ; Turn delay on
	CMP	BYTE PTR DSK_WRIC,0 ; Has a write occured ?
	JE	D8A		;   No, skip
	CALL	DSK_WAIT	;   Yes, wait for it to complete
D8A:	MOV	DSK_LTRK[SI],AL	; Set last track to new track
	CALL	DSK_ODAT	; Tell controller desired track

	TEST	BYTE PTR DSK_FLAG[SI],DSK_FFS ; Can drive fast step ?
	JZ	D9A		;   No, skip over fast step
	MOV	AL,DSK_SEL[SI]	; Get select command
	OR	AL,CON5FS	; Or in fast step
	CALL	DSK_OCON	; Make drive fast step

D9A:	MOV	AL,DSK_SK[SI]	; Get seek command
	CALL	DSK_EXCMD	; Execute the command
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FDP ; Should drive double step ?
	JZ	D9B		;   No, skip over double step
	MOV	AL,DSK_LTRK[SI]	;   Yes, get track number
	CALL	DSK_ODAT	; Tell controller desired track number
	MOV	AL,CH		; Get original track number
	CALL	DSK_OTRK	; Tell controller current(sic) track
	MOV	AL,DSK_SK[SI]	; Get seek command
	CALL	DSK_EXCMD	; Execute the command(ie double step)

D9B:	CALL	DSK_LWAIT	; Wait a long time for head to settle
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FFS ; Can drive fast step ?
	JZ	D9C		;   No, skip over fast step 
	MOV	AL,DSK_SEL[SI]	; Get select command
	CALL	DSK_OCON	; Turn off fast step
D9C:
	MOV	AL,DSK_LTRK[SI] ; Get track back
	CALL	DSK_OTRK	; Tell controller where head is again

; We have positioned to the desired track

D10:
	MOV	AL,AH		; Sector to proper reg
	CALL	DSK_OSEC	; Tell controller desired sector

	CMP	BYTE PTR DSK_FUN,DSK_READ ; Was function Disk read ?
	JNE	DSKFWR1		;   No, is a write
	JMP	DSKFRD1		;   Yes, is read

	PAGE
;
;    Now we are ready for actual write
;        (SI -> Disk parameter table; ES:BX -> parameter block)
;
	
DSKFWR1:
	MOV	AH,DSK_SEL[SI]	; Get disk select command
	OR	AH,CONWE	; Add enable wait state I/O
	TEST	AH,CONDS8	; Is drive an eight incher ?
	JNZ	DSKFWR2		;   Yes, skip
	CALL	DSK_IAS		; Get AUX status
	TEST	AL,AS96T	; Are drives 96 tpi ?
	JNZ	DSKFWR2		;   Yes, skip
	CMP	BYTE PTR DSK_LTRK[SI],FD5IT ; Are we on the inside tracks ?
	JB	DSKFWR2		;   No, skip
	AND	AH,NOT CONPC	;   Yes, turn on pre-comp
DSKFWR2:
	MOV	AL,AH		; Get select command
	CALL	DSK_OCON	; Make disk do wait state I/O
	MOV	CX,DSK_BPS[SI]	; Get bytes per sector
	PUSH	ES		; Save ES
	LES	DI,ES:DWORD PTR DSKPR_BUFF[BX] ; Load ES:DI with buffer addr

;	Check to see if a WRITE at this point will wrap us around the segment

DSKFWR2A:
	PUSH	DI
	ADD	DI,CX		; CX = byte count
	POP	DI
	JNC	DSKFWR2B	; If no wrap

;	Would wrap, adjust the pointers

	MOV	AX,ES
	ADD	AX,10H		; Add 10H to the segment
	MOV	ES,AX
	SUB	DI,100H		; Subtrack 100h from the offset
	JMP	DSKFWR2A	; And try again

DSKFWR2B:
	CLD			; Set direction flag for LODS instr
	MOV	AL,DSK_WR[SI]	; Get write command
	OR	AL,DSK_DBIT	; Add in delay information
	MOV	BYTE PTR DSK_DBIT,0 ; Clear delay 
	OR	AL,SIDFLG	; Add in side information
	PUSHF			; Save current interrupt status
	CLI			; Turn off interrupts

; Set up DX for port i/o

	MOV	DX,DSK_PORT[SI]	; Get base port number of controller
	ADD	DX,FDDAT	; Compute data port number
	PUSH	DX		; Save data port number
	MOV	DX,DSK_PORT[SI]	; Get base port number
	ADD	DX,FDCMD	; Compute command port number
	XCHG	SI,DI		; LODS uses SI
	OUT	DX,AL		; Start write
	POP	DX		; Recover data port number

; Write a sector
;   (DX = data port number; ES:SI -> data to write; CX = count to write)

W10A:
	LODS 	BYTE PTR ES:[SI] ; Get byte to write
	OUT	DX,AL		; Write byte
	LOOP	W10A		; Decr count, branch if not finished

	XCHG	SI,DI		; Recover SI (and don't lose DI)
	MOV	AL,DSK_SEL[SI]	; Get disk select command
	CALL	DSK_OCON	; Turn off wait state I/O
	CALL	DSK_WCMPLT	; Wait for finish and get final status
	MOV	BYTE PTR DSK_WRIC,0FFH ; Show that a write has occured
	POPF			; Restore interrupt status
	MOV	DX,ES		; DX = transger segment
	POP	ES		; Recover ES
	TEST	AL,AL		; Did an error occur ?
	JZ	W12		;   No, onward

; Error on write

    IF DSK_RTY
;	TEST	AL,FDSWPV	; Is disk write protected ?
;	JNZ	W10C		;   Yes, skip retries
	XOR	BYTE PTR RETRY_FLAG,0FFH ; Should we just try write again ?
	JZ	W10B		;   No, skip
	JMP	DSKCRTY		;   Yes, try again

W10B:	
	CALL	DSK_WAIT	; Wait for operation to complete
	PUSH	AX		; Save status
	CALL	DSK_RTRY	; Perform retry operation
	POP	AX		; Recover status
	JC	W13		; If too many errors
	JMP	DSKCRTY		; Try operation again
    ENDIF
W10C:
	STC			; Show error with carry
	JMP	SHORT W13	;  and join common exit  

; Success on write

W12:
	INC	WORD PTR CUR_SECTOR ; Compute next logical sector
	MOV	ES:DSKPR_BUFF[BX],DI ; Save new buffer offset
	MOV	ES:DSKPR_BUFF+2[BX],DX	; Save transfer segment
	INC	ES:WORD PTR DSKPR_SECTOR[BX]
	DEC	ES:WORD PTR DSKPR_COUNT[BX] ; decr rem sectors, any left ?
	JZ	W13		;   No, join common code
	JMP	DSKFSUL		;   Yes, write another

;	Wrap at end of segment, ignore rest of stuff

DSKFWRWRAP:
	POP	ES
	CLC

; Write common exit

W13:
	MOV	BYTE PTR DSK_LOPT[SI],DSK_OWR ; Show last op was a write
	LAHF			; Save CY
	CALL	DSK_WAIT	; Wait for operation to complete
	SAHF			; Restore CY
	MOV	AH,0		; Clear hi part (CY is error flag)
	JMP	DSK_DSEL	; Deselect the drive and return

	PAGE
;
;    Now we are ready for actual read
;        (SI -> disk parameter table; ES:BX -> parameter block)
;

DSKFRD1:
	MOV	AL,DSK_SEL[SI]	; Get disk select command
	OR	AL,CONWE	; Add in wait state I/O
	CALL	DSK_OCON	; Turn on wait state I/O
	MOV	CX,DSK_BPS[SI]	; Get number of bytes per sector
	PUSH	ES		; Save ES
	LES	DI,ES:DWORD PTR DSKPR_BUFF[BX] ; Load ES:DI with buffer addr
	CLD			; Set direction flag for STOSB instr
	MOV	AL,DSK_RD[SI]	; Get read command
	OR	AL,DSK_DBIT	; Add in delay information
	MOV	BYTE PTR DSK_DBIT,0 ; Clear delay
	OR	AL,SIDFLG	; Add in side information
	PUSHF			; Save interrupt status
	CLI			; Turn off interrupts

; Set up DX for port I/O

	MOV	DX,DSK_PORT[SI]	; Get controller base port
	ADD	DX,FDDAT	; Compute data port number
	PUSH	DX		; Save data port number
	MOV	DX,DSK_PORT[SI]	; Get controller base port number
	ADD	DX,FDCMD	; Compute command port number
	TEST	BYTE PTR VERFLG,0FFH
	JNZ	D10VA		; Is a verify

;	Is normal read, continue

	OUT	DX,AL		; Start read
	POP	DX		; Recover data port number

; Read sector
;  (DX = data port number; ES:DI -> buffer; CX = number of bytes in sector)

D10A:
	IN	AL,DX		; Read a byte
	STOSB			; Store byte in buffer
	LOOP	D10A		; Decr count, branch if not finished
	JMP	SHORT D10VB

;	Is a verified read

D10VA:
	OUT	DX,AL
	POP	DX		; Recover data port
D10VA1:
	IN	AL,DX		; Read data
	LOOP	D10VA1		;  But ignore it
;	JMP	SHORT D10VB

D10VB:
	MOV	AL,DSK_SEL[SI]	; Get disk select command
	CALL	DSK_OCON	; Turn off wait state I/O
	CALL	DSK_WCMPLT	; Wait for finish and get final status
	POPF			; Restore interrupt status
	POP	ES		; Recover ES	
	TEST	AL,AL		; Did an error occur ?
	JZ 	D12		;   No, onward

; Error on read

    IF DSK_RTY
	XOR	BYTE PTR RETRY_FLAG,0FFH ; Should we just try read again ?
	JZ 	D10B		;   No, skip
	JMP	DSKCRTY		;   Yes, try again
D10B:	PUSH	AX		; Save status
	CALL	DSK_RTRY	; Perform recovery operation
	POP	AX		; Recover status
	JC	D13		; If too many errors
	JMP	DSKCRTY		; Otherwise, try again
    ELSE
	STC			; Show error with cary
	RET
    ENDIF

; Success on read

D12:
	INC	WORD PTR CUR_SECTOR ; Compute next logical sector
	INC	ES:WORD PTR DSKPR_SECTOR[BX]
	MOV	ES:DSKPR_BUFF[BX],DI ; Save new buffer offset
	DEC	ES:WORD PTR DSKPR_COUNT[BX] ; decr rem sectors, any left ? 
	JZ	D13		;   No, join common code
	JMP	DSKFSUL		;   Yes, go read another sector
D13:
	MOV	BYTE PTR DSK_LOPT[SI],DSK_ORD ; Show last op was a read
	MOV	AH,0		; Clear hi part (AL and CY already set)
	JMP	DSK_DSEL	; Deslect the drive and return


	PAGE
;
;  Format disk function
;
;    (ES:BX has parmeter block addr;  SI has offset of disk parameter table)
;

DSKFFT:
;	TEST	BYTE PTR DSK_FLAG[SI],DSK_FWP ; Is disk write protected ?
;	JZ	D13A		;   No, skip onward
;	MOV	AX,FDSWPV	;   Yes, make it look like hardware protect
;	STC			; Turn on CY to show error
;	JMP	DSK_DSEL	; Deselect the drive and return
;
D13A:	TEST	BYTE PTR DSK_LOPT[SI],DSK_ORS+DSK_OSI+DSK_OFT ; Was last
				;  operation a Restore, Step, or format ?
	JNZ	D13B		;   Yes, skip onward
	MOV	AX,DSKST_ORERR	;   No, get error code
	STC			; Turn on CY to show error
	JMP	DSK_DSEL	; Deselect the drive and return

D13B:	MOV	BYTE PTR SIDFLG,0 ; Assume side 0
	TEST	ES: WORD PTR DSKPR_SECTOR[BX],0FFFFH ; Was side one
	JZ	D13BA		;   No, skip
	MOV	BYTE PTR SIDFLG,FDFSS1 ; Yes, get side one command

D13BA:
	MOV	AH,DSK_SEL[SI]	; Get disk select command
	OR	AH,CONWE	; Add enable wait state I/O
	TEST	AH,CONDS8	; Is drive an eight incher ?
	JNZ	D13BB		;   Yes, skip
	CALL	DSK_IAS		; Get AUX status
	TEST	AL,AS96T	; Are drives 96 tpi ?
	JNZ	D13BB		;   Yes, skip
	CMP	BYTE PTR DSK_LTRK[SI],FD5IT ; Are we on the inside tracks ?
	JB	D13BB		;   No, skip
	AND	AH,NOT CONPC	;   Yes, turn on pre-comp
D13BB:
	MOV	AL,AH		; Get select command
	CALL	DSK_OCON	; Turn on wait state I/O
	MOV	CX,DSK_BPWT[SI]	; Get number of bytes to write
	PUSH	ES		; Save ES
	LES	DI,ES:DWORD PTR DSKPR_BUFF[BX] ; Load ES:DI with buffer addr
	CLD			; Set direction flag for LODS instr
	PUSHF			; Save interrupt status
	CLI			; Turn off interrupts
	MOV	AL,DSK_FMT[SI]	; Get format(write track) command
	OR	AL,SIDFLG	; Add in side select information
	MOV	DX,DSK_PORT[SI]	; Get controller base port 
	ADD	DX,FDDAT	; Compute data port
	PUSH	DX		; Save data port
	MOV	DX,DSK_PORT[SI]	; Get controller base port 
	ADD	DX,FDCMD	; Compute command port
	XCHG	SI,DI		; Use SI for LODSB instr
	OUT	DX,AL		; Start write
	POP	DX		; Recover data port

; Write the track
;  (DX = data port number; ES:SI -> buffer; CX = number of bytes to write)

D13D:
	LODS 	BYTE PTR ES:[SI] ; Get byte to write
	OUT	DX,AL		; Write a byte
	LOOP	D13D		; Decr count, branch if not finished

	XCHG	SI,DI		; Recover SI
	MOV	AL,DSK_SEL[SI]	; Get disk select command
	CALL	DSK_OCON	; Turn off wait state I/O
	CALL	DSK_WCMPLT	; Wait for unit not busy and get final status
	POPF			; Restore interrupt status
	POP	ES		; Recover ES
	CALL	DSK_WAIT	; Wait for operation to complete	
	MOV	BYTE PTR DSK_LOPT[SI],DSK_OFT ; Assume operation succeeded
	TEST	AL,AL		; Did an error occur ?
	JZ	D13F		;   No, onward
	MOV	BYTE PTR DSK_LOPT[SI],DSK_OUK ; Yes, show error
	STC			; Set CY to show error
D13F:
	MOV	AH,0		; Clear upper part of status 
	JMP	DSK_DSEL	; Deselect the drive and return

	PAGE
;
;  Step in function
;
;      (ES:BX has parameter block addr; SI has offset of disk paramter table)
;

DSKFSI:
	TEST	BYTE PTR DSK_LOPT[SI],DSK_OSI+DSK_OFT+DSK_ORS ; Was last
				;  operation a Step in, Format, or Restore ?
	JNZ	D13G		;   Yes, skip onward
	MOV	AX,DSKST_ORERR	;   No, get error code
	STC			; Show error with CY
	JMP	DSK_DSEL	; Deselect the drive and return
		 	
D13G:	INC	WORD PTR DSK_LTRK[SI] ; Bump the track count
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FFS ; Can drive fast step
	JZ	D13GB		;   No, nothing special to do
	MOV	AL,DSK_SEL[SI]	;   Yes, get disk select command
	OR	AL,CON5FS	; Or in fast step
	CALL	DSK_OCON	; Make disk fast step
D13GB:	MOV	AL,DSK_SPHI[SI]	; Get step in command
	CALL	DSK_EXCMD	; Execute the command
	CALL	DSK_LWAIT	; Wait a long time for head to settle
	PUSH	AX		; Save status
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FFS ; Were we fast stepping ?
	JZ	D13GC		;   No, skip
	MOV	AL,DSK_SEL[SI]	; Get select command
	CALL	DSK_OCON	; Turn off fast step
D13GC:	POP	AX		; Recover status 	
	MOV	BYTE PTR DSK_LOPT[SI],DSK_OSI ; Assume no error
	CLC			; Show no error
	
D13H:	MOV	AH,0		; Clear upper part of status
	JMP	DSK_DSEL	; Deselect the drive and return

	PAGE
;
;  DSK_DSEL - Common exit to deselect the disk and return
;
;    SI -> disk parameter table
;    AX = status to return
;    CY = error flag
;

DSK_DSEL:
	MOV	WORD PTR [SI.DSK_TIMOUT],0	; Reset timeout counter

	MOV	DSK_STA[SI],AX	; Save status
	PUSH	AX		; Save status for a bit
	LAHF			; Save carry

	CLI			; Disable interrupts
	MOV	BYTE PTR DSKT_FG,0FFH ; Allow timer to deselect drive
	MOV	DX,DSK_TDSEL[SI] ; Get time before drive is deselected
	MOV	DSKT_DNCTR,DX	; Store as down counter for timer
	MOV	DX,DSK_PORT[SI]	; Get base port
	ADD	DX,FDCON	; Add control port offset
	MOV	DSKT_PORT,DX	; Save port for timer
	MOV	BYTE PTR DSKT_DSEL,0 ; Store deselect command for timer
	STI			; Turn interrupts back on

	SAHF			; Restore carry
	POP	AX		; Restore status
	JNC	DSK_DSEL0	; Skip if no error
	MOV	BYTE PTR SIDFLG,FDFSS1 ; An error occured, set side 1 flag to force side 0 select
DSK_DSEL0:
	RET			;  and return

	PAGE
;
;  DSK_RST - Restore the disk
;
;  Call with:
;      SI -> disk parameter table
;
;  Returns:
;      AL = status
;

DSK_RST:
	MOV	BYTE PTR DSK_LTRK[SI],0	; Show last track is zero
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FFS ; Can drive fast step ?
	JZ	D14A		;   No, skip over
	MOV	AL,DSK_SEL[SI]	; Get disk select command
	OR	AL,CON5FS	; Or in fast step
	CALL	DSK_OCON	; Make disk fast step

D14A:	MOV	AL,DSK_RS[SI]	; Get restore command
	MOV	BYTE PTR DSK_EXCMDF,-1	; Set doing a restore
	CALL	DSK_EXCMD	; Execute the command
	JC	D14E		; If errors

	TEST	BYTE PTR DSK_FLAG[SI],DSK_FRS ; Should we try again ?
	JZ	D14C		;   No, skip
	PUSH	CX		; Save CX
	MOV	CX,FDSTEPS	; Get number of steps
D14B:
	MOV	AL,DSK_SPHI[SI] ; Get Step command
	CALL	DSK_EXCMD	; Execute the command
	LOOP	D14B		; Do it until done

	POP	CX		; Restore CX
	MOV	AL,DSK_RS[SI]	; Get restore command
	OR	AL,FDFS30	; Make step real slow
	CALL	DSK_EXCMD	; Execute the command
D14C:
	CALL	DSK_LWAIT	; Wait a long time for the head to settle
	PUSH	AX		; Save status
	XOR	AL,AL		; Set track to zero
	CALL	DSK_OTRK	; Tell controller the track
	MOV	BYTE PTR DSK_LOPT[SI],DSK_ORS ; Show last op was a reset
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FFS ; Can drive fast step ?
	JZ	D14D		;   No, skip
	MOV	AL,DSK_SEL[SI]	; Get back disk select command
	CALL	DSK_OCON	; Make disk act regular
D14D:
	POP	AX		; Recover status
D14E:
	MOV	BYTE PTR DSK_EXCMDF,0	; No more restores
	RET			;  and return

	PAGE
;
;  DSK_RTRY - Does retries of a disk operation
;
;      Call with:
;          AL = Status
;          RETRY_INDX = Retry cycle index
;          RETRY_CREM = Down counter of retry cycles
;
;      Returns:
;          CY set - RETRY_CREM went to zero after a cycle completed
;          CY clear - RETRY_INDX updated and if cycle completed,
;                     then RETRY_CREM decremented
;
;      Uses: AX,DI,DX

DSK_RTRY:
	CMP	BYTE PTR RETRY_INDX,0 ; At start of cycle ?
	JNE	DSKRTRY0	;   No, skip
DSK_RDECR:
	DEC	BYTE PTR RETRY_CREM ; Decr remaining cycles, any left ?
	JNZ	DSKRTRY0	;   Yes, skip
	STC			;   No, show recoverry procedure failed
	RET			; and return

DSKRTRY0:
	INC	WORD PTR DSK_SERR[SI] ; Count as a soft error
	TEST	AL,FDSNRD+FDSWPV ; Is error Not Ready or Write Protect ?
	JNZ	DSK_RDECR	;   Yes, then fail immediately
	MOV	AL,RETRY_INDX	; Get retry cycle index
	INC	BYTE PTR RETRY_INDX ; Increment the index
	CBW			; Extend in to word
	SHL	AX,1		; Make into word
	MOV	DI,AX		; Make avail as index
	JMP	WORD PTR DSKRTRY1[DI] ; Case to recovery routine

DSKRTRY1:
	DW	DSKRTRYSI	; Step in 1 track
	DW	DSKRTRYSO	; Step out 1 track
	DW	DSKRTRYRS	; Restore head
	DW	DSKRTRYSI	; Step in 1 track
	DW	DSKRTRYSO	; Step out 1 track
	DW	DSKRTRYFL	; End cycle 


;
;  DSKRTRYFL - End of recovery cycle and when all below procedures fail
;

DSKRTRYFL:
	MOV	BYTE PTR RETRY_INDX,0 ; Reset cycle index to zero
	JMP	DSK_RTRY	; Start over again


;
;  DSKRTRYSI - Step head in 1 track
;

DSKRTRYSI:
	CALL	DSK_ITRK	; Get current track number
	CMP	AL,DSK_MAXT[SI]	; At maximum track yet ?
	JB	DSKRTRYSI1	;   No, continue
	CLC			;   Yes, don't do anything
	RET			;  and return

DSKRTRYSI1:
	INC	AL		; Incr track number
	MOV	BYTE PTR DSK_LTRK[SI],AL ; Set new track number
	MOV	AL,DSK_SPHI[SI] ; Get step in command
	CALL	DSK_EXCMD	; Step the head in
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FDP ; Should drive double step ?
	JZ	DSKRSIR		;   No, skip
	MOV	AL,DSK_SPHI[SI]	; Get step in command
	CALL	DSK_EXCMD	; Step the head in
DSKRSIR:
	CALL	DSK_LWAIT	; Wait for head to settle
	CLC			; Show not finished with cycle
	RET			; and return


;
; DSKRTRYSO - Step head out
;

DSKRTRYSO:
	CALL	DSK_ITRK	; Get current track
	TEST	AL,AL		; On track zero ?
	JNZ	DSKRTRYSO1	;   No, Continue
	CLC			;   Yes, don't do anything
	RET			; and return

DSKRTRYSO1:
	DEC	AL		; Decr track number
	MOV	BYTE PTR DSK_LTRK[SI],AL ; Save it
	CALL	DSK_ODAT	; Tell controller desired track
	MOV	AL,DSK_SK[SI]	; Get seek command
	CALL	DSK_EXCMD	; Seek to track
	TEST	BYTE PTR DSK_FLAG[SI],DSK_FFS ; Should disk double step ?
	JZ	DSKRSOR		;   No, skip
	MOV	AL,BYTE PTR DSK_LTRK[SI] ; Get track number
	CALL	DSK_ODAT	; Tell controller desired track
	INC	AL		; Compute old position
	CALL	DSK_OTRK	; Tell controller where head is
	MOV	AL,DSK_SK[SI]	; Get seek command
	CALL	DSK_EXCMD	; Seek again(ie double step)
DSKRSOR:
	CALL	DSK_LWAIT	; Wait for head to settle
	CLC			; Show not finished with cycle
	RET			;  and return


;
;  DSKRTRYRS - Restore head to track 0
;

DSKRTRYRS:
	PUSH	CX		; Save CX
	XOR	AL,AL		; Deselect drive to lift head
	CALL	DSK_OCON

; Wait for head to unload

	MOV	CX,FDHULDM+1	; Get head unload multiplier
DRS1:
	CALL	DSK_LWAIT	; Wait for head unload
	LOOP	DRS1

	MOV	AL,DSK_SEL[SI]	; Reselect the disk
	CALL	DSK_OCON

; Wait for head load

	MOV	CX,FDHLDM	; Get head load multiplier
DRS2:
	CALL	DSK_LWAIT	; Wait foor head to load
	LOOP	DRS2

	CALL	DSK_RST		; Restore the head
	CALL	DSK_LWAIT	; Wait for head to settle	
	CLC			; Show not finished with cycle
	POP	CX		; Restore CX
	RET			;  and return


	PAGE
;
;  DSK_WAIT - Wait for operation to complete
;
;    Call with:
;        SI -> disk parameter table
;

DSK_WAIT:
	PUSH	CX
	MOV	CX,WORD PTR DSK_DELAY[SI] ; Get count for short delay
	JMP	SHORT D16

;
;  DSK_LWAIT - Wait a long time for operation to complete
;
;    Call with:
;        SI -> disk parameter table
;

DSK_LWAIT:
	PUSH	CX
	MOV	CX,WORD PTR DSK_LDELAY[SI] ; Get count for long delay
D16:
	CALL	ALARM_WAIT		; Wait for time to go by
	POP	CX
	RET

;
;  DSK_EXCM/DSK_WCMPLT - (Execute command) and wait for it to complete
;
;      Call with:
;          SI -> Disk parameter table
;          AL = command to execute
;
;      Returns: 
;          Al = status
;

DSK_EXCMD:

;	Check to see if controller exists

	PUSH	BX
	PUSH	AX
	CALL	DSK_ITRK	; Read current track setting
	MOV	BL,AL		; BL gets current track number
	INC	AL
	CALL	DSK_OTRK	; Output modified track
	CALL	DSK_ITRK	; Should have modified track number
	XCHG	AL,BL		; BL = new, should be AL + 1
	CALL	DSK_OTRK	; Output the original one again
	INC	AL
	CMP	AL,BL		; 'ZR' set if controller exists
	POP	AX
	POP	BX
	JZ	DSK_EXCMD1

;	Controller not here

	MOV	AL,FDSNRD
	STC
	RET			; Show not read

;	Controller exists

DSK_EXCMD1:
	CALL	DSK_OCMD	; Execute command
	PUSH	AX

;	Calculate the wait timer period

	MOV	AL,BYTE PTR DSK_RS[SI]
	AND	AL,00000011B		; Isolate step rate
	CMP	BYTE PTR DSK_TYPE[SI],DSK_TZ2078	; Is 8"?
	JNZ	DSK_EXCMD1A
	ADD	AL,00000100B		; Yes, get next entry
DSK_EXCMD1A:
	CBW
	SHL	AX,1			; AX = word ptr
	PUSH	BX
	MOV	BX,AX
	ADD	BX,OFFSET DSK_EXCMDT	; Get timeout table
	MOV	AX,WORD PTR [BX]
	POP	BX
	MOV	WORD PTR MAX_RTIC,AX
	
	MOV	WORD PTR TICVAL,0	; Reset tic count value
	POP	AX			; Reset the stack

;***	Alternate entry point !!!

DSK_WCMPLT:
	PUSH	AX			; Save AX
DSK_WCMPLT0:
	CALL	DSK_IAS		; Get aux status
	TEST	AL,ASIRQ	; Is command completed ?
	JNZ	DSK_WCMPLT1	;   No, keep looking

	TEST	BYTE PTR DSK_EXCMDF,0FFH
	JZ	DSK_WCMPLT0

;	Doing a restore, time it carefully

	MOV	AX,WORD PTR TICVAL
	CMP	AX,WORD PTR MAX_RTIC
	JC	DSK_WCMPLT0

;	Did not get a response in time

	POP	AX
	MOV	AL,FDCFI
	CALL	DSK_OCMD
	MOV	BYTE PTR DSK_EXCMDF,0	; Now time out here
	STC
	RET

DSK_WCMPLT1:
	PUSH	CX		; Save CX
	MOV	CX,FDCOML	; Get time to wait before reading status
	CALL	ALARM_WAIT	; Wait for command to get started
	POP	CX		; Recover CX
DSK_WCMPLT2:
	CALL	DSK_ISTA	; Get status
	TEST	AL,FDSBSY	; Is controller chip busy ?
	JZ	DSK_WCMPLT2B
	TEST	BYTE PTR DSK_EXCMDF,0FFH
	JZ	DSK_WCMPLT2	; If not doing restore, no time-out

;	Doing a restore, time it carefully

	MOV	AX,WORD PTR TICVAL
	CMP	AX,WORD PTR MAX_RTIC
	JC	DSK_WCMPLT2

;	Did not get a response in time

	MOV	AL,FDCFI
	CALL	DSK_OCMD
	MOV	BYTE PTR DSK_EXCMDF,0	; Now time out here
	STC
DSK_WCMPLT2B:

;	AL = valid return data

	MOV	CS:BYTE PTR RETCD,AL
	POP	AX
	MOV	AL,CS:BYTE PTR RETCD
	RET			;   No, return

RETCD	DB	0

;
;  DSK_IAS, DSK_ISTA, DSK_ITRK, DSK_ISEC, DSK_IDAT - routines to do input
;     through controller base port at DSK_PORT[SI]
;
;      Returns:
;          AL = value from command
; 
;      Uses: DX
;

DSK_IAS:
	MOV	DX,FDAS		; Get Aux status port offset
	JMP	SHORT DSK_PIN	; Join command code

DSK_ITRK:
	MOV	DX,FDTRK	; Get track port offset
	JMP	SHORT DSK_PIN	; Join common code

DSK_ISEC:
	MOV	DX,FDSEC	; Get sector port offset
	JMP	SHORT DSK_PIN	; Join common code

DSK_IDAT:
	MOV	DX,FDDAT	; Get data port offset	
	JMP	SHORT DSK_PIN	; Join common code

DSK_ISTA:
	MOV	DX,FDSTA	; Get status port offset

DSK_PIN:
	ADD	DX,WORD PTR DSK_PORT[SI] ; Add base port
	IN	AL,DX		; Execute command
	RET			;  and return


;
;  DSK_OCON, DSK_OCMD, DSK_OTRK, DSK_OSEC, DSK_ODAT - Routines to do
;     output through controller base port DSK_PORT[SI]
;
;      Call with:
;          AL = value to output
;
;      Uses: DX
;

DSK_OCON:
	MOV	DX,FDCON	; Get control port offset
	JMP	SHORT DSK_POUT	; Join common code

DSK_OCMD:
	MOV	DX,FDCMD	; Get command port offset
	JMP	SHORT DSK_POUT	; Join common code

DSK_OTRK:
	MOV	DX,FDTRK	; Get track port offset
	JMP	SHORT DSK_POUT	; Join common code

DSK_OSEC:
	MOV	DX,FDSEC	; Get sector port offset
	JMP	SHORT DSK_POUT	; Join comon code

DSK_ODAT:
	MOV	DX,FDDAT	; Get data port offset

DSK_POUT:
	ADD	DX,WORD PTR DSK_PORT[SI] ; Add in base port
	OUT	DX,AL		; Output value
	RET			;  and return	
	PAGE
;
;  Variables used by disk routines
;

CURTRK		DB 0		; Current track
CURSEC		DB 0		; Current sector
SIDFLG		DB 0		; Side flag - 0 if side 0, FDFSS1 if side 1
CUR_SECTOR	DW ?		; Current logical sector

    IF DSK_RTY
RETRY_INDX 	DB ?		; Index in cycle of retry procedure
RETRY_FLAG	DB ?		; Flag (00 = retry without seek)
RETRY_SECTOR	DW ?		; sector of last retry
RETRY_CREM	DB ?		; Remaining number of retry cycles
    ENDIF

SECCNT		DW ?		; Sectors transfered in DSKW
PFLAG		DB 0		; =0 if logical read, else physical read

DSK_FUN		DB ?		; Function to perform
DSK_WRIC	DB ?		; Flag that shows that a write hass occured
DSK_LDRIVE	DW -1		; Last drive
DSK_DBIT	DB ?		; Delay command
DSK_EXCMDF	DB 0		; != 0 if doing a restore command
MAX_RTIC	DW 0

DSK_EXCMDT	LABEL	BYTE	; Table of delay values for step rates
		DW	60	; 5.25 at	6
		DW	110	;		12
		DW	170	;		20
		DW	250	;		30

		DW	34	; 8 at	3
		DW	57	;	6
		DW	87	;	10
		DW	126	;	15

BDSK207	ENDP
