;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
	PAGE	,132
	TITLE	PBE - Phony BIOS entry points

	.LFCOND
	.TFCOND		; Use /X switch to cause FALSE conds not to list

;  BIOS for MS-DOS 2.00
;
;      This is the so called Basic I/O
;      System for MS-DOS.
;
;      It is loaded into memory at a known
;      location by the MS-DOS Loader.
;
; 10/08/82 - BPE module created
;
;  (C)COPYRIGHT 1982 BY ZENITH DATA SYSTEMS
;
;	This PBE module is used as the entry point for old BIOS
;	functions. It is used here to support those routines needed
;	byte DSKCOxx and FORMAT, et al.
;

INCLUDE	PARMS.ASM		; Get program parms
INCLUDE	VER.ASM			; Version variables

    IF1
	%OUT	*Pass 1 started*
    ELSE
	%OUT	*Pass 2 started*
    ENDIF

    IF LISTI
	IF1
	%OUT	*Full listing being generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF
	.XLIST
    ENDIF

INCLUDE	DEFDEV.ASM
INCLUDE	DEFCHR.ASM
INCLUDE	DEFDSK.ASM
INCLUDE	DEFZ207.ASM
INCLUDE	DEFZ217.ASM
	.LIST

	PAGE

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

	PUBLIC	BIOS_DSKFUNC		; Disk functions

	EXTRN	BIOS_CONFUNC:NEAR,BIOS_PRNFUNC:NEAR,BIOS_AUXFUNC:NEAR

	EXTRN	DSK:NEAR
	EXTRN	RECURLV:WORD
	EXTRN	SAVESS:WORD
	EXTRN	SAVESP:WORD
	EXTRN	BIOS_STACK:NEAR
	EXTRN	DSK0_MCHK1:NEAR

	PUBLIC	PBE_STATUS,PBE_CONIN,PBE_CONOUT
	PUBLIC	PBE_PRINT,PBE_AUXIN,PBE_AUXOUT
	PUBLIC	PBE_READ,PBE_WRITE,PBE_DSKCHG
	PUBLIC	PBE_SETDATE,PBE_SETTIME,PBE_GETDATE
	PUBLIC	PBE_FLUSH,PBE_MAPDEV

	ORG	0

;*	BPE - BIOS Phony Entry Points
;
;	Phony entry points for BIOS jump table calls
;

;*	BPE_xxxxxx - Routines not implimented
;

	INCLUDE	BCONIO.ASM
	INCLUDE	BPRNIO.ASM
	INCLUDE	BAUXIO.ASM
	INCLUDE	BCLKIO.ASM
	INCLUDE	BDSKIO.ASM

DSKPR	DB	0			; Drive
	DW	0			; Start
	DW	0			; Count
	DD	0			; Address

;*	These routines simply return with no errors
;

PBE_DSKCHG	PROC	FAR

;	First, Inform the BIOS of the disk change action

	PUSH	DS
	PUSH	BX
	PUSH	ES
	PUSH	AX
	MOV	BX,CS
	MOV	DS,BX		; DS:BX must point to packet
	MOV	ES,BX
	MOV	BX,OFFSET PBE_DSKCHGA	; Pointer to packet

;	AL = unit number

	MOV	SRH_UNIT[BX],AL	; Save unit number
	CALL	DSK0_MCHK1	; Check it
	POP	AX
	POP	ES
	POP	BX
	POP	DS
	MOV	AH,0		; Show disk might have changed
	CLC
	RET
PBE_DSKCHG	ENDP

PBE_DSKCHGA	LABEL	NEAR	; Packet for call to DSK0_MCHK
	SRH_STRUC	<0FH,0,SRHC_MCHK,0>
	DB	0,0		; Media byte and status

PBE_MAPDEV	PROC	FAR
	CLC
	RET
PBE_MAPDEV	ENDP

;*	These routines actually do something!
;

BIOS_DSKFUNC	PROC	FAR
	CLI
	INC	WORD PTR CS:RECURLV	; Bump recursion
	JNZ	BDSK1			; If nested call
	MOV	CS:SAVESP,SP		; Save current stack area
	MOV	CS:SAVESS,SS
	PUSH	CS
	POP	SS			; Set up local stack
	MOV	SP,OFFSET BIOS_STACK	;  area for first level call
BDSK1:
	STI
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	CS
	POP	DS
	CALL	DSK			; Do call
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	CLI
	DEC	WORD PTR CS:RECURLV	; Leaving last level?
	JNS	BDSK2			; Nope, leave stack
	MOV	SS,CS:SAVESS
	MOV	SP,CS:SAVESP		; Restore user stack
BDSK2:
	STI
	RET
BIOS_DSKFUNC	ENDP

BIOS_SEG ENDS
	END

