	PAGE	,132
	TITLE	Z-100 PC EMULATOR SETUP
;	SETZPC -- ZPC CONFIGURATION PROGRAM
;
;	THIS PROGRAM CAN BE USED TO ALTER CERTAIN ASPECTS
;	OF THE OPERATION OF ZPC.  IT IS SELF PROMPTING.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER 29-AUG-85  19-FEB-86
;
;	COPYRIGHT (C) 1985 BY HEATH/ZENITH USERS' GROUP

IWHITE	EQU	0			;OFFSET TO INTENSE WHITE FLAG
ICOLOR	EQU	2			;OFFSET TO INTENSE COLOR FLAG
BLINK	EQU	4			;OFFSET TO BLINK FLAG
GCUR	EQU	6			;OFFSET TO GRAPHIC CURSOR FLAG
MEMSZ	EQU	7			;OFFSET TO MEMORY SIZE
FONT	EQU	9			;OFFSET TO FONT CODE
CHRTBA	EQU	10			;OFFSET TO TEXT CHAR TABLE ADDRESS
CHRTBA1	EQU	12			;OFFSET TO GRAPH. CHAR TABLE ADDRESS
DEFMODE	EQU	14			;OFFSET TO DEFAULT VIDEO MODE
NUMLCK	EQU	15			;OFFSET TO NUM LOCK FLAG POINTER
REDSEL	EQU	17			;OFFSET TO RED SELECT BITS

OPENF	EQU	0FH			;OPEN FILE
CLOSEF	EQU	10H			;CLOSE FILE
SETDTA	EQU	1AH			;SET DTA
RBW	EQU	28H			;RANDOM BLOCK WRITE

ROM	SEGMENT AT 0FE01H		;ROM SEGMENT
	ORG	19H
ROMOUT	LABEL	FAR			;ROM OUTPUT ROUTINE
ROM	ENDS

DUMMY	SEGMENT	STACK
DUMMY	ENDS
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	AX,0C00H
	INT	21H			;CLEAR CONSOLE
	MOV	DX,OFFSET TSTMSG
	MOV	AH,9
	INT	21H			;TEST FOR Z-100 MODE
	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			;LOOK FOR INPUT
	JNZ	Z100M			;Z-100 MODE
	MOV	IBMFLG,1		;FLAG IBM MODE ON
	MOV	DX,24*256
	MOV	BH,0
	MOV	AH,2
	INT	10H			;MOV OUT IBM CURSOR
	CALL	TYPTX
	DB	27,'y','5'+80H		;TURN ON Z-100 CURSOR
Z100M:	MOV	AX,0C00H
	INT	21H			;CLEAR CONSOLE
	CALL	TYPTX
	DB	27,'E'
	DB	'Z-100 PC Emulator Configuration Utility, V 2.0'
	DB	13,10
	DB	'By Patrick Swayne, HUG Software Engineer',13,10
	DB	"Copyright (C) 1985, 1986 by Heath/Zenith Users' "
	DB	'Grou','p'+80H
	XOR	AX,AX
	MOV	DS,AX			;POINT DS AT 0
	MOV	SI,10H*4		;POINT AT INT 10H VECTOR
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	PUSH	CS
	POP	DS			;FIX DS
CFZPC:	CMP	ES:-2[DI],'CP'		;ZPC INSTALLED?
	JNZ	NOTIN			;NO
	CMP	ES:-4[DI],'NA'		;ANSISYS INSTALLED?
	JNZ	ITSIN			;NO, JUST ZPC
	MOV	AX,ES:-8[DI]		;ELSE, GET POINTER TO ZPC
	MOV	ES,ES:-6[DI]
	MOV	DI,AX
	JMP	CFZPC			;CHECK FOR ZPC
NOTIN:	CALL	TYPTX
	DB	13,10,10,'ZPC is not installed','.'+80H
	JMP	DONE			;AND EXIT
ITSIN:	MOV	DI,103H			;POINT TO CONFIG VARIABLES
	CALL	TYPTX
	DB	13,10,10,'Default video mode is',' '+80H
	MOV	AL,ES:DEFMODE[DI]	;GET DEFAULT VIDEO MODE
	CALL	PRTMOD			;PRINT IT
	CALL	TYPTX			;** 1
	DB	13,10,10,'Font now in use is',' '+80H
	MOV	AL,ES:FONT[DI]		;GET FONT CODE
	CALL	PRTFNT			;PRINT IT
	CALL	TYPTX			;** 5
	DB	9,'Monochrome normal color is',' '+80H
	MOV	AL,ES:REDSEL[DI]	;GET RED SELECT BITS
	MOV	BX,OFFSET GREEN		;ASSUME GREEN
	CMP	AL,11101111B		;TURNING RED OFF?
	JZ	MONGRN			;YES, COLOR IS GREEN
	MOV	BX,OFFSET YELLOW
MONGRN:	CALL	TYPTX1			;PRINT MONOCHROME COLOR
	CALL	TYPTX			;** 2
	DB	13,10,'Intense white emulation is',' '+80H
	MOV	AX,ES:IWHITE[DI]	;GET INTENSE WHITE MASK
	MOV	BX,OFFSET ENAB		;ASSUME ENABLED
	OR	AX,AX
	JNZ	WHTEN			;ENABLED
	MOV	BX,OFFSET DISAB
WHTEN:	CALL	TYPTX1
	CALL	TYPTX			;** 6
	DB	9,'Graphic mode cursor is',' '+80H
	MOV	AL,ES:GCUR[DI]		;GET GRAPHIC CURSOR CONTROL
	MOV	BX,OFFSET ENAB		;ASSUME ENABLED
	OR	AL,AL
	JNZ	GCUREN			;ENABLED
	MOV	BX,OFFSET DISAB
GCUREN:	CALL	TYPTX1			;PRINT CURSOR STATUS
	CALL	TYPTX			;** 3
	DB	13,10,'Intense color emulation is',' '+80H
	MOV	AX,ES:ICOLOR[DI]	;GET INTENSE COLOR MASK
	MOV	BX,OFFSET ENAB		;ASSUME ENABLED
	OR	AX,AX
	JNZ	ICOLEN			;ENABLED
	MOV	BX,OFFSET DISAB
ICOLEN:	CALL	TYPTX1			;PRINT INTENSE STATUS
	CALL	TYPTX			;** 7
	DB	9,'Default Num Lck state is',' '+80H
	MOV	SI,ES:NUMLCK[DI]	;GET NUM LOCK FLAG POINTER
	MOV	AL,ES:[SI]		;GET NUM LOCK FLAG
	MOV	BX,OFFSET OFFMSG	;ASSUME OFF
	OR	AL,AL
	JZ	NUMOFF			;IT'S OFF
	MOV	BX,OFFSET ONMSG
NUMOFF:	CALL	TYPTX1
	CALL	TYPTX			;** 4
	DB	13,10,'Blinking video emulation is',' '+80H
	MOV	AX,ES:BLINK[DI]		;GET BLINK MASK
	MOV	BX,OFFSET ENAB		;ASSUME ENABLED
	OR	AX,AX
	JNZ	BLNKEN			;ENABLED
	MOV	BX,OFFSET DISAB
BLNKEN:	CALL	TYPTX1			;PRINT BLINKING STATUS
	MOV	AX,ES:MEMSZ[DI]		;GET PROGRAM MEMORY SPACE ** 8
	MOV	BYTE PTR LEVFLG,AH	;MARK LEVEL
	OR	AX,AX
	JZ	NOTL3			;NOT LEVEL3
	PUSH	AX
	CALL	TYPTX
	DB	9,'Emulated system memory size is',' '+80H
	POP	AX
	MOV	BX,OFFSET M640		;ASSUME 640K
	CMP	AX,0A000H
	JZ	R640			;THERE'S 640K
	MOV	BX,OFFSET M704
R640:	CALL	TYPTX1			;PRINT MEMORY STATUS
NOTL3:	CALL	TYPTX
	DB	13,10,10
	DB	'Enter the first letter or number of your choice, or '
	DB	'RETURN to skip.',13,10,10
	DB	'Enter default video mode (0-7):',' '+80H
GETMOD:	CALL	GETKEY			;GET RESPONSE
	CMP	AL,13			;CR?
	JNZ	NOTCR			;NO
	MOV	BX,OFFSET NOCHG
	CALL	TYPTX1			;ELSE, SAY "NO CHANGE"
	JMP	SHORT ENTFNT		;PROMPT FOR FONT
NOTCR:	SUB	AL,'0'			;REMOVE ASCII
	JC	GETMOD			;BAD ENTRY
	CMP	AL,8
	JNB	GETMOD			;BAD ENTRY
	MOV	ES:DEFMODE[DI],AL	;STORE NEW DEFAULT MODE
	CALL	PRTMOD			;PRINT IT
ENTFNT:	CALL	TYPTX
	DB	13,10,'Enter font (PC-style, Standard Z-100, User supplied)'
	DB	':',' '+80H
GETFNT:	CALL	GETKEY			;GET RESPONSE
	CMP	AL,13			;CR?
	JNZ	NOTCR1			;NO
	MOV	BX,OFFSET NOCHG
	CALL	TYPTX1			;ELSE, SAY "NO CHANGE"
	JMP	ENTWHT			;GO TO NEXT PROMPT
NOTCR1:	MOV	AH,0			;ASSUME PC FONT
	CMP	AL,'P'			;PC?
	JZ	GDFNT1			;GOOD FONT
	MOV	AH,1			;ASSUME STANDARD FONT
	CMP	AL,'S'			;STANDARD?
	JZ	GDFNT
	MOV	AH,2			;ASSUME USER FONT
	CMP	AL,'U'			;USER?
	JNZ	GETFNT			;BAD ENTRY
GDFNT:	MOV	ES:WORD PTR ICOLOR[DI],0 ;DISABLE INTENSE COLORS
GDFNT1:	MOV	AL,AH
	MOV	ES:FONT[DI],AL		;STORE FONT CODE IN ZPC
	PUSH	AX			;SAVE FONT CODE
	CALL	PRTFNT			;PRINT FONT
	POP	AX
	MOV	SI,OFFSET PCFTBL	;ASSUME PC FONT
	CMP	AL,0
	JZ	LOADF			;LOAD FONT
	MOV	SI,OFFSET SZFTBL	;ASSUME STANDARD Z-100 FONT
	CMP	AL,1
	JZ	LOADF
	XOR	AX,AX
	MOV	DS,AX
	MOV	SI,3FEH
	MOV	DS,[SI]			;POINT TO ROM DATA SEGMENT
	MOV	SI,6FH			;POINT TO CHARACTER TABLE ADDRESS
	LDS	SI,DWORD PTR [SI]	;GET IT
	ADD	SI,9			;MOVE TO "!"
LOADF:	PUSH	SI			;SAVE POINTER TO TABLE
	PUSH	DI			;SAVE POINTER TO ZPC
	MOV	DI,ES:CHRTBA[DI]	;GET ADDRESS OF TEXT CHAR TABLE
	MOV	CX,94*9			;94 CHARACTERS, 9 SCAN LINES EACH
	CLD
	REP	MOVSB			;MOVE IN NEW TABLE
	POP	DI
	POP	SI
	PUSH	DI
	MOV	DI,ES:CHRTBA1[DI]	;GET ADDRESS OF GRAPHIC CHAR TABLE
	MOV	DL,94			;94 CHARACTERS
LOADLP:	INC	SI			;SKIP FIRST SCAN LINE
	MOV	CX,8
	REP	MOVSB			;MOVE IN A CHARACTER
	DEC	DL			;COUNT IT
	JNZ	LOADLP			;LOOP UNTIL FINISHED
	POP	DI			;RESTORE POINTER TO ZPC
	PUSH	CS
	POP	DS			;ENSURE DS GOOD
ENTWHT:	CALL	TYPTX
	DB	13,10,'Enable/Disable intense white emulation:',' '+80H
GETWHT:	CALL	GETKEY			;GET RESPONSE
	MOV	BX,OFFSET ENAB1		;ASSUME ENABLE
	MOV	DX,0AAAAH
	CMP	AL,'E'			;ENABLE?
	JZ	ENWHT			;YES
	MOV	BX,OFFSET NOCHG
	CMP	AL,0DH
	JZ	ENWHT1			;NO CHANGE
	CMP	AL,'D'			;DISABLE?
	JNZ	GETWHT			;BAD ENTRY
	MOV	BX,OFFSET DISAB1
	MOV	DX,0
ENWHT:	MOV	ES:IWHITE[DI],DX	;SET STATUS
ENWHT1:	CALL	TYPTX1			;PRINT STATUS
	CALL	TYPTX
	DB	13,10,'Enable/Disable intense color emulation:',' '+80H
GETCOL:	CALL	GETKEY			;GET RESPONSE
	MOV	BX,OFFSET ENAB1		;ASSUME ENABLE
	MOV	DX,05555H
	CMP	AL,'E'			;ENABLE?
	JZ	ENCOL			;YES
	MOV	BX,OFFSET NOCHG
	CMP	AL,0DH
	JZ	ENCOL1			;NO CHANGE
	CMP	AL,'D'			;DISABLE?
	JNZ	GETCOL			;BAD ENTRY
	MOV	BX,OFFSET DISAB1
	MOV	DX,0
ENCOL:	MOV	ES:ICOLOR[DI],DX	;SET STATUS
	OR	DX,DX			;DISABLING?
	JZ	ENCOL1			;YES, MOVE ON
	CMP	ES:BYTE PTR FONT[DI],0	;PC FONT?
	JZ	ENCOL1			;YES
	MOV	AL,7
	CALL	CHROUT			;ELSE, BEEP
ENCOL1:	CALL	TYPTX1			;PRINT STATUS
	CALL	TYPTX
	DB	13,10,'Enable/Disable blinking video emulation:',' '+80H
GETBL:	CALL	GETKEY			;GET RESPONSE
	MOV	BX,OFFSET ENAB1		;ASSUME ENABLE
	MOV	DX,05555H
	CMP	AL,'E'			;ENABLE?
	JZ	ENBL			;YES
	MOV	BX,OFFSET NOCHG
	CMP	AL,0DH
	JZ	ENBL1			;NO CHANGE
	CMP	AL,'D'			;DISABLE?
	JNZ	GETBL			;BAD ENTRY
	MOV	BX,OFFSET DISAB1
	MOV	DX,0
ENBL:	MOV	ES:BLINK[DI],DX		;SET STATUS
ENBL1:	CALL	TYPTX1			;PRINT STATUS
	CALL	TYPTX
	DB	13,10,'Enter monochrome normal color (Green, Yellow):',' '+80H
GETMON:	CALL	GETKEY			;GET RESPONSE
	MOV	BX,OFFSET GREEN		;ASSUME GREEN
	MOV	DL,11101111B
	CMP	AL,'G'			;GREEN?
	JZ	SETMON
	MOV	BX,OFFSET NOCHG
	CMP	AL,0DH			;NO CHANGE?
	JZ	SETMON1
	MOV	BX,OFFSET YELLOW
	MOV	DL,11111111B
	CMP	AL,'Y'			;YELLOW?
	JNZ	GETMON			;BAD ENTRY
SETMON:	MOV	ES:REDSEL[DI],DL	;SET MONOCHROME COLOR
SETMON1:CALL	TYPTX1			;PRINT IT
	CALL	TYPTX
	DB	13,10,'Enable/Disable graphic mode cursor:',' '+80H
GETGC:	CALL	GETKEY			;GET RESPONSE
	MOV	BX,OFFSET ENAB1		;ASSUME ENABLE
	MOV	DL,1
	CMP	AL,'E'			;ENABLE?
	JZ	ENGC			;YES
	MOV	BX,OFFSET NOCHG
	CMP	AL,0DH
	JZ	ENGC1			;NO CHANGE
	CMP	AL,'D'			;DISABLE?
	JNZ	GETGC			;BAD ENTRY
DISGC:	MOV	BX,OFFSET DISAB1
	MOV	DL,0
ENGC:	MOV	ES:GCUR[DI],DL		;SET STATUS
ENGC1:	CALL	TYPTX1			;PRINT STATUS
	CALL	TYPTX
	DB	13,10,'Enter default Num Lck state (1=Off, 2=On):',' '+80H
GETNUM:	CALL	GETKEY			;GET RESPONSE
	MOV	BX,OFFSET NOCHG
	CMP	AL,0DH
	JZ	SETNUM1			;NO CHANGE
	MOV	BX,OFFSET OFFMSG	;ASSUME OFF
	MOV	DL,0
	CMP	AL,'1'
	JZ	SETNUM			;IT'S OFF
	MOV	BX,OFFSET ONMSG		;ASSUME ON
	MOV	DL,20H
	CMP	AL,'2'
	JNZ	GETNUM
SETNUM:	MOV	SI,ES:NUMLCK[DI]	;GET NUM LOCK FLAG POINTER
	MOV	ES:[SI],DL		;SET NUM LOCK STATE
SETNUM1:CALL	TYPTX1			;PRINT STATE
	CMP	BYTE PTR LEVFLG,0	;LEVEL 3?
	JZ	CHKWRT			;IF NOT, DONE
	CALL	TYPTX
	DB	13,10,'Enter emulated system memory size (640,704):',' '+80H
GETMS:	CALL	GETKEY			;GET RESPONSE
	MOV	BX,OFFSET M640		;ASSUME 640K
	MOV	DX,0A000H
	CMP	AL,'6'			;640?
	JZ	SET640			;YES
	MOV	BX,OFFSET NOCHG
	CMP	AL,0DH
	JZ	SET6401			;NO CHANGE
	CMP	AL,'7'			;704?
	JNZ	GETMS			;BAD ENTRY
	MOV	BX,OFFSET M704
	MOV	DX,0B000H
SET640:	MOV	ES:MEMSZ[DI],DX		;SET MEMORY SIZE
SET6401:CALL	TYPTX1
CHKWRT:	CALL	TYPTX
	DB	13,10,10,'Write changes to disk (Yes/No)?',' '+80H
GETWRT:	CALL	GETKEY
	MOV	BX,OFFSET NOMSG		;ASSUME NO
	CMP	AL,0DH
	JZ	NOWRT			;CR = DO NOT WRITE
	CMP	AL,'N'			;NO?
	JZ	NOWRT
	MOV	BX,OFFSET YESMSG	;ASSUME YES
	CMP	AL,'Y'			;YES?
	JZ	DOWRT
	JMP	GETWRT			;BAD ENTRY
NOWRT:	CALL	TYPTX1
	JMP	DONE
DOWRT:	CALL	TYPTX1
	MOV	DX,OFFSET ZPCFCB
	MOV	AH,OPENF
	INT	21H			;TRY TO OPEN ZPC.COM
	OR	AL,AL
	JZ	OPENOK
	CALL	TYPTX
	DB	13,10,'ERROR -- Cannot find ZPC.COM','.'+80H
	JMP	DONE
OPENOK:	MOV	WORD PTR RECSIZ,1	;SET RECORD SIZE TO 1 BYTE
	MOV	WORD PTR RNDREC,3	;START AT BYTE 3 IN ZPC
	MOV	DX,DI
	PUSH	ES
	POP	DS			;POINT DS:DX TO ZPC FLAGS
	MOV	AH,SETDTA
	INT	21H			;SET DTA THERE
	PUSH	CS
	POP	DS
	MOV	CX,18			;WRITE 18 BYTES
	MOV	DX,OFFSET ZPCFCB
	MOV	AH,RBW
	INT	21H			;WRITE FLAGS
	OR	AL,AL
	JNZ	BADWRT			;BAD WRITE
	MOV	AX,ES:NUMLCK[DI]	;GET NUM LCK FLAG ADDRESS
	MOV	DX,AX			;IN DX, TOO
	SUB	AX,100H			;SUBTRACT HEADER OFFSET
	MOV	WORD PTR RNDREC,AX	;POINT RANDOM RECORD THERE
	PUSH	ES
	POP	DS
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO NUM LCK FLAG
	PUSH	CS
	POP	DS
	MOV	CX,1			;WRITE 1 BYTE
	MOV	DX,OFFSET ZPCFCB
	MOV	AH,RBW
	INT	21H			;WRITE NUM LCK FLAG
	OR	AL,AL
	JNZ	BADWRT			;BAD WRITE
	MOV	AX,ES:CHRTBA[DI]	;GET TEXT CHARACTER TABLE ADDRESS
	MOV	DX,AX			;IN DX, TOO
	SUB	AX,100H			;SUBTRACT HEADER OFFSET
	MOV	WORD PTR RNDREC,AX	;POINT RANDOM RECORD THERE
	PUSH	ES
	POP	DS
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO CHAR TABLE ADDRESS
	PUSH	CS
	POP	DS
	MOV	CX,94*9			;WRITE 94 CHARACTERS (9 BYTES EACH)
	MOV	DX,OFFSET ZPCFCB
	MOV	AH,RBW
	INT	21H			;WRITE CHARACTERS
	OR	AL,AL
	JZ	WRTOK			;WRITE OK
BADWRT:	CALL	TYPTX
	DB	13,10,'ERROR -- Cannot write to ZPC.COM','.'+80H
	JMP	SHORT DONE
WRTOK:	MOV	AX,ES:CHRTBA1[DI]	;GET GRAPH. CHARACTER TABLE ADDRESS
	MOV	DX,AX			;IN DX, TOO
	SUB	AX,100H			;SUBTRACT HEADER OFFSET
	MOV	WORD PTR RNDREC,AX	;POINT RANDOM RECORD THERE
	PUSH	ES
	POP	DS
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO CHAR TABLE ADDRESS
	PUSH	CS
	POP	DS
	MOV	CX,94*8			;WRITE 94 CHARACTERS (8 BYTES EACH)
	MOV	DX,OFFSET ZPCFCB
	MOV	AH,RBW
	INT	21H			;WRITE CHARACTERS
	OR	AL,AL
	JNZ	BADWRT			;BAD WRITE
	MOV	DX,OFFSET ZPCFCB
	MOV	AH,CLOSEF
	INT	21H			;CLOSE FILE
	OR	AL,AL
	JNZ	BADWRT
DONE:	CMP	BYTE PTR IBMFLG,1	;IBM MODE ON?
	JZ	IBMM			;YES
	CALL	TYPTX
	DB	13,10+80H
	INT	20H
IBMM:	CALL	TYPTX
	DB	27,'x','5'+80H		;TURN OFF Z-100 CURSOR
	INT	20H

;	TYPTX - TYPE TEXT UNTIL PARITY BIT SET

TYPTX:	MOV	BP,SP			;GET TEXT ADDR
	XCHG	BX,[BP]
	CALL	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPTX1:	MOV	AL,[BX]
	AND	AL,7FH
	CALL	CHROUT			;OUTPUT CHARACTER
	CMP	AL,[BX]
	LAHF
	INC	BX
	SAHF
	JZ	TYPTX1
	RET

;	CHARACTER OUTPUT ROUTINE, VIA ROM

CHROUT:	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	CLD
	CALL	ROMOUT			;PRINT CHARACTER VIA ROM
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	PRINT VIDEO MODE

PRTMOD:	PUSH	AX			;SAVE IT
	ADD	AL,'0'			;CONVERT TO ASCII
	CALL	CHROUT			;PRINT IT
	POP	AX
	CBW				;CONVERT MODE TO WORD
	MOV	CL,MODSIZ
	MUL	CL			;MULTIPLY BY SIZE OF MODE TABLE
	MOV	BX,OFFSET MODES
	ADD	BX,AX			;POINT TO MODE DESCRIPTION
	CALL	TYPTX1			;PRINT IT
	RET

;	PRINT FONT DESCRIPTION FROM CODE

PRTFNT:	CBW				;MAKE IT A WORD
	MOV	CL,FNTSIZ
	MUL	CL			;MULTIPLY BY SIZE OF FONT DESC. TABLE
	MOV	BX,OFFSET FONTS
	ADD	BX,AX			;POINT TO FONT DESCRIPTION
	CALL	TYPTX1
	RET

;	GET KEY FROM USER

GETKEY:	MOV	AH,7
	INT	21H			;GET KEY
	CMP	AL,3			;CONTROL-C?
	JZ	DONE			;IF SO, DONE
	CMP	AL,'@'			;ALPHA?
	JC	GETKX			;IF NOT, EXIT
	AND	AL,5FH			;ELSE, CAPITALIZE
GETKX:	RET

TSTMSG	DB	13,27,'Z',13,'  $'	;Z-100 TEST MSG
ENAB	DB	'enabled','.'+80H
DISAB	DB	'disabled','.'+80H
GREEN	DB	'Green','.'+80H
YELLOW	DB	'Yellow','.'+80H
OFFMSG	DB	'Off','.'+80H
ONMSG	DB	'On','.'+80H
M640	DB	'640K','.'+80H
M704	DB	'704K','.'+80H
ENAB1	DB	'Enable','.'+80H
DISAB1	DB	'Disable','.'+80H
NOCHG	DB	'No change','.'+80H
YESMSG	DB	'Yes','.'+80H
NOMSG	DB	'No','.'+80H

MODES	DB	' -- 40 column b&w. ',' '+80H
MODES1	DB	' -- 40 column color','.'+80H
	DB	' -- 80 column b&w. ',' '+80H
	DB	' -- 80 column color','.'+80H
	DB	' -- Med. res. color','.'+80H
	DB	' -- Med. res. b&w. ',' '+80H
	DB	' -- Hi. res. b&w.  ',' '+80H
	DB	' -- Monochrome card','.'+80H
MODSIZ	EQU	MODES1-MODES

FONTS	DB	'PC-style.     ',' '+80H
FONTS1	DB	'Standard Z-100','.'+80H
	DB	'User supplied.',' '+80H
FNTSIZ	EQU	FONTS1-FONTS

;	PC-STYLE FONT TABLE
;	THIS TABLE DEFINES CHARACTERS ! THROUGH ~ IN A PC-STYLE FONT

PCFTBL	DB	00H,018H,03CH,03CH,018H,018H,00H,018H,00H	;21H (!)
	DB	00H,036H,036H,036H,00H,00H,00H,00H,00H
	DB	00H,036H,036H,07FH,036H,07FH,036H,036H,00H
	DB	00H,018H,03EH,060H,03CH,06H,07CH,018H,00H
	DB	00H,00H,063H,066H,0CH,018H,033H,063H,00H
	DB	00H,01CH,036H,01CH,03BH,06EH,066H,03BH,00H
	DB	00H,030H,030H,060H,00H,00H,00H,00H,00H
	DB	00H,0CH,018H,030H,030H,030H,018H,0CH,00H
	DB	00H,030H,018H,0CH,0CH,0CH,018H,030H,00H
	DB	00H,00H,066H,03CH,0FFH,03CH,066H,00H,00H
	DB	00H,00H,018H,018H,07EH,018H,018H,00H,00H
	DB	00H,00H,00H,00H,00H,00H,018H,018H,030H
	DB	00H,00H,00H,00H,07EH,00H,00H,00H,00H
	DB	00H,00H,00H,00H,00H,00H,018H,018H,00H
	DB	00H,03H,06H,0CH,018H,030H,060H,040H,00H
	DB	00H,03EH,063H,067H,06FH,07BH,073H,03EH,00H	;30H (0)
	DB	00H,018H,038H,018H,018H,018H,018H,07EH,00H
	DB	00H,03CH,066H,06H,01CH,030H,066H,07EH,00H
	DB	00H,03CH,066H,06H,01CH,06H,066H,03CH,00H
	DB	00H,0EH,01EH,036H,066H,07FH,06H,0FH,00H
	DB	00H,07EH,060H,07CH,06H,06H,066H,03CH,00H
	DB	00H,01CH,030H,060H,07CH,066H,066H,03CH,00H
	DB	00H,07EH,066H,06H,0CH,018H,018H,018H,00H
	DB	00H,03CH,066H,066H,03CH,066H,066H,03CH,00H
	DB	00H,03CH,066H,066H,03EH,06H,0CH,038H,00H
	DB	00H,00H,018H,018H,00H,00H,018H,018H,00H
	DB	00H,00H,018H,018H,00H,00H,018H,018H,030H
	DB	00H,0CH,018H,030H,060H,030H,018H,0CH,00H
	DB	00H,00H,00H,07EH,00H,00H,07EH,00H,00H
	DB	00H,030H,018H,0CH,06H,0CH,018H,030H,00H
	DB	00H,03CH,066H,06H,0CH,018H,00H,018H,00H
	DB	00H,03EH,063H,06FH,06FH,06FH,060H,03CH,00H	;40H (@)
	DB	00H,018H,03CH,066H,066H,07EH,066H,066H,00H
	DB	00H,07EH,033H,033H,03EH,033H,033H,07EH,00H
	DB	00H,01EH,033H,060H,060H,060H,033H,01EH,00H
	DB	00H,07CH,036H,033H,033H,033H,036H,07CH,00H
	DB	00H,07FH,031H,034H,03CH,034H,031H,07FH,00H
	DB	00H,07FH,031H,034H,03CH,034H,030H,078H,00H
	DB	00H,01EH,033H,060H,060H,067H,033H,01FH,00H
	DB	00H,066H,066H,066H,07EH,066H,066H,066H,00H
	DB	00H,03CH,018H,018H,018H,018H,018H,03CH,00H
	DB	00H,0FH,06H,06H,06H,066H,066H,03CH,00H
	DB	00H,073H,033H,036H,03CH,036H,033H,073H,00H
	DB	00H,078H,030H,030H,030H,031H,033H,07FH,00H
	DB	00H,063H,077H,07FH,07FH,06BH,063H,063H,00H
	DB	00H,063H,073H,07BH,06FH,067H,063H,063H,00H
	DB	00H,01CH,036H,063H,063H,063H,036H,01CH,00H
	DB	00H,07EH,033H,033H,03EH,030H,030H,078H,00H	;50H (P)
	DB	00H,03CH,066H,066H,066H,06EH,03CH,0EH,00H
	DB	00H,07EH,033H,033H,03EH,036H,033H,073H,00H
	DB	00H,03CH,066H,060H,03CH,06H,066H,03CH,00H
	DB	00H,07EH,05AH,018H,018H,018H,018H,03CH,00H
	DB	00H,066H,066H,066H,066H,066H,066H,03CH,00H
	DB	00H,066H,066H,066H,066H,066H,03CH,018H,00H
	DB	00H,063H,063H,063H,06BH,07FH,077H,063H,00H
	DB	00H,063H,063H,036H,01CH,036H,063H,063H,00H
	DB	00H,066H,066H,066H,03CH,018H,018H,03CH,00H
	DB	00H,07FH,063H,046H,0CH,019H,033H,07FH,00H
	DB	00H,03CH,030H,030H,030H,030H,030H,03CH,00H
	DB	00H,060H,030H,018H,0CH,06H,03H,01H,00H
	DB	00H,03CH,0CH,0CH,0CH,0CH,0CH,03CH,00H
	DB	00H,08H,01CH,036H,063H,00H,00H,00H,00H
	DB	00H,00H,00H,00H,00H,00H,00H,00H,0FFH
	DB	00H,018H,018H,0CH,00H,00H,00H,00H,00H		;60H (`)
	DB	00H,00H,00H,03CH,06H,03EH,066H,03BH,00H
	DB	00H,070H,030H,030H,03EH,033H,033H,06EH,00H
	DB	00H,00H,00H,03CH,066H,060H,066H,03CH,00H
	DB	00H,0EH,06H,06H,03EH,066H,066H,03BH,00H
	DB	00H,00H,00H,03CH,066H,07EH,060H,03CH,00H
	DB	00H,01CH,036H,030H,078H,030H,030H,078H,00H
	DB	00H,00H,00H,03BH,066H,066H,03EH,06H,07CH
	DB	00H,070H,030H,036H,03BH,033H,033H,073H,00H
	DB	00H,018H,00H,038H,018H,018H,018H,03CH,00H
	DB	00H,06H,00H,06H,06H,06H,066H,066H,03CH
	DB	00H,070H,030H,033H,036H,03CH,036H,073H,00H
	DB	00H,038H,018H,018H,018H,018H,018H,03CH,00H
	DB	00H,00H,00H,066H,07FH,07FH,06BH,063H,00H
	DB	00H,00H,00H,07CH,066H,066H,066H,066H,00H
	DB	00H,00H,00H,03CH,066H,066H,066H,03CH,00H
	DB	00H,00H,00H,06EH,033H,033H,03EH,030H,078H	;70H (p)
	DB	00H,00H,00H,03BH,066H,066H,03EH,06H,0FH
	DB	00H,00H,00H,06EH,03BH,033H,030H,078H,00H
	DB	00H,00H,00H,03EH,060H,03CH,06H,07CH,00H
	DB	00H,08H,018H,03EH,018H,018H,01AH,0CH,00H
	DB	00H,00H,00H,066H,066H,066H,066H,03BH,00H
	DB	00H,00H,00H,066H,066H,066H,03CH,018H,00H
	DB	00H,00H,00H,063H,06BH,07FH,07FH,036H,00H
	DB	00H,00H,00H,063H,036H,01CH,036H,063H,00H
	DB	00H,00H,00H,066H,066H,066H,03EH,06H,07CH
	DB	00H,00H,00H,07EH,04CH,018H,032H,07EH,00H
	DB	00H,0EH,018H,018H,070H,018H,018H,0EH,00H
	DB	00H,0CH,0CH,0CH,00H,0CH,0CH,0CH,00H
	DB	00H,070H,018H,018H,0EH,018H,018H,070H,00H
	DB	00H,03BH,06EH,00H,00H,00H,00H,00H,00H

;	STANDARD Z-100 CHARACTER TABLE
;	THIS TABLE DEFINES THE CHARACTERS ! THROUGH ~, AND
;	IS FROM THE DEFAULT ALTCHAR.SYS

SZFTBL	DB	00H,08H,08H,08H,08H,08H,00H,08H,00H		;21H
	DB	00H,014H,014H,014H,00H,00H,00H,00H,00H
	DB	00H,014H,014H,03EH,014H,03EH,014H,014H,00H
	DB	00H,08H,01EH,028H,01CH,0AH,03CH,08H,00H
	DB	00H,030H,032H,04H,08H,010H,026H,06H,00H
	DB	00H,08H,014H,014H,018H,02AH,024H,01AH,00H
	DB	00H,0CH,08H,010H,00H,00H,00H,00H,00H
	DB	00H,04H,08H,010H,010H,010H,08H,04H,00H
	DB	00H,010H,08H,04H,04H,04H,08H,010H,00H
	DB	00H,00H,08H,02AH,01CH,02AH,08H,00H,00H
	DB	00H,00H,08H,08H,03EH,08H,08H,00H,00H
	DB	00H,00H,00H,00H,00H,018H,018H,08H,010H
	DB	00H,00H,00H,00H,03EH,00H,00H,00H,00H
	DB	00H,00H,00H,00H,00H,00H,018H,018H,00H
	DB	00H,01H,02H,04H,08H,010H,020H,040H,00H
	DB	00H,01CH,022H,026H,02AH,032H,022H,01CH,00H	;30H
	DB	00H,08H,018H,08H,08H,08H,08H,01CH,00H
	DB	00H,01CH,022H,02H,04H,08H,010H,03EH,00H
	DB	00H,03EH,04H,08H,04H,02H,022H,01CH,00H
	DB	00H,04H,0CH,014H,024H,03EH,04H,04H,00H
	DB	00H,03EH,020H,03CH,02H,02H,022H,01CH,00H
	DB	00H,0CH,010H,020H,03CH,022H,022H,01CH,00H
	DB	00H,03EH,02H,04H,08H,010H,010H,010H,00H
	DB	00H,01CH,022H,022H,01CH,022H,022H,01CH,00H
	DB	00H,01CH,022H,022H,01EH,02H,04H,018H,00H
	DB	00H,00H,018H,018H,00H,018H,018H,00H,00H
	DB	00H,00H,018H,018H,00H,018H,018H,08H,010H
	DB	00H,02H,04H,08H,010H,08H,04H,02H,00H
	DB	00H,00H,00H,03EH,00H,03EH,00H,00H,00H
	DB	00H,020H,010H,08H,04H,08H,010H,020H,00H
	DB	00H,01CH,022H,02H,04H,08H,00H,08H,00H
	DB	00H,0CH,012H,026H,02AH,02EH,020H,01EH,00H	;40H
	DB	00H,01CH,022H,022H,03EH,022H,022H,022H,00H
	DB	00H,03CH,022H,022H,03CH,022H,022H,03CH,00H
	DB	00H,01CH,022H,020H,020H,020H,022H,01CH,00H
	DB	00H,038H,024H,022H,022H,022H,024H,038H,00H
	DB	00H,03EH,020H,020H,03CH,020H,020H,03EH,00H
	DB	00H,03EH,020H,020H,03CH,020H,020H,020H,00H
	DB	00H,01CH,022H,020H,026H,022H,022H,01EH,00H
	DB	00H,022H,022H,022H,03EH,022H,022H,022H,00H
	DB	00H,01CH,08H,08H,08H,08H,08H,01CH,00H
	DB	00H,0EH,04H,04H,04H,04H,024H,018H,00H
	DB	00H,022H,024H,028H,030H,028H,024H,022H,00H
	DB	00H,020H,020H,020H,020H,020H,020H,03EH,00H
	DB	00H,022H,036H,02AH,02AH,022H,022H,022H,00H
	DB	00H,022H,022H,032H,02AH,026H,022H,022H,00H
	DB	00H,01CH,022H,022H,022H,022H,022H,01CH,00H
	DB	00H,03CH,022H,022H,03CH,020H,020H,020H,00H	;50H
	DB	00H,01CH,022H,022H,022H,02AH,024H,01AH,00H
	DB	00H,03CH,022H,022H,03CH,028H,024H,022H,00H
	DB	00H,01CH,022H,020H,01CH,02H,022H,01CH,00H
	DB	00H,03EH,08H,08H,08H,08H,08H,08H,00H
	DB	00H,022H,022H,022H,022H,022H,022H,01CH,00H
	DB	00H,022H,022H,022H,014H,014H,08H,08H,00H
	DB	00H,022H,022H,022H,02AH,02AH,02AH,014H,00H
	DB	00H,022H,022H,014H,08H,014H,022H,022H,00H
	DB	00H,022H,022H,014H,08H,08H,08H,08H,00H
	DB	00H,03EH,02H,04H,08H,010H,020H,03EH,00H
	DB	00H,0EH,08H,08H,08H,08H,08H,0EH,00H
	DB	00H,040H,020H,010H,08H,04H,02H,01H,00H
	DB	00H,038H,08H,08H,08H,08H,08H,038H,00H
	DB	00H,08H,014H,022H,00H,00H,00H,00H,00H
	DB	00H,00H,00H,00H,00H,00H,00H,07FH,00H
	DB	00H,018H,08H,04H,00H,00H,00H,00H,00H		;60H
	DB	00H,00H,00H,01CH,02H,01EH,022H,01EH,00H
	DB	00H,020H,020H,03CH,022H,022H,022H,03CH,00H
	DB	00H,00H,00H,01CH,022H,020H,020H,01CH,00H
	DB	00H,02H,02H,01EH,022H,022H,022H,01EH,00H
	DB	00H,00H,00H,01CH,022H,03EH,020H,01CH,00H
	DB	00H,0CH,012H,010H,038H,010H,010H,010H,00H
	DB	00H,00H,00H,01EH,024H,038H,01CH,022H,01CH
	DB	00H,020H,020H,03CH,022H,022H,022H,022H,00H
	DB	00H,08H,00H,018H,08H,08H,08H,01CH,00H
	DB	00H,02H,00H,02H,02H,02H,02H,022H,01CH
	DB	00H,020H,020H,024H,028H,034H,022H,022H,00H
	DB	00H,018H,08H,08H,08H,08H,08H,01CH,00H
	DB	00H,00H,00H,034H,02AH,02AH,02AH,02AH,00H
	DB	00H,00H,00H,03CH,022H,022H,022H,022H,00H
	DB	00H,00H,00H,01CH,022H,022H,022H,01CH,00H
	DB	00H,00H,00H,02CH,032H,032H,02CH,020H,020H	;70H
	DB	00H,00H,00H,01AH,026H,026H,01AH,02H,02H
	DB	00H,00H,00H,02CH,032H,020H,020H,020H,00H
	DB	00H,00H,00H,01CH,020H,01CH,02H,01CH,00H
	DB	00H,010H,010H,038H,010H,010H,012H,0CH,00H
	DB	00H,00H,00H,022H,022H,022H,026H,01AH,00H
	DB	00H,00H,00H,022H,022H,022H,014H,08H,00H
	DB	00H,00H,00H,022H,022H,02AH,02AH,014H,00H
	DB	00H,00H,00H,022H,014H,08H,014H,022H,00H
	DB	00H,00H,00H,022H,022H,026H,01AH,02H,01CH
	DB	00H,00H,00H,03EH,04H,08H,010H,03EH,00H
	DB	00H,0CH,010H,010H,020H,010H,010H,0CH,00H
	DB	00H,08H,08H,08H,00H,08H,08H,08H,00H
	DB	00H,018H,04H,04H,02H,04H,04H,018H,00H
	DB	00H,030H,049H,06H,00H,00H,00H,00H,00H		;7EH

IBMFLG	DB	0
LEVFLG	DB	0

ZPCFCB	DB	0,'ZPC     COM'
	DB	0,0
RECSIZ	DW	1			;RECORD SIZE (1 BYTE)
	DB	17 DUP (0)
RNDREC	DW	0,0			;RANDOM RECORD NUMBER

CODE	ENDS
	END	START
                                                                                                                              