	PAGE	,132
;	VIDCON -- A PROGRAM TO DISABLE/ENABLE THE
;	VIDEO CONTROL PORT ON A ZHS CARD.
;
;	TO USE THIS PROGRAM, ENTER
;
;	VIDCON OFF	TO TURN THE VIDEO CONTROL PORT OFF
;	VIDCON		TO TURN THE VIDEO CONTROL PORT ON
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER

SLAVE	EQU	0F0H		;SLAVE PIC PORT
VCIM	EQU	01000000B	;VIDEO CONTROL INT. MASK

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5CH
FCB	LABEL	BYTE		;DEFINE FCB
	ORG	100H

START:	MOV	DX,OFFSET OPMSG
	MOV	AH,9
	INT	21H		;PRINT OPENING MSG.
	CMP	FCB+1,'O'	;TURN VIDCON OFF?
	MOV	DX,OFFSET OFFMSG ;ASSUME OFF
	IN	AL,SLAVE+1	;GET SLAVE MASK
	JZ	OFF
	MOV	DX,OFFSET ONMSG	;GET ON MSG.
	AND	AL,0FFH-VCIM	;TURN ON VIDEO CONTROL PORT
	JMP	SHORT FINISH	;FINISH UP
OFF:	OR	AL,VCIM		;MASK OFF VIDEO CON. PORT
FINISH:	OUT	SLAVE+1,AL	;UPDATE MASK
	MOV	AH,9
	INT	21H		;PRINT OFF/ON MSG.
	INT	20H		;AND EXIT

OPMSG	DB	13,10,'Video control port is $'
OFFMSG	DB	'off.',13,10,'$'
ONMSG	DB	'on. ',13,10,'$'

CODE	ENDS
	END	START
