	PAGE	,132
;	ZHS BOARD TEST ROUTINE
;
;	THIS PROGRAM TESTS THE VIDEO AND KEYBOARD PORTS
;	ON A ZHS BOARD.  IT CAN BE RUN WHILE ZPC IS IN
;	EITHER THE PC OR Z-100 MODES.
;
;	BY P. SWAYNE, HUG  04-AUG-86  06-NOV-86
;	COPYRIGHT (C) 1986 BY HEATH/ZENITH USERS' GROUP

MASTER	EQU	0F2H			;MASTER PIC PORT
SLAVE	EQU	0F0H			;SLAVE PIC PORT
V7INT	EQU	4FH			;V7 INTERRUPT
V6INT	EQU	4EH			;V6 INTERRUPT

JMPF	MACRO
	DB	0EAH
	ENDM

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

;	SET UP VECTORS AND 8259'S

START:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON MESSAGE
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INT. PAGE
	MOV	SI,OFFSET V7INT*4	;POINT TO V7 VECTOR
	MOV	DI,OFFSET V7SAV		;SAVE IT HERE
	PUSH	SI
	CLD
	MOVSW				;SAVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET IN60	;SET NEW VECTOR
	MOV	2[SI],CS
	MOV	SI,OFFSET V6INT*4	;POINT TO V6 VECTOR
	MOV	DI,OFFSET V6SAV		;SAVE IT HERE
	PUSH	SI
	MOVSW				;SAVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET OUT3D8	;SET NEW VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;FIX DS
	IN	AL,MASTER+1		;SET UP 8259'S
	MOV	MMASK,AL		;SAVE MASTER MASK
	AND	AL,0FFH-8
	OUT	MASTER+1,AL		;UNMASK SLAVE INPUT
	IN	AL,SLAVE+1
	MOV	SMASK,AL		;SAVE SLAVE MASK
	AND	AL,3FH
	OUT	SLAVE+1,AL		;UNMASK V7, V6 INPUTS

;	TEST OUT 3D8 PROCESSOR

	XOR	BX,BX			;CLEAR FLAG REGISTER
	MOV	DX,3D8H			;GET VIDEO CONTROL PORT
	MOV	AL,55			;GET A TEST VALUE
	OUT	DX,AL			;WRITE TO PORT
	DEC	DX			;CHANGE PORT IMMEDIATELY
	MOV	CX,100
WAIT1:	LOOP	WAIT1			;WAIT A BIT
	OR	AL,AL			;DID IT WORK?
	JNZ	TEST1			;NO
	OR	BX,1			;ELSE, MARK FAST PORT
	JMP	SHORT DO60		;TEST PORT 60
TEST1:	INC	DX			;FIX DX
	OUT	DX,AL			;WRITE TO PORT
	NOP				;ALLOW CIRCUIT TO PROCESS INTERRUPT
	DEC	DX			;NOW CHANGE PORT
	MOV	CX,100
WAIT2:	LOOP	WAIT2			;WAIT A BIT
	OR	AL,AL			;DID IT WORK?
	JNZ	TEST2			;NO
	OR	BX,10B			;ELSE, MARK ADEQUATE PORT
	JMP	SHORT DO60
TEST2:	INC	DX			;FIX DX
	OUT	DX,AL			;WRITE TO PORT
	NOP				;ALLOW CIRCUIT TO PROCESS INTERRUPT
	NOP
	DEC	DX			;NOW CHANGE PORT
	MOV	CX,100
WAIT3:	LOOP	WAIT3			;WAIT A BIT
	OR	AL,AL			;DID IT WORK?
	JNZ	BAD3D8			;NO
	OR	BX,100B			;ELSE, MARK SLOW PORT
	JMP	SHORT DO60
BAD3D8:	OR	BX,1000B		;PORT BAD, MARK IT

;	TEST IN 60 PROCESSOR

DO60:	MOV	DX,60H			;GET PORT 60
	IN	AL,DX			;READ IT
	CMP	AL,55H			;ZHS WORKED?
	JNZ	DO60S			;NO, TEST FOR SLOW PORT
	OR	BX,10000B		;ELSE, MARK PORT OK
	JMP	SHORT TSTVID		;TEST VIDEO RETRACE
DO60S:	IN	AL,DX
	IN	AL,DX			;TEST FOR SLOW PORT
	CMP	AL,55H
	JNZ	BAD60			;PORT 60 IS BAD
	OR	BX,100000B		;MARK PORT SLOW
	JMP	SHORT TSTVID
BAD60:	OR	BX,1000000B		;MARK MALFUNCTION

;	TEST VIDEO RETRACE PORT

TSTVID:	MOV	DX,3DAH			;VIDEO RETRACE PORT
	MOV	CX,20			;SET A COUNTER
TVLP1:	IN	AL,DX			;READ VIDEO PORT
	TEST	AL,1			;TEST RESULT (HORIZONTAL BIT)
	JZ	VIDOK			;PASSED FIRST PART
	LOOP	TVLP1			;GIVE HIM A CHANCE
	OR	BX,100000000B		;MARK VIDEO BAD
	JMP	SHORT REPORT		;AND REPORT IT
VIDOK:	MOV	CX,20			;FIX COUNTER
TVLP2:	IN	AL,DX			;READ VIDEO PORT
	TEST	AL,1			;TEST RESULT
	JNZ	VIDOK1			;PASSED SECOND PART
	LOOP	TVLP2
	OR	BX,100000000B		;MARK VIDEO BAD
	JMP	SHORT REPORT

VIDOK1:	MOV	CX,20			;SET A COUNTER
TVLP3:	IN	AL,DX			;READ VIDEO PORT
	TEST	AL,8			;TEST RESULT (VERTICAL BIT)
	JZ	VIDOK2			;PASSED FIRST PART
	LOOP	TVLP3			;GIVE HIM A CHANCE
	OR	BX,100000000B		;MARK VIDEO BAD
	JMP	SHORT REPORT		;AND REPORT IT
VIDOK2:	MOV	CX,20			;FIX COUNTER
TVLP4:	IN	AL,DX			;READ VIDEO PORT
	TEST	AL,8			;TEST RESULT
	JNZ	VIDOK3			;PASSED SECOND PART
	LOOP	TVLP4
	OR	BX,100000000B		;MARK VIDEO BAD
	JMP	SHORT REPORT

VIDOK3:	OR	BX,10000000B		;MARK VIDEO OK

;	REPORT FINDINGS OF TESTS

REPORT:	MOV	SI,OFFSET MSGTBL	;POINT TO MESSAGE TABLE
FNDMRK:	LODSW				;GET A MESSAGE ADDRESS
	SHR	BX,1			;TEST FOR A MESSAGE MARKER
	JNC	FNDMRK			;THIS IS NOT IT
REPORT1:MOV	DX,AX			;ADDRESS TO DX
	MOV	AH,9
	INT	21H			;REPORT CONDITION
	OR	BX,BX			;DONE?
	JNZ	FNDMRK			;IF NOT, CONTINUE

;	RESTORE INTERRUPT VECTORS AND MASKS

	XOR	AX,AX
	MOV	ES,AX			;POINT TO INT. PAGE
	MOV	DI,OFFSET V6INT*4	;POINT TO V6 VECTOR
	MOV	SI,OFFSET V6SAV		;POINT TO SAVED VECTOR
	MOV	CX,4			;MOVE 4 WORDS
	REP	MOVSW			;FIX VECTORS
	MOV	AL,MMASK		;GET MASTER MASK
	OUT	MASTER+1,AL		;FIX IT
	MOV	AL,SMASK		;GET SLAVE MASK
	OUT	SLAVE+1,AL		;FIX IT
	INT	20H			;EXIT

;	OUT 3D8 INTERRUPT PROCESSOR

OUT3D8:	PUSH	AX
	MOV	AL,20H
	OUT	MASTER,AL		;CLEAR 8259'S
	OUT	SLAVE,AL
	POP	AX
	CMP	DX,3D8H			;IS PORT STILL 3D8?
	JNZ	OUTBAD			;NO
	XOR	AL,AL			;ELSE, CLEAR AL
OUTBAD:	IRET

;	IN 60 INTERRUPT PROCESSOR

IN60:	MOV	CS:ALSAV,AL		;SAVE AX
	MOV	AL,20H
	OUT	MASTER,AL		;CLEAR 8259'S
	OUT	SLAVE,AL
	MOV	CS:SISAV,SI		;SAVE SI,DS
	MOV	CS:DSSAV,DS
	POP	SI			;GET USER'S IP
	POP	DS			;AND HIS CS
	STI
	MOV	AL,-1[SI]		;GET LAST INSTRUCION
	PUSH	DS
	PUSH	SI
	MOV	DS,CS:DSSAV		;RESTORE DS,SI
	MOV	SI,CS:SISAV
	CMP	AL,0ECH			;LAST INS. = IN AL,DX?
	JNZ	NOZHS
	CMP	DX,60H			;PORT = 60H?
	JNZ	NOZHS
ZHSOK:	MOV	AL,55H			;MARK TEST PASSED.
	IRET
NOZHS:	MOV	AL,CS:ALSAV		;RETURN ORIGINAL AX
	IRET

;	STORAGE

V6SAV	DW	0,0			;SAVED V6 VECTOR
V7SAV	DW	0,0			;SAVED V7 VECTOR
MMASK	DB	0			;MASTER PIC MASK
SMASK	DB	0			;SLAVE PIC MASK
ALSAV	DB	0
SISAV	DW	0
DSSAV	DW	0

;	MESSAGE TABLE AND MESSAGES

MSGTBL	DW	MSG1
	DW	MSG2
	DW	MSG3
	DW	MSG4
	DW	MSG5
	DW	MSG6
	DW	MSG7
	DW	MSG8
	DW	MSG9

SIGNON	DB	13,10,'ZHS board status report:',13,10,'$'
MSG1	DB	13,10,'The video control port is FAST (OK).$'
MSG2	DB	13,10,'The video control port is OK.$'
MSG3	DB	13,10,7,'The video control port is slow.$'
MSG4	DB	13,10,7,'The video control port does not work.$'
MSG5	DB	13,10,'The keyboard port is OK.$'
MSG6	DB	13,10,7,'The keyboard port is slow.$'
MSG7	DB	13,10,7,'The keyboard port does not work.$'
MSG8	DB	13,10,'The video retrace port is OK.$'
MSG9	DB	13,10,7,'The video retrace port does not work.$'

CODE	ENDS
	END	START
                           