	TITLE	SS
	PAGE	,132


;DS is short for dual screens. This program is invoked by typing: DS
;
;

dscrn	segment
	assume	cs:dscrn, ds:dscrn, ss:dscrn, es:dscrn

timerint	equ	1ch			;timer interrupt tick
cassint		equ	15h			;cassette interrupt!! yup!
cr		equ	0dh
lf		equ	0ah
bel		equ	7
screen_size	equ	2 * 1024
rate		equ	2
dualon		equ	102
dualoff		equ	103


	org	5ch
def_fcb	label	near


	org	100h
;TERMINATE AND STAY RESIDENT CODE STARTS HERE
;
start:
	jmp	setup				;jump around our tsr stuff



	db	"Copyright (c) 1986 The Heath Users' Group"
	db	"Written By: Jim Buszkiewicz"
	db	"DSCOM"				;signature



cassette_sr:
	cmp	ah,dualoff
	je	ds_out
	cmp	ah,dualon
	jne	cs9
	mov	cs:byte ptr installed,0ffh
	jmp	short cs9
ds_out:
	mov	cs:byte ptr installed,0h
cs9:
	jmp	cs:dword ptr cassvec



timer_sr:
	cmp	cs:byte ptr installed,0ffh
	je	ts0
	jmp	ts9
ts0:
	dec	cs:byte ptr scan_rate
	jz	ts1
	jmp	ts9
ts1:
	push	ax
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	mov	cs:byte ptr scan_rate,rate	;reset the rate
	sti
	mov	ah,0fh
	int	10h				;get video mode information
	mov	cs:byte ptr video_page,bh	;and save the page
	cmp	al,2				;works with mode 2 or 3 only
	je	ts2
	cmp	al,3
	je	ts2
	jmp	ts8				;anything else just quit

ts2:
	mov	ah,3
	int	10h				;get the cursor size & pos.
	mov	cl,ch				;save it here
	and	cl,20h				;is it gone?
	jz	ts4				;nope
	mov	ch,cl				;yup then get back the 20h
	jmp	short chg_cur			;and make it go away on mono.
ts4:
	cmp	ch,4				;somewhat of a block cursor
	mov	ch,1				;get ready if it is
	jc	chg_cur				;yup
	mov	ch,0ch				;nope then make it underline
chg_cur:
	mov	dx,3b4h				;change the cursor to either
	mov	al,0ah				;underline, block, or none
	out	dx,al
	mov	al,ch
	inc	dx
	out	dx,al
	dec	dx
	mov	al,0bh
	out	dx,al
	mov	al,0dh
	inc	dx
	out	dx,al

	mov	bl,cs:byte ptr video_page	;from the page we're on
	xor	bh,bh
	mov	ax,100h
	mul	bx
	add	ax,0b800h			;color graphics card
	mov	ds,ax
	xor	si,si
	mov	ax,0b000h			;hi res monochrome card
	mov	es,ax
	xor	di,di
	mov	cx,screen_size			;size = 4k
	cld
ts3:
	repz cmpsw				;see if there are any
	jz	ts7				;differences between the two
	sub	di,2				;cards... if so, make the
	sub	si,2				;color card, and the monochrome
	movsw					;cards the same.
	jmp	short ts3
ts7:
	mov	ax,800h
	xor	bh,bh
	mov	bl,cs:byte ptr video_page
	mul	bx				;calculate offset
	mov	bx,ax				;save it here

	mov	dx,3d4h				;get the 14 bit address of
	mov	al,0eh				;the cursor
	out	dx,al
	inc	dx
	in	al,dx
	mov	ah,al				;save the high part in AH
	dec	dx
	mov	al,0fh
	out	dx,al
	inc	dx
	in	al,dx				;get the lo part in AL
	sub	ax,bx
	mov	bx,ax

	mov	dx,3b4h
	mov	al,0eh
	out	dx,al
	inc	dx
	mov	al,bh
	out	dx,al
	dec	dx
	mov	al,0fh
	out	dx,al
	inc	dx
	mov	al,bl
	out	dx,al
ts8:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	pop	ax
ts9:
	jmp	cs:dword ptr timervec



signature	db	"DSCOM"			;so we can find ourselves
timervec	dd	0
cassvec		dd	0
video_mode	db	0			;which video mode we're in
chars_pl	db	0			;characters per line
video_page	db	0			;which page we're on
scan_rate	db	0			;ticks before scanning memory
installed	db	0			;installed flag

tsr	equ	$
;
;TERMINATE AND STAY RESIDENT CODE ENDS HERE



setup:
	mov	dx,offset msg1
	mov	ah,9
	int	21h
	mov	bx,offset def_fcb+1
	mov	al,byte ptr[bx]
	and	al,5fh
	cmp	al,'P'
	jne	su1
	jmp	install
su1:
	cmp	al,'D'
	jne	su2
	mov	dx,offset msg5
	mov	ah,9
	int	21h
	mov	ah,dualon
	int	cassint
	int	20h
su2:
	cmp	al,'O'
	jne	usage
	mov	dx,offset msg6
	mov	ah,9
	int	21h
	mov	ah,dualoff
	int	cassint
	int	20h
usage:
	mov	dx,offset msg2
usage1:
	mov	ah,9
	int	21h
	int	20h

install:
	mov	al,cassint
	mov	ah,35h
	int	21h
	mov	di,bx
	sub	di,5
	mov	si,offset signature
	mov	cx,5
	cld
	repz cmpsb
	jnz	su3
	mov	dx,offset msg4
	jmp	usage1
su3:
	mov	word ptr cassvec,bx
	mov	word ptr cassvec+2,es
	mov	dx,offset cassette_sr
	mov	al,cassint
	mov	ah,25h
	int	21h

	mov	al,timerint			;timer vector
	mov	ah,35h
	int	21h
	mov	word ptr timervec,bx
	mov	word ptr timervec+2,es
	mov	dx,offset timer_sr
	mov	al,timerint
	mov	ah,25h
	int	21h

	mov	byte ptr scan_rate,rate
	mov	byte ptr installed,0ffh
	mov	dx,offset msg3
	mov	ah,9
	int	21h
	lea	dx,tsr
	int	27h



msg1	db	cr,lf,"DualScreen Version 1.0 $"
msg2	db	cr,lf,lf,"Usage:"
 db cr,lf,"       DS <POD>"
 db cr,lf,"Where:"
 db cr,lf,"       P => Install DualScreen Permanently In Memory"
 db cr,lf,"       O => Turn Off The Monochrome Screen"
 db cr,lf,"       D => Re-establish DualScreen Mode"
 db cr,lf,lf,"Functions 'O' and 'D' Will Have No Effect If 'DualScreen'"
 db cr,lf,"Is Not First Permanently Installed With The 'P' Function.",cr,lf,"$"
msg3	db	"Installed",cr,lf,lf,"$"
	db	"Copyright (c) 1986 The Heath Users' Group"
	db	"Written By: Jim Buszkiewicz"
msg4	db	bel,"Was Previously Installed",cr,lf,lf,"$"
msg5	db	" ON",cr,lf,"$"
msg6	db	" OFF",cr,lf,"$"
dscrn	ends
	end	start
