	TITLE	SS
	PAGE	,132


;SS is short for screen saver. This program is invoked by typing
;
;                         SS xx,
;
;where xx is two digits represting the time in minutes from no keyboard or
;screen inactivity to when the screen is blanked. Two digits MUST be specified, and
;can range from 01 minutes to 60 minutes.

ssaver	segment
	assume	cs:ssaver, ds:ssaver, ss:ssaver, es:ssaver

keyint		equ	9h			;keyboard activity interrupt
scrnint		equ	10h			;video activity interrupt
timerint	equ	1ch			;timer interrupt tick
cr		equ	0dh
lf		equ	0ah
bel		equ	7
screen_size	equ	16 * 1024



	org	0
zero	label	near

	org	5ch
def_fcb	label	near



	org	100h
;TERMINATE AND STAY RESIDENT CODE STARTS HERE
;
start:
	jmp	setup				;jump around our tsr stuff



	db	"Copyright (c) 1986 The Heath Users' Group"
	db	"Written By: Jim Buszkiewicz"
	db	"SSCOM"				;signature



key_activity_sr:
	push	ax
	mov	ax,cs:word ptr time		;reset the counter
	mov	cs:word ptr count,ax
	cmp	cs:scrn_on,0ffh			;is the screen visible?
	je	kas2
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	call	restore_screen			;restore the screen and
	call	restore_cur			;the cursor
kas1:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
kas2:
	pop	ax
	jmp	cs:dword ptr keyvec



scrn_activity_sr:
	cmp	ah,3
	je	sas3
	cmp	ah,4
	je	sas3
	cmp	ah,8
	je	sas3
	cmp	ah,13
	je	sas3
	cmp	ah,15
	je	sas3
	push	ax
	mov	ax,cs:word ptr time		;reset the
	mov	cs:word ptr count,ax		;counter with time
	cmp	cs:byte ptr scrn_on,0ffh	;is the screen on or off
	je	sas2
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	call	restore_screen			;if off, then restore it
	mov	ah,2
	mov	dh,cs:byte ptr cur_row		;restore
	mov	dl,cs:byte ptr cur_col		;  the
	mov	bh,cs:byte ptr video_page	;    cursor
	cli
	pushf
	call	cs:dword ptr scrnvec
	mov	ah,1
	mov	ch,cs:byte ptr cur_start	;and
	mov	cl,cs:byte ptr cur_end		;  it's
	cli					;    shape
	pushf
	call	cs:dword ptr scrnvec
sas1:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
sas2:
	pop	ax
sas3:
	jmp	cs:dword ptr scrnvec



timer_sr:
	push	ax
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	cmp	cs:byte ptr scrn_on,0ffh
	je	screen_is_on
	jmp	screen_is_off

screen_is_on:
	dec	cs:word ptr count		;bump the count if screen is on
	jz	sion1				;time to turn it off?
	jmp	ts3				;nope
sion1:
	sti					;yup
	mov	ah,0fh
	int	10h				;get current video mode
	cli
	mov	cs:byte ptr video_mode,al	;and save it all
	mov	cs:byte ptr chars_pl,ah
	mov	cs:byte ptr video_page,bh
	cmp	al,4				;assure text mode only
	jc	sion2
	cmp	al,6				;hi res mono graphics ok too
	je	sion2
	cmp	al,7				;monochrome is ok too
	je	sion2
	jmp	ts2
sion2:
	call	get_cursor
	cmp	cs:byte ptr video_mode,7
	je	clear7
	mov	ax,0b800h
	mov	ds,ax
	mov	si,0				;  the
	mov	ax,cs
	mov	es,ax				;     old
	mov	di,offset old_screen
	mov	cx,screen_size/2		;       video
	cld
	rep movsw				;          screen
	mov	ax,0b800h
	mov	es,ax				;then
	mov	di,0
	mov	ax,0720h			;spaces for text
	cmp	cs:byte ptr video_mode,6
	jne	clear0
	mov	ax,0				;zeros for graphics
clear0:
	mov	cx,screen_size/2		;clear
	cld					;it out
	rep stosw
	jmp	clear_cur
clear7:
	mov	ax,0b000h
	mov	ds,ax
	mov	si,0
	mov	ax,cs
	mov	es,ax
	mov	di,offset old_screen
	mov	cx,screen_size/8
	cld
	rep movsw
	mov	ax,0b000h
	mov	es,ax
	mov	di,0
	mov	ax,0720h
	mov	cx,screen_size/8
	cld
	rep stosw
clear_cur:
	sti
	mov	ah,1
	mov	ch,20h				;make the cursor dissappear
	int	10h
	cli
	mov	cs:byte ptr scrn_on,0		;say the screen is off

screen_is_off:
	dec	cs:byte ptr scan_count
	jz	siof1
	jmp	ts2
siof1:
	mov	cs:byte ptr scan_count,18	;reset the timer to 1 second
	mov	ax,cs
	mov	bx,offset old_screen		;get our saved screen buffer
	mov	cl,4
	shr	bx,cl
	add	ax,bx				;make it cs:0
	mov	ds,ax
	mov	si,0
	mov	ax,0b800h			;get the regurlar screen seg.
	mov	cx,screen_size/2		;and how many words
	cmp	cs:byte ptr video_mode,7	;monochrome card?
	jne	siof2				;nope
	mov	ax,0b000h			;yup, so get its seg.
	mov	cx,screen_size/8		;and how many words
siof2:
	mov	es,ax				;video ram = es:0
	mov	di,0
	mov	ax,0720h			;what to check for when we scan
	cmp	cs:byte ptr video_mode,6	;hi res mono graphics mode?
	jne	siof3				;nope
	mov	ax,0				;yup, then check for zeros
siof3:
	cli
	cld
	mov	cs:byte ptr upd_scrn,0		;restore the screen flag
siof4:
	repz scasw				;start comparing
	jz	siof5				;if everything was equal
	sub	di,2				;back up to inequality
	mov	si,di				;same place in our buffer
	mov	bx,es:word ptr[di]		;get the word
	mov	ds:word ptr[si],bx		;update our buffer
	add	di,2				;put back
	mov	cs:byte ptr upd_scrn,0ffh	;flag to put back the screen
	jmp	short siof4			;check the rest of video
siof5:
	cmp	cs:byte ptr upd_scrn,0		;should we update memory
	je	ts2
	call	restore_screen
	call	restore_cur

ts2:
	mov	ax,cs:word ptr time
	mov	cs:word ptr count,ax		;no point in checking again
ts3:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	jmp	cs:dword ptr timervec



restore_screen:
	cmp	cs:byte ptr video_mode,7
	je	restore7
	mov	ax,0b800h			;restore
	mov	es,ax
	mov	di,0				;  the
	mov	ax,cs
	mov	ds,ax				;    old
	mov	si,offset old_screen
	mov	cx,screen_size/2		;      video
	cld
	rep movsw				;         ram
	jmp	short restore9
restore7:
	mov	ax,0b000h
	mov	es,ax
	mov	di,0
	mov	ax,cs
	mov	ds,ax
	mov	si,offset old_screen
	mov	cx,screen_size/8
	cld
	rep movsw
restore9:
	mov	cs:byte ptr scrn_on,0ffh
	ret



restore_cur:
	mov	ah,2
	mov	dh,cs:byte ptr cur_row		;restore
	mov	dl,cs:byte ptr cur_col		;  the
	sti
	mov	bh,cs:byte ptr video_page	;    cursor
	int	10h				;      position
	mov	ah,1
	mov	ch,cs:byte ptr cur_start	;and
	mov	cl,cs:byte ptr cur_end		;  it's
	int	10h				;     size
	cli
	ret



get_cursor:
	sti
	mov	ah,3
	mov	bh,cs:byte ptr video_page
	int	10h				;get cursor info
	cli
	mov	cs:byte ptr cur_start,ch
	mov	cs:byte ptr cur_end,cl
	mov	cs:byte ptr cur_row,dh
	mov	cs:byte ptr cur_col,dl		;and save it all
	ret



time		dw	0			;timeout value = 18*60*minutes
count		dw	0			;present count down value
signature	db	"SSCOM"
keyvec		dd	0
scrnvec		dd	0
timervec	dd	0
scrn_on		dw	0ffh			;screen on = 0ffh off = 0
video_mode	db	0
chars_pl	db	0
video_page	db	0
cur_start	db	0
cur_end		db	0
cur_row		db	0
cur_col		db	0
scan_count	db	18
upd_scrn	db	0

		db	(($-zero)/16*16)+16-($-zero) dup (0)
old_screen:
buff	struc
	db	16 * 1024 dup(?)	;where to save our screen ram
tsr	db	?
buff	ends
;
;TERMINATE AND STAY RESIDENT CODE ENDS HERE



setup:
	mov	dx,offset msg1
	mov	ah,9
	int	21h
	mov	bx,offset def_fcb+1
	mov	al,byte ptr[bx]
	cmp	al,'0'				;did he make an initial entry
	jnc	su1
	jmp	usage
su1:
	cmp	al,'6'+1
	jc	su2
	jmp	usage
su2:
	push	bx				;save the fcb pointer
	mov	ah,0
	sub	al,'0'				;make the digit binary
	mov	bx,10
	mul	bx
	pop	bx				;get back the pointer
	inc	bx				;point to next digit
	mov	ah,byte ptr[bx]
	cmp	ah,'0'
	jnc	su3
	jmp	usage
su3:
	cmp	ah,'9'+1
	jc	su4
usage:
	mov	dx,offset msg2
usage1:
	mov	ah,9
	int	21h
	int	20h
su4:
	sub	ah,'0'				;make it binary
	add	al,ah				;get total time in minutes
	mov	ah,0
	mov	bx,60*18			;second/min * ticks/seconds
	mul	bx
	mov	word ptr time,ax		;save his time out value
	mov	word ptr count,ax
	mov	word ptr scan_count,18		;scan memory every second
	
	mov	al,keyint
	mov	ah,35h				;get interrupt vector
	int	21h
	mov	di,bx
	sub	di,5				;point to the signature
	mov	si,offset signature
	mov	cx,5
	cld
	repz cmpsb
	jnz	su5
	mov	dx,offset msg4
	jmp	usage1
su5:
	mov	word ptr keyvec,bx		;save it
	mov	word ptr keyvec+2,es
	mov	dx,offset key_activity_sr
	mov	al,keyint
	mov	ah,25h				;set new interrupt vector
	int	21h

	mov	al,scrnint
	mov	ah,35h
	int	21h
	mov	word ptr scrnvec,bx
	mov	word ptr scrnvec+2,es
	mov	dx,offset scrn_activity_sr
	mov	al,scrnint
	mov	ah,25h
	int	21h

	mov	al,timerint			;and finally the timer
	mov	ah,35h
	int	21h
	mov	cs:word ptr timervec,bx
	mov	cs:word ptr timervec+2,es
	mov	dx,offset timer_sr
	mov	al,timerint
	mov	ah,25h
	int	21h

	mov	dx,offset msg3
	mov	ah,9
	int	21h
	
	lea	dx,old_screen.tsr
	int	27h


msg1	db	cr,lf,'ScreenSaver Version 1.0 $'
msg2	db	cr,lf,lf,'Usage:  SS xx'
	db	cr,lf,'Where xx = 01 to 60 minute timeout value.',cr,lf,'$'
msg3	db	'Installed',cr,lf,lf,'$'
msg4	db	bel,'Was Previously Installed',cr,lf,lf,'$'
	db	"Copyright (c) 1986 The Heath Users' Group"
	db	"Written By: Jim Buszkiewicz"
ssaver	ends
	end	start
