	PAGE	,132
	TITLE	ANTI-PARANOID
;	ANTI-PARANOID PROGRAM DEBUGGING AID
;	THIS PROGRAM ALLOWS YOU TO DEBUG PARANOID PROGRAMS
;	THAT WIPE OUT THE BREAKPOINT INTERRUPT
;
;	BY PATRICK SWAYNE, HUG SOFTWARE ENGINEER  04-APR-86

SSIINT	EQU	1*4			;SINGLE STEP INTERRUPT VECTOR
BKPINT	EQU	3*4			;BREAKPOINT INTERRUPT VECTOR

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	JMP	SETUP			;SET UP THIS PROGRAM

SSIVEC	DW	0,0			;SINGLE STEP INTERRUPT VECTOR
BKPVEC	DW	0,0			;BREAKPOINT INTERRUPT VECTOR
I8VEC	DW	0,0			;INTERRUPT 8 INTERRUPT VECTOR
I9VEC	DW	0,0			;   "      9     "        "
I10VEC	DW	0,0			;   "     10     "        "
I11VEC	DW	0,0			;   "     11     "        "
I12VEC	DW	0,0			;   "     12     "        "
I13VEC	DW	0,0			;   "     13     "        "
I14VEC	DW	0,0			;   "     14     "        "
I16VEC	DW	0,0			;   "     16     "        "
I17VEC	DW	0,0			;   "     17     "        "
I21VEC	DW	0,0			;   "     21     "        "
I42VEC	DW	0,0			;   "     42     "        "
I46VEC	DW	0,0			;   "     46     "        "

;	FIX SINGLE STEP AND BREAKPOINT INTERRUPT VECTORS DURING
;	VARIOUS INTERRUPTS

INT8:	CALL	FIXVEC			;FIX VECTORS
	JMP	CS:DWORD PTR I8VEC	;PROCESS THIS INTERRUPT
INT9:	CALL	FIXVEC
	JMP	CS:DWORD PTR I9VEC
INT10:	CALL	FIXVEC
	JMP	CS:DWORD PTR I10VEC
	DB	'PA'			;SIGNATURE
INT11:	CALL	FIXVEC
	JMP	CS:DWORD PTR I11VEC
INT12:	CALL	FIXVEC
	JMP	CS:DWORD PTR I12VEC
INT13:	CALL	FIXVEC
	JMP	CS:DWORD PTR I13VEC
INT14:	CALL	FIXVEC
	JMP	CS:DWORD PTR I14VEC
INT16:	CALL	FIXVEC
	JMP	CS:DWORD PTR I16VEC
INT17:	CALL	FIXVEC
	JMP	CS:DWORD PTR I17VEC
INT21:	CALL	FIXVEC
	JMP	CS:DWORD PTR I21VEC
INT42:	CALL	FIXVEC
	JMP	CS:DWORD PTR I42VEC
INT46:	CALL	FIXVEC
	JMP	CS:DWORD PTR I46VEC

;	FIX SINGLE STEP AND BREAKPOINT VECTORS

FIXVEC:	CMP	CS:SSIVEC+2,0		;HAVE THE ADDRESSES BEEN INSTALLED?
	JZ	FIXEX			;IF NOT, EXIT
	PUSHF				;ELSE, SAVE SOME REGISTERS
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	CS
	POP	DS			;PUT DS HERE
	XOR	SI,SI
	MOV	ES,SI			;PUT ES IN INTERRUPT SEGMENT
	MOV	SI,OFFSET SSIVEC	;POINT TO SINGLE STEP VECTOR
	MOV	DI,OFFSET SSIINT	;IT GOES HERE
	CLD
	MOVSW				;PUT IT IN
	MOVSW
	MOV	SI,OFFSET BKPVEC	;POINT TO BREAKPOINT VECTOR
	MOV	DI,OFFSET BKPINT	;IT GOES HERE
	MOVSW				;PUT IT IN
	MOVSW
	POP	ES			;RESTORE REGISTERS
	POP	DS
	POP	DI
	POP	SI
	POPF
FIXEX:	RET

ENDRES:					;END OF RESIDENT CODE

;	SET UP ALL VECTORS PROCESSED BY THIS PROGRAM

SETUP:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 11H*4		;POINT TO INT 11 VECTOR
	LES	DI,DWORD PTR [SI]	;GET VECTOR IN ES:DI
	CMP	WORD PTR ES:-2[DI],'AP'	;APNOID ALREADY IN?
	JNZ	NOTIN			;NO
	POP	DS
	MOV	DX,OFFSET ALMSG
	MOV	AH,9
	INT	21H			;SAY "APNOID ALREADY IN"
	INT	20H
NOTIN:	MOV	WORD PTR [SI],OFFSET INT11	;PUT IN MY VECTOR
	MOV	2[SI],CS		;AND THIS SEGMENT
	POP	DS			;RESTORE DS
	MOV	I11VEC,DI		;PUT OLD VECTOR AT OUR EXIT
	MOV	I11VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 8*4		;POINT TO INT 8
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	CLI
	MOV	WORD PTR [SI],OFFSET INT8	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I8VEC,DI		;PUT OLD VECTOR HERE
	MOV	I8VEC+2,ES
	STI
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 9*4		;POINT TO INT 9
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	CLI
	MOV	WORD PTR [SI],OFFSET INT9	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I9VEC,DI		;PUT OLD VECTOR HERE
	MOV	I9VEC+2,ES
	STI
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 10H*4		;POINT TO INT 10
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET INT10	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I10VEC,DI		;PUT OLD VECTOR HERE
	MOV	I10VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 12H*4		;POINT TO INT 12
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET INT12	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I12VEC,DI		;PUT OLD VECTOR HERE
	MOV	I12VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 13H*4		;POINT TO INT 13
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET INT13	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I13VEC,DI		;PUT OLD VECTOR HERE
	MOV	I13VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 14H*4		;POINT TO INT 14
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET INT14	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I14VEC,DI		;PUT OLD VECTOR HERE
	MOV	I14VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 16H*4		;POINT TO INT 16
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET INT16	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I16VEC,DI		;PUT OLD VECTOR HERE
	MOV	I16VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 17H*4		;POINT TO INT 17
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET INT17	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I17VEC,DI		;PUT OLD VECTOR HERE
	MOV	I17VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 21H*4		;POINT TO INT 21
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET INT21	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I21VEC,DI		;PUT OLD VECTOR HERE
	MOV	I21VEC+2,ES
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 42H*4		;POINT TO INT 42
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	CLI
	MOV	WORD PTR [SI],OFFSET INT42	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I42VEC,DI		;PUT OLD VECTOR HERE
	MOV	I42VEC+2,ES
	STI
	PUSH	DS
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET 46H*4		;POINT TO INT 46
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	CLI
	MOV	WORD PTR [SI],OFFSET INT46	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	I46VEC,DI		;PUT OLD VECTOR HERE
	MOV	I46VEC+2,ES
	STI
	MOV	DX,OFFSET INMSG
	MOV	AH,9
	INT	21H			;SAY "APNOID INSTALLED"
	MOV	DX,OFFSET ENDRES
	INT	27H			;INSTALL RESIDENT CODE

SIGNON	DB	13,10,'ANTI-PARANOID Debug Support Utility, V 1.0',13,10
	DB	'By Patrick Swayne, HUG Software Engineer',13,10
	DB	"Copyright (C) 1986 by Heath/Zenith Users' Group",13,10,10
	DB	'RUN APSET BEFORE DEBUGGING YOUR PROGRAM.',13,10,10,'$'
INMSG	DB	'APNOID is now installed.',13,10,'$'
ALMSG	DB	'APNOID is already installed.',13,10,'$'

CODE	ENDS
	END	START
