	PAGE	,132
;	DIR150 - Z-DOS DIRECTORY PROGRAM
;
;	THIS DIRECTORY PROGRAM MAKES USE OF SPECIAL FEATURES OF
;	THE H/Z19 TERMINAL GRAPHICS USED ON H/Z-100 COMPUTERS TO
;	PRODUCE AN EASY-TO-READ DIRECTORY LISTING.
;
;	BY P. SWAYNE, HUG  25-JAN-83
;
;	SHELL-METZNER SORT FROM HUG SORTER BY W. MOSS
;
;	Z-DOS VERSION BY P. SWAYNE  13-DEC-83
;	Z-150 MODS  17-MAY-84  02-JUN-84
;
;	THIS PROGRAM WAS BUILT UP FROM THE SDIR PROGRAM
;		by Keith Petersen, W8SDZ
;
;	PRINTS A 4-WIDE DIRECTORY, SORTED ALPHABETICALLY
;
;	A:DIR150 FILENAME.TYP
;
;	or just
;
;	A>DIR150
;
;	ALLOWS '*' OR '?' "WILD CARD" SPECIFICATIONS
;	DRIVE NAME BY ALSO BE SPECIFIED
;
;	YOU CAN ALSO SPECIFY THAT THE DIRECTORY NOT BE
;	ALPHABETIZED, BY ENTERING "N" AFTER THE FILE
;	NAME, DRIVE, ETC.  AND YOU CAN CAUSE HIDDEN (SYSTEM)
;	FILES TO SHOW BY ENTERING "S" THE SAME WAY.
;
;	A>DIR150 A: N		(DIRECTORY OF A:, NOT ALPHABETIZED)
;	A>DIR150 *.BAS N	(DIRECTORY OF ALL .BAS FILES, NOT ALPHA.)
;	A>DIR150 B: S		(DIRECTORY OF B:, INCLUDING HIDDEN FILES)
;	A>DIR150 A: SN		(DIRECTORY OF A:, NOT ALPHA, INCL. SYS. FILES)
;	A>DIR150 A: NS		(SAME AS ABOVE)
;
;	NEW SWITCHES FOR Z-DOS 2.0
;
;	A>DIR150 A: D		(DIRECTORY OF DIRECTORY BRANCHES)
;	A>DIR150 A: A		(SAME AS S, BUT SHOWS FLAG 20H)

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
H19	EQU	TRUE			;ASSEMBLE FOR HEATH EQUIPMENT
;					;OTHERWISE, ASSEMBLES FOR VT52
;
;	SYSTEM EQUATES
;
RDCHR	EQU	1			;READ CHAR FROM CONSOLE
DCIO	EQU	6			;DIRECT CONSOLE I/O
PRINT	EQU	9			;PRINT CONSOLE BUFF
SELECT	EQU	14			;SELECT DISK
FOPEN	EQU	15			;0FFH=NOT FOUND
SFF	EQU	17			;  "	"
SFN	EQU	18			;  "	"
FREAD	EQU	20			;0=OK, 1=EOF
GDISK	EQU	25			;GET CURRENT DISK
GALLOC	EQU	27			;GET ALLOCATION ADDRESS
VER	EQU	48			;GET Z-DOS VERSION
DFREE	EQU	54			;GET DRIVE FREE SPACE
FCB	EQU	5CH			;NORMAL FCB
XFCB	EQU	55H			;EXTENDED FCB

M	EQU	Byte Ptr 0[BX]		;DEFINE MEMORY REGISTER

DIR150	SEGMENT
	ASSUME CS:DIR150,SS:DIR150,DS:DIR150,ES:NOTHING
	ORG	100H

START:	CALL	TYPTX
	DB	27,'Z'+80H		;ASK TERMINAL TYPE
	MOV	CX,50			;SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			;TEST FOR REPLY
	OR	AL,AL
	JNZ	GOTCHR			;GOT REPLY
	LOOP	WFCHR			;ELSE, TRY AGAIN
GOTCHR:	MOV	AX,0C00H
	INT	21H			;FLUSH TYPE-AHEAD
	MOV	Byte Ptr CTYPE,CL	;SAVE COMPUTER TYPE (0 IF IBM)
	OR	CL,CL			;TEST
	JNZ	Z100			;Z-100
	CALL	IBMRST			;ELSE, RESET SCREEN
Z100:	CALL	TYPTX
	DB	27,'E'+80H		;CLEAR SCREEN
	MOV	BX,6DH			;GET FCB2 FIRST CHAR
CHKFLG:	MOV	AL,M
	CMP	AL,' '			;ANY SWITCHES
	JZ	GTDISK			;NO
	CMP	AL,'N'			;NO ALPHABETIZE?
	JNZ	CHKSYS			;NO, CHECK FOR "S" FLAG
	MOV	Byte Ptr NFLAG,1	;ELSE, SET NO SORT FLAG
	JMP	SHORT CHKNXT		;CHECK NEXT FLAG
CHKSYS:	CMP	AL,'S'			;SEE SYSTEM FILES?
	JNZ	CHKALL			;NO
	MOV	Word Ptr FCBADR,XFCB	;ELSE, USE EXTENDED FCB
	JMP	SHORT CHKNXT		;CHECK NEXT FLAG
CHKALL:	CMP	AL,'A'			;SHOW ALL FLAGS?
	JNZ	CHKDIR			;NO
	MOV	Word Ptr FCBADR,XFCB	;ELSE, USE EXTENDED FCB
	INC	Byte Ptr CHAFLG		;AND MARK CHECKING ALL
	JMP	SHORT CHKNXT
CHKDIR:	CMP	AL,'D'			;SHOW DIRECTORY FILES
	JNZ	GTDISK			;NO
	MOV	Word Ptr FCBADR,XFCB	;ELSE, SET EXTENDED FCB
	MOV	Byte Ptr FLAGS,10H	;AND LOOK ONLY FOR DIR NAMES
CHKNXT:	INC	BX			;INCREMENT POINTER
	JMP	SHORT CHKFLG		;AND CHECK FOR MORE FLAGS
GTDISK:	MOV	AH,GDISK
	INT	21H			;GET CURRENT DISK
	MOV	Byte Ptr CURDSK,AL	;SAVE CURRENT DISK
	MOV	BX,FCB			;GET FCB ADDRESS
	MOV	AL,M			;GET DISK WE'RE USING
	DEC	AL			;MAKE IT 0-N
	JNS	SEL			;NOT USING DEFAULT DISK
	MOV	AL,Byte Ptr CURDSK	;ELSE, GET IT
SEL:	MOV	DL,AL			;IN E
	INC	AL			;MAKE IT 1-N
	MOV	Byte Ptr LFCBDR,AL	;PUT IT IN LABEL FCB
	MOV	Byte Ptr DLFCBDR,AL	;AND IN DISK LABEL FCB, ALSO
	MOV	AH,VER
	INT	21H			;CHECK VERSION
	CMP	AL,2			;2.0?
	JB	OLDLAB			;NO, CHECK OLD LABEL ONLY
	MOV	DX,(Offset DLFCB)
	MOV	AH,SFF
	INT	21H			;SEARCH FOR LABEL
	INC	AL			;GOT ONE?
	MOV	Byte Ptr LABFLG,AL	;MARK RESULT
	JNZ	GOTLAB			;YES, GOT LABEL
OLDLAB:	MOV	DX,(Offset LFCB)
	MOV	AH,FOPEN
	INT	21H			;TRY TO OPEN LABEL FILE
	INC	AL
	JZ	NOLAB
	MOV	AH,FREAD
	MOV	DX,(Offset LFCB)
	INT	21H			;READ LABEL FILE
	OR	AL,AL
	JNZ	NOLAB			;BAD LABEL FILE
GOTLAB:	CALL	TYPTX
	DB	'Disk',' '+80H
	MOV	AL,Byte Ptr LFCBDR	;GET DRIVE CODE
	ADD	AL,40H			;MAKE IT ASCII
	CALL	TYPEC			;PRINT IT
	MOV	AL,':'
	CALL	TYPEC			;PUT ":" AFTER DRIVE
	CMP	Byte Ptr LABFLG,0	;DOS 2.0 LABEL?
	JNZ	GOTLAB1			;YES
	CALL	TYPTX
	DB	' ','#'+80H		;PUT # BEFORE NUMBER
	MOV	DX,82H
	CALL	WRCON			;PRINT VOL. NO.
GOTLAB1:CALL	TYPTX
	DB	' Label:',' '+80H
	CMP	Byte Ptr LABFLG,0
	JNZ	GOTLAB2
	MOV	DX,83H
FLAB:	MOV	SI,DX
	MOV	AL,[SI]
	CMP	AL,'"'			;FIND LABEL
	PUSHF
	INC	DX
	POPF
	JNZ	FLAB
	CALL	WRCON			;PRINT LABEL
	JMP	SHORT SIZEX
NOLAB:	CALL	TYPTX
	DB	'Directory of disk',' '+80H
	MOV	AL,Byte Ptr LFCBDR
	ADD	AL,40H
	CALL	TYPEC
	CALL	TYPTX
	DB	':'+80H
	JMP	SHORT SIZEX
GOTLAB2:MOV	SI,88H			;POINT TO LABEL
	MOV	CX,11			;CHAR COUNT
PRTLAB:	LODSB				;GET A CHARACTER
	PUSH	SI
	CALL	TYPEC			;PRINT IT
	POP	SI
	LOOP	PRTLAB			;LOOP UNTIL DONE

SIZEX:	MOV	DL,Byte Ptr LFCBDR	;GET DRIVE
	DEC	DL			;MAKE IT 0-N
	MOV	AH,SELECT
	INT	21H			;SELECT DISK
	CALL	BORDER
	PUSH	DS
	MOV	AH,GALLOC
	INT	21H			;GET ALLOCATION TABLE ADDRESS
	MOV	AH,0
	PUSH	DX			;SAVE NO. OF BLOCKS
	XCHG	CX,DX			;PUT BLOCKS IN CX, BYTES IN DX
	MUL	DX			;COMPUTE MIN. BLOCK SIZE
	PUSH	AX			;SAVE RESULT
	XOR	AX,AX			;CLEAR FREE COUNTER
	MOV	SI,2			;START WITH FAT ENTRY 2
SLOOP:	MOV	DI,SI			;PUT ENTRY NO. IN DI
	SHR	DI,1			;DIVIDE BY 2
	ADD	DI,SI			;CALCULATE FAT OFFSET
	MOV	DI,[BX+DI]		;GET ENTRY
	TEST	SI,1			;ODD ENTRY NO.?
	JZ	SIZE1			;NO, EVEN
	SHR	DI,1			;ELSE, MOVE DOWN 4 BITS
	SHR	DI,1
	SHR	DI,1
	SHR	DI,1
SIZE1:	AND	DI,0FFFH		;ISOLATE 12 BITS
	JNZ	SIZE2			;NOT AN EMPTY ENTRY
	INC	AX			;COUNT EMPTY ENTRY
SIZE2:	INC	SI			;DO NEXT FAT ENTRY
	LOOP	SLOOP			;UNTIL DONE
	POP	CX			;GET BLOCK SIZE
	POP	DX			;AND NO. OF BLOCKS
	POP	DS
	MOV	Word Ptr BSIZE,CX	;SAVE BLOCK SIZE
	PUSH	AX			;SAVE FREE SPACE
	PUSH	DX			;SAVE ALLOCATED USE
	MOV	AH,VER
	INT	21H			;GET VERSION NO.
	CMP	AL,2			;2 OR MORE?
	POP	DX
	POP	AX
	JB	OLDVER			;OLD VERSION
	MOV	AH,DFREE
	XOR	DL,DL
	INT	21H			;ELSE, GET FREE SPACE FROM SYSTEM
	MOV	AX,BX			;IN AX
OLDVER:	MOV	Word Ptr FREE,AX	;AND FREE BLOCK COUNT
	SUB	DX,AX			;COMPUTE ALLOCATED USE
	MOV	Word Ptr ALLOC,DX	;AND SAVE IT

START1:	MOV	BX,FCB+1
	MOV	AL,M
	CMP	AL,' '
	JNZ	GOTFCB

;NO FCB - MAKE FCB ALL '?'

	MOV	CX,11			;FN+FT COUNT
QLOOP:	MOV	M,'?'			;STORE '?' IN FCB
	INC	BX
	LOOP	QLOOP

GOTFCB:	MOV	BX,XFCB
	MOV	M,0FFH			;SET UP EXTENDED FCB
	MOV	CX,5
	INC	BX
XLOOP:	MOV	M,0
	INC	BX
	LOOP	XLOOP
	MOV	AL,Byte Ptr FLAGS
	MOV	M,AL			;SET FILE ATTRIBUTES

;LOOK UP THE FCB IN THE DIRECTORY

	MOV	AH,SFF			;GET 'SEARCH FIRST' FNC
	MOV	DX,Word Ptr FCBADR	;GET FCB ADDRESS
	INT	21H			;READ FIRST
	INC	AL			;WERE THERE ANY?
	JNZ	SOME			;GOT SOME
	JMP	BOTTOM
;
;READ MORE DIRECTORY ENTRIES

MOREDIR: MOV	AH,SFN			;SEARCH NEXT
	MOV	DX,Word Ptr FCBADR
	INT	21H			;READ DIR ENTRY
	INC	AL			;CHECK FOR END (0FFH)
	JNZ	SOME	
	JMP	SPRINT			;NO MORE - SORT & PRINT

;POINT TO DIRECTORY ENTRY 

SOME:	MOV	BX,80H			;POINT TO FILE NAME
	MOV	AL,M			;GET FIRST BYTE
	INC	BX			;MOVE TO NAME
	CMP	AL,0FFH			;TEST FOR EXTENDED FORMAT
	JNZ	NOTEXT			;NOT EXTENDED
	ADD	BX,7			;ELSE, ADD 7
	MOV	AL,11[BX]		;GET ATTRIBUTE BITS
	CMP	AL,10H			;DIRECTORY NAME?
	JNZ	NOTDIR			;NO
	MOV	Word Ptr 8[BX],'D<'	;ELSE, INSERT "<D>" FOR TYPE
	MOV	Byte Ptr 10[BX],'>'
	JMP	SHORT MRKFLG		;MARK FLAG
NOTDIR:	CMP	Byte Ptr FLAGS,10H	;CHECKING ONLY DIRECTORIES?
	JZ	MOREDIR			;IF SO, SKIP THIS ENTRY
MRKFLG:	CMP	Byte Ptr FLAGS,10H	;ONLY DIRECTORIES?
	JZ	NOTEXT			;YES, NO FLAGS
	CMP	AL,20H			;NORMAL FLAG?
	JNZ	NOT20H			;NO
	CMP	Byte Ptr CHAFLG,0	;DISPLAYING ALL?
	JZ	NOTEXT			;NO, SKIP THIS ENTRY
NOT20H:	PUSH	BX			;SAVE POINTER
ATLP:	SHR	AL,1			;TEST FOR AN ATTRIBUTE BIT
	JNC	NOAT			;NONE IN THIS PLACE
	OR	M,80H			;ELSE, MARK IT
NOAT:	INC	BX			;INCREMENT POINTER
	OR	AL,AL			;DONE WITH BITS?
	JNZ	ATLP			;IF NOT, LOOP
	POP	BX			;ELSE, RESTORE POINTER
NOTEXT:	MOV	AX,28[BX]		;GET FILE SIZE
	MOV	11[BX],AX		;PUT IT HERE
	MOV	AX,30[BX]		;MOVE HIGH WORD, TOO
	AND	AX,3FFFH		;MASK FILE SIZE TO 30 BITS
	MOV	13[BX],AX

;MOVE ENTRY TO TABLE

MOVEN:	MOV	AX,CS
	MOV	ES,AX			;PUT ES HERE
	MOV	SI,BX			;PUT ENTRY ADDR IN SI
	MOV	DI,Word Ptr NEXTT	;PUT NEXT TABLE ENTRY IN DI
	MOV	CX,15			;MOVE 15 CHARACTERS
	REP	MOVSB			;MOVE THE ENTRY
	MOV	Word Ptr NEXTT,DI	;UPDATE TABLE ADDRESS
	INC	Word Ptr COUNT		;INCREMENT COUNT
	JMP	MOREDIR
;
;SORT AND PRINT

SPRINT:	CMP	Word Ptr COUNT,0	;ANY FILES?
	JNZ	SPRINT1			;YES
	JMP	BOTTOM			;ELSE, DONE
SPRINT1:CMP	Byte Ptr NFLAG,0	;NO ALPHABETIZING WANTED?
	JZ	DOSORT			;NO, DO SORT
	JMP	DONE			;ELSE, DONE
DOSORT:	MOV	BX,(Offset ORDER)	;INITIALIZE POINTERS
	MOV	DX,(Offset TABLE)
	MOV	CX,15			;ENTRY LENGTH

;BUILD ORDER TABLE

BLDORD:	MOV	AX,Word Ptr COUNT	;GET COUNT OF FILES
BLDORD1:MOV	Word Ptr [BX],DX	;SAVE ORD ADDR
	INC	BX
	INC	BX
	ADD	DX,CX			;POINT TO NEXT ENTRY
	DEC	AX			;MORE?
	JNZ	BLDORD1			;..YES
	MOV	Word Ptr NEXTT,Offset ORDER	;SET TABLE POINTER
	MOV	AX,Word Ptr COUNT	;GET COUNT
	MOV	Word Ptr SCOUNT,AX	;SAVE AS # TO SORT
	DEC	AX			;ONLY 1 ENTRY?
	JNZ	SORT			;NO, DO SORT
	JMP	DONE			;ELSE, DONE

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'SCOUNT' = NUMBER OF STRINGS TO BE SORTED
;		('NEXTT') = START OF POINTER TABLE
;		   POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.
;		'SCOUNT' = NUMBER OF STRINGS SORTED. (UNCHANGED)
;		'VARM' = 0.

SORT:	MOV	BX,Word Ptr SCOUNT
	MOV	Word Ptr VARM,BX
SETM:	MOV	BX,Word Ptr VARM
	SHR	BX,1
	MOV	Word Ptr VARM,BX	;VARM = VARM / 2 
	CMP	BX,0
	JNZ	NOTEND	
	JMP	DONE			;IF END OF SORT
NOTEND:	MOV	BX,1
	MOV	Word Ptr VARJ,BX	;VARJ = 1
	MOV	BX,Word Ptr SCOUNT
	MOV	DX,Word Ptr VARM
	SUB	BX,DX
	MOV	Word Ptr VARK,BX	;VARK = SCOUNT - VARM
SETI:	MOV	BX,Word Ptr VARJ
	MOV	Word Ptr VARI,BX	;VARI = VARJ
SETL:	MOV	BX,Word Ptr VARI
	MOV	DX,Word Ptr VARM
	ADD	BX,DX
	MOV	Word Ptr VARL,BX	;VARL = VARI + VARM
	CALL	SYMVAL			;BX = START OF DATA POINTED BY VARL
	PUSH	BX
	MOV	BX,Word Ptr VARI
	CALL	SYMVAL
	POP	SI
	MOV	CL,15			;*GET STRING LENGHT
	DEC	BX			;*PRE-DECREMENT POINTERS
	DEC	SI			;*
SCOMP:	INC	BX
	INC	SI			;BX & SI POINT TO START OF LABEL STRINGS
	MOV	AL,[SI]
	AND	AL,7FH			;STRIP ATT. BIT
	MOV	AH,M
	AND	AH,7FH
	CMP	AL,AH			;COMPARE STRINGS
	JNZ	NOMACH			;IF NO MATCH
	DEC	CL
	JNZ	SCOMP
NOMACH:	JNB	SETJ			;IF NO REARRANGEMENT REQUIRED

; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	MOV	BX,Word Ptr VARI
	CALL	TABADD
	PUSH	BX			;STACK = POINTER DATA FOR (VARI)
	MOV	BX,Word Ptr VARL
	CALL	TABADD			;BX = POINTER DATA FOR (VARL)
	POP	SI
	MOV	AX,[SI]
	MOV	DX,[BX]
	MOV	[SI],DX
	MOV	[BX],AX

; SWITCH COMPLETED

	MOV	BX,Word Ptr VARI
	MOV	DX,Word Ptr VARM
	SUB	BX,DX
	MOV	Word Ptr VARI,BX	;VARI = VARI - VARM
	DEC	BX
	JS	SETJ	
	JMP	SETL			;IF VARI >= 1
SETJ:	MOV	BX,Word Ptr VARJ
	INC	BX
	MOV	Word Ptr VARJ,BX	;VARJ = VARJ + 1
	MOV	DX,Word Ptr VARK
	SUB	DX,BX
	JNB	SETJ0	
	JMP	SETM			;IF VARJ > VARK
SETJ0:	JMP	SETI

; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: BX = INTEGER VALUE ( 1 -> N )
;	EXIT:  BX = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DEC	BX			;START AT ZERO
	SHL	BX,1			;BX = [(ORIGINAL BX) - 1] * 2
	MOV	DX,Word Ptr NEXTT
	ADD	BX,DX
	RET

; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: BX = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  BX = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	BX,[BX]
	RET

;SORT IS ALL DONE - PRINT ENTRIES

DONE:	MOV	CL,20			;SET A COUNTER
	CMP	Byte Ptr NFLAG,0	;DIRECTORY SORTED?
	JZ	ENTRY			;YES
	MOV	BX,(Offset TABLE)-15
	MOV	Word Ptr NEXTT,BX	;ELSE, PUT TABLE IN NEXTT
;
;PRINT AN ENTRY

ENTRY:	CMP	Byte Ptr NFLAG,0	;DIRECTORY SORTED?
	JZ	ENTRY1			;YES
	MOV	BX,Word Ptr NEXTT	;ELSE, GET ENTRY ADDRESS
	ADD	BX,15			;ADD 15
	MOV	Word Ptr NEXTT,BX	;UPDATE POINTER
	XCHG	BX,DX			;DX = ADDRESS
	JMP	SHORT ENTRY2
ENTRY1:	MOV	BX,Word Ptr NEXTT	;GET ORDER TABLE POINTER
	MOV	DX,Word Ptr [BX]	;GET ADDRESS
	INC	BX
	INC	BX
	MOV	Word Ptr NEXTT,BX	;SAVE UPDATED TABLE POINTER
ENTRY2:	MOV	BX,Word Ptr COLADR	;GET COLUMN MOVER STRING
	CALL	TYPTX1			;PRINT IT
	XCHG	BX,DX			;TABLE ENTRY TO BX
	PUSH	BX			;SAVE ENTRY ADDRESS
	MOV	CH,8			;FILE NAME LENGTH
	CALL	TYPEIT			;TYPE FILENAME
	CALL	PERIOD			;PERIOD AFTER FN
	MOV	CH,3			;GET THE FILETYPE
	CALL	TYPEIT
	MOV	AX,[BX]			;GET FILE SIZE LOW
	ADD	Word Ptr USED,AX	;UPDATE USED SPACE
	PUSH	AX			;SAVE SIZE LOW
	MOV	AX,2[BX]
	ADC	Word Ptr USEDH,AX
	POP	BX			;GET SIZE LOW IN BX
	MOV	DX,(Offset SPACES)	;POINT TO SPACES
	CMP	AX,0			;HUGE FILE?
	JZ	SMFILE			;NO
	ADD	DX,4			;ELSE, ELIMINATE SOME SPACES
	JMP	SHORT PSIZE		;AND PRINT SIZE
SMFILE:	CMP	BX,10			;LESS THAN 10 BYTES?
	JB	PSIZE			;YES, PRINT SIZE
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,100			;LESS THAN 100 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,1000			;LESS THAN 1000 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,10000		;LESS THAN 10000 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
PSIZE:	XCHG	BX,DX			;BX = SPACES
	PUSH	AX			;SAVE SIZE HIGH
	CALL	TYPTX1			;PRINT SPACES
	POP	AX
	XCHG	BX,DX
	PUSH	CX
	CALL	DDECOUT			;PRINT FILE SIZE
	POP	CX
	CALL	CR			;PRINT CRLF

;SEE IF MORE ENTRIES

	INC	Word Ptr PCOUNT		;INCREMENT PRINT COUNT
	DEC	Word Ptr COUNT		;DECREMENT COUNT
	JNZ	SMORE	
	JMP	BOTTOM			;NO MORE FILES TO PRINT
SMORE:	MOV	AL,Byte Ptr COUNTP	;GET PRINT COUNT
	INC	AL			;INCREMENT IT
	MOV	Byte Ptr COUNTP,AL
	CMP	AL,80			;80 FILES PRINTED?
	JNZ	PMORE			;NO, PRINT MORE
	CALL	TYPTX
	DB	27,'Y73Press RETURN to see more files..','.'+80H
WAICR:	MOV	AH,RDCHR
	INT	21H
	CMP	AL,4			;ABORT?
	JNZ	WAICR1	
	JMP	BOTTOM			;YES, QUIT EARLY
WAICR1:	CMP	AL,0DH
	JNZ	WAICR			;WAIT FOR CR
	XOR	AL,AL
	MOV	Byte Ptr COUNTP,AL	;CLEAR PRINT COUNTER
	MOV	Byte Ptr COLNO,AL	;AND COLUMN NO.
	CALL	BORDER			;ERASE SCREEN, PRINT NEW BORDER
	MOV	BX,(Offset COL1)
	MOV	Word Ptr COLADR,BX	;UPDATE COLUMN ADDRESS
	MOV	CL,20			;SET COUNTER
	JMP	ENTRY			;PRINT MORE FILES
PMORE:	DEC	CL			;DECREMENT COLUMN COUNTER
	JZ	PMORE1	
	JMP	ENTRY			;MORE TO PRINT
PMORE1:	CALL	TYPTX
	DB	27,'Y"',' '+80H		;RETURN TO PAGE TOP
	MOV	CL,20			;SET COUNTER
	MOV	AL,Byte Ptr COLNO	;ELSE GET COLUMN NUMBER
	INC	AL			;INCREMENT IT
	MOV	Byte Ptr COLNO,AL
	MOV	BX,(Offset COL2)	;ASSUME COLUMN 2
	DEC	AL			;TEST FOR IT
	JZ	SETCOL			;YES
	MOV	BX,(Offset COL3)	;ASSUME COLUMN 3
	DEC	AL
	JZ	SETCOL
	MOV	BX,(Offset COL4)	;ELSE, IT'S COLUMN 4
SETCOL:	MOV	Word Ptr COLADR,BX
	JMP	ENTRY			;PRINT MORE
;
PERIOD:	MOV	AL,'.'
;
;TYPE CHAR IN A

TYPEC:	PUSH	CX
	PUSH	DX
	PUSH	BX
	PUSHF
	PUSH	AX
	CMP	BYTE PTR CTYPE,0	;TEST COMPUTER TYPE
	JNZ	TYPEC1			;Z100
	CALL	IBMOUT			;ELSE, CALL IBM OUTPUT
	JMP	TYPEC2
TYPEC1:	MOV	DL,AL
	MOV	AH,DCIO
	INT	21H
TYPEC2:	POP	AX
	POPF
	POP	BX
	POP	DX
	POP	CX
	RET
;
WRCON:	MOV	SI,DX
	MOV	AL,[SI]
	CMP	AL,'$'
	JNZ	WRCON1
	RET
WRCON1:	CALL	TYPEC
	INC	DX
	JMP SHORT WRCON
	RET
;
TYPEIT:	MOV	AL,M
	OR	AL,AL			;TEST FOR HI BIT
	JNS	TYPEIT1			;NONE THERE
	PUSH	AX			;SAVE CHARACTER
	CALL	TYPTX
	DB	27,'p'+80H
	POP	AX
	AND	AL,7FH			;STRIP PARITY BIT
	CALL	TYPEC
	CALL	TYPTX
	DB	27,'q'+80H
	INC	BX
	DEC	CH
	JNZ	TYPEIT
	RET
TYPEIT1: CALL	TYPEC
	INC	BX
	DEC	CH
	JNZ	TYPEIT
	RET
;
CR:	MOV	AL,0DH
	CALL	TYPEC
	MOV	AL,0AH
	CALL	TYPEC
	RET

;BOTTOM - PRINT DISK SPACE DATA

BOTTOM:	CALL	TYPTX
	DB	27,'Y7','3'+80H
	MOV	Byte Ptr COMFLG,1	;TELL DDECOUT TO USE COMMAS
	MOV	BX,Word Ptr PCOUNT	;GET FILE COUNT
	MOV	AX,0
	CALL	DDECOUT			;PRINT COUNT
	CALL	TYPTX
	DB	' Files. ',' '+80H
	MOV	BX,Word Ptr USED	;GET USED SPACE
	MOV	AX,Word Ptr USEDH
	CALL	DDECOUT			;PRINT IT
	CALL	TYPTX
	DB	' ','('+80H
	MOV	AX,Word Ptr ALLOC	;GET ALLOCATED SPACE
	MOV	CX,Word Ptr BSIZE	;AND BLOCK SIZE
	MUL	CX			;COMPUTE ALLOCATED BYTES
	MOV	BX,AX			;LOW TO BX
	MOV	AX,DX			;HIGH TO AX
	CALL	DDECOUT			;PRINT ALLOCATED SPACE
	CALL	TYPTX
	DB	') Used. ',' '+80H
	MOV	AX,Word Ptr FREE	;GET FREE SPACE
	MOV	CX,Word Ptr BSIZE	;AND BLOCK SIZE
	MUL	CX			;COMPUTE FREE BYTES
	MOV	BX,AX			;LOW WORD TO BX
	MOV	AX,DX			;HIGH WORD TO AX
	CALL	DDECOUT			;PRINT FREE SPACE
	CALL	TYPTX
	DB	' Free.',27,'Y6',' '+80H
;
;EXIT - ALL DONE 

EXIT:	MOV	AL,Byte Ptr CURDSK	;GET CURRENT DISK
	MOV	DL,AL
	MOV	AH,SELECT
	INT	21H			;SET DEFAULT DISK
	MOV	DL,0
	MOV	AH,0
	INT	21H			;RETURN TO Z-DOS

;	DDECOUT - PRINT 32 BIT NO. IN AX,BX IN DECIMAL
;	AX = HIGH WORD, BX = LOW WORD

DDECOUT: MOV	SI,0			;CLEAR ZERO SUPPRESS FLAG
	MOV	CX,3B9AH
	MOV	DX,0CA00H		;CX,DX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	CALL	COMMA			;PRINT A COMMA (IF NO. PRINTED)
	MOV	CX,5F5H
	MOV	DX,0E100H		;CX,DX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	DX,9680H		;CX,DX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	DX,4240H		;CX,DX = 1,000,000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,1
	MOV	DX,86A0H		;CX,DX = 100,000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10000		;CX,DX = 10000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,1000			;CX,DX = 1000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,0
	MOV	DX,100			;CX,DX = 100
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10			;CX,DX = 10
	CALL	DIVPR
	MOV	AL,BL			;GET ONES DIGIT
	ADD	AL,'0'			;ADD ASCII
	JMP	TYPEC			;PRINT IT AND RETURN
DIVPR:	MOV	DI,-1			;SET A COUNTER
DIVPR1:	INC	DI			;INCREMENT COUNTER
	SUB	BX,DX			;SUBTRACT DIVISOR
	SBB	AX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	BX,DX			;ADD DIVISOR BACK IN ONCE
	ADC	AX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,DI			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	CMP	SI,0			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	INC	SI			;ELSE, FLAG ZEROS PASSED
DIVPR2:	CALL	TYPEC			;PRINT NO.
DIVPR3:	POP	AX			;RESTORE AX
	RET
COMMA:	CMP	SI,0			;ANY NUMBERS PRINTED?
	JZ	COMMA1			;NO
	CMP	Byte Ptr COMFLG,0	;COMMAS WANTED?
	JZ	COMMA1			;NO
	PUSH	AX
	MOV	AL,','			;ELSE, PRINT COMMA
	CALL	TYPEC
	POP	AX
COMMA1:	RET

;	TYPTX - TYPE TEXT FOLLOWING CALL

TYPTX:	MOV	BP,SP			;GET ADDRESS OF TEXT
	XCHG	BX,[BP]
	CALL	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPTX1:	MOV	AL,M
	AND	AL,7FH
	CALL	TYPEC
	CMP	AL,M
	PUSHF
	INC	BX
	POPF
	JZ	TYPTX1
	RET

;	BORDER - PRINT A GRAPHIC CHARACTER BORDER FOR FILES

BORDER:	CALL	TYPTX
	IF	H19
	DB	27,'Y! ',27,'J',27,'F'+80H
	ENDIF
	IF	NOT H19
	DB	27,'Y! ',27,'J'+80H
	ENDIF
	MOV	CH,4
BORD1:	CALL	TYPTX
	IF	H19
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	ENDIF
	IF	NOT H19
	DB	'------------------','-'+80H
	ENDIF
	DEC	CH
	JZ	BORD2
	IF	H19
	MOV	AL,'s'
	ENDIF
	IF	NOT H19
	MOV	AL,'-'
	ENDIF
	CALL	TYPEC
	JMP	BORD1
BORD2:	MOV	CH,20
BORD3:	CALL	CR
	CALL	TYPTX
	IF	H19
	DB	9,9,'   `',9,9,'       `',9,9,'   ','`'+80H
	ENDIF
	IF	NOT H19
	DB	9,9,'   |',9,9,'       |',9,9,'   ','|'+80H
	ENDIF
	DEC	CH
	JNZ	BORD3
	CALL	CR
	MOV	CH,4
BORD4:	CALL	TYPTX
	IF	H19
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	ENDIF
	IF	NOT H19
	DB	'------------------','-'+80H
	ENDIF
	DEC	CH
	JZ	BORD5
	IF	H19
	MOV	AL,'u'
	ENDIF
	IF	NOT H19
	MOV	AL,'-'
	ENDIF
	CALL	TYPEC
	JMP	BORD4
BORD5:	CALL	TYPTX
	IF	H19
	DB	27,'G',27,'Y"',' '+80H
	ENDIF
	IF	NOT H19
	DB	27,'Y"',' '+80H
	ENDIF
	RET

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:AND	AL,7FH
	CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT
SCREEN_OUT:
	MOV	AH,9
	MOV	BL,ATTR
	MOV	BH,0			;WRITE CHR W/ ATTRIBUTE
	MOV	CX,1
	INT	10H
	JMP	DORT			;MOVE CURSOR OVER
WRT_TTY:MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,ATTR 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	RET				; YES - IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	BYTE PTR ATTR,7		;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,15
	INT	10H			;READ DISPLAY TYPE
	CMP	AL,2			;80 COLUMN MODE?
	JNB	IBMRS1			;YES
	INC	AL			;ELSE, CONVERT TO 80 COLUMNS
	INC	AL
	XOR	AH,AH
	INT	10H
IBMRS1:	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,ATTR			;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	DOHOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR POSITION CALL
	RET
;
DOUP:	MOV	AH,3			;CURSOR UP
	MOV	BH,0
	INT	10H			;GET CURRENT POS
DOUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP SHORT SETCURS
;
DODWN:	MOV	AH,3			;CURSOR DOWN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
DODWN1:	INC	DH
	CMP	DH,23
	JBE	SETCURS
	MOV	AL,10			;LET TTY I/O DO SCROLL
	JMP	WRT_TTY
;
TAB:	MOV	AH,3			;PROCESS TABS
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	ADD	DL,8
	AND	DL,0F8H			;MOV TO NEXT TAB STOP
	JMP SHORT DORT1
;
DORT:	MOV	AH,3			;CURSOR RIGHT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	INC	DL
DORT1:	CMP	DL,79
	JBE	SETCURS
	MOV	DL,0 
	JMP SHORT DODWN1
;
DOHOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,ATTR
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP SHORT DOHOME
;
ERSEOS:	MOV	AH,3			;ERASE TO END OF SCREEN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTR			;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,ATTR
	INT	10H
ERS_RET:RET
;
DOREV:	MOV	BYTE PTR ATTR,70H 	;REV. VIDEO
	RET
;
DONRM:	MOV	BYTE PTR ATTR,7		;NOR. VIDEO
	RET

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
GRAFLG	DB	0			;GRAPHICS MODE FLAG
ATTR	DB	2  			;DEFAULT ATTRIBUTE (GREEN ON BLACK)
SAV_ROW	DB	0			;SAVED ROW POSITION
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'A'
	DW	OFFSET DOUP
	DB	'B'
	DW	OFFSET DODWN
	DB	'C'
	DW	OFFSET DORT
	DB	'H'
	DW	OFFSET DOHOME
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH	LABEL	BYTE
	db	0f9h	; ^
	db	0dbh	; _
	db	0b3h	; `
	db	0c4h	; a
	db	0c5h	; b
	db	0bfh	; c
	db	0d9h	; d
	db	0c0h	; e
	db	0dah	; f
	db	0f1h	; g
	db	01ah	; h
	db	0b0h	; i
	db	0f6h	; j
	db	019h	; k
	db	0dah	; l
	db	0bfh	; m
	db	0d9h	; n
	db	0c0h	; o
	db	0dfh	; p
	db	0deh	; q
	db	0dbh	; r
	db	0c2h	; s
	db	0b4h	; t
	db	0c1h	; u
	db	0c3h	; v
	db	058h	; w
	db	02fh	; x
	db	05ch	; y
	db	0dfh	; z
	db	0dch	; {
	db	0ddh	; |
	db	0deh	; }
	db	014h	; ~
	db	0dbh	; del

;	DATA AREA
;
CTYPE	DB	1			;TYPE PRESET TO Z-100
CURDSK	DB	0			;CURRENT DISK
NFLAG	DB	0			;NO ALPHABETIZE FLAG
FCBADR	DW	(Offset FCB)		;DEFAULT FCB ADDRESS
NEXTT	DW	(Offset TABLE)		;NEXT TABLE ENTRY
COUNT	DW	0			;ENTRY COUNT
PCOUNT	DW	0			;COUNT TO PRINT
SCOUNT	DW	0			;# TO SORT
VARI	DW	0			;SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
USED	DW	0			;USED SPACE
USEDH	DW	0			;USED SPACE (HIGH WORD)
FREE	DW	0			;FREE SPACE
ALLOC	DW	0			;ALLOCATED SPACE
BSIZE	DW	0			;BLOCK SIZE
COMFLG	DB	0			;COMMA FLAG
COUNTP	DB	0			;PRINT COUNTER
LABFLG	DB	0			;DISK LABEL FLAG
FLAGS	DB	0FFH			;ATTRIBUTES FOR S SWITCH
CHAFLG	DB	0			;CHECK ALL FLAG
SPACES	DB	'    ',' '+80H
COLNO	DB	0			;COLUMN NUMBER
COLADR	DW	(Offset COL1)		;COLUMN MOVER ADDRESS
COL1	DB	80H
COL2	DB	9,9,27,'C',27,'C',27,'C',27,'C'+80H
COL3	DB	9,9,9,9,9+80H
COL4	DB	9,9,9,9,9,9,9,27,'C',27,'C',27,'C',27,'C'+80H
LFCB	DB	0FFH,0,0,0,0,0,2	;FCB EXTENSION
LFCBDR	DB	0,'IDENT   SYS',0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
TEMP	DW	0			;TEMP. STORAGE FOR SORT
DLFCB	DB	0FFH,0,0,0,0,0,8	;DISK LABEL FCB
DLFCBDR	DB	0,'???????????',0,0,0,0
ORDER	EQU	OFFSET $		;ORDER TABLE (ROOM FOR 1024 NAMES)
TABLE	EQU	(Offset $)+2048		;READ ENTRIES IN HERE
;
DIR150	ENDS
	END	START
