	TITLE	PDIR - PRINTING DIRECTORY PROGRAM
	PAGE	,132
;	PDIR - Z-DOS DIRECTORY PRINTING PROGRAM
;
;	THIS DIRECTORY PROGRAM MAKES USE OF SPECIAL FEATURES OF
;	THE H/Z25 PRINTER TO PRODUCE AN EASY-TO-READ DIRECTORY
;	LISTING.  IT MAY ALSO BE ASSEMBLED FOR USE WITH OTHER
;	PRINTERS.
;
;	BY P. SWAYNE, HUG  27-JAN-83
;	Z-DOS VERSION  22-FEB-84
;
;	THIS PROGRAM WAS BUILT UP FROM THE SDIR PROGRAM
;		by Keith Petersen, W8SDZ
;
;	PRINTS A 4-WIDE DIRECTORY, SORTED ALPHABETICALLY
;
;	A:PDIR FILENAME.TYP
;
;	or just
;
;	A:PDIR
;
;	ALLOWS '*' OR '?' "WILD CARD" SPECIFICATIONS
;	DRIVE NAME BY ALSO BE SPECIFIED
;
;	YOU CAN ALSO SPECIFY THAT THE DIRECTORY NOT BE
;	ALPHABETIZED, BY ENTERING "N" AFTER THE FILE
;	NAME, DRIVE, ETC. AND YOU CAN CAUSE HIDDEN (SYSTEM)
;	FILES TO SHOW BY ENTERING "S" THE SAME WAY.
;
;	A:PDIR A: N		(DIRECTORY OF A:, NOT ALPHABETIZED)
;	A:PDIR *.BAS N		(DIRECTORY OF ALL .BAS FILES, NOT ALPHA.)
;	A:PDIR B: S		(DIRECTORY OF B:, INCLUDING HIDDEN FILES)
;	A:PDIR A: SN		(DIRECTORY OF A:, NOT ALPHA., INCL. SYS. FILES)
;	A:PDIR A: NS		(SAME AS ABOVE)
;
TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
;
H25	EQU	FALSE			;ASSEMBLE FOR HEATH EQUIPMENT
;					;OTHERWISE, ASSEMBLES FOR REG. PRINTER
;
M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
;
; BDOS EQUATES
;
RDCHR	EQU	1			;READ CHAR FROM CONSOLE
LSTOUT	EQU	5			;WRITE CHR TO LST:
SELECT	EQU	14			;SELECT DISK
FOPEN	EQU	15			;0FFH=NOT FOUND
SFF	EQU	17			;   "	"
SFN	EQU	18			;   "	"
FREAD	EQU	20			;0=OK, 1=EOF
GDISK	EQU	25			;GET CURRENT DISK
FDMA	EQU	26
GALLOC	EQU	27			;GET ALLOCATION ADDRESS
VER	EQU	48			;GET VERSION NO.
DFREE	EQU	54			;GET DRIVE FREE SPACE
FCB	EQU	5CH
XFCB	EQU	55H
;
PDIR	SEGMENT
	ASSUME	CS:PDIR,DS:PDIR,ES:PDIR,SS:PDIR
	ORG	100H
;
START:	MOV	AX,CS
	MOV	DS,AX			;PUT DS HERE
	MOV	AL,0DH
	CALL	TYPEC			;RETURN PRINTHEAD TO 1ST COLUMN
	MOV	BX,6DH			;GET FCB2 FIRST CHAR
CHKFLG:	MOV	AL,M
	CMP	AL,' '			;ANY SWITCHES
	JZ	GTDISK			;NO
	CMP	AL,'N'			;NO ALPHABETIZE?
	JNZ	CHKSYS			;NO, CHECK FOR "S" FLAG
	MOV	Byte Ptr NFLAG,1	;ELSE, SET NO SORT FLAG
	JMP	SHORT CHKNXT		;CHECK NEXT FLAG
CHKSYS:	CMP	AL,'S'			;SEE SYSTEM FILES?
	JNZ	GTDISK			;NO
	MOV	Word Ptr FCBADR,XFCB	;ELSE, USE EXTENDED FCB
CHKNXT:	INC	BX			;INCREMENT POINTER
	JMP	SHORT CHKFLG		;AND CHECK FOR MORE FLAGS
GTDISK:	MOV	AH,GDISK
	INT	21H			;GET CURRENT DISK
	MOV	Byte Ptr CURDSK,AL	;SAVE CURRENT DISK
	MOV	BX,FCB			;GET FCB ADDRESS
	MOV	AL,M			;GET DISK WE'RE USING
	DEC	AL			;MAKE IT 0-N
	JNS	SEL			;NOT USING DEFAULT DISK
	MOV	AL,Byte Ptr CURDSK	;ELSE, GET IT
SEL:	MOV	DL,AL			;IN E
	INC	AL			;MAKE IT 1-N
	MOV	Byte Ptr LFCBDR,AL	;PUT IT IN LABEL FCB
	MOV	Byte Ptr DLFCBDR,AL	;AND IN DISK LABEL, ALSO
	MOV	DX,Offset LABBUF
	MOV	AH,FDMA
	INT	21H			;SET DMA TO LABEL BUFFER
	MOV	AH,VER
	INT	21H			;CHECK VERSION
	CMP	AL,2			;2.0?
	JB	OLDLAB			;NO, CHECK OLD LABEL ONLY
	MOV	DX,(Offset DLFCB)
	MOV	AH,SFF
	INT	21H			;SEARCH FOR LABEL
	INC	AL			;GOT ONE?
	MOV	Byte Ptr L2FLG,AL	;MARK RESULT
	JNZ	FSIZE			;GOT LABEL
OLDLAB:	MOV	DX,(Offset LFCB)
	MOV	AH,FOPEN
	INT	21H			;TRY TO OPEN LABEL FILE
	INC	AL
	JZ	NOLAB
	MOV	AH,FREAD
	MOV	DX,(Offset LFCB)
	INT	21H			;READ LABEL FILE
	OR	AL,AL			;TEST READ
	JZ	FSIZE			;GOOD READ
NOLAB:	INC	Byte Ptr LABFLG		;MARK NO LABEL

FSIZE:	MOV	DX,80H
	MOV	AH,FDMA
	INT	21H			;SET STANDARD DMA ADDRESS
	MOV	DL,Byte Ptr LFCBDR	;GET DRIVE
	DEC	DL			;MAKE IT 0-N
	MOV	AH,SELECT
	INT	21H			;SELECT DISK
	PUSH	DS
	MOV	AH,GALLOC
	INT	21H			;GET ALLOCATION TABLE ADDRESS
	MOV	AH,0
	PUSH	DX			;SAVE NO. OF BLOCKS
	XCHG	CX,DX			;PUT BLOCKS IN CX, BYTES IN DX
	MUL	DX			;COMPUTE MIN. BLOCK SIZE
	PUSH	AX			;SAVE RESULT
	XOR	AX,AX			;CLEAR FREE COUNTER
	MOV	SI,2			;START WITH FAT ENTRY 2
SLOOP:	MOV	DI,SI			;PUT ENTRY NO. IN DI
	SHR	DI,1			;DIVIDE BY 2
	ADD	DI,SI			;CALCULATE FAT OFFSET
	MOV	DI,[BX+DI]		;GET ENTRY
	TEST	SI,1			;ODD ENTRY NO.?
	JZ	SIZE1			;NO, EVEN
	SHR	DI,1			;ELSE, MOVE DOWN 4 BITS
	SHR	DI,1
	SHR	DI,1
	SHR	DI,1
SIZE1:	AND	DI,0FFFH		;ISOLATE 12 BITS
	JNZ	SIZE2			;NOT AN EMPTY ENTRY
	INC	AX			;COUNT EMPTY ENTRY
SIZE2:	INC	SI			;DO NEXT FAT ENTRY
	LOOP	SLOOP			;UNTIL DONE
	POP	CX			;GET BLOCK SIZE
	POP	DX			;AND NO. OF BLOCKS
	POP	DS
	MOV	Word Ptr BSIZE,CX	;SAVE BLOCK SIZE
	PUSH	AX			;SAVE FREE SPACE
	PUSH	DX			;AND ALLOCATED USE
	MOV	AH,VER
	INT	21H			;CHECK VERSION
	CMP	AL,2			;2 OR MORE?
	POP	DX
	POP	AX
	JB	OLDVER			;OLD VERSION
	MOV	AH,DFREE
	XOR	DL,DL
	INT	21H			;ELSE, GET FREE SPACE FROM SYSTEM
	MOV	AX,BX			;IN AX
OLDVER:	MOV	Word Ptr FREE,AX	;AND FREE BLOCK COUNT
	SUB	DX,AX			;COMPUTE ALLOCATED USE
	MOV	Word Ptr ALLOC,DX	;AND SAVE IT

START1:	MOV	BX,FCB+1
	MOV	AL,M
	CMP	AL,' '			;ANY FCB?
	JNZ	GOTFCB
;
;NO FCB - MAKE FCB ALL '?'
;
	MOV	CH,11			;FN+FT COUNT
QLOOP:	MOV	M,'?'			;STORE '?' IN FCB
	INC	BX
	DEC	CH
	JNZ	QLOOP

GOTFCB:	MOV	BX,XFCB
	MOV	M,0FFH			;SET UP EXTENDED FCB
	MOV	CH,5
	INC	BX
XLOOP:	MOV	M,0
	INC	BX
	DEC	CH
	JNZ	XLOOP
	MOV	M,0FFH			;SET ALL FILE ATTRIBUTES
;
;LOOK UP THE FCB IN THE DIRECTORY
;
	MOV	AH,SFF			;GET 'SEARCH FIRST' FNC
	MOV	DX,Word Ptr FCBADR	;GET FCB ADDRESS
	INT	21H			;READ FIRST
	INC	AL			;WERE THERE ANY?
	JNZ	SOME			;GOT SOME
	JMP	BOTTOM
;
;READ MORE DIRECTORY ENTRIES
;
MOREDIR:MOV	AH,SFN			;SEARCH NEXT
	MOV	DX,Word Ptr FCBADR
	INT	21H			;READ DIR ENTRY
	INC	AL			;CHECK FOR END (0FFH)
	JNZ	SOME
	JMP	SPRINT			;NO MORE - SORT & PRINT
;
;POINT TO DIRECTORY ENTRY 
;
SOME:	MOV	BX,80H			;POINT TO FILE NAME
	MOV	AL,M			;GET FIRST BYTE
	INC	BX			;MOVE TO NAME
	CMP	AL,0FFH			;TEST FOR EXTENDED FORMAT
	JNZ	NOTEXT			;NOT EXTENDED
	ADD	BX,7			;ELSE, ADD 7
	MOV	AL,11[BX]		;GET ATTRIBUTE BITS
	CMP	AL,10H			;DIRECTORY NAME?
	JNZ	NOTDIR			;NO
	MOV	Word Ptr 8[BX],'D<'	;ELSE, INSERT "<D>" FOR TYPE
	MOV	Byte Ptr 10[BX],'>'
NOTDIR:	PUSH	BX			;SAVE POINTER
ATLP:	SHR	AL,1			;TEST FOR AN ATTRIBUTE BIT
	JNC	NOAT			;NONE IN THIS PLACE
	OR	M,80H			;ELSE, MARK IT
NOAT:	INC	BX			;INCREMENT POINTER
	OR	AL,AL			;DONE WITH BITS?
	JNZ	ATLP			;IF NOT, LOOP
	POP	BX			;ELSE, RESTORE POINTER
NOTEXT:	MOV	AX,28[BX]		;GET FILE SIZE
	MOV	11[BX],AX		;PUT IT HERE
	MOV	AX,30[BX]		;MOVE HIGH WORD, TOO
	AND	AX,3FFFH		;MASK FILE SIZE TO 30 BITS
	MOV	13[BX],AX
;
;MOVE ENTRY TO TABLE
;
MOVEN:	MOV	AX,CS
	MOV	ES,AX
	MOV	SI,BX			;PUT ENTRY ADDR IN SI
	MOV	DI,Word Ptr NEXTT	;PUT NEXT TABLE ENTRY IN DI
	MOV	CX,15			;MOVE 15 CHARACTERS
	REP	MOVSB			;MOVE THE ENTRY
	MOV	Word Ptr NEXTT,DI	;SAVE UPDATED TABLE ADDR
	INC	Word Ptr COUNT		;INCREMENT COUNT
	JMP	MOREDIR
;
;SORT AND PRINT
;
SPRINT:	CMP	Byte Ptr NFLAG,0	;NO ALPHABETIZING WANTED?
	JZ	DOSORT			;NO, DO SORT
	JMP	DONE			;ELSE, DONE
DOSORT:	MOV	BX,(Offset ORDER)
	MOV	DX,(Offset TABLE)
	MOV	CX,15			;ENTRY LENGTH

;BUILD ORDER TABLE

BLDORD:	MOV	AX,COUNT		;GET COUNT OF FILES
BLDORD1:MOV	[BX],DX			;SAVE ORD ADDR
	INC	BX
	INC	BX
	ADD	DX,CX			;POINT TO NEXT ENTRY
	DEC	AX			;MORE?
	JNZ	BLDORD1			;..YES
	MOV	Word Ptr NEXTT,Offset ORDER	;SET TABLE POINTER
	MOV	AX,Word Ptr COUNT	;GET COUNT
	MOV	Word Ptr SCOUNT,AX	;SAVE AS # TO SORT
	DEC	AX			;ONLY 1 ENTRY?
	JNZ	SORT			;NO, DO SORT
	JMP	DONE			;ELSE, DONE

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'SCOUNT' = NUMBER OF STRINGS TO BE SORTED
;		('NEXTT') = START OF POINTER TABLE
;		   POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.
;		'SCOUNT' = NUMBER OF STRINGS SORTED. (UNCHANGED)
;		'VARM' = 0.

SORT:	MOV	BX,Word Ptr SCOUNT
	MOV	Word Ptr VARM,BX
SETM:	MOV	BX,Word Ptr VARM
	SHR	BX,1
	MOV	Word Ptr VARM,BX	;VARM = VARM / 2 
	CMP	BX,0
	JNZ	NOTEND	
	JMP	DONE			;IF END OF SORT
NOTEND:	MOV	BX,1
	MOV	Word Ptr VARJ,BX	;VARJ = 1
	MOV	BX,Word Ptr SCOUNT
	MOV	DX,Word Ptr VARM
	SUB	BX,DX
	MOV	Word Ptr VARK,BX	;VARK = VARN - VARM
SETI:	MOV	BX,Word Ptr VARJ
	MOV	Word Ptr VARI,BX	;VARI = VARJ
SETL:	MOV	BX,Word Ptr VARI
	MOV	DX,Word Ptr VARM
	ADD	BX,DX
	MOV	Word Ptr VARL,BX	;VARL = VARI + VARM
	CALL	SYMVAL			;BX = START OF DATA POINTED BY VARL
	PUSH	BX
	MOV	BX,Word Ptr VARI
	CALL	SYMVAL
	POP	SI
	MOV	CL,15			;*GET STRING LENGHT
	DEC	BX			;*PRE-DECREMENT POINTERS
	DEC	SI			;*
SCOMP:	INC	BX			;CL = LENGTH OF SHORTER STRING
	INC	SI			;HL & DE POINT TO START OF LABEL STRINGS
	MOV	AL,[SI]
	CMP	AL,M			;COMPARE STRINGS
	JNZ	NOMACH			;IF NO MATCH
	DEC	CL
	JNZ	SCOMP
NOMACH:	JNB	SETJ			;IF NO REARRANGEMENT REQUIRED

; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	MOV	BX,Word Ptr VARI
	CALL	TABADD
	PUSH	BX			;STACK = POINTER DATA FOR (VARI)
	MOV	BX,Word Ptr VARL
	CALL	TABADD			;BX = POINTER DATA FOR (VARL)
	POP	SI
	MOV	AX,[SI]
	MOV	DX,[BX]
	MOV	[SI],DX
	MOV	[BX],AX

; SWITCH COMPLETED

	MOV	BX,Word Ptr VARI
	MOV	DX,Word Ptr VARM
	SUB	BX,DX
	MOV	Word Ptr VARI,BX	;VARI = VARI - VARM
	DEC	BX
	JS	SETJ	
	JMP	SETL			;IF VARI >= 1
SETJ:	MOV	BX,Word Ptr VARJ
	INC	BX
	MOV	Word Ptr VARJ,BX	;VARJ = VARJ + 1
	MOV	DX,Word Ptr VARK
	SUB	DX,BX
	JNB	SETJ0	
	JMP	SETM			;IF VARJ > VARK
SETJ0:	JMP	SETI

; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: BX = INTEGER VALUE ( 1 -> N )
;	EXIT:  BX = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DEC	BX			;START AT ZERO
	SHL	BX,1			;BX = [(ORIGINAL HL) - 1] * 2
	MOV	DX,Word Ptr NEXTT
	ADD	BX,DX
	RET

; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: BX = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  BX = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	BX,[BX]
	RET
;
;SORT IS ALL DONE - PRINT ENTRIES
;
DONE:	MOV	AX,COUNT		;GET COUNT OF FILES
	MOV	DX,0
	MOV	CX,240			;ALLOW 240 FILES/PAGE
	DIV	CX			;CALCULATE NO. OF PAGES
	MOV	PAGES,AL		;SAVE NO. OF PAGES
	MOV	LASTPG,DX		;SAVE NO. OF FILES IN LAST PAGE
PLOOP:	MOV	Byte Ptr COLNO,0	;CLEAR COLUMN NO.
	MOV	Byte Ptr STRTCOL,0	;AND STARTING COLUMN
	MOV	Byte Ptr PGCNT,'1'	;SET PAGE COUNTER
	CMP	Byte Ptr LABFLG,0	;ANY LABEL
	JNZ	NOLAB1			;IF NOT, GO ON
	CALL	TYPTX
	DB	'Disk',' '+80H
	MOV	AL,Byte Ptr LFCBDR	;GET DRIVE CODE
	ADD	AL,40H			;MAKE IT ASCII
	CALL	TYPEC			;PRINT IT
	MOV	AL,':'
	CALL	TYPEC			;PUT ":" AFTER DRIVE
	CMP	Byte Ptr L2FLG,0	;DOS 2.0 LABEL?
	JNZ	D2LAB			;YES
	CALL	TYPTX
	DB	' ','#'+80H		;PUT # BEFORE NO.
	MOV	DX,(Offset LABBUF)+2
	CALL	WRPRT			;PRINT VOL. NO.
D2LAB:	CALL	TYPTX
	DB	' Label:',' '+80H
	CMP	Byte Ptr L2FLG,0
	JNZ	D2LAB1			;DOS 2.0 LABEL
	MOV	DX,(Offset LABBUF)+3
FLAB:	MOV	SI,DX
	MOV	AL,[SI]
	INC	DX
	CMP	AL,'"'			;FIND LABEL
	JNZ	FLAB
	CALL	WRPRT			;PRINT LABEL
	JMP	SHORT PBORD
NOLAB1:	CALL	TYPTX
	DB	'Directory of disk',' '+80H
	MOV	AL,Byte Ptr LFCBDR
	ADD	AL,40H
	CALL	TYPEC
	CALL	TYPTX
	DB	':'+80H
	JMP	SHORT PBORD
D2LAB1:	MOV	SI,(Offset LABBUF)+8	;POINT TO LABEL
	MOV	CX,11			;CHAR COUNT
PRTLAB:	LODSB				;GET A CHARACTER
	PUSH	SI
	CALL	TYPEC			;PRINT IT
	POP	SI
	LOOP	PRTLAB			;LOOP UNTIL DONE
PBORD:	CALL	TYPTX
	IF	H25
	DB	0DH,0AH			;GO TO NEXT LINE
	DB	27,'[10m',8DH		;ENTER GRAPHICS MODE
	ENDIF
	IF	NOT H25
	DB	0DH,8AH			;GO TO NEXT LINE
	ENDIF
	MOV	CH,4			;SET A COUNTER
BORD1:	CALL	TYPTX
	IF	H25
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	ENDIF
	IF	NOT H25
	DB	'------------------','-'+80H
	ENDIF
	DEC	CH
	JZ	BORD2
	IF	H25
	MOV	AL,'s'
	ENDIF
	IF	NOT H25
	MOV	AL,'-'
	ENDIF
	CALL	TYPEC
	JMP	SHORT BORD1
BORD2:	CALL	TYPTX
	DB	0DH,8AH			;GO TO NEXT LINE
	MOV	AX,CS
	MOV	ES,AX			;PUT ES HERE
	MOV	DI,(Offset PBUF)	;POINT TO PRINT BUFFER
	MOV	AL,' '			;GET A SPACE
	MOV	CX,80*60		;CLEAR 60 LINES BY 80 COLUMNS
	CLD				;ENSURE FORWARD STRING DIRECTION
	REP	STOSB			;CLEAR THE SPACE
	MOV	DI,(Offset PBUF)+78	;POINT TO END OF 1ST LINE
	MOV	DX,79			;LENGTH OF EACH LINE - 1
	MOV	CX,60			;60 LINES
CLBUF1:	MOV	AL,0DH			;INSERT CR, LF
	STOSB
	MOV	AL,8AH
	MOV	[DI],AL
	ADD	DI,DX			;MOVE TO NEXT LINE
	LOOP	CLBUF1			;LOOP UNTIL DONE
	MOV	DI,(Offset PBUF)+19	;POINT TO 1ST DIVIDER POS.
	MOV	DX,80			;CHARACTERS/LINE
	MOV	CX,60			;60 LINES
	IF	H25
	MOV	AL,'`'			;GET DIVIDER CHARACTER
	ENDIF
	IF	NOT H25
	MOV	AL,'|'
	ENDIF
CLBUF2:	MOV	[DI],AL			;INSERT DIVIDER
	MOV	20[DI],AL
	MOV	40[DI],AL
	ADD	DI,DX			;MOVE TO NEXT LINE
	LOOP	CLBUF2
	CMP	Byte Ptr PAGES,0	;NO PAGES?
	MOV	AX,Word Ptr LASTPG	;ASSUME NOT
	JZ	NOPAGE
	MOV	AX,240			;ELSE, PRINT 240 FILES
NOPAGE:	ADD	AX,3			;ADD 3
	MOV	DX,0
	MOV	BX,4
	DIV	BX			;DIVIDE BY 4
	CMP	AX,61			;MORE THAN 60?
	JB	TRY10			;NO, SEE IF TO LITTLE
	MOV	DH,60			;ELSE, PRINT 60 LINES
	JMP	SHORT SETLNS		;SET LINES TO PRINT
TRY10:	CMP	AX,10			;LESS THAN 10 LINES
	JNB	SETLNS1			;NO
	MOV	DH,10			;PRINT AT LEAST 10 LINES
SETLNS:	MOV	AL,DH
SETLNS1:MOV	Byte Ptr NLINES,AL	;SET NO. OF LINES TO PRINT
	MOV	AL,Byte Ptr NFLAG
	OR	AL,AL			;DIRECTORY SORTED?
	JZ	ENTRY			;YES
	MOV	BX,(Offset TABLE)-15
	MOV	Word Ptr NEXTT,BX	;ELSE, PUT TABLE IN NEXTT
;
;PRINT AN ENTRY
;
ENTRY:	MOV	AL,Byte Ptr NFLAG
	OR	AL,AL			;DIRECTORY SORTED?
	JZ	ENTRY1			;YES
	MOV	BX,Word Ptr NEXTT	;ELSE, GET ENTRY ADDRESS
	ADD	BX,15
	MOV	Word Ptr NEXTT,BX	;UPDATE POINTER
	XCHG	BX,DX			;DE = ADDRESS
	JMP	SHORT ENTRY2
ENTRY1:	MOV	BX,Word Ptr NEXTT	;GET ORDER TABLE POINTER
	MOV	DX,[BX]			;GET ADDRESS
	INC	BX
	INC	BX
	MOV	Word Ptr NEXTT,BX	;SAVE UPDATED TABLE POINTER
ENTRY2:	MOV	AL,Byte Ptr STRTCOL	;GET STARTING COLUMN NO.
	MOV	Byte Ptr COLUMN,AL	;SET COLUMN FOR INSERTION
	XCHG	BX,DX			;TABLE ENTRY TO HL
	PUSH	BX			;SAVE ENTRY ADDRESS
	MOV	CH,8			;FILE NAME LENGTH
	CALL	INSIT			;TYPE FILENAME
	CALL	PERIOD			;PERIOD AFTER FN
	MOV	CH,3			;GET THE FILETYPE
	CALL	INSIT
	MOV	AX,[BX]			;GET FILE SIZE LOW
	ADD	Word Ptr USED,AX	;UPDATE USED SPACE
	PUSH	AX			;SAVE SIZE LOW
	MOV	AX,2[BX]
	ADC	Word Ptr USEDH,AX
	POP	BX			;GET SIZE LOW IN BX
	MOV	DX,(Offset SPACES)	;POINT TO SPACES
	CMP	AX,0			;HUGE FILE?
	JZ	SMFILE			;NO
	ADD	DX,4			;ELSE, ELIMINATE SOME SPACES
	JMP	SHORT PSIZE		;AND PRINT SIZE
SMFILE:	CMP	BX,10			;LESS THAN 10 BYTES?
	JB	PSIZE			;YES, PRINT SIZE
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,100			;LESS THAN 100 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,1000			;LESS THAN 1000 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,10000		;LESS THAN 10000 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
PSIZE:	XCHG	BX,DX			;BX = SPACES
	PUSH	AX			;SAVE SIZE HIGH
	CALL	ITXT			;PRINT SPACES
	POP	AX
	XCHG	BX,DX
	PUSH	CX
	CALL	DDECOUT			;PRINT FILE SIZE
	POP	CX

;SEE IF MORE ENTRIES

	INC	Word Ptr PCOUNT		;INCREMENT PRINT COUNT
	DEC	Word Ptr COUNT		;DECREMENT COUNT
	JNZ	SMORE	
	JMP	PFILES			;NO MORE FILES TO PRINT
SMORE:	MOV	AL,Byte Ptr LINE	;GET LINE NUMBER
	INC	AL			;INCREMENT IT
	MOV	Byte Ptr LINE,AL
	CMP	AL,Byte Ptr NLINES	;END OF COLUMN?
	JZ	SMORE1	
	JMP	ENTRY			;MORE TO PRINT
SMORE1:	MOV	Byte Ptr LINE,0		;ZERO LINE COUNTER
	MOV	AL,Byte Ptr COLNO	;ELSE GET COLUMN NUMBER
	INC	AL			;INCREMENT IT
	MOV	Byte Ptr COLNO,AL
	CMP	AL,4			;PRINTED 4 COLUMNS?
	JZ	PFILES			;YES, PRINT FILES
	MOV	CL,20			;ASSUME COLUMN 2
	DEC	AL			;TEST FOR IT
	JZ	SETCOL			;YES
	MOV	CL,40			;ASSUME COLUMN 3
	DEC	AL
	JZ	SETCOL
	MOV	CL,60			;ELSE, IT'S COLUMN 4
SETCOL:	MOV	Byte Ptr STRTCOL,CL	;SET UP STARTING COLUMN
	JMP	ENTRY			;PRINT MORE
PFILES:	MOV	CH,Byte Ptr NLINES	;GET NO. OF LINES TO PRINT
	MOV	BX,(Offset PBUF)	;POINT TO PRINT BUFFER
PFILE1:	CALL	TYPTX1			;PRINT THE FILES
	DEC	CH
	JNZ	PFILE1
	MOV	CH,4			;SET A COUNTER
PFILE2:	CALL	TYPTX
	IF	H25
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	ENDIF
	IF	NOT H25
	DB	'------------------','-'+80H
	ENDIF
	DEC	CH
	JZ	PFILE3			;CHECK FOR MORE PAGES
	IF	H25
	MOV	AL,'u'
	ENDIF
	IF	NOT H25
	MOV	AL,'-'
	ENDIF
	CALL	TYPEC
	JMP	SHORT PFILE2
PFILE3:	CALL	TYPTX
	IF	H25
	DB	27,'[11m',0DH
	ENDIF
	DB	0DH,8AH
	DEC	Byte Ptr PAGES		;COUNT THIS PAGE
	JS	NMPAGES			;NO MORE PAGES
	CALL	TYPTX			;ELSE, FEED TO NEXT PAGE
	DB	'Page',' '+80H
	MOV	AL,PGCNT
	CALL	TYPEC			;PRINT PAGE NO.
	INC	AL
	MOV	PGCNT,AL
	CALL	TYPTX
	DB	13,10,10,10+80H
	JMP	PLOOP			;DO NEXT PAGE
NMPAGES:JMP	BOTTOM
;
PERIOD:	MOV	AL,'.'
	JMP	INSERT
;
;TYPE CHAR IN A
;
TYPEC:	PUSH	CX
	PUSH	DX
	PUSH	BX
	PUSH	AX
	MOV	DL,AL
	MOV	AH,LSTOUT
	INT	21H
	POP	AX
	POP	BX
	POP	DX
	POP	CX
	RET
;
WRPRT:	MOV	SI,DX			;GET A CHARACTER
	MOV	AL,[SI]
	CMP	AL,'$'			;END OF STRING?
	JNZ	WRPRT1	
	RET				;RETURN IF SO
WRPRT1:	CALL	TYPEC			;ELSE, PRINT IT
	INC	DX
	JMP	SHORT WRPRT
;
INSIT:	MOV	AL,M
	AND	AL,7FH			;STRIP PARITY BIT
	CALL	INSERT			;INSERT CHARACTER
	INC	BX
	DEC	CH
	JNZ	INSIT
	RET
;
;BOTTOM - PRINT DISK SPACE DATA
;
BOTTOM:	INC	Byte Ptr TYPFLG		;FLAG USE OF TYPE CALL IN DDECOUT
	INC	Byte Ptr COMFLG		;TELL DDECOUT TO USE COMMAS
	MOV	BX,Word Ptr PCOUNT	;GET FILE COUNT
	MOV	AX,0
	CALL	DDECOUT			;PRINT COUNT
	CALL	TYPTX
	DB	' Files. ',' '+80H
	MOV	BX,Word Ptr USED	;GET USED SPACE
	MOV	AX,Word Ptr USEDH
	CALL	DDECOUT			;PRINT IT
	CALL	TYPTX
	DB	' ','('+80H
	MOV	AX,Word Ptr ALLOC	;GET ALLOCATED SPACE
	MOV	CX,Word Ptr BSIZE	;AND BLOCK SIZE
	MUL	CX			;COMPUTE ALLOCATED BYTES
	MOV	BX,AX			;LOW TO BX
	MOV	AX,DX			;HIGH TO DX
	CALL	DDECOUT			;PRINT ALLOCATED SPACE
	CALL	TYPTX
	DB	') Used. ',' '+80H
	MOV	AX,Word Ptr FREE	;GET FREE SPACE
	MOV	CX,Word Ptr BSIZE	;AND BLOCK SIZE
	MUL	CX			;COMPUTE FREE BYTES
	MOV	BX,AX
	MOV	AX,DX
	CALL	DDECOUT			;PRINT FREE SPACE
	CALL	TYPTX
	DB	' Free.',13,10,10,8AH
;
;EXIT - ALL DONE 
;
EXIT:	MOV	DL,Byte Ptr CURDSK	;GET CURRENT DISK
	MOV	AH,SELECT
	INT	21H			;SET DEFAULT DISK
	INT	20H			;RETURN TO Z-DOS

;	DDECOUT - PRINT 32 BIT NO. IN AX,BX IN DECIMAL
;	AX = HIGH WORD, BX = LOW WORD

DDECOUT: MOV	SI,0			;CLEAR ZERO SUPPRESS FLAG
	MOV	CX,3B9AH
	MOV	DX,0CA00H		;CX,DX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	CALL	COMMA			;PRINT A COMMA (IF NO. PRINTED)
	MOV	CX,5F5H
	MOV	DX,0E100H		;CX,DX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	DX,9680H		;CX,DX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	DX,4240H		;CX,DX = 1,000,000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,1
	MOV	DX,86A0H		;CX,DX = 100,000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10000		;CX,DX = 10000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,1000			;CX,DX = 1000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,0
	MOV	DX,100			;CX,DX = 100
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10			;CX,DX = 10
	CALL	DIVPR
	MOV	AL,BL			;GET ONES DIGIT
	ADD	AL,'0'			;ADD ASCII
	CMP	Byte Ptr TYPFLG,0	;USE TYPE FUNCTION?
	JZ	DEC2			;NO, INSERT
	JMP	TYPEC
DEC2:	JMP	INSERT
DIVPR:	MOV	DI,-1			;SET A COUNTER
DIVPR1:	INC	DI			;INCREMENT COUNTER
	SUB	BX,DX			;SUBTRACT DIVISOR
	SBB	AX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	BX,DX			;ADD DIVISOR BACK IN ONCE
	ADC	AX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,DI			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	CMP	SI,0			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	INC	SI			;ELSE, FLAG ZEROS PASSED
DIVPR2:	CMP	Byte Ptr TYPFLG,0	;USE TYPE FUNCTION?
	JZ	DEC3			;NO, USE INSERT
	CALL	TYPEC			;ELSE, PRINT WITH TYPE
	JMP	SHORT DIVPR3
DEC3:	CALL	INSERT			;PRINT CHARACTER
DIVPR3:	POP	AX			;RESTORE AX
	RET
COMMA:	CMP	SI,0			;ANY NUMBERS PRINTED?
	JZ	COMMA1			;NO
	CMP	Byte Ptr COMFLG,0	;COMMAS WANTED?
	JZ	COMMA1			;NO
	PUSH	AX
	MOV	AL,','			;ELSE, PRINT COMMA
	CMP	Byte Ptr TYPFLG,0	;USE TYPE FUNCTION?
	JZ	DEC4			;NO, USE INSERT
	CALL	TYPEC			;ELSE, PRINT WITH TYPE
	JMP	SHORT DEC5
DEC4:	CALL	INSERT			;PRINT CHARACTER
DEC5:	POP	AX
COMMA1:	RET
;
;	TYPTX - TYPE TEXT FOLLOWING CALL
;
TYPTX:	MOV	BP,SP			;GET ADDRESS OF TEXT
	XCHG	BX,[BP]
	CALL	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPTX1:	MOV	AL,M
	AND	AL,7FH
	CALL	TYPEC
	CMP	AL,M
	PUSHF
	INC	BX
	POPF
	JZ	TYPTX1
	RET
;
;	ITXT - INSERT TEXT AT ((HL)) INTO BUFFER
;
ITXT:	MOV	AL,M
	AND	AL,7FH
	CALL	INSERT
	CMP	AL,M
	PUSHF
	INC	BX
	POPF
	JZ	ITXT
	RET
;
;	INSERT - INSERT CHARACTERS INTO BUFFER
;
;	THIS ROUTINE INSERTS CHARACTERS INTO A BUFFER
;	FOR PRINTING, USING THE FORMULA
;
;	POSITION = BUFFER + (80 * LINE + COLUMN)
;
;	THE VARIABLE COLUMN IS INCREMENTED AFTER
;	EACH INSERTION.  THE VARIABLE "LINE" IS
;	SET EXTERNALLY.
;
;	ENTER WITH (A) = CHARACTER TO STUFF.
;
INSERT:	PUSH	CX			;SAVE REGISTERS
	PUSH	DX
	PUSH	BX
	PUSH	AX			;SAVE CHARACTER
	MOV	AX,80			;80 CHARACTERS/LINE
	MOV	CL,Byte Ptr LINE	;GET LINE NO.
	MUL	CL			;MULTIPLY
	MOV	BX,AX			;RESULT TO BX
	MOV	DL,Byte Ptr COLUMN	;GET COLUMN NO.
	MOV	DH,0			;DX = COLUMN NO.
	INC	Byte Ptr COLUMN		;INCREMENT COLUMN NO.
	ADD	BX,DX			;ADD COLUMN NO.
	MOV	DX,(Offset PBUF)
	ADD	BX,DX			;FIND POS. IN BUFFER
	POP	AX			;GET CHARACTER
	MOV	M,AL			;INSERT IT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET
;
CURDSK	DB	0			;CURRENT DISK
NFLAG	DB	0			;NO ALPHABETIZE FLAG
FCBADR	DW	Offset FCB		;FCB ADDRESS
NEXTT	DW	(Offset TABLE)		;NEXT TABLE ENTRY
COUNT	DW	0			;ENTRY COUNT
PCOUNT	DW	0			;COUNT TO PRINT
SCOUNT	DW	0			;# TO SORT
VARI	DW	0			;SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
USED	DW	0			;USED SPACE
USEDH	DW	0			;USED SPACE (HIGH BYTE)
FREE	DW	0			;FREE SPACE
ALLOC	DW	0			;ALLOCATED SPACE
BSIZE	DW	0			;BLOCK SIZE
PAGES	DB	0			;PAGES OF FILES
LASTPG	DW	0			;FILES ON LAST PAGE
PGCNT	DB	0			;PAGE COUNTER
SPACES	DB	'    ',' '+80H
COLNO	DB	0			;COLUMN NUMBER (1-4)
STRTCOL	DB	0			;STARTING COLUMN NO.
COLUMN	DB	0			;COLUMN NUMBER (0-79)
LINE	DB	0			;LINE NO.
NLINES	DB	0			;NUMBER OF LINES TO PRINT
TYPFLG	DB	0			;TYPE FUNCTION FLAG (FOR DECOUT)
COMFLG	DB	0			;COMMA FLAG
LABFLG	DB	0			;LABEL FLAG
L2FLG	DB	0			;DOS 2.0 LABEL FLAG
LFCB	DB	0FFH,0,0,0,0,0,2	;FCB EXTENSION
LFCBDR	DB	0,'IDENT   SYS',0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DLFCB	DB	0FFH,0,0,0,0,0,8	;DOS 2.0 LABEL FCB
DLFCBDR	DB	0,'???????????',0,0,0,0
LABBUF	EQU	Offset $		;DISK LABEL BUFFER
ORDER	EQU	(Offset LABBUF)+128	;ORDER TABLE (ROOM FOR 1024 NAMES)
PBUF	EQU	(Offset ORDER)+2048	;PRINT BUFFER (60 LINES 80 COL.)
TABLE	EQU	(Offset PBUF)+(80*60)	;READ ENTRIES IN HERE
PDIR	ENDS
	END	START
