	PAGE	,132
	TITLE	INSTALL
;	INSTALL PROGRAM FOR HEPCAT.
;	THIS PROGRAM PROMPTS THE USER AND INSTALLS HEPCAT ON
;	HIS/HER DISK ACCORDING TO THE ANSWERS SUPPLIED.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  04-MAY-87
;	COPYRIGHT (C) PATRICK SWAYNE 1987.  ALL RIGHTS RESERVED.

RSIZE	EQU	14			;RECORD SIZE OFFSET
FSIZE	EQU	16			;FILE SIZE OFFSET
FDATE	EQU	20			;FILE DATE OFFSET
FTIME	EQU	22			;FILE TIME OFFSET

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	AH,19H
	INT	21H			;GET CURRENT DISK
	ADD	AL,'A'			;MAKE IT ASCII
	MOV	CDRIVE,AL		;SAVE IT
	PUSH	DS
	MOV	AX,40H
	MOV	DS,AX
	MOV	SI,0
	MOV	AL,'P'			;ASSUME PC
	CMP	BYTE PTR [SI],0E9H	;TEST
	POP	DS
	JNZ	PC
	MOV	AL,'Z'			;ELSE, Z-100
PC:	MOV	COMTYPE,AL		;SAVE COMPUTER TYPE
	MOV	AH,30H
	INT	21H			;GET DOS VERSION
	MOV	DOSVER,AL		;SAVE IT
	MOV	DX,OFFSET SIGNON
	CALL	PMSG			;PRINT SIGNON MSG
	MOV	DX,OFFSET PCMSG		;ASSUME PC
	CMP	BYTE PTR COMTYPE,'P'	;IS IT?
	JZ	PRTYP			;YES
	MOV	DX,OFFSET ZMSG
PRTYP:	CALL	PMSG
	MOV	DX,OFFSET CORMSG
	CALL	PMSG			;ASK IS THIS CORRECT
	CALL	AYN			;ASK Y OR N
	JC	GETHDRV			;HE SAID YES
	MOV	DX,OFFSET WARNMSG
	CALL	PMSG			;WARN USER
	MOV	AL,COMTYPE
	MOV	AH,'P'			;ASSUME Z-100 FROM TEST
	CMP	AL,'Z'			;IS IT?
	JZ	SWAPT			;YES, SWAP TO PC
	MOV	AH,'Z'			;ELSE, MAKE IT Z-100
SWAPT:	MOV	COMTYPE,AH
GETHDRV:MOV	DX,OFFSET GHDMSG
	CALL	PMSG			;ASK FOR DEST. DRIVE
	CMP	BYTE PTR DOSVER,2	;CHECK DOS VERSION
	JB	OLD			;OLD VERSION
	MOV	DX,OFFSET HPMSG
	CALL	PMSG			;ELSE, ASK FOR PATH
OLD:	MOV	DX,OFFSET GHDMSG1
	CALL	PMSG			;PRINT REST OF MSG.
	CALL	INPUT			;GET REPLY
	OR	CX,CX
	JZ	GETHDRV			;NOTHING ENTERED
	MOV	AL,[SI]
	CALL	MUC
	MOV	DRIVE,AL		;SAVE DRIVE CODE
	CMP	BYTE PTR DOSVER,2	;CHECK DOS VERSION
	JNB	CHKPATH			;2 OR ABOVE, CHECK FOR PATH
	CMP	CDRIVE,AL		;ELSE, CHECK CURRENT DRIVE
	JNZ	OLD1			;NOT THE SAME
	MOV	BYTE PTR SDFLG,1	;ELSE, MARK DRIVES THE SAME
	JMP	SHORT OLD1
CHKPATH:MOV	BX,CX			;COUNT TO BX
	DEC	BX			;LESS 1
	MOV	DI,SI
	MOV	AL,'\'
	CLD
	PUSH	CX
	REPNZ	SCASB			;LOOK FOR "\"
	POP	CX
	JZ	GOTPATH			;PATH WAS SPECIFIED
	MOV	AL,':'			;ELSE, LOOK FOR THIS
GOTPATH:CMP	[SI+BX],AL		;CHECK END OF STRING
	JZ	PATHOK			;IT'S OK
	CMP	AL,'\'			;DOING PATH?
	JZ	DOPATH			;YES
	CMP	CX,1			;DRIVE ONLY SPECIFIED?
	JZ	DOPATH			;YES, ":" OK
	MOV	AL,'\'			;ELSE, MUST BE PATH
DOPATH:	INC	BX			;MOVE TO END
	INC	CX			;FIX COUNT
	XOR	AH,AH
	MOV	[SI+BX],AX		;TERMINATE STRING PROPERLY
PATHOK:	CMP	BYTE PTR 1[SI],':'	;WAS A DRIVE SPECIFIED AT ALL?
	JZ	GOTDRV			;YES
	MOV	BYTE PTR SDFLG,1	;ELSE, MARK SAME DRIVE
GOTDRV:	MOV	AL,DRIVE
	CMP	AL,CDRIVE		;COMPARE DRIVE WITH CURRENT
	JNZ	MOVPATH			;NOT THE SAME
	MOV	BYTE PTR SDFLG,1	;ELSE, MARK SAME DRIVE
MOVPATH:MOV	DI,OFFSET PATH		;STORE PATH HERE
	REP	MOVSB			;COPY IT
	MOV	PATHE,DI		;SAVE END ADDRESS
OLD1:	MOV	DX,OFFSET CLKMSG
	CALL	PMSG			;ASK ABOUT SCRNCLK
	CALL	AYN			;ASK Y OR N
	JNC	NOCLK			;HE SAID NO
	MOV	BYTE PTR CLKFLG,1	;SET CLOCK FLAG
NOCLK:	MOV	DX,OFFSET MODMSG
	CALL	PMSG			;ASK IF AUTOEXEC TO BE MODIFIED
	CALL	AYN
	JNC	NOMOD			;HE SAID NO
	MOV	BYTE PTR AUTOFLG,1	;ELSE, MARK IT
	JMP	SHORT CHCLK
NOMOD:	MOV	DX,OFFSET CRMSG
	CALL	PMSG			;ASK IF AUTOEXEC TO BE CREATED
	CALL	AYN
	JNC	DOJOB			;HE SAID NO, DO JOB
	MOV	BYTE PTR AUTOFLG,2	;ELSE, MARK IT
CHCLK:	CMP	BYTE PTR CLKFLG,0	;DOING CLOCK?
	JZ	DOJOB			;IF NOT, GO DO JOB
	MOV	DX,OFFSET INCMSG
	CALL	PMSG			;ELSE, ASK ABOUT CLOCK
	CALL	AYN
	JNC	DOJOB			;NO CLOCK, DO THE JOB
	MOV	BYTE PTR CLLFLG,1	;ELSE, MARK IT
DOJOB:	MOV	DX,OFFSET BUFFER
	MOV	AH,1AH
	INT	21H			;SET DTA TO BUFFER
	MOV	DX,OFFSET THEPMSG
	CALL	PMSG			;SAY "TRANSFERRING HEPCAT"
	MOV	DX,OFFSET PHEPFCB	;ASSUME PC
	CMP	BYTE PTR COMTYPE,'P'	;IS IT?
	JZ	RDHEP			;YES
	MOV	DX,OFFSET ZHEPFCB	;ELSE, OTHER FCB
RDHEP:	CALL	READFIL
	JNC	RDHEPOK			;READ WAS OK
RHEPER:	MOV	DX,OFFSET RHEPMSG
	CALL	PMSG
	INT	20H
RDHEPOK:CALL	SWPDES			;SWAP DEST. IF NECESSARY
	MOV	DX,OFFSET HEPFCB	;POINT TO HEPCAT FCB
	MOV	SI,OFFSET HEPNAM	;AND ASCIZ NAME
	CALL	WRTFIL			;WRITE IT TO DEST.
	JNC	WHEPOK			;WRITE OK
WDESER:	MOV	DX,OFFSET WERMSG
	CALL	PMSG			;WRITE ERROR
	INT	20H
WHEPOK:	CALL	SWPSOU			;SWAP TO SOURCE
	MOV	DX,OFFSET TSETMSG
	CALL	PMSG			;SAY "TRANSFERRING HEPSET"
	MOV	DX,OFFSET SETFCB	;POINT TO HEPSET FCB
	CALL	READFIL			;READ IT
	JC	RHEPER			;ERROR
	CALL	SWPDES			;SWAP TO DESTINATION
	MOV	DX,OFFSET SETFCB
	MOV	SI,OFFSET SETNAM
	CALL	WRTFIL			;WRITE HEPSET.COM
	JC	WDESER			;ERROR
	CMP	BYTE PTR CLKFLG,1	;DOES HE WANT CLOCK?
	JNZ	CHKAUTO			;NO, CHECK AUTOEXEC
	CALL	SWPSOU			;SWAP TO SOURCE
	MOV	DX,OFFSET TSCKMSG
	CALL	PMSG			;SAY "TRANSFERRING SCRNCLK"
	MOV	DX,OFFSET PCLKFCB	;ASSUME PC
	CMP	BYTE PTR COMTYPE,'P'	;IS IT?
	JZ	RDCLK			;YES
	MOV	DX,OFFSET ZCLKFCB	;ELSE, OTHER FCB
RDCLK:	CALL	READFIL			;READ SCRNCLK
	JC	RHEPER
	CALL	SWPDES
	MOV	DX,OFFSET SCLKFCB
	MOV	SI,OFFSET SCLKNAM
	CALL	WRTFIL			;WRITE SCRNCLK
	JC	WDESER
	CALL	SWPSOU
	MOV	DX,OFFSET TCLKMSG
	CALL	PMSG			;SAY "TRANSFERRING CLK"
	MOV	DX,OFFSET CLKFCB
	CALL	READFIL			;READ CLK.COM
	JC	RHEPER
	CALL	SWPDES
	MOV	DX,OFFSET CLKFCB
	MOV	SI,OFFSET CLKNAM
	CALL	WRTFIL			;WRITE CLK.COM
	JC	WDESER
CHKAUTO:CMP	BYTE PTR AUTOFLG,0	;DO AUTOEXEC.BAT?
	JNZ	DOAUTO			;YES
	JMP	DONE			;ELSE, DONE
DOAUTO:	MOV	AL,DRIVE		;GET DRIVE
	SUB	AL,'@'			;REMOVE ASCII
	MOV	AUTOFCB,AL		;SET UP FOR READ
	CMP	BYTE PTR AUTOFLG,2	;CREATE AUTOEXEC?
	JZ	CRAUTO			;YES
	MOV	DX,OFFSET MAUTMSG
	CALL	PMSG			;SAY "MODIFYING AUTOEXEC"
	MOV	DX,OFFSET AUTOFCB
	CALL	READFIL			;READ AUTOEXEC
	JNC	CRAUTO1
	MOV	DX,OFFSET RAUTMSG
	CALL	PMSG			;ERROR READING AUTOEXEC
	INT	20H
CRAUTO:	MOV	DX,OFFSET CAUTMSG
	CALL	PMSG			;SAY "CREATING AUTOEXEC"
	MOV	DX,OFFSET AUTOFCB
	MOV	AH,11H
	INT	21H			;TRY TO OPEN AUTOEXEC.BAT
	OR	AL,AL
	JNZ	CRAUTO1			;NOT ONE THERE
	MOV	DX,OFFSET AUTXMSG
	CALL	PMSG			;SAY AUTOEXEC EXISTS
	CALL	AYN			;ASK TO DESTROY IT
	JC	CRAUTO1			;HE SAID YES
	MOV	DX,OFFSET AUTNMSG
	CALL	PMSG
	JMP	DONE
CRAUTO1:MOV	AX,6			;ASSUME DOING JUST HEPCAT
	MOV	DX,OFFSET HEPLINE
	CMP	BYTE PTR CLLFLG,1	;TEST FOR CLOCK
	JNZ	CRAUTO2			;NOT DOING IT
	MOV	DX,OFFSET CLKLINE	;ELSE, INCLUDE CLOCK LINE
	MOV	AX,15
CRAUTO2:CMP	BYTE PTR AUTOFLG,2	;JUST CREATING AUTOEXEC?
	JZ	CRAUTO3			;YES
	ADD	AX,2			;ELSE, ADD CR AND LF
	MOV	BX,AX			;SAVE COUNT IN BX
	ADD	AX,FILSIZE		;ADD FILE SIZE OF OLD AUTOEXEC
	PUSH	AX			;SAVE IT
	MOV	CX,FILSIZE		;GET FILE SIZE AGAIN
	MOV	DI,OFFSET BUFFER	;POINT TO BUFFER
	ADD	DI,CX			;MOVE TO END OF AUTOEXEC
	MOV	AL,0AH			;SEARCH FOR LF
	STD				;SEARCH BACKWARDS
	REPNZ	SCASB
	POP	AX			;RESTORE COUNT
	JNZ	CRAUTO3			;COULDN'T FIND ONE
	MOV	SI,CX			;COUNT TO SI
	MOV	CX,FILSIZE		;GET OLD FILE SIZE
	SUB	CX,SI			;REMOVE END COUNT
	ADD	DI,2			;POINT TO AFTER CRLF
	MOV	SI,DI			;IN SI
	PUSH	SI			;SAVE THIS ADDRESS
	MOV	DI,SI			;DI HERE, TOO
	ADD	DI,BX			;MOVE UP SIZE OF NEW STUFF
	ADD	SI,CX			;HAVE TO MOVE BACKWARDS
	ADD	DI,CX
	INC	CX			;FIX COUNT
	REP	MOVSB			;MOVE END UP
	CLD				;FIX FLAG
	POP	DI
	MOV	SI,DX			;GET NEW STUFF
	MOV	CX,BX			;SIZE OF IT
	REP	MOVSB			;MOVE IT IN PLACE
	MOV	DX,OFFSET BUFFER	;NOW, START WITH BUFFER
CRAUTO3:MOV	FILSIZE,AX		;UPDATE FILE SIZE
	MOV	AH,1AH
	CLD				;ENSURE FLAG FIXED
	INT	21H			;SET NEW DTA
	MOV	DX,OFFSET AUTOFCB
	CALL	OLDWRT			;WRITE NEW AUTOEXEC
	JNC	DONE
	JMP	WDESER			;ELSE, ERROR
DONE:	MOV	DX,OFFSET DNMSG
	CALL	PMSG			;SAY "DONE"
	INT	20H

;	PRINT MESSAGES

PMSG:	MOV	AH,9
	INT	21H
	RET

;	ASK Y OR N
;	SET CARRY IF Y

AYN:	MOV	DX,OFFSET YNMSG
	CALL	PMSG			;ASK Y OR N
	CALL	INPUT			;GET REPLY
	OR	CX,CX
	JZ	AYN
	MOV	AL,[SI]
	CALL	MUC			;CAPITALIZE ANSWER
	CMP	AL,'N'
	JZ	AYNX			;ANSWER IS N
	CMP	AL,'Y'
	JNZ	AYN			;BAD ANSWER
	STC				;MARK Y
AYNX:	RET

;	INPUT ROUTINE
;	INPUTS A STRING FROM THE USER
;	RETURNS WITH SI POINTING TO THE STRING, AND
;	CX WITH THE NUMBER OF CHARACTERS IN THE STRING.

INPUT:	MOV	SI,80H
	MOV	BYTE PTR [SI],80	;ALLOW 80 CHARACTERS
	MOV	DX,80H
	MOV	AH,0AH			;INPUT FUNCTION
	INT	21H			;GET THE INPUT
	INC	SI
	MOV	CL,[SI]			;GET COUNT
	MOV	CH,0			;IN CX
	MOV	BX,CX			;IN BX, TOO
	INC	SI			;POINT TO ENTRY
	MOV	BYTE PTR [SI+BX],0	;TERMINATE ENTRY
	CALL	SOS			;SKIP LEADING SPACES
	RET

;	SKIP SPACES IN STRING AT [SI]

SOS:	MOV	AL,[SI]			;GET A CHARACTER
	CMP	AL,' '			;SPACE?
	JNZ	SOSX			;NO
	INC	SI			;ELSE, BUMP POINTER
	LOOP	SOS			;TRY AGAIN
SOSX:	RET

;	MAP LOWER CASE TO UPPER

MUC:	CMP	AL,'a'			;LESS THAN "a"?
	JB	MUCX			;YES
	CMP	AL,'z'+1		;MORE THAN "z"?
	JNB	MUCX			;YES
	AND	AL,5FH			;ELSE, CAPITALIZE
MUCX:	RET

;	READ A FILE FROM THE HEPCAT DISK.  DX POINTS TO
;	FILE FCB

READFIL:MOV	AH,0FH
	INT	21H			;TRY TO OPEN FILE
	OR	AL,AL
	JNZ	READERR			;ERROR
	MOV	SI,DX			;POINT TO FCB
	MOV	AX,FSIZE[SI]		;GET FILE SIZE
	MOV	RSIZE[SI],AX		;SAVE AS RECORD SIZE
	MOV	FILSIZE,AX		;SAVE HERE, TOO
	MOV	AX,FDATE[SI]		;GET FILE DATE
	MOV	FILDATE,AX		;SAVE IT
	MOV	AX,FTIME[SI]		;GET FILE TIME
	MOV	FILTIME,AX		;SAVE IT
	MOV	AH,14H
	INT	21H			;READ FILE
	OR	AL,AL
	JNZ	READERR			;ERROR
	MOV	AH,10H
	INT	21H			;CLOSE FILE
	OR	AL,AL			;KILL ERROR
	RET
READERR:STC				;MARK ERROR
	RET

;	WRITE A FILE TO THE DESTINATION DISK.  DX POINTS TO
;	THE FILE FCB.  SI POINTS TO THE ASCIZ FILE NAME.

WRTFIL:	CMP	BYTE PTR DOSVER,2	;CHECK DOS VERSION
	JB	OLDWRT			;WRITE OLD WAY
	MOV	DI,PATHE		;ELSE, GET PATH END
	MOV	CX,12
	REP	MOVSB			;MOVE NAME TO PATH
	MOV	DX,OFFSET PATH		;POINT TO PATH
	MOV	AH,3CH
	INT	21H			;TRY TO CREATE FILE
	JC	WRTERR			;ERROR
	MOV	BX,AX			;HANDLE TO BX
	MOV	CX,FILSIZE		;GET FILE SIZE
	MOV	DX,OFFSET BUFFER	;DATA IS HERE
	MOV	AH,40H
	INT	21H			;WRITE FILE
	JC	WRTERR
	MOV	CX,FILTIME		;GET FILE TIME
	MOV	DX,FILDATE		;AND DATE
	MOV	AX,5701H
	INT	21H			;SET ORIGINAL DATE AND TIME
	MOV	AH,3EH
	INT	21H			;CLOSE FILE
	RET
WRTERR:	STC
	RET
OLDWRT:	MOV	DI,DX
	ADD	DI,12			;POINT TO AFTER FILE NAME
	MOV	CX,24
	MOV	AL,0
	REP	STOSB			;CLEAR AFTER NAME
	MOV	SI,DX			;POINT TO FCB
	MOV	AL,DRIVE
	SUB	AL,'@'
	MOV	[SI],AL			;SET UP DRIVE
	MOV	AH,16H
	INT	21H			;TRY TO CREATE FILE
	OR	AL,AL
	JNZ	WRTERR
	MOV	AX,FILSIZE		;GET FILE SIZE
	MOV	RSIZE[SI],AX		;MAKE IT RECORD SIZE
	MOV	AH,15H
	INT	21H			;WRITE TO FILE
	OR	AL,AL
	JNZ	WRTERR
	MOV	AX,FILDATE
	MOV	FDATE[SI],AX		;SET ORIGINAL DATE
	MOV	AX,FILTIME
	MOV	FTIME[SI],AX		;SET ORIGINAL TIME
	MOV	AH,10H
	INT	21H			;CLOSE FILE
	OR	AL,AL
	JNZ	WRTERR
	RET

;	PROMPT FOR DESTINATION SWAP, IF NECESSARY

SWPDES:	CMP	BYTE PTR SDFLG,1	;SAME DISK?
	JZ	SWPDES1			;YES
	RET				;ELSE, EXIT
SWPDES1:MOV	DX,OFFSET SWDMSG
	CALL	PMSG			;PROMPT FOR DEST. DISK
	CALL	INPUT			;WAIT FOR RETURN
	RET

;	PROMPT FOR SOURCE SWAP, IF NECESSARY

SWPSOU:	CMP	BYTE PTR SDFLG,1
	JZ	SWPSOU1			;SAME DISK
	RET
SWPSOU1:MOV	DX,OFFSET SWSMSG
	CALL	PMSG			;PROMPT FOR SOURCE DISK
	CALL	INPUT
	RET

DOSVER	DB	0
COMTYPE	DB	0
DRIVE	DB	0
CDRIVE	DB	0
SDFLG	DB	0			;SAME DRIVE FLAG
CLKFLG	DB	0			;INCLUDE SCRNCLK FLAG
CLLFLG	DB	0			;INCLUDE SCRNCLK LINE FLAG
AUTOFLG	DB	0			;AUTOEXEC MOD/CREATE FLAG
FILSIZE	DW	0			;SIZE OF FILE WE'RE WORKING WITH
FILDATE	DW	0			;DATE OF CURRENT FILE
FILTIME	DW	0			;TIME OF CURRENT FILE
PATH	DB	100 DUP (0)
PATHE	DW	0			;PATH END ADDRESS
HEPNAM	DB	'HEPCAT.COM',0
SETNAM	DB	'HEPSET.COM',0
SCLKNAM	DB	'SCRNCLK.COM',0
CLKNAM	DB	'CLK.COM',0
HEPFCB	DB	0,'HEPCAT  COM'
	DB	24 DUP (0)
SETFCB	DB	0,'HEPSET  COM'
	DB	24 DUP (0)
SCLKFCB	DB	0,'SCRNCLK COM'
	DB	24 DUP (0)
PCLKFCB	DB	0,'SCRNCLK POM'
	DB	24 DUP (0)
ZCLKFCB	DB	0,'SCRNCLK ZOM'
	DB	24 DUP (0)
CLKFCB	DB	0,'CLK     COM'
	DB	24 DUP (0)
ZHEPFCB	DB	0,'HEPCAT  ZOM'
	DB	24 DUP (0)
PHEPFCB	DB	0,'HEPCAT  POM'
	DB	24 DUP (0)
AUTOFCB	DB	0,'AUTOEXECBAT'
	DB	24 DUP (0)

SIGNON	DB	13,10,'HEPCAT Installation Utility version 1.0',13,10,10
	DB	'If you are unable to answer the questions asked by this',13,10
	DB	'program, exit by typing Control-C and consult your HEPCAT',13,10
	DB	'instruction manual.',13,10,10
	DB	'My sensors tell me that the computer you are using is',13,10
	DB	'$'
PCMSG	DB	'a PC-Compatible computer.$'
ZMSG	DB	'a Z-100 (not PC) computer.$'
CORMSG	DB	'  Is this correct?',13,10,'$'
WARNMSG	DB	13,10,10,'Warning!  You may be installing the wrong version'
	DB	13,10,'for your computer!$'
GHDMSG	DB	13,10,10,10,'Enter the drive$'
HPMSG	DB	'/path$'
GHDMSG1	DB	' where you wish to install HEPCAT.',13,10
	DB	'Press Return after your entry: $'
CLKMSG	DB	13,10,10,10,'Do you also want to install the HUG Screen Clock'
	DB	13,10,'at this time?',13,10,'$'
MODMSG	DB	13,10,10,10,'Do you want me to modify your AUTOEXEC.BAT so that'
	DB	13,10,'HEPCAT is loaded each time you boot?',13,10,'$'
YNMSG	DB	13,10,'Enter Y or N and press Return: $'
CRMSG	DB	13,10,10,10,'Do you want me to create a new AUTOEXEC.BAT so that'
	DB	13,10,'HEPCAT is loaded each time you boot?',13,10,'$'
INCMSG	DB	13,10,10,10,'Would you like to include a line in your '
	DB	'AUTOEXEC.BAT',13,10
	DB	'that will load the HUG Screen Clock?',13,10,'$'
THEPMSG	DB	13,10,10,'Transferring HEPCAT.COM...$'
TSETMSG	DB	13,10,10,'Transferring HEPSET.COM...$'
TSCKMSG	DB	13,10,10,'Transferring SCRNCLK.COM...$'
TCLKMSG	DB	13,10,10,'Transferring CLK.COM...$'
MAUTMSG	DB	13,10,10,'Modifying your AUTOEXEC.BAT...$'
CAUTMSG	DB	13,10,10,'Creating AUTOEXEC.BAT...$'
SWDMSG	DB	13,10,'Insert the destination disk, and hit Return.$'
SWSMSG	DB	13,10,'Insert the HEPCAT disk, and hit Return.$'
RHEPMSG	DB	13,10,10,'ERROR READING FROM HEPCAT DISK.',13,10,'$'
RAUTMSG	DB	13,10,10,'ERROR READING YOUR AUTOEXEC FILE.',13,10,'$'
WERMSG	DB	13,10,10,'ERROR WRITING TO DESTINATION DISK.',13,10,'$'
AUTXMSG	DB	13,10,10,'Warning!  You already have an AUTOEXEC.BAT file'
	DB	13,10,'on your disk.  If I create a new one, it will'
	DB	13,10,'destroy the old one.  Do you want me to go ahead?',13,10,'$'
AUTNMSG	DB	13,10,10,'A new AUTOEXEC.BAT was not created.$'
DNMSG	DB	13,10,10,'Installation completed.',13,10,'$'
CLKLINE	DB	'SCRNCLK',13,10
HEPLINE	DB	'HEPCAT',13,10
BUFFER	DB	0			;BUFFER STARTS HERE

CODE	ENDS
	END	START
