	PAGE	,132
;	CBEEP -- CONCURRENT BEEP ROUTINE.
;	THIS PROGRAM IS A SAMPLE TSR FOR PC-COMPATIBLES
;	THAT PROVIDES A CONCURRENT BEEP.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  18-SEP-87

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	JMP	SETUP			;INSTALL PROGRAM IN MEMORY

;	STORAGE AREA -- VECTORS AND FLAGS

INT10V	DW	0,0			;INT 10H VECTOR
INT1CV	DW	0,0			;INT 1CH VECTOR
BEEPFLG	DB	0			;BEEP PROGRESS FLAG
BEEPCNT	DB	0			;BEEP COUNTER

;	SCREEN INTERRUPT (INT 10H) PROCESSOR
;	DURING THIS INTERRUPT, WE CHECK FOR
;	THE COMMAND TO BEEP, AND JUST SET A FLAG
;	WHEN A BEEP IS REQUESTED.

SCREEN:	CMP	AX,0E07H		;TIME TO BEEP?
	JNZ	SCRNX			;NO
	MOV	CS:BEEPFLG,1		;ELSE, FLAG IT
	IRET				;SKIP NEXT PROCESS
SCRNX:	JMP	CS:DWORD PTR INT10V	;GO TO NEXT PROCESS

;	TIMER INTERRUPT (INT 1CH) PROCESSOR
;	DURING THIS INTERRUPT, WE MAKE THE BEEP
;	IF IT IS NEEDED.

TIMER:	PUSH	AX			;SAVE AX
	PUSH	DS			;AND DS
	MOV	AX,CS
	MOV	DS,AX			;PUT DS HERE
	MOV	AL,BEEPFLG		;GET BEEP FLAG
	CMP	AL,1			;TURN BEEP ON?
	JZ	BEEPON			;YES
	CMP	AL,2			;TIME BEEP?
	JZ	BEEPTIM			;YES
	JMP	TIMEX			;ELSE, EXIT
BEEPON:	INC	AL
	MOV	BEEPFLG,AL		;MARK BEEP ON
	CMP	BEEPCNT,0		;BEEP ALREADY ON?
	JNZ	CONBEEP			;IF SO, CONTINUE BEEP
	IN	AL,61H
	OR	AL,3
	OUT	61H,AL			;TURN ON SPEAKER
	MOV	AL,0B6H
	OUT	43H,AL			;CHANNEL 2, MODE 3
	MOV	AL,0C5H
	OUT	42H,AL			;LSB FOR 600 HZ
	MOV	AL,7
	OUT	42H,AL			;MSB FOR 600 HZ
CONBEEP:MOV	BEEPCNT,4		;SET BEEP COUNTER
	JMP	TIMEX			;DONE, EXIT
BEEPTIM:DEC	BEEPCNT			;DECREMENT BEEP COUNTER
	JNZ	TIMEX			;NOT DONE BEEPING, EXIT
	MOV	BEEPFLG,0		;ELSE, FLAG BEEP OFF
	IN	AL,61H
	AND	AL,0FCH
	OUT	61H,AL			;TURN SPEAKER OFF
TIMEX:	POP	DS			;RESTORE REGISTERS
	POP	AX
	JMP	CS:DWORD PTR INT1CV	;ELSE, PASS INTERRUPT ALONG

;	SET UP VECTORS AND EXIT WITH SOME OF THE
;	PROGRAM RESIDENT

SETUP:	MOV	AX,3510H		;FUNCTION 35H, INT 10H
	INT	21H			;GET INT 10H VECTOR
	MOV	INT10V,BX		;SAVE IT
	MOV	INT10V+2,ES
	MOV	AX,351CH
	INT	21H			;GET INT 1CH VECTOR
	MOV	INT1CV,BX		;SAVE IT
	MOV	INT1CV+2,ES
	MOV	AX,2510H		;FUNCTION 25H, INT 10H
	MOV	DX,OFFSET SCREEN	;POINT TO OUR PROCESS
	INT	21H			;INSTALL OUR VECTOR
	MOV	AX,251CH		;DO INT 1CH
	MOV	DX,OFFSET TIMER		;OUR TIMER PROCESS
	CLI				;KILL INTERRUPTS
	INT	21H			;INSTALL NEW TIMER VECTOR
	STI				;RESTORE INTERRUPTS
	MOV	DX,OFFSET SETUP		;SAVE ALL UP TO SETUP
	INT	27H			;EXIT AND STAY RESIDENT

CODE	ENDS
	END	START
