	PAGE	,132
;	KEYBOARD CLICKER FOR THE Z-171
;	THIS PROGRAM CAUSES A KEY CLICK FOR EACH KEY
;	INTERRUPT ON A Z-171.  AS ON OTHER ZDS SYSTEMS,
;	ALT-ESC CAN BE USED TO TOGGLE CLICKING OFF AND ON.

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	JMP	SETUP		;SET UP PROGRAM

KEYVEC	DD	0		;KEY INTERRUPT VECTOR
CLKFLG	DB	0		;CLICK ON/OFF FLAG
ALTUD	DB	0		;ALT UP/DN FLAG

;	PROCESS KEYBOARD INTERRUPTS HERE, AND MAKE A
;	CLICK FOR EACH ONE

CLICK:	PUSH	AX
	PUSH	CX
	IN	AL,60H		;READ KEYBOARD
	TEST	AL,80H		;KEY RELEASE?
	JNZ	CHKALT		;IF SO, CHECK FOR ALT UP
	CMP	AL,29		;CTRL KEY?
	JZ	NOCLICK		;NO CLICK IF SO
	CMP	AL,42		;LEFT SHIFT?
	JZ	NOCLICK
	CMP	AL,54		;RIGHT SHIFT?
	JZ	NOCLICK
	CMP	AL,56		;ALT?
	JZ	ALTDN		;IF SO, FLAG IT DOWN
	CMP	CS:CLKFLG,0	;CLICKING ON?
	JNZ	CHKESC		;NO, JUST CHECK FOR ESC
	PUSH	AX		;SAVE KEY
	IN	AL,61H		;READ CONTROL PORT
	AND	AL,0FEH		;TURN TIMER GATE OFF
	OR	AL,2		;SET SPEAKER ON BIT
	OUT	61H,AL		;TURN SPEAKER ON
	MOV	CX,40H		;CLICK DELAY
WAITLP:	LOOP	WAITLP		;WAIT A BIT
	AND	AL,0FDH		;RESET SPEAKER BIT
	OUT	61H,AL		;TURN SPEAKER OFF
	POP	AX		;GET KEY
CHKESC:	CMP	AL,1		;ESC KEY?
	JNZ	NOCLICK		;NO
	CMP	CS:ALTUD,56	;IS ALT KEY DOWN?
	JNZ	NOCLICK		;NO
	XOR	CS:CLKFLG,1	;ELSE, FLIP CLICK FLAG
NOCLICK:POP	CX
	POP	AX
	JMP	CS:DWORD PTR KEYVEC	;PROCESS KEY
CHKALT:	CMP	AL,56+80H	;ALT RELEASE?
	JNZ	NOCLICK		;NO
ALTDN:	MOV	CS:ALTUD,AL	;STORE ALT CONDITION
	JMP	NOCLICK
ENDRES:				;END OF RESIDENT CODE

;	SET UP KEYBOARD INTERRUPTS TO PASS THROUGH THIS
;	PROGRAM

SETUP:	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX		;POINT TO INT. VECTORS
	MOV	SI,9*4		;POINT TO KEY INT. VECTOR
	MOV	DI,OFFSET KEYVEC	;PUT VECTOR HERE
	PUSH	SI
	CLD
	MOVSW			;COPY VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET CLICK
	MOV	2[SI],CS	;PUT IN NEW VECTOR
	POP	DS
	MOV	DX,OFFSET ENDRES
	INT	27H		;TERMINATE, CODE RESIDENT

CODE	ENDS
	END	START
