	PAGE	,132
;	PROCAP -- PROTECT FOR THE CAPS LOCK KEY
;
;	THIS PROGRAM CAUSES THE CAPS LOCK KEY TO WORK
;	ONLY IF THE LEFT SHIFT KEY IS HELD DOWN WHILE
;	CAPS LOCK IS PRESSED.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  08-DEC-86

SHFCODE	EQU	42		;SCAN CODE FOR THE LEFT SHIFT KEY

;	NOTE: IF YOU WANT TO USE ANOTHER KEY INSTEAD OF
;	THE LEFT SHIFT KEY FOR ENABLING CAPS LOCK, HERE
;	ARE THE SCAN CODES OF SOME OTHER KEYS:
;
;	KEY		CODE
;
;	RIGHT SHIFT	54
;	CTRL		29
;	ALT		56
;
;	INSERT THE CODE YOU WANT IN THE SHFCODE DEFINITION ABOVE.

KEYDAT	EQU	60H		;KEYBOARD DATA PORT
KEYCON	EQU	61H		;KEYBOARD CONTROL PORT
PIC	EQU	20H		;INTERRUPT CONTROLLER PORT
EOI	EQU	20H		;END OF INTERRUPT COMMAND
KEYINT	EQU	9*4H		;KEYBOARD INTERRUPT VECTOR
BIOSSEG	EQU	40H		;BIOS RAM SEGMENT

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	JMP	SETUP		;SET UP THE PROGRAM

KEYVEC	DD	0		;KEYBOARD INTERRUPT VECTOR
SHFLG	DB	0		;SHIFT FLAG

;	KEYBOARD INTERRUPT PROCESSOR
;	HERE, WE INTERCEPT KEYBOARD INTERRUPTS, AND LOOK
;	FOR THE CAPS LOCK KEY BEING PRESSED.  IF IT IS
;	PRESSED, WE ABSORB IT UNLESS THE LEFT SHIFT KEY
;	IS ALSO DOWN.

KIP:	PUSH	AX
	IN	AL,KEYDAT	;GET CODE OF PRESSED KEY
	CMP	AL,58		;CAPS LOCK KEY?
	JZ	GOTCAP		;YES
	CMP	AL,SHFCODE	;LEFT SHIFT KEY?
	JNZ	CHLSU		;NO, CHECK FOR LEFT SHIFT UP
	MOV	CS:SHFLG,1	;ELSE, MARK LEFT SHIFT DOWN
	JMP	SHORT KIPX
CHLSU:	CMP	AL,SHFCODE+80H	;LEFT SHIFT UP?
	JNZ	KIPX		;NO
	MOV	CS:SHFLG,0	;ELSE, MARK LEFT SHIFT UP
KIPX:	POP	AX
	JMP	CS:DWORD PTR KEYVEC	;ELSE, EXIT
GOTCAP:	CMP	CS:SHFLG,1	;IS LEFT SHIFT DOWN?
	JZ	KIPX		;IF SO, LET CAPS LOCK WORK
	IN	AL,KEYCON	;ELSE, PREPARE TO ABSORB KEY
	OR	AL,80H
	OUT	KEYCON,AL
	AND	AL,7FH
	OUT	KEYCON,AL	;ABSORPTION DONE
	MOV	AL,EOI
	OUT	PIC,AL		;RESET INTERRUPT CONTROLLER
	POP	AX
	IRET			;RETURN FROM KEYBOARD INT.
ENDRES:				;END OF RESIDENT CODE

;	SET UP PROGRAM IN MEMORY

SETUP:	XOR	AX,AX
	MOV	DS,AX		;POINT TO INT. SEGMENT
	MOV	SI,OFFSET KEYINT	;POINT TO KEY INT.
	MOV	DI,OFFSET KEYVEC	;PUT IT HERE
	PUSH	SI
	CLD
	MOVSW			;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET KIP ;SET NEW VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS		;FIX DS
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H		;PRINT SIGN-ON MESSAGE
	MOV	DX,OFFSET ENDRES
	INT	27H		;EXIT, CODE RESIDENT

SIGNON	DB	13,10,'PROCAP installed, use Left Shift with Caps Lock.'
	DB	13,10,'$'

CODE	ENDS
	END	START
