
;
; DEFCHR - Definitions for the character devices (CON, AUX, and PRN)
;


;  Define functions of BIOS_CONFUNC, BIOS_PRNFUNC, and BIOS_AUXFUNC

CHR_WRITE	EQU 0		; Write function
CHR_READ	EQU CHR_WRITE+1	; Read function
CHR_STATUS	EQU CHR_READ+1	; Status function
  CHR_SFGS	  EQU 0		  ; Get status subfunction
    CHRS_WA	    EQU 00000001B   ; <ETX> sent, waiting for <ACK>
    CHRS_WD	    EQU 00000010B   ; <DC3> seen, waiting for <DC1>
    CHRS_SN         EQU 00000100B   ; Sending nulls
    CHRS_TXR        EQU 10000000B   ; Transmitter ready to send data
    CHRS_RXR	    EQU 01000000B   ; Receiver has data	
    CHRS_RXOF	    EQU 00100000B   ; Receiver queue overflow
    CHRS_RXE	    EQU 00010000B   ; Other type of reciver error
    CHRS_TXE	    EQU 00001000B   ; Transmitter error
  CHR_SFGC	  EQU CHR_SFGS+1  ; Get configuration info subfunction
CHR_CONTROL	EQU CHR_STATUS+1 ; Control function
  CHR_CFSU	  EQU 0		  ; Setup new configuration parms subfunction
  CHR_CFCI	  EQU CHR_CFSU+1  ; Clear input subfunction
  CHR_CFCO	  EQU CHR_CFCI+1  ; Clear output subfunction
CHR_LOOK	EQU CHR_CONTROL+1; Nondestructive read function
CHR_FMAX	EQU CHR_LOOK	; Maximum function number


; Configuration information packet

CHRD_CLASS	EQU 0		; Device class
  CHRDCL_CRT	  EQU 0		  ; Internal keyboard/display
  CHRDCL_SER	  EQU CHRDCL_CRT+1; 2661 serial port
  CHRDCL_PAR	  EQU CHRDCL_SER+1; PIA parallel port
  CHRDCL_MAX	  EQU CHRDCL_PAR  ; Maximum class value
CHRD_ATTR	EQU CHRD_CLASS+1 ; Attributes
  CHRDA_SPI	  EQU 00000001B	  ; Strip parity on input
  CHRDA_SPO	  EQU 00000010B	  ; Strip parity on output
  CHRDA_MLI	  EQU 00000100B	  ; Map lower to upper case on input
  CHRDA_MLO	  EQU 00001000B   ; Map lower to upper case on output

; The remaining fields are used only with the 2661 serial ports
;  (except CHRD_NCHR and CHRD_NCNT which can be used by para printer)

CHRD_PORT	EQU CHRD_ATTR+1	; Port number
CHRD_BAUD	EQU CHRD_PORT+2	; Baud rate
  BD455		  EQU 0		  ; 45.5
  BD050		  EQU 1		  ; 50
  BD075		  EQU 2		  ; 75
  BD110		  EQU 3		  ; 110
  BD134		  EQU 4		  ; 134.5
  BD150		  EQU 5		  ; 150
  BD300		  EQU 6		  ; 300
  BD600		  EQU 7		  ; 600
  BD120		  EQU 8		  ; 1200
  BD180		  EQU 9		  ; 1800
  BD200		  EQU 10	  ; 2000
  BD240		  EQU 11	  ; 2400
  BD480		  EQU 12	  ; 4800
  BD960		  EQU 13	  ; 9600
  BD192		  EQU 14	  ; 19200
  BD384		  EQU 15	  ; 38400
  BDMAX		  EQU BD384	  ; Maximum valid baud rate
CHRD_HSHK	EQU CHRD_BAUD+1	; Handshaking protocol
  CHRDH_NO	  EQU 0		  ; None
  CHRDH_EAH	  EQU CHRDH_NO+1  ; <ETX>/<ACK>
  CHRDH_DCH	  EQU CHRDH_EAH+1 ; <DC3>/<DC1> (CTRL-S/CTRL-Q)
  CHRDH_DCDH	  EQU CHRDH_DCH+1 ; DCD(data carrier detect) high
  CHRDH_DCDL	  EQU CHRDH_DCDH+1; DCD low
  CHRDH_DSRH	  EQU CHRDH_DCDL+1; DSR(data set ready) high
  CHRDH_DSRL      EQU CHRDH_DSRH+1; DSR low
  CHRDH_MAX	  EQU CHRDH_DSRL  ; Maximum valid value
CHRD_BCTL	EQU CHRD_HSHK+1	; Stop bits/parity/char length
				;   (2661 Mode register 1)
  CHRDB_SB	  EQU 11000000B	  ; Stop bits
    CHRDB_SB1	    EQU 040H	    ; 1 stop bit
    CHRDB_SB15	    EQU 080H        ; 1.5 stop bits
    CHRDB_SB2	    EQU 0C0H	    ; 2 stop bits
  CHRDB_PT	  EQU 00100000B	  ; Parity type(0=odd, 1=even)
  CHRDB_PC	  EQU 00010000B	  ; Parity contr(0=disabled, 1=enabled)
  CHRDB_CL	  EQU 00001100B   ; Character length
    CHRDB_CL5	    EQU 00H	    ; 5 bits
    CHRDB_CL6	    EQU 04H	    ; 6 bits
    CHRDB_CL7	    EQU 08H	    ; 7 bits
    CHRDB_CL8	    EQU 0CH	    ; 8 bits
CHRD_ECNT	EQU CHRD_BCTL+1	; If <ETX>/<ACK> used, chars to
				;   send before <ETX> sent
CHRD_NCNT	EQU CHRD_ECNT+1 ; Number of NULLs to send after
				;   CHRD_NCHR seen
CHRD_NCHR	EQU CHRD_NCNT+1 ; Character after which to send NULLs
CHRD_RES	EQU CHRD_NCHR+1 ; Reserved for future use
CHRD_SIZE	EQU CHRD_RES+6	; Size of a CHRD


; Error codes that are returned

CHRE_ILGFH	EQU 0		; Illegal function code in AH
CHRE_ILGFL	EQU CHRE_ILGFH+1; Illegal function code in AL
CHRE_NWR	EQU CHRE_ILGFL+1; No writes allowed to device
CHRE_NRD	EQU CHRE_NWR+1	; No reads allowed to device
CHRE_BSUP	EQU CHRE_NRD+1	; Bad set up parameters
CHRE_WRB	EQU CHRE_BSUP+1	; Device busy on write
CHRE_RDNR	EQU CHRE_WRB+1	; Device not ready on read
CHRE_HTO	EQU CHRE_RDNR+1	; Software handshake time out
CHRE_ILR	EQU CHRE_HTO+1	; Illegal responce from device
CHRE_IQE	EQU CHRE_ILR+1	; Input queue empty
CHRE_NIQ	EQU CHRE_IQE+1	; Device has no input queue


; Internal character device control table(It includes an embedded CHRD)

CID_CHRD	EQU 0		; A CHRD	
CID_CLASS	EQU CID_CHRD+CHRD_SIZE	; Class of character device
					;   (must be mult of 2)
  CIDCL_CRT	  EQU CHRDCL_CRT*2 ; Internal video/keyboard
  CIDCL_SER	  EQU CHRDCL_SER*2 ; 2661 serial port
  CIDCL_PAR	  EQU CHRDCL_PAR*2 ; PIA parallel port
CID_TYPE	EQU CID_CLASS+2	; Special types
  CIDTY_NORM	  EQU 0		   ; Normal type
  CIDTY_CSP	  EQU CIDTY_NORM+1 ; Special CRT
CID_IPORT	EQU CID_TYPE+2	; Input port
CID_OPORT	EQU CID_IPORT+2	; Output port
CID_SPORT	EQU CID_OPORT+2	; Status port
CID_CPORT	EQU CID_SPORT+2	; Control port
CID_ST		EQU CID_CPORT+2	; Status(see CHRD_SFGS for values)
CID_IRM		EQU CID_ST+1	; Input ready mask
CID_IPM		EQU CID_IRM+1	; Input polarity mask
CID_ORM		EQU CID_IPM+1	; Output ready mask
CID_OPM		EQU CID_ORM+1	; Output polarity mask
CID_ECTR	EQU CID_OPM+1	; Char counter for sending <ETX>
CID_NCTR	EQU CID_ECTR+1	; Null down counter
CID_SIZE	EQU CID_NCTR+1	; Size of the a CID 


;
; Define input queue for character devices
;

CQ_SADDR	EQU 0		; Addr of start of queue
CQ_EADDR	EQU CQ_SADDR+2	; Addr of end of queue
CQ_QSIZE	EQU CQ_EADDR+2	; Size of queue
CQ_ELMTS	EQU CQ_QSIZE+2	; Number of elements currently in queue
CQ_STATUS	EQU CQ_ELMTS+2	; Status (as defined under CHR_STATUS)
CQ_FRONT	EQU CQ_STATUS+1	; Addr of first element in queue
CQ_REAR		EQU CQ_FRONT+2	; Addr of last element in queue
CQ_SEGM		EQU CQ_REAR+2	; Segment of que
CQ_SIZE		EQU CQ_SEGM+2	; Size of a CQ

 	