 	page	 ,120
	title	GC1000 - H/Z100 Interface	V5.6

; Written Dec 02, 1983 by
; Jim Schuster
; 2804 Killarney Drive
; Cary, Illinois  60013

; This program is intended for use as an AUTOEXEC.BAT function to set the
; time/date at boot-up by reading the ASCII data from the GC1000 (mac) clock,
; and extracting the year from its own directory entry.  It may also be used
; as any other DOS command is used.

; One of two command lines are possible:
; GC1000             <-- reads the time & date. Uses the year from directory
; GC1000 1985        <-- reads time & date.  Sets the year in the directory.
;			 Also writes the time of this occurance in directory

; V5.0 Sept 22, 1984 -- gives conditional assembly for Port A or B;
; retrieves most recent year from directory entry for this GC1000.COM file.

; V5.3 Nov 21, 1984 -- added aux device configuration swapping
; V5.4 Dec 16, 1984 -- uses AUTO mode of GC1000. Eliminates direct port I/O.
; V5.5 - Documentation clarifications
; V5.6 - Fix bug in date modification code

FALSE	EQU	0
TRUE	EQU	NOT FALSE

PORT_A	EQU	TRUE		;false selects PORT_B

CMNDLINE	EQU	TRUE	;set to false to delete use of the command
;				line entry for updating the directory year.
;				Will then read the year from the GC1000.
		
; To select a baud rate of other than 9600, change the definition of
; "baud_rate" to ONE of the following, then re-assemble.  These definitions
; are found in the file "defchr.asm".
;
;	RATE		DEFINITION
;	9600		BD960	
;	4800		BD480
;	2400		BD240
;	1200		BD120
;	 600		BD600
;	 300		BD300
;	 150		BD150
;	 110		BD110

baud_rate	equ	BD960

; Configuration of serial port A or B is accomplished automatically.  The port
; used and the baud rate are selected at assembly time.  This program then
; controls the configuration requirements via BIOS and DOS system calls.  The
; DOS configuration program is not used to configure the port.  In fact, it
; cannot be used for this purpose.

; HARDWARE CONFIGURATION:

; GC1000	Serial port A (J1)
; pin 2 	pin 2
; pin 7 	pin 7

; GC1000	Serial port B  (J2)
; pin 2 	pin 3
; pin 7 	pin 7

; Note: With V5.4 & higher, pin 5 of the GC1000 need not be connected.

; The GC1000 is configured for 9600 baud, 1 stop bit, AUTO mode.

; DIP switch: 7 6 5 4 3 2 1 0
; set to:     1 1 1 1 0 0 0 1	
;	       \ \ \ \ \ \ \ \__Auto mode	
;		\ \ \ \_\_\_\__SET TO A LEAP YEAR, EXAMPLE 1984 !!!!
;		 \_\_\__9600 baud **SEE GC1000 MANUAL FOR OTHER RATES

; J401 - OPEN	(Except 110 baud.)

; The following commands will create the GC1000 program after it has been
; entered into the file GC1000.ASM using your favorite editor:
;	masm GC1000,,nul;
;	link GC1000;
;	exe2bin GC1000.exe.com
;	del GC1000.exe
;  The files "defms.asm" and "defchr.asm" are assumed on drive "B:".

; The GC1000 sends a 24 character ascii sequence consisting of the following:
; (example) 09:24:32.1 AM  11/27/83(cr), where the (cr) is a single hex 0D.
; This program then reads 24 charcters and tests the 24th character, which
; must be a (cr).  If this program recieves the (cr) before the 24th character, then
; the GC1000 is querried again.

; When the program has finally recieved a valid 24 character sequence, it is
; then converted into the DOS time and date formats.	The time
; is displayed in the format as recieved from the GC1000.  The current year
; is taken from the dirctory entry for this COM file.  The date is displayed,
; using a four digit format for the year.

; It should be noted that the GC1000 may be used in either 12 or 24 hour mode,
; and this program will convert the 12 hour mode reading into the required 24
; hour format.

; If you live in a weak reception area, and your GC1000 occassionally does not
; display the 1/10 second digit, it will also not send that digit to the
; computer.  The end result is that the DOS will not accept the time set.  If
; this should occur, this program will automatically set the 1/10 value
; to 0 and attempt to set the time again.

;included :defms.asm, defchr.asm

	.xlist
	include	b:defms.asm
	include b:defchr.asm
	.list

gc1000	segment
	assume	cs:gc1000, ss:gc1000, ds:gc1000, es:gc1000

	org	phd_codestart

start:

; sign on
	cld				;forward direction	
	mov	dx, offset msg_1	;say hello
	call	crlf

;Fetch the present definition of the aux port.  Save at old_info.

	mov	ax, chr_status * 256 + chr_sfgc
	mov	bx, offset old_info
	call	bios_auxfunc

;Now configure the aux port for the clock.  Port will be restored before
;program termination.

	mov	ax, chr_control * 256 + chr_cfsu
	mov	bx, offset new_info
	call	bios_auxfunc
	jnc	gc01                	;test for setup error
	jmp	gc21			;fatal error
gc01:	

	IF	CMNDLINE

;test for any command line parms in the form of a four digit year

	mov	si, [phd_dioa]		;pointer to command line
	lodsb				;get command line count into al
	or	al, al                  ;test for null command line
	jz	gc02                    ;command line is null

;Have a command line.
;If there is anything, treat it as a year entry and change the year in the
;directory entry.  This will be done after the time & date are read in.  For
;now, if it exists, read it in and save at cmnd_line_year.
;Due to self-imposed program space limitations, the command line must be
;entered only one way-- only one space followed by only a 4 digit year.
;There is no exception parsing code here: do it right or it will be ignored!

	mov	cl, al			;save the count
	dec	cl			;un-count the leading space
	cmp	cl, 4			;must have four left to be a year
	jnz	gc02

;process remaining as a year
	inc	si			;point to the year
	xor	ch, ch			;clear upper half of loop counter

;convert ASCII string in command line to BCD.
	push	si			;save this pointer

gc03:
	mov	al, [si]		;convert the ascii to bcd
	sub	al, '0'
	mov	[si], al
	inc	si
	loop	gc03
	pop	si			;restore pointer

;Now convert the BCD to a binary year and save it
	call	convert
	mov	ch, al			;the centuries
	call	convert
	mov	cl, al			;the decades

;multiply century by 100 and add to decade
	mov	al, ch
	xor	ah, ah
	mov	bl, 100
	mul	bl               	;(ax) = (al) * 100
	xor	ch, ch
	add	ax, cx
	mov	cmnd_line_year, ax	;save for later use

;At this point the command line has been parsed.
	ENDIF
;Read in the time & date from the GC1000.
; In the event of a read error, we will loop back to here.

gc02:
	mov	ax, chr_control * 256 + chr_cfci	;clear aux in buffer
	call	bios_auxfunc

	xor	cl, cl			;character counter
	mov	si, offset ascii_buffer	;ascii string storage
	mov	di, offset bcd_buffer	;bcd string storage

;Fetch a character.  Save in ASCII string storage.  Strip the ASCII value off
; and save in bcd storage.  The ASCII string will later be displayed; the BCD
; will be used to set the DOS time & date.
gc04:
	mov	ah, dosf_auxin
	int	dosi_func
 	and	al, 07fh		;strip off 8th bit
 	mov	[si], al		;save in ascii string storage
 	inc	si
 	inc	cl			;character counter
 	sub	al, 030h		;strip off ascii
	stosb				;save in bcd storage
	cmp	al, 0dh-30h		;check for end
	jne	gc04

	cmp	cl, 24			;must have 24 characters
	jne	gc07  			;not the right number -- repeat attempt

	mov	byte ptr [si], '$'

; convert time to DOS format

	mov	si, offset bcd_buffer
	call    convert			;get hours
	mov	ch, al			;put into ZDOS format
	mov	di, offset ascii_buffer + 11	;the location for the "A"
						; or "P" (blank if 24 hr mode)
	mov	al, [di]
	cmp	ch, 12			;test for AM/PM format and --
	jne	gc05  			;-- convert to 24 hour mode
	
	cmp	al, 'A'
	jne	gc06			;no change required

	sub	ch, 12		
	jmp	short gc06		;no change required
gc05:
	cmp	al, 'P'
	jne	gc06			;no change required
	add	ch, 12		

gc06:
	call    convert_si		;minutes from bcd_buffer+3
	mov	cl, al		

	call    convert_si		;seconds from bcd_buffer+6
	mov	dh, al

	inc	si			;1/10 second digit
	mov	ah, [si]
	mov	al, 0
	aad
	mov	dl, al

; Adjust time by one second to compensate for GC1000's delay in sending.  If
; the time rolls over to 24:00, then repeat to get the new date.
; No attempt is made to do this correction to the displayed time.
; The correct time is right there next to you--on the clock!

	add	dh, 1
	cmp	dh, 60
	jne	gc08			;adjustment is complete

	xor	dh, dh
	add	cl, 1
	cmp	cl, 60
	jne	gc08			;adjustment is complete

	xor	cl, cl
	add	ch, 1
	cmp	ch, 24
	jne	gc08			;adjustment is complete

;There is a problem with either the incomming data or the conversion of it.
;Display an appropriate message. Then try to re-read the clock.
gc07:
	mov	dx, offset msg_3
	call	crlf
	jmp	gc02

;All adjustments to the time have been accomplished.  Attempt to set the time.
;First try setting the time using the 1/10 second info from the clock.

gc08:              			;time is in cx:dx
        push	cx			;save the time
	push	dx
	mov	ah, dosf_stime		;Set the time
	int	dosi_func
	pop	dx			;restore the time
	pop	cx
	cmp	al, 0ffh		;test for time ok
	jne	gc09			;Time set acceptable

;The time did not set correctly.  In case it was due to an incorrect 1/10
; second digit, zero the 1/10 second digit and try again.
;The 1/10 second digit will display a '?' if this digit is wrong.

	xor	dl, dl			;the time was restored above
	mov	ah, dosf_stime
	int	dosi_func
	cmp	al, 0ffh
	jne	gc09			;if no problem

	mov	dx, offset msg_2
	jmp	gc17			;We tried!

;convert the date into DOS format

gc09:
	mov	si, offset bcd_buffer + 15
	call    convert		;month
	mov	dh, al

	call    convert_si		;return with al having the day

;On months with 30 days, the GC1000 has a small problem:  On the 30th, it
; reads out as the 00th of the following month ( 30 Nov = 00 Dec ).  The fix:

	cmp	al, 0			;day is in al
	jne	gc10			;no adjustment required
	mov	al, 30                  ;make it the 30th of...
	dec	dh			;...the previous month

gc10:
	mov	dl, al			;save the day!
	mov	day_save, dx            ;save month & day

	IF	CMNDLINE

;Test here for command line entry of a new year.  Set the year with it if
;present.
	mov	ax, cmnd_line_year	;if zero then none was entered
	push	ax			;save
	or	al, ah			;test for zero
	pop	ax                      ;restore
	jz	gc11			;none entered

	mov	year_save, ax		;stick it here
	jmp	short gc13		;no command line entry - use clock year

; Will use year from disk if it can be found, or from the clock.  There was
;no command line entry.

gc11:

	ENDIF

	call	convert_si		;year-- we use this only if we later on
	mov	cl, al			; cant read it in from the disk
	xor	ch, ch
	add	cx, 1900
	mov	year_save, cx

	IF	CMNDLINE

; Attempt to get the year from the FCB of (default drive):GC1000.COM

	mov	dx, offset fcb_1
	mov	ah, dosf_opfile
	int	dosi_func		;open file
	cmp	al, 0ffh
	jne	gc12			;file exists - try to use it's date

	mov	dx, offset msg_7	;cant open GC1000.COM
	call	crlf
	jmp	short gc13		;must use clock's date


;first close file so this doesn't cause problems later

gc12:
	mov	dx, offset fcb_1
	mov	ah, dosf_clfile
	int	dosi_func

	mov	di, offset fcb_1 + fcb_date
	mov	ax, [di]		;get date into ax
	mov	al, ah                  ;isolate the year
	shr	al, 1
	and	al, 07fh
	mov	cl, al

	xor	ch, ch
	add	cx, 1980		;correction factor
	mov	year_save, cx		;This is the year from the directory


; Before we use the clock date, it must be converted according to whether or
;    not it is a leap year.
; The algorithm in pseudo-code:
;    if (not_a_leap_year)  then
;      if (month = 1) skip this code (V5.6)
;      if (month = 2 and day = 29) then month = 3 & day = 1 (V5.6)
;	if (month >= 2 and day < max) increment the day
;	else increment the month, set day = 1.
;		Where "max" is the value from the "day_table", found elsewhere
;		in this program.
;This entire scheme relies on the GC1000 being set for a leap year (1984).

gc13:
	mov	ax, year_save
	mov	dx, 0			;test for leap year
	mov	bx, 4
	div	bx			;remainder in ah
	or	dx, dx		;if any remainder, then is NOT a leap year
	jz	gc15			;no change required

	mov	cx, day_save		;ch has month, cl has day
;** start of V5.6 fix
	cmp	ch, 1			;skip if month = Jan
	je	gc15
	cmp	ch, 2
	jne	gc23
	cmp	cl, 29
	jne	gc15
	mov	cx, 3 * 256 + 1		;month = Mar, day = 1
	jmp	short gc14
gc23:
;** end of V5.6 fix
	
	inc	cl			;adjust for non-leap year
	mov	bl, ch
	xor	bh, bh
	mov	di, bx
	mov	al, day_table[di]	;get table value for month
	cmp	cl, al			;table value vs. day
	jbe	gc14			;value is OK

	inc	ch			;next month
	mov	cl, 1                   ;first of month

gc14:
	mov	day_save, cx		;might be needed later

gc15:
	ENDIF

;Get the (possibily modified) date.  Then set the date using the DOS function.

	mov	cx, year_save		;restore year
	mov	dx, day_save		;restore day and month
	mov	ah, dosf_sdate
	int	dosi_func
	cmp	al, 0ffh
	jne	gc16

	mov	dx, offset msg_2A		;Can't set the date.
	jmp     short gc17

;First reconvert day_save & year_save to a ASCII string.  Then print out.
;Zero the date string area with ASCII '0'

gc16:
	mov	di, offset ascii_buffer + 15
	mov	cx, 10				;install 10 0's
	mov	al, '0'
	rep	stosb
	push	di				;save pointer (its at the
						;end of the date location)
	mov	al, 0dh				;RETURN
	stosb
	mov	al, 0ah                         ;line feed
	stosb
	mov	al, '$'				;line terminator
	stosb
	pop	di
	dec	di
	mov	ax, year_save			;convert the year
	call	bin_to_ascii
	mov	byte ptr [di], '/'
	dec	di
	mov	ax, day_save
	xor	ah, ah				;zero the month
	call	bin_to_ascii                    ;convert the day
	mov	byte ptr [di], '/'
	dec	di
	mov	ax, day_save
	xor	al, al                          ;zero the day
	xchg	al, ah                          ;convert the month
	call	bin_to_ascii

	mov	dx, offset ascii_buffer           ;print the string
gc17:
	call	crlf
gc18:
        IF	CMNDLINE
;Now see if we need to write a new year on disk.
	mov	ax, cmnd_line_year 	;if this is zero, then do nothing
	or	al, ah
	jz	gc20         		;all done

;Yes, new year is needed.  Watch carefully:
; 1.  Get the size of this COM file.
; 2.  Open file.
; 3.  Random block write with length of cx=0.
; 4.  Close file.
;Viola!  New year in GC1000.COM directory entry!
; (Actually, the directory entry has both a new time & date.)

	mov	dx, offset fcb_1	;point to fcb & get the size
	push	dx
	push	dx			;make a few copies of the pointer
	push	dx
	mov	di, offset fcb_1 + fcb_curblk	;clear the fcb for re-use
	mov	cx, fcb_size - fcb_curblk + 1
	xor	al, al
	rep	stosb

	mov	ah, dosf_gfsize
	int	dosi_func
	cmp	al, 0ffh
	jz	gc19     		;no file				

	pop	dx			;the fcb_1
	mov	ah, dosf_opfile		;open
	int	dosi_func
	cmp	al, 0ffh
	jz	gc19                    ;can't open

	pop	dx
	mov	ah, dosf_rblwrite	;random block write
	mov	cx, 0			;as promised-- no length
	int	dosi_func
	cmp	al, 0                   ;test for ok
	jnz	gc19

	pop	dx
	mov	ah, dosf_clfile
	int	dosi_func
	cmp	al, 0ffh
	jnz	gc20                    ;if ok

gc19:
	mov	dx, offset msg_6        ;GC1000.COM, where are you??
	call	crlf

	ENDIF

;Restore the aux port configuration to its introductory state.
gc20:
	mov	ax, chr_control * 256 + chr_cfsu
	mov	bx, offset old_info
	call	bios_auxfunc
	jnc	gc22

;A fatal error occured.  Exit here.
gc21:		
	mov	dx, offset msg_5
	call	crlf

; All done. Bye, bye!
gc22:
	int	dosi_term	;back to system

;
; subroutine to convert bcd WORD at si into binary BYTE in al.
; uses si, ax
;

convert_si:
	inc	si			;skip the punctuation byte

convert:				;convert bcd to binary
	lodsw				;get bcd word
	xchg	al, ah			;reverse
	aad				;convert
	ret

;
;subroutine to convert binary in ax to ascii at [di]

;entry:	ax has binary value (to be converted into as many digits as needed)
;	di points to area for saving ASCII character

;exit:	
;	di decremented to point to the character space just before the
;		last converted character
;	bx = 10; dl = '0', dh = 0

;uses:	di, bx, dx
;

bin_to_ascii:
	push	ax
	mov	bx, 10			;divide by 10
bin_to_ascii_loop:
	xor	dx, dx
	div	bx
	add	dx, '0'
	mov	[di], dl	
	dec	di
	or	ax, ax
	jnz	bin_to_ascii_loop
        pop	ax
	cmp	ax, 10
	jge	bin_exit
	dec	di			;adjust for small values
bin_exit:
	ret
;
; subroutine to print a message on crt
;
crlf:
	push	dx			;save message address
	mov	dx, offset msg_4	;print a cr-lf first
	call	crlf_1
	pop	dx			;restore msg address
crlf_1:
	mov	ah, dosf_outstr
	int	dosi_func		;print message
	ret

;
;
;

msg_1	db	'GC-1000 Interface, V5.6',0dh,0ah,'Wait ~1 second...$'

msg_2	db	7,'DOS time set error.  Check the GC1000.$'
msg_2A	db	7,'DOS date set error.  Check the GC1000.$'

msg_3	db	'Cant understand the GC1000.  Will try again.$'

msg_4	db	0dh,0ah,'$'

msg_5	db	7,'Attempted invalid aux configuration.$'

year_save	dw	0	
day_save	dw	0

		IF	CMNDLINE

cmnd_line_year	dw	0	;initially false, make true by inserting
				; non-zero year
	
fcb_1		db	0,'GC1000',20h,20h,'COM'        ;default drive
fcb_zero_len	equ	fcb_size - fcb_curblk + 1
		db	fcb_zero_len dup (0)

;This table is for a NON-leap year.  So that the algorithm may work,
; December is set to 32.

day_table	db	0,31,28,31,30,31,30,31,31,30,31,30,32

msg_6	db	7,'Cant change the date on disk.$'

msg_7	db	7,'Cant open file GC1000.COM.  Will use year from'
	db	' GC1000.$'

		ENDIF

new_info:	;table set up with GC1000 communications info
		db	chrdcl_ser		;2661 serial port
		db	0			;attributes
	
		IF	PORT_A	
                db      0E8H
		ELSE
		db	0ECH
		ENDIF
	
		db	0
                db	baud_rate
		db	chrdh_no        	;handshake protocol
		db	chrdb_sb1 + chrdb_cl8	;1 stop bit + 8 bit words
		db	0,0, 0dh
		db	(chrd_size - ($ - new_info)) dup (0)

old_info	equ	$
ascii_buffer	equ	old_info + chrd_size
bcd_buffer	equ	ascii_buffer + 25

gc1000	ends

	end	start
