	PAGE	,132
;	CURSOR CONTROL PROGRAM FOR LAPTOP COMPUTERS.
;	THIS PROGRAM ALLOWS YOU TO SET THE CURSOR TO A
;	BLOCK CURSOR, A NON-BLINKING BLOCK CURSOR, OR A
;	NORMAL CURSOR.
;
;	TO USE THIS PROGRAM, ENTER
;
;	CURSOR N		TO SET A NON-BLINKING CURSOR
;	CURSOR B		TO SET A BIG CURSOR
;	CURSOR S		TO SET A SLOW BLINKING BIG CURSOR
;	CURSOR D		TO DISABLE CURSOR.COM
;	CURSOR U		TO UNLOAD THE PROGRAM FROM MEMORY
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  28-APR-89  22-MAY-89
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1989.  ALL RIGHTS RESERVED.

CURCOL	EQU	0F8H		;CURSOR COLOR (DARK GRAY ON BLINKING WHITE)

;	BIOS RAM LOCATIONS

BIOS	SEGMENT AT 40H
	ORG	49H
MODE	LABEL	BYTE			;CURRENT VIDEO MODE
	ORG	4AH
COLS	LABEL	BYTE			;COLUMNS/LINE
	ORG	4EH
PGOFF	LABEL	WORD			;PAGE OFFSET
	ORG	50H
CURPOS	LABEL	WORD			;CURSOR POSITION
	ORG	60H
CURTYP	LABEL	WORD			;CURSOR TYPE
	ORG	62H
PAGENO	LABEL	BYTE			;CURRENT PAGE NUMBER
	ORG	63H
VPORT	LABEL	WORD			;BASE VIDEO PORT
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	DEFINE SOME MEMORY LOCATIONS

	ORG	1
PSPSEG	LABEL	WORD			;PROGRAM SEGMENT PREFIX SEGMENT ADDR.
	ORG	3
MCBSIZE	LABEL	WORD			;MEMORY CONTROL BLOCK SIZE
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	5DH
FCBN	LABEL	BYTE			;DEFINE FCB NAME
	ORG	6DH
FCBN2	LABEL	BYTE			;FCB NAME 2
	ORG	100H

START:	JMP	SETUP			;GO SET UP PROGRAM
	EVEN
SIG	DB	'CURSOR 1.0'		;PROGRAM SIGNATURE
INT10V	DW	0,0			;INT 10H VECTOR
INT1CV	DW	0,0			;INT 1CH VECTOR
INT28V	DW	0,0			;INT 28H VECTOR
DCFLG	DW	0,0			;DOS CRITICAL FLAG ADDRESS
ENFLG	DB	0			;ENABLE FLAG
TIMFLG	DB	0			;TIMER INTERRUPT FLAG
OLDCP	DW	0			;OLD CURSOR POSITION FLAG
OLDAT	DB	0			;OLD ATTRIBUTE

;	TIMER INTERRUPT PROCESSOR.  DURING TIMER
;	INTERRUPTS, WE TURN MAINTAIN THE NON-BLINKING
;	CURSOR, AND THE BLINKING BLOCK CURSORS IF THE
;	TIMER INTERRUPT FLAG IS SET.

INT1C:	CMP	CS:TIMFLG-0C0H,1	;TIMER INTERRUPT ON?
	JZ	INT1C1
	CMP	CS:ENFLG-0C0H,3		;NON-BLINKING CURSOR?
	JZ	INT1C2			;YES
INT1CX:	JMP	CS:DWORD PTR INT1CV-0C0H	;GO TO OTHER PROCESSES
INT1C2:	PUSH	BX
	PUSH	DS
	MOV	BX,CS:DCFLG-0C0H	;GET DOS CRITICAL FLAG ADDRESS
	MOV	DS,CS:DCFLG-0BEH
	CMP	BYTE PTR [BX],0		;IS DOS CRITICAL?
	POP	DS
	POP	BX
	JNZ	INT1CX
	CALL	CURSOR			;MAKE CURSOR
	JMP	INT1CX
INT1C1:	PUSH	AX
	PUSH	DX
	PUSH	DS
	MOV	AX,BIOS
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	MOV	AH,BYTE PTR CURTYP+1	;GET CURSOR TOP
	CMP	AH,0			;BLOCK CURSOR?
	JZ	INT1C1A
	CMP	AH,20H			;CURSOR TURNED OFF
	JZ	INT1C1X			;YES
	CMP	AH,5			;IS CURSOR LARGE?
	JB	INT1C1A			;YES
	MOV	AH,2			;ELSE, CURSOR START IS 2
INT1C1A:MOV	DX,VPORT		;ELSE, GET VIDEO PORT
	MOV	AL,10
	OUT	DX,AL			;SELECT CURSOR START REGISTER
	INC	DX
	MOV	AL,AH
	CMP	CS:ENFLG-0C0H,2		;SLOW CURSOR SET?
	JNZ	INT1C1B			;NO
	OR	AL,60H			;ELSE, SET SLOW MODE
INT1C1B:OUT	DX,AL			;SET MODIFIED BLOCK CURSOR
INT1C1X:POP	DS
	ASSUME	DS:CODE
	POP	DX
	POP	AX
	JMP	CS:DWORD PTR INT1CV-0C0H

;	NON-BLINKING BLOCK CURSOR UPDATE PROCESSOR

CURSOR:	PUSH	AX			;SAVE REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	MOV	AX,BIOS
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	MOV	CH,MODE			;GET VIDEO MODE
;;	MOV	DX,VPORT		;GET VIDEO PORT
;	CMP	CH,7			;MONOCHROME CARD MODE?
;	JZ	MODEOK			;THAT'S OK
	CMP	CH,4			;IN A GRAPHIC MODE?
	JB	MODEOK
	JMP	CUREX			;IF SO, EXIT
MODEOK:	;CMP	CS:EGAFLG,1		;EGA CARD?
;	JZ	GOTEGA			;YES
;;	MOV	AL,10			;CURSOR START REGISTER
;;	OUT	DX,AL			;SELECT IT
;;	INC	DX			;MOVE TO DATA PORT
;;	MOV	AL,20H
;;	OUT	DX,AL			;TURN OFF REAL CURSOR  3   3                     
;	JMP	SHORT DOBCUR		;DO BLOCK CURSOR
GOTEGA:	;MOV	AH,1
;	MOV	CX,2007H
;	MOV	BX,CURTYP		;SAVE CURRENT CURSOR TYPE
;	PUSHF
;	CALL	CS:DWORD PTR INT10V	;EGA, LET BIOS TURN CURSOR OFF
;	MOV	CURTYP,BX		;RESTORE CURSOR TYPE
DOBCUR:	MOV	CL,BYTE PTR CURTYP+1	;GET CURSOR TYPE HIGH
	MOV	AL,PAGENO		;GET VIDEO PAGE
	CBW				;MAKE IT A WORD
	MOV	BX,OFFSET CURPOS
	ADD	BX,AX			;POINT TO CURSOR POSITION
	MOV	AX,[BX]			;GET IT
	MOV	DL,AL			;SAVE COLUMN
	MOV	AL,AH			;ROW TO AL
	MUL	COLS			;MULTIPLY BY COLLUMNS/LINE
	XOR	DH,DH			;DX = COLUMN
	ADD	DX,AX			;DX = ABS. CURSOR POSITION
	SHL	DX,1			;DX = CURSOR ADDRESS
	ADD	DX,PGOFF		;ADD PAGE OFFSET
	INC	DX			;MOVE TO ATTRIBUTE BYTE
	MOV	AX,0B800H		;ASSUME CGA
;	CMP	CH,7			;MONOCHROME CARD?
;	JNZ	CGA			;NO, CGA
;	MOV	AX,0B000H		;ELSE USE MONOCHROME ADDRESS
CGA:	MOV	DS,AX			;POINT TO VIDEO RAM
	MOV	BX,CS:OLDCP-0C0H	;GET OLD CURSOR POSITION
	MOV	AL,CURCOL		;GET CURSOR ATTRIBUTE
	CMP	AL,[BX]			;CURSOR ON?
	JZ	TCOFF			;YES, TURN OFF
	SUB	BX,160			;TRY LINE ABOVE
	JB	LINE1			;ON LINE 1
	CMP	AL,[BX]			;CHECK CHARACTER
	JZ	TCOFF			;CURSOR WAS ON
LINE1:	ADD	BX,160*2		;MOVE TO LINE BELOW
	CMP	AL,[BX]			;CURSOR ON?
	JNZ	NOCUR			;NO
TCOFF:	MOV	AL,CS:OLDAT-0C0H	;GET OLD ATTRIBUTE
	MOV	[BX],AL			;TURN OFF CURSOR
NOCUR:	TEST	CL,20H			;CURSOR OFF?
	JNZ	CUREX			;IF SO, EXIT
	MOV	BX,DX			;GET NEW CURSOR POSITION
	MOV	AL,[BX]			;GET ATTRIBUTE
	MOV	CS:OLDAT-0C0H,AL	;SAVE IT
	MOV	CS:OLDCP-0C0H,BX	;AND OLD POSITION
	MOV	BYTE PTR [BX],CURCOL	;TURN CURSOR ON
CUREX:	POP	DS			;RESTORE REGISTERS
	ASSUME	DS:CODE
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	SCREEN INTERRUPT PROCESSOR.  CURSOR CALLS ARE CHECKED
;	AND MODIFIED AS NECESSARY.  3   3                     

INT10:	PUSH	AX
	MOV	AL,CS:ENFLG-0C0H
	CMP	AL,3			;NON-BLINKING CURSOR?
	JNZ	CHK1			;NO, CHECK FOR BLOCK
	POP	AX
	PUSHF				;PREPARE FOR IRET
	CALL	CS:DWORD PTR INT10V-0C0H	;PERFORM SCREEN FUNCTION
	CLI
	CALL	CURSOR			;UPDATE CURSOR
	STI
	IRET
CHK1:	CMP	AL,1			;BIG CURSOR ON?
	JZ	INT10A
	CMP	AL,2
	JNZ	VIPX			;IF NOT, NO PROCESSING HERE
INT10A:	CMP	AH,0			;SETTING VIDEO MODE?
	JZ	SETMOD			;YES
	CMP	AH,1			;SET CURSOR TYPE?
	JZ	SETCT			;YES
VIPX:	POP	AX
	JMP	CS:DWORD PTR INT10V-0C0H	;ELSE, EXIT
SETCT:	CMP	CH,20H			;TURN CURSOR OFF?
	JZ	VIPX			;YES
	PUSH	BX
	MOV	BX,CX			;SAVE CURSOR TYPE
	CMP	CH,5			;SET LARGE CURSOR?
	JB	SETCT1			;YES
	MOV	CH,2			;MODIFY CURSOR
SETCT1:	CMP	CS:ENFLG-0C0H,2		;MODIFY BLINKING RATE?
	JNZ	SETCT2			;NO
	OR	CH,60H			;ELSE, FLAG SLOW BLINKING
SETCT2:	PUSHF
	CALL	CS:DWORD PTR INT10V-0C0H	;SET NEW CURSOR TYPE
	PUSH	DS
	MOV	AX,40H
	MOV	DS,AX
	ASSUME	DS:BIOS
	MOV	CURTYP,BX		;SET TYPE TO WHAT WAS WANTED
	POP	DS
	ASSUME	DS:CODE
	MOV	CX,BX			;RESTORE TYPE IN CX
	POP	BX
	POP	AX
	IRET
SETMOD:	POP	AX
	PUSHF
	CALL	CS:DWORD PTR INT10V-0C0H	;SET MODE
	PUSH	AX
	PUSH	CX
	MOV	AH,1
	MOV	CX,607H
	STI
	INT	10H			;FIX CURSOR
	POP	CX
	POP	AX
	IRET

;	INT 28H PROCESSOR.  USED FOR UN-INSTALLING CURSOR.

INT28:	CMP	CS:ENFLG-0C0H,4		;UN-INSTALL CURSOR?
	JZ	UNINS			;YES
	JMP	CS:DWORD PTR INT28V-0C0H	;ELSE, EXIT
UNINS:	PUSH	CS
	POP	DS			;POINT TO THIS SEGMENT
	XOR	AX,AX
	MOV	ES,AX			;AND TO INT. SEGMENT
	MOV	SI,OFFSET INT10V-0C0H	;POINT TO INT 10 VECTOR
	MOV	DI,10H*4		;WHERE IT GOES
	CLD
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET INT1CV-0C0H	;POINT TO INT 1C VECTOR
	MOV	DI,1CH*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET INT28V-0C0H	;POINT TO INT 28 VECTOR
	MOV	DI,28H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	AH,49H
	INT	21H			;RELEASE THIS PROGRAM'S MEMORY
	MOV	ES,ENVSEG		;POINT TO ENVIRONMENT SEGMENT
	MOV	AH,49H
	INT	21H			;RELEASE ENVIRONMENT SEGMENT
	STI				;ENABLE INTERRUPTS
	INT	20H			;EXIT
ENDRES:

;	SET UP PROGRAM

SETUP:	MOV	AL,FCBN			;GET FCB NAME CHARACTER
	MOV	FCBARG,AL		;SAVE IT
	MOV	AL,FCBN2
	MOV	FCBARG2,AL		;SAVE SECOND ONE, TOO
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	CALL	PROARG			;TEST ARGUMENT
	JZ	SETUP1			;IT'S GOOD, PROCEED
	MOV	DX,OFFSET HLPMSG
	MOV	AH,9
	INT	21H			;PRINT HELP MSG
	INT	20H			;AND EXIT
SETUP1:	MOV	AH,34H
	INT	21H			;GET DOS CRITICAL FLAG ADDRESS
	MOV	DCFLG,BX		;SAVE IT
	MOV	DCFLG+2,ES
	MOV	AH,52H
	INT	21H			;GET MEMORY CONTROL BLOCK ADDR.
	MOV	AX,ES:[BX-2]		;GET FIRST MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
FNDLP:	MOV	AX,PSPSEG		;GET PSP SEGMENT
	MOV	DX,CS
	CMP	AX,DX			;IN THIS SEGMENT?
	JAE	CHKFND			;IF SO, CHECK IF CURSOR FOUND
	MOV	ES,AX			;ELSE, PSP SEGMENT TO ES
	MOV	SI,OFFSET SIG
	MOV	DI,SI
	SUB	DI,0C0H			;PROGRAM IS MOVED DOWN
	PUSH	DS			;SAVE MCB SEGMENT
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	CX,5			;5 WORDS IN SIGNATURE
	REPZ	CMPSW			;IS CURSOR HERE?
	JZ	GOTCC			;WE FOUND CURSOR
	MOV	LSTSEG,ES		;SAVE PSP SEGMENT
FNDNXT:	POP	DS			;RESTORE MCB SEGMENT
	MOV	AX,MCBSIZE		;GET MCB SIZE
	INC	AX			;CORRECT IT
	MOV	BX,DS
	ADD	AX,BX			;CALCULATE NEXT MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
	JMP	FNDLP			;TRY AGAIN
GOTCC:	MOV	FNDSEG,ES		;SAVE SEGMENT WHERE FOUND
	MOV	BYTE PTR FNDFLG,1	;MARK PROGRAM FOUND
	JMP	FNDNXT
CHKFND:	PUSH	CS
	POP	DS			;FIX DS
	CMP	BYTE PTR FNDFLG,1	;WAS CURSOR FOUND?
	JNZ	NOTFND			;NO
	MOV	ES,FNDSEG		;GET SEGMENT WHERE FOUND
	CALL	PROARG			;PROCESS USER ARGUMENT
	CMP	FCBARG,'U'		;UNINSTALL?
	JNZ	SETFLG			;NO, CONTROL CURSOR
	MOV	BX,FNDSEG		;GET SEGMENT WHERE FOUND
	CMP	BX,LSTSEG		;COMPARE WITH LAST PSP FOUND
	JNC	SETFLG			;OK TO UNLOAD
	MOV	DX,OFFSET NOUNMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "CAN'T UNLOAD"
	INT	20H
SETFLG:	MOV	AH,9
	INT	21H			;PRINT APPROPRIATE MSG
	CALL	SETNEW			;SET NEW CURSOR TYPE
	INT	20H			;AND EXIT
NOTFND:	CMP	FCBARG,'U'		;UNINSTALL?
	JNZ	DOINS			;NO
	MOV	DX,OFFSET NINMSG
	MOV	AH,9
	INT	21H			;SAY "NOT INSTALLED"
	INT	20H
DOINS:	PUSH	CS
	POP	ES			;FIX ES
	MOV	SI,OFFSET START		;POINT TO START OF PROGRAM
	MOV	DI,40H			;PUT IT HERE
	MOV	CX,ENDRES-START		;SIZE OF PROGRAM
	CLD
	REP	MOVSB			;MOVE PROGRAM DOWN
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INT. PAGE
	MOV	SI,OFFSET 10H*4		;POINT TO INT 10 VECTOR
	MOV	DI,OFFSET INT10V-0C0H	;PUT IT HERE
	PUSH	SI
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET INT10-0C0H	;SET NEW VECTOR
	MOV	2[SI],CS
	MOV	SI,OFFSET 1CH*4		;POINT TO INT 1C VECTOR
	MOV	DI,OFFSET INT1CV-0C0H	;PUT IT HERE
	PUSH	SI
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	CLI
	MOV	WORD PTR [SI],OFFSET INT1C-0C0H	;SET NEW VECTOR
	MOV	2[SI],CS
	STI
	MOV	SI,OFFSET 28H*4		;POINT TO INT 28 VECTOR
	MOV	DI,OFFSET INT28V-0C0H	;PUT IT HERE
	PUSH	SI
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET INT28-0C0H	;SET NEW VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;FIX DS
	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;PRINT INSTALLATION MSG
	CALL	PROARG			;PROCESS USER ARGUMENT
	MOV	AH,9
	INT	21H			;SHOW CURSOR CONDITION
	CALL	SETNEW			;SET NEW CURSOR TYPE
NOTDIS:	MOV	DX,OFFSET ENDRES-0C0H
	INT	27H			;EXIT WITH CURSOR RESIDENT

;	PROCESS USER ARGUMENT

PROARG:	MOV	AL,FCBARG		;GET ARGUMENT
SETSTC:	XOR	CL,CL			;ASSUME STANDARD CURSOR
	MOV	DX,OFFSET ORGMSG
	CMP	AL,'D'			;DISABLE CURSOR?
	JZ	PROARX			;YES
	INC	CL			;ASSUME BLOCK
	MOV	DX,OFFSET BLKMSG
	CMP	AL,'B'			;BIG?
	JZ	PROARX
	INC	CL			;ASSUME SLOW BIG
	MOV	DX,OFFSET SLOMSG
	CMP	AL,'S'
	JZ	PROARX
	INC	CL			;ASSUME NON-BLINKING
	MOV	DX,OFFSET NBLMSG
	CMP	AL,'N'			;NON-BLINKING
	JZ	PROARX
	INC	CL			;ASSUME UNINSTALL
	MOV	DX,OFFSET UNMSG
	CMP	AL,'U'			;UNINSTALL?
PROARX:	RET				;RETURN WITH GOOD/BAD INDICATION

;	SET NEW CURSOR TYPE

SETNEW:	PUSH	CX			;SAVE TYPE FLAG
	MOV	ES:TIMFLG-0C0H,0	;CLEAR TIMER INTERRUPT FLAG
	MOV	CX,2007H
	MOV	AH,1
	INT	10H			;TURN OLD CURSOR OFF
	POP	CX			;GET TYPE FLAG
	CLI
	MOV	ES:ENFLG-0C0H,CL	;SET NEW CURSOR TYPE
	CMP	CL,2			;CHECK TYPE JUST SET
	JA	SETNEW1			; FOR 1 OR 2
	CMP	CL,1
	JB	SETNEW1
	CMP	FCBARG2,'T'		;TIMER INTERRUPT ON?
	JNZ	SETNEW1			;NO
	MOV	ES:TIMFLG-0C0H,1	;ELSE, SET TIMER INTERRUPT ON
	MOV	DX,OFFSET TIMMSG
	MOV	AH,9
	INT	21H			;SAY TIMER INTERRUPT ON
SETNEW1:MOV	CX,607H
	MOV	AH,1
	INT	10H			;SET NEW CURSOR
	STI
	RET

FCBARG	DB	0			;FCB ARGUMENT SAVED HERE
FCBARG2	DB	0			;SECOND FCB ARGUMENT
LSTSEG	DW	0			;LAST PSP SEGMENT (SHOULD BE < PSPSEG)
FNDSEG	DW	0			;SEGMENT WHERE FOUND
FNDFLG	DB	0			;PROGRAM FOUND FLAG

SIGNON	DB	13,10,'CURSOR -- Laptop Cursor Control Program, v. 1.0',13,10
	DB	"Copyright (C) Heath/Zenith Users' Group 1989.  All rights reserved."
	DB	13,10,10,'$'
HLPMSG	DB	'To use CURSOR, enter',13,10,10
	DB	'  CURSOR B		To set a Big cursor.',13,10
	DB	'  CURSOR B T		Above, with timer interrupt enabled.',13,10
	DB	'  CURSOR S		To set a Slow-blinking big cursor.',13,10
	DB	'  CURSOR S T		Above, with timer interrupt enabled.',13,10
	DB	'  CURSOR N		To set a Non-blinking block cursor.',13,10
	DB	'  CURSOR D		To disable CURSOR (set normal cursor).',13,10
	DB	'  CURSOR U		To uninstall CURSOR.  You can only',13,10
	DB	'			uninstall if CURSOR is the last',13,10
	DB	'			TSR loaded.',13,10,'$'
INSMSG	DB	'CURSOR is now installed in memory.',13,10,'$'
ORGMSG	DB	'CURSOR is disabled.',13,10,'$'
BLKMSG	DB	'CURSOR set to Big.',13,10,'$'
SLOMSG	DB	'CURSOR set to Slow-blinking big.',13,10,'$'
NBLMSG	DB	'CURSOR set to Non-blinking block.',13,10,'$'
TIMMSG	DB	'Timer interrupt is on.',13,10,'$'
UNMSG	DB	'CURSOR is now uninstalled.',13,10,'$'
NOUNMSG	DB	"CURSOR is not the last TSR.  Can't uninstall.",13,10,'$'
NINMSG	DB	"CURSOR is already not installed.",13,10,'$'

CODE	ENDS
	END	START
