 	TITLE	SCREEN CLOCK FOR MS-DOS
	PAGE	,132
;	SCLK V 2 -- SCREEN CLOCK FOR MS-DOS (Z-100 PC)
;
;	THIS PROGRAM PROVIDES A SCREEN CLOCK FOR MS-DOS THAT
;	IS DISPLAYED IN THE UPPER RIGHT CORNER OF THE SCREEN.
;
;	THE COLOR OF THE DISPLAYED CLOCK IS DETERMINED BY THE
;	VARIABLES FGCOL AND BGCOL.  COLORS MAY BE DIFFERENT IN
;	EGA GRAPHIC MODES.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  23-MAY-86  21-APR-87
;	UN-INSTALLABLE VERSION 22-MAY-89
;
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1989.  ALL RIGHTS RESERVED.

;	DEFINITIONS

BLACK	EQU	0			;COLOR CONTROL BITS
BLUE	EQU	001B
GREEN	EQU	010B
CYAN	EQU	011B
RED	EQU	100B
MAGENTA	EQU	101B
YELLOW	EQU	110B			;(IBM CALLS IT BROWN)
WHITE	EQU	111B

ROW	EQU	0			;STARTING ROW

;	WE ASSUME 65543 TICKS PER HOUR.  EVERYTHING IS MULTIPLIED
;	BY 5 FOR GREATER ACCURACY WITHIN THE LIMITS OF INTEGER
;	ARITHMETIC.

TPHH	EQU	5			;TICKS/HOUR * 5 HIGH
TPHL	EQU	23H			;TICKS/HOUR * 5 LOW
TPM	EQU	5462			;TICKS/MINUTE * 5
TPS	EQU	91			;TICKS/SECOND * 5

SCRINT	EQU	10H			;SCREEN CONTROL INTERRUPT
WCHAR	EQU	9			;WRITE CHARACTER
TIMEINT	EQU	1CH*4			;Z-150 TIMER INTERRUPT VECTOR
SYSINT	EQU	21H*4			;MS-DOS SYSTEM INTERRUPT

JMPF	MACRO
	DB	0EAH			;DEFINE FAR JUMP
	ENDM
CALLF	MACRO
	DB	09AH			;DEFINE FAR CALL
	ENDM

BIOS	SEGMENT AT 40H
	ORG	49H
MODE	LABEL	BYTE			;CURRENT VIDEO MODE
	ORG	4AH
COLS	LABEL	BYTE			;COLUMNS/LINE
	ORG	50H
CURPOS	LABEL	WORD			;CURSOR POSITION
	ORG	62H
PAGENO	LABEL	BYTE			;CURRENT PAGE NUMBER
	ORG	6CH
TIMERL	LABEL	WORD			;DEFINE TIMER LOW
	ORG	6EH
TIMERH	LABEL	WORD			;DEFINE TIMER HIGH
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	DEFINE SOME MEMORY LOCATIONS

	ORG	1
PSPSEG	LABEL	WORD			;PROGRAM SEGMENT PREFIX SEGMENT ADDR.
	ORG	3
MCBSIZE	LABEL	WORD			;MEMORY CONTROL BLOCK SIZE
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	5DH
FCBN	LABEL	BYTE			;FCB ARGUMENT NAME
	ORG	100H

START:	JMP	SETUP			;SET UP CLOCK INTERRUPT, ETC.

;	CLOCK DATA AREA

FGCOL	DB	WHITE			;FOREGROUND COLOR
BGCOL	DB	BLACK			;BACKGROUND COLOR
SIG	DB	'SCRNCLK  2.0'		;PROGRAM SIGNATURE
CLKFLG	DB	1			;CLOCK ON/OFF FLAG
CIVFLG	DB	0			;CIVILIAN TIME FLAG
SKCNT	DB	0			;SKIP COUNTER
HOU	DB	0			;BINARY HOUR
MIN	DB	0			;BINARY MINUTE
OLDSEC	DB	0			;OLD SECOND
CPOS	DW	0			;CURSOR POSITION
CPADR	DW	0			;CURSOR POSITION ADDRESS
CMODE	DB	0			;CURRENT VIDEO MODE
TIMSTR	DB	' '			;SPACE BEFORE TIME
HOUR	DW	0			;HOUR (ASCII)
	DB	':'
MINUTE	DW	0			;MINUTE
	DB	':'
SECOND	DW	0			;SECOND
AMPM	DB	' '			;TRAILING SPACE

;	PROCESS CLOCK INTERRUPTS HERE

MYTIME:	CMP	CS:CLKFLG-0C0H,0	;CLOCK ENABLED?
	JZ	TIMEX			;IF NOT, EXIT
	XOR	CS:SKCNT-0C0H,1		;TIME TO CHECK?
	JZ	CHTIME			;YES, DO IT
TIMEX:	JMPF				;FAR JUMP INSTRUCTION
TIMADR	DW	0,0			;SYSTEM TIMER ADDRES GOES HERE

;	CHECK TIME, SEE IF A SECOND HAS PASSED

CHTIME:	PUSH	AX
	PUSH	BX			;SAVE REGISTERS
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DS
	MOV	AX,40H			;BIOS RAM SEGMENT
	MOV	DS,AX
	ASSUME	DS:BIOS
	MOV	AX,TIMERL		;GET TIMER LOW
	MOV	DX,TIMERH		;AND TIMER HIGH
	MOV	BX,AX
	MOV	CX,DX			;TIMER IN CX,BX
	SHL	AX,1			;MPY TIMER * 5
	RCL	DX,1			;* 2
	SHL	AX,1
	RCL	DX,1			;* 4
	ADD	AX,BX
	ADC	DX,CX			;* 5
	PUSH	CS
	POP	DS			;PUT DS HERE
	ASSUME	DS:CODE
	MOV	BX,TPHH			;GET TICKS/HOUR * 5 HIGH
	MOV	CX,TPHL			;AND TICKS/HOUR * 5 LOW
	MOV	SI,-1			;SET A COUNTER
DIVLP:	INC	SI			;DIVIDE TICKS BY TICKS/HOUR
	SUB	AX,CX
	SBB	DX,BX
	JNB	DIVLP
	ADD	AX,CX
	ADC	DX,BX			;DX,AX = REMAINDER
	MOV	WORD PTR HOU-0C0H,SI	;SAVE HOUR
	MOV	CX,TPM
	DIV	CX			;DIV BY TICKS/MINUTE * 5
	MOV	MIN-0C0H,AL		;SAVE RESULT
	MOV	AX,DX			;GET REMAINDER
	MOV	CL,TPS
	DIV	CL			;DIV BY TICKS/SECOND * 5
	CMP	AL,OLDSEC-0C0H		;HAS A SECOND PASSED?
	JNZ	UPDATE
	JMP	NOUPD			;IF NOT, EXIT

;	A SECOND HAS PASSED, PRINT TIME ON THE SCREEN

UPDATE:	CLD				;ENSURE FORWARD DIRECTION
	MOV	OLDSEC-0C0H,AL		;UPDATE OLD SECOND
	CMP	AL,60			;INTEGER MATH ERROR?
	JNZ	NERR			;NO
	DEC	AL			;ELSE, CORRECT
NERR:	CALL	CONASC			;CONVERT SECONDS TO ASCII
	MOV	SECOND-0C0H,AX		;RESULT TO BUFFER
	MOV	AL,MIN-0C0H		;GET MINUTES
	CALL	CONASC			;CONVERT TO ASCII
	MOV	MINUTE-0C0H,AX		;RESULT TO BUFFER
	MOV	AL,HOU-0C0H		;GET HOURS
	MOV	AMPM-0C0H,' '		;ASSUME MILITARY TIME
	CMP	CIVFLG-0C0H,1		;CIVILIAN TIME MODE?
	JNZ	MILTIM			;NO
	MOV	AMPM-0C0H,'a'		;ASSUME AM
	CMP	AL,12			;12 OR LATER?
	JB	MORN			;NO, MORNING
	MOV	AMPM-0C0H,'p'		;ELSE FLAG PM
	CMP	AL,13			;1 OR LATER?
	JB	MILTIM			;NO
	SUB	AL,12			;ELSE, SUBTRACT 12 HOURS
	JMP	SHORT H12MOD
MORN:	OR	AL,AL			;12 AM?
	JNZ	H12MOD			;NO
	MOV	AL,12			;ELSE, MAKE IT SAY IT
H12MOD:	CALL	CONASC			;CONVERT HOUR
	CMP	AL,'0'			;LEADING ZERO?
	JNZ	SAVHOU			;NO
	MOV	AL,' '			;ELSE, REPLACE WITH SPACE
	JMP	SHORT SAVHOU
MILTIM:	CALL	CONASC			;CONVERT TO ASCII
SAVHOU:	MOV	HOUR-0C0H,AX		;RESULT TO BUFFER
	MOV	DH,ROW			;GET ROW FOR CLOCK
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	MOV	DL,COLS			;AND COLUMNS
	SUB	DL,10			;SUBTRACT CLOCK WIDTH FROM COLUMNS
	MOV	AL,PAGENO		;GET VIDEO PAGE
	MOV	BH,AL			;IN BH, ALSO
	SHL	AL,1			;DOUBLE IT
	CBW				;MAKE IT A WORD
	MOV	SI,OFFSET CURPOS
	ADD	SI,AX			;POINT TO CURSOR POSITION
	MOV	CX,[SI]			;GET IT
	MOV	[SI],DX			;SET CURSOR TO TIME AREA
	MOV	BL,MODE			;GET MODE
	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	ASSUME	DS:CODE
	MOV	CPOS-0C0H,CX		;SAVE CURSOR POSITION
	MOV	CPADR-0C0H,SI		;SAVE CURSOR POSITION ADDRESS
	MOV	CMODE-0C0H,BL		;SAVE CURRENT MODE
	MOV	CX,10			;SET A COUNTER
	MOV	BL,BGCOL-0C0H		;GET BACKGROUND COLOR
	SHL	BL,1			;ROTATE TO HIGHER NIBBLE
	SHL	BL,1
	SHL	BL,1
	SHL	BL,1
	OR	BL,FGCOL-0C0H		;ADD IN FOREGROUND COLOR
	CMP	CMODE-0C0H,6		;MODE 6?
	JNZ	PTIME1			;NO
	MOV	BL,1			;ELSE, COLOR IS 1
PTIME1:	MOV	SI,OFFSET TIMSTR-0C0H	;POINT TO TIME STRING
PTMLP:	LODSB				;GET A DIGIT
	PUSH	CX			;SAVE COUNTER
	PUSH	SI			;SAVE POINTER
	CALL	PDIGIT			;PRINT DIGIT
	POP	SI
	POP	CX
	LOOP	PTMLP			;LOOP UNTIL DONE
PDONE:	MOV	DX,CPOS-0C0H		;GET OLD CURSOR POSITION
	MOV	BX,CPADR-0C0H		;GET CURSOR POSITION ADDRESS
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS
	MOV	[BX],DX			;RESTORE CURSOR POSITION
NOUPD:	POP	DS			;RESTORE REGISTERS
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	JMP	TIMEX			;AND EXIT

;	CONVERT NUMBER IN AL TO ASCII DIGITS IN AL, AH

CONASC:	MOV	AH,0			;CLEAR AH
	MOV	BH,10			;GET RADIX
	DIV	BH			;DIVIDE BY IT
	ADD	AX,'00'			;ADD ASCII
	RET

;	PRINT A DIGIT ON THE SCREEN

PDIGIT:	MOV	AH,WCHAR
	MOV	CX,1
	CALL	SCROUT			;WRITE CHARACTER
	MOV	SI,CPADR-0C0H		;GET CURSOR POSITION ADDRESS
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	INC	BYTE PTR [SI]		;MOVE CURSOR OVER
	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	ASSUME	DS:CODE
	RET

;	SCREEN INTERRUPT VECTOR

SCROUT:	PUSHF
	CALLF
SCRVEC	DW	0,0
	RET

;	LOCAL SYSTEM INTERRUPT PROCESSOR

MYSYS:	CMP	AH,0F2H			;CLOCK PROCESS CODE?
	JZ	CLKSYS			;YES
	JMPF				;ELSE, EXIT
SYSADR	DW	0,0
CLKSYS:	MOV	CS:CIVFLG-0C0H,0	;ASSUME CIVILIAN MODE OFF
	CMP	AL,2			;SET CIVILIAN MODE?
	JNZ	CLKSYS1			;NO
	MOV	CS:CIVFLG-0C0H,1	;ELSE, SET IT
	DEC	AL			;FIX AL
CLKSYS1:MOV	CS:CLKFLG-0C0H,AL	;SET CLOCK CONDITION
	IRET

;	INT 28H PROCESSOR.  USED FOR UN-INSTALLING CAPCON.

INT28:	CMP	CS:CLKFLG-0C0H,2	;UN-INSTALL CAPCON?
	JZ	UNINS			;YES
	JMPF
INT28V	DW	0,0			;ELSE, EXIT
UNINS:	PUSH	CS
	POP	DS			;POINT TO THIS SEGMENT
	XOR	AX,AX
	MOV	ES,AX			;AND TO INT. SEGMENT
	MOV	SI,OFFSET TIMADR-0C0H	;POINT TO INT 1C VECTOR
	MOV	DI,TIMEINT		;WHERE IT GOES
	CLD
	CLI
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET SYSADR-0C0H
	MOV	DI,SYSINT
	MOVSW				;RESTORE SYSTEM INTERRUPT
	MOVSW
	MOV	SI,OFFSET INT28V-0C0H	;POINT TO INT 28 VECTOR
	MOV	DI,28H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	AH,49H
	INT	21H			;RELEASE THIS PROGRAM'S MEMORY
	MOV	ES,ENVSEG		;POINT TO ENVIRONMENT SEGMENT
	MOV	AH,49H
	INT	21H			;RELEASE ENVIRONMENT SEGMENT
	STI				;ENABLE INTERRUPTS
	INT	20H			;EXIT

ENDRES:					;END OF RESIDENT CODE

;	SET UP INTERRUPT VECTORS.
;	THEN EXIT WITH PROGRAM RESIDENT

SETUP:	MOV	AL,FCBN			;GET FCB NAME CHARACTER
	MOV	FCBARG,AL		;SAVE IT
	CMP	AL,'?'			;HELP?
	JNZ	NOHLP			;NO
	MOV	DX,OFFSET HLPMSG
	MOV	AH,9
	INT	21H
	INT	20H
NOHLP:	CLD
	MOV	AH,52H
	INT	21H			;GET MEMORY CONTROL BLOCK ADDR.
	MOV	AX,ES:[BX-2]		;GET FIRST MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
FNDLP:	MOV	AX,PSPSEG		;GET PSP SEGMENT
	MOV	DX,CS
	CMP	AX,DX			;IN THIS SEGMENT?
	JAE	CHKFND			;IF SO, CHECK IF SCLK FOUND
	MOV	ES,AX			;ELSE, PSP SEGMENT TO ES
	MOV	SI,OFFSET SIG
	MOV	DI,SI
	SUB	DI,0C0H			;PROGRAM IS MOVED DOWN
	PUSH	DS			;SAVE MCB SEGMENT
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	CX,6			;6 WORDS IN SIGNATURE
	REPZ	CMPSW			;IS SCLK HERE?
	JZ	GOTCC			;WE FOUND SCLK
	MOV	LSTSEG,ES		;SAVE PSP SEGMENT
FNDNXT:	POP	DS			;RESTORE MCB SEGMENT
	MOV	AX,MCBSIZE		;GET MCB SIZE
	INC	AX			;CORRECT IT
	MOV	BX,DS
	ADD	AX,BX			;CALCULATE NEXT MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
	JMP	FNDLP			;TRY AGAIN
GOTCC:	MOV	FNDSEG,ES		;SAVE SEGMENT WHERE FOUND
	MOV	BYTE PTR FNDFLG,1	;MARK PROGRAM FOUND
	JMP	FNDNXT
CHKFND:	PUSH	CS
	POP	DS			;FIX DS
	CMP	BYTE PTR FNDFLG,1	;WAS SCLK FOUND?
	JNZ	NOTFND			;NO
	MOV	ES,FNDSEG		;GET SEGMENT WHERE FOUND
	CMP	FCBARG,'U'		;UNINSTALL?
	JNZ	CHKD			;NO, CHECK DISABLE
	MOV	BX,FNDSEG		;GET SEGMENT WHERE FOUND
	CMP	BX,LSTSEG		;COMPARE WITH LAST PSP FOUND
	JNC	UNLOK			;OK TO UNLOAD
	MOV	DX,OFFSET NOUNMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "CAN'T UNLOAD"
	INT	20H
CHKD:	MOV	AX,0F200H		;ASSUME DISABLE
	CMP	FCBARG,'D'		;IS IT?
	JZ	SETCLK			;YES
	INC	AL			;OTHERWISE, ENABLE
	CMP	FCBARG,'C'		;CIVILIAN MODE?
	JNZ	SETCLK			;NO
	INC	AL			;ELSE, FLAG IT
SETCLK:	INT	21H			;SCLK WILL PROCESS THIS
	INT	20H
UNLOK:	MOV	DX,OFFSET UNMSG
	MOV	AH,9
	INT	21H			;PRINT UNLOAD MESSAGE
	MOV	ES:CLKFLG-0C0H,2	;FLAG UNLOAD DESIRED
	INT	20H			;AND EXIT
NOTFND:	CMP	FCBARG,'U'		;UNINSTALL?
	JZ	CANTUN			;CAN'T UN-INSTALL
	PUSH	CS
	POP	ES			;FIX ES
	MOV	SI,OFFSET START		;POINT TO START OF PROGRAM
	MOV	DI,40H			;PUT IT HERE
	MOV	CX,ENDRES-START		;SIZE OF PROGRAM
	CLD
	REP	MOVSB			;MOVE PROGRAM DOWN
	PUSH	DS			;SAVE DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET TIMEINT	;POINT TO TIMER INTERRUPT
	MOV	DI,OFFSET TIMADR-0C0H	;ELSE, PUT OLD VECTOR HERE
	PUSH	SI
	CLI				;TURN OFF INTERRUPTS
	CLD
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYTIME-0C0H	;PUT IN MY VECTOR
	MOV	2[SI],CS		;AND THIS SEGMENT
	MOV	SI,OFFSET SYSINT	;POINT TO SYSTEM INTERRUPT
	MOV	DI,OFFSET SYSADR-0C0H	;PUT VECTOR HERE
	PUSH	SI
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYSYS-0C0H	;PUT IN MY VECTOR
	MOV	2[SI],CS
	MOV	SI,OFFSET 28H*4		;POINT TO INT 28 VECTOR
	MOV	DI,OFFSET INT28V-0C0H
	PUSH	SI
	MOVSW				;COPY INT 28 VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET INT28-0C0H	;SET NEW ONE
	MOV	2[SI],CS
	STI
	MOV	SI,OFFSET SCRINT*4	;POINT TO SCREEN VECTOR
	MOV	DI,OFFSET SCRVEC-0C0H	;PUT IT HERE
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	DS
	CMP	FCBARG,'D'		;DISABLE?
	JNZ	NOTDIS
	MOV	CLKFLG-0C0H,0		;ELSE, START WITH CLOCK KILLED
NOTDIS:	CMP	FCBARG,'C'		;CIVILIAN MODE?
	JNZ	NOTCIV			;NO
	MOV	CIVFLG-0C0H,1		;ELSE, SET IT
NOTCIV:	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;PRINT "SCLK INSTALLED"
	MOV	DX,OFFSET ENDRES-0C0H	;POINT TO END OF RES. CODE
	INT	27H			;EXIT, LEAVE PROGRAM HERE
CANTUN:	MOV	DX,OFFSET NINMSG
	MOV	AH,9
	INT	21H			;SAY "NOT INSTALLED"
	INT	20H

LSTSEG	DW	0			;LAST PSP SEGMENT (SHOULD BE < PSPSEG)
FNDSEG	DW	0			;SEGMENT WHERE FOUND
FNDFLG	DB	0			;PROGRAM FOUND FLAG
FCBARG	DB	0			;SAVED FCB ARGUMENT

INSMSG	DB	13,10,'HUG Screen Clock v. 2.0',13,10,10
	DB	'SCLK is now installed in memory.',13,10
HLPMSG	DB	'You can control SCLK by entering',13,10,10
	DB	'  SCLK D	To disable the clock.',13,10
	DB	'  SCLK		To enable the clock.',13,10
	DB	'  SCLK C	To enable the clock in civilian mode.',13,10
	DB	'  SCLK U	To uninstall SCLK.  You may only uninstall',13,10
	DB	'		if SCLK is the last TSR installed.',13,10,'$'
UNMSG	DB	13,10,'SCLK is now uninstalled.',13,10,'$'
NOUNMSG	DB	13,10,"SCLK is not the last TSR.  Can't uninstall.",13,10,'$'
NINMSG	DB	13,10,"SCLK is already not installed.",13,10,'$'

CODE	ENDS
	END	START
