
;	YOU CAN ALSO SPECIFY A USER NUMBER AFTER THE DRIVE
;	AND/OR FILE SPECIFICATION, AS IN THIS EXAMPLE
;
;	A>L A: 5    (SHOW FILES ON USER 5)
;
;	YOU CAN ALSO SPECIFY THAT THE DIRECTORY NOT BE
;	ALPHABETIZED, BY ENTERING "N" AFTER THE DRIVE,
;	NAME, OR USER NUMBER
;
;	A>DIR19 A: N
;	A>DIR19 *.BAS N
;	A>DIR19 B:*.COM 10N  (NO SPACE AFTER USER NO.)
;
;
; BDOS EQUATES
;
;GALLOC	EQU	27		;GET ALLOCATION ADDRESS - bad for cp/m +
boot	equ	0		; for warm boot
bdos	equ	0005		; bdos function
fcb	equ	05ch		; fcb
fcb1	equ	05ch		; first file name
fcb2	equ	06ch		; second file name
DBUFF	EQU	80H		; DEFAULT BUFFER
ABUFF	EQU	DBUFF		; ACUTAL BUFFER
UNUSED	EQU	0E5H		; DIR ENTRY
TPA	EQU	100H
;
notfind	equ	0FFH		; not found for file open/dir search
false	equ	0
true	equ	not false
; set flags in main program so that only one copy of certain
; routines will be generated. SET lines before MACLIB call.
;
BNflag	SET	false	; binary to ASCII binary
CIflag	SET	false	; input console char
COflag	SET	false 	; output console char
CRflag	SET	false 	; CRLF
CXflag	SET	false	; binary to hex
deflag	set	false	; binary to decimal
dvflag	set	false	; 16  bit divide
flflag	set	false	; fill chars
mlflag	set	false	; 16 bit multiply in hl
mvflag	set	false	; block move
prflag	set	false 	; print console
;end of flags
;
MACLIB	CPMMAC
;
	ORG	100H
;
START:
	MVI	C,26		; set dma function
	LXI	D,80H
	CALL	BDOS		;SET DEFAULT DMA
	LXI	H,0
	DAD	SP		;FIND STACK
	LXI	SP,NSTACK	;SET NEW ONE
	PUSH	H		;SAVE OLD ONE
	CALL	TYPTX
	DB	esc,'E'+80H	;CLEAR SCREEN
	MVI	A,'?'
	STA	FCB+12		;PUT "?" IN EXTENT POS.
	MVI	E,notfind
	MVI	C,32		; get user function
	CALL	BDOS		;GET CURRENT USER CODE
	STA	USER		;SAVE IT
	LXI	H,6DH		;GET FCB2 FIRST CHAR
	MOV	A,M
	CPI	' '		;ANY USER CODE
	JZ	NOUSER		;NO
	CPI	'N'		;NO ALPHABETIZE?
	JNZ	DECIN		;NO, CHECK FOR NUMBER
	MVI	A,1
	STA	NFLAG		;ELSE, MARK NO ALPHA
	JMP	NOUSER
DECIN:	MVI	C,0		;GET A ZERO
DLOOP:
	MOV	A,M		;GET A CHARACTER
	CPI	'N'		;NO ALPHA?
	JNZ	DLOOP1		;NO, NORMAL OUTPUT
	MVI	A,1
	STA	NFLAG		;MARK NO ALPHA
	JMP	GOTUSR		;GOT USER NOW
DLOOP1:
	SUI	'0'		;REMOVE ASCII
	JC	GOTUSR		;WE GOT A USER NO.
	CPI	10		;MORE THAN 9
	JNC	NOUSER		;YES, BAD ENTRY
	INX	H		;INCREMENT POINTER
	MOV	D,A		;SAVE ENTRY
	MOV	A,C		;GET LAST ENTRY
	ADD	A		;* 2
	MOV	B,A		;SAVE IT
	ADD	A		;* 4
	ADD	A		;* 8
	ADD	B		;PLUS N*2 = N*10
	ADD	D		;ADD CURRENT ENTRY
	MOV	C,A		;STORE RESULT
	JMP	DLOOP		;GET ANOTHER DIGIT

GOTUSR:
	MOV	E,C		; user code from above - move to E
	MVI	C,32		; set user code
	CALL	BDOS		; SET NEW USER CODE

NOUSER:				; get current disk and store in binary (CURDB)
	CALL	TYPTX
	DB	esc,'p','WMA Disk',' '+80H
	CALL	CDISK		; 	and ASCII (CURDA) 
	LDA	FCB1		; check for drive in ASCII
	ORA	A		; was a drive specified? no, use default drive
	CNZ	SETDSK		; yes - set the drive
	LDA	CURDB		; now have default/requested drive
	STA	FCB1		; in binary - store in label FCB ???
	ADI	'A'		; convert to ascii
	PCHAR
	CALL	TYPTX
	DB	':',esc,'q'+80H
	CALL	GETDPH		; get disk parameters
	CALL 	XAMINE		; display them
	CALL	BORDER		; write the border
	JMP	ENDIT

;
;	Get the disk parameters
;
GETDPH:			
	MVI	C,31		; get disk parameter address
	CALL	BDOS
	MOVE	,DPARM,15	; macro - copy to end
	LHLD	BLKMAX		; max # of blocks
	INX	H		; 
	SHLD	BLKMAX		; starts at zero
	LHLD	DIRENT		; # of directory entries
	INX	H		; starts at zero
	DIVIDE	4		; macro - convert to # of sectors
; save number of directory sectors as 16 bits
	SHLD	DIRMAX		; and save
	SHLD	DIRMX2		; count
;
; Directory block allocation is stored as 1000 000 for 1 block
; 1100 0000 for 2 etc.... but we want left byte in H
;
	LHLD	ALLVEC		; reverse bytes
	MOV	A,L
	MOV	L,H
	MOV	H,A
	SHLD	ALLVEC
; Get number of dir blocks as ASCII
	XRA	A		; zero out A
XAM3:
	DAD	H		; shift left
	JNC	XAM4
	INR	A
	JMP	XAM3
XAM4:
	MOV	E,A		; # of dir blocks
	MVI	D,0
	LHLD	BLKMAX		; max number of blocks
	SBC	HL,DE		; macro - deduct for directory
	SHLD	NETBL		; net number of data blocks available
	MOV	A,E
	ORI	'0'		; ASCII bias
	STA	ALLOCA		; save
;
; select disk and setup disk parameter header
;
	LDA	FCB
	MOV	C,A
	CALL	SELDSK		; select drive
	MOV	A,H		; HL has DPH
	ORA	L
	JZ	ILDISK		; error - no disk
	MOV	E,M		; get translate table
	INX	H		; 	address
	MOV	D,M
	XCHG
	SHLD	DPH		; save address
	RET
;
;	Display disk parameters
;
XAMINE:
;	PRINT	<CR,LF,'Sectors/track:     '>
;	LHLD	NUMSEC
;	HLDEC			; decimal
;	PCHAR	' '
;	PCHAR	'('
;	OUTHL
;	PRINT	<'hex)',CR,LF,'Sectors/block:     '>
	LDA	BLM
	INR	A
	MOV	L,A
	MVI	H,0
;	HLDEC
;	PCHAR	' '
;	PCHAR	'('
;	OUTHEX	L
;	PRINT	'hex)'
;	PRINT	<CR,LF,'Block size:        '>
	DIVIDE	8	
	MOV	B,L			; save block size
;	HLDEC
;	PRINT	'K bytes'
	LHLD	NETBL			; # data blocks
	MOV	A,B			; block size
	MULT
	PRINT	<'        Disk Capacity: '>	; line 1, col 25
	HLDEC
	PRINT	' K (usable)'
;	PRINT	<CR,LF,'Extents/entry:     '>
;	LDA	EMASK
;	INR	A
;	MOV	L,A
;	MVI	H,0
;	HLDEC
;	PRINT	<CR,LF,'Number of blocks:   '>
;	LHLD	BLKMAX
;	HLDEC
;	PCHAR	' '
;	PCHAR	'('
;	OUTHL
	PRINT	<'     Max entries: '>	; line 1, col 55
	LHLD	DIRENT
	INX	H
	HLDEC
;**	PRINT	<esc,'k'>
;	PCHAR	' '
;	PCHAR	'('
;	OUTHL
;	PRINT	<'hex)',CR,LF,'Directory blocks:   '>
;	LDA	ALLVEC
;	PCHAR
;	PCHAR	' '
;	PCHAR	'('
;	LDA	ALLVEC+1
;	BINBIN				; allocation in binary
;	LDA	ALLVEC
;	ORA	A
;	JZ	XAM2
;	BINBIN				; 2nd if needed
;XAM2:
;	PRINT	<')',CR,LF,'Track Offset:        '>
;	LHLD	TRKOFF
;	HLDEC
;	MOV	A,H
;	ORA	A
;	JZ	XAM5			; skip hex
;	PCHAR	' '
;	PCHAR	'('
;	OUTHL
;	PRINT	'hex)'
;XAM5:
;	CRLF
	RET
	
;BEGINNING OF OLD CODE
;	*****************************************************
;SIZE:
;	CALL	BORDER
;	MVI	C,31	; get disk parameter address
;	CALL	BDOS
;	INX	H		; skip SPT (2 bytes)
;	INX	H		;MOVE TO BLOCK SHIFT - block shift factor
;	MOV	A,M		;GET IT
;	DCR	A
;	DCR	A
;	DCR	A		;MAKE IT START AT ZERO
;	PUSH	PSW		;SAVE IT
;	INX	H		; skip BLM	MOVE TO DISK SIZE - dsm (5) 
;	INX	H		; skip EXM
;	INX	H		; get drive size mask - DSM
;	MOV	E,M		;PUT disk size IN DE
;	INX	H		; get directory mask(# blocks on drive -1)
;	MOV	D,M		; DRM is 2 bytes long
;	INX	D		;ADD 1 for total blocks on drive
;	XCHG
;	SHLD	DSIZE		;SAVE DISK SIZE
;	XCHG
;	INX	H		; skip 2nd DRM byte
;	INX	H		; skip allocation vector 0
;	INX	H		; get allocation vector 1
;	MOV	A,M		;GET IT
;	STA	ALLOC		;SAVE IT
;	POP	PSW		;GET BLOCK SHIFT (-3)
;	LXI	H,1		;HL = 1 K - start at 1 k blocks
;	ORA	A		;SET FLAGS
;	JZ	SIZE1		;GOT BLOCK SIZE
;BLKLP	DAD	H		;DOUBLE BLOCK SIZE
;	DCR	A		;IS THIS IT
;	JNZ	BLKLP		;NO, DOUBLE AGAIN
;
;SIZE1	MOV	A,L
;	STA	BSIZE		;SAVE BLOCK SIZE FOR LATER
;	PUSH	H		;SAVE BLOCK SIZE
;	MVI	C,GALLOC			; bad *****
;	CALL	BDOS		;GET ALLOCATION MAP
;	POP	D		;DE = BLOCK SIZE
;SIZE2	MVI	B,8		;8 BITS PER BYTE
;	MOV	A,M		;GET A BYTE
;	PUSH	H		;SAVE MAP ADDRESS
;SIZE3	RAL			;TEST FOR A BIT
;	JC	SIZE4		;IT IS SET
;	LHLD	FREE		;INCREMENT FREE SPACE
;	DAD	D
;	SHLD	FREE
;	JMP	SIZE5
;SIZE4	LHLD	USED		;INCREMENT USED SPACE
;	DAD	D
;	SHLD	USED
;SIZE5	LHLD	DSIZE		;GET DISK SIZE
;	DCX	H		;SUBTRACT THIS GROUP
;	SHLD	DSIZE
;	PUSH	PSW		;SAVE MAP BYTE
;	MOV	A,H
;	ORA	L		;DONE WITH DISK?
;	JZ	SIZE6		;IF SO, LEAVE
;	POP	PSW		;ELSE RESTORE MAP BYTE
;	DCR	B		;DONE WITH BYTE?
;	JNZ	SIZE3		;NO, TEST ANOTHER BIT
;	POP	H		;ELSE, GET MAP ADDRESS
;	INX	H		;INCREMENT IT
;	JMP	SIZE2		;GET NEXT BYTE
;SIZE6	POP	PSW		;RESTORE PSW
;	POP	H		;AND HL
;	XCHG			;HL = BLOCK SIZE
;	CALL	CHL		;COMPLEMENT IT
;	XCHG			;PUT RESULT IN DE
;	LHLD	USED		;GET USED SPACE
;	LDA	ALLOC		;AND ALLOCATION VECTOR
;	RAL			;TEST FOR A BIT
;	JNC	SIZE8		;NONE SET, NO ALLOCATED SPACE
;SIZE7	DAD	D		;SUBTRACT A BLOCK
;	RAL			;TEST FOR A BIT
;	JC	SIZE7		;IT WAS SET, SUBTRACT BLOCK
;SIZE8	SHLD	USED		;SAVE UPDATED USED SPACE
;	****************************************************
;END OF OLD CODE
;	Looking for files
;

START1	LXI	H,FCB+1
	MOV	A,M
	CPI	' '
	JNZ	GOTFCB

;NO FCB - MAKE FCB ALL '?'

	MVI	B,11		;FN+FT COUNT
QLOOP	MVI	M,'?'		;STORE '?' IN FCB
	INX	H
	DCR	B
	JNZ	QLOOP
;LOOK UP THE FCB IN THE DIRECTORY

GOTFCB	MVI	C,17 	; search first dir entry-GET 'SEARCH FIRST' FNC
	LXI	D,FCB		;GET FCB ADDRESS
	CALL	BDOS		;READ FIRST
	INR	A		;WERE THERE ANY?
	JNZ	SOME		;GOT SOME
	JMP	BOTTOM
;
;READ MORE DIRECTORY ENTRIES

MOREDIR	MVI	C,18		;SEARCH NEXT directory entry
	LXI	D,FCB
	CALL	BDOS		;READ DIR ENTRY
	INR	A		;CHECK FOR END (notfind - 0FFH)
	JZ	SPRINT		;NO MORE - SORT & PRINT

;POINT TO DIRECTORY ENTRY 

SOME	DCR	A		;UNDO PREV 'INR A'
	ANI	3		;MAKE MODULUS 4
	ADD	A		;MULTIPLY...
	ADD	A		;..BY 32 BECAUSE
	ADD	A		;..EACH DIRECTORY
	ADD	A		;..ENTRY IS 32
	ADD	A		;..BYTES LONG
	LXI	H,81H		;POINT TO BUFFER
;				;(SKIP TO FN/FT)
	ADD	L		;POINT TO ENTRY
	MOV	L,A		;SAVE (CAN'T CARRY TO H)
	PUSH	H		;SAVE ADDRESS
	LXI	D,11
	DAD	D		;SKIP TO EXTENT NO.
	MOV	A,M		;GET IT
	POP	H		;RESTORE ADDRESS
	ORA	A		;ZERO EXTENT?
	JZ	MOVEN		;YES, MOVE FILE NAME
	LDA	COUNT		;ELSE, GET FILE COUNT
	ORA	A		;FIRST FILE?
	JZ	MOVEN		;YES
	MOV	B,A		;COUNT IN B
	MVI	C,11		;GET COMPARE COUNT
	LXI	D,TABLE		;POINT TO TABLE
FIND	PUSH	B		;SAVE REGISTERS
	PUSH	D
	PUSH	H
COMP	LDAX	D
	CMP	M		;COMPARE ENTRIES
	JNZ	NOCOMP
	INX	D
	INX	H
	DCR	C
	JNZ	COMP		;CONTINUE FOR CHAR COUNT
NOCOMP	POP	H		;RESTORE REGISTERS
	POP	D
	POP	B
	JZ	REPLACE		;FOUND MATCH, REPLACE ENTRY
	PUSH	H
	XCHG			;HL = TABLE ADDRESS
	LXI	D,15
	DAD	D		;MOVE TO NEXT ENTRY
	XCHG
	POP	H
	DCR	B		;DECREMENT COUNT
	JNZ	FIND		;TRY AGAIN
	JMP	MOVEN		;NO MATCH, NEW ENTRY
REPLACE	PUSH	H		;SAVE NEW ENTRY ADDR
	PUSH	D		;AND OLD ONE
	LXI	B,11
	DAD	B		;MOVE TO NEW EXTENT NO.
	MOV	A,M		;GET IT
	POP	H		;GET OLD ENTRY
	PUSH	H		;SAVE AGAIN
	DAD	B		;MOVE TO ITS EXTENT NO.
	CMP	M		;COMPARE
	POP	D		;RESTORE REGISTERS
	POP	H
	JC	SKIPRP		;OLD BIGGER, SKIP REPLACEMENT
	MVI	B,15		;MOVE 15 CHARACTERS
REP1	MOV	A,M		;GET A CHARACTER
	STAX	D		;MOVE IT TO TABLE
	INX	H
	INX	D		;INCREMENT POINTERS
	DCR	B		;DECREMENT COUNTER
	JNZ	REP1		;CONTINUE UNTIL DONE
SKIPRP	JMP	MOREDIR		;GET ANOTHER ENTRY

;MOVE ENTRY TO TABLE

MOVEN	XCHG			;ENTRY TO DE
	LHLD	NEXTT		;NEXT TABLE ENTRY TO HL
	MVI	B,15		;ENTRY LENGTH
TMOVE	LDAX	D		;GET ENTRY CHAR
	MOV	M,A		;STORE IN TABLE
	INX	D
	INX	H
	DCR	B		;MORE?
	JNZ	TMOVE
	SHLD	NEXTT		;SAVE UPDATED TABLE ADDR
	LDA	COUNT		;GET PREV COUNT
	INR	A
	STA	COUNT
	JMP	MOREDIR
;
;SORT AND PRINT

SPRINT	LDA	COUNT		;INIT THE ORDER TABLE
	STA	PCOUNT		;SAVE FOR PRINTING
	LDA	NFLAG
	ORA	A		;NO ALPHABETIZING WANTED?
	JNZ	DONE		;YES, SKIP SORT
	LXI	H,ORDER
	LXI	D,TABLE
	LXI	B,15		;ENTRY LENGTH
BLDORD	MOV	M,E		;SAVE LO ORD ADDR
	INX	H
	MOV	M,D		;SAVE HI ORD ADDR
	INX	H
	XCHG			;TABLE ADDR TO HL
	DAD	B		;POINT TO NEXT ENTRY
	XCHG
	DCR	A		;MORE?
	JNZ	BLDORD		;..YES
	LDA	COUNT		;GET COUNT
	STA	SCOUNT		;SAVE AS # TO SORT
	DCR	A		;ONLY 1 ENTRY?
	JZ	DONE		;..YES, SO SKIP SORT
SORT	XRA	A		;GET A ZERO
	STA	SWITCH		;SHOW NONE SWITCHED
	LDA	SCOUNT		;GET COUNT
	DCR	A		;USE 1 LESS
	STA	TEMP		;SAVE # TO COMPARE
	STA	SCOUNT		;SAVE HIGHEST ENTRY
	JZ	DONE		;EXIT IF NO MORE
	LXI	H,ORDER		;POINT TO ORDER TABLE
SORTLP	CALL	COMPR		;COMPARE 2 ENTRIES
	CM	SWAP		;SWAP IF NOT IN ORDER
	INX	H		;BUMP ORDER
	INX	H		;..TABLE POINTER
	LDA	TEMP		;GET COUNT
	DCR	A
	STA	TEMP
	JNZ	SORTLP		;CONTINUE

;ONE PASS OF SORT DONE

	LDA	SWITCH		;ANY SWAPS DONE?
	ORA	A
	JNZ	SORT

;SORT IS ALL DONE - PRINT ENTRIES

DONE	LXI	H,ORDER
	SHLD	NEXTT
	MVI	C,20		;ZERO A COUNTER
	LDA	NFLAG
	ORA	A		;DIRECTORY SORTED?
	JZ	ENTRY		;YES
	LXI	H,TABLE-15
	SHLD	NEXTT		;ELSE, PUT TABLE IN NEXTT
;
;PRINT AN ENTRY

ENTRY:	LDA	NFLAG
	ORA	A		;DIRECTORY SORTED?
	JZ	ENTRY1		;YES
	LHLD	NEXTT		;ELSE, GET ENTRY ADDRESS
	LXI	D,15
	DAD	D		;ADD 15
	SHLD	NEXTT		;UPDATE POINTER
	XCHG			;DE = ADDRESS
	JMP	ENTRY2
ENTRY1	LHLD	NEXTT		;GET ORDER TABLE POINTER
	MOV	E,M		;GET LO ADDR
	INX	H
	MOV	D,M		;GET HI ADDR
	INX	H
	SHLD	NEXTT		;SAVE UPDATED TABLE POINTER
ENTRY2	LHLD	COLADR		;GET COLUMN MOVER STRING
	CALL	TYPTX1		;PRINT IT
	XCHG			;TABLE ENTRY TO HL
	PUSH	H		;SAVE ENTRY ADDRESS
	MVI	B,8		;FILE NAME LENGTH
	CALL	TYPEIT		;TYPE FILENAME
	CALL	XPERIOD		;PERIOD AFTER FN
	MVI	B,3		;GET THE FILETYPE
	CALL	TYPEIT
	POP	H		;GET NAME ADDRESS
	LXI	D,11
	DAD	D		;MOVE TO EXTENT NO.
	MOV	A,M		;GET IT
	PUSH	H		;SAVE EXTENT ADDRESS
	MOV	L,A
	MVI	H,0		;HL = EXTENT NO.
	DAD	H		;MULTIPLY BY 16
	DAD	H
	DAD	H
	DAD	H
	POP	D		;GET EXTENT ADDRESS
	INX	D		;MOVE TO RECORD COUNT
	INX	D
	INX	D
	LDAX	D		;GET IT
	ADI	7		;ADD 7
	RRC			;DIVIDE BY 8
	RRC
	RRC
	ANI	00011111B	;NOW, IT EQUALS K'S
	PUSH	PSW		;SAVE IT
	LDA	BSIZE		;GET BLOCK SIZE
	DCR	A		;SUBTRACT 1
	MOV	B,A		;RESULT IN B
	POP	PSW		;GET RECORD COUNT (IN K'S)
	ADD	B		;ADD (BSIZE-1)
	PUSH	PSW		;SAVE RESULT
	MOV	A,B		;GET BSIZE-1
	CMA			;COMPLEMENT IT
	MOV	B,A		;RESULT IN B
	POP	PSW		;GET COUNT-(BSIZE-1)
	ANA	B		;ROUND OFF TO GROUP SIZE
	ADD	L		;ADD TO HL
	MOV	L,A
	JNC	NOCARRY
	INR	H		;ADD CARRY
NOCARRY	LXI	D,SPACES	;POINT TO SPACES
	PUSH	D		;SAVE ON STACK
	LXI	D,10
	CALL	CPHD		;LESS THAN 10 FILES?
	JC	PSIZE		;YES, PRINT SIZE
	POP	D
	INX	D		;NO, REMOVE 1 SPACE
	PUSH	D
	LXI	D,100
	CALL	CPHD		;LESS THAN 100 FILES
	JC	PSIZE		;YES
	POP	D
	INX	D		;NO, REMOVE 1 SPACE
	PUSH	D
	LXI	D,1000		;LESS THAN 1000 FILES?
	CALL	CPHD
	JC	PSIZE		;YES
	POP	D
	INX	D		;NO, REMOVE 1 SPACE
	JMP	PSIZE+1		;PRINT SIZE
PSIZE	POP	D		;GET NO. OF SPACES
	XCHG			;HL = SPACES
	CALL	TYPTX1		;PRINT THEM
	XCHG
	CALL	DECOUT		;PRINT FILE SIZE
	MVI	A,'K'
	CALL	TYPE		;ADD "K"
	CRLF			; macro

;SEE IF MORE ENTRIES

	LDA	COUNT
	DCR	A
	STA	COUNT		;DECREMENT COUNT
	JZ	BOTTOM		;NO MORE FILES TO PRINT
	LDA	COUNTP		;GET PRINT COUNT
	INR	A		;INCREMENT IT
	STA	COUNTP
	CPI	80		;80 FILES PRINTED?
	JNZ	PMORE		;NO, PRINT MORE
	CALL	TYPTX
	DB	esc,'Y73Press RETURN to see more files..','.'+80H
WAICR:
	MVI	C,1		; read a console char
	CALL	BDOS
	CPI	3		;ABORT?
	JZ	BOTTOM		;YES, QUIT EARLY
	CPI	0DH
	JNZ	WAICR		;WAIT FOR CR
	XRA	A
	STA	COUNTP		;CLEAR PRINT COUNTER
	STA	COLNO		;AND COLUMN NO.
	CALL	BORDER		;ERASE SCREEN, PRINT NEW BORDER
	LXI	H,COL1
	SHLD	COLADR		;UPDATE COLUMN ADDRESS
	MVI	C,20		;SET COUNTER
	JMP	ENTRY		;PRINT MORE FILES
PMORE:
	DCR	C		;DECREMENT COLUMN COUNTER
	JNZ	ENTRY		;MORE TO PRINT
	CALL	TYPTX
	DB	esc,'Y"',' '+80H	;RETURN TO PAGE TOP
	MVI	C,20		;SET COUNTER
	LDA	COLNO		;ELSE GET COLUMN NUMBER
	INR	A		;INCREMENT IT
	STA	COLNO
	LXI	H,COL2		;ASSUME COLUMN 2
	DCR	A		;TEST FOR IT
	JZ	SETCOL		;YES
	LXI	H,COL3		;ASSUME COLUMN 3
	DCR	A
	JZ	SETCOL
	LXI	H,COL4		;ELSE, IT'S COLUMN 4
SETCOL:
	SHLD	COLADR
	JMP	ENTRY		;PRINT MORE
;
XPERIOD:	MVI	A,'.'

;************************************************
;						*
;	Miscellaneous subroutines		*
;						*
;************************************************

TYPE:
	PUSH	B		; Type char in A
	PUSH	D
	PUSH	H
	PUSH	PSW
	MOV	E,A
	MVI	C,6		; direct console IO
	CALL	BDOS
	POP	PSW
	POP	H
	POP	D
	POP	B
	RET
;
WRCON:
	MVI	C,9		; print string on console
	JMP	BDOS
;
TYPEIT:
	MOV	A,M
	ORA	A		;TEST FOR HI BIT
	JP	TYPEIT1		;NONE THERE
	PUSH	PSW		;SAVE CHARACTER
	CALL	TYPTX
	DB	esc,'p'+80H
	POP	PSW
TYPEIT1	ANI	7FH		;STRIP PARITY BIT
	CALL	TYPE
	CALL	TYPTX
	DB	esc,'q'+80H
	INX	H
	DCR	B
	JNZ	TYPEIT
	RET
;
;COMPARE ROUTINE FOR SORT

COMPR:
	PUSH	H		;SAVE TABLE ADDR
	MOV	E,M		;LOAD LO
	INX	H
	MOV	D,M		;LOAD HI
	INX	H
	MOV	C,M
	INX	H
	MOV	B,M	; BC, DE NOW POINT TO ENTRIES TO BE COMPARED
	XCHG
CMPLP	LDAX	B
	CMP	M
	INX	H
	INX	B
	JZ	CMPLP
	POP	H
	RET			;COND CODE TELLS ALL
;
;SWAP ENTRIES IN THE ORDER TABLE

SWAP:
	MVI	A,1
	STA	SWITCH		;SHOW A SWAP WAS MADE
	MOV	C,M
	INX	H
	PUSH	H		;SAVE TABLE ADDR+1
	MOV	B,M
	INX	H
	MOV	E,M
	MOV	M,C
	INX	H
	MOV	D,M
	MOV	M,B
	POP	H
	MOV	M,D
	DCX	H		;BACK POINTER TO CORRECT LOC'N
	MOV	M,E
	RET

;BOTTOM - PRINT DISK SPACE DATA

BOTTOM:
	CALL	TYPTX
	DB	esc,'Y7','3'+80H
	LDA	PCOUNT		;GET FILE COUNT
	MOV	L,A
	MVI	H,0		;IN HL
	CALL	DECOUT		;PRINT COUNT
	CALL	TYPTX
	DB	' Files.  Used =',' '+80H
	LHLD	USED		;GET USED SPACE
	CALL	DECOUT		;PRINT IT
	CALL	TYPTX
	DB	'K.  Free =',' '+80H
	LHLD	FREE
	CALL	DECOUT		;PRINT FREE SPACE
	CALL	TYPTX
	DB	'K.',esc,'Y6',' '+80H
;
;         EXIT - ALL DONE 

ENDIT:
	LDA	CURDB		;GET CURRENT DISK
	MOV	E,A
	MVI	C,14		; select disk
	CALL	BDOS		;SET DEFAULT DISK
	LDA	USER
	MOV	E,A
	MVI	C,32
	CALL	BDOS		;SET CURRENT USER
	POP	H		;RESTORE STACK
	SPHL
	RET			;TO CP/M

;DECOUT - PRINT HL IN DECIMAL

DECOUT:
	PUSH	B
	PUSH	D
	PUSH	H		;SAVE REGISTERS
	LXI	B,-10		;RADIX FOR CONVERSION
	LXI	D,-1
DX	DAD	B		;DIVIDE BY 10
	INX	D
	JC	DX
	LXI	B,10
	DAD	B
	XCHG			;DE = DIGIT, HL = NUMBER/10
	MOV	A,H
	ORA	L		;DONE?
	CNZ	DECOUT		;CALL RECURSIVELY UNTIL DONE
	MOV	A,E		;GET CHARACTER TO PRINT
	ADI	'0'		;ADD ASCII BIAS
	CALL	TYPE		;PRINT IT
	POP	H		;RESTORE REGISTERS
	POP	D
	POP	B
	RET

;	CHL - COMPLEMENT HL

CHL:
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	RET

;	CPHD - CPMPARE HL TO DE

CPHD:
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	RET

;	TYPTX - TYPE TEXT FOLLOWING CALL

TYPTX:
	XTHL			;GET ADDRESS OF TEXT
	CALL	TYPTX1
	XTHL
	RET
TYPTX1	MOV	A,M
	ANI	7FH
	CALL	TYPE
	CMP	M
	INX	H
	JZ	TYPTX1
	RET

;	BORDER - PRINT A GRAPHIC CHARACTER BORDER FOR FILES

BORDER:
	CALL	TYPTX
	DB	esc,'Y! ',esc,'J',esc,'F'+80H
	MVI	B,4
BORD1	CALL	TYPTX
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	DCR	B
	JZ	BORD2
	MVI	A,'s'
	CALL	TYPE
	JMP	BORD1
BORD2	MVI	B,20
BORD3:	CRLF			;macro
	CALL	TYPTX
	DB	9,9,'   `',9,9,'       `',9,9,'   ','`'+80H
	DCR	B
	JNZ	BORD3
	CRLF			; MACRO
	MVI	B,4
BORD4	CALL	TYPTX
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	DCR	B
	JZ	BORD5
	MVI	A,'u'
	CALL	TYPE
	JMP	BORD4
BORD5	CALL	TYPTX
	DB	esc,'G',esc,'Y"',' '+80H
	RET

;	new subroutine to select disk drive

SETDSK:				; set disk drive
	DCR	A		; 1st is CURDA, then is CURDB
	STA	CURDB		; save it in A - binary
	MOV	E,A		; move new disk to E for call
	MVI	C,14		; select new drive
	CALL	BDOS
	RET	
;	new subroutine to find currently logged in disk

CDISK:
	MVI	C,25
	CALL	BDOS
	STA	CURDB		; 0=A, 1-B
	ADI	'A'		; convert to ASCII
	STA	CURDA		; save it in A - ASCII
	RET	

SELDSK:				; select disk in C
	LHLD	BOOT+1		; warm boot
	PUSH	D
	LXI	D,3*8		; offset
	DAD	D
	POP	D
	PCHL			; jump to address in HL

;************************************************
;						*
;	DISPLAY INFO and error messages		*
;						*
;************************************************

ILDISK:
	ERRORM	'?is invalid disk drive',ENDIT

;************************************************
;						*
;	Data Area                      		*
;						*
;************************************************

USER	DB	0		;CURRENT USER NO.
;CURDSK	DB	0		;CURRENT DISK
NFLAG	DB	0		;NO ALPHABETIZE FLAG
NEXTT	DW	TABLE		;NEXT TABLE ENTRY
COUNT	DB	0		;ENTRY COUNT
PCOUNT	DB	0		;COUNT TO PRINT
SCOUNT	DB	0		;# TO SORT
SWITCH	DB	0		;SWAP SWITCH FOR SORT
DSIZE	DW	0		;DISK SIZE
USED	DW	0		;USED SPACE
FREE	DW	0		;FREE SPACE
ALLOC	DB	0		;ALLOCATION VECTOR
BSIZE	DB	0		;BLOCK SIZE
COUNTP	DB	0		;PRINT COUNTER
;
;	Disk Parameter Block info
;
DPARM:				; copy of disk parameters
NUMSEC:	DS	2		; sectors per track (SPT)
BSHIFT:	DS	1		; Block shift factor (BSH)
BLM:	DS	1		; block mask
EMASK:	DS	1		; extent mask (EXM)
BLKMAX:	DS	2		; Max # blocks on disk (DSM)
DIRENT:	DS	2		; Max # dir entries on disk (DRM)
ALLVEC:	DS	2		; A11,A10 reversed (AL0,AL1)
CKS:	DS	2		; dir check size (CKS)
TRKOFF:	DS	2		; track offset (OFF)
DPH:	DS	2		; disk parameter header
;
DIRMAX:	DS	2		; max # of dir sectors
NETBL:	DS	2		; number of data blocks
ALLOCA	DS	1		; directory blocks (ASCII)
DIRMX2:	DS	2		; remaining direct sectors
CURDA:	DS	1		; current disk - ASCII
CURDB:	DS	1		; current disk - binary
ECOUNT:	DS	1		; entries in sector
SECTOR:	DS	2		; current sector
TRACK:	DS	2		; current track
E5FLAG:	DS	1		; found erased if = 1
BLKCNT:	DS	2		; blocks in use
;		end of new data
; 
SPACES	DB	'   ',' '+80H
COLNO	DB	0		;COLUMN NUMBER
COLADR	DW	COL1		;COLUMN MOVER ADDRESS
COL1	DB	80H
COL2	DB	9,9,esc,'C',esc,'C',esc,'C',esc,'C'+80H
COL3	DB	9,9,9,9,9+80H
COL4	DB	9,9,9,9,9,9,9,esc,'C',esc,'C',esc,'C',esc,'C'+80H
LFCB	DB	0				;,'IDENT   SYS',0,0,0,0
;	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ORDER	DS	512		;ORDER TABLE (ROOM FOR LOTS OF NAMES)
TEMP	DS	1		;SAVE DIR ENTRY
	DS	64
NSTACK:	EQU	$		;LOCAL STACK
TABLE:	EQU	$		;READ ENTRIES IN HERE
;
;HERE:
;ORG	(HERE AND 0FF00H)+100H
;BMAP:	DS	1		; block allocation map
;
	END	START
