	TITLE	EDIT - SUPER EDITOR FOR Z-DOS
	PAGE	,132
;
;THIS VERSION MODIFIED AND FORTIFIED BY --
;JIM BUSZKIEWICZ, HEATH CO.
;
;MODIFIED FURTHER BY P. SWAYNE, HUG  8-JUL-81
;
;THIS VERSION IS FOR Z-DOS  06-JAN-84
;
;NEW COMMANDS THAT WERE ADDED:
; CR = LT$$
;/ or # = 65536  (BOY DID I MISS THAT ONE)
; * REPLACED BY - (THIS SURE ISN'T BASIC)
; 'M' COMMAND = DISPLAY TEXT AND BUFFER SIZE
; 'P' COMMAND = 23L23T
; CONTROL 'C' INSTEAD OF BREAK KEY (YECH)
;'V' COMMAND SAME AS 'M' COMMAND
;HONEST BACKSPACE ADDED (JUST ABOUT)
;RULER ON THE 25TH LINE FOR THE H19 TERMINAL
;DIRECT CONSOLE I/O 
;CONTROL 'U' ADDED (ABORTS EVERYTHING FROM LAST COMMAND)
;ADDED lower CASE COMMAND CAPABILITY
;
;OUTPUT GOES TO SOURCE DRIVE UNLESS OTHERWISE
;   STATED (NOT TO SYSTEM DRIVE AS BEFORE).  (PWS)
;CONTROL-P TOGGLES PRINTER.  (PWS)
;DELETE BACKSPACES CORRECTLY OVER TABS, AND
;   DOES AN AUTOMATIC CONTROL-R IF YOU DELETE
;   A CARRIAGE RETURN.  (PWS)
;-R ERASES RULER.  (PWS)
;PROMPT CHANGED TO ">".  (PWS)
;CONTROL CHARACTERS ARE ECHOED AS PRINTABLE
;   CHARACTERS PRECEEDED BY "^".  (PWS)
;CONTROL-] (CONTROL-SHIFT-[) PLACES AN ESC
;   CHARACTER IN THE TEXT WHILE IN THE INSERT
;   MODE ONLY.  ONCE INSERTED, IT CAN ONLY
;   BE REMOVED WITH THE D COMMAND.  CONVERSION
;   FROM ^] TO AN ESCAPE CHARACTER DOES NOT
;   TAKE PLACE UNTIL THE INSERT MODE IS EXITED.
;   FROM THEN ON, THE ESCAPE IS PRINTED AS
;   DETERMINED BY THE X COMMAND.  (PWS)
;THE X COMMAND DETERMINES HOW ESCAPE CHARACTERS
;   IN THE TEXT (NOT IN A COMMAND) ARE ECHOED
;   AS FOLLOWS:
;   X$$ WILL CAUSE THEM TO BE ECHOED AS TRUE
;       ESCAPES, WITH THEIR RESULTING EFFECTS
;       ON THE TERINAL.
;   -X$$ WILL CAUSE THEM TO BE ECHOED AS ^[,
;       WITH NO EFFECT ON THE TERMINAL.
;   THE DEFAULT AT START UP IS -X.  (PWS)
;CONTROL-U (OR CONTROL-X) ONLY DELETES LAST
;   LINE TYPED (NOT EVERYTHING SINCE PROMPT.  (PWS)
;
;MODIFIED TO RUN ON CPM86 BY: Jim Buszkiewicz
;USING XLT86 AND HAND OPTIMIZATION.
;
;MODIFIED FOR Z-DOS (AND FURTHER OPTIMIZED) BY P. SWAYNE, HUG
;
;ASSEMBLE THIS PROGRAM INTO A .COM FILE!
;
;NOTE:  THE UNUSUAL CONSTRUCTION OF THIS FILE (IE. THE DATA
;AREA AT THE BEGINNING) IS BECAUSE, EVEN THOUGH IT IS A .COM FILE,
;IT USES A SEPARATE AREA FOR THE DATA SEGMENT.  SO EVEN THOUGH IT
;MAY APPEAR THAT THE EDITED FILE WOULD OVER-WRITE THE PROGRAM
;ITSELF, IT DOESN'T, BECAUSE THE TEXT IS ACTUALLY ELSEWHERE IN
;MEMORY.
;
;THE FOLLOWING LABEL DETERMINES THE WAY CONTROL-R WORKS.
;IF IT IS SET TO ZERO, EVERYTHING SINCE THE LAST PROMPT IS
;ECHOED.  IF IT IS SET TO NON-ZERO, ONLY THE LAST LINE IS
;ECHOED.
;
SPMOD	EQU	0				;SPECIAL MODIFICATION

PRMCHR	EQU	'='				;PROMPT CHARACTER
;
EDIT	SEGMENT
	ASSUME	CS:EDIT,DS:EDIT,SS:EDIT,ES:EDIT
;
	ORG	5CH
DFCB1	LABEL	NEAR				;FIRST DEFAULT FCB
	ORG	6CH
DFCB2	LABEL	NEAR				;SECOND DEFAULT FCB

	ORG	100H
START:
	JMP	START1				;JUMP OVER DATA

;	DATA -- ACTUALLY USED IN ANOTHER PART OF MEMORY

DSPTBL	DW	(Offset ACMD)			;APPEND COMMAND
	DW	(Offset BCMD)			;GO BEGINNING OF FILE COMMAND
	DW	(Offset CCMD)			;MOVE POINTER ONE CHAR COMMAND
	DW	(Offset DCMD)			;DELETE ONE CHARACTER COMMAND
	DW	(Offset ECMD)			;EXIT COMMAND
	DW	(Offset FCMD)			;FIND STRING COMMAND
	DW	(Offset GCMD)			;PRINT LINE GAUGE
	DW	(Offset HCMD)			;SET VERTICAL HEIGHT H=16 -H=24
	DW	(Offset ICMD)			;INSERT TEXT COMMAND
	DW	(Offset CMDERR)			;NO 'J' COMMAND
	DW	(Offset KCMD)			;KILL LINE COMMAND
	DW	(Offset LCMD)			;ADVANCE ONE LINE COMMAND
	DW	(Offset MCMD)			;DISPLAY MEMORY COMMAND
	DW	(Offset NCMD)			;NEXT COMMAND
	DW	(Offset CMDERR)			;NO 'O' COMMAND
	DW	(Offset PCMD)			;PAGE COMMAND
						;SET BY EITHER + OR - H
	DW	(Offset QCMD)			;QUIT COMMAND (NO CHANGES MADE)
	DW	(Offset RULCMD)			;PUT RULER ON H19 25TH LINE
	DW	(Offset SCMD)			;SUBSTITUTE NEW STRING FOR OLD
	DW	(Offset TCMD)			;CURRENT POINTER TO END OF LINE
	DW	(Offset UCMD)			;SET UPPER/LOWER CASE
	DW	(Offset MCMD)			;'V' COMMAND SAME AS 'M'
	DW	(Offset WCMD)			;WRITE OUT LINE COMMAND
	DW	(Offset XCMD)			;SWITCH ESCAPE ECHO MODE
	DW	(Offset CMDERR)			;NO 'Y' COMMAND
	DW	(Offset ZCMD)			;GO TO END OF FILE COMMAND
;
INFCNT	DB	7FH				;BYTE COUNT IN INPUT BUFFER
IFCB	DB	0				;INPUT FILE CONTROL BLOCK
IFCB1	DB	8 DUP (0)
	DB	'ASM'
	DB	0,0,0,0
IFCBRN	DB	16 DUP (0)
	DB	0
NEWMSG	DB	13,10,'NEW FILE$'
NSPMSG	DB	13,10,'NO MORE DISK SPACE$'
NSFMSG	DB	13,10,'NO SOURCE FILE SPECIFIED$'
SIGNON	DB	13,10,10,'** Z-DOS Development Editor **',13,10
	DB	'** Version 1.1  <06-Jan-84> **',13,10,10,'$'
MSMSG	DB	'Text buffer memory size is $'
GRDMSG	DB	27,106,27,120,49,27,89,56,32,'----|----1----|----2----|'
	DB	'----3----|----4----|----5----|----6----|----7----|----8'
	DB	27,107,'$'
NGDMSG	DB	27,'y1$'
UMSG	DB	'#',10,13,'$'
ILGMSG	DB	'" Illegal In This Context',13,10,'$'
VMSG1	DB	13,10,'Please Verify "'
VMSG2	DB	'*" Command (Y/N): $'
CNFMSG	DB	13,10,'Cannot Find "$'
ISFMSG	DB	13,10,'Iteration Stack Fault$'
BRKMSG	DB	13,10,'*Break*',13,10,'$'
GMSG	DB	'....+....1....+....2....+....3....+....4....+....5'
	DB	'....+....6....+....7....+...',0DH,0AH,'$'
;
OUFCNT	DB	255				;BYTE COUNT IN OUTPUT BUFFER
OFCB	DB	0				;OUTPUT FILE CONTROL BLOCK
OFCB1	DB	8 DUP (0)
	DB	'$$$'
	DB	0,0,0,0
OFCBRN	DB	16 DUP (0)
	DB	0
;
LPS	DW	(24-1)				;DEFAULT NO. OF LINES PER PAGE
TARGLN	DW	0
CMDPTR	DW	0
TXTPTR	DW	0
TXTTOP	DW	0
SPLBEG	DW	0
SPLEND	DW	0
CMDFPT	DW	0
MAXMEM	DW	0
CURCMC	DB	0
CHRTYP	DB	0
ITRCNT	DW	0
MINUS	DB	0
LINPOS	DB	0
SWFLG	DB	0
EOFFLG	DB	0
WRFLAG	DB	0
DESTDR	DB	0
XFLAG	DB	0
PFLAG	DB	0
UFLAG	DB	0
ITRLVL	DB	0
TARGST	DB	31 DUP (0)
ITRPST	DB	16 DUP (0)
ITRCST	DB	16 DUP (0)
	DB	0,0
CURCHR	DB	0
PRVCHR	DB	0
INBUF	EQU	Offset $			;INPUT BUFFER (1 SECTOR LONG)
OUTBUF	EQU	(Offset INBUF)+128		;OUTPUT BUFFER (1 SECTOR)
LINBUF	EQU	(Offset OUTBUF)+128
STAK	EQU	(Offset LINBUF)+512
FENCE	EQU	Offset STAK
TXTBUF	EQU	(Offset FENCE)+1

;	PROGRAM CODE STARTS HERE

START1:	MOV	BX,CS				;GET CODE SEGMENT
	MOV	CX,4
	MOV	DX,0
MPYLP:	SHL	BX,1				;MULTIPLY BX BY 16
	RCL	DX,1				;WITH EXCESS TO DX
	LOOP	MPYLP
	MOV	AX,Offset LEND
	ADD	BX,AX				;ADD OFFSET TO SEGMENT
	ADC	DX,0				;ADD ANY CARRY TO DX
	MOV	CL,4				;CH SHOULD BE 0
DIVLP:	SHR	DX,1				;NOW, DIVIDE BY 16
	RCR	BX,1
	LOOP	DIVLP
	INC	BX				;GO TO CLEAR PAR.
	MOV	SS,BX				;SET STACK SEGMENT
	MOV	ES,BX				;SET EXTRA SEGMENT
	MOV	SP,Offset STAK			;SET STACK
	PUSH	CS
	POP	DS				;PUT DS HERE (FOR NOW)
	MOV	SI,0
	MOV	DI,0
	MOV	CX,400H
	CLD
	REP	MOVSB				;COPY DATA TO DATA SEG
	PUSH	ES
	POP	DS				;PUT DS IN NEW SEG
	MOV	BX,0FFH				;PREPARE TO TEST MEMORY
MEMLP:	DEC	BH
	MOV	AL,Byte Ptr [BX]		;GET A BYTE
	INC	Byte Ptr [BX]			;TRY TO CHANGE MEMORY
	CMP	AL,Byte Ptr [BX]		;TEST
	MOV	Byte Ptr [BX],AL		;REPLACE THE BYTE
	JZ	MEMLP				;NO CHANGE, IT'S NOT RAM
	MOV	Word Ptr MAXMEM,BX		;STORE MEMORY TOP
;
	MOV	AL,Byte Ptr DFCB2		;GET DESTINATION DRIVE
	OR	AL,AL				;WAS ONE GIVEN?
	JNZ	STDSDR				;IF SO, STORE IT
	MOV	AL,Byte Ptr DFCB1		;GET INPUT DRIVE
STDSDR:
	MOV	Byte Ptr DESTDR,AL		;STORE DRIVE NAME
	XOR	AL,AL				;CLEAR FLAGS
	MOV	Byte Ptr SWFLG,AL
	MOV	Byte Ptr EOFFLG,AL
	MOV	BX,(Offset DFCB1)+1		;MAKE SURE THERE'S A FILENAME
	MOV	AL,Byte Ptr [BX]
	CMP	AL,' '
	JNZ	HAVNAM
	MOV	AH,9				;OTHERWISE, DIE WITH ERROR
	MOV	DX,(Offset NSFMSG)
	INT	21H
	JMP	ABORT
HAVNAM:
	MOV	DX,(Offset IFCB)		;MOVE FILENAME TO OUR INPUT FCB
	MOV	BX,Offset DFCB1
	MOV	CX,0CH
	CALL	MOVE
HAVNAME:
	MOV	DX,(Offset IFCB)		;TRY TO OPEN IT
	CALL	OPENF
	INC	AL
	MOV	AL,Byte Ptr DESTDR
	JNZ	OPNDST
	MOV	DX,(Offset NEWMSG)		;OPEN FAILED - SAY 'NEW FILE'
	MOV	AH,9
	INT	21H
	MOV	BX,Offset DFCB1			;AND CREATE THE FILE
	MOV	DX,(Offset OFCB)
	MOV	CX,0CH
	CALL	MOVE
	MOV	BX,Offset SWFLG
	MOV	Byte Ptr [BX],0FFH		;SET 'CREATE' FLAG
	INC	BX
	MOV	Byte Ptr [BX],01AH		;SET 'END OF FILE' FLAG
	MOV	AL,Byte Ptr DFCB1
OPNDST:
	MOV	Byte Ptr OFCB,AL		;SET DESTINATION DRIVE #
	MOV	DX,(Offset OFCB1)		;COPY NAME FROM FIRST FILE
	CALL	MOVNAM				;TO OUR OUTPUT FCB
	MOV	DX,(Offset OFCB)		;CREATE THE OUTPUT FILE
	CALL	MAKFIL
	JMP	MAIN				;NOW GO EDIT IT
CONIN:
	PUSH	BX
	PUSH	DX
	PUSH	CX
CONIN1:
	MOV	AH,7				;CONSOLE INPUT
	INT	21H
	CMP	AL,10H				;CONTROL-P?
	JNZ	CONIEX				;NO, EXIT
	MOV	AL,Byte Ptr PFLAG
	XOR	AL,1				;TOGGLE PRINTER FLAG
	MOV	Byte Ptr PFLAG,AL
	JMP	SHORT CONIN1			;GET ANOTHER CHARACTER
CONIEX:
	MOV	CL,AL				;SAVE CHARACTER
	MOV	AL,Byte Ptr UFLAG
	OR	AL,AL				;FORCE TO UPPER CASE?
	MOV	AL,CL
	JZ	LCASE				;NO
	CMP	AL,7FH				;DELETE CHAR?
	JZ	LCASE				;DON'T CONVERT
	CMP	AL,60H				;IS CHARACTER LC?
	JB	LCASE				;NO
	AND	AL,5FH				;FORCE TO UPPER CASE
LCASE:
	POP	CX
	POP	DX
	POP	BX
	RET
CONOUT:
	PUSH	BX				;CONSOLE OUTPUT
	PUSH	DX				;SAVE ALL REGS
	PUSH	CX
	MOV	AL,Byte Ptr UFLAG
	OR	AL,AL				;FORCE TO UPPER CASE?
	JZ	TLCASE				;NO
	MOV	AL,CL
	AND	AL,7FH				;REMOVE BIT 7
	CMP	AL,60H				;IS CHARACTER LC?
	JB	TLCASE				;NO
	AND	AL,5FH				;FORCE TO UPPER CASE
	MOV	CL,AL				;REPLACE IN C
TLCASE:
	MOV	AL,CL				;GET CHARACTER
	AND	AL,7FH				;REMOVE BIT 7
	MOV	DL,AL				;THEN CALL Z-DOS
	MOV	AH,6				;DIRECT CONSOLE I/O
	INT	21H
	MOV	AL,Byte Ptr PFLAG
	OR	AL,AL				;IS PRINTER ON?
	JZ	CONOEX				;IF NOT, EXIT
	POP	CX				;RECALL CHARACTER
	MOV	DL,CL
	PUSH	CX
	MOV	AH,5				;PRINTER FUNCTION
	INT	21H				;PRINT THE CHARACTER
CONOEX:
	POP	CX				;RESTORE REGS
	POP	DX
	POP	BX
	RET
CSTS:
	PUSH	BX
	PUSH	DX
	PUSH	CX
	MOV	AH,6				;CONSOLE STATUS (BREAK TEST)
	MOV	DL,0FFH				;DIRECT CONSOLE I/O (FF=INPUT)
	INT	21H
	POP	CX
	POP	DX
	POP	BX
	RET
GETBYT:
	MOV	AL,Byte Ptr EOFFLG		;READ A BYTE FROM THE INPUT FILE
	OR	AL,AL				;FIRST CHECK END-OF-FILE
	MOV	AL,01AH
	JZ	GTBYT2
	RET
GTBYT2:
	PUSH	CX				;NOW WE KNOW WE'VE GOT SOMETHING
	PUSH	DX
	PUSH	BX
GTBYT1:
	MOV	BX,(Offset INFCNT)		;CHECK BYTE COUNT IN BUFFER
	INC	Byte Ptr [BX]			;WILL SET MINUS IF AT END
	JS	READF				; WHICH SAYS TO READ SOME MORE
	MOV	CL,Byte Ptr [BX]		;OTHERWISE, ADD COUNT TO BUFFER
	MOV	CH,0				;ADDRESS, GIVING ADDRESS OF
	MOV	BX,(Offset INBUF)		;NEXT BYTE
	ADD	BX,CX
	MOV	AL,Byte Ptr [BX]		;FETCH THE BYTE
	CMP	AL,01AH				;MAKE SURE IT'S NOT EOF
	JNZ	GTBYT3
GTBYT4:
	MOV	Byte Ptr EOFFLG,AL		;WE READ AN EOF, SO SET FLAG
GTBYT3:
	AND	AL,07FH				;STRIP THE PARITY BIT
	POP	BX				;RESTORE REGS
	POP	DX
	POP	CX
	RET					;AND EXIT
READF:
	MOV	BX,(Offset INFCNT)		;COME HERE TO READ NEXT BUFFER
	MOV	Byte Ptr [BX],0FFH		;RIG THE COUNT SO NEXT INC WILL
	MOV	DX,(Offset INBUF)		;GIVE US BYTE ZERO
	MOV	AH,01AH				;'SET DMA ADDRESS' CALL TO Z-DOS
	INT	21H
	MOV	DX,(Offset IFCB)		;ISSUE 'READ' CALL TO Z-DOS
	MOV	AH,014H
	INT	21H
	CMP	AL,1				;TEST FOR EOF
	JNZ	GTBYT1				;OTHERWISE, PROCESS BYTE
	MOV	AL,01AH				;GOT EOF - SEND BACK EOF CHARACTER
	JMP	SHORT GTBYT4
PUTBYT:
	MOV	AH,Byte Ptr WRFLAG		;WRITE DISABLED?
	OR	AH,AH
	JZ	PTBYT0				;NO
	RET					;ELSE, RETURN
PTBYT0:	PUSH	BX				;WRITE A BYTE TO THE OUTPUT FILE
	PUSH	DX
	MOV	BX,(Offset OUFCNT)		;BUMP OUTPUT BUFFER COUNT
	INC	Byte Ptr [BX]			;GOES NEGATIVE AFTER 128 BYTES
	JNS	PTBYT1	
	CALL	WRITEF				;FLUSH BUFFER BEFORE CONTINUING
PTBYT1:
	MOV	AL,Byte Ptr [BX]
	MOV	AH,0				;ADD BYTE COUNT TO BUFFER BASE
	MOV	BX,(Offset OUTBUF)		;GIVING ADDRESS OF NEXT BYTE
	ADD	BX,AX
	MOV	Byte Ptr [BX],CL		;AND STORE IN BUFFER
	CMP	CL,1AH				;WAS IT AN EOF?
	JNZ	PTBYT2
	MOV	Byte Ptr WRFLAG,1		;DISABLE WRITE ROUTINE
	MOV	SI,BX				;SAVE POINTER TO BUFFER
	MOV	BX,(Offset OUFCNT)		;NOW FLUSH LAST OUTPUT BUFFER
	MOV	AL,Byte Ptr [BX]
	INC	AL				;UPDATE COUNTER TO WHERE WE ARE
ENDLP:	INC	SI
	MOV	Byte Ptr [SI],0			;FILL REST OF BUFFER WITH ZEROS
	INC	AL
	JNS	ENDLP
	CALL	WRITEF
	MOV	AH,010H				;CLOSE THE OUTPUT FILE
	MOV	DX,(Offset OFCB)
	INT	21H
	MOV	BX,(Offset IFCB1)		;MOVE INPUT NAME TO SECOND HALF
	MOV	AL,Byte Ptr OFCB		;OF OUTPUT FCB, IN PREPARATION
	MOV	DX,(Offset OFCBRN)		;FOR RENAME OPERATION
	MOV	SI,DX
	MOV	[SI],AL
	INC	DX
	PUSH	CX
	MOV	CX,0BH
	CALL	MOVE
	POP	CX
PTBYT2:
	POP	DX				;RESTORE REGISTERS AND EXIT
	POP	BX
	RET
WRITEF:
	MOV	Byte Ptr [BX],0			;HERE TO FLUSH OUTPUT BUFFER
	MOV	AH,01AH				;  CLEAR BYTE COUNT
	MOV	DX,(Offset OUTBUF)		;'SET DMA ADDRESS' TO Z-DOS
	INT	21H
	MOV	DX,(Offset OFCB)		;ISSUE 'WRITE' TO Z-DOS
	MOV	AH,015H
	INT	21H
	MOV	BX,(Offset OUFCNT)		;POINT TO BYTE COUNT (PUTBYT) 
	CMP	AL,1				;TEST FOR 'NO SPACE' ERROR A=1
	JZ	WRITF1	
	RET					;NO ERROR - RETURN
WRITF1:
	MOV	DX,(Offset NSPMSG)		;SCREAM ABOUT ERROR
	MOV	AH,9
	INT	21H
	MOV	DX,(Offset OFCB)		;CLOSE OUTPUT (SAVE WHAT WE CAN)
	MOV	AH,010H
	INT	21H
BYEBYE:
	MOV	AL,Byte Ptr SWFLG		;EXIT - FIRST CHECK CREATE FLAG
	OR	AL,AL
	JZ	BYE4
ABORT:
	PUSH	CS
	POP	DS				;FIX DATA SEGMENT
	INT	20H				;NO CREATE, EXIT
BYE4:
	MOV	DX,(Offset IFCB)		;YES CREATE - WE MUST CLOSE IT
	MOV	AH,010H
	INT	21H
	JMP	SHORT ABORT			;THEN EXIT
;
MAKFIL:						;PERFORM ALL STEPS OF
						;CREATING A FILE
	PUSH	DX				;MAKE AN OUTPUT FILE
	MOV	AH,013H				;FIRST DELETE OLD ONE
	INT	21H
	POP	DX
	PUSH	DX
	MOV	AH,016H				;THEN CREATE NEW ONE
	INT	21H
	POP	BX
	MOV	Word Ptr 14[BX],128		;INSERT RECORD SIZE
	RET
OPENF:
	MOV	AH,0FH				;OPEN THE FILE WITH FCB AT (DX)
	INT	21H
	RET
MOVNAM:
	MOV	BX,(Offset DFCB1)+1		;COPY NAME FIELD ONLY
	MOV	CX,8				;FROM FIRST DEFAULT FCB
MOVE:
	PUSH	DS
	POP	ES				;ENSURE ES IS HERE
	MOV	SI,BX
	MOV	DI,DX
	CLD
	REP	MOVSB
	MOV	BX,SI
	MOV	DX,DI
	RET
FILL:
	MOV	Byte Ptr [BX],CH		;FILL [BX] WITH (CH)
	INC	BX
	DEC	CL				;UNTIL CL=0
	JNZ	FILL
	RET
;
;
CRLF:
	MOV	CL,0DH				;PRINT CARRIAGE RETURN, LINE FEED
	CALL	PCHAR
	MOV	CL,0AH
PCHAR:
	PUSH	DX				;PRINT A CHARACTER
	PUSH	BX				;WITH FULL FORMATTING
PCHAR1:
	MOV	CH,1				;ITERATION COUNT
	MOV	AL,CL				;LOOK AGAIN AT CHARACTER TO PRINT
	SUB	AL,0DH				;CARRIAGE RETURN?
	JNZ	PCHAR4
	MOV	Byte Ptr LINPOS,AL		;IF CARRIAGE RETURN, CLEAR COLUMN COUNT
	JMP	SHORT PCHAR6
PCHAR4:
	MOV	AL,CL				;GET THE CHARACTER
	CMP	AL,9				;TAB?
	JNZ	PCHAR2
	MOV	AL,Byte Ptr LINPOS		;SEE WHERE WE'RE AT ON THE LINE
	AND	AL,7				;GET THE BITS NECESSARY
	NOT	AL				;SEE WHICH ONES ARE OFF
	AND	AL,7				;GET RID OF HIGH BITS AGAIN
	ADD	AL,1
	MOV	CH,AL				;SAVE IT AS A COUNT
	MOV	CL,' '+80H			;GET A SPACE WITH BIT 7
PCHAR2:
	MOV	AL,CL				;GET THE CHARACTER
	CMP	AL,177Q				;DELETE CHARACTER?
	JNZ	PCHR27	
	JMP	PCHAR7				;THEY DO NOTHING
PCHR27:
	CMP	AL,0AH				;LINE FEED?
	JZ	PCHAR6				;DON'T COUNT LINE FEED
	MOV	BX,Offset LINPOS		;GET LINE POINTER
	MOV	BL,Byte Ptr [BX]
	MOV	BH,0				;HL = LINE POINTER
	MOV	DX,Offset LINBUF		;POINT TO LINE BUFFER
	ADD	BX,DX				;FIND POSITION IN IT
	MOV	Byte Ptr [BX],CL		;STORE CHARACTER THERE
	MOV	BX,Offset LINPOS		;OTHERWISE BUMP THE
	INC	Byte Ptr [BX]			;COUNT
PCHAR6:
	PUSH	CX				;SAVE COUNT AND CHARACTER
	MOV	AL,CL				;GET CHARACTER
	CMP	AL,0DH				;CR?
	JZ	NOTCTL				;PRINT AS IS
	CMP	AL,0AH				;LF?
	JZ	NOTCTL				;PRINT AS IS
	CMP	AL,1BH				;ESCAPE?
	JNZ	CPI20				;IF NOT, GO ON
	CMP	Byte Ptr XFLAG,0		;HOW SHALL WE ECHO AN ESCAPE?
	JNZ	NOTCTL				;ECHO AS A TRUE ESCAPE
CPI20:
	CMP	AL,20H				;OTHER CONTROL CHARACTER?
	JNB	NOTCTL				;IF NOT, CONTINUE
	MOV	CL,'^'				;PRINT "^"
	CALL	CONOUT
	MOV	BX,Offset LINPOS		;GET LINE POSITION
	INC	Byte Ptr [BX]			;INCREMENT IT
	MOV	BL,Byte Ptr [BX]
	MOV	BH,0				;HL = LINEPOS
	MOV	DX,Offset LINBUF
	ADD	BX,DX				;FIND PLACE IN LINE BUFFER
	MOV	Byte Ptr [BX],CL		;PUT IN "^" TO TAKE SPACE
	POP	CX				;RESTORE CHARACTER
	PUSH	CX
	MOV	AL,CL				;GET CHARACTER
	ADD	AL,40H				;MAKE IT PRINTABLE
	MOV	CL,AL
NOTCTL:
	CALL	CONOUT				;PRINT IT
	POP	CX
	DEC	CH				;BUMP THE ITERATION
	JZ	PCHAR7	
	JMP	PCHAR2				;AND KEEP DOING IT
PCHAR7:
	POP	BX				;RESTORE REGS
	POP	DX
	RET					;AND EXIT
MESSBC:
	MOV	BH,CH				;PRINT MESSAGE AT M(BC)
	MOV	BL,CL				; FOR LENGTH (DE)
MESSHL:
	MOV	CL,Byte Ptr [BX]
	INC	BX
	CALL	PCHAR
	CALL	BRKCHK
	OR	DX,DX
	JZ	BRKCK1
	DEC	DX
	JMP	SHORT MESSHL
BRKCHK:
	CALL	CSTS
	OR	AL,AL
	JNZ	BRKCK2
BRKCK1:
	RET
BRKCK2:
	AND	AL,07FH				;STRIP PARITY FROM CHARACTER
	CMP	AL,3				;CONTROL 'C' INSTEAD OF BREAK
	JNZ	BRKCK3	
	JMP	BREAK
BRKCK3:
	CMP	AL,023Q				;MAYBE IT'S A CONTROL 'S'
	JZ	HOLD
	RET
HOLD:
	CALL	CONIN
	CMP	AL,003Q				;CONTROL 'C'
	JNZ	HOLD1	
	JMP	BREAK
HOLD1:
	RET
INCCMD:
	MOV	AL,Byte Ptr ITRLVL		;MOVE POINTER TO NEXT COMMAND
	OR	AL,AL				;ONLY IF NO ITERATIONS ARE
	JNZ	HOLD1
	MOV	DX,Word Ptr CMDFPT
	MOV	BX,Word Ptr MAXMEM		;TOP OF RAM -> HL
	DEC	BX				;BACK OFF BY 1 BYTE
	MOV	Word Ptr CMDFPT,BX		;CMDFPT POINTS TO 2ND CHARACTER
	PUSH	BX				;SAVE IT
	MOV	BX,Offset CMDPTR		;GET POINTER TO END OF COMMAND
	MOV	AX,DX				;SUBTRACT FORWARD POINTER TO
	SUB	AX,Word Ptr [BX]		;GET LENGTH OF COMMAND STRING
	MOV	CX,AX
	JB	INCCDN				;IF LENGTH GOES NEGATIVE, QUIT
	INC	CX				;SOMETHING IS LEFT
	XCHG	BX,DX				;OLD FWD PNTR -> HL
	POP	DX				;NEW FWD PNTR -> DE
CMDMOV:
	PUSH	DS
	POP	ES				;ENSURE ES IS HERE
	MOV	SI,BX
	MOV	DI,DX
	STD					;PACK DOWN USED COMMAND PARTS
	REP	MOVSB				; TO MAKE MORE ROOM FOR TEXT
	MOV	BX,SI
	MOV	DX,DI
	PUSH	DX				;DX IS NOW NEW END POINTER
INCCDN:
	POP	BX				;GET END POINTER
	INC	BX
	MOV	Word Ptr CMDPTR,BX		;AND SAVE IT
	RET
GETCMD:
	MOV	CL,PRMCHR			;PROMPT FOR A COMMAND STRING
	CALL	PCHAR
GETCM8:
	MOV	BX,Word Ptr MAXMEM		;STORED UPSIDE DOWN
	MOV	Word Ptr CMDPTR,BX		; SO THAT COMMAND BUFFER
	DEC	BX				; GROWS TOWARDS TEXT BUFFER
	MOV	Word Ptr CMDFPT,BX
	XOR	AL,AL
	MOV	Byte Ptr PRVCHR,AL
	MOV	Byte Ptr ITRLVL,AL		;CLEAR PREVIOUS CHARACTER AND..
						;ITERATION LEVEL
	CALL	CONIN
	CMP	AL,0DH
	JNZ	GETCM0
	CALL	CRLF
	CALL	LCMD
	MOV	Word Ptr SPLBEG,BX
	MOV	BX,Word Ptr TXTTOP
	MOV	Word Ptr SPLEND,BX
	CALL	TCMD
	JMP	SHORT GETCMD
GETCML:
	CALL	CONIN				;LOOP, FETCHING CMD CHARS
GETCM0:
	MOV	Byte Ptr CURCHR,AL		;SAVE AS CURRENT CHARACTER
	CMP	AL,003Q				;BREAK?
	JNZ	GETCM1	
	JMP	BREAK
GETCM1:
	MOV	DX,Word Ptr MAXMEM		;TOP OF RAM -> DE
	MOV	BX,Word Ptr CMDPTR		;CMD STACK PTR -> HL
	CMP	AL,18H				;CONTROL-X?
	JZ	CNTLX				;YES, PROCESS
	CMP	AL,025Q				;CONTROL-U?
	JNZ	GETCM9
CNTLX:
	PUSH	DX
	MOV	DX,Offset UMSG
	MOV	AH,9
	INT	21H
	POP	DX
	MOV	BX,Word Ptr CMDPTR		;GET COMMAND POINTER
CTLX1:
	MOV	AL,Byte Ptr [BX]		;GET CHAR
	CMP	AL,0AH				;END OF LINE?
	JZ	FNDIT				;YES, FOUND IT
	PUSH	DX
	MOV	DX,Word Ptr MAXMEM		;POINT TO MAX MEMORY
	CMP	BX,DX				;HAVE WE BACKED UP THAT FAR
	POP	DX				;RESTORE DE
	JZ	FNDIT				;BACKED UP ALL THE WAY
	INC	BX				;BACK UP MORE
	JMP	SHORT CTLX1
FNDIT:
	MOV	Word Ptr CMDPTR,BX		;UPDATE COMMAND POINTER
	XOR	AL,AL
	MOV	Byte Ptr PRVCHR,AL		;CLEAR PREVIOUS CHAR
	PUSH	DX
	MOV	DX,Word Ptr MAXMEM		;GET MAX MEM
	CMP	BX,DX				;AT TOP
	POP	DX
	JZ	FNDIT1	
	JMP	GETCML				;IF NOT GET ANOTHER LINE
FNDIT1:
	JMP	GETCMD				;GET A NEW COMMAND
;
GETCM9:
	CMP	AL,012H				;CONTROL-R?
	JNZ	RUBOUT
	CALL	CRLF				;CONTROL-R MEANS RE-ECHO BUFFER
	CMP	BX,DX				;MAKE SURE THERE'S WHAT TO ECHO
	JNZ	CNTLR0	
	JMP	GETCMD
CNTLR0:
;
	IF	SPMOD
	PUSH	DX
SPMDLP:	MOV	SI,DX
	MOV	AL,[SI]				;GET A CHARACTER
	CMP	AL,0AH				;IS IT END OF LINE?
	JNZ	SPMD1				;IF NOT, KEEP LOOKING
	INC	SP
	INC	SP				;POINT TO WHERE DX STORED
	PUSH	DX				;REPLACE IT
SPMD1:	DEC	DX				;MOVE TO NEXT CHAR
	CMP	BX,DX				;END OF TEXT?
	JNZ	SPMDLP				;IF NOT, KEEP LOOKING
	POP	DX				;DX = ADDR OF LAST CRLF
	ENDIF
;
CNTLR:	CMP	BX,DX				;DONE YET?
	JNZ	CNTLR1	
	JMP	GETCML
CNTLR1:
	DEC	DX				;NO, FETCH NEXT CHARACTER
	MOV	SI,DX
	MOV	AL,[SI]
	CMP	AL,01BH				;CHANGE ESCAPE TO DOLLAR SIGN
	JNZ	RNOTES
	MOV	AL,'$'
RNOTES:
	MOV	CL,AL				;PRINT CHARACTER
	CALL	PCHAR
	JMP	SHORT CNTLR			;AND GET SOME MORE
RUBOUT:
	CMP	AL,07FH				;WAS A RUBOUT TYPED?
	JZ	RUBOT1	
	CMP	AL,8				;** BACK SPACE?
	JZ	RUBOT1				;** YES
	JMP	STCMCH
RUBOT1:
	CMP	BX,DX				;TEST FOR EMPTY BUFFER
	JNZ	DELNES	
	JMP	CMDOVR
DELNES:
	MOV	BX,Word Ptr CMDPTR
	MOV	CH,1				;DEFAULT ERASE COUNT
	MOV	AL,Byte Ptr [BX]
	CMP	AL,9				;WAS IT A TAB?
	JNZ	NOTAB				;NOT A TAB
	PUSH	BX
	PUSH	DX				;SAVE DE,HL
	MOV	BX,Offset LINPOS		;POINT TO LINE POSITION
	MOV	BL,Byte Ptr [BX]
	MOV	BH,0				;HL = LINE POSITION
	MOV	DX,Offset LINBUF		;POINT TO LINE BUFFER
	ADD	BX,DX				;GET POSITION IN BUFFER
	MOV	CH,0				;CLEAR COUNT
CNTBLP:
	DEC	BX				;GET PREVIOUS CHARACTER
	MOV	AL,Byte Ptr [BX]
	CMP	AL,' '+80H			;IS IT A SPACE
	JNZ	TBLPEX				;IF NOT, STOP BACKING
	INC	CH				;INCREMENT COUNT TO BACKSPACE
	MOV	AL,CH
	CMP	AL,8				;REACHED A TAB STOP?
	MOV	AL,20H				;REPLACE SPACE
	JNZ	CNTBLP				;TRY AGAIN
TBLPEX:
	POP	DX
	POP	BX				;RESTORE DE,HL
	JMP	SHORT DELNES4				;BACK SPACE
NOTAB:
	CMP	AL,1BH				;IF ESCAPE, ERASE THE '$' SIGN
	JZ	DELNES4
	CMP	AL,0AH				;LF?
	JZ	DELNES3				;IGNORE IT
	CMP	AL,0DH				;CR?
	JNZ	CP20H				;IF NOT, CONTINUE
	XOR	AL,AL
	MOV	Byte Ptr LINPOS,AL		;CLEAR LINE POSITION
	MOV	Byte Ptr PRVCHR,AL		;CLEAR PREVIOUS CHAR FLAG
	INC	Word Ptr CMDPTR			;BACK UP COMMAND POINTER
	MOV	AL,12H				;CONTROL-R
	JMP	GETCM0				;EXECUTE A CONTROL-R
CP20H:
	CMP	AL,020H				;ANY OTHER CONTROL CHARACTERS
	JNB	DELNES4				;IF NOT, CONTINUE
	MOV	CH,2				;DELETE 2 CHARACTERS
DELNES4:
	DEC	Byte Ptr LINPOS			;BUMP LINE POSITION BY ONE
DELNES2:
	MOV	CL,'H'-040H			;GET A CONTROL 'H'
	CALL	CONOUT				;PRINT IT
	MOV	CL,' '				;GET A SPACE
	CALL	CONOUT				;PRINT IT
	MOV	CL,'H'-040H			;ANOTHER CONTROL 'H'
	CALL	CONOUT				;AND PRINT IT
	DEC	CH				;DO IT AGAIN?
	JNZ	DELNES4				;LOOP UNTIL FINISHED
;
DELNES3:
	XOR	AL,AL				;CLEAR 'PREVIOUS CHAR' FLAG
	MOV	Byte Ptr PRVCHR,AL
	INC	Word Ptr CMDPTR			;BACK UP COMMAND PTR...
						;BECAUSE OF DELETE CHARACTER
	JMP	GETCML				;LOOP BACK FOR NEXT INPUT
CMDOVR:
	CALL	CRLF				;DEL PAST BEGINNING - SEND CRLF
	JMP	GETCMD				;AND RE-PROMPT
STCMCH:
	MOV	BX,Word Ptr CMDPTR		;HERE TO STORE COMMAND CHAR
	MOV	DX,-20				;MAKE SURE THERE'S ROOM
	ADD	BX,DX
	XCHG	BX,DX
	MOV	BX,Word Ptr TXTTOP
	CMP	BX,DX
	JB	HVROOM
	PUSH	BX
	PUSH	DX
	MOV	DL,7				;NO RAM LEFT - RING BELL
	MOV	AH,6
	INT	21H
	POP	DX
	POP	BX
	JMP	GETCML				;AND HOPE NEXT CHAR IS RUBOUT
HVROOM:
	MOV	AL,Byte Ptr CURCHR		;GET CURRENT CHARACTER
	CMP	AL,0DH				;TEST FOR CARRIAGE RETURN
	JNZ	NOCR
	MOV	BX,Word Ptr CMDPTR		;STORE CARRIAGE RETURN
	DEC	BX
	MOV	Word Ptr CMDPTR,BX
	MOV	CL,0DH
	MOV	Byte Ptr [BX],CL		;IN COMMAND BUFFER
	CALL	PCHAR				;ECHO IT
	MOV	AL,0AH				;ECHO AND STORE A LF BEHIND IT
NOCR:
	MOV	Byte Ptr CURCHR,AL		;SAVE CURRENT CHAR
	CMP	AL,01BH				;IS IT AN ESCAPE?
	MOV	CL,AL				;IF ESCAPE, ECHO '$' INSTEAD
	JNZ	ECHOCM
	MOV	CL,'$'
ECHOCM:
	CALL	PCHAR				;ECHO THE COMMAND CHARACTER
	MOV	BX,Word Ptr CMDPTR		;BUMP COMMAND STACK POINTR
	DEC	BX
	MOV	Word Ptr CMDPTR,BX
	MOV	AL,Byte Ptr CURCHR		;STORE CHAR IN COMMAND BUFFER
	MOV	Byte Ptr [BX],AL
	CMP	AL,01BH				;IF CURRENT CHARACTER IS..
						;ESCAPE, WHAT WAS PREVIOUS?
	JNZ	SETPRV
	MOV	AL,Byte Ptr PRVCHR		;IF PREV WAS ESCAPE, SEND CRLF
	CMP	AL,01BH				;AND RETURN
	JNZ	SETPRV	
	JMP	CRLF
SETPRV:
	MOV	AL,Byte Ptr [BX]		;CURRENT CHAR PREVIOUS CHAR
	MOV	Byte Ptr PRVCHR,AL
	JMP	GETCML				;AND GO GET SOME MORE
GETCDC:
	MOV	DX,Word Ptr CMDPTR		;END OF COMMAND -> DE
	MOV	BX,Word Ptr CMDFPT		;CURRENT POINTER -> HL
	CMP	BX,DX				;COMMAND EXHAUSTED?
	JNB	GETCD2	
	CALL	GETCMD				;READ ANOTHER COMMAND IF NEEDED
GETCD2:
	MOV	Byte Ptr CHRTYP,2		;INIT CHARACTER TYPE TO 'OTHER'
	MOV	BX,Word Ptr CMDFPT
	MOV	AL,Byte Ptr [BX]		;GET COMMAND CHARACTER
	CMP	AL,'#'
	JZ	BIGNO				;HE MUST WANT LOTS
	CMP	AL,'/'				;SAME THING AS #
	JZ	BIGNO
	CMP	AL,'A'
	JB	GETCD1				;SET FLAG FOR ALPHA OR NUMERIC
	CMP	AL,'Z'+1			;TEST FOR ALPHA UPPER CASE
	JB	LETTER				;IT IS
	CMP	AL,'a'				;LESS THAN "a"?
	JB	GETCD1				;YES
	CMP	AL,'z'+1			;IF ALPHABETIC, CHRTYP=0
	JNB	GETCDN
LETTER:	MOV	Byte Ptr CHRTYP,0
GETCD1:
	CMP	AL,'0'				;IF NUMERIC, CHRTYP=1
	JB	GETCDN
	CMP	AL,'9'+1
	JNB	GETCDN
BIGNO:
	MOV	Byte Ptr CHRTYP,1
GETCDN:
	MOV	BX,Word Ptr CMDFPT		;ADVANCE COMMAND FORWARD PNTR
	DEC	BX
	MOV	Word Ptr CMDFPT,BX
	RET
GETNUM:
	MOV	AL,Byte Ptr CURCMC		;PARSE A NUMBER FROM THE COMMAND
	CMP	AL,'-'				; STRING
	JNZ	CKPLUS				;SET MINUS FLAG IF WE SEE A MINUS
	MOV	BX,Offset MINUS
	MOV	Byte Ptr [BX],0FFH
	CALL	GETCDC				;AND GET NEXT CHAR
	MOV	Byte Ptr CURCMC,AL		;INTO 'CURRENT CMD CHAR'
	JMP	SHORT CNVNUM
CKPLUS:
	CMP	AL,'+'				;SWALLOW A PLUS SIGN IF PRESENT
	JNZ	CNVNUM
	CALL	GETCDC
	MOV	Byte Ptr CURCMC,AL
CNVNUM:
	MOV	BX,0
CNVLUP:
	MOV	AL,Byte Ptr CHRTYP		;TEST FOR NUMERIC
	CMP	AL,1
	JNZ	CNVDON				;QUIT IF NOT NUMERIC
	MOV	AL,Byte Ptr CURCMC
	CMP	AL,'#'
	JZ	CNVLP3
	CMP	AL,'/'
	JNZ	CNVLP1
CNVLP3:
	MOV	BX,0FFFFH			;MAKE H-L BIG
	JMP	SHORT CNVLP2
CNVLP1:
	MOV	DX,BX				;MULTIPLY HL BY 10
	SHL	BX,1
	SHL	BX,1
	ADD	BX,DX
	SHL	BX,1
	MOV	AL,Byte Ptr CURCMC		;CONVERT DIGIT TO NUMBER
	SUB	AL,'0'
	MOV	DL,AL				;AND ADD IT TO HL
	MOV	DH,0
	ADD	BX,DX
CNVLP2:
	PUSH	BX				;BUMP TO NEXT CMD CHAR
	CALL	GETCDC
	POP	BX
	MOV	Byte Ptr CURCMC,AL		;MAKE IT CURRENT
	JMP	SHORT CNVLUP				;AND GO CONVERT IT
CNVDON:
	MOV	Word Ptr ITRCNT,BX		;COMPLETED NO. = ITERATION COUNT
	MOV	AL,Byte Ptr MINUS		;MINUS ZERO BECOMES MINUS ONE
	ROR	AL,1
	JAE	CNVDNR
	OR	BX,BX
	JNZ	CNVDNR
	INC	BX
	MOV	Word Ptr ITRCNT,BX
CNVDNR:
	RET					;DONE
SKPLIN:
	MOV	BX,Word Ptr ITRCNT		;SKIP FORWARD OR BACKWARD
	MOV	CX,BX				; (ITRCNT) LINES
	MOV	BX,Word Ptr TXTTOP		;END OF TEXT -> HL
	MOV	AX,Offset TXTBUF		;END=BEG? (BUFF EMPTY)
	SUB	AX,BX
	JZ	CNVDNR				;IF EMPTY, QUIT (RETURN)
	XCHG	BX,DX				;END OF TEXT -> DE
	MOV	BX,Word Ptr TXTPTR		;CURRENT POSN -> HL
	OR	CX,CX				;ITRCNT=0 MEANS BACKWARD SKIP
	LAHF
	INC	CX				;ANYWAY, WE ALWAYS WANT ITRCNT+1
	SAHF
	JZ	SKPBAK				;TO ACCOUNT FOR CURRENT LINE
	MOV	AL,Byte Ptr MINUS		;ITRCNT#0, SO CHECK SIGN FLAG
	ROR	AL,1
	JNB	SKPFWD				;TO DECIDE WHICH WAY TO SKIP
SKPBAK:
	INC	CX				;BACKWARD SKIP - ITRCNT+2 -> BC
	CMP	BX,DX				;ARE WE AT END OF TEXT?
	JNZ	SKPBA1
	MOV	DX,Offset TXTBUF		;IS END ALSO BEGINNING?
	CMP	BX,DX
	JZ	SKPBA1				;IF SO, BACK OFF SO WE FIND EOF
	DEC	BX				;  ON FIRST TEST
SKPBA1:
	MOV	DH,0FFH				;SEARCH FOR FF (END OF TEXT)
	MOV	DL,0AH				;OR LINEFEED
SKPBA2:
	DEC	CX				;DECREMENT ITERATION COUNT
	JZ	SKPBA4				;DONE
SKPBA3:
	MOV	AL,Byte Ptr [BX]		;TEST NEXT CHARACTER
	CMP	AL,DH				;END OF BUFFER?
	JZ	SKPBDN
	DEC	BX
	CMP	AL,DL				;LINEFEED?
	JNZ	SKPBA3				;BUMP POINTER AND TRY AGAIN
	JMP	SHORT SKPBA2			;FOUND ONE, MORE ITERATIONS?
SKPBA4:
	INC	BX				;FOUND RIGHT NUMBER OF LF'S - 
SKPBDN:
	INC	BX				;POINTER TO BE AFTER LAST LF
	RET
SKPFWD:
	MOV	DH,0FFH				;HERE TO SKIP FORWARD..
						;SEARCH FOR END OF BUFFER
	MOV	DL,0AH				;OR LINEFEED
SKPFW1:
	DEC	CX				;DECREMENT ITERATION COUNT
	JNZ	SKPFW2
	RET
SKPFW2:
	MOV	AL,Byte Ptr [BX]		;TEST NEXT CHARACTER
	CMP	AL,DH				;END OF BUFFER?
	JNZ	SKPFW3
	RET
SKPFW3:
	INC	BX				;BUMP POINTER
	CMP	AL,DL				;LINEFEED
	JNZ	SKPFW2				;TRY NEXT IF NO MATCH
	JMP	SHORT SKPFW1			;CHECK ITERATION COUNT IF MATCH
SEARCH:
	MOV	Byte Ptr TARGLN,0		;TARGET STRING LENGTH TO ZERO
GTARGT:
	MOV	CX,Offset TARGST		;COPY STRING FROM CMD BUFFER
	MOV	BX,Word Ptr TARGLN		;INTO TARGET BUFFER AND UPDATE
	ADD	BX,CX				;TARGET LENGTH
	PUSH	BX
	CALL	GETCDC
	POP	BX
	MOV	Byte Ptr [BX],AL
	SUB	AL,01BH				;END COPY ON AN ESCAPE CHAR
	JZ	DOSEAR				;AND GO DO THE SEARCH
	MOV	BX,Offset TARGLN
	MOV	AL,Byte Ptr [BX]
	SUB	AL,020H				;TARGET BUFFER OVERFLOW?
	JNB	GTARGT				;NO
	INC	Byte Ptr [BX]			;IF YES, IGNORE EXTRA CHARS
	JMP	SHORT GTARGT
DOSEAR:
	MOV	BX,Word Ptr TXTPTR		;ACTUALLY PERFORM THE SEARCH
	XCHG	BX,DX				;TEXT POINTER -> DE
	DEC	DX				;BUMP ONE BECAUSE OF ALGORITHM
SEARL1:
	MOV	BX,Offset TARGST		;RESET TARGET STRING POINTER
SEARL2:
	INC	DX				;FETCH CHAR FROM TEXT BUFFER
	MOV	SI,DX
	MOV	AL,[SI]
	CMP	AL,0FFH				;END OF BUFFER?
	JZ	SEARER				;IF END, GIVE NOTICE
	CMP	AL,Byte Ptr [BX]		;COMPARE BUFFER TO TARGET
	JNZ	SEARL2				;NO MATCH, TRY NEXT
	MOV	CX,DX				;MATCHED FIRST CHARACTER SO..
						;SAVE ITS POSITION
SEARL3:
	INC	BX				;SEE IF REST OF STRING MATCHES
	INC	DX				;BUMP BOTH TARGET AND BUFFER
	MOV	SI,DX				;FETCH NEXT FROM BUFFER
	MOV	AL,[SI]
	CMP	AL,Byte Ptr [BX]		;MATCH?
	JZ	SEARL3				;YUP, KEEP GOING
	MOV	AL,Byte Ptr [BX]		;NO MATCH, MAYBE A 'DONT CARE'
	CMP	AL,'|'				;OR 'BAR' IS DON'T CARE CHAR
	JZ	SEARL3
	CMP	AL,01BH				;NEITHER MATCH NOR DON'T CARE..
						;BUT WE MAY BE DONE
	MOV	DX,CX				;PREPARE FOR RETRY BY RESTORING
						;BUFFER POINTER
	JZ	SRCHRT				;LAST TARGET WAS ESCAPE..
						;WE'RE DONE
	MOV	SI,DX				;TEST FOR END OF BUFFER
	MOV	AL,[SI]
	CMP	AL,0FFH
	JZ	SEARER				;IF END, ERROR
	JMP	SHORT SEARL1			;RESTORE TARGET PTR & CONTINUE
SEARER:
	STC					;NOT FOUND -SET CARRY FOR ERROR
SRCHRT:
	RET
NOFIND:
	MOV	DX,Offset CNFMSG		;SAY 'CAN NOT FIND...'
	MOV	AH,9
	INT	21H
	MOV	AL,Byte Ptr TARGLN		;ECHO TARGET STRING AS WELL
	OR	AL,AL
	JZ	ENDQUO
	MOV	CX,Offset TARGST
	MOV	DL,AL
	DEC	DL				;DECREMENT LENGTH TO AVOID
						;TERMINATING ESCAPE
	MOV	DH,0
	CALL	MESSBC
ENDQUO:
	MOV	CL,022H				;TERMINATING QUOTE AND CRLF
	CALL	CONOUT
	CALL	CRLF
	JMP	BREAK
PACK:
	MOV	DX,Word Ptr SPLBEG		;PACK DOWN TEXT BUFFER AFTER
						; A DELETE-TYPE OPERATION
	MOV	BX,Word Ptr TXTPTR		;BEGINNING OF SPLIT -> DE
						;CURRENT POSITION -> HL
						;IF EQUAL, NO PACK REQUIRED
	CMP	DX,BX
	JNE	PACKON
	RET
PACKON:
	MOV	BX,Offset SPLEND		;OTHERWISE LENGTH OF SPLIT = BX
	MOV	AL,Byte Ptr [BX]
	SUB	AL,DL
	INC	BX
	MOV	CL,AL
	MOV	AL,Byte Ptr [BX]
	SBB	AL,DH
	MOV	CH,AL
	JB	PACKDN				;IF SPLIT LENGTH=0, QUIT
	INC	CX				;ADJUST LENGTH
	MOV	DX,Word Ptr SPLBEG		;START OF SPLIT -> DE
	MOV	BX,Word Ptr TXTPTR		;CURRENT POINTER -> HL
PACKLP:
	PUSH	DS
	POP	ES
	MOV	SI,DX
	MOV	DI,BX
	CLD					;PACK CHARS FROM SPLIT
	REP	MOVSB				;TOWARDS CURRENT POINTER
	MOV	DX,SI
	MOV	BX,DI
	DEC	BX				;SET END OF TEXT MARKER
						;AT NEW END OF BUFFER
	MOV	Byte Ptr [BX],0FFH
	MOV	Word Ptr TXTTOP,BX		;STORE NEW END VALUE
	JMP	INCCMD				;GO REPACK COMMAND BUFFER
PACKDN:
	MOV	BX,Word Ptr TXTTOP		;DELETE ONLY COVERED ONE CHAR
	DEC	BX				;SO JUST RESET END OF BUFFER
	MOV	Word Ptr TXTTOP,BX
	MOV	Byte Ptr [BX],0FFH		;AND MARK IT
	JMP	INCCMD				;AND GO PACK COMMAND BUFFER

;	MAIN PROGRAM STARTS HERE

MAIN:
	MOV	DX,Offset SIGNON		;PRINT SIGNON MESSAGE
	MOV	AH,9
	INT	21H
	MOV	DX,Offset MSMSG			;PRINT MEMORY SIZE MESSAGE
	MOV	AH,9
	INT	21H
	CALL	MCMD1				;PRINT MEMORY SIZE ITSELF
	MOV	BX,-1
	MOV	Word Ptr FENCE,BX		;MARK ENDS OF BUFFER
	MOV	BX,(Offset TXTBUF)
	MOV	Word Ptr TXTPTR,BX		;INITIALIZE CURRENT POINTER
	MOV	Word Ptr TXTTOP,BX		;AND END POINTER
CMDLUP:
	CALL	GETCMD				;GET FIRST COMMAND STRING
FOREVR:
	CALL	NXTCMD				;PROCESS COMMANDS FOREVER
	JMP	SHORT FOREVR
NXTCMD:
	MOV	BX,Word Ptr TXTPTR		;MAKE SPLIT POINTERS MATCH
	MOV	Word Ptr SPLBEG,BX		;ACTUAL BUFFER POINTERS
	MOV	BX,Word Ptr TXTTOP
	MOV	Word Ptr SPLEND,BX
	MOV	BX,(Offset MINUS)		;CLEAR MINUS FLAG
	MOV	Byte Ptr [BX],0
	MOV	BX,1				;DEFAULT TO ONE ITERATION
	MOV	Word Ptr ITRCNT,BX
	CALL	GETCDC				;NEXT CHAR FROM COMMAND STRING
	MOV	Byte Ptr CURCMC,AL		;SAVE IT
	CMP	AL,'-'				;IF + OR -,
	JZ	CPUSH				;  THEN GET A NUMBER
	CMP	AL,'+'
	JZ	CPUSH
	MOV	AL,Byte Ptr CHRTYP		;IF NUMERIC, ALSO GET A NUMBER
	CMP	AL,1
	JNZ	NOTNUM
CPUSH:
	CALL	GETNUM				;GET NUMBER INTO ITRCNT
NOTNUM:
	MOV	AL,Byte Ptr CURCMC		;GET CURRENT CHARACTER
	CMP	AL,'<'				;START OF ITERATION?
	MOV	BX,(Offset ITRLVL)		;PREPARE TO STACK AN ITERATION
	MOV	CH,0
	JNZ	CPOP
	INC	Byte Ptr [BX]			;INC ITERATION STACK COUNT
	MOV	CL,Byte Ptr [BX]		;AND FETCH IT
	MOV	AL,8				;STACK OVERFLOW? 8 LEVELS MAX.
	CMP	AL,Byte Ptr [BX]
	JNB	PUSHIT
	MOV	DX,Offset ISFMSG		;PRINT STACK FAULT MESSAGE
	MOV	AH,9
	INT	21H
	JMP	BREAK				;AND FAKE A BREAK
PUSHIT:
	MOV	BX,Word Ptr CMDFPT		;PUT COMMAND FORWARD POINTER..
						;ONTO ITS STACK
	XCHG	BX,DX
	MOV	BX,(Offset ITRPST)
	ADD	BX,CX
	ADD	BX,CX
	MOV	Word Ptr [BX],DX
	MOV	BX,Word Ptr ITRCNT		;ITERATION COUNT ONTO ITS STACK
	XCHG	BX,DX
	MOV	BX,(Offset ITRCST)
	ADD	BX,CX
	ADD	BX,CX
	MOV	Word Ptr [BX],DX
	INC	BX
	RET					;GO BACK FOR NEXT COMMAND
CPOP:
	CMP	AL,'>'				;END OF ITERATION?
	JNZ	DISPAT
	MOV	CL,Byte Ptr [BX]		;CHECK ITERATION LEVEL
	MOV	AL,CL
	OR	AL,AL				;IF ZERO, IGNORE
	JZ	DISPAT
	MOV	BX,(Offset ITRCST)		;POINT TO ITERATION COUNT ON
	ADD	BX,CX				; CURRENT LEVEL
	ADD	BX,CX
	MOV	AL,Byte Ptr [BX]
	SUB	AL,1				;DECREMENT IT
	MOV	Byte Ptr [BX],AL
	INC	BX
	MOV	AL,Byte Ptr [BX]
	SBB	AL,0
	MOV	Byte Ptr [BX],AL
	DEC	BX				;CURRENT LEVEL'S COUNT=0?
	OR	AL,Byte Ptr [BX]
	JZ	DRPSTK				;IF YES, DROP ITERATION STACKS
	MOV	BX,(Offset ITRPST)		;OTHERWISE, RESTORE COMMAND PTR
	ADD	BX,CX				;FOR THIS LEVEL
	ADD	BX,CX
	MOV	DX,Word Ptr [BX]
	INC	BX
	XCHG	BX,DX
	MOV	Word Ptr CMDFPT,BX
	RET
DRPSTK:
	MOV	BX,(Offset ITRLVL)		;DECREMENT ITERATION LEVEL
	DEC	Byte Ptr [BX]
	RET
DISPAT:						;****COMMAND DISPATCHER***
	MOV	AL,Byte Ptr CHRTYP		;IF WE GET HERE WITH OTHER
	OR	AL,AL				;THAN A LETTER, IT'S AN ERROR
	JZ	DISPAT2	
	JMP	CMDERR
DISPAT2:
	MOV	AL,Byte Ptr CURCMC		;CONVERT LETTER TO DISPATCH
	CMP	AL,'Z'+1			;SEE IF IT'S UPPER CASE
	JB	DISPAT1				;JUMP IF IT IS
	SUB	AL,040Q				;OTHERWISE MAKE IT UPPER CASE
DISPAT1:
	SUB	AL,'A'				;  TABLE INDEX
	MOV	BL,AL
	MOV	BH,0
	SHL	BX,1
	MOV	DX,(Offset DSPTBL)		;INDEX TO RIGHT TABLE ENTRY
	ADD	BX,DX
	MOV	DX,Word Ptr [BX]
	XCHG	BX,DX
	JMP	BX				;AND DISPATCH TO IT
ACMD:						;*****APPEND COMMAND*****
	MOV	BX,Word Ptr ITRCNT
	MOV	CX,BX
APPLIM:
	MOV	BX,Word Ptr CMDPTR
	MOV	DX,-40
	ADD	BX,DX
	XCHG	BX,DX
	MOV	BX,Word Ptr TXTTOP
APPEND:
	CMP	BX,DX
	JNB	FLGEND
ACMLUP:
	CALL	GETBYT
	OR	AL,AL
	JZ	ACMLUP
	CMP	AL,07FH
	JZ	ACMLUP
	CMP	AL,01AH
	JZ	FLGEND
	MOV	Byte Ptr [BX],AL
	INC	BX
	CMP	AL,0AH
	JNZ	APPEND
	LOOP	APPEND
FLGEND:
	MOV	Word Ptr TXTTOP,BX
	MOV	Byte Ptr [BX],0FFH
	RET
BCMD:
	MOV	AL,Byte Ptr MINUS
	OR	AL,AL				;-B?
	JZ	BCMD1	
	JMP	ZCMD
BCMD1:
	MOV	BX,(Offset TXTBUF)
	MOV	Word Ptr TXTPTR,BX
	RET
CCMD:
	CALL	MOVPTR
	MOV	Word Ptr TXTPTR,BX
	RET
MOVPTR:
	MOV	AL,Byte Ptr MINUS
	ROR	AL,1
	MOV	BX,Word Ptr TXTPTR
	XCHG	BX,DX
	MOV	BX,Word Ptr ITRCNT
	JNB	CPLUS
	SUB	DX,BX
	MOV	BX,(Offset TXTBUF)
	CMP	BX,DX
	JAE	MVPTRR
	XCHG	BX,DX
MVPTRR:
	RET
CPLUS:
	ADD	BX,DX
	XCHG	BX,DX
	MOV	BX,Word Ptr TXTTOP
	CMP	BX,DX
	JB	CPLUSR
	XCHG	BX,DX
CPLUSR:
	RET
DCMD:
	CALL	MOVPTR
	MOV	AL,Byte Ptr MINUS
	ROR	AL,1
	XCHG	BX,DX
	MOV	BX,(Offset TXTPTR)
	JB	DELSET
	MOV	BX,(Offset SPLBEG)
DELSET:
	MOV	Byte Ptr [BX],DL
	INC	BX
	MOV	Byte Ptr [BX],DH
	JMP	PACK
ECMD:
	MOV	AL,'E'
	CALL	VERFY				;MAKE SURE HE WANTS TO EXIT
	MOV	BX,(Offset TXTBUF)
ECMLUP:
	MOV	AL,Byte Ptr [BX]
	CMP	AL,0FFH
	JZ	CPREST
	MOV	CL,AL
	CALL	PUTBYT
	INC	BX
	JMP	SHORT ECMLUP
CPREST:
	CALL	GETBYT
	CMP	AL,01AH
	MOV	CL,AL
	PUSHF
	CALL	PUTBYT
	POPF
	JNZ	CPREST
	MOV	CL,01AH
	CALL	PUTBYT
	MOV	AL,Byte Ptr SWFLG
	OR	AL,AL
	JZ	CPREST1	
	JMP	ABORT
CPREST1:
	MOV	DX,Offset IFCB
	PUSH	DX
	MOV	AH,010H
	INT	21H
	POP	BX
	MOV	DX,Offset IFCBRN
	PUSH	DX
	MOV	CX,9
	CALL	MOVE
	XCHG	BX,DX
	MOV	Byte Ptr [BX],'B'
	INC	BX
	MOV	Byte Ptr [BX],'A'
	INC	BX
	MOV	Byte Ptr [BX],'K'
	INC	BX
	MOV	CX,015H
	CALL	FILL
	POP	DX
	MOV	AH,013H
	INT	21H
	MOV	DX,Offset IFCB
	MOV	AH,017H
	INT	21H
	MOV	DX,Offset OFCB
	MOV	AH,017H
	INT	21H
	JMP	ABORT
FCMD:
	CALL	SEARCH
	JNB	FCMD1	
	JMP	NOFIND
FCMD1:
	MOV	BX,Word Ptr TARGLN
	ADD	BX,DX
	MOV	Word Ptr TXTPTR,BX
	RET
GCMD:
	PUSH	CX
	PUSH	DX
	PUSH	BX
	MOV	DX,Offset GMSG
	MOV	AH,9
	INT	21H				;PRINT LINE GAUGE
	POP	BX
	POP	DX
	POP	CX
	RET
HCMD:
	MOV	AL,Byte Ptr MINUS		;WHICH WAY?
	AND	AL,AL				;TEST
	MOV	AL,12-1				;ASSUME POSITIVE
	JZ	HSET				;IS SO
	MOV	AL,24-1				;NEGATIVE STANDARD 24 LINES
HSET:	MOV	Byte Ptr LPS,AL			;HOW MANY LINES FIT ON SCREEN
	RET
ICMD:
	CALL	GETCDC
	CMP	AL,01BH
	JNZ	ICMD2	
	JMP	PACK
ICMD2:
	MOV	BX,Word Ptr CMDFPT
	INC	BX
	MOV	Word Ptr CMDFPT,BX
ICMD1:
	CALL	INCCMD
	MOV	CX,-20
	MOV	BX,Word Ptr CMDPTR
	ADD	BX,CX
	XCHG	BX,DX
	MOV	BX,Word Ptr SPLEND
	CMP	BX,DX
	JNAE	ICMD3	
	JMP	BREAK
ICMD3:
	XCHG	BX,DX
	PUSH	BX
	MOV	BX,(Offset SPLBEG)
	MOV	AX,DX
	SUB	AX,Word Ptr [BX]
	MOV	CX,AX
	POP	BX
	JB	L09CE
	PUSH	DX
	PUSH	BX
	MOV	BX,Word Ptr CMDFPT
	MOV	DX,0
GTISIZ:
	MOV	AL,Byte Ptr [BX]
	CMP	AL,01BH
	JZ	GOTSIZ
	INC	DX
	DEC	BX
	JMP	SHORT GTISIZ
GOTSIZ:
	MOV	BX,Word Ptr TXTPTR
	ADD	BX,DX
	ADD	BX,CX
	INC	CX
	XCHG	BX,DX
	POP	BX
	CMP	BX,DX
	JNB	L09B5
	XCHG	BX,DX
L09B5:
	POP	BX
	CMP	BX,DX
	JNB	L09D1
	XCHG	BX,DX
	MOV	Word Ptr TXTTOP,BX
	MOV	Word Ptr SPLEND,BX
L09C3:
	PUSH	DS
	POP	ES
	MOV	SI,DX
	MOV	DI,BX
	STD					;MOVE BACKWARDS
	REP	MOVSB
	MOV	DX,SI
	MOV	BX,DI
	INC	BX
L09CE:
	MOV	Word Ptr SPLBEG,BX
L09D1:
	MOV	BX,Word Ptr TXTPTR
	XCHG	BX,DX
	MOV	BX,Word Ptr SPLBEG
	SUB	BX,DX
	MOV	CX,BX
	MOV	BX,Word Ptr CMDFPT
L09E1:
	MOV	AL,Byte Ptr [BX]
	DEC	BX
	CMP	AL,01BH
	JZ	L09F1
	CMP	AL,1DH				;CONTROL-]?
	JNZ	NOTECH
	MOV	AL,1BH				;REPLACE WITH ESC
NOTECH:	MOV	SI,DX
	MOV	[SI],AL
	INC	DX
	LOOP	L09E1
	MOV	AL,Byte Ptr [BX]
L09F1:
	MOV	Word Ptr CMDFPT,BX
	XCHG	BX,DX
	MOV	Word Ptr TXTPTR,BX
	CMP	AL,01BH
	JZ	L09F11
	JMP	ICMD1
L09F11:
	CALL	INCCMD
	JMP	PACK
KCMD:
	CALL	SKPLIN
	MOV	Word Ptr SPLBEG,BX
	XCHG	BX,DX
	MOV	BX,Word Ptr TXTPTR
	CMP	BX,DX
	JNB	KCMD1	
	JMP	PACK
KCMD1:
	MOV	Word Ptr SPLBEG,BX
	XCHG	BX,DX
	MOV	Word Ptr TXTPTR,BX
	JMP	PACK
LCMD:
	CALL	SKPLIN
	MOV	Word Ptr TXTPTR,BX
	RET
MCMD:
	MOV	BX,Word Ptr TXTTOP		;GET END OF TEXT ADDR
	MOV	DX,(Offset TXTBUF)
	SUB	BX,DX				;SUBTRACT START OF TEXT = SIZE
	CALL	DECOUT				;PRINT TEXT SIZE
	MOV	CL,'/'				;THEN SLASH
	CALL	PCHAR
MCMD1:
	MOV	BX,Word Ptr MAXMEM		;NOW GET MAX. MEMORY ADDR AVAIL
	MOV	DX,(Offset TXTBUF)
	SUB	BX,DX				;SUBTRACT TO GET AVAIL SIZE
	CALL	DECOUT				;PRINT IT
	JMP	CRLF
;
;	DECIMAL PRINT SUBROUTINE
;	PRINTS H,L AS A DECIMAL NO.
;
DECOUT:	MOV	DX,-10000
	CALL	PRTDGT				;PRINT 10'S OF THOUSANDS
	MOV	DX,-1000
	CALL	PRTDGT				;PRINT THOUSANDS
	MOV	DX,-100
	CALL	PRTDGT				;PRINT HUNDREDS
	MOV	DX,-10
	CALL	PRTDGT				;PRINT TENS
	MOV	DX,-1
PRTDGT:	MOV	CL,'0'-1			;INITIALIZE COUNT
	PUSH	BX				;SO INITIAL INC SP'S WON'T HURT
PRT1:	INC	CL				;BUMP COUNT OF SUCCESSFUL SUBTR
	INC	SP				;POP STACK W/O ALTERING REGS
	INC	SP
	PUSH	BX				;SAVE H,L
	ADD	BX,DX				;DO 1 SUBTRACTION
	JB	PRT1				;IF RESULT STILL POS., DO AGAIN
	POP	BX				;RESTORE LAST GOOD VALUE TO H,L
	JMP	PCHAR				;PRINT CHAR & RETURN
NCMD:
	CALL	SEARCH
NCMD1:
	JNAE	NCMD2	
	JMP	FCMD1
NCMD2:
	MOV	DX,-120
	MOV	BX,Word Ptr CMDPTR
	ADD	BX,DX
	XCHG	BX,DX
	MOV	BX,Word Ptr TXTTOP
	CMP	BX,DX
	JB	NAPP
	MOV	BX,032H
	MOV	Word Ptr ITRCNT,BX
	CALL	WCMD
NAPP:
	MOV	BX,Word Ptr TXTTOP
	PUSH	BX
	MOV	CX,1
	CALL	APPLIM
	POP	BX
	CMP	AL,01AH
	JNZ	NAPP1	
	JMP	NOFIND
NAPP1:
	MOV	Word Ptr TXTPTR,BX
	MOV	BX,Word Ptr TXTTOP
	MOV	Word Ptr SPLEND,BX
	CALL	DOSEAR
	JMP	SHORT NCMD1
;
PCMD:	MOV	BX,Word Ptr ITRCNT		;SAVE ITERATION COUNT
	PUSH	BX				;ON STACK
	MOV	BX,Word Ptr LPS			;NO LINES ON SCREEN
	MOV	Word Ptr ITRCNT,BX
	CALL	LCMD				;DO L PART
	MOV	BX,Word Ptr LPS			;NOW SET UP FOR TYPE
	MOV	Word Ptr ITRCNT,BX
	MOV	AL,Byte Ptr MINUS		;SAVE SIGN
	MOV	Byte Ptr MINUS,0		;MAKE IT POSITIVE
	PUSH	AX				;ON STACK
	CALL	TCMD				;DO TYPE PART
	POP	AX				;NOW RESTOR MINUS
	MOV	Byte Ptr MINUS,AL
	MOV	BX,Word Ptr TXTPTR		;GET TEXT POINTER
	MOV	AL,Byte Ptr [BX]		;GET DATA
	CMP	AL,0FFH				;END OF BUFFER?
PCMD1:	POP	BX				;END OF BUFFER REACHED
	JZ	PCMD2
	DEC	BX				;SEE IF DONE
	JNZ	PCMD3	
PCMD2:
	RET					;YES? DONE
PCMD3:
	MOV	Word Ptr ITRCNT,BX		;PUT IT BACK
	MOV	BX,-1				;NOW A LITTLE DELAY
DELY:	DEC	BX
	MOV	AL,BL
	OR	AL,BH
	JNZ	DELY
	JMP	SHORT PCMD				;AND REPEAT
QCMD:
	MOV	AL,'Q'
	CALL	VERFY				;MAKE SURE HE WANTS TO QUIT
	MOV	DX,Offset OFCB
	MOV	AH,010H
	INT	21H
	MOV	DX,Offset OFCB
	MOV	AH,013H
	INT	21H
	JMP	BYEBYE
RULCMD:
	MOV	AL,Byte Ptr MINUS		;TEST FOR MINUS PREFIX
	OR	AL,AL
	JNZ	NRLCMD				;ERASE RULER IF NECESSARY
	MOV	DX,Offset GRDMSG		;PUT A RULER ON THE 25TH LINE
	MOV	AH,9
	INT	21H
	JMP	SHORT RULEX
NRLCMD:
	MOV	DX,Offset NGDMSG		;ERASE RULER
	MOV	AH,9
	INT	21H
RULEX:
	MOV	SP,Offset STAK
	JMP	CMDLUP
SCMD:
	CALL	SEARCH
	JNB	SCMD1	
	JMP	NOFIND
SCMD1:
	MOV	BX,Word Ptr TARGLN
	ADD	BX,DX
	MOV	Word Ptr SPLBEG,BX
	MOV	Word Ptr TXTPTR,DX
	JMP	ICMD
TCMD:
	CALL	SKPLIN
	XCHG	BX,DX
	MOV	BX,Word Ptr TXTPTR
	MOV	AL,BL
	SUB	AL,DL
	MOV	BL,AL
	MOV	AL,BH
	SBB	AL,DH
	MOV	BH,AL
	XCHG	BX,DX
	JNB	TCMD1
	MOV	BX,Word Ptr TXTPTR
	NOT	DX
	INC	DX
TCMD1:
	MOV	CX,BX
	CMP	DX,0
	LAHF
	DEC	DX
	SAHF
	JZ	TCMD2
	JMP	MESSBC
TCMD2:
	RET
UCMD:
	MOV	AL,Byte Ptr MINUS
	OR	AL,AL
	JNZ	MINU
	MOV	AL,1
	MOV	Byte Ptr UFLAG,AL		;SET UPPER CASE
	RET
MINU:	XOR	AL,AL
	MOV	Byte Ptr UFLAG,AL		;SET LOWER CASE
	RET
WCMD:
	MOV	BX,(Offset MINUS)
	MOV	Byte Ptr [BX],0
	MOV	BX,(Offset TXTBUF)
	MOV	Word Ptr TXTPTR,BX
	CALL	SKPLIN
	MOV	Word Ptr SPLBEG,BX
	XCHG	BX,DX
	MOV	BX,(Offset TXTBUF)
WCMDL:
	CMP	BX,DX
	JNAE	WCMDL1	
	JMP	PACK
WCMDL1:
	MOV	CL,Byte Ptr [BX]
	INC	BX
	CALL	PUTBYT
	JMP	SHORT WCMDL
XCMD:
	MOV	SP,Offset STAK			;RESET STACK
	MOV	AL,Byte Ptr MINUS
	OR	AL,AL
	JNZ	MINX				;-X ENTERED
	MOV	AL,1
	MOV	Byte Ptr XFLAG,AL		;FLAG TRUE ESCAPE ECHO
	JMP	CMDLUP
MINX:	XOR	AL,AL
	MOV	Byte Ptr XFLAG,AL		;FLAG ^[ ECHO
	JMP	CMDLUP
ZCMD:
	MOV	BX,Word Ptr TXTTOP
	MOV	Word Ptr TXTPTR,BX
	RET
;
;
CMDERR:
	MOV	AL,Byte Ptr CURCMC
	CMP	AL,' '+1
	JNB	CMDR52
	RET
CMDR52:
	CALL	CRLF
	MOV	CL,'"'
	CALL	CONOUT
	MOV	BX,(Offset CURCMC)
	MOV	CL,Byte Ptr [BX]
	CALL	PCHAR
	MOV	DX,Offset ILGMSG
BRKOUT:
	MOV	SP,Offset STAK
	MOV	AH,9
	INT	21H
	JMP	CMDLUP
;
;VERIFY OPERATORS INTENTIONS
;
VERFY:
	MOV	Byte Ptr VMSG2,AL		;STORE LETTER OF THE COMMAND..
						;IN MESSAGE
	MOV	DX,Offset VMSG1			;ASK OPERATOR TO CONFIRM CMD
	MOV	AH,9
	INT	21H
	CALL	CONIN				;GET HIS ANSWER
	PUSH	AX				;SAVE HIS ANSWER
	MOV	CL,AL				;ECHO
	CALL	PCHAR				;IT
	CALL	CRLF				;PRINT CR-LF
	POP	AX				;RESTORE HIS ANSWER
	AND	AL,0DFH				;CONVERT TO UPPER CASE
	CMP	AL,'Y'				;IS IT A YES
	JNZ	VERFY1	
	RET					;ALLOW HIM TO DO IT TO IT
VERFY1:
	MOV	SP,Offset STAK			;ELSE RESET THE STACK
	JMP	CMDLUP				;AND WARM START THE EDITOR
;
BREAK:
	MOV	DX,Offset BRKMSG
	JMP	SHORT BRKOUT
LEND	EQU	Offset $

EDIT	ENDS
	END	START
		;AND WARM START THE EDITOR
;
BREAK:
	MOV	DX,Offset BRK