	TITLE	Z-DOS Menu Program
	PAGE	,132
;
;	Z-DOS Menu Program
;
;	Author: R. A. Metz		Date: 2/16/83
;
;	MODIFIED BY P. SWAYNE, HUG  22-DEC-83
;	
;	This program provides a method for menu access to 
;	Z-DOS programs on a Z-100 system.
;
;	This program will display a menu similar to that used
;	by the Install program of Wordstar.  The user will move
;	the highlighted line using the cursor up/down keys and
;	selects an entry using the enter/return key.  The help
;	key is also active and if pressed, the contents of the
;	file 'MENU.DAT' are displayed on the screen 23 lines per
;	page.  MENU.DAT will contain any desired instructions to
;	the user.  When a menu item is selected, a number of things
;	happen according to the command table entry associated
;	with the selected line:
;
;		1) - The default drive is set according to the entry
;	in the command table.  The reason behind this is the fact 
;	that a design consideration for this menu system was for
;	the user to have the menu disk containing all his programs
;	in the 'A' drive and a data disk containing all his files
;	in the 'B' drive.  Setting the default drive to 'B' would
;	save his specifying 'B:' on all his data file specifications.
;	Some programs (Multiplan in particular) require the default
;	drive to contain all or parts of the program itself and
;	therefore, the default drive for these programs must be 'A'.
;
;		2) - The menu program then does one of three things
;	based on the entry flag in the command table:
;
;		a) - The program specified in the command table entry
;	is loaded and entered directly from the menu program without
;	further aid from the Z-DOS command processor.  When the
;	program terminates, this menu program regains control and
;	immediately re-displays the main menu.  Commands must be
;	'COM' files for this option to be used.
;
;		b) - If, for some reason, the above method fails, or
;	if specifically requested in the command table entry, this
;	program will build a batch command file X.BAT on the 'B'
;	drive (the 'B' drive is used so that the menu disk in the
;	'A' drive may be write protected) and exit to Z-DOS.  The
;	final entry written to X.BAT is an XA command.  XA is a 
;	batch file containing a command to invoke the menu program
;	followed by a command to invoke the X.BAT file.  In this
;	manner, the menu is always returned to following program
;	termination.  Note: the AUTOEXEC.BAT file should contain
;	as its final entry the XA command to invoke the menu
;	system.  
;		A design consideration of the menu system is that
;	it is desirable for the menu program to always regain
;	control following execution of a user requested program.
;	While method b) will accomplish that purpose and is the
;	method most often used in MS-DOS systems, it is agon-
;	izingly slow as Z-DOS thrashes around through the various
;	batch files and commands.  The preferred method, if at all
;	possible, is a) above as the menu is instantly returned to
;	following program execution.
;
;		c) - If the manual entry flag is set in the command
;	table entry (special entry type of which there should only
;	be one or none) the screen is cleared, some terse instructions
;	displayed, and the user is prompted for the manual entry of
;	a command.  The menu program will process that command in
;	the following manner:
;
;		i) - a special table is searched for a match.  This
;	table contains entries which are to be processed in a 
;	special manner (see spec_string_table).
;		ii) - a 'COM' file of the entered command is searched
;	for on disk 'A' if no drive specification is entered or on 
;	the specified drive is searched for.  If found, that program
;	is loaded and executed.  When the program terminates, the
;	menu program regains control and prompts the user for the
;	next command.
;		iii) - if a 'COM' file cannot be found, a batch
;	stream X.BAT is created with the command entered and the
;	menu program exits to the Z-DOS command interpreter.  The
;	final record written to X.BAT is XM which is a batch 
;	file containing a command to enter the menu program at
;	the manual entry point (full menu not displayed).  Again,
;	X.BAT is written to the 'B' drive so as to allow the
;	disk in the 'A' drive to be write protected.  The menu
;	program begins processing at the manual entry point if
;	an argument is present in the MENU command.
;
;
;	Menu program resource requirements:
;
;	AUTOEXEC.BAT :
;
;		DATE
;		TIME
;		XA
;
;	XA.BAT:
;
;		A:MENU
;		B:X
;
;	XM.BAT:
;
;		A:MENU X
;		B:X
;
;	MENU.DAT:	User instructions, 23 lines per page.
;		   	Page 2 is displayed in response to '?'
;			from manual entry screen.
;
;	B:X.BAT:	Created by menu program if necessary to
;			use batch method of program entry.
;
;	MENU.TBL	Special file containing the menu tables.
;			This file contains 1 1600-byte record
;			organized as follows:
;
;		20 80-byte table entries giving a maximum of 20
;		menu line items.  Each 80-byte record consists of 
;		2 40-byte sub-fields:
;		20-bytes of menu line display information:
;			byte 0,1 - screen address of start of display
;				   in CRT screen address format.
;				   '99' indicates end of table.
;			bytes 2-39 - displayed line - terminated 
;				    with a '$' (up to 37 bytes of
;				    display information)
;		20-bytes of line item command information:
;			byte 0 - Default disk id for command:
;				'0'=A, '1'=B
;			byte 1 - Entry flag:
;				'0'=direct(command is COM file)
;				'1'=indirect(Command is EXE or BAT file)
;				'2'=manual (Special for user entered
;					    command)
;			bytes 2-39 - Command line associated with menu
;				item.  This command should use
;				explicit disc names and must be
;				terminated with the string:
;					0DH,0AH,24H (CR,LF,$)
;
;		Note: a BASIC program 'BUILD' is provided to build
;		this record from user entered data.  BUILD is prim
;		and if improvement is desired, it will be up to the
;		user.  Since it is written in BASIC, modification is
;		relatively easy.
;
;	Comments:  This program works best when it performs all
;		program loads itself.  The intrinsic Z-DOS commands
;		as well as any EXE commands pose a problem in that
;		they must be accessed in batch mode in order for 
;		this program to regain control after command
;		execution.  The next release of this program (if
;		ever done) will contain an EXE program loader and
;		will itself process all intrinsic commands.  It
;		will then phsically replace the COMMAND.COM 
;		program provided with Z-DOS.
;
;
	SUBTTL	Definitions
	PAGE
MENU	SEGMENT
	ASSUME	DS:MENU,CS:MENU,SS:MENU,ES:MENU
	ORG	5CH
FCB1:
	ORG	6CH
FCB2:
	ORG	80H
BUF:				; Default buffer address
	ORG	100H
START:
	MOV	SP,OFFSET STACK
	PUSH	AX
	JMP	BEGIN		; Skip around data
ESC	EQU	1BH
;
DSKMSG	DB	ESC,'E'
	DB	'Please put a data disk in drive B.'
	DB	0DH,0AH
	DB	'Press any key to continue--$'
MENU_HDR	DB	ESC,'E'	; Clear screen
	DB	ESC,'x1'	; Enable 25th line
	DB	ESC,'Y8 '
	DB	80 DUP (' ')	; Clear 25th line
	DB	ESC,'y?'	; Disable kbd expansion
	DB	ESC,'x5'	; Cursor off
	DB	ESC,'Y 6'
	DB	ESC,'q'		; Normal video
	DB	ESC,'F'		; Graphic mode
	DB	'f'
	DB	33 DUP ('a')
	DB	'c'
	DB	ESC,'Y!6`'
	DB	ESC,'G'
	DB	'      HUG Z-DOS MENU SYSTEM      '
	DB	ESC,'F`'
	DB	ESC,'Y"6`'
	DB	ESC,'G'
	DB	10 DUP (' ')
	DB	'Version 1.101'
	DB	10 DUP (' ')
	DB	ESC,'F'
	DB	'`',ESC,'Y#6e'
	DB	33 DUP ('a')
	DB	'd'
	DB	ESC,'Y1-f'
	DB	12 DUP ('a')
	DB	's'
	DB	12 DUP ('a')
	DB	's'
	DB	12 DUP ('a')
	DB	's'
	DB	12 DUP ('a')
	DB	'c'
	DB	ESC,'Y2-`'
	DB	ESC,'G'
	DB	'  Key ==>   '
	DB	ESC,'F`',ESC,'G'
	DB	'    Help    '
	DB	ESC,'F`',ESC,'G'
	DB	'   Cursor   '
	DB	ESC,'F`',ESC,'G'
	DB	'   Enter    '
	DB	ESC,'F`'
	DB	ESC,'Y3-`'
	DB	ESC,'G'
	DB	12 DUP (' ')
	DB	ESC,'F`',ESC,'G'
	DB	'            '
	DB	ESC,'F`',ESC,'G'
	DB	'  Up/Down   '
	DB	ESC,'F`',ESC,'G'
	DB	12 DUP (' ')
	DB	ESC,'F`'
	DB	ESC,'Y4-v'
	DB	12 DUP ('a')
	DB	'b'
	DB	12 DUP ('a')
	DB	'b'
	DB	12 DUP ('a')
	DB	'b'
	DB	12 DUP ('a')
	DB	't'
	DB	ESC,'Y5-`'
	DB	ESC,'G'
	DB	' Action ==> '
	DB	ESC,'F`',ESC,'G'
	DB	'  Display   '
	DB	ESC,'F`',ESC,'G'
	DB	'    Move    '
	DB	ESC,'F`',ESC,'G'
	DB	'    Make    '
	DB	ESC,'F`'
	DB	ESC,'Y6-`'
	DB	ESC,'G'
	DB	12 DUP (' ')
	DB	ESC,'F`',ESC,'G'
	DB	' information'
	DB	ESC,'F`',ESC,'G'
	DB	'  indicator '
	DB	ESC,'F`',ESC,'G'
	DB	' Selection  '
	DB	ESC,'F`'
	DB	ESC,'Y7-e'
	DB	12 DUP ('a')
	DB	'u'
	DB	12 DUP ('a')
	DB	'u'
	DB	12 DUP ('a')
	DB	'u'
	DB	12 DUP ('a')
	DB	'd'
	DB	ESC,'G$'
;
EXITMSG	DB	ESC,'y5'	; Cursor on
	DB	ESC,'x?'	; Kbd expansion on
	DB	ESC,'G'		; Graphics off
	DB	ESC,'q'		; Normal video
	DB	ESC,'E'		; Clear
	DB	'$'
HITRET	DB	13,10,'Hit RETURN...$'
;
;
ENDBAT	DB	'A:XA',0DH,0AH,1AH,'$'
ENDBATM	DB	0AH,'A:XM',0DH,0AH,1AH,'$'
ZRTN	DB	'DIR/W',0DH,0AH,1AH,'$'
;
SPC	DB	'   $'
CLS	DB	ESC,'E$'
CRLF	DB	0DH,0AH,'$'
COUNT	DB	0
LINCNT	DB	0
HELPREP DB	0
SKPCNT	DB	0
DEFSW	DB	0
BUFPTR	DW	0
;
MFCB	DB	1
	DB	'MENU    TBL'
	DB	30 DUP (0)
HFCB	DB	1
	DB	'MENU    DAT'
	DB	30 DUP (0)
DIRFCB	DB	0
	DB	'???????????'
	DB	30 DUP (0)
XFCB	DB	2
	DB	'X       BAT'
	DB	30 DUP (0)
;
FILER	DB	ESC,'E'
	DB	'Batch file error - program aborted$'
;
INITMSG	DB	ESC,'y5'
	DB	ESC,'x?'
	DB	ESC,'y6'
	DB	ESC,'y7'
	DB	ESC,'x1'
	DB	ESC,'q'
	DB	ESC,'j'
	DB	ESC,'Y8 '
	DB	80 DUP (' ')
	DB	ESC,'k$'
;
MERRMSG	DB	'ERROR ON FILE "MENU.TBL" - MENU ABORTED$'
;
LINBUF	DB	80
	DB	80 DUP (?)
;
MAXADR	DW	0
;
MANMSG	DB	ESC,'E'
	DB	ESC,'Y!0'
	DB	ESC,'p'
	DB	'Z-DOS Menu System - Manual Command Entry:'
	DB	0AH,0AH
	DB	ESC,'q'
	DB	0DH,0AH
	DB	'Enter command directly.'
	DB	0DH,0AH
	DB	'Null entry (CR only) returns to main menu'
	DB	0DH,0AH
	DB	'Type "?" for further explaination'
	DB	0DH,0AH
	DB	ESC,'x?'
	DB	ESC,'y5$'
;
REV_VID	DB	ESC,'p$'
NRM_VID DB	ESC,'q$'
;
;	In manual entry mode, certain commands are treated 
;	as special cases.  This table consists of pointers
;	to entries in the spec_string_table below:
;
SPEC_TABLE	DW	OFFSET	HELP
		DW	OFFSET  XC
		DW	OFFSET  MENUC
		DW	OFFSET  DIRC
		DW	OFFSET  ZEXIT
		DW	OFFSET 	RENC
		DW	OFFSET 	DELC
		DW	OFFSET 	COPYC
		DW	OFFSET 	ERASEC
		DW	OFFSET DATEC
		DW	OFFSET TIMEC
		DW	OFFSET TYPEC
TBLEND:
;
;	spec_string_table:
;
;	entry format:
;
;	bytes 0,1 - pointer to special processor routine
;		3 - character count for string check
;	      4,n - special command string to look for
;
HELP	DW	OFFSET DSPHLP	; ? - display help info
	DB	1,'?'
;
;	The next 2 entries prevent the user from accessing
;	the menu program itself.
;
XC	DW	OFFSET DOENTR	; X (XA,XM) - display main menu
	DB	1,'X'
MENUC	DW	OFFSET DOENTR	; MENU - display main menu
	DB	4,'MENU'
;
;	Since a directory display is a much requested item
;	it is detrimental for the user to wait while Z-DOS
;	thrashes through batch streams so the directory is
;	displayed by the menu program.  It is displayed in
;	wide form only and for the current default drive.
;	If the Z-DOS form of directory display is desired,
;	the user need merely specify the full form of the
;	directory command (include drive ID and/or file
;	names)
;
DIRC	DW	OFFSET DODIR	; DIR - do directory display
	DB	3,'DIR'
;
;	Provide a method to exit the menu system.
;	This method would not normally be known to the 
;	general user.
;
ZEXIT	DW	OFFSET DOXIT	; #@! - allow user to exit menu
	DB	3,'#@!'
;
;	The following commands are the Z-DOS built-in commands.
;	They must be handled specially as they may not be
;	prefaced by a drive id.  Normal handling of user 
;	entered commands not prefaced by a drive id would
;	be to force the 'A:' prefix as it is assumed that all
;	programs will reside on the 'A' drive regardless of the
;	current deault drive.
;
RENC	DW	OFFSET	PASSZ	; REN - pass to Z-DOS
	DB	3,'REN'
DELC	DW	OFFSET	PASSZ	; DEL - pass to Z-DOS
	DB	3,'DEL'
COPYC	DW	OFFSET	PASSZ	; COPY - pass to Z-DOS
	DB	4,'COPY'
ERASEC	DW	OFFSET	PASSZ	; ERASE - pass to Z-DOS
	DB	5,'ERASE'
DATEC	DW	OFFSET	PASSZ	; DATE - pass to Z-DOS
	DB	4,'DATE'
TIMEC	DW	OFFSET	PASSZ	; TIME - pass to Z-DOS
	DB	4,'TIME'
TYPEC	DW	OFFSET	PASSZ	; TYPE - pass to Z-DOS
	DB	4,'TYPE'
;
INTRTN:
	IRET
	SUBTTL	Menu System Code - Manual Entry
	PAGE
BEGIN:
	MOV	WORD PTR TABLE_BUF,0
	MOV	DX,OFFSET INITMSG
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET INTRTN
	MOV	AH,25H		; Don't allow user to exit
	MOV	AL,23H		; the Menu system with control/C
	INT	21H
	CMP	BYTE PTR BUF,0	; Parameter present?
	JNE	PROMPT		;  Yes - get command
	MOV	DX,OFFSET DSKMSG
	MOV	AH,9
	INT	21H		; Ask user for disk B
	MOV	AH,8
	INT	21H		; Wait for reply
RESET_TABLE:
	CALL	TRESET
	JMP	DOENTR
;
TRESET	PROC	NEAR		; Read menu table subroutine
	MOV	DX,OFFSET TABLE_BUF
	MOV	AH,1AH		; DTA To TABLE_BUF
	INT	21H
	MOV	DX,OFFSET MFCB
	MOV	AH,15		; Open Table file
	INT	21H
	CMP	AL,0
	JE	READ_TABLE	; Check for open error
	CMP	WORD PTR TABLE_BUF,0
	JNE	DOOLD		; Ignore error if have table already
TABLE_ERROR:
	MOV	DX,OFFSET EXITMSG
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET MERRMSG
	MOV	AH,9
	INT	21H
	INT	20H
READ_TABLE:
	MOV	MFCB+32,0
	MOV	WORD PTR MFCB+12,0
	MOV	WORD PTR MFCB+14,1600
	MOV	WORD PTR MFCB+33,0
	MOV	CX,1
	MOV	DX,OFFSET MFCB
	MOV	AH,27H
	INT	21H		; Read table w/ rndm blk read
	CMP	AL,0
	JNE	TABLE_ERROR
DOOLD:
	MOV	AH,1AH
	MOV	DX,OFFSET BUF	; Restore DTA
	INT	21H
	RET
TRESET	ENDP
;
PROMPT:
	CMP	WORD PTR TABLE_BUF,0
	JNE	DSPCRLF
	CALL	TRESET			; Get menu table if necessary
DSPCRLF:
	MOV	DX,OFFSET CRLF   	;  prompt for command
	MOV	AH,9
	INT	21H
	MOV	AH,19H
	INT	21H			; Default drive id
	ADD	AL,41H
	MOV	DL,AL
	MOV	AH,2
	INT	21H
	MOV	DL,'#'
	MOV	AH,2
	INT	21H
	MOV	AH,10		; Read input line
	MOV	DX,OFFSET LINBUF
	INT	21H
	MOV	BX,OFFSET SPEC_TABLE
	CMP	BYTE PTR LINBUF+1,0	; 0 Chrs read?
	JNE	CHK_SPEC		;  No - decode entry
	JMP	DOENTR			;  Yes - return to full menu
;
;	Check special entry table for special commands
;
CHK_SPEC:
	CMP	BX,OFFSET TBLEND
	JE	XCMD		; No match found - go execute cmd
	PUSH	BX
	MOV	BX,[BX]
	MOV	DX,[BX]
	INC	BX
	INC	BX
	MOV	CL,[BX]
	INC	BX
	MOV	SI,OFFSET LINBUF+2
	MOV	CH,0
CKLP:
	MOV	AL,[SI]
	MOV	AH,[BX]
	INC	SI
	INC	BX
	AND	AL,5FH		; Allow either upper/lower case
	AND	AH,5FH
	CMP	AL,AH
	JNE	NOMTCH
	LOOP	CKLP
	POP	AX
	JMP	DX		; Match found - enter processor
NOMTCH:
	POP	BX
	INC	BX
	INC	BX
	JMP	CHK_SPEC
;
XCMD:
	CALL	LODR		; Load and execute command
	JNC	PROMPT		; Carry clear if command executed
;				  Carry set if command not loaded
MOVLINE:			; Build batch file B:X.BAT
	MOV	DI,OFFSET BUF
	MOV	SI,OFFSET LINBUF+1
	CMP	DEFSW,0		; Force A:?
	JE	MVIT		;  No - drive explicit
	MOV	AL,'A'		;  Yes - add 'A:'
	STOSB
	MOV	AL,':'
	STOSB
MVIT:
	LODSB			; Chr count
	MOV	AH,0
	MOV	CX,AX
	INC	CX
	REP	MOVSB
	MOV	SI,OFFSET ENDBATM
LP1:				; Add XM command
	LODSB
	CMP	AL,'$'
	JE	DSCWRT
	STOSB
	JMP	LP1
DSCWRT:
	MOV	DX,OFFSET XFCB
	MOV	AH,15		; Open B:X.BAT
	INT	21H
	CMP	AL,0
	JE	OPNOK
	MOV	DX,OFFSET XFCB
	MOV	AH,22		; Create it if none
	INT	21H
	CMP	AL,0
	JE	OPNOK
	MOV	DX,OFFSET FILER	; Abort if cannot create it
	MOV	AH,9
	INT	21H
	INT	20H
OPNOK:
	MOV	AH,21		; Write X.BAT
	MOV	DX,OFFSET XFCB
	INT	21H
	MOV	AH,16		; Close file
	MOV	DX,OFFSET XFCB
	INT	21H
	INT	20H		; Return to Z-DOS
;
DSPHLP:				; Display MENU.DAT file
	MOV	SKPCNT,1	; Begin with page 2
	JMP	HLPDSP
;
DOHELP:				; Display MENU.DAT file
	MOV	SKPCNT,0	; Begin with page 1
HLPDSP:
	MOV	BUFPTR,80H
	MOV	LINCNT,0
	MOV	HELPREP,0
	MOV	AL,0
	MOV	DI,OFFSET HFCB+12
	MOV	CX,30		; Clear help fcb
	REP	STOSB
	MOV	DX,OFFSET HFCB
	MOV	AH,15		; Open help file
	INT	21H
	CMP	AL,0
	JE	BEGINH
	JMP	DOENTR		; NOP on file open error
BEGINH:
	CMP	HELPREP,0
	JNE	DOHELP
	MOV	DX,OFFSET CLS
	MOV	AH,9		; Clear screen
	INT	21H
DSPLP:
	CMP	LINCNT,23
	JE	WAIT
	CALL	GETCHR
	CMP	AL,1AH
	JNE	CKLF
	MOV	DX,OFFSET HFCB
	MOV	AH,16		; Close file
	INT	21H
	MOV	HELPREP,1
WAIT:
	MOV	LINCNT,0
	DEC	SKPCNT
	CMP	SKPCNT,0
	JGE	BEGINH
	MOV	AH,8
	INT	21H		; Get kbd entry
	CMP	AL,0DH		; CR returns to menu display
	JNE	BEGINH		; All else requests next page
	MOV	DX,OFFSET HFCB
	MOV	AH,16
	INT	21H
	JMP	DOENTR
CKLF:
	CMP	AL,0AH
	JNE	PUTIT
	INC	LINCNT
PUTIT:
	CMP	SKPCNT,0
	JG	DSPLP
	MOV	DL,AL
	MOV	AH,2
	INT	21H
	JMP	DSPLP
;
;	Pass command to Z-DOS without Drive specification
;
PASSZ:
	MOV	DEFSW,0
	JMP	MOVLINE
;
;	Display directory of default drive
;
DODIR:
	MOV	AL,LINBUF+1
	CMP	AL,3		; If more than 3 chrs entered - 
	JNE	PASSZ		;  Pass to Z-DOS for processing
	MOV	COUNT,5		;  Else display directory 5 entries
	MOV	DX,OFFSET DIRFCB ;  per line
	MOV	AH,17		; Get first entry
	INT	21H
	JMP	PRTENT
NXTENT:
	MOV	DX,OFFSET DIRFCB
	MOV	AH,18		; Get next entry
	INT	21H
	CMP	AL,0FFH
	JE	DIRFIN
PRTENT:				; display entry
	INC	COUNT
	CMP	COUNT,6
	JNE	DSPENT
	MOV	DX,OFFSET CRLF
	MOV	AH,9
	INT	21H
	MOV	COUNT,1
DSPENT:
	MOV	CX,8
	MOV	SI,OFFSET BUF+1
NAMLP:
	MOV	DL,[SI]
	INC	SI
	MOV	AH,2
	INT	21H
	LOOP	NAMLP
	MOV	DL,' '
	MOV	AH,2
	INT	21H
	MOV	CX,3
EXTLP:
	MOV	DL,[SI]
	INC	SI
	MOV	AH,2
	INT	21H
	LOOP	EXTLP
	MOV	DX,OFFSET SPC
	MOV	AH,9		; Space over
	INT	21H
	JMP	NXTENT
DIRFIN:				; CRLF when done
	MOV	DX,OFFSET CRLF
	MOV	AH,9
	INT	21H
	JMP	PROMPT
;
;	Exit to Z-DOS Command processor.  There will be no 
;	return to the menu in this case.  
;
DOXIT:				; Exit to Z-DOS
	MOV	DX,OFFSET EXITMSG
	MOV	AH,9		; Restore cursor
	INT	21H
	MOV	DI,OFFSET BUF
	MOV	SI,OFFSET ZRTN
	JMP	LP1
	SUBTTL	Menu System Code - Main Menu Processing
	PAGE
;
;	This is the main menu processor
;
DOENTR:
	MOV	DX,OFFSET MENU_HDR
	MOV	AH,9		; Display menu screen
	INT	21H
	MOV	CX,20     	; Display menu items
	MOV	BX,OFFSET TABLE_BUF
LINLP:
	CMP	WORD PTR [BX],'99'
	JE	TABLE_FIN	; '99' is end of table
	CALL	NORMAL		; Display line item
	ADD	BX,80		; Next table entry
	LOOP	LINLP
;
TABLE_FIN:
	SUB	BX,80		; BX to last entry
	MOV	MAXADR,BX
	MOV	BX,OFFSET TABLE_BUF
INLUP:
	CALL	REVERSE		; Reverse current entry
INLUP1:
	MOV	AH,8
	INT	21H		; Read kbd entry
	CMP	AL,0A5H		; Cursor up?
	JNE	DWNCHK
	CALL	NORMAL		;  Yes - normal vid - current line
	SUB	BX,80		;   Previous line
	CMP	BX,OFFSET TABLE_BUF
	JGE	INLUP
	MOV	BX,MAXADR	;  (Wrap)
	JMP	INLUP
DWNCHK:
	CMP	AL,0A6H		; Cursor down?
	JNE	HELPCHK
	CALL	NORMAL		;  Yes
	ADD	BX,80		;  Next line
	CMP	BX,MAXADR
	JLE	INLUP
	MOV	BX,OFFSET TABLE_BUF 	; Wrap
	JMP	INLUP
HELPCHK:
	CMP	AL,95H		; Help key?
	JNE	ENTRCHK
	JMP	DOHELP
ENTRCHK:
	CMP	AL,0DH		; CR?
	JE	DOCR
	CMP	AL,8DH		; Enter?
	JNE	INLUP1		;  No - ignore entry
DOCR:
	ADD	BX,40
	MOV	SI,BX		; Command line addr
	MOV	AH,14
	MOV	DL,[SI]
	AND	DL,15
	INT	21H
	INC	SI
	CMP	BYTE PTR [SI],'1'	; Use Z-DOS for entry?
	JE	BATENT			;  Yes - build batch file
	CMP	BYTE PTR [SI],'2'	;  No - manual entry?
	JE	MANUAL			;   Yes - prompt user
	MOV	DI,OFFSET LINBUF+2	;   No - assume direct entry
	MOV	BX,OFFSET LINBUF+1
	MOV	BYTE PTR [BX],0
	PUSH	SI
	INC	SI
LP3:
	LODSB
	CMP	AL,'$'
	JE	LODIT
	STOSB
	CMP	AL,0DH
	JE	LODIT
	INC	BYTE PTR [BX]
	JMP	LP3
LODIT:
	MOV	DX,OFFSET EXITMSG
	MOV	AH,9		; Restore cursor
	INT	21H
	CALL	LODR		; Load and execute program
	JC	RSTJ  		; Loader failure if carry set
	POP	SI
	MOV	DX,OFFSET HITRET
	MOV	AH,9
	INT	21H			;SAY "HIT RETURN"
WAICR:	MOV	AH,1
	INT	21H
	CMP	AL,0DH			;CR?
	JNZ	WAICR
	JMP	DOENTR
RSTJ:
	POP	SI
	JMP	RESET_TABLE
DOBTCH:				; Process command via batch stream
	POP	SI
	DEC	SI
BATENT:
	MOV	DX,OFFSET EXITMSG
	MOV	AH,9
	INT	21H
	INC	SI
	MOV	DI,OFFSET BUF
LP2:
	LODSB
	CMP	AL,'$'
	JE	DSCOUT
	STOSB
	JMP	LP2
DSCOUT:
	MOV	SI,OFFSET ENDBAT
	JMP	LP1
;
;	Manual command entry requested - display special screen
;
MANUAL:
	MOV	DX,OFFSET MANMSG
	MOV	AH,9
	INT	21H
	JMP	PROMPT
;
	SUBTTL	Subroutines
	PAGE
;
;	Change video characteristics of menu line item
;	in response to movement by a cursor up/down key
;
REVERSE	PROC	NEAR
	MOV	DX,OFFSET REV_VID	; Set to reverse video
	MOV	AH,9
	INT	21H
NORMAL:
	MOV	AH,2
	MOV	DL,ESC		; ESC
	INT	21H
	MOV	AH,2
	MOV	DL,'Y'		; 'Y'
	INT	21H
	MOV	DX,BX
	MOV	AH,9		; Display line item
	INT	21H
REV_RTN:
	MOV	DX,OFFSET NRM_VID
	MOV	AH,9		; Restore to normal video
	INT	21H
	RET
REVERSE	ENDP
;
;
;
GETCHR	PROC	NEAR		; Extract a chr from help file
	CMP	BUFPTR,80H
	JNE	GETC
	MOV	BUFPTR,0
	MOV	AH,14H		; Read a record
	MOV	DX,OFFSET HFCB
	INT	21H
GETC:
	MOV	BX,BUFPTR
	INC	BUFPTR
	ADD	BX,OFFSET BUF
	MOV	AL,[BX]
	RET
GETCHR	ENDP
;
	SUBTTL	COM Program Loader
	PAGE
;
;	This subroutine will perform a 'COM' file program
;	load and if successful, will enter that program.
;	When the program terminates, this routine regains 
;	control.  Carry is set if the load is unsuccessful,
;	otherwise it is clear on return.  The string at
;	location 'LINBUF' is taken to be a command line
;	to be executed.
;
LODR	PROC	NEAR
;
	JMP	LODR_ENTR
FCBL	DB	50 DUP (0)
SISV	DW	0
COM	DB	'COM'
NEWPROG DW	START
SEGSV	DW	0
STKSV	DW	0
SAVLEN	DW	0,0
;
LODR_ENTR:
	MOV	DEFSW,0
	MOV	SI,OFFSET LINBUF+2
	MOV	BL,LINBUF+1
	MOV	BH,0
	ADD	BX,SI
	MOV	DI,OFFSET FCBL
	MOV	AH,29H		; Parse command in LINBUF
	MOV	AL,0
	INT	21H
	CMP	BYTE PTR FCBL+1,' '
	JNE	GOTPROG
	MOV	DL,FCBL		; Change default drive if no file
	DEC	DL
	MOV	AH,14
	INT	21H
	CLC			; Indicate Processing complete
	RET
GOTPROG:
	CMP	FCBL,0		; Force default prog drive to A
	JNE 	DOPROG
	MOV	DEFSW,1		; Unless defined explicitly
	MOV	FCBL,1
DOPROG:
	MOV	BYTE PTR BUF,0
	MOV	DI,OFFSET FCB1
	MOV	AL,' '
CLRFCLP:
	STOSB			; Clear Parameter FCB area
	CMP	DI,OFFSET BUF
	JL	CLRFCLP
	MOV	BYTE PTR FCB1,0
	MOV	BYTE PTR FCB2,0
	MOV	SISV,SI
	CMP	SI,BX		; Check for parameters in command
	JGE	NOPARMS		;  None
	MOV	DI,OFFSET FCB1
	MOV	AH,29H		; Parse 1st parm to FCB1
	MOV	AL,0FFH
	INT	21H
	CMP	SI,BX
	JGE	NOPARM2
	MOV	DI,OFFSET FCB2
	MOV	AH,29H		; Parse 2nd parm to FCB2
	MOV	AL,0FFH
	INT	21H
NOPARM2:
	MOV	SI,SISV
	MOV	DI,OFFSET BUF+1
CPYLP:
	MOVSB			; Copy parms to BUF area
	INC	BUF
	CMP	SI,BX
	JNE	CPYLP
	MOV	AL,0DH		; Add CR
	STOSB
NOPARMS:
	MOV	DX,OFFSET FCBL
	MOV	DI,OFFSET FCBL+9
	MOV	SI,OFFSET COM
	MOVSB			; Force 'COM' extension
	MOVSB
	MOVSB
	MOV	AL,0
	MOV	CX,30
	REP	STOSB		; Clear rest of FCB
	MOV	AH,15
	INT	21H		; Open program file
	CMP	AL,0
	JE 	OPENOK
OPNER:				; No such file on open error
	MOV	DX,OFFSET BUF
	MOV	AH,1AH		; Reset DTA addr
	INT	21H
	STC			; Indicate load error
	RET
OPENOK:
	MOV 	AX,WORD PTR FCBL+16
	MOV	WORD PTR FCBL+14,AX	; Rec size=File size
	MOV	WORD PTR SAVLEN,AX
	MOV	AX,WORD PTR FCBL+18
	MOV	WORD PTR SAVLEN+2,AX
	MOV	DX,OFFSET RETN
	MOV	AH,25H		; Set terminate vector to
	MOV	AL,22H		; Return to this routine
	INT	21H
	MOV	DX,OFFSET STACK+15
	MOV	CL,4
	SHR	DX,CL		; Use memory just beyond this 
	MOV	AX,DS		; program for the new one
	ADD	DX,AX
	MOV	SEGSV,DX
	MOV	AH,26H		; Create new Program header
	INT	21H
	MOV	DX,OFFSET STACK+15
	AND	DX,0FFF0H
	ADD	DX,100H
	MOV	AH,1AH		; Set DTA to Prog+100H
	MOV	BX,DX
	INT	21H
	MOV	DX,OFFSET FCBL
	MOV	AH,14H		; Read in program file
	INT	21H
	MOV	AX,SP
	MOV	STKSV,AX
	MOV	BX,SAVLEN+2
	MOV	CX,SAVLEN
	MOV	AX,SEGSV
	MOV	DS,AX		; Set up registers for new program
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,0FFF0H
	MOV	DX,OFFSET BUF
	MOV	AH,1AH		; Set default DTA for new program
	INT	21H
	MOV	SI,0
	MOV	DI,0
	MOV	BP,0
	MOV	AX,0
	MOV	DX,0
	PUSH	AX
	JMP	DWORD PTR CS:NEWPROG	; Enter new program
;
;	Program terminate vector points here
;
RETN:
	MOV	AX,CS		; Restore segment registers
	MOV	DS,AX
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,STKSV
	MOV	DX,OFFSET BUF
	MOV	AH,1AH		; Reset DTA addr
	INT	21H
	CLC			; Indicate Good Load
	RET			; Return to caller
LODR	ENDP
;
TABLE_BUF:
	ORG	TABLE_BUF+1600
ENDCOD:
	ORG	ENDCOD+200H	; 200H STACK SIZE
STACK:
;
MENU	ENDS
	END	START

LODR	ENDP
