	page	,132
	title	Re-direct stdprn and execute prog
;
;	Re-direct std print and execute program
;
;	Author: R. A. Metz		Date: 12/14/83
;
;
;	The MS-DOS 2.0 user is provided with the tools to re-direct
;	the standard in and out devices via the COMMAND.COM command
;	line.  There is, however, no means provided to re-direct the
;	standard list, error, or aux devices, though the means is
;	provided for a programmer to do so.  Calling sequence for 
;	REPRINT is as follows:
;
;		A:REPRINT dest prog [parms]
;
;	where:
;
;		'dest' is the destination of std prn
;		'prog' is the program to be executed (EXE or COM)
;		'[parms]' is the optional parameter list for the program
;
;	This program will re-direct the standard print to the destination 
;	specified by the first parameter and execute the program specified
;	by the 2nd parameter.  E.g.:
;
;		A:REPRINT B:TEMP.LST WS [parms]
;
;	will switch standard print to the file 'B:TEMP.LST' and execute
;	the program 'WS'.  The optional [parms] are parameters to be
;	used by the program (in this case 'WS').
;
;	One particularly useful use of this program is to execute
;	WordStar using this program to re-direct standard print to a
;	file.  A document may then be printed by WordStar which will
;	result in a printable file being created unlike WordStar's 
;	supposed capability of printing to a file which results in
;	a copy of WordStar's internal format - hardly printable.
;
;	Also, the 'prog' parameter may be 'COMMAND' such that a
;	secondary copy of COMMAND.COM is executed while print is
;	re-directed.  To exit to the primary COMMAND processor, type
;	the 'EXIT' command.
;
include macros.asm
REPRINT	segment
	assume	cs:reprint,ds:reprint,ss:reprint,es:reprint
	org	2ch
env_seg	label	word
	org	5ch
fcb1	label	byte
	org	6ch
fcb2	label	byte
	org	80h
buf	label	byte
	org	100h
start:
	mov	sp,offset stack
	push	ax
	jmp	begin
;
cr	equ	0dh
lf	equ	0ah
;
curdsk	db	0
spsave	dw	0
savhndl	dw	0
eof	db	1ah
progfcb	db	33 dup (0)
com	db	'COM'
exe	db	'EXE'
dta_buf	db	128 dup (?)
progname	db	80 dup (0)
;
errmsg	db	0dh,0ah
	db	'error in assignment of handle$'
;
no_prog_msg	db	cr,lf
	db	'Program not found.$'
progerr	db	cr,lf
	db	'Program load error$'
doserr	db	cr,lf
	db	'Incorrect DOS version!$'
;
	even
prog_blk	label	word
	dw	0
	dw	buf,0
	dw	fcb1,0
	dw	fcb2,0
;
begin:
;
	svc	30h
	cmp	al,2
	jae	dosok		; verify proper dos
	display doserr
	int	20h
dosok:
	mov	ax,ds
	mov	prog_blk[4],ax
	mov	prog_blk[8],ax	; segment fixups
	mov	prog_blk[12],ax
;
	svc	19h		; get current drive
	inc	al
	mov	curdsk,al
;
	mov	bx,offset endcod
	mov	cl,4
	shr	bx,cl
	inc	bx		; free mem behind me
	svc	4ah
;
	cmp	buf,0		; must have parms else exit
	jne	gotfil
	sys_term 0
gotfil:
	mov	si,offset buf+1
ljust:
	cmp	byte ptr [si],' '
	jne	fndend
	inc	si
	jmp	ljust
fndend:
	mov	dx,si
rjust:
	cmp	byte ptr [si],'.'
	je	rjust_cont
	cmp	byte ptr [si],'/'
	jbe	gotend
rjust_cont:
	inc	si
	jmp	rjust
gotend:
	mov	byte ptr [si],0
	inc	si
	push	si		; save beginning of command line
	mov	al,1
	svc	3dh
	jnc	sw_to_prt	; switch to stdprn if open ok
	cmp	ax,2		;  if no file - make one
	jne	error
	mov	cx,0
	svc	3ch
	jc	error
sw_to_prt:
	mov	savhndl,ax
	mov	bx,ax
	mov	cx,4
	svc	46h		; force file to have handle 4 (stdprn)
	jnc	xqt_prog
error:
	display errmsg
	sys_term 0
;
xqt_prog:
	pop	si
	parse	,progfcb
	cmp	progfcb+1,' '	; was progname entered?
	jne	locfile		;  yes - try to find program file
	sys_term 0
locfile:
	push	si
;
chk_for_file:
	set_dta	dta_buf
chk_pfile:
	mov	di,offset progfcb+9
	mov	si,offset com	; check for .com file
	mov	cx,3
	rep	movsb
	search_first	progfcb
	cmp	al,0
	je	do_prog
	mov	si,offset exe
	mov	di,offset progfcb+9
 	mov	cx,3
	rep	movsb		; check for .exe file
	search_first	progfcb
	cmp	al,0
	je	do_prog
	pop	dx
	display no_prog_msg
	sys_term 0
do_prog:
	pop	dx
	mov	di,offset progname
	mov	si,offset progfcb	; build pathname at progname
	lodsb
	cmp	al,0
	jne	setdrv
	mov	al,curdsk
setdrv:
	add	al,'@'
	stosb			; drive letter
	mov	al,':'
	stosb			; ':'
	mov	cx,8
cpy_pname:
	lodsb
	cmp	al,' '		; name field
	je	set_ext
	stosb
	loop	cpy_pname
set_ext:
	mov	al,'.'
	stosb			; '.'
	mov	si,offset progfcb+9
	mov	cx,3
	rep	movsb		; extension
	mov	al,0
	stosb			; null terminator
;
	call	prog_xqt
	mov	dx,offset eof
	mov	bx,savhndl
	mov	cx,1		; write eof to prn file
	svc	40h
	svc	3eh		; close it
	sys_term 0
;
prog_xqt	proc	near	; load & xqt program
;
;	dx points to parameters
;	pathname of program at progname
;
	mov	si,dx
	parse	,fcb1       	; parse 1st parm
	parse	,fcb2		; parse 2nd parm
noparms:
	mov	si,dx
	mov	di,offset buf+1	; copy parm list to buf
	mov	buf,0
parmcpy:
	lodsb
	cmp	al,cr		; stop at cr
	je	cpyfin
	stosb
	inc	buf
	jmp	parmcpy
cpyfin:
	stosb			; put cr in buffer
;
	mov	spsave,sp
	mov	dx,offset progname
	mov	bx,offset prog_blk	; execute the program
	mov	al,0
	svc	4bh
	mov	bx,cs
	mov	ds,bx
	mov	es,bx			; restore segment regs
	mov	ss,bx
	mov	sp,spsave
	jc	prog_err
	ret				; return 
prog_err:
	display progerr    		; load error - display msg
	ret
prog_xqt	endp
;
	db	128+64 dup (?)
stack:
endcod:
;
reprint	ends
	end	start
                         