	PAGE	,132
	TITLE	'HUG BACKGROUND PRINT SPOOLER'
;	HBPS - HUG BACKGROUND PRINT SPOOLER FOR MS-DOS
;
;	THIS PROGRAM IS A BACKGROUND PRINTER SPOOLER THAT
;	INTERCEPTS OUTPUT TO THE PRINTER AND BUFFERS IT SO
;	THAT PROGRAMS DO NOT HAVE TO WAIT ON THE PRINTER.
;
;	BY P. SWAYNE, HUG  08-APR-85  17-MAY-85
;
;	COPYRIGHT (C) 1985 BY HEATH USERS' GROUP

;	DEFINITIONS

TRUE	EQU	0FFFFH			;DEFINE TRUE
FALSE	EQU	NOT TRUE		;AND FALSE
DOS2	EQU	TRUE			;ASSEMBLE FOR DOS VER. 2?
PC	EQU	FALSE			;ASSEMBLE FOR PC?
FAST	EQU	TRUE			;ASSEMBLE FOR FAST ON 100?
CPI	EQU	10			;CHARS/INTERRUPT

M	EQU	BYTE PTR 0[BX]		;MEMORY POINTER

SYSINT	EQU	21H*4			;SYSTEM INTERRUPT
	IF	PC
TIMEINT	EQU	1CH*4			;Z150 TIMER INTERRUPT VECTOR
KEYINT	EQU	16H			;KEYBOARD INTERRUPT
PIOINT	EQU	17H			;PARALLEL I/O INTERRUPT
PORT	EQU	0			;LPT PORT NO.
	ELSE
TIMEINT	EQU	51H*4			;Z100 TIMER INTERRUPT VECTOR
BIOS	SEGMENT AT 40H
	ORG	3
BCONST	LABEL	FAR			;BIOS CONSOLE STATUS
	ORG	6
BCONIN	LABEL	FAR			;BIOS CONSOLE INPUT
	ORG	0CH
BLSTOUT	LABEL	FAR			;BIOS LIST OUTPUT
	ORG	4BH
PRNFUNC	LABEL	FAR			;BIOS PRINT FUNCTION
BIOS	ENDS
	ENDIF

JMPF	MACRO
	DB	0EAH			;FAR JUMP INSTRUCTION
	ENDM
RETF	MACRO
	DB	0CBH			;FAR RETURN INSTRUCTION
	ENDM

HBPS	SEGMENT
	ASSUME	CS:HBPS,DS:HBPS,ES:HBPS,SS:HBPS
	ORG	2
MEMLIM	LABEL	WORD			;MEMORY LIMIT
	ORG	100H

START:	JMP	SETUP			;SET UP PROGRAM

;	MEMORY CELLS USED IN THIS PROGRAM

LSTAK	LABEL	NEAR			;LOCAL STACK
SYSSTK	DW	0			;SYSTEM STACK
SYSSTKS	DW	0			;SYSTEM STACK SEGMENT
SYSTK1	DW	0			;SYSTEM STACK (CLOCK)
SYSTKS1	DW	0			;SYSTEM STACK SEGMENT (CLOCK)
TEMP1	DW	0			;TEMP. STORAGE NO. 1
TEMP2	DW	0			;TEMP. STORAGE NO. 2
TEMP3	DW	0			;TEMP. STORAGE NO. 3
CCFLG	DB	1			;CONTROL-C ABORT ENABLE FLAG
ENFLG	DB	0			;SPOOLER ENABLE FLAG
	IF	NOT PC
DBFLG	DB	0			;DISK BUSY FLAG
	ENDIF
	IF	NOT PC AND NOT FAST
SKFLG	DB	0			;SKIP CLOCK FLAG
	ENDIF
TIMFLG	DB	0			;TIMER ENABLE FLAG
HEADPT	DW	BUFBEG			;BUFFER HEAD POINTER
TAILPT	DW	BUFBEG			;BUFFER TAIL POINTER
BUFEND	DW	10*1024			;BUFFER END ADDRESS
	IF	DOS2
HSEG	DW	0			;HEAD SEGMENT NO.
TSEG	DW	0			;TAIL SEGMENT NO.
ENDSEG	DW	0			;END SEGMENT ADDRESS
	ENDIF

;	MAIN PROGRAM
;	HERE, WE INTERCEPT PRINTER OUTPUT CALLS
;	AND PLACE CHARACTERS IN A BUFFER FOR PRINTING
;	AT TIMER INTERRUPT TIME.

	DB	'HS'			;IDENTIFIER
MYSYS:
	IF	NOT PC
	MOV	CS:DBFLG,0		;CLEAR DISK BUSY FLAG
	ENDIF
	CMP	AH,0F1H			;SET SPOOLER FUNCTION?
	JZ	SETSP			;YES
	CMP	AH,5			;LIST OUT?
	JZ	FUNCOK			;YES, OK
	CMP	AH,64			;XENIX OUT?
	IF	NOT PC
	JNZ	CFDSK			;NO, LET DOS DO IT
	ELSE
	JNZ	MYEXIT
	ENDIF
	CMP	BX,4			;PRINTER OUTPUT?
	JZ	FUNCOK			;YES
	IF	NOT PC
	JMP	SHORT CHAND		;LET DOS DO FUNC.
	ELSE
	JMP	SHORT MYEXIT
	ENDIF
FUNCOK:	CMP	CS:ENFLG,0		;SPOOLER ON?
	JNZ	MYEXIT			;IF NOT, EXIT
	MOV	CS:SYSSTK,SP		;SAVE STACK
	MOV	CS:SYSSTKS,SS		;AND STACK SEGMENT
	PUSH	CS
	POP	SS			;PUT STACK SEGMENT HERE
	MOV	SP,OFFSET LSTAK		;SET LOCAL STACK
	STI
	CMP	AH,5			;LIST OUTPUT?
	JZ	LSTOUT
	CMP	AH,64			;XENIX WRITE?
	JNZ	MYEXIT
	JMP	XWRITE
MYEXIT:	JMPF				;JUMP TO SYSTEM
SYSADR	DD	0			;SYSTEM ADDRESS
	IF	NOT PC
CFDSK:	CMP	AH,20			;DISK READ?
	JZ	SETDB			;YES, SET DISK BUSY
	CMP	AH,21			;DISK WRITE?
	JZ	SETDB
	CMP	AH,33			;RANDOM READ?
	JZ	SETDB
	CMP	AH,34			;RANDOM WRITE?
	JZ	SETDB
	CMP	AH,39			;RANDOM BLK READ?
	JZ	SETDB
	CMP	AH,40			;RANDOM BLK WRITE?
	JZ	SETDB
	CMP	AH,63			;XENIX READ?
	JZ	CHAND			;YES, CHECK HANDLE
	JMP	MYEXIT			;NOT A DISK FUNCTION
CHAND:	CMP	BX,5			;FILE HANDLE?
	JC	MYEXIT			;NO
SETDB:	MOV	CS:DBFLG,1		;SET DISK BUSY
	JMP	MYEXIT			;AND EXIT
	ENDIF

;	LOCAL FUNCTIONS START HERE
;	SET SPOOLER

SETSP:	OR	AL,AL			;ENABLE SPOOLER?
	JNZ	EMPTY			;NO
	MOV	CS:ENFLG,0		;ELSE, ENABLE SPOOLER
	IRET
EMPTY:	MOV	CS:TIMFLG,1		;KILL TIMER
	MOV	CS:HEADPT,OFFSET BUFBEG	;RESET POINTERS
	MOV	CS:TAILPT,OFFSET BUFBEG
	IF	DOS2
	MOV	CS:HSEG,CS		;CLEAR SEGMENT NOS.
	MOV	CS:TSEG,CS
	ENDIF
	MOV	CS:TIMFLG,0		;RE-ENABLE TIMER
	CMP	AL,2			;DISABLE SPOOLER?
	JNZ	SETSPX			;IF NOT, EXIT NOW
	MOV	CS:ENFLG,1		;ELSE, DISABLE SPOOLER
SETSPX:	IRET

;	LIST OUTPUT

LSTOUT:	CALL	MYLSOUT			;PRINT THE CHARACTER
MYRET:	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:SYSSTK
	IRET				;RETURN, FUNCTION COMPLETED

;	XENIX WRITE

XWRITE:	PUSH	DI
	PUSH	SI
	PUSH	CX			;SAVE COUNT
	PUSH	DX
	MOV	DI,OFFSET MYLSOUT	;GET LST OUTPUT
	MOV	SI,DX			;POINT TO BUFFER
	XOR	AX,AX			;SET A COUNTER
	OR	CX,CX			;NULL COUNT?
	JZ	XWRIT2
XWRITLP:MOV	DL,[SI]			;GET CHARACTER
	CMP	DL,'Z'-'@'		;CONTROL-Z?
	JZ	XWRIT2			;YES
	INC	AX			;ELSE, COUNT CHARACTER
	CALL	DI			;WRITE TO DEVICE
	INC	SI
	LOOP	XWRITLP			;UNTIL DONE
XWRIT2:	POP	DX
	POP	CX
	POP	SI
	POP	DI
XRET:	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:SYSSTK
	POP	CS:TEMP1		;SAVE RET IP HERE
	POP	CS:TEMP2		;SAVE RET CS HERE
	POPF				;GET OLD FLAGS
	CLC				;CLEAR CARRY
	PUSH	CS:TEMP2		;RESTORE CS
	PUSH	CS:TEMP1		;RESTORE IP
	RETF				;RETURN, CARRY CLEAR

;	LOCAL LST OUTPUT

MYLSOUT:PUSH	AX
	PUSH	BX
	IF	DOS2
	PUSH	DS
	MOV	DS,CS:HSEG		;GET HEAD SEGMENT
	ENDIF
	MOV	CS:TIMFLG,1		;KILL TIMER
	MOV	BX,CS:HEADPT		;GET HEAD POINTER
	IF	DOS2
	MOV	[BX],DL			;STORE CHARACTER
	ELSE
	MOV	CS:[BX],DL
	ENDIF
	INC	BX			;INCREMENT POINTER
	IF	DOS2
	JNZ	NSEND
	ADD	CS:HSEG,1000H		;UPDATE HEAD SEGMENT
NSEND	LABEL	NEAR
	ENDIF
	CMP	BX,CS:BUFEND		;AT END?
	JNZ	NOTEND			;NO
	IF	DOS2
	MOV	AX,DS
	CMP	AX,CS:ENDSEG		;AT END?
	JNZ	NOTEND
	MOV	CS:HSEG,CS		;CLEAR HEAD SEGMENT
	ENDIF
	MOV	BX,OFFSET BUFBEG	;POINT TO BEGINNING
NOTEND:	CMP	BX,CS:TAILPT		;AT TAIL POINTER?
	JNZ	MYLSX			;NO
	IF	DOS2
	MOV	AX,DS
	CMP	AX,CS:TSEG		;AT TAIL SEGMENT?
	JNZ	MYLSX			;NO
	ENDIF
	PUSH	BX
	PUSH	DS
	PUSH	ES
	MOV	BX,CS
	MOV	DS,BX			;PUT DS HERE
	CALL	CHROUT			;OUTPUT A CHAR NOW
	POP	ES
	POP	DS
	POP	BX
	CALL	MYCONST			;ALLOW CONTROL-C CHECK
MYLSX:	MOV	CS:HEADPT,BX		;UPDATE HEAD POINTER
	MOV	CS:TIMFLG,0		;RESTORE TIMER
	IF	DOS2
	POP	DS
	ENDIF
	POP	BX
	POP	AX
	RET

;	CHARACTER OUTPUT ROUTINE
;	TAKES A CHARACTER FROM THE BUFFER AND PRINTS IT

CHROUT:	MOV	BX,TAILPT		;GET TAIL POINTER
	CMP	BX,HEADPT		;BUFFER EMPTY?
	IF	NOT DOS2
	JZ	CHRX			;IF SO, EXIT
	MOV	AL,[BX]			;ELSE, GET CHARACTER
	ELSE
	MOV	ES,TSEG			;GET TAIL SEGMENT
	JNZ	NOTEM			;NOT EMPTY
	MOV	AX,ES
	CMP	AX,HSEG			;AT HEAD SEGMENT?
	JZ	CHRX			;IF SO, EXIT
NOTEM:	MOV	AL,ES:[BX]		;ELSE, GET CHARACTER
	ENDIF
	IF	PC
	MOV	AH,0
	PUSH	DX
	MOV	DX,PORT
	INT	PIOINT			;PRINT CHAR
	POP	DX
	ELSE
	CALL	BLSTOUT			;PRINT CHAR
	ENDIF
	INC	BX			;INCREMENT POINTER
	IF	DOS2
	JNZ	NSEND1
	ADD	TSEG,1000H		;UPDATE TAIL SEGMENT
NSEND1	LABEL	NEAR
	ENDIF
	CMP	BX,BUFEND		;AT END?
	JNZ	NOTEND1			;NO
	IF	DOS2
	MOV	AX,ES
	CMP	AX,ENDSEG		;LAST SEGMENT?
	JNZ	NOTEND1
	MOV	TSEG,CS			;ELSE, RESET TAIL SEGMENT
	ENDIF
	MOV	BX,OFFSET BUFBEG	;POINT TO BEGINNING
NOTEND1:MOV	TAILPT,BX		;UPDATE TAIL POINTER
	OR	AL,AL			;FLAG NOT EMPTY
CHRX:	RET

;	LOCAL CONSOLE STATUS ROUTINE

MYCONST:
	IF	PC
	MOV	AH,1
	INT	KEYINT			;CHECK KEYBOARD STATUS
	ELSE
	CALL	BCONST			;CHECK STATUS VIA BIOS
	ENDIF
	JNZ	HAVCHR			;WE HAVE A CHARACTER
	XOR	AL,AL			;ELSE, CLEAR AL
	RET
HAVCHR:
	IF	PC
	CMP	AX,'C'-'@'
	ELSE
	CMP	AL,'C'-'@'		;CONTROL-C?
	ENDIF
	JNZ	NOTC			;NO
	IF	PC
	MOV	AH,0
	INT	KEYINT
	ELSE
	CALL	BCONIN			;ELSE, ABSORB CONTROL-C
	ENDIF
	CALL	CTLC			;AND PROCESS IT
	JMP	MYCONST			;GET ANOTHER CHARACTER
NOTC:	MOV	AL,0FFH			;SAY CHAR IS READY
MYCNX:	RET

;	CONTROL-C PROCESSOR

CTLC:	PUSH	AX			;SAVE A BUNCH OF REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	MOV	CS:TEMP1,SS		;SAVE STACK
	MOV	CS:TEMP2,SP
	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE ORIGINAL SEGMENT
	MOV	SP,CS:SYSSTK		;AND ORIGINAL STACK
	STI
	INT	23H			;EXECUTE CONTROL-C INTERRUPT
	CLI				;KILL INTERRUPS
	MOV	SS,CS:TEMP1		;RESTORE STACK
	MOV	SP,CS:TEMP2
	CMP	CS:CCFLG,0		;CONTROL-C ABORT ENABLED?
	JZ	CTLCX			;IF NOT, EXIT
	MOV	AX,4C01H		;TERMINATE, CONTROL-C EXIT
	PUSHF
	PUSH	CS
	MOV	BX,OFFSET CTLCX
	PUSH	BX
	JMP	MYEXIT			;FAKE INTERRUPT 21H
CTLCX:	STI				;IN DOS 1, NO FUNC. 4CH
	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	TIMER INTERRUPT PROCESSOR
;	PRINTS CHARACTER FROM BUFFER IF PRINTER IS
;	NOT BUSY.

MYTIME:	CMP	CS:TIMFLG,0		;BUSY?
	JNZ	TIMEX1			;IF SO, EXIT
	IF	NOT PC
	CMP	CS:DBFLG,0		;DISK BUSY?
	JZ	DISKNB			;NO
	INC	CS:DBFLG		;ELSE, COUNT THIS CLOCK
	JMP	SHORT TIMEX1		;AND EXIT
DISKNB	LABEL	NEAR
	ENDIF
	IF	NOT PC AND NOT FAST
	XOR	CS:SKFLG,1		;SKIP CLOCK?
	JZ	TIMEX1			;YES
	ENDIF
	PUSH	AX			;ELSE SAVE REGISTERS
	PUSH	DS
	MOV	AX,CS
	MOV	DS,AX			;PUT DS HERE
	MOV	SYSTK1,SP		;SAVE SYSTEM STACK
	MOV	SYSTKS1,SS		;AND SYSTEM STACK SEGMENT
	MOV	SS,AX			;PUT STACK SEGMENT HERE
	MOV	SP,OFFSET 80H		;PUT STACK HERE
	PUSH	BX
	PUSH	CX
	PUSH	ES
	MOV	TIMFLG,1		;MARK ROUTINE BUSY
	STI				;ENABLE INTERRUPTS
	MOV	CX,CPI			;GET CHARS/INT
PRTLP:	MOV	AX,TAILPT
	CMP	AX,HEADPT		;BUFFER EMPTY?
	IF	NOT DOS2
	JZ	TIMEX			;IF SO, EXIT
	ELSE
	JNZ	NOTEM1			;NOT EMPTY
	MOV	AX,TSEG
	CMP	AX,HSEG			;SEGMENTS EQUAL?
	JZ	TIMEX			;IF SO, EXIT
NOTEM1	LABEL	NEAR
	ENDIF
	IF	PC
	PUSH	DX
	MOV	DX,PORT
	MOV	AH,2
	INT	PIOINT			;GET PRINTER STATUS
	POP	DX
	ELSE
	PUSH	DX			;SAVE REGISTERS AFFECTED
	PUSH	SI
	PUSH	DI
	MOV	AX,200H
	CALL	PRNFUNC			;GET PRINTER STATUS
	POP	DI
	POP	SI
	POP	DX
	ENDIF
	AND	AH,80H			;CHECK IT
	JZ	TIMEX			;NOT READY
	CALL	CHROUT			;ELSE, PRINT A CHARACTER
	JZ	TIMEX			;BUFFER EMPTY
	LOOP	PRTLP			;REPEAT UNTIL BUSY
TIMEX:	CLI				;KILL INTERRUPTS
	MOV	TIMFLG,0		;ENABLE TIMER
	POP	ES
	POP	CX
	POP	BX
	MOV	SS,SYSTKS1		;RESTORE SYSTEM STACK SEGMENT
	MOV	SP,SYSTK1		;AND SYSTEM STACK
	POP	DS
	POP	AX
TIMEX1:	JMPF
TIMADR	DD	0			;TIMER INTERRUPT ADDRESS

;	"CALL 5" PROCESSOR

CALL5:	POP	AX			;REMOVE IP
	POP	CS:TEMP3		;REMOVE USER CS
	POP	AX			;REMOVE PROGRAM IP
	PUSH	CS:TEMP3		;RESTORE USER CS
	PUSH	AX			;AND PROGRAM IP
	MOV	AH,CL			;GET CALL
	INT	21H			;EXECUTE IT
	RETF

BUFBEG:					;BUFFER BEGINS HERE

;	SET UP SYSTEM SO THAT SYSTEM INTERRUPTS PASS THROUGH
;	THIS PROGRAM

SETUP:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	MOV	SI,OFFSET 80H		;POINT TO CMD BUFFER
	CLD
	LODSB				;GET CHAR COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GETNUM			;YES, GET IT
NONUM:	MOV	DX,OFFSET EXPL
	MOV	AH,9
	INT	21H			;ELSE, EXPLAIN
	INT	20H
GETNUM:	MOV	DI,SI
	MOV	AL,' '
	REPZ	SCASB			;LOOK FOR NON-SPACE
	DEC	DI			;POINT TO IT
	MOV	SI,DI
	XOR	CX,CX			;ZERO NUMBER REGISTER
GETLP:	LODSB				;GET A CHARACTER
	SUB	AL,'0'			;REMOVE ASCII
	JB	GOTNUM			;END OF NUMBER
	CMP	AL,10			;MORE THAN 9
	JNB	GOTNUM			;YES, END OF NUMBER
	XOR	AH,AH
	MOV	DX,AX			;SAVE ENTRY
	MOV	AX,CX			;GET LAST ENTRY
	ADD	AX,AX			;* 2
	MOV	BX,AX			;SAVE IT
	ADD	AX,AX			;* 4
	ADD	AX,AX			;* 8
	ADD	AX,BX			;PLUS N*2 = N*10
	ADD	AX,DX			;ADD CURRENT ENTRY
	MOV	CX,AX			;STORE RESULT
	JMP	GETLP			;GET ANOTHER DIGIT
GOTNUM:	DEC	SI			;POINT TO LAST CHARACTER
	CMP	SI,DI			;ANY NUMBER ENTERED?
	JZ	NONUM			;IF NOT, EXIT
GETUX:
	IF	DOS2
	CMP	CX,513			;LEGAL NUMBER?
	ELSE
	CMP	CX,65			;LEGAL NUMBER?
	ENDIF
	JNC	NONUM
	CMP	CX,4			;USE AT LEAST 4K
	JC	NONUM
	MOV	AX,1024			;GET 1K
	MUL	CX			;MPY BY NUMBER ENTERED
	IF	DOS2
	OR	AX,AX
	JNZ	NOT64			;NUMBER WAS NOT MOD 64K
	ELSE
	JNC	NOT64			;NUMBER WAS NOT 64
	ENDIF
	MOV	AX,0FFF0H		;ELSE, MAKE TOP FFF0
	IF	DOS2
	DEC	DX			;REMOVE ONE BANK
	ENDIF
NOT64:	MOV	BUFEND,AX		;SAVE IT
	IF	DOS2
	MOV	BX,AX			;SAVE BUFEND
	XCHG	DH,DL
	MOV	CL,4
	SHL	DH,CL			;CONVERT HIGH WORD TO PARAGRAPHS
	PUSH	DX			;SAVE PARAGRAPHS WANTED
	MOV	AX,CS
	ADD	DX,AX			;FIND END SEGEMENT
	MOV	ENDSEG,DX		;SAVE IT
	MOV	HSEG,CS			;INITIALIZE HEAD SEGMENT
	MOV	TSEG,CS			;AND TAIL SEGMENT
	ADD	BX,0FH
	MOV	CL,4
	SHR	BX,CL			;CONVERT END ADDR TO PARAGRAPHS
	ADD	DX,BX			;GET ABSOLUTE END
	ADD	DX,400			;ALLOW 16K FOR SYSTEM
	CMP	DX,MEMLIM		;COMPARE END TO MEMORY LIMIT
	JC	MEMOK			;THERE'S ENOUGH
	MOV	DX,OFFSET NEMMSG
	MOV	AH,9
	INT	21H			;SAY "NOT ENOUGH MEMORY"
	INT	20H
MEMOK:	POP	DX			;GET PARAGRAPHS WANTED
	ADD	BX,DX			;COMPUTE PARAGRAPHS TO RESERVE
	ENDIF
	XOR	AX,AX
	MOV	DS,AX			;PUT DS AT INT. SEGMENT
	MOV	SI,OFFSET SYSINT
	LES	DI,DWORD PTR [SI]	;GET SYS INT. ADDRESS
	CMP	ES:WORD PTR -2[DI],'SH'	;HBPS ALREADY IN?
	JNZ	NOTIN			;NO
	PUSH	CS
	POP	DS			;ELSE, FIX DS
	MOV	DX,OFFSET ITSMSG
	MOV	AH,9
	INT	21H			;SAY "IT'S IN"
	INT	20H			;EXIT
NOTIN:	MOV	[SI],OFFSET MYSYS	;REPLACE IT WITH MY ADDR
	MOV	2[SI],CS		;AND THIS SEGMENT
	PUSH	CS
	POP	DS			;RESTORE DS
	MOV	WORD PTR SYSADR,DI	;PUT IN JUMP TO SYSTEM
	MOV	WORD PTR SYSADR+2,ES
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET TIMEINT	;POINT TO TIMER INTERRUPT
	LES	DI,DWORD PTR [SI]	;GET VECTOR IN ES:DI
	CLI				;TURN OFF INTERRUPTS
	MOV	[SI],OFFSET MYTIME	;PUT IN MY VECTOR
	MOV	2[SI],CS		;AND THIS SEGMENT
	PUSH	CS
	POP	DS			;RESTORE DS
	MOV	WORD PTR TIMADR,DI	;PUT IN OLD VECTOR
	MOV	WORD PTR TIMADR+2,ES
	STI
	MOV	SI,6
	LES	DI,DWORD PTR [SI]	;GET "CALL 5" ADDRESS
	INC	DI			;POINT TO ADDRESS
	MOV	AX,OFFSET CALL5
	CLD
	STOSW				;MOVE IN NEW JUMP
	MOV	AX,CS
	STOSW
	MOV	DX,OFFSET INMSG
	MOV	AH,9
	INT 	21H			;PRINT SIGN ON MESSAGE
	IF	DOS2
	MOV	DX,BX			;GET AMMOUNT TO RESERVE
	MOV	AX,3100H		;KEEP PROCESS, 0 CODE
	INT	21H
	ELSE
	MOV	DX,BUFEND		;POINT TO END OF RES. CODE
	INT	27H			;EXIT WITH CODE RESIDENT
	ENDIF

SIGNON	DB	13,10,"HBPS - HUG Background Print Spooler, "
	DB	"V 2."
	IF	DOS2
	DB	"2."
	ELSE
	DB	"1."
	ENDIF
	IF	PC
	DB	"150"
	ELSE
	DB	"100"
	ENDIF
	IF	FAST AND NOT PC
	DB	"F"
	ENDIF
	DB	" (by PS:)",13,10
	DB	"Copyright (C) 1985 by Heath Users' Group"
	DB	13,10,10,"$"
INMSG	DB	"HBPS is now installed.$"
EXPL	DB	"To use this program, enter",13,10,10
	DB	"  HBPS n",13,10,10
	DB	"where n is the number of k-bytes of memory"
	DB	13,10,"to be reserved for HBPS (4-"
	IF	DOS2
	DB	'512'
	ELSE
	DB	'64'
	ENDIF
	DB	").$"
ITSMSG	DB	'HBPS is already installed.$'
	IF	DOS2
NEMMSG	DB	'Not enough memory for requested size.$'
	ENDIF
HBPS	ENDS
	END	START
                                                                                           