	TITLE	KEYMAP FUNCTION KEY MAPPER
	PAGE	,132
;	KEYMAP -- MAP FUNCTION KEYS TO USER DEFINED CHARACTERS
;
;	THIS PROGRAM MAPS THE VARIOUS FUNCTION KEYS TO USER
;	DEFINED CHARACTER SEQUENCES.  THE SEQUENCE FOR ANY
;	ONE KEY CAN BE UP TO 20 CHARACTERS.
;
;	Z-150/IBM-PC VERSION
;
;	BY P. SWAYNE, HUG  26-SEP-84  19-OCT-84
;	COPYRIGHT (C) 1984 BY HEATH USERS' GROUP

;	DEFINITIONS

M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
TYPEF	EQU	9			;TYPE STRING FUNCTION

KEY	SEGMENT
	ASSUME	CS:KEY,DS:KEY,SS:KEY,ES:KEY
	ORG	100H

START:	JMP	SETUP			;SET UP KEYMAP

;	TABLE OF MAPPED SEQUENCES

MAPTBL	DW	Offset F1
	DW	Offset F2
	DW	Offset F3
	DW	Offset F4
	DW	Offset F5
	DW	Offset F6
	DW	Offset F7
	DW	Offset F8
	DW	Offset F9
	DW	Offset F10
	DW	Offset NOTDF1		;E
	DW	Offset NOTDF2		;F
	DW	Offset HOME
	DW	Offset UP
	DW	Offset PGUP
	DW	Offset NOTDF3		;J
	DW	Offset BK
	DW	Offset NOTDF4		;L
	DW	Offset FWD
	DW	Offset NOTDF5		;N
	DW	Offset ENDKEY
	DW	Offset DN
	DW	Offset PGDN
	DW	Offset INS
	DW	Offset DEL
	DW	Offset SF1
	DW	Offset SF2
	DW	Offset SF3
	DW	Offset SF4
	DW	Offset SF5
	DW	Offset SF6
	DW	Offset SF7
	DW	Offset SF8
	DW	Offset SF9
	DW	Offset SF10
	DW	Offset CF1
	DW	Offset CF2
	DW	Offset CF3
	DW	Offset CF4
	DW	Offset CF5
	DW	Offset CF6
	DW	Offset CF7
	DW	Offset CF8
	DW	Offset CF9
	DW	Offset CF10
	DW	Offset AF1
	DW	Offset AF2
	DW	Offset AF3
	DW	Offset AF4
	DW	Offset AF5
	DW	Offset AF6
	DW	Offset AF7
	DW	Offset AF8
	DW	Offset AF9
	DW	Offset AF10
;	DW	Offset CPSC
;	DW	Offset CBK
;	DW	Offset CFWD
;	DW	Offset CEND
;	DW	Offset CPGDN
;	DW	Offset CHOME

;	MAPPED CHARACTER SEQUENCES

;HOME	DB	'TEST',13,255
;	DB	15 DUP (0)
HOME	DB	0,'G',255
	DB	18 DUP (0)
UP	DB	0,'H',255
	DB	18 DUP (0)
PGUP	DB	0,'I',255
	DB	18 DUP (0)
BK	DB	0,'K',255
	DB	18 DUP (0)
FWD	DB	0,'M',255
	DB	18 DUP (0)
ENDKEY	DB	0,'O',255
	DB	18 DUP (0)
DN	DB	0,'P',255
	DB	18 DUP (0)
PGDN	DB	0,'Q',255
	DB	18 DUP (0)
INS	DB	0,'R',255
	DB	18 DUP (0)
DEL	DB	0,'S',255
	DB	18 DUP (0)

F1	DB	0,';',255
	DB	18 DUP (0)
F2	DB	0,'<',255
	DB	18 DUP (0)
F3	DB	0,'=',255
	DB	18 DUP (0)
F4	DB	0,'>',255
	DB	18 DUP (0)
F5	DB	0,'?',255
	DB	18 DUP (0)
F6	DB	0,'@',255
	DB	18 DUP (0)
F7	DB	0,'A',255
	DB	18 DUP (0)
F8	DB	0,'B',255
	DB	18 DUP (0)
F9	DB	0,'C',255
	DB	18 DUP (0)
F10	DB	0,'D',255
	DB	18 DUP (0)
SF1	DB	0,'T',255
	DB	18 DUP (0)
SF2	DB	0,'U',255
	DB	18 DUP (0)
SF3	DB	0,'V',255
	DB	18 DUP (0)
SF4	DB	0,'W',255
	DB	18 DUP (0)
SF5	DB	0,'X',255
	DB	18 DUP (0)
SF6	DB	0,'Y',255
	DB	18 DUP (0)
SF7	DB	0,'Z',255
	DB	18 DUP (0)
SF8	DB	0,'[',255
	DB	18 DUP (0)
SF9	DB	0,'\',255
	DB	18 DUP (0)
SF10	DB	0,']',255
	DB	18 DUP (0)
CF1	DB	0,'^',255
	DB	18 DUP (0)
CF2	DB	0,'_',255
	DB	18 DUP (0)
CF3	DB	0,'`',255
	DB	18 DUP (0)
CF4	DB	0,'a',255
	DB	18 DUP (0)
CF5	DB	0,'b',255
	DB	18 DUP (0)
CF6	DB	0,'c',255
	DB	18 DUP (0)
CF7	DB	0,'d',255
	DB	18 DUP (0)
CF8	DB	0,'e',255
	DB	18 DUP (0)
CF9	DB	0,'f',255
	DB	18 DUP (0)
CF10	DB	0,'g',255
	DB	18 DUP (0)
AF1	DB	0,'h',255
	DB	18 DUP (0)
AF2	DB	0,'i',255
	DB	18 DUP (0)
AF3	DB	0,'j',255
	DB	18 DUP (0)
AF4	DB	0,'k',255
	DB	18 DUP (0)
AF5	DB	0,'l',255
	DB	18 DUP (0)
AF6	DB	0,'m',255
	DB	18 DUP (0)
AF7	DB	0,'n',255
	DB	18 DUP (0)
AF8	DB	0,'o',255
	DB	18 DUP (0)
AF9	DB	0,'p',255
	DB	18 DUP (0)
AF10	DB	0,'q',255
	DB	18 DUP (0)
NOTDF1	DB	0,'E',255
NOTDF2	DB	0,'F',255
NOTDF3	DB	0,'J',255
NOTDF4	DB	0,'L',255
NOTDF5	DB	0,'N',255

;	ALTERNATE MAPPED CHARACTER SEQUENCES

XHOME	DB	0,'G',255
	DB	18 DUP (0)
LTBL	EQU	XHOME-HOME		;TABLE LENGTH
XUP	DB	0,'H',255
	DB	18 DUP (0)
XPGUP	DB	0,'I',255
	DB	18 DUP (0)
XBK	DB	0,'K',255
	DB	18 DUP (0)
XFWD	DB	0,'M',255
	DB	18 DUP (0)
XENDKEY	DB	0,'O',255
	DB	18 DUP (0)
XDN	DB	0,'P',255
	DB	18 DUP (0)
XPGDN	DB	0,'Q',255
	DB	18 DUP (0)
XINS	DB	0,'R',255
	DB	18 DUP (0)
XDEL	DB	0,'S',255
	DB	18 DUP (0)

XF1	DB	0,';',255
	DB	18 DUP (0)
XF2	DB	0,'<',255
	DB	18 DUP (0)
XF3	DB	0,'=',255
	DB	18 DUP (0)
XF4	DB	0,'>',255
	DB	18 DUP (0)
XF5	DB	0,'?',255
	DB	18 DUP (0)
XF6	DB	0,'@',255
	DB	18 DUP (0)
XF7	DB	0,'A',255
	DB	18 DUP (0)
XF8	DB	0,'B',255
	DB	18 DUP (0)
XF9	DB	0,'C',255
	DB	18 DUP (0)
XF10	DB	0,'D',255
	DB	18 DUP (0)
XSF1	DB	0,'T',255
	DB	18 DUP (0)
XSF2	DB	0,'U',255
	DB	18 DUP (0)
XSF3	DB	0,'V',255
	DB	18 DUP (0)
XSF4	DB	0,'W',255
	DB	18 DUP (0)
XSF5	DB	0,'X',255
	DB	18 DUP (0)
XSF6	DB	0,'Y',255
	DB	18 DUP (0)
XSF7	DB	0,'Z',255
	DB	18 DUP (0)
XSF8	DB	0,'[',255
	DB	18 DUP (0)
XSF9	DB	0,'\',255
	DB	18 DUP (0)
XSF10	DB	0,']',255
	DB	18 DUP (0)
XCF1	DB	0,'^',255
	DB	18 DUP (0)
XCF2	DB	0,'_',255
	DB	18 DUP (0)
XCF3	DB	0,'`',255
	DB	18 DUP (0)
XCF4	DB	0,'a',255
	DB	18 DUP (0)
XCF5	DB	0,'b',255
	DB	18 DUP (0)
XCF6	DB	0,'c',255
	DB	18 DUP (0)
XCF7	DB	0,'d',255
	DB	18 DUP (0)
XCF8	DB	0,'e',255
	DB	18 DUP (0)
XCF9	DB	0,'f',255
	DB	18 DUP (0)
XCF10	DB	0,'g',255
	DB	18 DUP (0)
XAF1	DB	0,'h',255
	DB	18 DUP (0)
XAF2	DB	0,'i',255
	DB	18 DUP (0)
XAF3	DB	0,'j',255
	DB	18 DUP (0)
XAF4	DB	0,'k',255
	DB	18 DUP (0)
XAF5	DB	0,'l',255
	DB	18 DUP (0)
XAF6	DB	0,'m',255
	DB	18 DUP (0)
XAF7	DB	0,'n',255
	DB	18 DUP (0)
XAF8	DB	0,'o',255
	DB	18 DUP (0)
XAF9	DB	0,'p',255
	DB	18 DUP (0)
XAF10	DB	0,'q',255
	DB	18 DUP (0)
XNOTDF1	DB	0,'E',255
XNOTDF2	DB	0,'F',255
XNOTDF3	DB	0,'J',255
XNOTDF4	DB	0,'L',255
XNOTDF5	DB	0,'N',255

SCANTBL	DB	57,2,40,4,5,6,8,40,10,11,9,13,51,12,52,53
	DB	11,2,3,4,5,6,7,8,9,10,39,39,51,13,52,53
	DB	3,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
	DB	25,16,19,31,20,22,47,17,45,21,44,26,43,27,7,12
	DB	41,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24
	DB	25,16,19,31,20,22,47,17,45,21,44,26,43,27,7,14

MAPFLG	DB	0			;MAPPING IN PROGRESS FLAG
MAPPTR	DW	0			;MAPPED CHARACTER POINTER
ASFLG	DB	0			;ALTERNATE SELECT FLAG
ASKEY	DB	0			;ALTERNATE SELECT KEY
TGLFLG	DB	0			;ON/OFF TOGGLE FLAG
TGLK	DB	'^'-'@'			;TOGGLE KEY
OFFLNK	DB	'\'-'@'			;OFF LINE KEY
INT16V	DD	0			;INT 16H VECTOR
INT10V	DD	0			;INT 10H VECTOR

BLMSG	DB	'F'+80H,'1'+80H,'      '
	DB	'F'+80H,'2'+80H,'      '
	DB	'F'+80H,'3'+80H,'      '
	DB	'F'+80H,'4'+80H,'      '
	DB	'F'+80H,'5'+80H,'      '
	DB	'F'+80H,'6'+80H,'      '
	DB	'F'+80H,'7'+80H,'      '
	DB	'F'+80H,'8'+80H,'      '
	DB	'F'+80H,'9'+80H,'      '
	DB	'1'+80H,'0'+80H,'      '

;	THIS IS THE MAIN CODE THAT INTERCEPTS BIOS CONSOLE
;	STATUS AND INPUT CALLS (INT 16H) TO DETECT FUNCTION
;	KEYS AND MAP THE USER-DEFINED CHARACTERS TO THEM

	DB	'KM'			;IDENTIFIER
MYINT16:STI				;ENABLE OTHER INTERRUPTS
	CMP	AH,1			;STATUS CHECK?
	JZ	MYSTAT			;YES
	OR	AH,AH			;INPUT?
	JZ	MYINP			;YES
XINT16:	JMP	Dword Ptr CS:INT16V	;ELSE, JUMP TO BIOS

MYSTAT:	CMP	Byte Ptr CS:MAPFLG,0	;ARE WE MAPPING?
	JZ	XINT16			;NO, NORMAL STATUS CHECK
	PUSH	BX			;ELSE, SAVE SOME REGISTERS
	MOV	BX,Word Ptr CS:MAPPTR	;GET MAP CHARACTER POINTER
	MOV	AL,Byte Ptr CS:[BX]	;GET NEXT CHARACTER
	INC	AL			;DONE MAPPING?
	JZ	CKRST			;YES, CHECK REGULAR STATUS
	DEC	AL			;ELSE, FIX CHARACTER
	CALL	GETSCAN			;GET SCAN CODE FOR IT
	CLI				;KILL INTERRUPTS
	PUSH	BP			;SAVE BP
	MOV	BP,SP			;POINT TO STACK
	AND	Word Ptr 8[BP],1111111110111111B	;CLEAR Z FLAG
	POP	BP
	STI
	POP	BX
	IRET				;RETURN FROM INTERRUPT, CHAR READY
CKRST:	MOV	Byte Ptr CS:MAPFLG,AL	;CLEAR MAP FLAG
	POP	BX
	JMP	SHORT XINT16		;CHECK STATUS

;	MY CONSOLE INPUT ROUTINE

MYINP:	PUSH	BX			;SAVE SOME REGISTERS
	PUSH	DX
	CMP	Byte Ptr CS:MAPFLG,0	;ARE WE MAPPING?
	JZ	NMAP			;NO
	JMP	MAP			;YES, RETURN MAPPED CHARACTER
NMAP:	CALL	INCHAR			;INPUT CHARACTER
	CMP	AL,Byte Ptr CS:TGLK	;TOGGLE KEYMAP?
	JNZ	NOTGL
	JMP	TOGGLE			;GO TOGGLE KEYMAP
NOTGL:	CMP	AL,Byte Ptr CS:OFFLNK	;GO OFF LINE?
	JNZ	NOTOFL
	JMP	OFFLIN			;GO OFF LINE
NOTOFL:	OR	AL,AL			;NULL CHARACTER?
	JZ	GOTNULL
INTRET:	POP	DX			;RESTORE REGISTERS
	POP	BX
	IRET				;RETURN FROM BIOS INTERRUPT

;	WE HAVE A NULL CHAR -- SEE IF IT'S A FUNCTION KEY

GOTNULL:CMP	Byte Ptr CS:TGLFLG,0	;TEST FOR ON/OFF TOGGLE
	JZ	KEYON			;KEYMAP IS ON
	JMP	SHORT INTRET		;ELSE, RETURN WITH CHARACTER
KEYON:	MOV	Byte Ptr CS:ASFLG,0	;CLEAR ALTERNATE SEL. FLAG
KEYON1:	MOV	BX,Offset MAPTBL	;POINT TO MAP TABLE
	CMP	AH,';'			;";" OR MORE?
	JB	INTRET			;NO, RETURN WITH CODE
	CMP	AH,'q'+1		;"q" OR LESS?
	JNB	INTRET			;NO, RETURN WITH CODE
	CMP	Byte Ptr CS:ASFLG,0	;WORKING ON ALTERNATE KEY?
	JNZ	NOAS			;IF SO, SKIP SHIFT CHECK
	CMP	AH,Byte Ptr CS:ASKEY	;IS THIS THE ALTERNATE SEL. KEY?
	JNZ	NOAS			;NO
	INC	Byte Ptr CS:ASFLG	;ELSE, SET ALTERNATE SEL. FLAG
	CALL	INCHAR			;GET SECOND KEY
	OR	AL,AL			;NULL?
	JZ	KEYON1			;IT'S NULL, GET NEXT CHARACTER
	DEC	Byte Ptr CS:ASFLG	;ELSE, CLEAR ALTERNATE SEL. FLAG
	JMP	INTRET			;RETURN WITH CHARACTER

;	IT'S A VALID FUNCTION KEY -- TURN MAPPING ON

NOAS:	INC	Byte Ptr CS:MAPFLG	;SET MAP FLAG
	SUB	AH,';'			;REMOVE ASCII FROM CHARACTER
	ADD	AH,AH			;DOUBLE IT
	XCHG	AL,AH			;NOW, AX = INDEX INTO TABLE
	ADD	BX,AX			;BX POINTS TO TABLE ENTRY
	MOV	BX,CS:[BX]		;BX POINTS TO MAP STRING
	CMP	Byte Ptr CS:ASFLG,0	;ALTERNATE FUNCTION?
	JZ	NOAS1			;NO
	ADD	BX,LTBL			;ELSE, USE SECOND TABLE
	MOV	Byte Ptr CS:ASFLG,0	;CLEAR ALTERNATE FLAG
NOAS1:	MOV	Word Ptr CS:MAPPTR,BX	;SET UP MAP POINTER

;	MAPPING ROUTINE -- SENDS A CHARACTER FROM THE USER SUPPLIED
;	STRING AS LONG AS THE SYSTEM REQUESTS KEYBOARD INPUT, UNTIL
;	THE END OF THE STRING IS REACHED.  THEN NORMAL INPUT IS
;	RESUMED

MAP:	MOV	BX,Word Ptr CS:MAPPTR	;GET MAP POINTER
	MOV	AL,Byte Ptr CS:[BX]	;GET MAPPED CHARACTER
	INC	BX			;INCREMENT POINTER
	OR	AL,AL			;NULL CHARACTER?
	JNZ	NOTCODE			;NO, NOT CODE KEY
	MOV	AH,CS:[BX]		;ELSE, GET MAPPED SCAN CODE
	INC	BX			;FIX POINTER
	JMP	SHORT CSEND		;AND EXIT
NOTCODE:CALL	GETSCAN			;GET SCAN CODE FOR CHARACTER
CSEND:	MOV	Word Ptr CS:MAPPTR,BX	;UPDATE MAP POINTER
	CMP	Byte Ptr CS:[BX],255	;END OF STRING?
	JNZ	MAPX			;NO
	MOV	Byte Ptr CS:MAPFLG,0	;ELSE, CLEAR MAP FLAG
MAPX:	JMP	INTRET			;RETURN WITH MAPPED CHARACTER

;	TOGGLE KEYMAP OFF AND ON

TOGGLE:	XOR	Byte Ptr CS:TGLFLG,1	;TOGGLE TOGGLE FLAG
	PUSHF				;SAVE RESULT OF TOGGLE
	CMP	Byte Ptr CS:BLMSG,0	;ANY BOTTOM LINE MESSAGE?
	JNZ	TOGGLE0			;YES
	POPF				;ELSE, REMOVE PUSHED FLAGS
	JMP	NMAP			;GET ANOTHER INPUT
TOGGLE0:POPF				;GET RESULT OF TOGGLE
	JZ	TOGGLE1			;TOGGLED ON, WRITE BOTTOM LINE
	PUSH	CX			;ELSE, PREPARE TO CLEAR BOTTOM LINE
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,8
	INT	10H			;GET ATTRIBUTE AT CURSOR POS.
	MOV	BH,AH			;PUT IT IN BH
	MOV	AX,600H			;GET BLANK WINDOW FUNCTION
	MOV	CX,24*256		;UPPER CORNER OF WINDOW
	MOV	DX,24*256+79		;LOWER CORNER
	INT	10H			;BLANK 24TH LINE
	PUSH	DS			;SAVE DS
	XOR	AX,AX
	MOV	DS,AX			;POINT TO BOTTOM SEGMENT
	MOV	BX,10H*4		;POINT TO INT 10H VECTOR
	MOV	AX,Word Ptr CS:INT10V	;GET ORIGINAL ADDRESS
	MOV	[BX],AX			;PUT IT IN
	MOV	AX,Word Ptr CS:INT10V+2
	MOV	2[BX],AX
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	CX
	STI
	JMP	NMAP			;GET ANOTHER INPUT
TOGGLE1:PUSH	DI
	PUSH	BP
	PUSH	CX
	CALL	PBMSG			;PRINT BOTTOM MSG
	POP	CX
	POP	BP
	POP	DI
	STI
	JMP	NMAP			;GET ANOTHER CHARACTER

;	PRINT BOTTOM MESSAGE AND FIX INT 10H VECTOR

PBMSG:	PUSH	SI			;SAVE SOME REGISTERS
	PUSH	DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,3
	INT	10H			;GET CURSOR POSITION
	PUSH	DX			;SAVE IT
	CMP	DH,24			;CURSOR ON BOTTOM?
	JNZ	NOTBOT			;NO
	POP	DX			;ELSE, GET IT AGAIN
	DEC	DH			;MOVE IT UP ONE
	PUSH	DX			;SAVE AGAIN
	MOV	AH,8
	INT	10H			;GET CURRENT ATTRIBUTE
	PUSH	BX			;SAVE ACTIVE PAGE
	MOV	BH,AH			;ATTRIBITE TO BH
	MOV	AX,6*256+1		;FUNC. 6, 1 LINE
	MOV	CX,0			;SCROLL FROM UPPER LEFT
	MOV	DX,24*256+79		;TO LOWER RIGHT
	INT	10H			;SCROLL SCREEN UP
	POP	BX			;RESTORE ACTIVE PAGE
NOTBOT:	MOV	DX,24*256		;SET CURSOR TO BOTTOM LINE
	PUSH	DX			;SAVE IT
	MOV	SI,Offset BLMSG		;POINT TO BOTTOM LINE MSG
	MOV	CX,80			;WRITE 80 CHARACTERS
	CLD				;ENSURE FORWARD STRING DIRECTION
	POP	DX			;GET CURSOR POSITION
PBLP:	LODSB				;GET A CHARACTER
	PUSH	CX			;SAVE COUNTER
	PUSH	SI			;SAVE POINTER
	PUSH	DX			;SAVE CURSOR POSITION
	PUSH	AX			;SAVE CHARACTER
	MOV	AH,2
	INT	10H			;SET CURSOR POSITION
	POP	AX			;GET CHARACTER
	POP	DX
	INC	DL			;UPDATE POSITION
	PUSH	DX
	MOV	BL,7			;ASSUME NORMAL VIDEO
	OR	AL,AL			;TEST CHARACTER
	JNS	NORVID			;IT'S NORMAL
	MOV	BL,0FH			;ELSE, SET INTENSE VIDEO
	AND	AL,7FH			;STRIP MARKER BIT
NORVID:	MOV	CX,1			;WRITE 1 CHARACTER
	MOV	AH,9
	INT	10H			;WRITE CHARACTER
	POP	DX
	POP	SI
	POP	CX
	LOOP	PBLP			;LOOP UNTIL DONE
	POP	DX			;GET OLD CURSOR POSITION
	MOV	AH,2
	INT	10H			;SET IT
	XOR	AX,AX
	MOV	DS,AX			;SET DS TO BOTTOM SEG.
	MOV	BX,10H*4		;POINT TO INT 10H VECTOR
	CLI
	MOV	Word Ptr [BX],Offset MYOUT	;SET NEW VECTOR
	MOV	2[BX],CS
	STI
	POP	DS			;RESTORE DS
	POP	SI			;AND SI
	RET

;	TAKE "TERMINAL" OFF LINE

OFFLIN:	CALL	INCHAR			;GET A CHARACTER
	CMP	AL,Byte Ptr CS:OFFLNK	;GO BACK ON LINE?
	JZ	ONLIN			;YES
	MOV	AH,14
	MOV	BX,0
	PUSH	SI
	PUSH	DI
	PUSH	BP
	INT	10H			;SEND CHARACTER
	POP	BP
	POP	DI
	POP	SI
	JMP	SHORT OFFLIN		;GO AROUND AGAIN
ONLIN:	JMP	NMAP			;CONTINUE WHERE WE LEFT OFF

;	GET SCAN CODE FOR MAPPED CHARACTER

GETSCAN:CMP	AL,9			;TAB
	MOV	AH,15			;ASSUME IT IS
	JZ	GETSCX			;IT IS
	CMP	AL,0DH			;CR?
	MOV	AH,28			;ASSUME IT IS
	JZ	GETSCX
	CMP	AL,0AH			;LF?
	MOV	AH,28			;USE RET KEY
	JZ	GETSCX
	PUSH	DS			;NOT SPECIAL CASE, SAVE DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	PUSH	BX			;SAVE BX
	PUSH	AX			;AND CHAR
	MOV	BX,Offset SCANTBL	;POINT TO SCAN TABLE
	CMP	AL,' '			;LESS THAN SPACE?
	JNB	GETSC1			;NO
	ADD	AL,'@'			;ELSE, CONTROL CHAR, CONVERT
GETSC1:	XLAT				;GET SCAN CODE FROM TABLE
	MOV	BL,AL			;SAVE CODE IN BL
	POP	AX			;RESTORE CHARACTER
	MOV	AH,BL			;PUT SCAN CODE IN AH
	POP	BX
	POP	DS
GETSCX:	RET

;	INPUT CHARACTERS FROM KEYBOARD, BYPASSING KEYMAP CHECKS

INCHAR:	PUSH	DS			;SAVE DS
	PUSH	BX			;SAVE BX
	XOR	AX,AX
	MOV	DS,AX			;SET DS TO BOTTOM SEGMENT
	MOV	BX,16H*4		;POINT TO INPUT VECTOR
	MOV	Word Ptr [BX],Offset XINT16	;ALTER TO BYPASS KEYMAP
	INT	16H			;READ CHARACTER
	MOV	Word Ptr [BX],Offset MYINT16	;FIX VECTOR
	POP	BX			;RESTORE REGISTERS
	POP	DS
	STI				;ENSURE INTERRUPTS ENABLED
	RET

;	OUTPUT CHARACTERS TO SCREEN, WITH 25TH LINE PROTECTED

MYOUT:	STI				;TURN INTERRUPTS ON
	CMP	AH,14			;TTY OUT?
	JNE	MYOUT1			;NO, LET BIOS DO IT
	CMP	AL,10			;LF?
	JNE	MYOUT1			;NO
	PUSH	SI			;ELSE, SAVE SOME REGISTERS
	PUSH	DI
	PUSH	BP
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,3			;GET CURSOR POSITION
	INT	10H
	MOV	AX,14*256+10		;REPLACE FUNC #, CHAR
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JL	MYOUT0
	JE	SCROL24			;IF LINE = 24 THEN SCROLL 1-24
MYX:	POP	DX			;RESTORE REGISTERS
	POP	CX
	POP	BX
	POP	BP
	POP	DI
	POP	SI
	IRET				;IF LINE = 25 THEN IGNORE LF
SCROL24:MOV	AH,8
	INT	10H			;READ CHAR ATTRIBUTE
	MOV	BH,AH			;ATTRIBUTE TO BH
	MOV	AX,6*256+1		;SCROLL FUNCTION (6), 1 LINE
	MOV	CX,0			;UPPER LEFT SCROLL POSITION
	MOV	DX,23*256+79		;LOWER RIGHT CORNER
	INT	10H			;SCROLL THE SCREEN
	JMP	SHORT MYX		;AND RETURN
MYOUT0:	POP	DX
	POP	CX
	POP	BX
	POP	BP
	POP	DI
	POP	SI
MYOUT1:	JMP	Dword Ptr CS:INT10V	;LET BIOS PROCESS CHAR

LEND:					;END OF RESIDENT CODE

;	SET UP FOR KEY MAPPING BY VECTORING BIOS CONSOLE STATUS
;	AND INPUT ROUTINES TO THIS PROGRAM

SETUP:	MOV	AH,15
	INT	10H			;READ VIDEO STATE
	CMP	AH,15			;AH CHANGED?
	JNZ	GDSYS			;YES, GOOD SYSTEM
	MOV	DX,Offset BSMSG
	MOV	AH,TYPEF
	INT	21H			;ELSE, SAY "BAD SYSTEM"
	INT	20H			;AND EXIT
GDSYS:	XOR	AX,AX
	MOV	DS,AX			;POINT TO BOTTOM SEGMENT
	MOV	SI,16H*4		;POINT TO INPUT VECTOR
	PUSH	SI
	LES	DI,Dword Ptr [SI]	;GET ROUTINE ADDRESS
	CMP	Word Ptr ES:-2[DI],'MK'	;TEST FOR KEYMAP ALREADY IN
	JZ	ITSIN			;IT'S IN, EXIT
	MOV	DI,Offset INT16V	;POINT TO KEYMAP EXIT
	PUSH	CS
	POP	ES			;PUT ES HERE
	CLD				;ENSURE FORWARD DIRECTION
	MOVSW				;MOVE INPUT VECTOR TO KEYMAP
	MOVSW
	POP	SI
	MOV	Word Ptr [SI],Offset MYINT16	;ALTER VECTOR TO HERE
	MOV	2[SI],CS
	CMP	Byte Ptr CS:BLMSG,0	;ANY BOTTOM LINE MESSAGE?
	JZ	NMSG			;NO
	MOV	SI,10H*4		;ELSE, POINT TO INT 10H VECTOR
	MOV	DI,Offset INT10V	;WHERE TO PUT IT
	MOVSW				;PUT IT THERE
	MOVSW
	CALL	PBMSG			;PRINT BOTTOM LINE MSG
NMSG:	PUSH	CS
	POP	DS			;RESTORE DS
	MOV	DX,Offset SIGNON
	MOV	AH,TYPEF
	INT	21H			;PRINT SIGN ON MESSAGE
	MOV	DX,Offset LEND		;SET DX
	INT	27H			;TERMINATE, BUT STAY RESIDENT
ITSIN:	MOV	AX,CS
	MOV	DS,AX			;RESTORE DX
	MOV	DX,Offset INMSG
	MOV	AH,TYPEF
	INT	21H			;SAY "ALREADY LOADED"
	INT	20H			;AND EXIT

SIGNON	DB	13,10
	DB	'Z-150 KEYMAP Function Key Mapper, Version 1.0'
	DB	' (by PS:) is now installed.$'
INMSG	DB	13,10
	DB	'ERROR -- KEYMAP is already installed.$'
BSMSG	DB	13,10
	DB	'ERROR -- Incompatible computer system.  '
	DB	'Can',27H,'t run Z-150 KEYMAP.$'

KEY	ENDS
	END	START
                    