	TITLE	CP/EMulator II CP/M EMULATOR
	SUBTTL	Definitions
	PAGE	,132
;	CP/EMulator II -- A PROGRAM FOR RUNNING CP/M PROGRAMS
;	UNDER MS-DOS ON Z-150 AND ET-100 COMPUTERS.
;
;	THIS PROGRAM ALLOWS YOU TO RUN 8080 CODE CP/M PROGRAMS
;	UNDER MS-DOS BY NOT ONLY EMULATING THE CP/M SYSTEM CALLS,
;	BUT BY EMULATING THE 8080 PROCESSOR ITSELF.  THE PROGRAM
;	CAN THEREFORE RUN ON A SYSTEM THAT DOES NOT HAVE AN 8-BIT
;	PROCESSOR.
;
;	BY P. SWAYNE, HUG  30-AUG-84  06-SEP-84
;	MUCH IS FROM FROM THE FIRST CP/EMulator BY BOB METZ
;
;	This program provides a pseudo-CP/M environment in which
;	it is possible to run a good deal of software designed
;	to run under CP/M under MS-DOS instead.  The 8080 machine
;	code instructions in the CP/M program are intrepreted by
;	this program, and MS-DOS does all I/O.  CP/M programs using
;	standard calls should function properly.  Any CP/M program
;	which attempts to utilize the BIOS (except non-disk I/O)
;	will fail.
;
;	To use the program, enter the CPM2 command to invoke this 
;	program followed by the name of the CP/M program to be
;	executed, followed by any parameters required by that
;	program.  E.g.:
;
;		A:CPM2 DUMP FILE.TXT
;
;	would run CP/M program 'DUMP' which uses 'FILE.TXT' as a 
;	parameter.
;	CP/M programs which normally have a 'COM' extension must
;	have a 'CPM2' extension to be run by this program.  To
;	prepare a CP/M program for execution, merely copy the 
;	program file from a CP/M disk to the MS-DOS disk using the
;	'RDCPM2' utility.
;
;	Entering 'CPM2' followed by a carriage return will cause
;	a page of text to be displayed which explains the use
;	of the CPM2 program.
;
;	The IOBYTE may be changed from the default value by
;	entering its 2-digit hex value in the following menner:
;
;		A:CPM2[/io] Prog [Parms]
;
;	The IOBYTE bits ars as follows [(*) indicates default]:
;
;	0,1 = CON:  0 - AUX
;		    1 - KBD/CRT (*)
;		    2 - IN/LST
;		    3 - KBD/OUT,CRT
;	2,3 = RDR:  0 - AUX (*)
;		    1 - KBD
;		    2 - AUX
;		    3 - IN
;	4,5 = PUN:  0 - AUX (*)
;		    1 - CRT
;		    2 - PRT
;		    3 - OUT
;	6,7 = LST:  0 - AUX
;		    1 - CRT
;		    2 - PRT (*)
;		    3 - OUT
;
;	IN & OUT are files CPM.IN and CPM.OUT
;
;	TECHNICAL DATA
;
;	WHILE INTERPRETING 8080 CODE, THIS PROGRAM USES THE 8088
;	REGISTERS AS FOLLOWS
;
;	REGISTER	USE
;	AX		8080 ACCUMULATOR (AL) AND FLAGS (AH)
;	BX		8080 HL REGISTER
;	CX		8080 BC REGISTER
;	DX		8080 DE REGISTER
;	SI		8080 PROGRAM COUNTER
;	DI		8080 STACK POINTER
;	BP		8080 INSTRUCTION DECODE REGISTER
;
;	THIS PROGRAM MAINTAINS 3 SEGMENTS IN MEMORY.  A CODE
;	SEGMENT IS USED FOR THE 8088 EXECUTABLE CODE AND FOR
;	VARIABLES MAINTAINED BY THIS PROGRAM.  A DATA SEGMENT
;	HOLDS THE CP/M PROGRAM, PARAMETERS REQUIRED BY IT, AND
;	A TEMPORARY FCB USED BY THIS PROGRAM.  THE ES AND DS
;	REGISTERS POINT TO THE DATA SEGMENT.  A STACK SEGMENT
;	IS USED FOR THIS PROGRAM'S STACK AND FOR A JUMP TABLE
;	CONTAINING THE ADDRESSES OF 8080 EMULATION ROUTINES.
;	THE JUMP TABLE IS KEPT IN THE STACK SEGMENT SO THAT
;	THE BP REGISTER CAN BE USED TO INDEX IT WITHOUT A
;	SEGMENT OVER-RIDE.
	PAGE
;
CPM2	SEGMENT
	ASSUME CS:CPM2,DS:CPM2,SS:CPM2,ES:CPM2
;
	ORG	3
IOBYTEL:
	ORG	4
DEFDSKL:
	ORG	5CH
FCB1:
	ORG	6CH
FCB2:
	ORG	80H
BUF:
	ORG	100H

M	EQU	Byte Ptr 0[BX]

IOBYTE	EQU	3
DEFDSK	EQU	4
FCBTMP	EQU	0FFC0H			; TEMP. FCB ADDRESS

	SUBTTL	CP/M Program Loader
	PAGE
;	FIND THE SEGMENT ADDRESS OF THE END OF THIS PROGRAM.
;	USE IT FOR CP/M SEGMENT.

START:	MOV	AX,Offset LEND		; POINT TO PGM END
	MOV	CL,4
	SHR	AX,CL			; DIVIDE BY 16
	INC	AX			; MOVE TO CLEAR PARAGRAPH
	MOV	BX,CS			; GET CODE SEGMENT ADDR
	ADD	BX,AX			; FIND FREE SEGMENT
	PUSH	BX			; SAVE RESULT FOR STACK SEGMENT
	ADD	BX,40H			; ADD 4 PAGES OF SPACE
	MOV	ES,BX			; PUT ES HERE
	MOV	Word Ptr CPMSEG,BX	; SAVE CP/M SEGMENT
	MOV	BX,0FFFFH		; POINT TO LAST BYTE IN SEGMENT
	MOV	AL,Byte Ptr ES:[BX]	; GET A BYTE
	INC	Byte Ptr ES:[BX]	; TRY TO CHANGE MEMORY
	CMP	AL,Byte Ptr ES:[BX]	; SEE IF IT CHANGED
	MOV	Byte Ptr ES:[BX],AL	; FIX RAM
	PUSH	CS
	POP	ES			; FIX ES
	POP	BX			; RESTORE STACK SEGMENT ADDR
	JNZ	RAM_OK			; RAM IS OK
NOT_ENOUGH_RAM:
	MOV	DX,Offset NMMSG
	MOV	AH,9
	INT	21H			; ELSE, SAY "NOT ENOUGH RAM"
	INT	20H
RAM_OK:
	CLD
	CLI				; KILL INTERRUPTS
	MOV	SS,BX			; SET STACK SEGMENT
	MOV	SP,400H			; SET STACK
	STI				; RESTORE INTERRUPTS
	MOV	ES,BX			; PUT ES IN STACK SEGMENT
	MOV	SI,Offset OPTABLE	; POINT TO OPCODE TABLE
	MOV	DI,0
	MOV	CX,256
	REP	MOVSW			; MOVE TABLE TO STACK SEGMENT
	PUSH	CS
	POP	ES			; FIX ES
	MOV	SI,Offset BUF
	MOV	DI,Offset LINBUF
	MOV	CX,80H
	REP	MOVSB			; Copy parms to LINBUF
	MOV	SI,Offset LINBUF+1
	MOV	AL,[SI]			; Check for optional IOBYTE
	CMP	AL,'/'
	JNE	NOIOBYTE
	INC	SI
	DEC	LINBUF			; One found - decode hex ascii
	LODSB
	CMP	AL,'0'
	JL	EXPLAINJ		; Display explaination on illegal entry
	CMP	AL,'F'
	JG	EXPLAINJ
	MOV	AH,AL
	LODSB
	CMP	AL,'0'
	JL	EXPLAINJ
	CMP	AL,'F'
	JL	HEXOK
EXPLAINJ:
	JMP	EXPLAIN
HEXOK:
	DEC	LINBUF
	DEC	LINBUF
	CMP	AH,'9'
	JLE	CKAL
	SUB	AH,7
CKAL:
	CMP	AL,'9'
	JLE	FIXBYT
	SUB	AL,7
FIXBYT:
	AND	AX,0F0FH
	MOV	CL,4
	SHL	AH,CL
	OR 	AL,AH
	MOV	DEFLTIO,AL		; Change default IOBYTE
NOIOBYTE:
	MOV	BL,LINBUF
	MOV	BH,0
	CMP	BX,0
	JG	GOTPROG			; We have a program
	JMP	EXPLAIN			; Else, explain
GOTPROG:
	MOV	AL,0
	MOV	DI,Offset FCB1
	STOSB
	MOV	AL,' '			; Fill name area with spaces
	MOV	CX,15
	REP	STOSB
	MOV	AL,0
	STOSB
	MOV	AL,' '
	MOV	CX,15
	REP	STOSB
	MOV	AL,0
FCBCLR:					; Clear FCB area
	STOSB
	CMP	DI,Offset START
	JL	FCBCLR
	ADD	BX,SI
	MOV	DI,Offset FCBC		; Parse CP/M program name
	MOV	AH,29H
	MOV	AL,0FFH
	INT	21H
	MOV	Byte Ptr BUF,0
	MOV	SISV,SI
	CMP	SI,BX
	JGE	NOPARMS
	MOV	DI,Offset FCB1		; Parse 1st parm to FCB1
	MOV	AH,29H
	MOV	AL,0FFH
	INT	21H
	CMP	SI,BX
	JGE	NOPARM2
	MOV	DI,Offset FCB2		; Parse 2nd parm to FCB2
	MOV	AH,29H
	MOV	AL,0FFH
	INT	21H
NOPARM2:
	MOV	SI,SISV
	MOV	DI,Offset BUF+1		; Copy all parms to buffer area
CPYLP:
	MOVSB
	INC	Byte Ptr BUF
	CMP	SI,BX
	JNE	CPYLP
	MOV	AL,0			; Add 0 at end
	STOSB
NOPARMS:
	MOV	DI,Offset FCBC+9
	MOV	SI,Offset CPMC		; Force to 'CPM' extension
	MOVSB
	MOVSB
	MOVSB
	MOV	AL,0
	MOV	CX,30			; Clear remainder of FCB
	REP	STOSB
	CMP	Byte Ptr FCBC+1,'?'	; COMMAND MODE WANTED?
	MOV	DX,Offset FCBC		; ASSUME NO
	JNZ	GETCMD
	MOV	Byte Ptr CMDFLAG,1	; ELSE, SET CMD FLAG
	MOV	DX,Offset SGNON
	MOV	AH,9
	INT	21H			; PRINT SIGN-ON MESSAGE
	MOV	DX,Offset CMDFCB	; GET CMD FCB
GETCMD:
	MOV	AH,15			; Open file
	INT	21H
	CMP	AL,0
	JE 	OPENOK
NOPROG:
	MOV	DX,Offset ERMSG		; Error - no program file
	MOV	AH,9
	INT	21H
	INT	20H
;
EXPLAIN:
	MOV	DX,Offset XMSG		; Display instructions if no 
	MOV	AH,9			;  program name entered
	INT	21H
	INT	20H
;
OPENOK:
	MOV	AX,Word Ptr FCBC+16	; Set rec size to file size
	MOV	Word Ptr FCBC+14,AX
	MOV	AX,Word Ptr CMDFCB+16	; SAME FOR CMD FCB
	MOV	Word Ptr CMDFCB+14,AX
	MOV	AX,Word Ptr CPMSEG
	MOV	ES,AX			; ES at CP/M SEGMENT
	MOV	DI,0
	MOV	SI,0
	MOV	CX,100H
	REP	MOVSB			; Copy 100H-byte program header
	PUSH	ES
	POP	DS
	MOV	DX,100H			; SET DTA TO CPMSEG:100
	CMP	Byte Ptr CS:CMDFLAG,0	; COMMAND MODE?
	JZ	NOTCMD1			; NO
	MOV	DX,0F600H		; SET DTA TO CPMSEG:F600
NOTCMD1:
	MOV	AH,1AH			; SET DTA
	INT	21H
	PUSH	CS
	POP	DS
	MOV	DX,Offset FCBC
	CMP	Byte Ptr CMDFLAG,0	; COMMAND MODE?
	JZ	NOTCMD2
	MOV	DX,Offset CMDFCB	; USE CMD FCB
NOTCMD2:
	MOV	AH,14H			; Read in program
	INT	21H
	CMP	AL,0			; GOOD READ?
	JZ	GOODRD			; YES
	JMP	NOPROG			; ELSE, SAY "NO PROGRAM"
GOODRD:
	PUSH	ES
	MOV	DX,80H
	POP	DS
	MOV	AH,1AH			; Set up DTA for program
	INT	21H
	PUSH	CS
	POP	DS
	MOV	SI,Offset CPMCOD
	MOV	DI,0FE00H		; Copy 8080 code to CPMSEG:FC00
	MOV	CX,CODSIZ
	REP	MOVSB
	MOV	CX,200H-CODSIZ
	XOR	AL,AL
	REP	STOSB			; CLEAR REST OF 8080 AREA
	MOV	DI,0
	MOV	SI,Offset LOCODE
	MOV	CX,LOSIZE		; Copy JMP instructions to CPMSEG:0
	REP	MOVSB
	XOR	AL,AL
LOCLR:
	STOSB
	CMP	DI,Offset FCB1		; Clear to FCB1
	JL	LOCLR
	MOV	SI,Offset DPB
	MOV	DI,0FE10H
	MOV	CX,17
	REP	MOVSB			; MOV DPB TO CP/M AREA
	MOV	AH,19H
	INT	21H			; Get default drive id
	MOV	Byte Ptr ES:DEFDSK,AL	; set in CP/M header
	MOV	DX,Offset CTLC_PROCESS
	MOV	AH,25H
	MOV	AL,23H
	INT	21H			; SET IN DUMMY CONTROL-C ROUTINE
	MOV	SI,100H			; SET "PROGRAM COUNTER"
	CMP	Byte Ptr CMDFLAG,1	; COMMAND MODE?
	JNZ	SETSTK			; NO
	MOV	SI,0F600H		; ELSE, START AT CMD.SYS
SETSTK:	MOV	DI,0FFFEH		; PUT 8080 STACK HERE
	PUSH	ES
	POP	DS			; PUT DS IN CP/M SEGMENT
	MOV	Word Ptr [DI],0		; ENSURE JUMP TO 0 ON STACK
	XOR	AX,AX			; CLEAR ALL USER REGISTERS
	XOR	BX,BX
	XOR	CX,CX
	XOR	DX,DX
	SUBTTL	8080 Code and CP/M System call decoder
	PAGE
;	THIS IS THE MAIN LOOP OF THE 8080 INTERPRETER.  HERE THE
;	OPCODE IS FETCHED, AND A ROUTINE IS BRANCHED TO BASED
;	ON THE OPCODE'S VALUE.
;	(ACTUALLY, THIS CODE HERE IS EXECUTED ONLY ONCE, AND A
;	COPY OF IT IS EXECUTED AFTER EACH EMULATION ROUTINE,
;	RATHER THAN JUMPING BACK TO HERE.  THAT SAVES 15 CLOCK
;	CYCLES PER 8080 INSTRUCTION.

MLOOP:	MOV	BP,AX			;SAVE 8080 A,F
	LODSB				;FETCH OPCODE
	XOR	AH,AH			;CLEAR HI BYTE
	SHL	AX,1			;* 2
	XCHG	AX,BP			;RESTORE A,F
	JMP	Word Ptr [BP]		;EXECUTE THE OPCODE

;	TABLE OF 8080 OPCODE PROCESSING ROUTINES
;	THIS TABLE IS MOVED TO LOW MEMORY IN THE STACK SEGMENT

OPTABLE:
	DW	NOOP
	DW	LXIB
	DW	STAXB
	DW	INXB
	DW	INRB
	DW	DCRB
	DW	MVIB
	DW	RALC
	DW	NOOP			;UNUSED OPCODE (08H)
	DW	DADB
	DW	LDAXB
	DW	DCXB
	DW	INRC
	DW	DCRC
	DW	MVIC
	DW	RARC
	DW	NOOP			;10H
	DW	LXID
	DW	STAXD
	DW	INXD
	DW	INRD
	DW	DCRD
	DW	MVID
	DW	RAAL
	DW	NOOP			;18H
	DW	DADD
	DW	LDAXD
	DW	DCXD
	DW	INRE
	DW	DCRE
	DW	MVIE
	DW	RAAR
	DW	NOOP			;20H
	DW	LXIH
	DW	SHLD
	DW	INXH
	DW	INRH
	DW	DCRH
	DW	MVIH
	DW	DAAA
	DW	NOOP			;28H
	DW	DADH
	DW	LHLD
	DW	DCXH
	DW	INRL
	DW	DCRL
	DW	MVIL
	DW	CMAA
	DW	NOOP			;30H
	DW	LXISP
	DW	STAA
	DW	INXSP
	DW	INRM
	DW	DCRM
	DW	MVIM
	DW	STCF
	DW	NOOP			;38H
	DW	DADSP
	DW	LDAA
	DW	DCXSP
	DW	INRA
	DW	DCRA
	DW	MVIA
	DW	CMCF
;
	DW	NOOP			;MOV B,B
	DW	MOVBC
	DW	MOVBD
	DW	MOVBE
	DW	MOVBH
	DW	MOVBL
	DW	MOVBM
	DW	MOVBA
;
	DW	MOVCB
	DW	NOOP			;MOV C,C
	DW	MOVCD
	DW	MOVCE
	DW	MOVCH
	DW	MOVCL
	DW	MOVCM
	DW	MOVCA
;
	DW	MOVDB
	DW	MOVDC
	DW	NOOP			;MOV D,D
	DW	MOVDE
	DW	MOVDH
	DW	MOVDL
	DW	MOVDM
	DW	MOVDA
;
	DW	MOVEB
	DW	MOVEC
	DW	MOVED
	DW	NOOP			;MOV E,E
	DW	MOVEH
	DW	MOVEL
	DW	MOVEM
	DW	MOVEA
;
	DW	MOVHB
	DW	MOVHC
	DW	MOVHD
	DW	MOVHE
	DW	NOOP			;MOV H,H
	DW	MOVHL
	DW	MOVHM
	DW	MOVHA
;
	DW	MOVLB
	DW	MOVLC
	DW	MOVLD
	DW	MOVLE
	DW	MOVLH
	DW	NOOP			;MOV L,L
	DW	MOVLM
	DW	MOVLA
;
	DW	MOVMB
	DW	MOVMC
	DW	MOVMD
	DW	MOVME
	DW	MOVMH
	DW	MOVML
	DW	HALT
	DW	MOVMA
;
	DW	MOVAB
	DW	MOVAC
	DW	MOVAD
	DW	MOVAE
	DW	MOVAH
	DW	MOVAL
	DW	MOVAM
	DW	NOOP			;MOV A,A
;
	DW	ADDB
	DW	ADDC
	DW	ADDD
	DW	ADDE
	DW	ADDH
	DW	ADDL
	DW	ADDM
	DW	ADDA
;
	DW	ADCB
	DW	ADCC
	DW	ADCD
	DW	ADCE
	DW	ADCH
	DW	ADCL
	DW	ADCM
	DW	ADCA
;
	DW	SUBB
	DW	SUBC
	DW	SUBD
	DW	SUBE
	DW	SUBH
	DW	SUBL
	DW	SUBM
	DW	XRAA			;SUB A
;
	DW	SBBB
	DW	SBBC
	DW	SBBD
	DW	SBBE
	DW	SBBH
	DW	SBBL
	DW	SBBM
	DW	SBBA
;
	DW	ANAB
	DW	ANAC
	DW	ANAD
	DW	ANAE
	DW	ANAH
	DW	ANAL
	DW	ANAM
	DW	ANAA
;
	DW	XRAB
	DW	XRAC
	DW	XRAD
	DW	XRAE
	DW	XRAH
	DW	XRAL
	DW	XRAM
	DW	XRAA
;
	DW	ORAB
	DW	ORAC
	DW	ORAD
	DW	ORAE
	DW	ORAH
	DW	ORAL
	DW	ORAM
	DW	ORAA
;
	DW	CMPB
	DW	CMPC
	DW	CMPD
	DW	CMPE
	DW	CMPH
	DW	CMPL
	DW	CMPM
	DW	CMPA
;
	DW	RNZ
	DW	POPB
	DW	JPNZ
	DW	JUMP
	DW	CNZ
	DW	PUSHB
	DW	ADI
	DW	RST0
	DW	RZ
	DW	RETS
	DW	JPZ
	DW	NOOP			;0CBH
	DW	CZ
	DW	CALLS
	DW	ACI
	DW	CBDOS			;USE RST 1 FOR BDOS CALLS
	DW	RNC
	DW	POPD
	DW	JPNC
	DW	OUTA
	DW	CNC
	DW	PUSHD
	DW	SUI
	DW	RST2
	DW	RC
	DW	NOOP			;0D9H
	DW	JPC
	DW	INA
	DW	CC
	DW	NOOP			;0DDH
	DW	SBI
	DW	RST3
	DW	RPO
	DW	POPH
	DW	JPPO
	DW	XTHL
	DW	CPO
	DW	PUSHH
	DW	ANI
	DW	RST4
	DW	RPE
	DW	PCHL
	DW	JPPE
	DW	XCHD
	DW	CPE
	DW	NOOP			;0EDH
	DW	XRI
	DW	RST5
	DW	RP
	DW	POPAF
	DW	JPP
	DW	NOOP			;DISABLE INTERRUPTS (NOT ALLOWED)
	DW	CP
	DW	PUSHAF
	DW	ORI
	DW	RST6
	DW	RM
	DW	SPHL
	DW	JPM
	DW	NOOP			;ENABLE INTERRUPTS (NOT ALLOWED)
	DW	CM
	DW	NOOP			;0FDH
	DW	CPI
	DW	RST7


;	8080 OPCODE PROCESSING ROUTINES
;	THE NAME OF EACH ROUTINE IS DERIVED FROM THE OPCODE
;	IT EMULATES.

NOOP:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LXIB:	MOV	CX,AX			;SAVE ACC.
	LODSW				;GET DATA
	XCHG	CX,AX			;DATA TO CX, RESTORE ACC.
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
STAXB:	XCHG	SI,CX
	MOV	[SI],AL
	XCHG	SI,CX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INXB:	INC	CX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRB:	SAHF				;SET FLAGS TO 8080 CONDITION
	INC	CH			;PERFORM FLAG ALTERING OPERATION
	LAHF				;SAVE FLAGS IN 8080 "FLAG" REGISTER
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]			;AND SO FOR ALL SUCH OPCODES
DCRB:	SAHF
	DEC	CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVIB:	MOV	CH,[SI]
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RALC:	SAHF
	ROL	AL,1
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DADB:	AND	AH,0FEH			;CLEAR 8080 CARRY FLAG
	ADD	BX,CX			;16-BIT ADD
	JNC	NCYB			;CARRY NOT SET
	OR	AH,1			;ELSE, SET 8080 CARRY FLAG
NCYB:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LDAXB:	XCHG	SI,CX
	MOV	AL,[SI]
	XCHG	SI,CX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCXB:	DEC	CX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRC:	SAHF
	INC	CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCRC:	SAHF
	DEC	CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVIC:	MOV	CL,[SI]
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RARC:	SAHF
	ROR	AL,1
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LXID:	MOV	DX,AX
	LODSW
	XCHG	DX,AX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
STAXD:	XCHG	SI,DX
	MOV	[SI],AL
	XCHG	SI,DX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INXD:	INC	DX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRD:	SAHF
	INC	DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCRD:	SAHF
	DEC	DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVID:	MOV	DH,[SI]
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RAAL:	SAHF
	RCL	AL,1
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DADD:	AND	AH,0FEH
	ADD	BX,DX
	JNC	NCYD
	OR	AH,1
NCYD:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LDAXD:	XCHG	SI,DX
	MOV	AL,[SI]
	XCHG	SI,DX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCXD:	DEC	DX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRE:	SAHF
	INC	DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCRE:	SAHF
	DEC	DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVIE:	MOV	DL,[SI]
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RAAR:	SAHF
	RCR	AL,1
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LXIH:	MOV	BX,AX
	LODSW
	XCHG	BX,AX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SHLD:	MOV	BP,AX			;SAVE ACCUMULATOR
	LODSW				;GET ADDRESS
	XCHG	AX,BX
	MOV	[BX],AX			;PUT DATA THERE
	MOV	BX,AX
	MOV	AX,BP
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INXH:	INC	BX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRH:	SAHF
	INC	BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCRH:	SAHF
	DEC	BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVIH:	MOV	BH,[SI]
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DAAA:	SAHF
	DAA
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DADH:	AND	AH,0FEH
	SHL	BX,1
	JNC	NCYH
	OR	AH,1
NCYH:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LHLD:	MOV	BX,[SI]			;GET ADDRESS
	INC	SI
	INC	SI
	MOV	BX,[BX]			;GET DATA THERE
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCXH:	DEC	BX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRL:	SAHF
	INC	BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCRL:	SAHF
	DEC	BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVIL:	MOV	BL,[SI]
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMAA:	NOT	AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LXISP:	MOV	DI,[SI]			;DI IS OUR "STACK POINTER"
	INC	SI
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
STAA:	MOV	BP,BX
	MOV	BX,[SI]
	MOV	M,AL
	MOV	BX,BP
	INC	SI
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INXSP:	INC	DI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRM:	SAHF
	INC	M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCRM:	SAHF
	DEC	M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVIM:	MOV	BP,AX
	LODSB				;GET DATA
	MOV	M,AL			;STORE IT
	MOV	AX,BP
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
STCF:	OR	AH,1			;SET 8080 CARRY FLAG
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DADSP:	AND	AH,0FEH
	ADD	BX,DI
	JNC	NCYSP
	OR	AH,1
NCYSP:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
LDAA:	MOV	BP,BX
	MOV	BX,[SI]
	MOV	AL,M
	MOV	BX,BP
	INC	SI
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCXSP:	DEC	DI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INRA:	SAHF
	INC	AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
DCRA:	SAHF
	DEC	AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MVIA:	LODSB
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMCF:	XOR	AH,1
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVBC:	MOV	CH,CL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVBD:	MOV	CH,DH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVBE:	MOV	CH,DL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVBH:	MOV	CH,BH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVBL:	MOV	CH,BL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVBM:	MOV	CH,M
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVBA:	MOV	CH,AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVCB:	MOV	CL,CH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVCD:	MOV	CL,DH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVCE:	MOV	CL,DL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVCH:	MOV	CL,BH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVCL:	MOV	CL,BL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVCM:	MOV	CL,M
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVCA:	MOV	CL,AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVDB:	MOV	DH,CH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVDC:	MOV	DH,CL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVDE:	MOV	DH,DL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVDH:	MOV	DH,BH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVDL:	MOV	DH,BL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVDM:	MOV	DH,M
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVDA:	MOV	DH,AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVEB:	MOV	DL,CH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVEC:	MOV	DL,CL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVED:	MOV	DL,DH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVEH:	MOV	DL,BH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVEL:	MOV	DL,BL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVEM:	MOV	DL,M
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVEA:	MOV	DL,AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVHB:	MOV	BH,CH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVHC:	MOV	BH,CL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVHD:	MOV	BH,DH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVHE:	MOV	BH,DL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVHL:	MOV	BH,BL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVHM:	MOV	BH,M
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVHA:	MOV	BH,AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVLB:	MOV	BL,CH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVLC:	MOV	BL,CL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVLD:	MOV	BL,DH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVLE:	MOV	BL,DL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVLH:	MOV	BL,BH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVLM:	MOV	BL,M
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVLA:	MOV	BL,AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVMB:	MOV	M,CH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVMC:	MOV	M,CL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVMD:	MOV	M,DH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVME:	MOV	M,DL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVMH:	MOV	M,BH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVML:	MOV	M,BL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
HALT:	HLT
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVMA:	MOV	M,AL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVAB:	MOV	AL,CH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVAC:	MOV	AL,CL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVAD:	MOV	AL,DH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVAE:	MOV	AL,DL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVAH:	MOV	AL,BH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVAL:	MOV	AL,BL
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
MOVAM:	MOV	AL,M
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDB:	ADD	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDC:	ADD	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDD:	ADD	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDE:	ADD	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDH:	ADD	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDL:	ADD	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDM:	ADD	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADDA:	ADD	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCB:	SAHF
	ADC	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCC:	SAHF
	ADC	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCD:	SAHF
	ADC	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCE:	SAHF
	ADC	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCH:	SAHF
	ADC	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCL:	SAHF
	ADC	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCM:	SAHF
	ADC	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADCA:	SAHF
	ADC	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBB:	SUB	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBC:	SUB	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBD:	SUB	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBE:	SUB	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBH:	SUB	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBL:	SUB	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBM:	SUB	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUBA:	SUB	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBB:	SAHF
	SBB	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBC:	SAHF
	SBB	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBD:	SAHF
	SBB	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBE:	SAHF
	SBB	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBH:	SAHF
	SBB	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBL:	SAHF
	SBB	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBM:	SAHF
	SBB	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBBA:	SAHF
	SBB	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAB:	AND	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAC:	AND	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAD:	AND	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAE:	AND	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAH:	AND	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAL:	AND	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAM:	AND	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANAA:	AND	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAB:	XOR	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAC:	XOR	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAD:	XOR	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAE:	XOR	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAH:	XOR	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAL:	XOR	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAM:	XOR	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRAA:	XOR	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAB:	OR	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAC:	OR	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAD:	OR	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAE:	OR	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAH:	OR	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAL:	OR	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAM:	OR	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORAA:	OR	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPB:	CMP	AL,CH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPC:	CMP	AL,CL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPD:	CMP	AL,DH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPE:	CMP	AL,DL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPH:	CMP	AL,BH
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPL:	CMP	AL,BL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPM:	CMP	AL,M
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CMPA:	CMP	AL,AL
	LAHF
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
;
RNZ:	SAHF				;GET FLAGS
	JZ	NRNZ
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRNZ:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
POPB:	MOV	CX,[DI]
	INC	DI
	INC	DI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPNZ:	SAHF
	JZ	NJPNZ
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPNZ:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JUMP:	MOV	SI,[SI]
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CNZ:	SAHF
	JZ	NCNZ
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCNZ:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
PUSHB:	DEC	DI
	DEC	DI
	MOV	[DI],CX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ADI:	ADD	AL,[SI]
	LAHF				;RECORD RESULT
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RST0:	MOV	CL,0
	JMP	CBDOS			;WARM BOOT ON RST 0
RZ:	SAHF				;GET FLAGS
	JNZ	NRZ
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRZ:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RETS:	MOV	SI,[DI]
	INC	DI
	INC	DI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPZ:	SAHF
	JNZ	NJPZ
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPZ:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CZ:	SAHF
	JNZ	NCZ
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCZ:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CALLS:	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI
	INC	SI
	INC	SI
	MOV	[DI],SI			;PUT RET ADDR ON STACK
	MOV	SI,BP			;SET PC
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ACI:	SAHF
	ADC	AL,[SI]
	LAHF
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]

;	BDOS CALLS ARE PROCESSED HERE, AT RST 1 PLACE

CBDOS:	PUSH	SI			;SAVE PC
	PUSH	DI			;SAVE SP
	CALL	CBDOS1			;EXECUTE THE FUNCTION
	POP	DI
	POP	SI
	JMP	RETS			;EXECUTE A RETURN

RNC:	SAHF				;GET FLAGS
	JC	NRNC
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRNC:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
POPD:	MOV	DX,[DI]
	INC	DI
	INC	DI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPNC:	SAHF
	JC	NJPNC
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPNC:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
OUTA:	MOV	BP,DX
	MOV	DL,[SI]			;GET PORT NO.
	INC	SI
	XOR	DH,DH
	OUT	DX,AL
	MOV	DX,BP
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CNC:	SAHF
	JC	NCNC
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCNC:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
PUSHD:	DEC	DI
	DEC	DI
	MOV	[DI],DX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SUI:	SUB	AL,[SI]
	LAHF
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RST2:	DEC	DI
	DEC	DI
	MOV	[DI],SI
	MOV	SI,20Q
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RC:	SAHF				;GET FLAGS
	JNC	NRC
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRC:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPC:	SAHF
	JNC	NJPC
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPC:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
INA:	MOV	BP,DX
	MOV	DL,[SI]			;GET PORT NO.
	INC	SI
	XOR	DH,DH
	IN	AL,DX
	MOV	DX,BP
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CC:	SAHF
	JNC	NCC
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCC:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SBI:	SAHF
	SBB	AL,[SI]
	LAHF
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RST3:	DEC	DI
	DEC	DI
	MOV	[DI],SI
	MOV	SI,30Q
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RPO:	SAHF				;GET FLAGS
	JP	NRPO
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRPO:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
POPH:	MOV	BX,[DI]
	INC	DI
	INC	DI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPPO:	SAHF
	JP	NJPPO
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPPO:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XTHL:	XCHG	BX,[DI]
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CPO:	SAHF
	JP	NCPO
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCPO:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
PUSHH:	DEC	DI
	DEC	DI
	MOV	[DI],BX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ANI:	AND	AL,[SI]
	LAHF
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RST4:	DEC	DI
	DEC	DI
	MOV	[DI],SI
	MOV	SI,40Q
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RPE:	SAHF				;GET FLAGS
	JNP	NRPE
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRPE:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
PCHL:	MOV	SI,BX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPPE:	SAHF
	JNP	NJPPE
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPPE:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XCHD:	XCHG	BX,DX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CPE:	SAHF
	JNP	NCPE
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCPE:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
XRI:	XOR	AL,[SI]
	LAHF
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RST5:	DEC	DI
	DEC	DI
	MOV	[DI],SI
	MOV	SI,50Q
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RP:	SAHF				;GET FLAGS
	JS	NRP
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRP:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
POPAF:	MOV	AX,[DI]
	INC	DI
	INC	DI
	XCHG	AL,AH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPP:	SAHF
	JS	NJPP
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPP:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CP:	SAHF
	JS	NCP
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCP:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
PUSHAF:	DEC	DI
	DEC	DI
	XCHG	AL,AH			;ACC. IS HI BYTE, FLAGS ARE LOW
	MOV	[DI],AX
	XCHG	AL,AH
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
ORI:	OR	AL,[SI]
	LAHF
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RST6:	DEC	DI
	DEC	DI
	MOV	[DI],SI
	MOV	SI,60Q
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RM:	SAHF				;GET FLAGS
	JNS	NRM
	MOV	SI,[DI]			;GET RETURN ADDRESS
	INC	DI
	INC	DI
NRM:	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
SPHL:	MOV	DI,BX
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
JPM:	SAHF
	JNS	NJPM
	MOV	SI,[SI]			;GET NEW PC ADDRESS
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NJPM:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CM:	SAHF
	JNS	NCM
	MOV	BP,[SI]			;GET ROUTINE ADDR
	DEC	DI
	DEC	DI			;DECREMENT STACK
	INC	SI
	INC	SI			;POINT TO CODE AFTER CALL
	MOV	[DI],SI			;SAVE RET. ADDR
	MOV	SI,BP			;SET "PC"
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
NCM:	INC	SI			;SKIP ADDRESS
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
CPI:	CMP	AL,[SI]
	LAHF
	INC	SI
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]
RST7:	DEC	DI
	DEC	DI
	MOV	[DI],SI
	MOV	SI,70Q
	MOV	BP,AX
	LODSB
	XOR	AH,AH
	SHL	AX,1
	XCHG	AX,BP
	JMP	Word Ptr [BP]

;	BDOS CALL PROCESSOR

CBDOS1:	MOV	CH,0			; Get and verify request code
	CMP	CX,41
	JLE	CODEOK
	JMP	PGMABT			; Abort if bad code
CODEOK:
	SHL	CX,1
	MOV	BX,Offset JMPTBL
	ADD	BX,CX
	JMP	Word Ptr CS:[BX]	; Enter code processor
;
;	CONTROL-C INTERRUPT HANDLER
;
CTLC_PROCESS:
	IRET				; DO NOTHING!
	SUBTTL	System Call Processor Jump Table
	PAGE
;
;	CP/M System call processor jump table
;	
;	Note: entries 41-42 are special:
;
;	41 - Process abort from CP/M program - eg: illegal BIOS access
;
JMPTBL:
	DW	TERM		; 0 - PGM TERMINATE
	DW	BCONIN		; 1 - CONSOLE INPUT
	DW	BCONOUT		; 2 - CONSOLE OUTPUT
	DW	BRDRIN		; 3 - READER INPUT
	DW	BPCHOUT		; 4 - PUNCH OUTPUT
	DW	BLSTOUT		; 5 - LIST OUTPUT
	DW	BDIRCON		; 6 - DIRET CONSOLE I/O
	DW	GETIOB		; 7 - GET I/O BYTE
	DW	SETIOB		; 8 - SET I/O BYTE
	DW	PRINT		; 9 - PRINT STRING
	DW	READ		; 10 - READ BUFFER
	DW	BCONST		; 11 - GET CON STAT
	DW	GETVER		; 12 - GET VERSION
	DW	RESDSK		; 13 - RESET DISK SYSTEM
	DW	SELDSK		; 14 - SELECT DISK
	DW	OPNFIL		; 15 - OPEN FILE
	DW	CLSFIL		; 16 - CLOSE FILE
	DW	SRCHF		; 17 - SEARCH FOR FIRST
	DW	SRCHN		; 18 - SEARCH FOR NEXT
	DW	DELFIL		; 19 - DELETE FILE
	DW	REDSEQ		; 20 - READ SEQUENTIAL
	DW	WRTSEQ		; 21 - WRITE SEQUENTIAL
	DW	MAKFIL		; 22 - MAKE FILE
	DW	RENFIL		; 23 - RENAME FILE
	DW	RETVCT		; 24 - RETURN LOGIN VECTOR
	DW	RETDSK		; 25 - RETURN CURRENT DRIVE
	DW	SETADR		; 26 - SET DMA ADDR
	DW	GETADR		; 27 - GET ADDR (ALLOC)
	DW	WRTPRT		; 28 - WRITE PROTECT DSK
	DW	GETRO		; 29 - GET R/O VECTOR
	DW	SETFIL		; 30 - SET FILE ATTRIBUTES
	DW	GETAD		; 31 - GET DISK PARMS ADDR
	DW	SETUSR		; 32 - SET USER CODE
	DW	REDRND		; 33 - READ RANDOM
	DW	WRTRND		; 34 - WRITE RANDOM
	DW	FILSIZ		; 35 - COMPUTE FILE SIZE
	DW	SETRND		; 36 - SET RANDOM REC
	DW	RESTDR		; 37 - RESET DRIVE
	DW	PGMABT		; 38 - ILLEGAL
	DW	PGMABT		; 39 - ILLEGAL
	DW	WRZF		; 40 - WRITE RND/ZERO FILL
	DW	PGMABT		; 41 - ABORT CODE
	SUBTTL 	System Call Processors
	PAGE
;
;	Program Terminate
;
TERM:
	MOV	SP,400H			; RESET STACK
	PUSH	DS
	POP	ES			; PUT ES IN CP/M SEGMENT
	PUSH	CS
	POP	DS			; ENSURE DS IS HERE
	CMP	Byte Ptr CS:CMDFLAG,0	; CMD.SYS IN RESIDENCE?
	JZ	TERM1			; NO
	CMP	Byte Ptr ES:0FFFFH,0	; ABORT CMD.SYS?
	JNZ	TERM1			; YES
	PUSH	CS
	POP	ES			; ELSE, PUT ES HERE
	MOV	DX,Offset CMDFCB	; POINT TO CMD FCB
	MOV	DI,Offset CMDFCB+12
	MOV	CX,30
	MOV	AL,0
	REP	STOSB			; CLEAR END OF FCB
	JMP	GETCMD			; AND START OVER
TERM1:
	CMP	Byte Ptr CS:OUTOPN,0	; WAS CPM.OUT OPEN?
	JE	QUIT			; NO
	MOV	DX,Offset OUTDTA
	MOV	AH,1AH			; Set DTA to proper buffer address
	INT	21H
	MOV	BX,OUTPTR
	MOV	OUTDTA[BX],1AH		; Put EOF in buffer
	MOV	DX,Offset OUTFCB
	MOV	AH,15H			; Write final record
	INT	21H
	MOV	AH,16			; Close file
	INT	21H
QUIT:
	INT	20H			; Exit to MS-DOS
;
;	Write protect disk is a no-op
;
WRTPRT:
	RET
;
;	Get R/O vector returns 0
;
GETRO:
	XOR	BX,BX
	XOR	AL,AL
	XOR	CH,CH
	RET
;
;	Set file attributes just returns a 0 return code
;
SETFIL:
	XOR	AL,AL
	XOR	BL,BL
	RET
;
;	Set user is a no-op; Get user returns 0
;
SETUSR:
	CMP	AL,0FFH
	JNE	SETUSR1
	XOR	AL,AL
	XOR	BL,BL
SETUSR1:
	RET
;
;	Get allocation vector address
;
GETADR:
	PUSH	DS
	MOV	AH,1BH
	INT	21H			; GET ALLOCATION TABLE ADDRESS
	MOV	AH,0
	PUSH	DX			; SAVE NO. OF BLOCKS
	XCHG	CX,DX			; PUT BLOCKS IN CX, BYTES IN DX
	XOR	AX,AX			; CLEAR FREE COUNTER
	MOV	SI,2			; START WITH FAT ENTRY 2
SLOOP:	MOV	DI,SI			; PUT ENTRY NO. IN DI
	SHR	DI,1			; DIVIDE BY 2
	ADD	DI,SI			; CALCULATE FAT OFFSET
	MOV	DI,[BX+DI]		; GET ENTRY
	TEST	SI,1			; ODD ENTRY NO.?
	JZ	SIZE1			; NO, EVEN
	SHR	DI,1			; ELSE, MOVE DOWN 4 BITS
	SHR	DI,1
	SHR	DI,1
	SHR	DI,1
SIZE1:	AND	DI,0FFFH		; ISOLATE 12 BITS
	JNZ	SIZE2			; NOT AN EMPTY ENTRY
	INC	AX			; COUNT EMPTY ENTRY
SIZE2:	INC	SI			; DO NEXT FAT ENTRY
	LOOP	SLOOP			; UNTIL DONE
	POP	DX			; GET NO. OF BLOCKS
	POP	DS
	PUSH	AX			; SAVE FREE SPACE
	PUSH	DX			; SAVE ALLOCATED USE
	MOV	AH,48
	INT	21H			; GET VERSION NO.
	CMP	AL,2			; 2 OR MORE?
	POP	DX
	POP	AX
	JB	OLDVER			; OLD VERSION
	MOV	AH,54
	XOR	DL,DL
	INT	21H			; ELSE, GET FREE SPACE
	MOV	AX,BX			; IN AX
OLDVER:	SUB	DX,AX			; COMPUTE ALLOCATED USE
	MOV	DI,Offset 0FE20H	; PUT TABLE HERE
	CMP	AX,8			; AT LEAST 8 BITS FREE?
	JG	GETM8			; MORE THAN 8
	MOV	AH,AL			; PUT FREE BYTES IN AH
	JMP	SHORT GETUS
GETM8:
	MOV	CX,8
	PUSH	DX
	MOV	DX,0
	DIV	CX			; ELSE, CALCULATE BYTES FOR TABLE
	MOV	CX,AX
	MOV	AL,0
	REP	STOSB			; STORE EMPTY BYTES
	MOV	AH,DL			; GET REMAINDER OF DIVISION
	POP	DX
GETUS:
	MOV	AL,0FFH			; GET A FULL BYTE
	MOV	CL,AH			; GET REMAINING BITS
	SHR	AL,CL			; SET UP AL
	STOSB				; PUT IT IN TABLE
	MOV	AX,DX			; PUT USED BLOCKS IN AX
	MOV	DX,0
	MOV	CX,8
	DIV	CX			; CALCULATE BYTES FOR TABLE
	MOV	CX,AX			; RESULT TO CX
	INC	CX			; ADD ONE FOR GOOD MEASURE
	MOV	AL,0FFH
	REP	STOSB			; PUT BITS IN TABLE
	MOV	BX,0FE20H		; RETURN TABLE ADDRESS
	MOV	CH,BH
	MOV	AL,BL
	RET
;
;	Get disk parameters
;
GETAD:
	PUSH	DS
	MOV	AH,27
	INT	21H			; GET ALLOCATION ADDRESS
	POP	DS
;	SUB	DX,2			; SUB 2 RES. ENTRIES
	MOV	Word Ptr ES:0FE15H,DX	; PUT BLOCK CNT. IN TABLE
	MOV	AH,0
	MUL	CX			; COMPUTE BLOCK SIZE
	CMP	AX,1024			; 1K BLOCKS?
	JG	LGBLK			; NO, GREATER
	MOV	Byte Ptr ES:0FE12H,3	; ELSE SET BLOCK SHIFT
	MOV	Byte Ptr ES:0FE13H,7	; AND MASK FOR 1K BLOCKS
	JMP	SHORT GETADX		; AND EXIT
LGBLK:	MOV	Byte Ptr ES:0FE12H,4	; SET BLOCK SHIFT
	MOV	Byte Ptr ES:0FE13H,15	; AND MASK FOR 2K BLOCKS
GETADX:	MOV	BX,0FE10H		; RETURN DISK PARM ADDR
	MOV	CH,BH
	MOV	AL,BL
	RET
;
;	Illegal system call abort processor
;
PGMABT:
	PUSH	CX
	MOV	DX,Offset ABTMSG
	MOV	AH,9
	INT	21H
	POP	CX
	MOV	BL,CL
	CMP	BL,41
	JNZ	NOTABT			; NOT BIOS ABORT
	MOV	DX,Offset ABTMS1
	MOV	AH,9
	INT	21H			; ILLEGAL BIOS CALL
	JMP	SHORT ABORT85
NOTABT:
	MOV	BH,0
	CALL	DECOUT
ABORT85:
	MOV	CL,0
	JMP	CBDOS1			; WARM BOOT
;
;	BDOS CONSOLE FUNCTIONS
;
BCONIN:
	CALL	CONECH
	MOV	BL,AL
	RET
BCONOUT:
	MOV	CL,DL
	CALL	CONOUT
	RET
BRDRIN:
	CALL	RDRIN
	MOV	BL,AL
	RET
BPCHOUT:
	MOV	CL,DL
	CALL	PCHOUT
	RET
BLSTOUT:
	MOV	CL,DL
	CALL	LSTOUT
	RET
BDIRCON:
	MOV	CL,DL
	CMP	CL,0FFH			; INPUT?
	JNZ	BDIROUT			; NO
	CALL	CONSTF			; CHECK STATUS
	CMP	AL,0			; NO CHARACTER?
	JZ	BDIRIN			; NO, RETURN
	CALL	CONINF			; ELSE, GET CHARACTER
BDIRIN:
	MOV	BL,AL
	RET
BDIROUT:
	CALL	CONOUTF			; OUTPUT CHARACTER
	RET
BCONST:
	CALL	CONSTF
	MOV	BL,AL
	RET
;
;	Get/Set IOBYTE function
;
GETIOB:
	MOV	AL,Byte Ptr IOBYTE
	MOV	BL,AL
	RET
SETIOB:
	MOV	Byte Ptr IOBYTEL,AL
	RET
;
;	Print string Function
;
PRINT:
	MOV	BX,DX			; GET STRING ADDR
PRINT1:
	MOV	CL,M
	CMP	CL,'$'			; END?
	JZ	PRINTX			; IF SO, LEAVE
	INC	BX
	PUSH	BX
	CALL	TABOUT			; PRINT CHARACTER
	POP	BX
	JMP	PRINT1
PRINTX:
	RET
;
;	Read Console Buffer function
;
READ:
	MOV	AL,Byte Ptr CS:COLUMN
	MOV	Byte Ptr CS:STRTCOL,AL	; SAVE STARTING COLUMN NO.
	MOV	BX,DX
	MOV	CL,M			; CL = MAX LENGTH
	INC	BX			; SKIP TO USER'S COUNT
	PUSH	BX
	MOV	CH,0			; CH = CURRENT LENGTH
READNX:
	PUSH	CX
	PUSH	BX			; SAVE BUFFER, COUNTERS
READN0:
	CALL	CONIN			; GET A CHARACTER
	POP	BX
	POP	CX			; GET BUFFER, COUNTERS
	CMP	AL,0DH			; CR?
	JZ	GOTEND			; YES, END OF INPUT
	CMP	AL,0AH			; LINE FEED?
	JNZ	NOTEND
GOTEND:
	JMP	READEN			; ELSE, END
NOTEND:
	CMP	AL,8			; BACK SPACE?
	JZ	BKSP			; YES
	CMP	AL,7FH			; RUBOUT?
	JNZ	NOTRUB			; NO
BKSP:
	CMP	CH,0			; NO CHARACTERS?
	JZ	READNX			; NO, JUST READ
	DEC	CH			; ELSE, REMOVE ONE CHAR
	MOV	AL,Byte Ptr CS:COLUMN
	MOV	Byte Ptr CS:COMPCOL,AL	; MARK LENGTH COMPUTING
	JMP	LINELEN			; BACK UP
NOTRUB:
	CMP	AL,5			; CONTROL-E?
	JNZ	NOTE			; NOPE!
	PUSH	CX
	PUSH	BX
	CALL	CRLF			; ELSE, CRLF
	MOV	Byte Ptr CS:STRTCOL,0	; CLEAR START COLUMN
	JMP	READN0			; GET ANOTHER CHAR
NOTE:
	CMP	AL,'P'-40H		; CONTROL-P?
	JNZ	NOTP			; NO
	NOT	Byte Ptr CS:CTLPFLG	; ELSE, COMPLEMENT CTLP FLAG
	JMP	READNX
NOTP:
	CMP	AL,'X'-40H		; CONTROL-X?
	JNZ	NOTX			; NO
BACKX:
	MOV	AL,Byte Ptr CS:STRTCOL
	CMP	AL,Byte Ptr CS:COLUMN
	JC	BACKX1			; COL > STARTCOL
	POP	DX			; GET ORIGINAL START POSITION
	DEC	DX			; BACK UP TO START
	JMP	READ			; ELSE, START OVER
BACKX1:
	DEC	Byte Ptr CS:COLUMN	; DECREMENT COLUMN NO.
	CALL	BACKUP
	JMP	SHORT BACKX
NOTX:
	CMP	AL,'U'-40H		; CONTROL-U?
	JNZ	NOTU			; NOPE
	CALL	CRLFP			; ELSE, CRLF
	POP	DX			; GET START POS.
	DEC	DX
	JMP	READ			; START OVER
NOTU:
	CMP	AL,'R'-40H		; CONTROL-R?
	JNZ	NOTR
LINELEN:
	PUSH	CX
	CALL	CRLFP
	POP	CX
	POP	BX			; RESTORE VALUE
	PUSH	BX
	PUSH	CX
REP0:
	CMP	CH,0
	JZ	REP1			; COUNT IS ZERO
	INC	BX
	MOV	CL,M			; GET NEXT CHAR
	DEC	CH			; DECREMENT COUNT
	PUSH	CX
	PUSH	BX
	CALL	CTLOUT			; ECHO CHARACTER
	POP	BX
	POP	CX
	JMP	SHORT REP0
REP1:
	PUSH	BX			; SAVE POINTER
	MOV	AL,Byte Ptr CS:COMPCOL
	CMP	AL,0
	JNZ	REP2			; NOT AT BEGINNING
	JMP	READN0
REP2:
	SUB	AL,Byte Ptr CS:COLUMN
	MOV	Byte Ptr CS:COMPCOL,AL	; RESET COMPUTED COLUMN
BACKSP:
	CALL	BACKUP			; BACK UP ONE
	DEC	Byte Ptr CS:COMPCOL
	JNZ	BACKSP			; UNTIL DONE
	JMP	READN0			; GET NEXT CHAR
NOTR:
RDECHO:
	INC	BX
	MOV	M,AL			; PUT IN CHARACTER
	INC	CH			; COUNT IT
RDECH1:
	PUSH	CX
	PUSH	BX			; SAVE POINTERS, COUNTERS
	MOV	CL,AL
	CALL	CTLOUT			; PRINT CHAR
	POP	BX
	POP	CX
	CMP	M,3			; CONTROL-C?
	JNZ	NOTC			; NO
	CMP	CH,1			; FIRST CHAR?
	JNZ	NOTC			; NO
	MOV	CL,0
	JMP	CBDOS1			; ELSE, WARM BOOT
NOTC:
	CMP	CH,CL			; END OF BUFFER?
	JNC	READEN			; IF SO, END
	JMP	READNX			; ELSE, READ NEXT CHAR
READEN:
	POP	BX
	MOV	M,CH			; PUT IN COUNT
	MOV	CL,0DH
	CALL	CONOUT			; PRINT CR
READX:
	RET				; AND EXIT
;
;	Get version function
;
GETVER:
	MOV	BX,0022H		; Fix at CP/M Version 2.2
	MOV	CH,BH
	MOV	AL,BL
	RET
;
;	Reset drive and reset disk call treated the same
;	Do MS-DOS Disk reset call
;
RESTDR:
RESDSK:
	MOV	AH,13
	INT	21H
	MOV	BL,AL
	RET
;
;	Select default disk function
;
SELDSK:
	MOV	AH,14
	INT	21H
	RET
;
;	Open file function
;
OPNFIL:
	MOV	CL,15
FILCOM:
	CALL	SETFCB			; Set up temp FCB
	MOV	AH,CL
	INT	21H			; Do file I/O call
	PUSH	AX			; SAVE ERROR CODE
	CMP	AL,0FFH
	JNE	DORESTOR
	MOV	Byte Ptr CS:NORC,1	; On error - don't calc record count
DORESTOR:
	CALL	RESETFCB		; Restore CP/M FCB
	POP	AX			; GET ERROR CODE
	MOV	BL,AL
	RET
;
;	Close file function
;
CLSFIL:
	MOV	CL,16
	JMP	SHORT FILCOM
;
;	Search for first function
;
SRCHF:
	MOV	Word Ptr CS:SERADR,DX	; SAVE SEARCH ADDR
	MOV	CL,17
SRCHCOM:
	MOV	Byte Ptr CS:NORC,1
	CALL	SETFCB
	MOV	AH,CL
	INT	21H
	CMP	AL,0FFH
	JE	SETA85
	CALL	RESETFCB
	MOV	BX,Word Ptr CS:DTA	; GET DTA ADDRESS
	MOV	AX,Word Ptr ES:29[BX]	; GET FILE SIZE
	MOV	DX,Word Ptr ES:31[BX]
	CMP	DX,0			; FILE SMALLER THAN 64K?
	JNZ	SRCH1			; NO
	CMP	AX,4000H		; SMALLER THAN 16K?
	JNB	SRCH1			; NO
	MOV	DX,AX			; ELSE, PUT SIZE IN DX
	MOV	AX,0			; MARK NO FULL EXTENTS
	JMP	SRCH2			; AND COMPUTE RECORDS
SRCH1:
	MOV	CX,4000H		; GET 16K BYTES
	DIV	CX			; COMPUTE NO. OF EXTENTS
SRCH2:
	MOV	Word Ptr ES:12[BX],AX	; PUT IN NO. OF EXTENTS
	MOV	AX,DX			; GET REMAINING RECORDS
	ADD	AX,127
	AND	AX,0FF80H		; ROUND OFF TO RECORDS
	JZ	SRCH3			; THERE ARE NO RECORDS
	MOV	CL,128
	DIV	CL			; ELSE, CALCULATE NO. THERE IS
SRCH3:
	MOV	ES:15[BX],AL		; PUT IN NO. OF RECORDS
	XOR	AL,AL			; ALWAYS FIRST ENTRY
	MOV	BL,AL
	RET
SETA85:
	PUSH	AX
	CALL	RESETFCB
	POP	AX
	MOV	BL,AL
	RET
;
;	Search for next function 
;
SRCHN:
	MOV	DX,Word Ptr CS:SERADR	; GET SEARCH FCB ADDR
	MOV	CL,18
	CALL	SRCHCOM
	RET
;
;	Delete file function
;
DELFIL:
	CALL	SETFCB			; SET UP FCB
	MOV	AH,19
	INT	21H			; DELETE THE FILE
	PUSH	AX			; SAVE RESULT
	MOV	Byte Ptr CS:NORC,1	; DON'T CALCULATE RECORD COUNT
	CALL	RESETFCB		; RESTORE CP/M FCB
	POP	AX
	MOV	BL,AL
	RET
;
;	Read sequential function
;
REDSEQ:
	CALL	SETFCB
	MOV	AH,20
	INT	21H
	CMP	AL,3			; Return code 3 --> 0
	JNE	SETA85
	MOV	AL,0
	JMP	SETA85
;
;	Write sequential function
;
WRTSEQ:
	MOV	CL,21
	JMP	FILCOM
;
;	Create file function
;
MAKFIL:
	MOV	CL,22
	JMP	FILCOM
;
;	Rename file function
;
RENFIL:
	MOV	Byte Ptr CS:NORC,1
	MOV	CL,23
	JMP	FILCOM
;
;	Return disk vector function
;
RETVCT:
	MOV	BX,3H			; 2 DRIVES PRESENT
	MOV	CH,BH
	MOV	AL,BL
	RET
;
;	Return default drive id finction
;
RETDSK:
	MOV	AH,19H
	INT	21H
	MOV	BL,AL
	MOV	Byte Ptr DEFDSKL,AL	; ENSURE CP/M KNOWS CUR. DSK.
	RET
;
;	Set DMA Address function
;
SETADR:
	MOV	CS:DTA,DX		; SAVE DMA ADDRESS
	MOV	AH,1AH
	INT	21H
	RET
;
;	Read random function
;
REDRND:
	MOV	Byte Ptr CS:RNDFLG,1	; Random FCB size is 36 bytes
	MOV	CL,21H
	JMP	FILCOM
;
;	Write random and Write random with zero fill are the
;	same for now
;
WRTRND:
WRZF:
	MOV	Byte Ptr CS:RNDFLG,1
	MOV	CL,22H
	JMP	FILCOM
;
;	Compute file size function
;
FILSIZ:
	MOV	Byte Ptr CS:RNDFLG,1
	MOV	CL,23H
	JMP	FILCOM
;
;	Set random record function
;
SETRND:
	MOV	Byte Ptr CS:RNDFLG,1
	MOV	CL,24H
	JMP	FILCOM
;
	SUBTTL	Subroutines
	PAGE
;
;	BDOS-STYLE CONSOLE HANDLERS
;
CONIN:
	MOV	AL,Byte Ptr CS:KBCHAR
	MOV	Byte Ptr CS:KBCHAR,0
	CMP	AL,0
	JNZ	CONIN1			; HAVE A PREVIOUS CHARACTER
	CALL	CONINF			; ELSE, GET ONE
CONIN1:
	RET
;
CONECH:
	CALL	CONIN			; GET A CHARACTER
	CALL	ECHOC			; CHECK FOR ECHO
	JNC	CONECH1
	RET
CONECH1:
	PUSH	AX
	MOV	CL,AL
	CALL	TABOUT
	POP	AX
	RET
;
ECHOC:
	CMP	AL,0DH			; CR?
	JZ	ECHOX
	CMP	AL,0AH
	JZ	ECHOX
	CMP	AL,9			; TAB?
	JZ	ECHOX
	CMP	AL,8			; BACK SPACE?
	JZ	ECHOX
	CMP	AL,' '			; LESS THAN SPACE?
ECHOX:
	RET
;
CONBRK:
	CMP	Byte Ptr CS:KBCHAR,0
	JNZ	CONB1			; ACTIVE CHARACTER PRESENT
	CALL	CONSTF			; CHECK STATUS
	AND	AL,1
	JZ	CONBRKX1		; NO CHAR, EXIT
	CALL	CONINF			; GET CHAR
	CMP	AL,'S'-40H		; CONTROL-S?
	JNZ	CONB0			; NO
	CALL	CONINF			; ELSE, READ NEXT CHAR
	CMP	AL,'C'-40H		; CONTROL-C?
	JNZ	CONBRKX
	MOV	CL,0
	JMP	CBDOS1			; ELSE, WARM BOOT
CONBRKX:
	XOR	AL,AL			; CLEAR AL
CONBRKX1:
	RET
CONB0:
	MOV	Byte Ptr CS:KBCHAR,AL	; SAVE ACTIVE CHARACTER
CONB1:	MOV	AL,1
	RET
;
CONOUT:					; CONSOLE OUTPUT
	CMP	Byte Ptr CS:COMPCOL,0	; COMPUTING COLUMN?
	JNZ	COMPOUT			; YES
	PUSH	CX
	CALL	CONBRK			; ELSE, CHECK FOR SCREEN STOP
	POP	CX
	PUSH	CX
	CALL	CONOUTF			; PRINT THE CHARACTER
	POP	CX
	PUSH	CX
	CMP	Byte Ptr CS:CTLPFLG,0	; TEST FOR CONTROL-P
	JZ	CONOUT1			; NOT SET
	CALL	LSTOUT			; ELSE, PRINT CHAR
CONOUT1:
	POP	CX
COMPOUT:
	MOV	AL,Byte Ptr CS:COLUMN	; GET COLUMN NUMBER
	CMP	CL,7FH			; RUBOUT?
	JZ	CONOUTX			; IF SO, EXIT
	INC	AL			; ELSE, INCREMENT COLUMN
	CMP	CL,' '			; LESS THAN SPACE?
	JNC	CONOUTX			; IF NOT, EXIT
	DEC	AL			; ELSE, DECREMENT COLUMN
	CMP	AL,0			; AT COLUMN ZERO?
	JZ	CONOUTX			; IF SO, EXIT
	CMP	CL,'H'-40H		; BACK SPACE?
	JNZ	NOTBACKSP		; NO
	DEC	AL			; ELSE, DECREMENT COLUMN NUMBER
CONOUTX:
	MOV	Byte Ptr CS:COLUMN,AL	; REPLACE COLUMN NO.
	RET
NOTBACKSP:
	CMP	CL,0AH			; LF?
	JNZ	CONOUTX			; NO
	MOV	AL,0			; ELSE, RESET COLUMN
	JMP	SHORT CONOUTX
;
CTLOUT:
	MOV	AL,CL
	CALL	ECHOC			; CHECK FOR ECHO
	JNC	TABOUT			; SKIP IF GRAPHIC, TAB, CR, LF, CTLH
	PUSH	AX
	MOV	CL,'^'
	CALL	CONOUT			; PRINT "^"
	POP	AX
	OR	AL,40H			; MAKE CHARACTER PRINTABLE
	MOV	CL,AL
;
TABOUT:
	CMP	CL,9			; TAB?
	JNZ	TAB1			; NO, USE CONOUT
TAB0:
	MOV	CL,' '
	CALL	CONOUT			; ELSE, PRINT SPACES
	MOV	AL,Byte Ptr CS:COLUMN
	AND	AL,111B
	JNZ	TAB0			; UNTIL TAB STOP
	RET
TAB1:
	CALL	CONOUT
	RET
;
BACKUP:
	MOV	CL,8
	CALL	CONOUTF			; BACK UP
	MOV	CL,' '
	CALL	CONOUTF			; SPACE
	MOV	CL,8
	CALL	CONOUTF			; BACK UP AGAIN
	RET
;
CRLFP:
	MOV	CL,'#'
	CALL	CONOUT			; PRINT "#"
	CALL	CRLF
CRLFP0:
	MOV	AL,Byte Ptr CS:COLUMN
	CMP	AL,Byte Ptr CS:STRTCOL	; AT START?
	JNC	CRLFPX			; IF SO, EXIT
	MOV	CL,' '
	CALL	CONOUT			; ELSE, PRINT SPACES
	JMP	CRLFP0
CRLFPX:
	RET
;
CRLF:
	MOV	CL,0DH
	CALL	CONOUT
	MOV	CL,0AH
	CALL	CONOUT
	RET
;
;	Get console status function
;
CONSTF:
	MOV	BL,ES:IOBYTE		; Decode IOBYTE
	MOV	BH,0
	SHL	BX,1
	AND	BX,6
	ADD	BX,Offset STTBL
	JMP	Word Ptr CS:[BX]
STTBL:
	DW	AUXST		; 0 - AUX
	DW	CONST		; 1 - KBD
	DW	INST		; 2 - IN
	DW	CONST		; 3 - KBD
;
CONST:					; Check for KBD character present
	CMP	Byte Ptr CS:STATCHR,0	; USED LAST CHARACTER?
	JNZ	CONST0			; NO, SAY ONE'S AVAILABLE
	MOV	AH,6			; USE FUNCTION 6 TO AVOID CONTROL-C
	MOV	DL,0FFH
	INT	21H
	MOV	Byte Ptr CS:STATCHR,AL	; STORE CHARACTER
	CMP	AL,0			; CHARACTER THERE?
	JZ	CONST1			; YES, EXIT
CONST0:
	MOV	AL,0FFH			; SIGNAL CHARACTER THERE
CONST1:
	RET
;
INST:					; Character always present in file
	MOV	AL,0FFH
	RET
;
AUXST:					; Check for character at AUX port
;	MOV	AH,CHR_LOOK
;	CALL 	BIOS_AUXFUNC
;	JC	NOCHR
	MOV	AL,0FFH			; ALWAYS READY
	RET
;NOCHR:
;	MOV	AL,0
;	RET
;
;	Console input function
;
CONINF:
	MOV	BL,ES:IOBYTE		; Decode IOBYTE
	MOV	BH,0
	SHL	BX,1
	AND	BX,6
	ADD	BX,Offset CONITBL
	JMP	Word Ptr CS:[BX]
CONITBL:
	DW	AUXI		; 0 - AUX
	DW	CONI		; 1 - KBD
	DW	INI		; 2 - IN
	DW	CONI		; 3 - KBD
;
INI:					; Get character from CPM.IN file
	CALL	GETCHR
	RET
;
CONI:					; Get character from Keyboard
	MOV	AL,Byte Ptr CS:STATCHR	; GET CHARACTER FROM STATUS CHECK
	CMP	AL,0			; ANYTHING?
	JZ	CONI1			; NO, GET ONE NOW
	MOV	Byte Ptr CS:STATCHR,0	; ELSE, CLEAR STATUS CHARACTER
	RET				; AND RETURN
CONI1:
	MOV	AH,7
	INT	21H
	RET
AUXI:
	MOV	AH,3			; Get character from AUX port
	INT	21H
	RET
;
;	Console output function
;
CONOUTF:
	MOV	DL,CL
	MOV	BL,ES:IOBYTE		; Decode IOBYTE
	MOV	BH,0
	SHL	BX,1
	AND	BX,6
	ADD	BX,Offset CONOTBL
	JMP	Word Ptr CS:[BX]
CONOTBL:
	DW	AUXO		; 0 - AUX
	DW	CONO		; 1 - CRT
	DW	LSTOUT		; 2 - LST (LOGICAL DEV.)
	DW	OUTO		; 3 - OUT,CRT
;
OUTO1:					; Send character to file CPM.OUT
	CALL	PUTCHR
	RET
;
AUXO:					; Send character to AUX
	MOV	AH,4
COMO:
	INT	21H
	RET
;
OUTO:					; Send character to CPM.OUT then CRT
	CALL	PUTCHR
;
CONO:					; Send character to CRT
	MOV	AH,6
	JMP	COMO
PRTO:					; Sent character to printer
	MOV	AH,5
	JMP	COMO
;
;	Reader input function
;
RDRIN:
	MOV	BL,ES:IOBYTE		; Decode IOBYTE
	MOV	BH,0
	SHR 	BX,1
	AND	BX,6
	ADD	BX,Offset RDRTBL
	JMP	Word Ptr CS:[BX]
RDRTBL:
	DW	AUXI		; 0 - AUX
	DW	CONI		; 1 - KBD
	DW	AUXI		; 2 - AUX
	DW	INI		; 3 - IN
;
;	Punch output function
;
PCHOUT:
	MOV	DL,CL
	MOV	BL,ES:IOBYTE		; Decode IOBYTE
	MOV	BH,0
	MOV	CL,3
	SHR	BX,CL
	AND	BX,6
	ADD	BX,Offset PCHTBL
	JMP	Word Ptr CS:[BX]
PCHTBL:
	DW	AUXO		; 0 - AUX
	DW	CONO		; 1 - CRT
	DW	PRTO		; 2 - PRT
	DW	OUTO1		; 3 - OUT
;
;	Printer Output function
;
LSTOUT:
	MOV	DL,CL
	MOV	BL,ES:IOBYTE		; Decode IOBYTE
	MOV	BH,0
	MOV	CL,5
	SHR	BX,CL
	AND	BX,6
	ADD	BX,Offset LSTTBL
	JMP	Word Ptr CS:[BX]
LSTTBL:
	DW	AUXO		; 0 - AUX
	DW	CONO		; 1 - CRT
	DW	PRTO		; 2 - PRT
	DW	OUTO1		; 3 - OUT
;
;	SETFCB - Move CP/M FCB to temp and convert to MS-DOS format
;
SETFCB	PROC	NEAR
	PUSH	CX
	MOV	SI,DX			; GET FCB ADDRESS
	MOV	CS:FCBADR,DX		; SAVE IT
	MOV	DI,FCBTMP
	MOV	BX,DI
	MOV	DX,DI
	MOV	CX,36
	REP	MOVSB
	MOV	Byte Ptr 15[BX],0	; RC-->0 (rec siz Hi Byte)
	MOV	Byte Ptr 36[BX],0	; High order random rec #=0
	POP	CX
	RET
SETFCB	ENDP
;
;	RESETFCB - Convert FCB back to CP/M form
;
RESETFCB PROC	NEAR
	MOV	DI,CS:FCBADR
	MOV	SI,FCBTMP
	MOV	CX,33			; Copy 33 bytes unless random
	CMP	Byte Ptr CS:RNDFLG,0
	JE	CPYBAK
	MOV	Byte Ptr CS:RNDFLG,0
	MOV	CX,36			;  Then copy 36 bytes
CPYBAK:
	REP	MOVSB
	CMP	Byte Ptr CS:NORC,0	; No RC calculation if NORC set
	JE	CALCRC
	MOV	Byte Ptr CS:NORC,0
	JMP	SHORT RSETDS
CALCRC:					; Calculate RC from EX and file size
	MOV	DI,CS:FCBADR
	MOV	BX,FCBTMP
	MOV	AX,16[BX]
	MOV	DX,18[BX]
	MOV	CX,128
	DIV	CX
	CMP	DX,0
	JE	NOXTRA
	INC	AX
NOXTRA:
	MOV	CL,128
	DIV	CL
	CMP	AL,12[BX]
	JE	SETRC
	MOV	AH,80H
SETRC:
	MOV	15[DI],AH		; Set RC in CP/M FCB
RSETDS:
	RET
RESETFCB	ENDP
;
;	GETCHR - Extract a character from CPM.IN
;
GETCHR	PROC	NEAR
	PUSH	CS
	POP	DS			; PUT DS HERE
	CMP	Byte Ptr INOPN,0	; Open file on first access
	JNE	OPENIN
	MOV	INOPN,1
	MOV	DX,Offset INFCB
	MOV	AH,15
	INT	21H
	CMP	AL,0FFH
	JE	INFILER			; Abort program on open error
OPENIN:
	MOV	BX,INPTR		; Buffer pointer
	CMP	BX,80H
	JE	NEWREC			; If = 80H then must read nxt rec
GTNXTCHR:
	MOV	AL,INDTA[BX]		; Get next character from buffer
	INC	INPTR
	CMP	AL,1AH			; EOF?
	JNZ	GETNXT1			; NO
	MOV	AL,ES:IOBYTE		; ELSE, GET IOBYTE
	AND	AL,11111100B		; REMOVE INPUT BITS
	OR	AL,1			; SET CONSOLE INPUT
	MOV	ES:IOBYTE,AL
	POP	AX			; CLEAN UP STACK
	JMP	RESABT			; AND ABORT
GETNXT1:PUSH	ES
	POP	DS
	RET
NEWREC:					; Read a record from disk
	MOV	DX,Offset INDTA
	MOV	AH,1AH			; Change DTA to CPM.IN buffer
	INT	21H
	MOV	DX,Offset INFCB
	MOV	AH,14H			; Read a record
	INT	21H
	OR	AL,AL			; TEST FOR EOF
	JZ	GOTNEWREC
	MOV	Byte Ptr INDTA,1AH	; MARK EOF
	JMP	SHORT GOTNEWREC
INFILER:				; Abort program on file I/O error
	MOV	DX,Offset INERMSG
	MOV	AH,9
	INT	21H
	POP	AX			; Clean up stack
	JMP	RESABT			; Go abort 8085
GOTNEWREC:
	MOV	Word Ptr INPTR,0	; Got a new record - clear buffer pointer
	MOV	DX,DTA
	PUSH	ES
	POP	DS
	MOV	AH,1AH			; Restore Program's DTA
	INT	21H
	PUSH	CS
	POP	DS
	MOV	BX,INPTR
	JMP	GTNXTCHR
RESABT:	PUSH	ES
	POP	DS
	JMP	ABORT85
GETCHR	ENDP
;
;	PUTCHR - Put a character in CPM.OUT output buffer
;
PUTCHR	PROC	NEAR
	PUSH	BX
	PUSH	DX
	PUSH	CS
	POP	DS			; PUT DS HERE
	CMP	Byte Ptr OUTOPN,0	; Open file on first access
	JNE	OUTOPENED
	MOV	Byte Ptr OUTOPN,1
	MOV	DX,Offset OUTFCB
	MOV	AH,15
	INT	21H
	CMP	AL,0FFH
	JNE	RESTRDX
	MOV	AH,16H			; Create file if none exists
	INT	21H
	CMP	AL,0FFH
	JE	OUTFILER		; If no room - abort program
RESTRDX:
	POP	DX
	PUSH	DX
OUTOPENED:
	MOV	BX,OUTPTR		; Buffer pointer
	MOV	OUTDTA[BX],DL		; Put character in buffer
	INC	BX
	CMP	BX,80H			; When buffer full - 
	JE	PUTREC			;  write record to disk
	MOV	OUTPTR,BX
	PUSH	ES
	POP	DS
	POP	DX
	POP	BX
	RET
PUTREC:					; Write record to disk
	MOV	DX,Offset OUTDTA
	MOV	AH,1AH			; Change DTA to CPM.OUT buffer
	INT	21H
	MOV	DX,Offset OUTFCB
	MOV	AH,15H	; Write to disk
	INT	21H
	CMP	AL,0
	JNE	OUTFILER		; Abort program on disk full
	MOV	Word Ptr OUTPTR,0
	MOV	DX,DTA
	PUSH	ES
	POP	DS
	MOV	AH,1AH			; Reset DTA to programs address
	INT	21H
	POP	DX			; Restore registers
	POP	BX
	RET
OUTFILER:
	MOV	DX,Offset OUTERMSG
	MOV	AH,9			; CPM.OUT file error
	INT	21H
	POP	AX
	POP	AX			; Clean up stack
	POP	AX
	PUSH	ES
	POP	DS
	JMP	ABORT85
PUTCHR	ENDP

;	DECOUT - Print BX in decimal

DECOUT	PROC	NEAR
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	ADD	DL,'0'			;ADD ASCII BIAS
	MOV	AH,2
	INT	21H			;PRINT DIGIT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	RET
DECOUT	ENDP
;
	DB	8 DUP (0)
CMDFCB	DB	0
	DB	'COMD    SYS'
	DB	30 DUP (0)
INFCB	DB	0
	DB	'CPM     IN '
	DB	30 DUP (0)
OUTFCB	DB	0
	DB	'CPM     OUT'
	DB	30 DUP (0)
INDTA	DB	128 DUP (?)
OUTDTA	DB	128 DUP (?)
FCBC	DB	50 DUP (0)
;
;	Flags, Pointers, and Data
;
CPMSEG	DW	0
SERADR	DW	0
FCBADR	DW	0
DTA	DW	80H
NORC	DB	0
INOPN	DB	0
OUTOPN	DB	0
INPTR	DW	80H
OUTPTR	DW	0
AXFLG	DB	0
SISV	DW	0
CPMC	DB	'CPM'
RNDFLG	DB	0
CMDFLAG	DB	0
STATCHR	DB	0
COLUMN	DB	0
STRTCOL	DB	0
COMPCOL	DB	0
CTLPFLG	DB	0
KBCHAR	DB	0
LINBUF	DB	80H DUP (0)
;
;	Messages
;
NMMSG	DB	13,10,'ERROR - Not enough memory'
	DB	' for this program.',13,10,'$'
ABTMSG	DB	0DH,0AH
	DB	'ILLEGAL CP/M FUNCTION CALL: $'
ABTMS1	DB	' ILLEGAL BIOS CALL.$'
ERMSG	DB	0DH,0AH
	DB	'NO SUCH CP/M PROGRAM$'
INERMSG	DB	0DH,0AH
	DB	'I/O Error - File CPM.IN'
	DB	0DH,0AH,'$'
OUTERMSG	DB	0DH,0AH
	DB	'I/O Error - File CPM.OUT'
	DB	0DH,0AH,'$'
XMSG	DB	13,10,9
 DB 'CP/EMulator II, Version 1.0.'
 DB '  To use this program, enter'
 DB 13,10,9,'~~~~~~~~~~~~~~~~~~~~~~~~~~~'
 DB 13,10,9
 DB 'A:CPM2[/nn] CPMPROG [parms]'
 DB 13,10,10,9
 DB 'where  CPMPROG  is the name of the CP/M program you want to  run,'
 DB 13,10,9
 DB 'parms are optional parameters supplied to the CP/M  program,  and'
 DB 13,10,9
 DB '/nn is an optional IOBYTE specification.  You may also use'
 DB 13,10,10,9
 DB 'A:CPM2[/nn] *'
 DB 13,10,10,9
 DB 'to run CP/EMulator in the interactive mode.   It will sign on and'
 DB 13,10,9
 DB 'accept normal CP/M commands.  Enter BYE to exit to MS-DOS.'
 DB 13,10,10,9
 DB 'The IOBYTE is a 2 digit hex number that defines I/O devices.  The'
 DB 13,10,9
 DB '8  bits in the IOBYTE specify devices as follows:   0,1 = Console'
 DB 13,10,9
 DB '(CON:);  2,3 = Reader (RDR:);  4,5 = Punch (PUN:);  6,7 = List or'
 DB 13,10,9
 DB 'Printer (LST:).  Possible IOBYTE assignments are:'
 DB 13,10,10,9
 DB 'CON:  0 = AUX, 1 = <KBD/CRT>, 2 = IN/LST, 3 = KBD/OUT-CRT'
 DB 13,10,9
 DB 'RDR:  0 = <AUX>, 1 = KBD, 2 = AUX, 3 = IN'
 DB 13,10,9
 DB 'PUN:  0 = <AUX>, 1 = CRT, 2 = PRN, 3 = OUT     IN and OUT = files'
 DB 13,10,9
 DB 'LST:  0 = AUX, 1 = CRT, 2 = <PRN>, 3 = OUT     CPM.IN, CPM.OUT'
 DB '$'
SGNON	DB	13,10
	DB	'CP/EMulator II, Version 1.0',13,10,'$'
	PAGE
;

DPB	DB	20H,0,4,0FH,0,9BH,0,0FFH,0,0F0H	; DISK PARAMETERS
	DB	0,40H,0,2,0
	DB	0,0F0H				; ALLOCATION TABLE START
;
CPMCOD:               ;;       CPM100 - 8080 CP/M EMULATOR CODE
                      ;;
                      ;;       THIS CODE PROVIDES A SERIAL NO, BDOS ENTRY,
                      ;;       AND A MINIMAL BIOS FOR CP/M PROGRAMS
                      ;
                      ;        ORG     0FE00H
 DB 0C4H,003H,000H    ;SERNO:  DB      0C4H,3,0 ;DUMMY SERIAL NUMBER
 DB 000H,000H,000H    ;        DB      0,0,0   ;(ALLOWS MBASIC TO RUN)
                      ;
                      ;;       THIS CODE PROCESSES BDOS FUNCTIONS
                      ;
 DB 0CFH              ;BDOS:   RST     1       ;CALL BDOS PROCESSOR
 DB 0C9H              ;        RET
                      ;BDOSEND:
                      ;
                      ;;       BIOS VECTORS
                      ;
	DB	256-8 DUP (0)
                      ;        DS      256-(BDOSEND-SERNO)
 DB 0C3H,033H,0FFH    ;BIOS:   JMP     FIN     ;COLD BOOT
 DB 0C3H,033H,0FFH    ;WBOOT:  JMP     FIN
 DB 0C3H,03DH,0FFH    ;        JMP     CONST
 DB 0C3H,042H,0FFH    ;        JMP     CONIN
 DB 0C3H,04EH,0FFH    ;        JMP     CONOUT
 DB 0C3H,054H,0FFH    ;        JMP     LIST
 DB 0C3H,038H,0FFH    ;        JMP     ABT     ;OTHER FUNCTIONS ILLEGAL
 DB 0C3H,038H,0FFH    ;        JMP     ABT
 DB 0C3H,038H,0FFH    ;        JMP     ABT
 DB 0C3H,05AH,0FFH    ;        JMP     SELDSK
 DB 0C3H,038H,0FFH    ;        JMP     ABT
 DB 0C3H,038H,0FFH    ;        JMP     ABT
 DB 0C3H,060H,0FFH    ;        JMP     SETDMA
 DB 0C3H,038H,0FFH    ;        JMP     ABT
 DB 0C3H,038H,0FFH    ;        JMP     ABT
 DB 0C3H,067H,0FFH    ;        JMP     LISTST
 DB 0C3H,038H,0FFH    ;        JMP     ABT
                      ;
                      ;;       BIOS FUNCTIONS
                      ;
 DB 00EH,000H         ;FIN:    MVI     C,0
 DB 0C3H,006H,0FEH    ;        JMP     BDOS
 DB 00EH,029H         ;ABT:    MVI     C,41
 DB 0C3H,006H,0FEH    ;        JMP     BDOS
 DB 00EH,00BH         ;CONST:  MVI     C,11
 DB 0C3H,006H,0FEH    ;        JMP     BDOS
 DB 00EH,006H         ;CONIN:  MVI     C,6
 DB 01EH,0FFH         ;        MVI     E,0FFH
 DB 0CDH,006H,0FEH    ;        CALL    BDOS
 DB 0B7H              ;        ORA     A
 DB 0CAH,042H,0FFH    ;        JZ      CONIN
 DB 0C9H              ;        RET
 DB 059H              ;CONOUT: MOV     E,C
 DB 00EH,06           ;        MVI     C,6
 DB 0C3H,006H,0FEH    ;        JMP     BDOS
 DB 059H              ;LIST:   MOV     E,C
 DB 00EH,05           ;        MVI     C,5
 DB 0C3H,006H,0FEH    ;        JMP     BDOS
 DB 059H              ;SELDSK: MOV     E,C
 DB 00EH,0EH          ;        MVI     C,14
 DB 0C3H,006,0FEH     ;        JMP     BDOS
 DB 042H              ;SETDMA: MOV     B,D
 DB 059H              ;        MOV     E,C
 DB 00EH,1AH          ;        MVI     C,26
 DB 0C3H,006H,0FEH    ;        JMP     BDOS
 DB 0AFH              ;LISTST: XRA     A
 DB 0C9H              ;        RET
CPMCEND:
CODSIZ	EQU	CPMCEND-CPMCOD

;	LOW MEMORY CODE

LOCODE:
  DB  0C3H,03H,0FFH	;	JMP	BIOS	;BIOS TABLE
DEFLTIO	DB	81H				;IOBYTE=81H
	DB	0				;DEFAULT DRIVE=0
  DB  0CFH,6,0FEH	;	RST	1	;RST 1 AND BDOS ADDRESS
;
ENDLOCODE:
LOSIZE	EQU	ENDLOCODE-LOCODE
;
LEND:
CPM2	ENDS
	END	START
                                                                                                            