	PAGE	,132
	TITLE	SEE, A REPLACEMENT FOR "TYPE"
;	SEE - A PROGRAM TO LOOK AT TEXT FILES

;	THIS PROGRAM PROVIDES AN EASY WAY TO LOOK AT
;	TEXT FILES, AND INCLUDES THE ABILITY TO SCROLL
;	FORWARD OR BACKWARD BY LINES OR PAGES, TO SEARCH
;	FOR CHARACTER STRINGS, AND TO PRINT SCREENS OF
;	THE FILE.

;	TO USE THIS PROGRAM, ENTER

;		SEE <PATHNAME>[</SWITCHES>]

;	WHERE <PATHNAME> IS A PATH DESCRIBING THE FILE
;	YOU WANT TO SEE, AND <SWITCHES> ARE OPTIONAL SWITCHES.

;	BY P. SWAYNE, HUG  25-FEB-83  28-MAY-83
;	Z-DOS VERSION  17-FEB-84  01-MAY-84
;	H150 MODS  17-MAY-84
;	VERSION 2.0 14-SEP-88  12-JAN-89
;		IBM SCREEN CONTROL DERIVED FROM PROGRAMS BY BOB METZ

;	DEFINITIONS

FGC	EQU	7			;FOREGROUND COLOR
BGC	EQU	0			;BACKGROUND COLOR
HFGC	EQU	0			;HIGHLIGHT FOREGROUND COLOR
HBGC	EQU	7			;HIGHLIGHT BACKGROUND COLOR

M	EQU	Byte Ptr 0[BX]		;DEFINE MEMORY POINTER
LSTOUT	EQU	5			;PRINTER OUTPUT
DCIO	EQU	6			;DIRECT CONSOLE I/O
DCIN	EQU	7			;DIRECT CONSOLE INPUT
OPENF	EQU	15			;OPEN FILE
CLOSEF	EQU	16			;CLOSE FILE
READF	EQU	20			;READ FILE (SEQUENTIAL)
SETDMA	EQU	26			;SET DMA ADDRESS

ROM	SEGMENT AT 0FE01H		;Z-100 ROM SEGMENT
	ORG	19H
ROMOUT	LABEL	FAR			;DEFINE ROM OUTPUT
ROM	ENDS

BIOS	SEGMENT AT 40H
	ORG	6
CONIN	LABEL	FAR
BIOS	ENDS

SEE	SEGMENT
	ASSUME	CS:SEE,DS:SEE,SS:SEE,ES:SEE
	ORG	0
Z	LABEL	NEAR			;DEFINE ZERO LABEL
	ORG	2
MEMSIZ	LABEL	WORD			;MEMORY SIZE IS HERE
	ORG	5CH
FCB	LABEL	NEAR			;FILE CONTROL BLOCK
	ORG	6CH
FCB2	LABEL	NEAR			;SECOND FILE CONTROL BLOCK
	ORG	80H
ARG	LABEL	BYTE			;ARGUMENT IS HERE
	ORG	100H

;	MAIN PROGRAM

START:	JMP	SHORT BEGIN
DFATTR	DB	(BGC SHL 4)+FGC		;DEFAULT ATTRIBUTE
HIATTR	DB	(HBGC SHL 4)+HFGC	;HIGHLIGHT ATTRIBUTE
BEGIN:	CLD
	MOV	AL,DFATTR
	MOV	ATTR,AL			;SET ATTR
	AND	AL,77H			;REMOVE INTENSITY, ETC.
	MOV	AH,AL			;COPY TO AH
	MOV	CL,4
	SHR	AH,CL			;SHIFT HIGH NIBBLE DOWN
	AND	AL,0FH			;ISOLATE LOW
	MOV	BX,OFFSET COLTBL
	XCHG	AL,AH
	XLAT				;TRANSLATE COLORS TO Z-100 VALUES
	XCHG	AL,AH
	XLAT
	ADD	AX,3030H		;MAKE IT ASCII
	MOV	ZATTR,AX		;SET Z-100 COLORS
	OR	AH,80H			;SET HI BIT ON BACKGROUND
	MOV	WORD PTR ZATTR1,AX	;OTHER Z-100 COLOR PLACE
	MOV	AL,HIATTR
	AND	AL,77H
	MOV	AH,AL			;COPY TO AH
	MOV	CL,4
	SHR	AH,CL			;SHIFT HIGH NIBBLE DOWN
	AND	AL,0FH			;ISOLATE LOW
	XCHG	AL,AH
	XLAT				;TRANSLATE COLORS TO Z-100 VALUES
	XCHG	AL,AH
	XLAT
	ADD	AX,3030H		;MAKE IT ASCII
	OR	AH,80H
	MOV	WORD PTR ZHATTR,AX	;SET Z-100 HIGHLIGHT COLORS
	MOV	AX,(BA.BUFFER-Z+15) SHR 4	;GET END OF PGM.
	MOV	BX,CS			;AND THIS SEGMENT
	ADD	AX,BX			;CALCULATE NEXT SEGMENT
	MOV	BUFSEG,AX		;SAVE IT
	MOV	BX,MEMSIZ		;GET MEMORY SIZE
	SUB	BX,AX			;GET FREE RAM
	TEST	BX,0F000H		;TEST FOR MORE THAN 64K
	JZ	LT64K			;IT'S LESS THAN 64K
	MOV	BX,0FFF0H		;ELSE, USE 0FFF0H
	JMP	SHORT MT64K
LT64K:	MOV	CL,4
	SHL	BX,CL			;CONVERT TO BYTES
MT64K:	MOV	Word Ptr MEMTOP,BX	;SAVE AS MEMORY TOP
	MOV	AX,64			;ASSUME LARGE BUFFER
	CMP	BX,0FFF0H		;IS IT
	JZ	SAVBS			;YES
	XCHG	AX,BX
	MOV	BX,1024
	XOR	DX,DX
	DIV	BX			;ELSE, CONVERT SIZE TO K'S
SAVBS:	MOV	BUFSIZE,AX		;SAVE BUFFER SIZE
	MOV	SI,OFFSET ARG		;POINT TO USER ARGUMENT
	LODSB				;GET COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JZ	NOFILEJ			;NO
	MOV	CL,AL			;COUNT TO CL
	XOR	CH,CH			;TO CX
SOS:	CMP	BYTE PTR [SI],' '	;SPACE
	JNZ	NOTSP			;NO
	INC	SI			;ELSE, SKIP SPACE
	LOOP	SOS
NOFILEJ:JMP	NOFILE
NOTSP:	MOV	DX,SI			;POINT TO ARGUMENT IN DX
	MOV	BX,CX			;COUNT TO BX
	MOV	BYTE PTR [BX+SI],0	;ZERO END OF ARGUMENT
	MOV	DI,SI			;POINT TO ARGUMENT IN DI
	MOV	AL,' '
	PUSH	CX			;SAVE CHARACTER COUNT
	REPNZ	SCASB			;LOOK FOR SPACE
	POP	CX
	JNZ	NBSP			;NO SPACE BEHIND ARGUMENT
	MOV	BYTE PTR -1[DI],0	;ELSE, ZERO OUT SPACE
NBSP:	MOV	DI,SI			;POINT TO ARGUMENT
	MOV	AL,'/'
	REPNZ	SCASB			;LOOK FOR SWITCH
	JNZ	NOSW			;NO SWITCH
	MOV	BYTE PTR -1[DI],0	;ELSE, ZERO OUT SWITCH CHARACTER
GETSW:	MOV	AL,[DI]			;GET SWITCH
	CMP	AL,'8'			;SEE 8-BIT CODES?
	JNZ	NOSW			;NO
	MOV	BYTE PTR STRIP,0FFH	;ELSE, FIX STRIPPER
;NEXTSW:	INC	DI			;POINT TO NEXT SWITCH
;	LOOP	GETSW			;GET IT
NOSW:	MOV	FNAME,DX		;SAVE FILE NAME ADDRESS
	MOV	AX,3D00H		;OPEN FOR READ FUNCTION
	INT	21H			;TRY TO OPEN FILE
	JC	NOOPEN			;CAN'T DO IT
	MOV	HANDLE,AX		;ELSE, SAVE HANDLE
	JMP	READ			;READ FILE
NOOPEN:	CALL	TYPTX
	DB	13,10,'ERROR - Cannot find',' '+80H
	CALL	PFNAM			;PRINT FILE NAME
	CALL	TYPTX
	DB	'.',13,10+80H
	INT	20H			;RETURN TO Z-DOS
NOFILE:	CALL	TYPTX
	DB	13,10,'SEE Version 2.0 by PS:',13,10,10
	DB	'The correct use of this program is',13,10,10
	DB	'  SEE <pathname>[/8]',13,10,10
	DB	'where <pathname> is the path describing the',13,10
	DB	'file you want to SEE, and /8 is an optional',13,10
	DB	'switch to allow viewing 8-bit "extended"',13,10
	DB	'ASCII characters',13,10+80H
	INT	20H			;RETURN TO MS-DOS

READ:	MOV	SP,OFFSET BA.STACK+1	;SET STACK OUT OF DATA AREA
	MOV	AX,40H
	MOV	DS,AX
	MOV	SI,0
	MOV	AL,[SI]			;GET FIRST BIOS RAM BYTE
	PUSH	CS
	POP	DS			;FIX DS
	MOV	CL,1			;ASSUME Z-100
	CMP	AL,0E9H			;Z-100?
	JZ	Z100			;YES
	MOV	CL,0			;IT'S PC
	PUSH	CX
	MOV	AH,15
	INT	10H			;READ DISPLAY TYPE
	MOV	DISPLAY,AL		;SAVE DISPLAY TYPE
	CMP	AL,7			;MONO?
	JNZ	COLOR			;NO, COLOR
	MOV	MEMADR,0B000H		;ELSE, FIX VIDEO MEMORY ADDRESS
	JMP	SHORT MODEOK		;MODE SHOULD BE ALREADY SET
COLOR:	CMP	AL,2			;MODE 2?
	JZ	CKPG			;YES
	CMP	AL,3			;MODE 3
	JNZ	MAKM3			;NO, MAKE IT 3
CKPG:	CMP	BH,0			;PAGE 0?
	JZ	MODEOK			;IF SO, MODE IS OK
MAKM3:	MOV	AX,3			;ELSE, FORCE MODE 3
	INT	10H
MODEOK:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURSOR POS, TYPE
	MOV	CURTYP,CX		;SAVE TYPE
	MOV	AH,1
	MOV	CX,2020H
	INT	10H			;CLEAR CURSOR
	MOV	AH,2
	MOV	DX,24*256
	INT	10H			;PUT CURSOR AT BOTTOM
	POP	CX
Z100:	MOV	Byte Ptr TTYPE,CL	;MARK TERMINAL TYPE
	MOV	BYTE PTR FTFLG,1	;MARK FIRST TIME DONE
	MOV	CX,Word Ptr MEMTOP	;GET MEMORY TOP
	XOR	BX,BX			;READ INTO BUFFER BOTTOM
	CALL	TYPTX
	DB	27,'z'+80H
	CMP	BYTE PTR TTYPE,0	;PC
	JZ	READLP			;YES
	XOR	AX,AX
	MOV	ES,AX			;ELSE, POINT TO INTERRUPT SEGMENT
	MOV	AX,ES:WORD PTR [3FEH]	;GET ROM DATA SEGMENT
	MOV	ROMSEG,AX		;SAVE IT
	MOV	ES,AX			;POINT TO IT
	MOV	AL,ES:BYTE PTR [5]	;GET ROM VERSION
	AND	AL,0F0H			;ISOLATE MAJOR VERSION NO.
	CMP	AL,10H			;VERSION 1?
	JNZ	RNV1			;NO
	MOV	WORD PTR CURADR,28FH	;ELSE, FIX CURSOR ADDRESS
RNV1:	PUSH	CS
	POP	ES			;FIX ES
	CALL	TYPTX
	DB	27,'m'
ZATTR	DW	3137H			;SET COLORS
	DB	27,'E'			;CLEAR SCREEN
	DB	27,'y','?'+80H		;TURN OFF KEY EXPANSION

READLP:	MOV	DS,BUFSEG		;POINT DS TO MEMORY SEGMENT
	CALL	READFIL			;READ THE FILE
	CMP	BX,CS:MEMTOP		;DID WE READ A BUFFER FULL?
	JNZ	READ2			;NO, GOT ALL OF FILE
READ1:	MOV	CS:BYTE PTR NEXTFLG,1	;SET "NEXT" FLAG
READ2:	MOV	CX,128			;SET A COUNTER
	SUB	BX,128			;SUBTRACT 128 FROM ADDR
	JNB	READ3			;FILE BIGGER THAN 128 BYTES
	ADD	BX,128			;ELSE, FIX BX
	MOV	CX,BX			;USE SIZE FOR COUNT
	XOR	BX,BX			;AND START AT BEGINNING
READ3:	MOV	AL,M			;GET A BYTE
	CMP	AL,'Z'-40H		;CONTROL-Z?
	JZ	READ4			;YES, FOUND END OF TEXT
	INC	BX			;INCREMENT POINTER
	LOOP	READ3			;LOOP FOR 128 BYTES
READ4:	MOV	CS:RDEND,BX		;SAVE END OF READING
	MOV	CS:TXTEND,BX		;SAVE END OF TEXT
	CMP	CX,0			;SEARCHED ALL OF END?
	MOV	AL,0
	JNZ	FNDEND			;IF NOT, END FOUND
	CMP	CS:BYTE PTR NEXTFLG,1	;MORE TEXT TO BE READ?
	JNZ	FNDEND			;IF NOT, WE HAVE END
READ5:	DEC	BX			;BACK UP
	JZ	READ6			;NO
	INC	CX			;COUNT THE BACK-UP
	MOV	AL,M			;GET CHARACRER
	AND	AL,CS:STRIP		;STRIP HIGH BIT
	CMP	AL,10			;LINE FEED?
	JNZ	READ5			;NOPE
	DEC	CX			;DON'T COUNT THE LINE FEED
READ6:	INC	BX			;MOVE PAST IT
	MOV	CS:TXTEND,BX		;MARK REAL END OF TEXT
	MOV	AX,CX			;GET END COUNT
FNDEND:	MOV	CS:ENDCNT,AL		;SAVE IT
	MOV	DX,BX			;DX = FILE SIZE
	MOV	AX,CS:LINCNT		;GET LINE COUNT
	MOV	CS:LINSTRT,AX		;UPDATE FIRST LINE
	XOR	CX,CX			;CLEAR A COUNTER
	MOV	BX,CS:TXTSTRT		;POINT TO START OF TEXT
CNTLNS:	MOV	AL,M			;GET A CHARACTER
	AND	AL,CS:STRIP		;STRIP HIGH BIT
	INC	BX			;INCREMENT POINTER
	CMP	AL,10			;LINE FEED?
	JNZ	CNTLN1			;NO
	INC	CX			;COUNT THIS LINE
CNTLN1:	DEC	DX			;DECREMENT SIZE COUNTER
	JNZ	CNTLNS			;LOOP UNTIL DONE
	MOV	BX,CS:LINSTRT		;GET STARTING LINE
	ADD	BX,CX			;ADD LINE COUNT
	MOV	CS:LINCNT,BX		;UPDATE LINE COUNT
	CMP	CX,25			;LESS THAN 25 LINES?
	JNB	FNDLP			;NO, FIND LAST PAGE
	MOV	CS:Word Ptr LASTPG,0	;ELSE, LAST PAGE = BUFFER START
	JMP	SHORT PFN		;PRINT FILE NAME
FNDLP:	MOV	BX,CS:TXTEND		;GET END OF TEXT
	DEC	BX			;SKIP LAST LINE FEED
	MOV	CX,24			;24 LINES/PAGE
FLP:	DEC	BX			;BACK UP ONE CHARACTER
	MOV	AL,M			;GET CHARACTER
	AND	AL,CS:STRIP		;REMOVE HIGH BIT
	CMP	AL,10			;LINE FEED?
	JNZ	FLP			;NO, KEEP LOOKING
	LOOP	FLP			;LOOP FOR 24 LINES
	INC	BX			;MOVE TO FIRST CHAR IN PAGE
	MOV	CS:LASTPG,BX		;SAVE LAST PAGE ADDRESS
PFN:	PUSH	CS
	POP	DS			;FIX DS
	MOV	AL,NEXTFLG
	OR	NRFLG,AL		;SET NEXT/REWIND CONDITION
	CALL	PBMSG			;PRINT BOTTOM MESSAGE
	CALL	TYPTX
	DB	27,'q',27,'Y7',' '+80H
	XOR	BX,BX			;POINT TO TOP OF FILE
	JMP	TOP0			;DISPLAY TOP OF FILE

;	MAIN COMMAND LOOP

CMDLP:	CALL	TYPTX			;CLEAR OLD LINE NO.
	DB	27,'Y8"'
	DB	27,'q     '
	DB	27,'Y8','"'+80H
	MOV	BX,Word Ptr CURLIN	;GET CURRENT LINE NO.
	CALL	DECOUT			;PRINT IT
	CALL	TYPTX
	DB	27,'Y7',' '+80H
CMDLP0:	CALL	SCIN			;GET A CHARACTER
	CMP	AL,13			;CR?
	JNZ	CMDLP1	
	JMP	PLINE			;IF SO, MOVE DOWN ONE LINE
CMDLP1:	CMP	AL,27			;ESCAPE?
	JNZ	CMDLP2			;NO
	JMP	EXIT			;ELSE, EXIT
CMDLP2:	MOV	BX,OFFSET ZCMDTBL	;ASSUME Z-100
	CMP	BYTE PTR TTYPE,0	;PC?
	JNZ	GOTCHAR			;NO
	MOV	AL,AH			;ELSE, USE CHARACTER IN AH
	MOV	BX,OFFSET PCMDTBL	;AND PC TABLE
GOTCHAR:MOV	CL,AL			;ELSE, SAVE CHARACTER IN C
FNDCMD:	MOV	AL,M			;GET A CHARACTER
	OR	AL,AL			;END OF TABLE?
	JZ	BEEP
	CMP	AL,CL			;IS THIS THE ONE ENTERED?
	JZ	EXECUT			;YES, EXECUTE THE COMMAND
	ADD	BX,3			;ELSE, MOVE TO NEXT ENTRY
	JMP	FNDCMD			;TRY AGAIN
BEEP:	MOV	AL,7
	CALL	SCOUT			;BEEP
	JMP	CMDLP
EXECUT:	INC	BX			;BX POINTS TO COMMAND ADDRESS
	MOV	BX,Word Ptr [BX]	;GET COMMAND ADDRESS
	JMP	BX			;EXECUTE THE COMMAND

;	THE COMMANDS
;	GO FORWARD ONE PAGE ON SCREEN

PPAGE:	MOV	DX,Word Ptr LASTPG	;GET LAST PAGE ADDRESS
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	CMP	BX,DX			;COMPARE
	JNZ	PPAGE1
	JMP	CMDLP			;SAME, DO NOT INCREMENT
PPAGE1:	MOV	CX,24			;SET A COUNTER
PPAGE2:	CALL	FWD1			;PLUS ONE LINE
	LOOP	PPAGE2			;LOOP UNTIL DONE
	CALL	DISPPG			;DISPLAY PAGE
	JMP	CMDLP			;GET ANOTHER COMMAND

;	GO FORWARD ONE LINE ON SCREEN

PLINE:	CALL	PLINE1			;PLUS ONE LINE
	JMP	CMDLP			;GET ANOTHER COMMAND
PLINE1:	CALL	FWD1			;MOVE FORWARD ONE LINE IN TEXT
	JZ	PLINEX			;AT END
	CALL	TYPTX
	DB	27,'Y7 ',10+80H		;MOVE TEXT UP
	CALL	PRLINE			;PRINT NEXT LINE
PLINEX:	RET

;	MOVE POINTER FORWARD ONE LINE IN TEXT

FWD1:	MOV	DX,Word Ptr LASTPG	;GET LAST PAGE ADDRESS
	MOV	SI,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	CMP	SI,DX			;COMPARE
	JNZ	FWD2	
	RET				;SAME, DO NOT INCREMENT
FWD2:	MOV	AH,STRIP		;GET HIGH BIT STRIPPER
	MOV	DS,BUFSEG		;POINT TO BUFFER SEGMENT
FWD3:	LODSB				;GET A CHARACTER
	AND	AL,AH			;STRIP HIGH BIT
	CMP	AL,10			;LINE FEED?
	JNZ	FWD3			;FIND LINE FEED
	MOV	CS:TPADR,SI		;SAVE TOP PAGE ADDRESS
	MOV	SI,CS:BPADR		;GET BOTTOM PAGE ADDRESS
	PUSH	SI			;SAVE IT
FWD4:	LODSB				;GET A CHARACTER
	AND	AL,AH			;STRIP HIGH BIT
	CMP	AL,10			;LINE FEED?
	JZ	FWD5			;YES
	CMP	SI,CS:TXTEND		;AT END OF TEXT?
	JAE	FWD6			;YES
	JMP	FWD4			;ELSE, KEEP LOOKING
FWD5:	MOV	CS:BPADR,SI		;UPDATE BOTTOM PAGE ADDRESS
	POP	BX			;GET OLD BOTTOM PAGE ADDRESS
	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	INC	WORD PTR CURLIN		;INCREMENT CURRENT LINE
	RET
FWD6:	MOV	SI,CS:TXTEND		;DON'T GO PAST TEXT END
	JMP	FWD5

;	GO TO TOP OF TEXT

TOP:	MOV	DX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	OR	DX,DX			;AT TOP OF BUFFER?
	JNZ	TOP0	
	JMP	CMDLP			;ALREADY AT TOP
TOP0:	MOV	Word Ptr TPADR,0	;UPDATE TOP PAGE ADDRESS
	CALL	DISPPG			;DISPLAY PAGE
	MOV	BX,Word Ptr LINSTRT	;GET FIRST LINE NUMBER
	MOV	Word Ptr CURLIN,BX	;UPDATE CURRENT LINE
	JMP	CMDLP			;GET NEXT COMMAND

;	BACK UP ONE LINE ON SCREEN

MLINE:	CALL	MLINE1			;MINUS ONE LINE
	JMP	CMDLP			;GET NEXT COMMAND
MLINE1:	CALL	BACK1			;BACK UP ONE LINE IN TEXT
	JZ	MLINEX
	CALL	TYPTX
	DB	27,'H',27,'I'+80H	;BACK UP ONE LINE ON SCREEN
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDR
	CALL	PRLINE			;PRINT THE LINE THERE
MLINEX:	RET

;	BACK UP POINTER ONE LINE IN TEXT

BACK1:	XOR	DX,DX			;GET BUFFER START
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDR
	CMP	BX,DX			;COMPARE
	JNZ	BACK1A	
	RET				;SAME, DO NOT DECREMENT
BACK1A:	MOV	AH,STRIP		;GET HIGH BIT STRIPPER
	MOV	DS,BUFSEG		;GET BUFFER SEGMENT
	DEC	BX			;BACK UP OVER LINE FEED
	JZ	BACK2A			;FOUND TOP
	DEC	BX
BACK2:	OR	BX,BX
	JZ	BACK2A
	MOV	AL,M			;GET A CHARACTER
	AND	AL,AH			;STRIP HIGH BIT
	DEC	BX			;MOVE TO PREVIOUS CHARACTER
	CMP	AL,10			;LINE FEED?
	JNZ	BACK2			;FIND LINE FEED
	INC	BX			;SKIP OVER LINE FEED
	INC	BX
BACK2A:	MOV	CS:TPADR,BX		;SAVE TOP PAGE ADDESS
	MOV	BX,CS:BPADR		;GET BOTTOM PAGE ADDR
	DEC	BX			;BACK UP OVER LINE FEED
	DEC	BX
BACK3:	MOV	AL,M			;FIND PREVIOUS LINE FEED
	AND	AL,AH			;STRIP HIGH BIT
	DEC	BX
	CMP	AL,10
	JNZ	BACK3
	INC	BX
	INC	BX
	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	MOV	Word Ptr BPADR,BX	;UPDATE BOTTOM PAGE ADDR
	DEC	Word Ptr CURLIN		;DECREMENT CURRENT LINE
	RET

;	BACK UP ONE PAGE ON SCREEN

MPAGE:	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	XOR	DX,DX			;POINT TO BUFFER
	CMP	BX,DX			;COMPARE
	JNZ	MPAGE1
	JMP	CMDLP			;ALREADY AT TOP
MPAGE1:	MOV	CH,24			;SET A COUNTER
MPAGE2:	CALL	BACK1			;BACK UP ONE LINE
	DEC	CH
	JNZ	MPAGE2			;LOOP UNTIL DONE
	CALL	DISPPG			;DISPLAY PAGE
	JMP	CMDLP

;	GO TO BOTTOM OF TEXT

BOTTOM:	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDR
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr LASTPG	;GET LAST PAGE ADDR
	CMP	BX,DX			;COMPARE
	JNZ	BOTTOM1	
	JMP	CMDLP			;ALREADY AT BOTTOM
BOTTOM1:MOV	Word Ptr TPADR,BX	;SET TOP PAGE ADDRESS
	MOV	BX,Word Ptr LINCNT	;GET LINE COUNT
	SUB	BX,24			;SUBTRACT 24
	MOV	Word Ptr CURLIN,BX	;UPDATE CURRENT LINE
	MOV	BX,Word Ptr TPADR
	CALL	DISPPG			;DISPLAY PAGE
	JMP	CMDLP			;GET NEXT COMMAND

;	PRINT MARKED TEXT TO PRINTER

PRINT:	CMP	Byte Ptr MARKNO,'2'	;IS TEXT MARKED?
	JZ	PRINT1	
	JMP	BEEP			;NO, DON'T EVEN TRY
PRINT1:	MOV	Byte Ptr PFLAG,1	;SET PRINT FLAG
	MOV	BX,TMADR		;GET TOP MARK ADDRESS
PRINTLP:CALL	PRLINE			;PRINT A LINE
	MOV	AL,13
	CALL	POUT			;PRINT CR
	MOV	AL,10
	CALL	POUT			;PRINT LF
	INC	BX			;SKIP LINE FEED
	CMP	BX,BMADR		;HAVE WE REACHED THE BOTTOM
	JB	PRINTLP			;IF NOT, LOOP
	MOV	Byte Ptr PFLAG,0	;CLEAR PRINT FLAG
	JMP	BEEP

;	FIND SPECIFIED TEXT

FIND:	CALL	LINPUT			;INPUT SEARCH LINE
	JNZ	FIND0	
	JMP	FIND4			;ESC
FIND0:	CALL	TYPTX			;PRINT "SEARCHING..."
	DB	27,'x5',27,'Y8 ',27,'K',27,'p'
	DB	' Searching for: ',27,'q'+80H
	PUSH	DX			;SAVE SEARCH ARG ADDR
	MOV	CL,Byte Ptr LINLEN	;GET STRING LENGTH
	XOR	CH,CH			;IN CX
PSMSG:	MOV	SI,DX			;GET A CHARACTER
	MOV	AL,[SI]
	CALL	SCOUT			;PRINT IT
	INC	DX
	LOOP	PSMSG			;LOOP UNTIL DONE
	POP	DX			;RESTORE SEARCH ARG ADDR
	CALL	TYPTX
	DB	27,'Y7',' '+80H
	CMP	BYTE PTR LCBIT,20H	;CASE INSENSITIVE SEARCH?
	JNZ	FINDC			;NO
	MOV	SI,DX			;ELSE, POINT TO SEARCH STRING
	MOV	DI,OFFSET SCHLIN	;COPY IT TO HERE
	MOV	CL,LINLEN		;GET LINE LENGTH
	XOR	CH,CH			;IN CX
COPYSL:	LODSB				;GET A CHARACTER
	CMP	AL,' '			;CONTROL?
	JB	NOCLC			;DO NOT CONVERT TO LOWER CASE
	OR	AL,20H			;ELSE, CONVERT
NOCLC:	STOSB				;STORE CONVERTED CHARACTER
	LOOP	COPYSL
	MOV	DX,OFFSET SCHLIN	;USE THIS BUFFER FOR SEARCH
FINDC:	MOV	BX,Word Ptr CURLIN	;GET CURRENT LINE
	PUSH	BX			;SAVE IT
	INC	BX			;START WITH NEXT LINE
	MOV	Word Ptr CURLIN,BX	;SAVE NEW LINE NO.
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	PUSH	BX			;SAVE IT
	MOV	AH,STRIP		;GET HIGH BIT STRIPPER
	MOV	DS,BUFSEG		;GET BUFFER SEGMENT
FIND1:	MOV	AL,M			;FIND NEXT LINE
	AND	AL,AH
	INC	BX
	CMP	AL,10
	JNZ	FIND1
	PUSH	DX			;SAVE SUBSTRING
	PUSH	BX			;SAVE STRING
	NEG	BX			;GET -STRING ADDR
	XCHG	BX,DX			;IN DE
	MOV	BX,CS:TXTEND		;GET TEXT END
	ADD	BX,DX			;COMPUTE STRING LENGTH
	MOV	CX,BX			;IN CX
	POP	BX
	POP	DX			;RESTORE ADDRESSES
	MOV	AL,CS:LINLEN		;GET INPUT LENGTH
	CALL	INSTRG			;LOOK FOR STRING
	JZ	FIND2	
	JMP	NOFIND			;COULD NOT FIND IT
FIND2:	DEC	BX			;BACK UP TO BEGINNING OF STRING
	MOV	AL,M
	AND	AL,CS:STRIP
	CMP	AL,10
	JNZ	FIND2
	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	INC	BX			;SKIP LINE FEED
	MOV	Word Ptr TPADR,BX	;UPDATE TOP PAGE ADDRESS
	CALL	DISPPG			;DISPLAY PAGE WITH MATCH
	MOV	DX,Word Ptr LASTPG	;GET LAST PAGE
	MOV	BX,Word Ptr TPADR	;AND TOP PAGE ADDR
	CMP	BX,DX			;ON LAST PAGE?
	JNZ	FIND3			;NO
	MOV	BX,Word Ptr LINCNT	;ELSE, GET LINE COUNTER
	SUB	BX,24			;SUBTRACT 24
	MOV	AL,BH			;GET LINE NUMBER HIGH
	CMP	AL,0FFH			;IMPOSSIBLY HIGH?
	JNZ	GDLNO			;NO, GOOD NO.
	POP	DX
	POP	BX			;ELSE, GET ORIGINAL LINE NUMBER
	PUSH	BX			;FIX STACK
	PUSH	DX
GDLNO:	MOV	Word Ptr CURLIN,BX	;UPDATE CURRENT LINE
	CALL	TYPTX
	DB	7+80H			;BEEP
	MOV	AH,2CH
	INT	21H			;GET TIME FROM DOS
	ADD	DL,50			;ADD 1/2 SECOND TO HUNDREDTHS
	MOV	BX,DX			;SAVE VALUE
BPDLY:	MOV	AH,2CH
	INT	21H			;GET TIME AGAIN
	CMP	BH,DH			;SECOND THE SAME?
	JZ	SAMSEC			;YES
	ADD	DL,100			;ELSE, FIX HUNDREDTHS
SAMSEC:	CMP	BL,DL			;1/2 SECOND GONE?
	JA	BPDLY			;IF NOT, WAIT
	CALL	TYPTX
	DB	7+80H			;BEEP AGAIN
FIND3:	POP	BX			;FIX STACK
	POP	BX
FIND4:	CALL	PBMSG0			;RESTORE BOTTOM LINE
	JMP	CMDLP
NOFIND:	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	POP	BX			;RESTORE OLD TOP ADDR
	MOV	Word Ptr TPADR,BX
	POP	BX			;RESTORE OLD LINE NUMBER
	MOV	Word Ptr CURLIN,BX
	CALL	PBMSG0			;RESTORE BOTTOM LINE
	JMP	BEEP

;	LOAD NEXT PART OF FILE

NEXT:	MOV	AL,Byte Ptr NEXTFLG	;GET "NEXT" FLAG
	OR	AL,AL			;IS IT SET?
	JNZ	DONXT
	JMP	BEEP			;NO, IGNORE NEXT COMMAND
DONXT:	DEC	AL			;A = 0
	MOV	Byte Ptr NEXTFLG,AL	;CLEAR FLAG
	MOV	WORD PTR BMADR,0	;CLEAR MARKING
	MOV	BYTE PTR MARKNO,'0'
	MOV	SI,Word Ptr TXTEND	;POINT TO TEXT END
	MOV	AL,Byte Ptr ENDCNT	;GET END TEXT COUNT
	MOV	CL,AL
	XOR	CH,CH
	XOR	DI,DI			;POINT TO BUFFER
	OR	AL,AL			;ANY END TEXT
	JZ	NETXT			;NO
	MOV	AX,BUFSEG		;GET BUFFER SEGMENT
	MOV	DS,AX
	MOV	ES,AX
	REP	MOVSB			;MOVE THE TEXT
	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	MOV	ES,AX			;AND ES
NETXT:	MOV	Word Ptr TXTSTRT,DI	;UPDATE TEXT START
	MOV	CX,Word Ptr MEMTOP	;GET MEMORY TOP
	SUB	CX,DI			;FIND FREE SPACE
	MOV	BX,Word Ptr TXTSTRT	;START READING HERE
	JMP	READLP			;READ THE TEXT

;	RE-WIND FILE

REWIND:	CMP	BYTE PTR NRFLG,1	;IS REWIND ENABLED?
	JZ	DOREW			;YES
	JMP	BEEP			;ELSE, BEEP
DOREW:	MOV	DI,OFFSET TXTSTRT	;POINT TO TEXT FLAGS
	MOV	CX,FLAGL		;GET LENGTH OF FLAGS
	XOR	AL,AL
	REP	STOSB			;CLEAR FLAGS
	MOV	WORD PTR LINCNT,1	;THIS FLAG STARTS AT 1
	MOV	BYTE PTR MARKNO,'0'	;CLEAR MARK NUMBER
	MOV	BX,HANDLE		;GET FILE HANDLE
	MOV	AH,3EH
	INT	21H			;CLOSE FILE
	MOV	DX,FNAME		;POINT TO FILE NAME
	MOV	AX,3D00H
	INT	21H			;OPEN IT AGAIN
	JC	NOREW			;ERROR
	MOV	HANDLE,AX		;UPDATE HANDLE (IN CASE IT CHANGED)
	MOV	CX,MEMTOP		;GET MEMORY TOP ADDRESS
	XOR	BX,BX			;READ INTO BUFFER BOTTOM
	JMP	READLP			;READ IN FILE AGAIN
NOREW:	JMP	BEEP			;PROBABLY SHOULD EXIT NOW

;	MARK/UNMARK TEXT

MARK:	MOV	AL,MARKNO		;GET MARK FLAG
	INC	AL			;ADD 1
	MOV	MARKNO,AL
	CMP	AL,'1'			;TIME TO MARK TOP?
	JZ	MARK1			;YES, DO IT
	CMP	AL,'2'			;MARK BOTTOM?
	JZ	MARK2
	MOV	WORD PTR BMADR,0	;ELSE, CLEAR BOTTOM MARK
	MOV	BYTE PTR MARKNO,'0'	;CLEAR MARK FLAG
MARKX:	CALL	DISPPG			;ENSURE PAGE MARKING CLEARED
CASEX:	CALL	PBMSG0			;UPDATE MARK NO.
	JMP	CMDLP
MARK1:	MOV	AX,TPADR		;GET TOP PAGE ADDRESS
	MOV	TMADR,AX		;MARK TOP ADDRESS
MARK2:	MOV	SI,TPADR		;GET TOP PAGE ADDRESS
	MOV	AH,STRIP		;GET HIGH BIT STRIPPER
	MOV	DS,BUFSEG		;GET BUFFER SEGMENT
MARK3:	LODSB
	AND	AL,AH
	CMP	AL,10			;LOOK FOR LINE FEED
	JZ	MARK4			;GOT ONE
	CMP	SI,CS:TXTEND		;AT END OF TEXT?
	JAE	MARK4			;YES
	JMP	MARK3
MARK4:	PUSH	CS
	POP	DS			;FIX DS
	MOV	BMADR,SI		;MARK BOTTOM
	JMP	MARKX
MARKB:	MOV	AL,MARKNO		;GET MARK FLAG
	INC	AL
	CMP	AL,'1'
	JZ	MARKB1
	CMP	AL,'2'			;TIME TO MARK BOTTOM?
	JZ	MARKB2			;YES
	JMP	BEEP			;ELSE, BEEP
MARKB1:	MOV	MARKNO,AL
	MOV	BX,BPADR		;GET BOTTOM PAGE ADDR
	MOV	AH,STRIP
	MOV	DS,BUFSEG
	DEC	BX			;BACK UP OVER LINE FEED
	DEC	BX
MARKB1A:MOV	AL,M			;FIND PREVIOUS LINE FEED
	AND	AL,AH			;STRIP HIGH BIT
	DEC	BX
	CMP	AL,10
	JNZ	MARKB1A
	INC	BX
	INC	BX
	MOV	AX,CS
	MOV	DS,AX			;FIX DS
	MOV	TMADR,BX		;MARK BEGINNING OF LAST LINE
	JMP	MARKX1
MARKB2:	MOV	MARKNO,AL
MARKX1:	MOV	AX,BPADR		;GET BOTTOM PAGE ADDRESS
	MOV	BMADR,AX		;SET BOTTOM MARK
	JMP	MARKX

;	MOVE WINDOW RIGHT

RWINDOW:INC	Byte Ptr WPOS		;TO SHOW RIGHT WINDOW
WINDX:	CALL	DISPPG			;DISPLAY PAGE
	JMP	CMDLP

;	MOVE WINDOW LEFT

LWINDOW:MOV	AL,BYTE PTR WPOS	;GET WINDOW POSITION
	SUB	AL,1			;SUBTRACT 1
	JNB	LWIND1			;NOT TOO FAR DOWN
	XOR	AL,AL			;ELSE, USE ZERO
LWIND1:	MOV	Byte Ptr WPOS,AL	;UPDATE WINDOW POSITION
	JMP	WINDX			;DISPLAY PAGE

;	JUMP TO LEFT COLUMN

JLEFT:	MOV	BYTE PTR WPOS,0		;CLEAR WINDOW POSITION
	JMP	WINDX

;	EXIT FROM SEE

EXIT:	CALL	TYPTX
	DB	27,'y1',27,'y5',27,'q',27,'G',27,'y6',27,'x?'
	DB	27,'Y7',' '+80H
	CMP	Byte Ptr TTYPE,0	;H150?
	JNZ	EXIT1			;NO
	CALL	TYPTX
	DB	27,'Y8 ',27,'l'+80H
	MOV	DX,23*256
	MOV	BH,0
	MOV	AH,2
	INT	10H			;PUT CURSOR ON NEXT TO LAST LINE
	MOV	AL,DISPLAY		;GET OLD DISPLAY TYPE
	CMP	AL,3			;MODE 3?
	JZ	EXIT1			;IF SO, DON'T RESET
	CMP	AL,2
	JZ	EXIT1			;SAME FOR 2
	CMP	AL,7
	JZ	EXIT1			;SAME FOR 7
	XOR	AH,AH
	INT	10H			;SET IT
EXIT1:	INT	20H			;RETURN TO Z-DOS

TCASE:	XOR	BYTE PTR LCBIT,20H	;TOGGLE LOWER CASE BIT
	JZ	CASEC			;CASE SENSITIVE SEARCHES SET
	MOV	BYTE PTR CASEFLG,'i'	;ELSE, MARK INSENSITIVE
	JMP	CASEX			;SHOW CHANGE
CASEC:	MOV	BYTE PTR CASEFLG,'c'	;MARK CASE SENSITIVE SEARCHES
	JMP	CASEX			;SHOW CHANGE

HELP:	CALL	TYPTX
	DB	27,'E'			;ERASE SCREEN
	DB	'To move around in the file you are SEEing, use the '
	DB	'numeric keypad:',13,10
	DB	27,'F'			;ENTER GRAPHICS MODE
	DB	'faaaaaaaasaaaaaaaasaaaaaaaac',13,10
	DB	'`   TOP  `   UP   `   UP   `',13,10
	DB	'`   OF   `   ONE  `   ONE  `',13,10
	DB	'`  FILE  `  LINE  ` SCREEN `',13,10
	DB	'vaaaaaaaabaaaaaaaabaaaaaaaat',13,10
	DB	'`  MOVE  `  5 KEY `  MOVE  `',13,10
	DB	'` WINDOW `  (NOT  ` WINDOW `',13,10
	DB	'`  LEFT  `  USED) `  RIGHT `',13,10
	DB	'vaaaaaaaabaaaaaaaabaaaaaaaat',13,10
	DB	'` BOTTOM `  DOWN  `  DOWN  `',13,10
	DB	'`   OF   `   ONE  `   ONE  `',13,10
	DB	'`  FILE  `  LINE  ` SCREEN `',13,10
	DB	'eaaaaaaaauaaaaaaaauaaaaaaaad'
	DB	27,'G'			;EXIT GRAPHICS MODE
	DB	27,'Y"HYou can also use these keys:'
	DB    13,27,'Y#HReturn or Enter	 Down one line'
	DB    13,27,"Y$HDown Arrow	 Down one line"
	DB    13,27,"Y%HUp Arrow	 Up one line"
	DB    13,27,"Y&HRight Arrow	 Move window right"
	DB    13,27,"Y'HLeft Arrow	 Move window left"
	DB    13,27,'Y(HL		 Move window to col. 1'
	DB	13,27,'Y.HTo exit to DOS, press Esc','.'+80H
	CMP	BYTE PTR TTYPE,0	;PC?
	JNZ	HELPZ
	JMP	HELPPC			;YES
HELPZ:	CALL	TYPTX			;ELSE, PRINT Z-100 HELP
	DB    13,27,'Y)HShift-Down Arrow Down one screen'
	DB    13,27,'Y*HShift-Up Arrow	 Up one screen'
	DB    13,27,'Y+HShift-Home	 Bottom of file/buffer'
	DB    13,27,'Y,HHome		 Top of file/buffe','r'+80H
	JMP	HELPCM			;GO TO COMMON CODE
HELPPC:	CALL	TYPTX
	DB    13,27,'Y)HPgDn		 Down one screen'
	DB    13,27,'Y*HPgUp		 Up one screen'
	DB    13,27,'Y+HEnd		 Bottom of file/buffer'
	DB    13,27,'Y,HHome		 Top of file/buffe','r'+80H
HELPCM:	CALL	TYPTX
	DB	13,10,10,10
	DB     'Use the function keys as follows:	'
	DB	27,'F','f'+80H
	MOV	AL,'a'
	MOV	CL,37
	CALL	MSCOUT			;PRINT 37 "a"'S
	CALL	TYPTX
	DB	'c',27,'G',13,10
	DB     'F1	Find a string of text		'
	DB	27,'F`',27,'GThe first press of F2 (or Shift-F2)  ',27,'F`'
	DB	27,'G',13,10
	DB     'Shf-F1	Toggle Find case sensitivity	'
	DB	27,'F`',27,'Gmarks the beginning of a text block. ',27,'F`'
	DB	27,'G',13,10
	DB     'F2	Mark the top screen line	'
	DB	27,'F`',27,'GThe second press marks the end.  The ',27,'F`'
	DB	27,'G',13,10
	DB     'Shf-F2	Mark the bottom screen line	'
	DB	27,'F`',27,'Gthird press removes the marks.  Print',27,'F`'
	DB	27,'G',13,10
	DB     'F3	Print the marked block		'
	DB	27,'F`',27,'G(F3) will not work unless a block is ',27,'F`'
	DB	27,'G',13,10+80H
	CMP	BYTE PTR NRFLG,1	;IS FILE LARGE?
	JZ	HELP1			;YES
	CALL	TYPTX			;ELSE, SKIP NEXT MSG
	DB	9,9,9,9,9+80H
	JMP	SHORT HELP2
HELP1:	CALL	TYPTX
	DB     'F4	Load the next',' '+80H
	MOV	BX,BUFSIZE		;GET BUFFER SIZE
	CALL	DECOUT			;PRINT IT
	CALL	TYPTX
	DB	'k of the file',9+80H
HELP2:	CALL	TYPTX
	DB	27,'F`',27,'Gmarked.',9,9,9,'      ',27,'F`',27,'G',13,10+80H
	CMP	BYTE PTR NRFLG,1	;IS FILE LARGE?
	JZ	HELP3			;YES
	CALL	TYPTX			;ELSE, SKIP NEXT MSG
	DB	9,'Buffer size =',' '+80H
	MOV	BX,BUFSIZE		;GET BUFFER SIZE
	CALL	DECOUT			;PRINT IT
	CALL	TYPTX
	DB	'k',9,9+80H
	JMP	SHORT HELP4
HELP3:	CALL	TYPTX
	DB     'F5	Rewind to the top of the file',9+80H
HELP4:	CALL	TYPTX
	DB	27,'F','e'+80H
	MOV	AL,'a'
	MOV	CL,37
	CALL	MSCOUT			;PRINT 37 "a"'S
	CALL	TYPTX
	DB	'd',27,'G'
	DB	27,'Y7H',27,'p Press any key to return to your file.. ',27,'q'+80H
	CALL	SCIN
	MOV	BX,TPADR
	CALL	DISPPG			;RE-DISPLAY CURRENT PAGE
	JMP	CMDLP

;	SUBROUTINES
;	READFIL - READ DISK FILE
;	ENTRY:	DS:BX = ADDRESS TO READ INTO
;	CX = NUMBER OF BYTES TO READ
;	EXIT:	CY = 1 IF ERROR, AND
;	BX = NEXT FREE BYTE

READFIL:MOV	DX,BX			;ADDRESS TO DX
	MOV	BX,CS:HANDLE		;GET FILE HANDLE
	MOV	AH,3FH
	INT	21H			;READ FILE
	MOV	BX,DX			;POINTER TO BX
	JC	READX			;ERROR
	ADD	BX,AX			;POINT TO END OF TEXT
READX:	RET

;	TYPTX - TYPE TEXT UNTIL PARITY BIT SET

TYPTX:	MOV	BP,SP			;GET TEXT ADDR
	XCHG	BX,[BP]
TYPTX1:	MOV	AL,M			;GET A CHARACTER
	AND	AL,7FH			;STRIP 8TH BIT
	CALL	SCOUT			;PRINT IT
	CMP	AL,M			;TEST FOR END
	LAHF
	INC	BX
	SAHF
	JZ	TYPTX1			;NOT END
	MOV	BP,SP
	XCHG	BX,[BP]			;FIX BX AND RETURN ADDRESS
	RET

;	SCIN - SINGLE CHARACTER INPUT

SCIN:	CMP	BYTE PTR TTYPE,0	;PC?
	JZ	SCINP			;YES
	CALL	CONIN			;ELSE, GET Z-100 CHARACTER
	RET
SCINP:	XOR	AH,AH
	INT	16H			;GET KEY FROM BIOS
	RET

;	SCOUT - OUTPUT CHARACTER

SCOUT:	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	DX
	CMP	Byte Ptr TTYPE,0	;H150?
	JNZ	SCOUT1
	CALL	IBMOUT
	JMP	SHORT SCOUTX
SCOUT1:	CMP	BYTE PTR FTFLG,0	;FIRST TIME?
	JZ	SCOUT1A			;YES
	MOV	AH,LSTCHR		;GET LAST CHARACTER
	MOV	LSTCHR,AL		;UPDATE IT
	CMP	AH,1BH			;LAST CHAR ESCAPE?
	JNZ	SCOUT3			;NO
	CMP	AL,'p'			;SET REV. VID?
	JNZ	SCOUT2			;NO
	CALL	TYPTX
	DB	'm'
ZHATTR	DB	'0','3'+80H
	JMP	SHORT SCOUTX
SCOUT2:	CMP	AL,'q'			;SET NORMAL VIDEO?
	JNZ	SCOUT3			;NO
	CALL	TYPTX
	DB	'm'
ZATTR1	DB	'7','1'+80H
	JMP	SHORT SCOUTX
SCOUT3:	PUSH	SI
	PUSH	DI
	PUSH	ES			;ELSE, SAVE THESE
	CLD				;MUST BE CLEARED!
	CALL	ROMOUT			;USE ROM FOR PRINTING
	POP	ES
	POP	DI
	POP	SI
	JMP	SHORT SCOUTX
SCOUT1A:MOV	DL,AL
	MOV	AH,DCIO
	INT	21H
SCOUTX:	POP	DX
	POP	BX
	POP	CX
	POP	AX
	RET

;	MULTIPLE CHARACTER OUTPUT

MSCOUT:	XOR	CH,CH			;CX = COUNT
MSCOUT1:CALL	SCOUT			;OUTPUT CHARACTER
	LOOP	MSCOUT1			;UNTIL N TIMES DONE
	RET

;	POUT - OUTPUT CHARACTER TO PRINTER

POUT:	PUSH	CX
	PUSH	DX
	MOV	DL,AL			;CHARACTER TO E
	MOV	AH,LSTOUT
	INT	21H			;PRINT CHARACTER
	POP	DX
	POP	CX
	RET

;	PRLINE - PRINT LINE AT (BX)

PRLINE:	MOV	BYTE PTR LCFLG,0	;CLEAR LAST COLUMN FLAG
	MOV	ES,BUFSEG		;GET BUFFER SEGMENT
	CMP	BYTE PTR PFLAG,0	;PRINTING?
	JZ	PRLINNP			;NO
	JMP	PRLINE3			;YES, NO WINDOW CHECK OR MARKING
PRLINNP:CMP	WORD PTR BMADR,0	;IS TEXT MARKED?
	JZ	PRLINE0			;NO
	CMP	BX,TMADR		;COMPARE LINE TO TOP MARK
	JB	PRLINCB			;BELOW, DO NOT MARK
	CMP	BX,BMADR		;COMPARE TO BOTTOM LINE MARK
	JAE	PRLINCB			;ABOVE, DO NOT MARK
	CALL	TYPTX
	DB	27,'p'+80H
;	DB	27,'m0','7'+80H		;SET MARKING COLORS
	JMP	SHORT PRLINE0
PRLINCB:CALL	TYPTX
	DB	27,'q'+80H
;	DB	27,'m7','1'+80H		;SET NORMAL COLORS
PRLINE0:MOV	AL,WPOS			;GET WINDOW POSITION
	OR	AL,AL			;ZERO?
	JZ	PRLINE3			;YES, SHOW LEFT WINDOW
	PUSH	CX			;ELSE, SAVE CX
	MOV	CL,8
	MUL	CL			;MULTIPLY WINDOW COUNT BY 8
	MOV	CX,AX			;RESULT TO CX
	XOR	DI,DI			;ZERO A COUNTER
PRLINE1:MOV	AL,ES:[BX]		;GET A CHARACTER
	AND	AL,STRIP		;STRIP HIGH BIT
	CMP	AL,10			;END OF LINE?
	JZ	PRLINE2			;YES
	CMP	BX,TXTEND		;AT END OF TEXT?
	JBE	PRLNE			;NO
	POP	CX
	JMP	PREND			;ELSE, END OF LINE
PRLNE:	INC	BX			;MOVE TO NEXT CHARACTER
	CMP	AL,9			;TAB?
	JZ	PRTAB			;YES, PROCESS IT
	CMP	AL,27			;ESCAPE?
	JNZ	NOTESC			;NOT AN ESCAPE
	INC	BX			;ELSE, SKIP NEXT CHARACTER
	MOV	AL,ES:[BX]		;GET NEXT CHARACTER
	CMP	AL,'s'			;H29 ATTRIBUTE?
	JZ	SKIP1			;IF SO, SKIP ONE MORE CHAR
	CMP	AL,'m'			;H100 COLOR SETTING?
	JNZ	PRLINE1			;NO
	INC	BX			;ELSE, SKIP TWO MORE CHARS
SKIP1:	INC	BX
	JMP	SHORT PRLINE1		;AND CHECK FOLLOWING ONE
NOTESC:	CMP	AL,' '			;ANY OTHER CONTROL CHARACTER?
	JB	PRLINE1			;IF SO, DON'T COUNT IT
	INC	DI			;ELSE, COUNT CHARACTER
	LOOP	PRLINE1			;LOOP UNTIL DONE
	CMP	BX,TXTEND		;PAST END OF TEXT?
	JAE	PREND
	JMP	SHORT PRLINE2		;PRINT REST OF LINE NORMALLY
PRTAB:	DEC	CX			;DECREMENT WINDOW COUNTER
	JZ	PRLINE2			;DONE, PRINT NORMALLY
	INC	DI			;INCREMENT PLACE COUNTER
	MOV	AX,DI			;GET IT
	AND	AX,7			;AT TAB STOP?
	JNZ	PRTAB			;IF NOT, KEEP COUNTING
	JMP	SHORT PRLINE1		;ELSE, CHECK NEXT CHARACTER
PRLINE2:POP	CX			;RESTORE CX
PRLINE3:MOV	AL,ES:[BX]		;GET A CHARACTER
	AND	AL,STRIP		;STRIP PARITY
	CMP	AL,' '			;SPACE OR MORE
	JNB	PRL0			;IF SO, PRINT CHAR
	CMP	AL,27			;ESCAPE?
	JZ	PRL0			;OK
	CMP	AL,7			;LESS THAN 7?
	JB	PRL2			;DON'T PRINT
	CMP	AL,10			;10 OR LESS?
	JZ	PREND			;LINE FEED, RETURN
	JNB	PRL2			;DON'T PRINT MORE THAN 10
PRL0:	CMP	Byte Ptr PFLAG,0	;PRINTER ON?
	JZ	PRL1			;NO
	CALL	POUT			;ELSE, USE PRINTER OUT
	JMP	SHORT PRL2
PRL1:	CMP	BYTE PTR LCFLG,1	;LAST COLUMN USED?
	JZ	PRL2			;IF SO, QUIT
	CMP	BYTE PTR TTYPE,0	;PC?
	JZ	PRL1A			;YES
	MOV	DI,CURADR		;ELSE, GET CURSOR ADDRESS
	PUSH	ES
	MOV	ES,ROMSEG
	MOV	AH,ES:[DI]		;GET CURSOR COLUMN
	POP	ES
	JMP	SHORT PRL1B
PRL1A:	MOV	AH,BYTE PTR CURPOS	;GET CURSOR COLUMN
PRL1B:	CMP	AH,79			;IN LAST COLUMN?
	JNZ	PRL1C			;NO
	MOV	BYTE PTR LCFLG,1	;ELSE, MARK LAST COLUMN USED
PRL1C:	CALL	SCOUT			;NOT PRINTER, USE SCOUT
PRL2:	INC	BX			;MOVE TO NEXT CHARACTER
	CMP	BX,TXTEND		;AT END?
	JAE	PREND
	JMP	SHORT PRLINE3		;PRINT IT
PREND:	MOV	AX,CS
	MOV	ES,AX			;FIX ES
	RET				;RETURN

;	DISPPG - DISPLAY PAGE AT (TPADR)

DISPPG:	CALL	TYPTX
	DB	27,'w',27,'E'+80H	;CLEAR WRAP AND SCREEN
DISP0:	MOV	BX,Word Ptr LASTPG	;GET LAST PAGE ADDRESS
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	CMP	BX,DX			;COMPARE LASTPG WITH TPADR
					;TO SEE IF SHORT PAGE
	JB	DISP1			;LASTPG BIGGER, IT'S OK
	XCHG	BX,DX			;ELSE, USE LASTPG FOR START
	MOV	Word Ptr TPADR,BX	;UPDATE TOP PAGE ADDRESS
DISP1:	MOV	DX,Word Ptr TXTEND	;GET END OF TEXT
	MOV	CH,24			;SET A COUNTER
DISP2:	CALL	PRLINE			;PRINT A LINE
	INC	BX			;SKIP LINE FEED
	CMP	BX,DX			;END OF TEXT?
	JAE	DISP3			;YES, END EARLY
	DEC	CH			;DONE?
	JZ	DISP3			;DONE
	CALL	TYPTX
	DB	13,10+80H		;MOVE TO NEXT LINE
	JMP	SHORT DISP2		;PRINT IT
DISP3:	MOV	Word Ptr BPADR,BX	;SET BOTTOM PAGE ADDR
	RET

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	MOV	AL,DL			;GET CHARACTER TO PRINT
	ADD	AL,'0'			;ADD ASCII BIAS
	CALL	SCOUT			;PRINT IT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

;	INSTR - SEARCH STRING FOR SUBSTRING
;	DS:BX = STRING
;	DX = SUBSTRING
;	CX = STRING LENGTH
;	AL = SUBSTRING LENGTH
;	RETURNS Z FLAG IF FOUND, WITH BX = END OF SUBSTRING

INSTRG:	PUSH	CS
	POP	ES			;ENSURE ES IS HERE
	XOR	AH,AH
	MOV	BP,AX			;SAVE SUBSTRING LENGTH
	SUB	CX,AX			;SUBTRACT SUB. L. FROM STRING LENGTH
	MOV	AH,CS:STRIP		;GET HIGH BIT STRIPPER
INSTR0:	PUSH	CX			;SAVE STRING SIZE
	MOV	CX,BP
	MOV	AL,M			;GET FIRST CHARACTER
	AND	AL,AH			;STRIP HIGH BIT
	CMP	AL,10			;LINE FEED?
	JNZ	INSTR1			;NO
	INC	CS:Word Ptr CURLIN	;INCREMENT LINE COUNTER
	JMP	SHORT INSTR3		;NO MATCH ON LINE FEED
INSTR1:	MOV	DI,DX			;SUBSTRING TO DI
	MOV	SI,BX			;MAIN STRING TO SI
INSTR2:	LODSB				;GET A BYTE FROM SRING
	AND	AL,AH			;REMOVE HIGH BIT
	CMP	AL,' '
	JB	NOOR
	OR	AL,CS:LCBIT		;MAKE LOWER CASE
NOOR:	SCASB				;COMPARE WITH SUBSTRING
	LOOPZ	INSTR2			;LOOP IF MATCH
INSTR3:	POP	CX
	JZ	INSTR4			;FOUND SUBSTRING
	INC	BX			;INCREMENT STRING POINTER
	LOOP	INSTR0			;TRY AGAIN
	RET				;NO MATCH
INSTR4:	ADD	BX,BP			;MOVE TO END OF STRING
	XOR	AL,AL			;SET ZERO
	RET

;	LINPUT - LINE INPUT (FOR SEARCH STRING)

LINPUT:	CALL	TYPTX
	DB	27,'Y8 ',27,'l',27,'p',27,'y5'
	DB	' Enter string (RET = last, ESC = exit): '
	DB	27,'q'+80H
	MOV	BX,(Offset BA.LINBUF)	;POINT TO LINE BUFFER
	MOV	SI,OFFSET BA.TSBUF	;AND TO TAB STOP BUFFER
	MOV	CL,0			;SET A COUNTER
	MOV	CH,CL			;AND A LINE POINTER
LINPUT1:CMP	BYTE PTR TTYPE,0	;PC?
	JNZ	LINPZ			;NO
	PUSH	BX
	PUSH	DX
	MOV	DX,CURPOS		;ELSE, GET CURSOR POSITION
	MOV	BH,0
	MOV	AH,2
	INT	10H			;PUT CURSOR THERE
	POP	DX
	POP	BX
LINPZ:	CALL	SCIN			;GET A CHARACTER
	CMP	AL,13
	JZ	LINEND			;YES, END
	CMP	AL,8			;BACK SPACE?
	JZ	BACKUP
	CMP	AL,7FH			;DELETE?
	JZ	BACKUP
	CMP	AL,27			;ESCAPE?
	JNZ	NOTQT	
	RET				;YES, ABORT
NOTQT:	CMP	AL,9			;TAB?
	JZ	LINTAB			;YES, INPUT TAB
	CMP	AL,' '			;OTHER CONTROL CHARACTER?
	JB	LINPUT1			;IF SO, DON'T TAKE IT
	INC	CH			;AND LINE POSITION
	JMP	SHORT LINOUT
LINTAB:	MOV	[SI],CH			;STORE LINE POSITION
	INC	SI
	ADD	CH,8			;MOVE TO NEXT TAB STO
	AND	CH,0F8H
LINOUT:	MOV	M,AL			;STORE CHARACTER
	CALL	SCOUT			;PRINT IT
	INC	BX			;INCREMENT POINTER
	INC	CL			;INCREMENT COUNTER
	CMP	CL,40			;40 CHARACTERS?
	JZ	LINEND			;YES
	JMP	SHORT LINPUT1		;GET ANOTHER CHARACTER
BACKUP:	INC	CL
	DEC	CL			;SET FLAGS
	JZ	LINPUT1			;TAKE NO ACTION
	DEC	CL			;DECREMENT COUNTER
	DEC	BX			;AND POINTER
	CMP	M,9			;WAS OLD CHARACTER A TAB?
	JNZ	ONEBK			;NO, BACK UP ONLY ONCE
	DEC	SI			;ELSE, POINT TO POS. TO BACK TO
BACKLP:	CALL	TYPTX			;BACK UP
	DB	8,' ',8+80H
	DEC	CH
	CMP	CH,[SI]			;BACKED UP ENOUGH?
	JNZ	BACKLP			;IF NOT, LOOP
	JMP	LINPUT1
ONEBK:	CALL	TYPTX
	DB	8,' ',8+80H		;WIPE OUT CHARACTER
	DEC	CH			;BACK UP LINE POSITION
	JMP	LINPUT1
LINEND:	OR	CL,CL			;IS COUNT ZERO?
	JNZ	LINPUT2			;NO, USE THIS STRING
	MOV	DX,Offset BA.PRVSTR	;ELSE, USE PREVIOUS STRING
	MOV	AL,Byte Ptr LINLEN	;GET OLD LINE LENGTH
	OR	AL,AL			;SET FLAGS
	RET
LINPUT2:MOV	SI,Offset BA.LINBUF	;POINT TO BUFFER
	MOV	DI,Offset BA.PRVSTR	;AND PREVIOUS STRING SPACE
	MOV	Byte Ptr LINLEN,CL	;SET LENGTH
	XOR	CH,CH
	REP	MOVSB			;UPDATE PREVIOUS STRING
	MOV	DX,Offset BA.LINBUF	;GET BUFFER
	INC	CL			;SET FLAGS
	RET

;	PBMSG - PRINT BOTTOM LINE MESSAGE

PBMSG:	CALL	TYPTX
	DB	27,'E'+80H
PBMSG0:	CALL	TYPTX
	DB	27,'x5',27,'x1',27,'Y8 ',27,'pL#',27,'q     '
	DB	27,'pF1',27,'qFind('
CASEFLG	DB	'i)',27,'pF2',27,'qMark('
MARKNO	DB	'0)'
	DB	27,'G',27,'pF3',27,'qPrin','t'+80H
	CMP	BYTE PTR NRFLG,1	;IS NEXT/REWIND ENABLED?
	JNZ	PBMSG1			;NO
	CALL	TYPTX			;ELSE, PRINT THIS PART
	DB	27,'pF4',27,'qNext',27,'pF5',27,'qRewin','d'+80H
PBMSG1:	CALL	TYPTX
	DB	27,'pFile: ',27,'j'
	DB	27,'Y8jH=Help',27,'k',27,'q'+80H
PFNAM:	MOV	SI,Word Ptr FNAME	;GET FILE NAME
PFNAMLP:LODSB				;GET A CHARACTER
	OR	AL,AL			;END
	JZ	FNEND			;YES
	CALL	SCOUT			;PRINT CHARACTER
	JMP	PFNAMLP
FNEND:	RET

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT

SCREEN_OUT:
	PUSH	ES
	PUSH	DI
	PUSH	AX			;SAVE CHARACTER
	MOV	AX,MEMADR
	MOV	ES,AX
	MOV	AL,BYTE PTR CURPOS+1	;GET ROW
	XOR	AH,AH			;IN AX
	MOV	CL,80
	MUL	CL			;MPY BY 80
	MOV	CL,BYTE PTR CURPOS
	XOR	CH,CH
	ADD	AX,CX			;ADD COLUMN
	SHL	AX,1			;2 BYTES/CHAR
	MOV	DI,AX			;POSITION TO DI
	POP	AX			;GET CHARACTER
	MOV	AH,ATTR			;ATTRIBUTE TO AH
	STOSW				;STORE CHARACTER
	POP	DI
	POP	ES
	JMP	DORT			;MOVE CURSOR OVER
WRT_TTY:CMP	AL,10			;LF?
	JNE	WRT_TTY1
	MOV	DX,CURPOS		; YES, GET CURSOR POSITION
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JL	MOVEDN
	JE	SCROL_24		;IF LINE = 24 THEN SCROLL 1-24
	RET				;IF LINE = 25 THEN IGNORE LF
MOVEDN:	INC	DH			;JUST ADD A LINE
	MOV	CURPOS,DX
	RET
SCROL_24:
	MOV	AX,601H
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTR
	INT	10H
	RET
WRT_TTY1:
	CMP	AL,13			;CR
	JNZ	WRT_TTY2		;NO
	MOV	BYTE PTR CURPOS,0	;ELSE, ZERO COLUMN
WRT_TTY2:
	CMP	AL,8			;BS?
	JNZ	NOTBS			;NO
	MOV	AL,BYTE PTR CURPOS	;ELSE, GET COLUMN
	OR	AL,AL			;IN POS. 0?
	JZ	NOTBS			;IF SO, LEAVE ALONE
	DEC	AL			;ELSE, BACK UP
	MOV	BYTE PTR CURPOS,AL
	RET
NOTBS:	MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,ATTR 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	CMP	BYTE PTR STRIP,0FFH	;PASSING 8TH BIT?
	JNZ	DUMPIT			;NO, DUMP CHARACTER
	JMP	CRT_OUT			;ELSE, PRINT IT
DUMPIT:	RET				;IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	AL,DFATTR
	MOV	ATTR,AL			;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,ATTR			;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	DOHOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

REVIND:	MOV	DX,CURPOS		;REVERSE INDEX
	CMP	DH,0			;LINE 1?
	JNZ	DOUP			;NO
	MOV	AX,701H			;ELSE, SCROLL DOWN
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTR
	INT	10H
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	CURPOS,DX
	RET
;
DOUP:	MOV	DX,CURPOS		;CURSOR UP
DOUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP	SHORT SETCURS
;
DODWN:	MOV	DX,CURPOS		;CURSOR DOWN
DODWN1:	CMP	DH,24			;AT BOTTOM LINE?
	JZ	DODWN2			;IF SO, NO SCROLL
	INC	DH
	CMP	DH,23
	JLE	SETCURS
DODWN2:	RET
;
TAB:	MOV	DX,CURPOS		;PROCESS TABS
	ADD	DL,8
	AND	DL,0F8H			;MOV TO NEXT TAB STOP
	CMP	DL,79			;CHECK NEW POSITION
	JB	SETCURS			;IT'S OK
	MOV	DL,79			;ELSE, FORCE TO LAST COLUMN
	JMP	SETCURS
;
DORT:	MOV	DX,CURPOS		;CURSOR RIGHT
	INC	DL
DORT1:	CMP	DL,79
	JBE	SETCURS
	RET				;CURSOR IN LAST COLUMN
;
DOLFT:	MOV	DX,CURPOS		;CURSOR LEFT
	DEC	DL
	CMP	DL,0
	JAE	SETCURS
	RET				;CURSOR IN FIRST COLUMN

DOHOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,ATTR
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP	SHORT DOHOME
;
ERSEOL:	MOV	DX,CURPOS		;ERASE TO END OF LINE
	MOV	AX,600H
	MOV	BH,ATTR
	MOV	CX,DX
	MOV	DL,79
	INT	10H
	RET
;
ERSEOS:	MOV	DX,CURPOS		;ERASE TO END OF SCREEN
	MOV	AX,600H
	MOV	BH,ATTR			;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,ATTR
	INT	10H
ERS_RET:RET

ERSLIN:	MOV	DX,CURPOS		;ERASE LINE
	MOV	CX,DX
	MOV	CL,0
	MOV	DL,79
	MOV	AX,0600H		;SCROLL REGION (SINGLE LINE) CLEAR
	MOV	BH,ATTR
	INT	10H
	RET
;
SAVCRS:	MOV	DX,CURPOS		;SAVE CURSOR POSITION
	MOV	CURSAV,DX
	RET
;
RSTCRS:	MOV	DX,CURSAV		;RESTORE CURSOR POSITION
	JMP	SETCURS
;
DOREV:	MOV	AL,HIATTR
	MOV	ATTR,AL			;SET REV. VIDEO
	RET
;
DONRM:	MOV	AL,DFATTR
	MOV	ATTR,AL			;SET NOR. VIDEO
	RET

SETMOD:	MOV	WORD PTR IBMJMP,OFFSET SETMOD1	;GET NEXT CHAR
	RET
SETMOD1:CMP	AL,'5'				;CURSOR OFF?
	JNZ	IGNORE				;NO, IGNORE
	MOV	BH,0
	MOV	CX,2020H
	MOV	AH,1
	INT	10H				;ELSE, KILL CURSOR
IGNORE:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	RET

RESMOD:	MOV	WORD PTR IBMJMP,OFFSET RESMOD1	;GET NEXT CHAR
	RET
RESMOD1:CMP	AL,'5'				;CURSOR OFF?
	JNZ	IGNORE				;NO, IGNORE
	MOV	BH,0
	MOV	CX,CURTYP
	MOV	AH,1
	INT	10H				;ELSE, ENABLE CURSOR
	JMP	IGNORE

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
MEMADR	DW	0B800H
CURTYP	DW	0
CURPOS	DW	0
GRAFLG	DB	0			;GRAPHICS MODE FLAG
ATTR	DB	(BGC SHL 4)+FGC		;DEFAULT ATTRIBUTE
SAV_ROW	DB	0			;SAVED ROW POSITION
CURSAV	DW	0			;SAVED CURSOR POSITION
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'K'
	DW	OFFSET ERSEOL
	DB	'A'
	DW	OFFSET DOUP
	DB	'B'
	DW	OFFSET DODWN
	DB	'C'
	DW	OFFSET DORT
	DB	'D'
	DW	OFFSET DOLFT
	DB	'H'
	DW	OFFSET DOHOME
	DB	'I'
	DW	OFFSET REVIND
	DB	'l'
	DW	ERSLIN
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'j'
	DW	OFFSET SAVCRS
	DB	'k'
	DW	OFFSET RSTCRS
	DB	'x'
	DW	OFFSET SETMOD
	DB	'y'
	DW	OFFSET RESMOD
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH	LABEL	BYTE
	db	0f9h	; ^
	db	0dbh	; _
	db	0b3h	; `
	db	0c4h	; a
	db	0c5h	; b
	db	0bfh	; c
	db	0d9h	; d
	db	0c0h	; e
	db	0dah	; f
	db	0f1h	; g
	db	01ah	; h
	db	0b1h	; i
	db	0f6h	; j
	db	019h	; k
	db	0dah	; l
	db	0dbh	; m
	db	0d9h	; n
	db	0dbh	; o
	db	0dfh	; p
	db	0deh	; q
	db	0dbh	; r
	db	0c2h	; s
	db	0b4h	; t
	db	0c1h	; u
	db	0c3h	; v
	db	0dbh	; w
	db	0dbh	; x
	db	0dbh	; y
	db	0dbh	; z
	db	0dbh	; {
	db	0dbh	; |
	db	0dbh	; }
	db	014h	; ~
	db	0dbh	; del

;	Z-100 COMMAND TABLE

ZCMDTBL	DB	0B1H
	DW	OFFSET BOTTOM
	DB	0B2H
	DW	OFFSET PLINE
	DB	0B3H
	DW	OFFSET PPAGE
	DB	0B4H
	DW	OFFSET LWINDOW
	DB	0B6H
	DW	OFFSET RWINDOW
	DB	0B7H
	DW	OFFSET TOP
	DB	0B8H
	DW	OFFSET MLINE
	DB	0B9H
	DW	OFFSET MPAGE
	DB	0A5H
	DW	OFFSET MLINE
	DB	0A6H
	DW	OFFSET PLINE
	DB	0A7H
	DW	OFFSET RWINDOW
	DB	0A8H
	DW	OFFSET LWINDOW
	DB	0E5H
	DW	OFFSET MPAGE
	DB	0E6H
	DW	OFFSET PPAGE
	DB	0A9H
	DW	OFFSET TOP
	DB	0E9H
	DW	OFFSET BOTTOM
	DB	4CH
	DW	OFFSET JLEFT
	DB	6CH
	DW	OFFSET JLEFT
	DB	97H
	DW	OFFSET FIND
	DB	98H
	DW	OFFSET MARK
	DB	99H
	DW	OFFSET PRINT
	DB	9AH
	DW	OFFSET NEXT
	DB	9BH
	DW	OFFSET REWIND
	DB	0D8H
	DW	OFFSET MARKB
	DB	0D7H
	DW	OFFSET TCASE
	DB	95H
	DW	OFFSET HELP
	DB	68H
	DW	OFFSET HELP
	DB	48H
	DW	OFFSET HELP
	DB	0			;END OF TABLE

;	PC COMMAND TABLE

PCMDTBL	DB	47H
	DW	OFFSET TOP
	DB	48H
	DW	OFFSET MLINE
	DB	49H
	DW	OFFSET MPAGE
	DB	4BH
	DW	OFFSET LWINDOW
	DB	4DH
	DW	OFFSET RWINDOW
	DB	4FH
	DW	OFFSET BOTTOM
	DB	50H
	DW	OFFSET PLINE
	DB	51H
	DW	OFFSET PPAGE
	DB	26H
	DW	OFFSET JLEFT
	DB	3BH
	DW	OFFSET FIND
	DB	3CH
	DW	OFFSET MARK
	DB	3DH
	DW	OFFSET PRINT
	DB	3EH
	DW	OFFSET NEXT
	DB	3FH
	DW	OFFSET REWIND
	DB	55H
	DW	OFFSET MARKB
	DB	54H
	DW	OFFSET TCASE
	DB	23H
	DW	OFFSET HELP
	DB	0			;END OF TABLE

;	PC TO Z-100 COLOR TRANSLATE TABLE

COLTBL	DB	0,1,4,5,2,3,6,7

;	VARIABLES AND BUFFER

FTFLG	DB	0			;FIRST TIME FLAG
MEMTOP	DW	0			;MEMORY TOP
BUFSIZE	DW	0			;BUFFER SIZE
BUFSEG	DW	0			;BUFFER SEGMENT
FNAME	DW	0			;FILE NAME ADDRESS
HANDLE	DW	0			;FILE HANDLE
DISPLAY	DB	0			;DISPLAY TYPE
TTYPE	DB	1			;TERMINAL TYPE FLAG
LSTCHR	DB	0			;LAST CHARACTER (Z-100)
ROMSEG	DW	0			;Z-100 ROM DATA SEGMENT
CURADR	DW	291H			;Z-100 CURSOR POSITION ADDRESS
LCFLG	DB	0			;LAST COLUMN FLAG
TXTSTRT	DW	0			;START OF TEXT
TXTEND	DW	0			;END OF TEXT
RDEND	DW	0			;END OF READING
ENDCNT	DB	0			;COUNT BETWEEN RDEND AND TXTEND
LINCNT	DW	1			;LINE COUNTER (PRESET TO 1)
LINSTRT	DW	0			;FIRST LINE NUMBER
CURLIN	DW	0			;CURRENT LINE NUMBER
TPADR	DW	0			;TOP PAGE ADDRESS IN FILE
BPADR	DW	0			;BOTTOM PAGE ADDRESS IN FILE
LASTPG	DW	0			;LAST PAGE POINTER
TMADR	DW	0			;TOP MARK ADDRESS
BMADR	DW	0			;BOTTOM MARK ADDRESS
MVFLG	DB	0			;MARKED VIDEO FLAG
NEXTFLG	DB	0			;"NEXT" FLAG
NRFLG	DB	0			;NEXT/REWIND ENABLE FLAG
FLAGL	EQU	$-TXTSTRT		;LENGTH OF FLAGS
PFLAG	DB	0			;PRINT FLAG
WPOS	DB	0			;WINDOW POSITION
MPFLG	DB	0			;MINUS PAGE FLAG
LINLEN	DB	0			;LINE INPUT LENGTH
STRIP	DB	07FH			;HIGH BIT STRIPPER
LCBIT	DB	20H			;LOWER CASE BIT

	EVEN
BA:					;BUFFER AREA
BUFF	STRUC
TSBUF	DB	8 DUP (?)		;TAB STOP BUFFER
	DB	255 DUP (?)
STACK	DB	?			;STACK (ACTUALLY AT PRVSTR)
PRVSTR	DB	40 DUP (?)		;PREVIOUS LINE INPUT
SCHLIN	DB	40 DUP (?)		;SEARCH LINE
LINBUF	DB	40 DUP (?)		;LINE INPUT BUFFER
BUFFER	DB	?			;BUFFER STARTS HERE
BUFF	ENDS

SEE	ENDS
	END	START
