;;;	zsio - CIOS for MITE utility / Altos Computer (ZSIO)
;
;	L.E. Hughes
;
;	Mycroft Labs, Inc.
;	P.O. Box 6045
;	Tallahassee, FL 32301
;
;	(904) 385-2708

data	equ	01CH
stat	equ	01DH
rate	equ	0DH

x16	equ	01000111B
x64	equ	00000111B

cr	equ	0DH		;carriage return
lf	equ	0AH		;line feed
eos	equ	'$'		;end of string
 
	org	180H

;;	jump vector
;
 
	jmp	initm
	jmp	modin
	jmp	modout
	jmp	chkrr
	jmp	chktr
	jmp	chkcd
	jmp	chkpe
	jmp	chkfe
	jmp	chkoe
	jmp	chkri
	jmp	setbr
	jmp	setpar
	jmp	set8db
	jmp	set2sb
	jmp	setorg
	jmp	setoh
	jmp	settxe
	jmp	setbrk
	jmp	dial
	jmp	tenths
	jmp	w1ms

;;;	initm - initialize modem
;

initm:	mvi	a,0		;select write reg 0
	out	stat
	mvi	a,4		;select write reg 4
	out	stat
	mvi	a,01000111b	;16x clk, 1 sbit, even parity
	out	stat
	sta	cr4
	mvi	a,1		;select write reg 1
	out	stat
	mvi	a,00000000b	;disable all interrupts
	out	stat
	mvi	a,3		;select write reg 3
	out	stat
	mvi	a,01000001b	;7 dbits on rx, rx enable
	out	stat
	sta	cr3
	mvi	a,5		;select write reg 5
	out	stat
	mvi	a,10101010b	;7 dbits on tx, enable tx, dtr, rts
	out	stat
	sta	cr5
	ret
 
;;;	modin - input character from modem
;
;	exit:	A	character from modem
 
modin:	in	data
	push	h
	lxi	h,mask
	ana	m
	pop	h
	ret

;;;	modout - output character to modem
;
;	entry:	A	character for modem

modout:	out	data
	ret
 
;;;	chkrr - check for receiver ready
;
;	exit:	c-flag	set if character available

chkrr:	call	rsr0
	ani	01H
	jz	chkrr1
	stc
	ret
chkrr1:	ora	a
	ret
 
;;;	chktr - check for tranmitter ready
;
;	exit:	c-flag	set if transmitter ready

chktr:	call	rsr0
	ani	04H
	jz	chktr1
	stc
	ret
chktr1:	ora	a
	ret

;;	chkcd - check for carrier detect
;
;	exit:	c-flag	set if carrier present

chkcd:	mvi	a,10H
	out	stat
	call	rsr0
	ani	08H
	jz	chkcd1
	stc
	ret
chkcd1:	ora	a
	ret

;;;	chkpe - check for parity error
;
;	exit:	c-flag set if parity error
 
chkpe:	call	rsr1
	ani	10H
	jz	chkpe1
	mvi	a,6 shl 3
	out	stat
	stc
	ret
chkpe1:	ora	a
	ret
 
;;;	chkfe - check for frame error
;
;	exit:	c-flag set if frame error
 
chkfe:	call	rsr1
	ani	40H
	jz	chkfe1
	stc
	ret
chkfe1:	ora	a
	ret
 
;;;	chkoe - check for overrun error
;
;	exit:	c-flag set if overrun error
 
chkoe:	call	rsr1
	ani	20H
	jz	chkoe1
	mvi	a,6 shl 3
	out	stat
	stc
	ret
chkoe1:	ora	a
	ret
 
;;;	chkri - check for ring indicate
;
;	exit:	c-flag	set if incoming call
 
chkri:	stc
	ret
 
rsr0:	in	stat
	ret
 
rsr1:	mvi	a,1
	out	stat
	in	stat
	ret
 
;;;	setbr - set baud rate
;
;	entry:	HL	baud rate
;
;	exit:	c-flag	set if error
 
setbr:	lxi	d,110		;jump if not 110
	call	cmpde
	jnz	setr2
	mvi	b,x64
	mvi	c,08DH
	jmp	setrx
setr2:	lxi	d,300		;jump if not 300
	call	cmpde
	jnz	setr3
	mvi	b,x64
	mvi	c,34H
	jmp	setrx
setr3:	lxi	d,600		;jump if not 600
	call	cmpde
	jnz	setr4
	mvi	b,x64
	mvi	c,01AH
	jmp	setrx
setr4:	lxi	d,1200		;jump if not 1200
	call	cmpde
	jnz	setr5
	mvi	b,x64
	mvi	c,0DH
	jmp	setrx
setr5:	lxi	d,2400		;jump if not 2400
	call	cmpde
	jnz	setr6
	mvi	b,x16
	mvi	c,34H
	jmp	setrx
setr6:	lxi	d,4800		;jump if not 4800
	call	cmpde
	jnz	setr7
	mvi	b,x16
	mvi	c,1AH
	jmp	setrx
setr7:	lxi	d,9600		;jump if not 9600
	call	cmpde
	jnz	setrE
	mvi	b,x16
	mvi	c,0DH
setrx:	mov	a,b		;program CTC
	out	rate
	mov	a,c
	out	rate
	ora	a		;normal exit
	ret
setrE:	stc			;error exit
	ret
 
;;;	setpar - set parity
;
;	entry:	A	parity select code:
;				0 = none
;				1 = odd
;				2 = even
;

setpar:	ora 	a
	jnz	setp1
	mvi	b,01H
	jmp	cr4off
setp1:	dcr	a		;jump if A .ne. 1
	jnz	setp2
	mvi	b,02H
	call	cr4off
	mvi	b,01H
	jmp	cr4on
setp2:	mvi	b,02H
	call	cr4on
	mvi	b,01H
	jmp	cr4on

;;;	set8db - set number of data bits
;
;	entry:	A	data bits select code:
;				0 = 7 data bits
;				1 = 8 data bits

set8db:	ora	a		;jump if A .ne. 0
	jnz	set8d1
	mvi	b,80H
	call	cr3off
	mvi	b,40H
	call	cr5off
	mvi	a,7FH
	sta	mask
	ret
set8d1:	mvi	b,80H
	call	cr3on
	mvi	b,40H
	call	cr5on
	mvi	a,0FFH
	sta	mask
	ret
 
;;;	set2sb - set number of stop bits
;
;	entry:	A	stop bits select code:
;				0 = 1 stop bit
;				1 = 2 stop bits
 
set2sb:	ora	a		;jump if A .ne. 0
	jnz	set2s1
	mvi	b,08H
	jmp	cr4off
set2s1:	mvi	b,08H
	jmp	cr4on
 
;;;	setorg - set modem mode (answer or originate)
;
;	entry:	A	mode select code:
;				0 = answer
;				1 = originate

setorg:	ret
 
;;;	setoh - set phone "off hook"
;
;	entry:	A	hook select code:
;				0 = on hook (hung up)
;				1 = off hook
 
setoh:	ora	a
	jnz	setoh1
	mvi	b,80H
	jmp	cr5off
setoh1:	mvi	b,80H
	jmp	cr5on

;;;	settxe - set transmitter enable
;
;	entry:	A	transmitter enable code:
;				0 = disabled
;				1 = enabled
 
settxe:	ret
	
;;;	setbrk - set communications line break
;
;	entry:	A	break enable code:
;				0 = normal
;				1 = break
 
setbrk:	ora	a		;jump if A .ne. 0 (break)
	jnz	setbk1
	mvi	b,10H
	jmp	cr5off
setbk1:	mvi	b,10H
	jmp	cr5on

 
;;	cr3on - turn on bit(s) on modem control reg. three
;
;	entry conditions
;
;		b	ones in positions to turn on
 
cr3on:	push	psw
	mvi	a,3
	out	stat
	lda	cr3
	ora	b
	sta	cr3
	out	stat
	pop	psw
	ret
 
;;	cr3off - turn bit(s) off on modem control reg. three
;
;	entry conditions
;
;		b	ones in positions to turn off
 
cr3off:	push	psw
	mvi	a,3
	out	stat
	mov	a,b
	cma
	mov	b,a
	lda	cr3
	ana	b
	sta	cr3
	out	stat
	pop	psw
	ret
 
;;	cr4on - turn on bit(s) on modem control reg. four
;
;	entry conditions
;
;		b	ones in positions to turn on
 
cr4on:	push	psw
	mvi	a,4
	out	stat
	lda	cr4
	ora	b
	sta	cr4
	out	stat
	jmp	cr4x
 
;;	cr4off - turn bit(s) off on modem control reg. four
;
;	entry conditions
;
;		b	ones in positions to turn off
 
cr4off:	push	psw
	mvi	a,4
	out	stat
	mov	a,b
	cma
	mov	b,a
	lda	cr4
	ana	b
	sta	cr4
	out	stat
cr4x:	mvi	a,3
	out	stat
	lda	cr3
	out	stat
	mvi	a,5
	out	stat
	lda	cr5
	out	stat
	pop	psw
	ret
 
;;	cr5on - turn on bit(s) on modem control reg. five
;
;	entry conditions
;
;		b	ones in positions to turn on
 
cr5on:	push	psw
	mvi	a,5
	out	stat
	lda	cr5
	ora	b
	sta	cr5
	out	stat
	pop	psw
	ret
 
;;	cr5off - turn bit(s) off on modem control reg. five
;
;	entry conditions
;
;		b	ones in positions to turn off
 
cr5off:	push	psw
	mvi	a,5
	out	stat
	mov	a,b
	cma
	mov	b,a
	lda	cr5
	ana	b
	sta	cr5
	out	stat
	pop	psw
	ret
 
;;;	cmpde - compare de to hl
;
;	exit:	c-flag	set if de < hl
;		z-flag	set if de = hl

cmpde:	mov	a,h
	cmp	d
	rnz
	mov	a,l
	cmp	e
	ret
 
;;;	dial - dial phone number
;
;	entry:	HL	points to phone number, term by 0 byte

dial:	push	h
	lxi	d,str1		;point to header string
	call	wasm		;write to 'modem'
	pop	h
dial1:	mov	a,m		;fetch next digit
	ora	a		;jump if end of string
	jz	dial2
	call	wacm		;write to modem
	inx	h
	jmp	dial1
dial2:	mvi	a,cr		;issue CR
	call	wacm
	ret

;;	wasm - write ASCII string to modem
;
 
wasm:	ldax	d
	cpi	'$'
	rz
	call	wacm
	inx	d
	jmp	wasm
 
;;	wacm - write ASCII character to modem
;
 
wacm:	push	psw
wacm1:	call	chktr
	jnc	wacm1
	pop	psw
	jmp	modout
 
;;	racm - read ASCII character from modem
;
 
racm:	call	chkrr
	jnc	racm
	jmp	modin
 
;;	tenths - wait B tenths of a second
;
;	entry:	B	number of tenths of a second to wait

tenths:	call	tenth
	dcr	b
	jnz	tenths
	ret
 
;;	tenth - wait 1 tenth of a second
;
 
tenth:	push	b
	mvi	b,100
tenth1:	call	w1ms
	dcr	b
	jnz	tenth1
	pop	b
	ret

;;	w1ms - wait one millisecond
;
 
w1ms:	push	psw
	push	h
	lxi	h,160
w1ms1:	dcx	h
	mov	a,h
	ora	l
	jnz	w1ms1
	pop	h
	pop	psw
	ret
 
str1:	db	cr,'AT D$'	;SMARTMODEM dial header
 
mask:	ds	1		;mask for 7/8 data bits

cr3:	ds	1
cr4:	ds	1
cr5:	ds	1
 
	end	zsio
