;;;	os1 - MITE CIOS for Osborne OS-1
;
;	L.E. Hughes
;
;	Mycroft Labs, Inc.
;	P.O. Box 6045
;	Tallahassee, FL 32301
;
;	(904) 385-2708

rstat	equ	0780H		;read status port
rdata	equ	0783H		;read data port
wstat	equ	0786H		;write status port
wdata	equ	0789H		;write data port
 
cr	equ	0DH		;carriage return
lf	equ	0AH		;line feed
eos	equ	'$'		;end of string
 
	org	180H

;;	jump vector
;
 
	jmp	initm
	jmp	modin
	jmp	modout
	jmp	chkrr
	jmp	chktr
	jmp	chkcd
	jmp	chkpe
	jmp	chkfe
	jmp	chkoe
	jmp	chkri
	jmp	setbr
	jmp	setpar
	jmp	set8db
	jmp	set2sb
	jmp	setorg
	jmp	setoh
	jmp	settxe
	jmp	setbrk
	jmp	dial
	jmp	tenths
	jmp	w1ms
 
;;;	initm - initialize modem
;;

initm:	mvi	a,01001010B
	sta	cr1
	call	wstat
	ret
 
;;;	modin - input character from modem
;
;	exit:	A	character from modem
 
modin:	call	rdata		;read data port
	ret

;;;	modout - output character to modem
;
;	entry:	A	character for modem

modout:	call	wdata		;write data port
	ret
 
;;;	chkrr - check for receiver ready
;
;	exit:	c-flag	set if character available

chkrr:	call	rstat		;check status port 1
	ani	01H		;mask off data avail. bit
	jz	chkrr1		;exit if no data available
	stc			;exit with carry set
	ret
chkrr1:	ora	a
	ret

;;;	chktr - check for tranmitter ready
;
;	exit:	c-flag	set if transmitter ready

chktr:	call	rstat		;check status port 1
	ani	02H		;mask off trans. ready bit
	jz	chktr1		;exit if not ready
	stc			;exit with carry set
	ret
chktr1:	ora	a
	ret

;;	chkcd - check for carrier detect
;
;	exit:	c-flag	set if carrier present

chkcd:	call	rstat
	ani	04h
	jnz	chkcd1
	stc
	ret
chkcd1:	call	rstat
	call	rdata
	call	rstat
	ani	04h
	jnz	chkcd2
	stc
	ret
chkcd2:	ora	a
	ret

;;;	chkpe - check for parity error
;
;	exit:	c-flag set if parity error
 
chkpe:	call	rstat		;check status port 0
	ani	40H		;mask off parity error bit
	jz	chkpe		;exit if no parity error
	stc			;return with carry set
	ret
chkpe1:	ora	a
	ret
	
;;;	chkfe - check for frame error
;
;	exit:	c-flag set if frame error
 
chkfe:	call	rstat		;check status port 0
	ani	10H		;mask off frame error bit
	jz	chkfe1		;exit if no frame error
	stc			;return with carry set
	ret
chkfe1:	ora	a
	ret

;;;	chkoe - check for overrun error
;
;	exit:	c-flag set if overrun error
 
chkoe:	call	rstat		;check status port 0
	ani	20H		;mask off overrun error bit
	jz	chkoe1		;exit if no overrun error
	stc			;return with carry set
	ret
chkoe1:	ora	a
	ret
 	
;;;	chkri - check for ring indicate
;
;	exit:	c-flag	set if incoming call
 
chkri:	stc
	ret

;;;	setbr - set baud rate
;
;	entry:	HL	baud rate
;
;	exit:	c-flag	set if error
 
setbr:	lxi	d,300
	call	cmpde
	jnz	setb1
	mvi	b,00000011B
	call	cr1off
	mvi	b,00000010B
	call	cr1on
	ora	a
	ret
setb1:	lxi	d,1200
	call	cmpde
	jnz	setb2
	mvi	b,00000011B
	call	cr1off
	mvi	b,00000001B
	call	cr1on
	ora	a
	ret
setb2:	stc
	ret
 
;;;	setpar - set parity
;
;	entry:	A	parity select code:
;				0 = NONE
;				1 = ODD
;				2 = EVEN

setpar:	add	a		;b = parity code shl 2
	add	a
	mov	b,a
	lda	fmt		;fetch format code
	ani	00000011B	;retain other bits
	ora	b		;or in new ones
	sta	fmt		;save it back
	lxi	h,fmttbl	;index into format table
	mov	c,a
	mvi	b,0
	dad	b
	mov	a,m		;fetch acia format bits
	cpi	8		;exit if illegal
	rz
	add	a		;shift format bits into position 
	add	a
	mov	b,a
	push	b		;strip old format bits
	mvi	b,0011100B
	call	cr1off
	pop	b
	jmp	cr1on		;set new ones

;;;	set8db - set number of data bits
;
;	entry:	A	data bits select code:
;				0 = 7 data bits
;				1 = 8 data bits

set8db:	add	a		;b = parity code shl 1
	mov	b,a
	lda	fmt		;fetch format code
	ani	00001101B	;retain other bits
	ora	b		;or in new ones
	sta	fmt		;save it back
	lxi	h,fmttbl	;index into format table
	mov	c,a
	mvi	b,0
	dad	b
	mov	a,m		;fetch acia format bits
	cpi	8		;exit if illegal
	rz
	add	a		;shift format bits into position 
	add	a
	mov	b,a
	push	b		;strip old format bits
	mvi	b,0011100B
	call	cr1off
	pop	b
	jmp	cr1on		;set new ones

;;;	set2sb - set number of stop bits
;
;	entry:	A	stop bits select code:
;				0 = 1 stop bit
;				1 = 2 stop bits
 
set2sb:	mov	b,a		;b = parity code
	lda	fmt		;fetch format code
	ani	00001110B	;retain other bits
	ora	b		;or in new ones
	sta	fmt		;save it back
	lxi	h,fmttbl	;index into format table
	mov	c,a
	mvi	b,0
	dad	b
	mov	a,m		;fetch acia format bits
	cpi	8		;exit if illegal
	rz
	add	a		;shift format bits into position 
	add	a
	mov	b,a
	push	b		;strip old format bits
	mvi	b,0011100B
	call	cr1off
	pop	b
	jmp	cr1on		;set new ones

;;;	setorg - set modem mode (answer or originate)
;
;	entry:	A	mode select code:
;				0 = answer
;				1 = originate

setorg:	ret
 
;;;	setoh - set phone "off hook"
;
;	entry:	A	hook select code:
;				0 = on hook (hung up)
;				1 = off hook
 
setoh:	ret

;;;	settxe - set transmitter enable
;
;	entry:	A	transmitter enable code:
;				0 = disabled
;				1 = enabled
 
settxe:	ret
 
;;;	setbrk - set communications line break
;
;	entry:	A	break enable code:
;				0 = normal
;				1 = break
 
setbrk:	ora	a		;jump if A .ne. 0 (break)
	jnz	setbk1
	mvi	b,60H
	jmp	cr1off
setbk1:	mvi	b,60H
	jmp	cr1on

;;;	cr1on - turn on bit(s) on modem control register one
;
;	entry:	B	ones in bit position(s) to turn on

cr1on:	push	psw
	lda	cr1
	ora	b
	sta	cr1
	call	wstat
	pop	psw
	ret
 
;;;	cr1off - turn off bit(s) on modem control register one
;
;	entry:	B	ones in bit position(s) to turn off

cr1off:	push	psw
	mov	a,b
	cma
	mov	b,a
	lda	cr1
	ana	b
	sta	cr1
	call	wstat
	pop	psw
	ret
 
;;;	cmpde - compare de to hl
;
;	exit:	c-flag	set if de < hl
;		z-flag	set if de = hl

cmpde:	mov	a,h
	cmp	d
	rnz
	mov	a,l
	cmp	e
	ret
 
;;;	dial - dial phone number
;
;	entry:	HL	points to phone number, term by 0 byte

dial:	ret

;;	tenths - wait B tenths of a second
;
;	entry:	B	number of tenths of a second to wait

tenths:	call	tenth
	dcr	b
	jnz	tenths
	ret
 
;;	tenth - wait 1 tenth of a second
;
 
tenth:	push	b
	mvi	b,100
tenth1:	call	w1ms
	dcr	b
	jnz	tenth1
	pop	b
	ret

;;	wait50 - wait 50 msec
;
 
wait50:	push	b
	mvi	b,50
wait51:	call	w1ms
	dcr	b
	jnz	wait51
	pop	b
	ret
 
;;	w1ms - wait one millisecond
;
 
w1ms:	push	psw
	push	h
	lxi	h,80
w1ms1:	dcx	h
	mov	a,h
	ora	l
	jnz	w1ms1
	pop	h
	pop	psw
	ret

				;parity	dbits	sbits 
 
fmttbl:	db	8		;NONE	7	1	(illegal)
	db	8		;NONE	7	2	(illegal)
	db	5		;NONE	8	1
	db	4		;NONE	8	2
	db	3		;ODD	7	1
	db	1		;ODD	7	2
	db	7		;ODD	8	1
	db	8		;ODD	8	2	(illegal)
	db	2		;EVEN	7	1
	db	0		;EVEN	7	2
	db	6		;EVEN	8	1
	db	8		;EVEN	8	2	(illegal)

fmt:	ds	1		;ACIA format code
cr1:	ds	1		;current control register 1

	end	os1
