;;;	zenith - CIOS for MITE utility / Zenith Z89, Smartmodem verison
;
;	L.E. Hughes
;
;	Mycroft Labs, Inc.
;	P.O. Box 6045
;	Tallahassee, FL 32301
;
;	(904) 385-2708

z89ser	equ	0D8H		;serial port
 
cr	equ	0DH		;carriage return
lf	equ	0AH		;line feed
eos	equ	'$'		;end of string

sminit	equ	11CH		;location of smart modem init string
predil	equ	167H		;location of smart modem pre-dial str
number	equ	148H		;location of phone number
adtyp	equ	146H		;location of adtyp in main module
 
	org	180H

;;	jump vector
;
 
	jmp	initm
	jmp	modin
	jmp	modout
	jmp	chkrr
	jmp	chktr
	jmp	chkcd
	jmp	chkpe
	jmp	chkfe
	jmp	chkoe
	jmp	chkri
	jmp	setbr
	jmp	setpar
	jmp	set8db
	jmp	set2sb
	jmp	setorg
	jmp	setoh
	jmp	settxe
	jmp	setbrk
	jmp	dial
	jmp	tenths
	jmp	w1ms
	jmp	exit

;;;	initm - initialize modem
;

initm:	mvi	a,00000000B
	out	z89ser+1	;disable interrupts on serial port
	mvi	a,00011010B	;even parity, 7 db, 1 sb
	out	z89ser+3
	mvi	a,00000001B	;raise dtr
	out	z89ser+4
	call	initsm		;initialize smart modem
	ret
 
;;;	initsm - initialize smart modem
;
;

initsm:	lxi	d,sminit	;point to init string
	ldax	d		;get character
	cpi	' '
	rz			;exit if first char blank
	call	wasmx		;write string to modem
	ret

 
;;;	exit - exit routine after leaving MITE
;
;

exit:	ret
 
;;;	modin - input character from modem
;
;	exit:	A	character from modem
 
modin:	in	z89ser+0	;read data port
	ret

;;;	modout - output character to modem
;
;	entry:	A	character for modem

modout:	out	z89ser+0	;write data port
	ret
 
;;;	chkrr - check for receiver ready
;
;	exit:	c-flag	set if character available

chkrr:	in	z89ser+5
	ani	01H
	jz	chkrr1
	stc
	ret
chkrr1:	ora	a
	ret
 
;;;	chktr - check for tranmitter ready
;
;	exit:	c-flag	set if transmitter ready

chktr:	in	z89ser+5
	ani	20H
	jz	chktr1
	stc
	ret
chktr1:	ora	a
	ret

;;	chkcd - check for carrier detect
;
;	exit:	c-flag	set if carrier present

chkcd:	in	z89ser+6
	ani	80H
	jz	chkcd1
	stc
	ret
chkcd1:	ora	a
	ret

;;;	chkpe - check for parity error
;
;	exit:	c-flag set if parity error
 
chkpe:	in	z89ser+5
	ani	04H
	jz	chkpe1
	stc
	ret
chkpe1:	ora	a
	ret
 
;;;	chkfe - check for frame error
;
;	exit:	c-flag set if frame error
 
chkfe:	in	z89ser+5
	ani	08H
	jz	chkfe1
	stc
	ret
chkfe1:	ora	a
	ret
 
;;;	chkoe - check for overrun error
;
;	exit:	c-flag set if overrun error
 
chkoe:	in	z89ser+5
	ani	02H
	jz	chkoe1
	stc
	ret
chkoe1:	ora	a
	ret
 
;;;	chkri - check for ring indicate
;
;	exit:	c-flag	set if incoming call
 
chkri:	stc
	ret
 
;;;	setbr - set baud rate
;
;	entry:	HL	baud rate
;
;	exit:	c-flag	set if error
 
setbr:	push	h
	lxi	d,75		;error exit if baud rate < 75
	call	cmpde
	jc	setbrx
	lxi	d,9601		;error exit if baud rate > 9600
	call	cmpde
	cmc
	jc	setbrx
	call	div2		;divide by 2
	xchg			;move it into DE
	lxi	h,57850		;HL = constant to divide into
	lxi	b,0		;BC = 0
setbr1:	mov	a,l		;HL = HL - DE
	sub	e
	mov	l,a
	mov	a,h
	sbb	d
	mov	h,a
	jc	setbr2		;jump if negative
	inx	b		;BC = BC + 1
	jmp	setbr1		;loop
setbr2:	mov	h,b		;save constant
	mov	l,c
	in	z89ser+3	;set baud rate
	ori	80H
	out	z89ser+3
	mov	a,b
	out	z89ser+1
	mov	a,c
	out	z89ser+0
	in	z89ser+3
	ani	7FH
	out	z89ser+3
	ora	a
	pop	h
	ret
setbrx:	stc
	pop	h
	ret

div2:	ora	a
	mov	a,h
	rar
	mov	h,a
	mov	a,l
	rar
	mov	l,a
	ret

;;;	setpar - set parity
;
;	entry:	A	parity select code:
;				0 = NONE
;				1 = ODD
;				2 = EVEN

setpar:	ora	a		;jump if A .ne. 0
	jnz	setp1
	mvi	b,08H
	jmp	cr3off
setp1:	dcr	a		;jump if A .ne. 1
	jnz	setp2
	mvi	b,10H
	call	cr3off
	mvi	b,08H
	jmp	cr3on
setp2:	mvi	b,10H
	call	cr3on
	mvi	b,08H
	jmp	cr3on

;;;	set8db - set number of data bits
;
;	entry:	A	data bits select code:
;				0 = 7 data bits
;				1 = 8 data bits

set8db:	ora	a		;jump if A .ne. 0
	jnz	set8d1
	mvi	b,01H
	jmp	cr3off
set8d1:	mvi	b,01H
	jmp	cr3on
 
;;;	set2sb - set number of stop bits
;
;	entry:	A	stop bits select code:
;				0 = 1 stop bit
;				1 = 2 stop bits
 
set2sb:	ora	a		;jump if A .ne. 0
	jnz	set2s1
	mvi	b,04H
	jmp	cr3off
set2s1:	mvi	b,04H
	jmp	cr3on
 
;;;	setorg - set modem mode (answer or originate)
;
;	entry:	A	mode select code:
;				0 = answer
;				1 = originate

setorg:	mov	b,a
	lda	adtyp
	cpi	1		;check for pulse dial
	mov	a,b
	rnz
	ora	a		;check for originate
	jnz	setor1		;jump if so
	mvi	b,2		;set ready (rts)
	call	cr4on
	mvi	b,1		;clear adp (dtr)
	call	cr4off
	ret
setor1:	mvi	b,3		;clear ready and adp
	call	cr4off
	ret
 
;;;	setoh - set phone "off hook"
;
;	entry:	A	hook select code:
;				0 = on hook (hung up)
;				1 = off hook
 
setoh:	ora	a
	jnz	setoh1
	mvi	b,03H
	jmp	cr4off
setoh1:	mvi	b,01H
	jmp	cr4on

;;;	settxe - set transmitter enable
;
;	entry:	A	transmitter enable code:
;				0 = disabled
;				1 = enabled
 
settxe:	ret
 
;;;	setbrk - set communications line break
;
;	entry:	A	break enable code:
;				0 = normal
;				1 = break
 
setbrk:	ora	a		;jump if A .ne. 0 (break)
	jnz	setbk1
	mvi	b,40H
	jmp	cr3off
setbk1:	mvi	b,40H
	jmp	cr3on

;;;	cr3on - turn on bit(s) on modem control register three
;
;	entry:	B	ones in bit position(s) to turn on

cr3on:	push	psw
	in	z89ser+3
	ora	b
	out	z89ser+3
	pop	psw
	ret
 
;;;	cr3off - turn off bit(s) on modem control register three
;
;	entry:	B	ones in bit position(s) to turn off

cr3off:	push	psw
	mov	a,b
	cma
	mov	b,a
	in	z89ser+3
	ana	b
	out	z89ser+3
	pop	psw
	ret
 
;;;	cr4on - turn on bit(s) on modem control register four
;
;	entry:	B	ones in bit position(s) to turn on

cr4on:	push	psw
	in	z89ser+4
	ora	b
	out	z89ser+4
	pop	psw
	ret
 
;;;	cr4off - turn off bit(s) on modem control register four
;
;	entry:	B	ones in bit position(s) to turn off

cr4off:	push	psw
	mov	a,b
	cma
	mov	b,a
	in	z89ser+4
	ana	b
	out	z89ser+4
	pop	psw
	ret
 
;;;	cmpde - compare de to hl
;
;	exit:	c-flag	set if de < hl
;		z-flag	set if de = hl

cmpde:	mov	a,h
	cmp	d
	rnz
	mov	a,l
	cmp	e
	ret


;;;	dial - dial phone number
;
;	entry:	HL	points to phone number, term by 0 byte

dial:	lda	adtyp		;determine the modem dial type
	cpi	0		;check for hayes
	jz	dialt
	cpi	1		;check for pulse dial
	jz	dialp
	ret			;exit if neither (manual dial)
 
;;;	dialt - dial phone number (hayes method)
;
;	entry:	HL	points to phone number, term by 0 byte

dialt:	push	h
	lxi	d,predil	;point to header string
	call	wasmx		;write to 'modem'
	pop	h
dialt1:	mov	a,m		;fetch next digit
	ora	a		;jump if end of string
	jz	dialt3
	cpi	'^'		;check for control
	jnz	dialt2
	inx	h
	mov	a,m		;get character
	ora	a
	jz	dialt3
	ani	1FH		;make control char
dialt2:	call	wacm		;write to modem
	inx	h
	push	psw
	mvi	b,2
	call	tenths
	pop	psw
	cpi	cr		;check for return
	cz	racmx		;if so, wait for response
	jmp	dialt1
dialt3:	mvi	a,cr		;issue CR
	call	wacm
	ret
 
;;;	dialp - dial phone number pusle method
;
;	entry:	HL	points to phone number, term by 0 byte

dialp:	mov	a,m		;fetch next digit of number
	ora	a		;exit if zero
	rz
	inx	h		;increment pointer
	cpi	'*'		;jump if not asterisk
	jnz	dialp2
	mvi	b,10		;wait 1 second
	call	tenths
	jmp	dialp		;continue
dialp2:	sui	'0'		;convert ASCII to binary
	jc	dialp		;ignore if < '0'
	cpi	10		;ignore if > '9'
	jnc	dialp
	ora	a		;jump if not zero 
	jnz	dialp3
	mvi	a,10		;use 10 clicks for zero
dialp3:	mov	b,a		;b = number of clicks
dialp4:	push	b
	mvi	a,0
	call	setoh
	call	wait50		;wait 50 msec
	mvi	a,1
	call	setoh
	call	wait50		;wait 50 msec
	pop	b
	dcr	b		;decrement click count
	jnz	dialp4		;loop until zero
	mvi	b,7		;interdigit wait (.7 sec)
	call	tenths
	jmp	dialp

 
;;	racmx - read until no more
;

racmx:	push	b		;save bc
racmx0:	lxi	b,500		;.25 seconds w/o character
racmx1:	call	chkrr
	jc	racmx2		;jump if character
	call	w1ms		;wait a millisecond
	dcx	b
	mov	a,b
	ora	c
	jnz	racmx1		;loop if not done
	pop	b
	ret			;exit if done
racmx2:	call	modin		;get character
	jmp	racmx0		;try again

;;	wasmx - write ASCII string to modem with check
;

wasmx:	ldax	d
	inx	d		;update pointer
	ora	a		;check for end
	rz
	cpi	'^'		;check for control code
	jnz	wasmx1
	ldax	d
	inx	d
	ani	1FH		;convert to control
	cpi	'W'-40H		;check for wait
	jz	wasmx2
wasmx1:	call	wacm		;write character
	push	psw
	mvi	b,2
	call	tenths
	pop	psw
	cpi	cr		;check for return
	jnz	wasmx		;continue
wasmx2:	call	racmx		;wait for no response
	jmp	wasmx



;;;	wait50 - wait 50 milliseconds
;

wait50:	push	b
	mvi	b,70
wt50:	call	w1ms		;wait 1 ms
	dcr	b
	jnz	wt50		;do 50 times
	pop	b
	ret



;;	wasm - write ASCII string to modem
;
 
wasm:	ldax	d
	cpi	'$'
	rz
	call	wacm
	inx	d
	jmp	wasm
 
;;	wacm - write ASCII character to modem
;
 
wacm:	push	psw
wacm1:	call	chktr
	jnc	wacm1
	pop	psw
	jmp	modout
 
;;	racm - read ASCII character from modem
;
 
racm:	call	chkrr
	jnc	racm
	jmp	modin
 
;;	tenths - wait B tenths of a second
;
;	entry:	B	number of tenths of a second to wait

tenths:	call	tenth
	dcr	b
	jnz	tenths
	ret
 
;;	tenth - wait 1 tenth of a second
;
 
tenth:	push	b
	mvi	b,100
tenth1:	call	w1ms
	dcr	b
	jnz	tenth1
	pop	b
	ret

;;	w1ms - wait one millisecond
;
 
w1ms:	push	psw
	push	h
	lxi	h,80
w1ms1:	dcx	h
	mov	a,h
	ora	l
	jnz	w1ms1
	pop	h
	pop	psw
	ret
 
 
tocnt:	ds	2		;time-out count for RACM
timer:	ds	2		;msec timer for RACM

	end	zenith
