	PAGE	58
	TITLE	'Z-100 8085 PORTION OF CP/M+ BIOS'
;
; THE 8080 PORTION OF A Z-100 BANKED BIOS FOR CP/M-80 PLUS
;
	EXTRN	@CIVEC,@COVEC,@AIVEC,@AOVEC,@LOVEC,@BNKBF
	EXTRN	@CRDMA,@CRDSK,@VINFO,@RESEL,@USRCD,@FX
	EXTRN	@MLTIO,@ERMDE,@ERDSK,@MEDIA,@BFLGS
	EXTRN	@MXTPA,?ERJMP,@DATE,@HOUR,@MIN,@SEC
	EXTRN	@CNWDTH, @CNPGLN
;
MEMCTL	EQU	0FCH		;Z-100 MEMORY CONTROL PORT
PSP	EQU	0FEH		;PROCESSOR SWAP PORT
;
	CSEG			;THIS ALL GOES IN COMMON MEMORY
;
; BIOS JUMP TABLE
;
	JMP	BOOT		;COLD BOOT
WBE:	JMP	WBOOT		;WARM BOOT
	JMP	CONST		;CONSOLE STATUS
	JMP	CONIN		;CONSOLE INPUT
	JMP	CONOUT		;CONSOLE OUTPUT
	JMP	LIST		;PRINTER OUTPUT
	JMP	AUXOUT		;AUX. OUTPUT (PUNCH)
	JMP	AUXIN		;AUX. INPUT (READER)
	JMP	HOME		;HOME DRIVE
	JMP	SELDSK		;SELECT DISK DRIVE
	JMP	SETTRK		;SET TRACK
	JMP	SETSEC		;SET SECTOR
	JMP	SETDMA		;SET DMA ADDR
	JMP	READ		;READ SECTOR
	JMP	WRITE		;WRITE SECTOR
	JMP	LISTST		;LIST BUSY TEST
	JMP	SECTRAN		;SECTOR TRANSLATION
	JMP	CONOST		;RETURN CONSOLE OUTPUT STAT
	JMP	AUXIST		;RETURN AUX INPUT STATUS
	JMP	AUXOST		;RETURN AUX OUTPUT STATUS
	JMP	GTDEVTB		;RETURN ADDRESS OF DEVICE DEF TBL
	JMP	NOTIMP		;CONFIGURE DEVICE (NOT IMPLEMENTED)
	JMP	GTDRVTB		;RETURN ADDR OF DRIVE TABLE
	JMP	MULTIO		;SET MULTI-SECTOR COUNT
	JMP	FLUSH		;FLUSH DISK BUFFERS
	JMP	MOVE		;BLOCK MOVE
	JMP	NOTIMP		;GET/SET TIME (NOT IMPLEMENTED)
	JMP	SELMEMB		;BANK SELECT MEMORY
	JMP	SETDMAB		;SET BANK FOR DISK OPERATIONS	
	JMP	XMOVE		;SET SRC & DEST BANKS
;
	JMP	CONFIG		;CONFIGURATION ENTRY PT
	JMP	0		;FUTURE EXP
	JMP	0		;FUTURE EXP
;
; THE PHYSICAL ADDRESSES OF RELOCATABLE VARIABLES IN THE
; SCB (SYSTEM CONTROL BLOCK)
;
	DW	@CNWDTH
	DW	@CNPGLN
	DW	@CIVEC
	DW	@COVEC
	DW	@AIVEC
	DW	@AOVEC
	DW	@LOVEC
	DW	@BNKBF
	DW	@CRDMA
	DW	@CRDSK
	DW	@VINFO
	DW	@RESEL
	DW	@FX
	DW	@USRCD
	DW	@MLTIO
	DW	@ERMDE
	DW	@ERDSK
	DW	@MEDIA
	DW	@BFLGS
	DW	@DATE
	DW	@HOUR
	DW	@MIN
	DW	@SEC
	DW	?ERJMP
	DW	@MXTPA
;
; DATA STORAGE & COMMUNICATIONS AREA
;
CACPU	DB	80H		;CURNTLY ACTIVE CPU (8088, IN PLACE, NOSWAP)
MEMBNK	DB	38H		;MEMORY LATCH VALUE (CONTIGUOUS)
;
FUNCT	DB	0		;FUNTION FOR 8088 PORTION OF XIOS
REGAF	DW	0		;8080 PSW
REGBC	DW	0		;8080 REG B,C
REGDE	DW	0		;8080 REG D,E
REGHL	DW	0		;8080 REG H,L
;
; CP/M PLUS MEMORY TO MEMORY MOVE VARIABLES
;
XMVFLG	DB	0
XMDSTBK	DB	0
XMSRCBK	DB	0
;
; LOGICAL DISK I/O VARIABLES
;
CPMLDSK	DB	0
CPMDSK	DB	0
CPMTRK	DW	0
CPMSECT	DW	0
DMAADR	DW	0
DMASEG	DW	0
;
PIODSK	DB	0
PIOTRK	DW	0
SIDFLG	DB	0
PSPT	DB	0
PSECSIZ	DW	0
PDMADR	DW	0
PDMASEG	DW	0
SHDRTRK	DB	0
PHYCYL	DB	0
;
MCOUNT	DB	1
DDOPCNT	DB	0
;
ERCNT	DB	0
ERRCODE	DB	0
;
LTCHVAL	DB	0
DPHPTR	DW	0
;
; DISK DRIVE TABLE, USED ONLY BY GENCPM TO FIND DPH's AT GENCPM TIME.
;
; NOTE: LOGICAL DEVICES (A: - P:) AT GENCPM TIME DO NOT CORRESPOND TO
; DEVICES AT ACTUAL RUN TIME.  IF MORE THAN TWO OF ANY FLOPPY DISK DRIVE
; TYPE ARE REQUIRED (E.G. FOUR 5" OR 8" FLOPPIES), THE ENTRIES FOR C:,D:
; AND/OR G:,H: MUST BE SET TO THEIR RESPECTIVE DPH's SO THAT GENCPM WILL
; ALLOCATE THE NECESSARY ALLOCATION AND CHECKSUM VECTORS.
;
DRVTBL:	DW	DPH50		;A: - 5" UNIT 0
	DW	DPH51		;B: - 5" UNIT 1
	DW	0		;C: - 5" UNIT 2 (SET TO DPH52 TO USE)
	DW	0		;D: - 5" UNIT 3 (SET TO DPH53 TO USE)
;
	DW	DPH80		;E: - 8" UNIT 0
	DW	DPH81		;F: - 8" UNIT 1
	DW	0		;G: - 8" UNIT 2 (SET TO DPH82 TO USE)
	DW	0		;H: - 8" UNIT 3 (SET TO DPH83 TO USE)
;
	DW	DPHW0		;I: - WINCHESTER PARTITION 0
	DW	DPHW1		;J: - WINCHESTER PARTITION 1
	DW	DPHW2		;K: - WINCHESTER PARTITION 2
	DW	DPHW3		;L: - WINCHESTER PARTITION 3
;
	DW	DPHMD		;M: - MEMORY DISK
	DW	0		;N: - NOT USED EVER
	DW	0		;O: - NOT USED EVER
	DW	0		;P: - NOT USED EVER
;
; DRIVE MAP TABLE
;
; USED TO REASSIGN LOGICAL DRIVE LETTERS (A-P) TO PHYSICAL DRIVES.
;
; ALSO HAS LOGICAL DRIVES (A: TO P:) ASSIGNED TO EACH OF THE FOUR
; WINCHESTER LOGICAL DRIVES.  0,1,2,3 = 5", 4,5,6,7 = 8",
; 8,9,0AH,0BH = FOUR WINCHESTER LOGICAL DRIVES. 7FH = UNASSIGNED.
;
DRVMAP	DB	7FH			;A
	DB	7FH			;B
	DB	7FH			;C
	DB	7FH			;D
	DB	7FH			;E
	DB	7FH			;F
	DB	7FH			;G
	DB	7FH			;H
	DB	7FH			;I
	DB	7FH			;J
	DB	7FH			;K
	DB	7FH			;L
	DB	7FH			;M - MEMORY DISK
	DB	7FH			;N
	DB	7FH			;O
	DB	7FH			;P
;
; WINCHESTER FOUND FLAG - SET TO 0FFH IF A Z-217 IS FOUND
; DURING INITIALIZATION
;
; WINCHESTER LOWER PARTITION BOUND TABLE
; 
; THESE TWO VARIABLES MUST STAY IN THIS SEQUENCE
;
WIFND	DB	0
WLPBTBL	DW	0
	DW	0
	DW	0
	DW	0
;
; HARD DISK CONTROL BLOCK
;
HDCTLBK	DB	0			;OPCODE
	DB	0,0,0			;UNIT SELECT & SECTOR #
	DB	0			;NUMBER OF SECTORS (18 = FULL TRK)
	DB	0,0,0			;DMA ADDR, HIGH BYTE FIRST
	DB	0,0,0			;NEXT CMD ADDR, HI BYTE FIRST
	DB	0			;FLAGS
	DB	0			;ERROR CODE
	DB	0,0,0			;SECTOR WHERE ERROR OCCURED
;
; TRACK TABLE FOR EACH FLOPPY DRIVE
; (TRACK HEAD IS CURRENTLY OVER)
;
TRKTBL	DB	0			;TRACK FOR DRIVE 0 (5" UNIT 0)
	DB	0			;TRACK FOR DRIVE 1 (5" UNIT 1)
	DB	0			;TRACK FOR DRIVE 2 (5" UNIT 2)
	DB	0			;TRACK FOR DRIVE 3 (5" UNIT 3)
	DB	0			;TRACK FOR DRIVE 4 (8" UNIT 0)
	DB	0			;TRACK FOR DRIVE 5 (8" UNIT 1)
	DB	0			;TRACK FOR DRIVE 6 (8" UNIT 2)
	DB	0			;TRACK FOR DRIVE 7 (8" UNIT 3)
;
TKTBPTR	DW	0			;WHICH ENTRY NOW IN 1797
;
SSIZTBL	DW	512			;PHYSICAL SECTOR SIZE FOR DRIVE 0
	DW	512			;PHYSICAL SECTOR SIZE FOR DRIVE 1
	DW	512			;PHYSICAL SECTOR SIZE FOR DRIVE 2
	DW	512			;PHYSICAL SECTOR SIZE FOR DRIVE 3
	DW	128			;PHYSICAL SECTOR SIZE FOR DRIVE 4
	DW	128			;PHYSICAL SECTOR SIZE FOR DRIVE 5
	DW	128			;PHYSICAL SECTOR SIZE FOR DRIVE 6
	DW	128			;PHYSICAL SECTOR SIZE FOR DRIVE 7
;
SPTTBL	DB	8			;PHYSICAL SECT PER TRACK DRIVE 0
	DB	8			;PHYSICAL SECT PER TRACK DRIVE 1
	DB	8			;PHYSICAL SECT PER TRACK DRIVE 2
	DB	8			;PHYSICAL SECT PER TRACK DRIVE 3
	DB	26			;PHYSICAL SECT PER TRACK DRIVE 4
	DB	26			;PHYSICAL SECT PER TRACK DRIVE 5
	DB	26			;PHYSICAL SECT PER TRACK DRIVE 6
	DB	26			;PHYSICAL SECT PER TRACK DRIVE 7
;
; DISK PARAMETER HEADERS
;
; FIRST FOUR HEADERS ARE FOR 5" FLOPPIES, NEXT FOUR ARE FOR 8"
; FLOPPIES, NEXT FOUR ARE FOR FOUR PARTITIONS OF A 
; WINCHESTER DISK.
;
; NOTE: HEATH HAS SHIPPED SEVERAL FORMATS USING THE WRONG
; EXTENT MASK.  FOR COMPATABILITY, BOTH THE RIGHT AND THE
; WRONG VERSIONS OF THE EFFECTED FORMATS ARE SUPPORTED.
;
DPH50	DW	0		;NO TRANSLATE TABLE
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB50		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPH51	DW	0		;NO TRANSLATE TABLE
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB51		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPH52	DW	0		;NO TRANSLATE TABLE
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB52		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPH53	DW	0		;NO TRANSLATE TABLE
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB53		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPH80	DW	0		;XLAT TBL ADDR
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB80		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPH81	DW	0		;XLAT TBL ADDR
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB81		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPH82	DW	0		;XLAT TBL ADDR
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB82		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPH83	DW	0		;XLAT TBL ADDR
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPB83		;DISK PARAMETER BLOCK ADDR
	DW	0FFFEH		;CHECK SUM VECTOR
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPHW0	DW	0		;NO XLAT TBL
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPBW0		;DISK PARAMETER BLOCK ADDR
	DW	0		;CHECKSUM VECTOR (NONE)
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFEH		;DATA BCB LIST HEAD
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPHW1	DW	0		;NO XLAT TBL
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPBW1		;DISK PARAMETER BLOCK ADDR
	DW	0		;CHECKSUM VECTOR (NONE)
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFEH		;DATA BCB LIST HEAD
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPHW2	DW	0		;NO XLAT TBL
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPBW2		;DISK PARAMETER BLOCK ADDR
	DW	0		;CHECKSUM VECTOR (NONE)
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFEH		;DATA BCB LIST HEAD
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPHW3	DW	0		;NO XLAT TBL
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPBW3		;DISK PARAMETER BLOCK ADDR
	DW	0		;CHECKSUM VECTOR (NONE)
	DW	0FFFEH		;ALLOCATION VECTOR
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD
	DW	0FFFEH		;DATA BCB LIST HEAD
	DW	0FFFEH		;HASH TABLE
	DB	0		;HASH BANK
;
DPHMD	DW	0		;NO XLAT TBL
	DW	0		;SCRATCHPAD VALUE
	DW	0
	DW	0
	DW	0
	DB	0
	DB	0		;MEDIA FLAG
	DW	DPBMD		;DISK PARAMETER BLOCK ADDR
	DW	0		;CHECKSUM VECTOR (NONE)
	DW	0FFFEH		;ALLOCATION VECTOR (LET GENCPM ASSIGN)
	DW	0FFFEH		;DIRECTORY BCB LIST HEAD (LET GENCPM ASSIGN)
	DW	0FFFFH		;DATA BCB LIST HEAD (NONE)
	DW	0FFFEH		;HASH TABLE (LET GENCPM ASSIGN)
	DB	0		;HASH BANK
;
; 5" DISK PARAMETER BLOCK FOR 48TPI EXTENDED DENSITY DOUBLE SIDED.
; 5*1024 TRACK FORMAT.  CORRECTED VERSION OF DPB5EDX.
;
DPB50	DW	40		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	394		;395 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	08H		;***EXTENSION DBL DEN, DBL SIDED
;
; 5" DISK PARAMETER BLOCK FOR 48TPI EXTENDED DENSITY DOUBLE SIDED.
; 5*1024 TRACK FORMAT.  CORRECTED VERSION OF DPB5EDX.
;
DPB51	DW	40		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	394		;395 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	08H		;***EXTENSION DBL DEN, DBL SIDED
;
; 5" DISK PARAMETER BLOCK FOR 48TPI EXTENDED DENSITY DOUBLE SIDED.
; 5*1024 TRACK FORMAT.  CORRECTED VERSION OF DPB5EDX.
;
DPB52	DW	40		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	394		;395 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	08H		;***EXTENSION DBL DEN, DBL SIDED
;
; 5" DISK PARAMETER BLOCK FOR 48TPI EXTENDED DENSITY DOUBLE SIDED.
; 5*1024 TRACK FORMAT.  CORRECTED VERSION OF DPB5EDX.
;
DPB53	DW	40		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	394		;395 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	08H		;***EXTENSION DBL DEN, DBL SIDED
;
; DISK PARAMETER BLOCK FOR 8" HUGE DENSITY DOUBLE SIDED
; WITH 9*1024 TRACK FORMAT.  NO SKEW TABLE.
;
DPB80	DW	72		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	683		;684 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	48H		;***EXTENSION DBL DEN, DBL SIDED
;
; DISK PARAMETER BLOCK FOR 8" HUGE DENSITY DOUBLE SIDED
; WITH 9*1024 TRACK FORMAT.  NO SKEW TABLE.
;
DPB81	DW	72		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	683		;684 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	48H		;***EXTENSION DBL DEN, DBL SIDED
;
; DISK PARAMETER BLOCK FOR 8" HUGE DENSITY DOUBLE SIDED
; WITH 9*1024 TRACK FORMAT.  NO SKEW TABLE.
;
DPB82	DW	72		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	683		;684 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	48H		;***EXTENSION DBL DEN, DBL SIDED
;
; DISK PARAMETER BLOCK FOR 8" HUGE DENSITY DOUBLE SIDED
; WITH 9*1024 TRACK FORMAT.  NO SKEW TABLE.
;
DPB83	DW	72		;LOGICAL SECTORS PER TRACK
	DB	4		;2**4 = 16 RCDS (2K) PER ALLOC GRP
	DB	15		;RIGHTMOST FOUR BITS SET
	DB	0		;EXTENT MASK
	DW	683		;684 2K ALOC BLKS PER DISK
	DW	255		;256 DIRECTORY ENTRIES PER DISK
	DW	00F0H		;FOUR 2K DIR BLOCK IN USE
	DW	64		;CHECK ALL 64 DIRECTORY SECTORS
	DW	2		;RESERVE TWO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
	DB	3		;***EXTENSION ACTUAL PHY SHIFT FACTOR
	DB	48H		;***EXTENSION DBL DEN, DBL SIDED
;
; WINCHESTER DPB'S, MAX SIZE (8 MEG) DISK FOR GENSYS
;
DPBW0	DW	72		;LOGICAL SECTORS PER TRACK
	DB	5		;2**5 = 32 RCDS (4K) PER ALOC GRP
	DB	31		;RIGHTMOST FIVE BITS SET
	DB	1		;EXTENT MASK
	DW	2047		;2048 4K ALOC BLKS PER DISK
	DW	1023		;1024 DIRECTORY ENTRIES PER DISK
	DW	00FFH		;EIGHT 4K DIR BLOCK IN USE
	DW	8000H		;DO NOT CHECK DIRECTORY ENTRIES
	DW	1		;RESERVE 1 TRKS FOR SYSTEM
	DB	2		;PHYSICAL SHIFT FACTOR
	DB	3		;PHYSICAL RECORD MASK
;
; DISK PARAMETER BLOCK FOR WINCHESTER'S SECOND PARTITION
;
DPBW1	DW	72		;LOGICAL SECTORS PER TRACK
	DB	5		;2**5 = 32 RCDS (4K) PER ALOC GRP
	DB	31		;RIGHTMOST FIVE BITS SET
	DB	1		;EXTENT MASK
	DW	2047		;2048 4K ALOC BLKS PER DISK
	DW	1023		;1024 DIRECTORY ENTRIES PER DISK
	DW	00FFH		;EIGHT 4K DIR BLOCK IN USE
	DW	8000H		;DO NOT CHECK DIRECTORY ENTRIES
	DW	1		;RESERVE 1 TRKS FOR SYSTEM
	DB	2		;PHYSICAL SHIFT FACTOR
	DB	3		;PHYSICAL RECORD MASK
;
; DISK PARAMETER BLOCK FOR WINCHESTER'S THIRD PARTITION
;
DPBW2	DW	72		;LOGICAL SECTORS PER TRACK
	DB	5		;2**5 = 32 RCDS (4K) PER ALOC GRP
	DB	31		;RIGHTMOST FIVE BITS SET
	DB	1		;EXTENT MASK
	DW	2047		;2048 4K ALOC BLKS PER DISK
	DW	1023		;1024 DIRECTORY ENTRIES PER DISK
	DW	00FFH		;EIGHT 4K DIR BLOCK IN USE
	DW	8000H		;DO NOT CHECK DIRECTORY ENTRIES
	DW	1		;RESERVE 1 TRKS FOR SYSTEM
	DB	2		;PHYSICAL SHIFT FACTOR
	DB	3		;PHYSICAL RECORD MASK
;
; DISK PARAMETER BLOCK FOR WINCHESTER'S FOURTH PARTITION
;
DPBW3	DW	72		;LOGICAL SECTORS PER TRACK
	DB	5		;2**5 = 32 RCDS (4K) PER ALOC GRP
	DB	31		;RIGHTMOST FIVE BITS SET
	DB	1		;EXTENT MASK
	DW	2047		;2048 4K ALOC BLKS PER DISK
	DW	1023		;1024 DIRECTORY ENTRIES PER DISK
	DW	00FFH		;EIGHT 4K DIR BLOCK IN USE
	DW	8000H		;DO NOT CHECK DIRECTORY ENTRIES
	DW	1		;RESERVE 1 TRKS FOR SYSTEM
	DB	2		;PHYSICAL SHIFT FACTOR
	DB	3		;PHYSICAL RECORD MASK
;
; DPB FOR THE M-DISK, MAX SIZE
;
DPBMD	DW	8		;SECTORS PER TRACK (1K)
	DB	4		;BSH, 2**N RECORDS PER ALLOC. GRP (2K)
	DB	15		;RIGHTMOST (BSH) BITS SET
	DB	0		;EXTENT MASK
	DW	319		;UP TO 320 ALOC BLKS PER DISK
	DW	127		;UP TO 128 DIRECTORY ENTRIES PER DISK
	DW	00C0H		;TWO 2K DIR BLKS IN USE
	DW	8000H		;DO NOT CHECK DIRECTORY ENTRIES
	DW	0		;RESERVE NO TRKS FOR SYSTEM
	DB	0		;PHYSICAL SHIFT FACTOR
	DB	0		;PHYSICAL RECORD MASK
;
;******************************************************************
;****         8085 BIOS FUNCTIONS PERFORMED LOCALLY            ****
;****************************************************************** 
;
; SET TRACK
;
SETTRK:	MOV	H,B
	MOV	L,C
	SHLD	CPMTRK
	RET
;
; SET SECTOR
;
SETSEC:	MOV	L,C
	MOV	H,B
	SHLD	CPMSECT
	RET
;
; SET DMA ADDRESS
;
SETDMA:	MOV	H,B
	MOV	L,C
	SHLD	DMAADR
	RET
;
; DO SECTOR TRANSLATION
; 
; NOTE: SECTOR TRANSLATION IS DONE IN THE 16-BIT BIOS
;
SECTRAN:MOV	H,B		;B,C = 0-BASED SECTOR #
	MOV	L,C		;ASSUME NO XLAT
	RET
;
; RETURN DEVICE TABLE ADDR
;
GTDEVTB:LXI	H,0		;NONE HERE
	RET
;
; RETURN DRIVE TABLE ADDR
;
GTDRVTB:LXI	H,DRVTBL
	RET
;
;SET MULTI-SECTOR COUNT
;
MULTIO:	MOV	A,C
	STA	MCOUNT		;FALL THROUGH TO TIME RETURN
;
; NON-IMPLEMENTED BIOS FUNCTIONS
;
NOTIMP:	RET
;
; SELECT MEMORY BANKS
;
SELMEMB:ORA	A		;SEE IF BANK 1
	MVI	A,38H		;ASSUME BANK 1
	JNZ	SELMB1		;WAS BANK 1
	MVI	A,3BH
SELMB1:	STA	MEMBNK
	OUT	MEMCTL
	RET
;
; SET BANK FOR DISK I/O TRANSFERS
;
; THE "DMA BANK" IS ACTUALLY THE 8088 SEGMENT REGISTER VALUE
; FOR THE SELECTED BANK.  THE 8088 DISK ROUTINE FORCES A
; SEGMENT VALUE OF 1000H IF THE DMA ADDRESS IS IN THE COMMON
; AREA (eg >= 0F000H) AND THE DMA SEGMENT IS LESS THAN 2000H.
;
SETDMAB:ORA	A		;SEE IF BANK 1
	LXI	H,1000H		;ASSUME BANK 1
	JNZ	SETDMB1
	MOV	H,A		;A = 0 IF WE EXECUTE THIS INST.
SETDMB1:SHLD	DMASEG
	RET	
;
; SET BANKS FOR AN INTER-BANK "EXTENDED" MOVE
; 
XMOVE:	MVI	A,0FFH
	STA	XMVFLG
	MOV	A,B
	STA	XMDSTBK
	MOV	A,C
	STA	XMSRCBK
	RET
;
;******************************************************************
;****    8088 BIOS FUNCTIONS PERFORMED BY THE 16-BIT BIOS      ****
;****************************************************************** 
;
; ENTER HERE AFTER AN EMULATOR START-UP TO BEGIN THE EMULATION
;
BOOT:
WBOOT:	DI
	LXI	SP,0FFFFH	;PUT STACK AT TOP OF MEMORY
	MVI	A,38H		;BANK 1
	CALL	SELMB1		;SELECT BANK 1 (TPA BANK)
	MVI	A,0C3H		;JUMP INST
	STA	0		;SET UP BIOS WBOOT ENTRY AT 0,1,2
	STA	5		;SET UP BDOS ENTRY AT 5,6,7
	LXI	H,WBE		;WARM BOOT ENTRY TO BIOS
	SHLD	1
	LHLD	@MXTPA		;SET UP WARM BOOT ENTRY AT 0,1,2
	SHLD	6
	XRA	A		;FUNCTION 0, LOAD CCP
	STA	FUNCT
	CALL	FNENTER		;DO IT
	JMP	100H		;THEN JUMP TO CCP
;
CONST:	MVI	A,1
	STA	FUNCT
	JMP	FNENTER
;
CONIN:	MVI	A,2
	STA	FUNCT
	JMP	FNENTER
;
CONOUT:	MVI	A,3
	STA	FUNCT
	JMP	FNENTER
;
LIST:	MVI	A,4
	STA	FUNCT
	JMP	FNENTER
;
AUXOUT:	MVI	A,5
	STA	FUNCT
	JMP	FNENTER
;
AUXIN:	MVI	A,6
	STA	FUNCT
	JMP	FNENTER
;
HOME:	MVI	A,7
	STA	FUNCT
	JMP	FNENTER
;
SELDSK:	MVI	A,8
	STA	FUNCT
	JMP	FNENTER
;
READ:	LDA	DDOPCNT		;GET DUMMY OPERATION COUNT
	DCR	A		;DECR, GOES MINUS IF IT WAS 0
	JM	READ2		;WAS 0, NOT A DUMMY OPERATION
READ1:	STA	DDOPCNT		;JUST DCR DUMMY OPERATION COUNT
	XRA	A		;SHOW GOOD RETURN
	RET			;THEN EXIT
;
READ2:	LDA	MCOUNT		;GET MULTI SECTOR COUNT
	DCR	A		;NUMBER OF SUBSEQUENT DUMMY OPS
	STA	DDOPCNT		;IS ONE LESS THAN ACTUAL COUNT
	MVI	A,9
READ3:	STA	FUNCT
	CALL	FNENTER
	PUSH	PSW		;NOW SET MCOUNT TO 1 FOR NEXT TIME
	MVI	A,1
	STA	MCOUNT
	POP	PSW
	RET
;
WRITE:	LDA	DDOPCNT
	DCR	A
	JP	READ1
	LDA	MCOUNT
	DCR	A
	STA	DDOPCNT
	MVI	A,10
	JMP	READ3
;
LISTST:	MVI	A,11
	STA	FUNCT
	JMP	FNENTER
;
CONOST:	MVI	A,12
	STA	FUNCT
	JMP	FNENTER
;
AUXIST:	MVI	A,13
	STA	FUNCT
	JMP	FNENTER
;
AUXOST:	MVI	A,14
	STA	FUNCT
	JMP	FNENTER
;
FLUSH:	MVI	A,16
	STA	FUNCT
	JMP	FNENTER
;
MOVE:	MVI	A,17
	STA	FUNCT
	JMP	FNENTER
;
CONFIG:	MVI	A,18
	STA	FUNCT
;
; ENTER HERE TO TRANSFER CONTROL TO THE 8088
;
FNENTER:DI			;SHOULD NOT BE ENABLED ANYWAY
	SHLD	REGHL		;SAVE REG H,L
	XCHG			;D,E TO H,L
	SHLD	REGDE
	MOV	H,B
	MOV	L,C
	SHLD	REGBC
	PUSH	PSW
	POP	H
	SHLD	REGAF
	XRA	A		;8085, RESUME IN PLACE, NO SWAP ON INT
	OUT	PSP		;EFFECTIVELY DISABLE INT ON BOTH CPU's
	MVI	A,80H		;8088, RESUME IN PLACE, NO SWAP ON INT
	STA	CACPU		;SHOW 8088 ACTIVE
	OUT	PSP		;SWAP CPU'S
;
; WE GET HERE AFTER THE 8088 RESTORES CONTROL TO THE 8085 TO
; COMPLETE PROCESSING OF FUNCTIONS AND RETURN TO THE APPLICATIONS
; PROGRAM.
;
FNEXIT:	LHLD	REGAF		;GET PSW
	PUSH	H
	POP	PSW
	LHLD	REGBC		;GET B,C
	MOV	B,H
	MOV	C,L
	LHLD	REGDE
	XCHG
	LHLD	REGHL
	ORA	A
	RET
;
	END
