;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Definitions for Z-207 disk controller board
;

;  PORT DISPLACEMENTS

FDCMD	EQU	0		;1797 COMMAND REGISTER
FDSTA	EQU	0		;     STATUS REGISTER
FDTRK	EQU	1		;     TRACK REGISTER
FDSEC	EQU	2		;     SECTOR REGISTER
FDDAT	EQU	3		;     DATA REGISTER
FDCON	EQU	4		;DISK CONTROL PORT
FDAS	EQU	5		;AUX STATUS PORT


;  SOME USEFUL DEFINITIONS

FDHOLES	EQU	2		;NUMBER OF INDEX HOLES FOR DISK TO COME TO SPEED
FDSTEPS	EQU	10		;NUMBER OF STEPS TO STEP IN
FDHULDM EQU	3		;HEAD UNLOAD MULTIPLIER
FD5MOM	EQU	20		;5.25 INCH MOTOR STARTUP MULTIPLIER
FD8NRD	EQU	7FFFH		;8 INCH MOTOR MAX STARTUP TRYS
FDHLDM	EQU	4		;HEAD LOAD MULTIPLIER
FDCOML	EQU	60/4		;TICS BEFORE STATUS CAN BE READ AFTER A COMMAND
FD5IT	EQU	23		;INSIDE TRACK NUMBER ON 48TPI, 5.25 INCH 



;  COMMANDS
FDCRST	EQU	000H		;RESTORE
FDCSEK	EQU	010H		;SEEK
FDCSTP	EQU	020H		;STEP
FDCSTI	EQU	040H		;STEP IN
FDCSTO	EQU	060H		;STEP OUT
FDCRDS	EQU	080H		;READ SECTOR
FDCWRS	EQU	0A0H		;WRITE SECTOR
FDCRDA	EQU	0C0H		;READ ADDRESS
FDCRDT	EQU	0E0H		;READ TRACK
FDCWRT	EQU	0F0H		;WRITE TRACK
FDCFI	EQU	0D0H		;FORCE INTERRUPT

;  TYPE 1 COMMAND FLAGS
FDFUTR	EQU	00010000B	;UPDATE TRACK REGISTER
FDFHLB	EQU	00001000B	;HEAD LOAD AT BEGINNING
FDFVRF	EQU	00000100B	;VERIFY FLAGS

;  TYPE 1 COMMAND STEP RATE FLAGS
FDFS6	EQU	00000000B	;STEP RATE  6 MS
FDFS12	EQU	00000001B	;          12
FDFS20	EQU	00000010B	;          20
FDFS30	EQU	00000011B	;          30

;  TYPE 2&3 COMMAND FLAGS
FDFMRF	EQU	00010000B	;MULTIPLE RECORD FLAG
FDFSLF	EQU	00001000B	;SECTOR LENGTH FLAG
FDFDLF	EQU	00000100B	;30 MS DELAY
FDFSS1	EQU	00000010B	;SELECT SIDE 1
FDFDDM	EQU	00000001B	;DELETED DATA MARK

;  TYPE 4 COMMAND FLAGS
FDFINI	EQU	00000000B	;TERMINATE WITH NO INTERRUPT
FDFII0	EQU	00000001B	;NOT READY TO READY TRANSITION
FDFII1	EQU	00000010B	;READY TO NOT READY TRANSITION
FDFII2	EQU	00000100B	;INDEX PULSE
FDFII3	EQU	00001000B	;IMMEDIATE INTERRUPT

;  STATUS FLAGS
FDSNRD	EQU	10000000B	;NOT READY
FDSWPV	EQU	01000000B	;WRITE PROTECT VIOLATION
FDSHLD	EQU	00100000B	;HEAD IS LOADED
FDSRTE	EQU	00100000B	;RECORD TYPE
FDSWTF	EQU	00100000B	;WRITE FAULT
FDSSEK	EQU	00010000B	;SEEK ERROR
FDSRNF	EQU	00010000B	;RECORD NOT FOUND
FDSCRC	EQU	00001000B	;CRC ERROR
FDSTK0	EQU	00000100B	;FOUND TRACK 0
FDSLDT	EQU	00000100B	;LOST DATA
FDSIND	EQU	00000010B	;INDEX HOLE
FDSBSY	EQU	00000001B	;BUSY

;  INFO RETURNED BY A READ ADDRESS COMMAND
FDRATRK	EQU	0		;TRACK
FDRASID	EQU	1		;SIDE
FDRASEC	EQU	2		;SECTOR
FDRASL	EQU	3		;SECTOR LENGTH
FDRACRC	EQU	4		;2 BYTE CRC
FDRAL	EQU	6		;LENGTH OF READ ADDRESS INFO

;  DISK HEADER SECTOR LENGTH VALUES
FDSL128	EQU	0		;SECTOR LENGTH 128
FDSL256	EQU	1		;SECTOR LENGTH 256
FDSL512	EQU	2		;SECTOR LENGTH 512
FDSL1K	EQU	3		;SECTOR LENGTH 1024

;  CONTROL REGISTER FLAGS
CONDS	EQU	00000011B	;DRIVE SELECT BITS
CONDS8	EQU	00000100B	;0=5 1/4" , 1=8"
CONDSEN	EQU	00001000B	;DRIVE SELECT ENABLE
CONPC	EQU	00010000B	;WRITE PRE-COMPENSATION
				; 5 1/4"  0=YES , 1=NO
				; 8"  0=ALL TRACKS , 1=TRACKS 44-76
CON5FS	EQU	00100000B	;5 1/4" FAST STEP
CONWE	EQU	01000000B	;ENABLE WAIT FOR DRQ OR IRQ
CONSD	EQU	10000000B	;ENABLE SINGLE DENSITY

;  AUXILARY STATUS REGISTER FLAGS
ASIRQ	EQU	00000001B	;1797 INTERRUPT REQUEST
ASMO	EQU	00000010B	;5 1/4" MOTOR ON
AS96T	EQU	00001000B	;5 1/4" DRIVES ARE 96TPI
AS5PC	EQU	00010000B	;5 1/4" DRIVES NEED WRITE PRE-COMPENSATION
AS2S	EQU	01000000B	;SELECTED 8" DRIVE CONTAINS 2 SIDED MEDIA
ASDRQ	EQU	10000000B	;1797 DRQ

