;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

	PAGE	,132
	TITLE	Strategy routine for all interrupts
      
.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFMTR.ASM
	INCLUDE DEFIPAGE.ASM
.LIST

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS,DS:BIOS,SS:BIOS

	PUBLIC	AUX_INT, AUX_STRAT, BUSY, CLOCK_INT, CLOCK_STRAT
	PUBLIC	COM1_INT, COM1_STRAT, COM2_INT, COM2_STRAT, CON_INT
	PUBLIC	CON_STRAT, DISK_INT, DISK_STRAT, ERROR, ERRORC
	PUBLIC	LPT1_INT, LPT1_STRAT, LPT2_INT, LPT2_STRAT, LPT3_INT
	PUBLIC	LPT3_STRAT, PRN_INT, PRN_STRAT, SPECIAL, SUCESS



	EXTRN	PACKET:DWORD
	EXTRN	SS_SAVE:WORD
	EXTRN	SP_SAVE:WORD
	EXTRN	STACK_TOP:WORD
	EXTRN	CON_INIT:NEAR
	EXTRN	CON_INPUT:NEAR
	EXTRN	CON_LOOK:NEAR
	EXTRN	CON_FLUSH:NEAR
	EXTRN	CON_OUTPUT:NEAR
	EXTRN	COM_INPUT:NEAR
	EXTRN	COM_LOOK:NEAR
	EXTRN	COM_IN_STAT:NEAR
	EXTRN	COM_FLUSH:NEAR
	EXTRN	COM_OUTPUT:NEAR
	EXTRN	COM_OUT_STAT:NEAR
	EXTRN	LPT_INPUT:NEAR
	EXTRN	LPT_LOOK:NEAR
	EXTRN	LPT_IN_STAT:NEAR
	EXTRN	LPT_FLUSH:NEAR
	EXTRN	LPT_OUTPUT:NEAR
	EXTRN	LPT_OUT_STAT:NEAR
	EXTRN	LPT_OUTPUT:NEAR
	EXTRN	CLOCK_READ:NEAR
	EXTRN	CLOCK_WRITE:NEAR
	EXTRN	DISK_INIT:NEAR
	EXTRN	MEDIA_CHECK:NEAR
	EXTRN	BUILD_BPB:NEAR
	EXTRN	DISK_READ:NEAR
	EXTRN	DISK_WRITE:NEAR
	EXTRN	DISK_WRITE_VERIFY:NEAR
	EXTRN	RECURLV:WORD



;**	STRATEGY - This routine will save the packet passed by the DOS.
;		This information will later be used by the appropriate 
;		interrupt routine.
;
STRATEGY PROC FAR

CON_STRAT:
AUX_STRAT:
PRN_STRAT:
CLOCK_STRAT:
DISK_STRAT:
LPT1_STRAT:
LPT2_STRAT:
LPT3_STRAT:
COM1_STRAT:
COM2_STRAT:
	MOV	WORD PTR CS:PACKET,BX
	MOV	WORD PTR CS:PACKET+2,ES
	RET
STRATEGY ENDP


	SUBTTL	Interrput routines
	PAGE
;**	CON_INT - This routine passes the address of a jump
;		table to the common interrupt routine
;
CON_INT LABEL	FAR
	PUSH	SI
	MOV	SI,OFFSET CON_TABLE
	JMP	SHORT COMMON_INT

;**	AUX_INT - This routine passes the address of a jump
;		table and a device number to the common interrupt routine
;
AUX_INT:
COM1_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET COM_TABLE
	MOV	DX,0
	JMP	SHORT COMMON_INT1

COM2_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET COM_TABLE
	MOV	DX,1
	JMP	SHORT COMMON_INT1


;**	These routines pass the address of a jump
;	table and a printer index to the common interrupt routine
;
PRN_INT:
LPT1_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET LPT_TABLE
	MOV	DX,0
	JMP	SHORT COMMON_INT1

LPT2_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET LPT_TABLE
	MOV	DX,1
	JMP	SHORT COMMON_INT1

LPT3_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET LPT_TABLE
	MOV	DX,2
	JMP	SHORT COMMON_INT1

;**	CLOCK_INT - This routine passes the address of a jump
;		table to the common interrupt routine
;
CLOCK_INT LABEL	FAR
	PUSH	SI
	MOV	SI,OFFSET CLOCK_TABLE
	JMP	SHORT COMMON_INT

;**	DISK_INT - This routine passes the address of a jump
;		table to the common interrupt routine
;
DISK_INT LABEL	FAR
	PUSH	SI
	MOV	SI,OFFSET DISK_TABLE
	JMP	SHORT COMMON_INT

	SUBTTL	Common interrupt routine
	PAGE
;*	COMMON_INT:	This is a common entry point for
;	interrupt procedures. It will save all registers,
;	dispatch the function and upon return restore registers
;	and return to the caller.
;
;	ENTRY:	SI - Address table of routines
;		DX - Device index for printers and communications
;		     (entry at COMMON_INT1 only).
;
;	EXIT:	None
;
COMMON_INT:
	PUSH	DX			; Save all registers

COMMON_INT1:
	CLI
	INC	WORD PTR CS:RECURLV	; Bump recursion
	JNZ	COMINT1A		; If nested call
	MOV	CS:SP_SAVE,SP		; Save DOS Stack
	MOV	CS:SS_SAVE,SS
	PUSH	CS
	POP	SS			; Set up local stack
	MOV	SP,OFFSET STACK_TOP
COMINT1A:
	STI

	PUSHF
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS

	PUSH	CS			; Set up addressing
	POP	DS
	LES	BX,PACKET		; Get address of packet

	MOV	CL,ES:SRH_CMD[BX]	; Get the command index
	SUB	CH,CH
	SHL	CX,1			; Make into a word offset
	ADD	SI,CX			; Index into address table
	JMP	[SI]			; Dispatch routine

COMMON_EXIT:
	LES	BX,CS:PACKET		; Get address of packet back
	OR	AH,SRHS_DON
	MOV	WORD PTR ES:SRH_STAT[BX],AX	; Return status
	POP	DS			; Restore all registers
	POP	ES
	POP	BP
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	POPF
	MOV	DX,CS:SS_SAVE

	CLI
	DEC	WORD PTR CS:RECURLV	; Leaving last level?
	JNS	COMEXT1			; No, leave stack
	MOV	SS,SS_SAVE
	MOV	SP,SP_SAVE		; Restore DOS stack
COMEXT1:
	STI

	POP	DX
	POP	SI			; Pushed by the initial interrupt routine

	RETF

	SUBTTL	Address tables for driver routines
	PAGE

;	Subroutine table for the "CON" driver.

CON_TABLE LABEL	WORD
	DW	OFFSET CON_INIT		; Init
	DW	OFFSET NO_OP		; Media check
	DW	OFFSET NO_OP		; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET CON_INPUT	; Console input
	DW	OFFSET CON_LOOK		; Console look-ahead
	DW	OFFSET NO_OP		; Console status
	DW	OFFSET CON_FLUSH	; Console flush
	DW	OFFSET CON_OUTPUT	; Console output
	DW	OFFSET CON_OUTPUT	; Console output and verify
	DW	OFFSET NO_OP		; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET UNKNOWN		; IOCTL OUTPUT

;	Subroutine table for the "AUX", "COM1", and "COM2" drivers.

COM_TABLE LABEL	WORD
	DW	OFFSET NO_OP		; Init
	DW	OFFSET NO_OP		; Media check
	DW	OFFSET NO_OP		; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET COM_INPUT	; input
	DW	OFFSET COM_LOOK		; look-ahead
	DW	OFFSET COM_IN_STAT	; Input status
	DW	OFFSET COM_FLUSH	; flush
	DW	OFFSET COM_OUTPUT	; output
	DW	OFFSET COM_OUTPUT	; output and verify
	DW	OFFSET COM_OUT_STAT	; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET UNKNOWN		; IOCTL OUTPUT

;	Subroutine table for the "PRN", "LPT1", "LPT2", and "LPT3" drivers.

LPT_TABLE LABEL	WORD
	DW	OFFSET NO_OP		; Init
	DW	OFFSET NO_OP		; Media check
	DW	OFFSET NO_OP		; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET LPT_INPUT	; input
	DW	OFFSET LPT_LOOK		; look-ahead
	DW	OFFSET LPT_IN_STAT	; status
	DW	OFFSET LPT_FLUSH	; flush
	DW	OFFSET LPT_OUTPUT	; output
	DW	OFFSET LPT_OUTPUT	; output and verify
	DW	OFFSET LPT_OUT_STAT	; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET NO_OP		; IOCTL OUTPUT

;	Subroutine table for the CLOCK$ driver

CLOCK_TABLE LABEL WORD
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET UNKNOWN
	DW	OFFSET CLOCK_READ
	DW	OFFSET BUSY
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET CLOCK_WRITE
	DW	OFFSET CLOCK_WRITE
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET UNKNOWN

;	Subroutine table for the disk driver 

DISK_TABLE LABEL WORD
	DW	OFFSET DISK_INIT	; Init
	DW	OFFSET MEDIA_CHECK	; Media check
	DW	OFFSET BUILD_BPB	; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET DISK_READ	; Disk read
	DW	OFFSET BUSY		; Non destructive read
	DW	OFFSET NO_OP		; Status
	DW	OFFSET NO_OP		; Flush
	DW	OFFSET DISK_WRITE	; Write
	DW	OFFSET DISK_WRITE_VERIFY ; Write and verify
	DW	OFFSET NO_OP		; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET UNKNOWN		; IOCTL OUTPUT

	SUBTTL	Commonly used exits for driver routines
	PAGE

;	Sucessful operation, clear all flags
SUCESS	PROC	NEAR

	SUB	AH,AH
	JMP	COMMON_EXIT

SUCESS	ENDP

;**	Set the busy status flag to show input queue empty
BUSY	PROC NEAR

	MOV	AH,SRHS_BUI
	JMP	COMMON_EXIT

BUSY	ENDP

;	Unknown command requested
UNKNOWN:
	MOV	AL,SRHS_EUKC		; Unknown command code
	JMP	SHORT ERROR		; Flag error

;	Correct the transfer count and flag error, used only for
;	 R/W packets with CX=Number of blocks/chars left untransferred 
ERRORC:
	LES	BX,CS:PACKET
	SUB	ES:CRW_CNT[BX],CX

;	Flag error
ERROR:
	MOV	AH,SRHS_ERR			; Flag error

;	No operation
NO_OP:
	JMP	COMMON_EXIT
	

	SUBTTL	Console routines
	PAGE

;**	SPECIAL - This routine is the special console output routine.
;		It is accessed by INT 29H

SPECIAL	PROC	FAR
	PUSH	AX			; Save reg
	SUB	AH,AH			; Prepare for user int
	INT	INT_UCRTA		; Let user see char
	OR	AH,AH			; Did user take it?
	JNZ	SPEC1			; Skip if so
	STI
	CALL	MTR_SCRT
SPEC1:
	POP	AX			; Restore reg
	IRET
SPECIAL ENDP

BIOS	ENDS
	END
